<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'nl', branch 'MOODLE_28_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Eerste mededeling';
$string['alert2'] = 'Tweede mededeling';
$string['alert3'] = 'Derde mededeling';
$string['alert_general'] = 'Aankondiging';
$string['alert_info'] = 'Informatief';
$string['alertinfodesc'] = 'Stel hier de instellingen voor je meldingen in.';
$string['alertsdesc'] = 'Deze optie maakt het mogelijk om drie notificaties op de voorpagina te tonen. Vergeet ze niet uit te zetten als ze niet meer nodig zijn!';
$string['alertsheading'] = 'Notificaties';
$string['alertsheadingsub'] = 'Toon belangrijke notificaties op de voorpagina.';
$string['alerttext'] = 'Notificatie tekst';
$string['alerttextdesc'] = 'Voer hier de notificatie tekst in.';
$string['alerttitle'] = 'Titel';
$string['alerttitledesc'] = 'Voer hier de titel van je notificatie in.';
$string['alerttype'] = 'Type';
$string['alerttypedesc'] = 'Stel hier het type notificatie in.';
$string['alert_warning'] = 'Waarschuwing';
$string['allclasses'] = 'Alle klassen';
$string['allcourses'] = 'Alle cursussen';
$string['allmodules'] = 'Alle modules';
$string['allunits'] = 'Alle lessen';
$string['alternativecolors'] = 'Alternatieve kleurschema {$a}';
$string['alternativethemecolor'] = 'Alternatieve themakleur {$a}';
$string['alternativethemecolordesc'] = 'Welke kleur moet het thema in alternatief kleurschema {$a} zijn?';
$string['alternativethemecolorname'] = 'Naam van alternatief kleurschema {$a}';
$string['alternativethemecolornamedesc'] = 'Geef een herkenbare naam op voor dit alternatieve kleurschema.';
$string['alternativethemecolors'] = 'Alternatieve themakleur {$a}';
$string['alternativethemecolorsdesc'] = 'Definieer de alternatieve kleurschema\'s.';
$string['alternativethemehovercolor'] = 'Alternative Theme Hover Colour {$a}';
$string['alternativethemehovercolordesc'] = 'Welke kleur moet er gebruikt worden voor hovers in alternatief kleurschema {$a}?';
$string['alternativethemeiconcolor'] = 'Alternatieve icoon kleur {$a}.';
$string['alternativethemeiconcolordesc'] = 'Kies hier de alternatieve {$a} kleur voor alle iconen.';
$string['alternativethemename'] = 'Naam voor kleurschema {$a}';
$string['alternativethemenamedesc'] = 'Voer hier de naam van alternatief kleurschema {$a} in.';
$string['alternativethemenavcolor'] = 'Navigatie tekst kleur {$a}.';
$string['alternativethemenavcolordesc'] = 'Kies hier de alternatieve {$a} tekst kleur voor de navigatie. Het gaat om de navigatie balk en het stijlvolle kruimelpad.';
$string['alternativethemetextcolor'] = 'Alternatieve tekst kleuren {$a}';
$string['alternativethemetextcolordesc'] = 'Stel de kleur in voor je alternatieve tekst {$a}';
$string['alternativethemeurlcolor'] = 'Alternatieve link kleur {$a}';
$string['alternativethemeurlcolordesc'] = 'Stel hier de kleur voor je alternatieve link tekst in {$a}';
$string['alwaysdisplay'] = 'Altijd tonen';
$string['analytics'] = 'Analytics';
$string['analyticscleanurl'] = '"schone" URL\'s';
$string['analyticscleanurldesc'] = 'Genereer een "schone" URL voor geavanceerde tracking.';
$string['analyticsdesc'] = 'Stel hier Google Analytics in voor je Moodle omgeving. Om Analytics te kunnen gebruiken moet je gratis een account aanmaken voor Google Analytics op: <a href="http://analytics.google.com" target="_blank">http://analytics.google.com</a>';
$string['analyticsenabled'] = 'Aanzetten';
$string['analyticsenableddesc'] = 'Zet Analytics voor Moodle aan';
$string['analyticsheadingsub'] = 'Krachtige site analytics mogelijk gemaakt door Google Analytics.';
$string['analyticsimagetrack'] = 'Afbeeldingen tracken';
$string['analyticsimagetrackdesc'] = 'Stel hier de afbeelding tracking voor browsers waar JavaScript uitstaat in.';
$string['analyticssiteiddesc'] = 'Vul je Site ID in';
$string['analyticssiteurldesc'] = 'Vul je "Piwiki Analytics" URL in zonder http(s) of een schuine streep. Bijvoorbeeld "mysite.com/analytics".';
$string['analyticstrackadmin'] = 'Opvolgen beheerders';
$string['analyticstrackadmindesc'] = 'Zet het opvolgen van gebruikers met beheerrechten aan (wordt niet geadviseerd)';
$string['analyticstrackingiddesc'] = 'Voer je Tracking ID in';
$string['android'] = 'Android (Google Play)';
$string['backgroundstylefixed'] = 'Vast';
$string['backgroundstylestretch'] = 'Uitgerekt';
$string['backgroundstyletiled'] = 'Gedraaid';
$string['backtotop'] = 'Naar boven';
$string['badgepreferences'] = 'Badges voorkeuren';
$string['blogpreferences'] = 'Blog voorkeuren';
$string['breadcrumbsimple'] = 'Simpel';
$string['breadcrumbstyle'] = 'Kruimelpad stijl';
$string['breadcrumbstyled'] = 'Stijlvol';
$string['breadcrumbstyledesc'] = 'Stel hier in hoe je het kruimelpad getoond wilt hebben.';
$string['breadcrumbstylednocollapse'] = 'Stijlvol zonder invouwen';
$string['breadcrumbthin'] = 'Dun';
$string['categoryiconcategory'] = 'Het icoon voor de categorie: {$a->category}.';
$string['categoryicondesc'] = 'Indien ingeschakeld kun je hier iconen voor iedere categorie instellen.';
$string['categoryiconheading'] = 'Categorie Iconen';
$string['categoryiconheadingsub'] = '';
$string['categoryiconinfo'] = 'Aangepaste categorie iconen';
$string['categoryiconinfodesc'] = 'Stel hier per categorie een icoon in. De mogelijke opties vind je <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>, voer het gedeelte na "fa-" in.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class=img-polaroid src="essential/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Over Essential</h3>
<p>Essential is een aangepast Moodle bootstrap thema dat stylen en renderers van haar moeder themas erft.</p>
<h3>Afhankelijkheden</h3>
<p>Dit thema is gebaseerd op het Bootstrap thema ontwikkeld door:<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts en Mary Evans.</p>
<h3>Thema Credits</h3>
<p>Origineel Auteur: Julian Ridden<br>
Werk in Juli 2014 overgenomen door:<br>
Gareth J. Barnard<br>
David Bezemer<br>
</p>
</div></div>';
$string['colordesc'] = 'Hieronder staan de verschillende instellingen om veel van de gebruikte kleuren in dit thema aan te passen.';
$string['colorheading'] = 'Kleurinstellingen';
$string['colorheadingsub'] = 'Kies hier de kleuren die je in je thema wil gebruiken.';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Contact informatie';
$string['contactinfodesc'] = 'Voer hier je contact informatie in.';
$string['copyright'] = 'Copyright';
$string['copyrightdesc'] = 'Naam van je organisatie om als copyright houder te tonen.';
$string['coursegrades'] = 'Cursus cijfers';
$string['courselistteachericon'] = 'Cursuslijst: docenten icoon';
$string['credit'] = 'Essential thema is ontwikkeld, verbeterd en bijgehouden door';
$string['customcss'] = 'Aanvullende CSS';
$string['customcssdesc'] = 'Als er aanvullende CSS vereist is kan dit in het onderstaande tekstvak worden ingevoerd, en zal automatisch op iedere pagina ingevoegd worden.';
$string['defaultcategoryicon'] = 'Standaard categorie icoon';
$string['defaultcategoryicondesc'] = 'Stel hier een standaard categorie icoon in.';
$string['defaultcolors'] = 'Standaardkleuren';
$string['displayafterlogin'] = 'Alleen na inloggen tonen';
$string['displaybeforelogin'] = 'Alleen voor inloggen tonen';
$string['displaymycourses'] = 'Toon ingeschreven cursussen';
$string['displaymycoursesdesc'] = 'Toon ingeschreven cursussen in het aangepaste menu.';
$string['dontdisplay'] = 'Nooit tonen';
$string['enablealert'] = 'Notificatie  inschakelen';
$string['enablealertdesc'] = 'Kies hier of je notificaties wil inschakelen.';
$string['enablealternativethemecolors'] = 'Schakel alternatief kleurschema {$a} in';
$string['enablealternativethemecolorsdesc'] = 'Indien ingeschakeld krijgen gebruikers de keuze om alternatief kleurschema {$a}te kiezen.';
$string['facebook'] = '';
$string['facebookdesc'] = 'Link naar je Facebook pagina. (bvb. https://www.facebook.com/mijnorganisatie)';
$string['facebookurl'] = 'Facebook URL';
$string['few'] = 'Een aantal';
$string['fitvids'] = 'Gebruik FitVids';
$string['fixedwidthnarrow'] = 'Vaste breedte - smal';
$string['fixedwidthnormal'] = 'Vaste breedte - Normaal';
$string['fixedwidthwide'] = 'Vaste breedte - breed';
$string['flattr_click'] = 'Doneer via Flattr';
$string['flickr'] = 'Flickr URL';
$string['flickrdesc'] = 'Link naar je Flickr pagina. (bvb. https://www.flickr.com/photos/mijnorganisatie)';
$string['flickrurl'] = 'Flickr URL';
$string['fontselect'] = 'Font kiezer';
$string['fontselectdesc'] = 'Kies hier uit de lijst met beschikbare fonts.';
$string['footercolor'] = 'Voetnoot achtergrondkleur';
$string['footercolordesc'] = 'Stel hier de kleur in voor de achtergrond van de voetnoot regio.';
$string['footercolors'] = 'Voetnoot kleuren';
$string['footercolorsdesc'] = 'Verander de kleuren van de voetnoot';
$string['footerheadingcolor'] = 'Voetnoot titelkleur';
$string['footerheadingcolordesc'] = 'Stel hier de kleur in van de titel van de voetnoot.';
$string['footerhovercolor'] = 'Voetnoot link hover kleur';
$string['footerhovercolordesc'] = 'Stel hier de kleur in voor de links in de voetnoot als je er met de muis op zweeft.';
$string['footersepcolor'] = 'Voetnoot scheidingskleur';
$string['footersepcolordesc'] = 'Hier kun je de kleur van de scheidingslijnen instellen.';
$string['footertextcolor'] = 'Voetnoot tekstkleur';
$string['footertextcolordesc'] = 'Stel hier de kleur in van de tekst in de voetnoot.';
$string['footerurlcolor'] = 'Voetnoot link kleur';
$string['footerurlcolordesc'] = 'Stel hier de kleur van de links in de voetnoot in.';
$string['footnote'] = 'Voetnoot';
$string['footnotedesc'] = 'Tekst welke in dit veld wordt ingevoegd zal op iedere pagina in de voetnoot worden weergegeven.';
$string['frontcontentarea'] = 'Voorpagina content';
$string['frontcontentareadesc'] = 'De inhoud van dit blik wordt over de gehele breedte van de pagina tussen de slidehsow en marketing blokken weergegeven.';
$string['frontcontentdesc'] = 'Dit voegt een speciaal blok in tussen de slideshow en de marketing blokken waar je eigen content kan plaatsen.';
$string['frontcontentheading'] = 'Voorpagina instellingen';
$string['frontpageblocks'] = 'Uitlijning van voorpagina blokken';
$string['frontpageblocksdesc'] = 'Hier kun je de uitlijning van de blokken op de voorpagina kiezen.';
$string['frontpagemiddleblocks'] = 'Voorpagina midden blokken inschakelen';
$string['frontpagemiddleblocksdesc'] = 'Indien ingeschakeld worden er drie blokken weergegeven onder de marketing blokken.';
$string['genericsettings'] = 'Algemene Instellingen';
$string['googleplus'] = 'Google+ URL';
$string['googleplusdesc'] = 'Link naar je Google+ profiel. (bvb. https://plus.google.com/+mijnorganisatie)';
$string['headerbackground'] = 'Header achtergrond afbeelding';
$string['headerbackgrounddesc'] = 'Upload hier je eigen achtergrond afbeelding';
$string['headertextcolor'] = 'Header tekst kleur';
$string['headertextcolordesc'] = 'Kies hier de tekst kleur voor de header';
$string['headertitle'] = 'Header titel';
$string['headertitledesc'] = 'Configureer hier de titel die getoond moet worden in de header. Noot: De header titel wordt alleen gebruikt als er geen logo is.';
$string['helplinktype'] = 'Zet help link in het menu aan';
$string['helplinktypedesc'] = 'Kies hier of je een help mogelijkheid wilt tonen in het gebruikersmenu. Je kunt kiezen uit een link dat geopend wordt in een nieuwe scherm of een e-mailadres.';
$string['hideonphone'] = 'Verberg slideshow op telefoons';
$string['hideonphonedesc'] = 'Kies hier of je de slideshow wil uitschakelen op telefoons.';
$string['hideontablet'] = 'Verberg slide shows op tablets';
$string['hideontabletdesc'] = 'Kies hier als je de slide show niet op tablets wil laten tonen';
$string['included'] = 'Inclusief bestanden';
$string['instagram'] = 'Instagram URL';
$string['instagramdesc'] = 'Link naar je Instagram feed. (bvb. http://instagram.com/mijnorganisatie)';
$string['ios'] = 'iPhone/iPad (Apple App Store)';
$string['iosdesc'] = '';
$string['iosicon'] = 'iOS thuisscherm iconen';
$string['iosicondesc'] = 'In dit thema zijn iconen in te stellen die getoond worden op het iOS thuisscherm als je een bladwijzer maakt voor de Moodle omgeving.';
$string['ipadicon'] = 'iPad icoon (Zonder Retina)';
$string['ipadicondesc'] = 'Dit icoon moet een 72px x 72px PNG icoon zijn.';
$string['ipadretinaicon'] = 'iPad icoon (Retina)';
$string['ipadretinaicondesc'] = 'Dit icoon moet een 144px x 144px PNG icoon zijn.';
$string['iphoneicon'] = 'iPhone/iPod Touch icoon (Zonder Retina)';
$string['iphoneicondesc'] = 'Dit icoon moet een 57px x 57px PNG zijn.';
$string['iphoneretinaicon'] = 'iPhone/iPod Touch icoon (Retina)';
$string['iphoneretinaicondesc'] = 'Dit icoon moet een 114px x 114px PNG zijn.';
$string['layout'] = 'Gebruik standaard cursus layout';
$string['layoutdesc'] = '';
$string['left'] = 'Links';
$string['linkedin'] = 'LinkedIn URL';
$string['linkedindesc'] = 'Link naar je LinkedIn profiel. (bvb. https://www.linkedin.com/company/mijnorganisatie)';
$string['loadtime'] = 'Laad tijd';
$string['loggedinas'] = 'Inloggen als';
$string['loggedinfrom'] = 'Ingelogd vanaf';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Upload hier je eigen logo. Indien je een logo upload vervangt dit automatisch het standaard logo en het gekozen icoon.';
$string['marketing1'] = 'Marketing blok 1';
$string['marketing2'] = 'Marketing blok 2';
$string['marketing3'] = 'Marketing blok 3';
$string['marketingbuttontext'] = 'Link tekst';
$string['marketingbuttontextdesc'] = 'Tekst om te tonen op de link button.';
$string['marketingbuttonurl'] = 'Link URL';
$string['marketingbuttonurldesc'] = 'URL the button will point to.';
$string['marketingcontent'] = 'Inhoud';
$string['marketingcontentdesc'] = 'Stel hier de inhoud van het marketing blok in. Maak het kort maar krachtig.';
$string['marketingdesc'] = 'Dit thema bevat de optie om drie marketing blokken te tonen onder de slideshow. Dit geeft je de mogelijkheid om direct informatie te tonen aan gebruikers, ook zonder dat deze ingelogd zijn. Dit is handig voor als je specifieke cursussen wil uitlichten.';
$string['marketingheading'] = 'Marketing blokken';
$string['marketingheadingsub'] = 'De marketing blokken zijn drie blokken op de voorpagina waarin informatie en links getoond worden.';
$string['marketingheight'] = 'Hoogte van de marketing afbeeldingen';
$string['marketingheightdesc'] = 'Als je afbeeldingen wil tonen in de marketing blokken kun je hier de hoogte instellen.';
$string['marketingicon'] = 'Icoon';
$string['marketingicondesc'] = 'Naam van het iccon dat je wil gebruiken. Kies uit de lijst <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voor de naam in achter "fa-", bijvoorbeeld "star".';
$string['marketingimage'] = 'Afbeelding';
$string['marketingimagedesc'] = 'Stel hier een afbeelding in om boven de tekst in dit marketing blok te tonen.';
$string['marketinginfodesc'] = 'Configureer hier de marketing blokken.';
$string['marketingtitle'] = 'Titel';
$string['marketingtitledesc'] = 'Marketing blok titel.';
$string['marketingurltarget'] = 'Link doel';
$string['marketingurltargetdesc'] = 'Voer hier in hoe de link geopend moet worden';
$string['marketingurltargetnew'] = 'Open in nieuwe pagina';
$string['marketingurltargetparent'] = 'Open in hoofdframe';
$string['marketingurltargetself'] = 'Open in huidige pagina';
$string['memused'] = 'Geheugen gebruik';
$string['messagepreferences'] = 'Berichten voorkeur';
$string['mobileappsdesc'] = 'Heb je een app in de App Store of Play Store? Voer hier de links in zodat je apps eenvoudig gevonden kunenn worden.';
$string['mobileappsheading'] = 'Mobiele applicaties';
$string['mobileappsheadingsub'] = 'Link naar je apps om te stimuleren dat gebruikers mobiele apparaten gebruiken.';
$string['myclasses'] = 'Mijn klassen';
$string['mycourses'] = 'Mijn cursussen';
$string['mycoursesinfo'] = 'Automatische cursus lijst';
$string['mycoursesinfodesc'] = 'Toont een lijst met alle cursussen waar een gebruiker in ingeschreven is.';
$string['mycoursetitle'] = 'Naamgeving';
$string['mycoursetitledesc'] = 'Verander de naamgeving voor het "Mijn cursussen" menu hieronder.';
$string['mygrades'] = 'Mijn cijfers';
$string['mymodules'] = 'Mijn modules';
$string['myunits'] = 'Mijn lessen';
$string['navbartitle'] = 'Navigatiebalk titel';
$string['navbartitledesc'] = 'Configureer hier de titel die op de navigatiebalk getoond wordt.';
$string['nextsection'] = 'Volgende sectie';
$string['nobreadcrumb'] = 'Verbergen';
$string['noenrolments'] = 'Geen cursusinschrijving bekend';
$string['nomessagesfound'] = 'Geen berichten gevonden';
$string['noslidetitle'] = 'Geen titel voor de slide {$a->slide}';
$string['notitle'] = 'Geen titel';
$string['numberofslides'] = 'Aantal slides';
$string['numberofslides_desc'] = 'Aantal slides op de slider';
$string['oldnavbar'] = 'Gebruik oude navigatie balk positie';
$string['oldnavbardesc'] = 'Indien ingeschakeld wordt de navigatie balk op de oude positie getoond.';
$string['pagebackground'] = 'Pagina achtergrondafbeelding';
$string['pagebackgrounddesc'] = 'Upload hier je achtergrond afbeelding. Deze achtergrond afbeelding zal op alle pagina\'s getoond worden. Als je geen afbeelding upload wordt hier een vaste kleur voor gebruikt.';
$string['pagebackgroundstyle'] = 'Pagina achtergrond stijl';
$string['pagebackgroundstyledesc'] = 'Selecteer de stijl voor de geuploaden afbeelding';
$string['pagewidth'] = 'Kies pagina breedte';
$string['pagewidthdesc'] = 'Kies uit de lijst met beschikbare breedtes om de site breedte in te stellen.';
$string['paypal_click'] = 'Moodle profiel';
$string['people'] = 'Mensen';
$string['perfinfo'] = 'Performance informatie';
$string['perfinfodesc'] = '';
$string['perf_max'] = 'Gedetailleerd';
$string['perf_min'] = 'Minimaal';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'Link naar je Pinterest prikbord. (bvb. http://www.pinterest.com/mijnorganisatie/mijnprikbord)';
$string['pinteresturl'] = 'Pinterest URL';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Vorige sectie';
$string['profilebarcustomtitle'] = 'Aangepaste profielbalk titel';
$string['profilebarcustomtitledesc'] = 'Voer hier indien gewenst een aangepaste title in voor de profielbalk.';
$string['readme_click'] = 'klik hier voor README.txt';
$string['readme_desc'] = 'Voor meer informatie over het Essentali thema: {$a->url}';
$string['readme_title'] = 'Essential lees-mij';
$string['readmore'] = 'Lees verder';
$string['region-footer-left'] = 'Voetnoot (links)';
$string['region-footer-middle'] = 'Voetnoot (midden)';
$string['region-footer-right'] = 'Voetnoot (rechts)';
$string['region-hidden-dock'] = 'Verborgen';
$string['region-home-left'] = 'Home (links)';
$string['region-home-middle'] = 'Home (midden)';
$string['region-home-right'] = 'Home (rechts)';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['right'] = 'Rechts';
$string['serverload'] = 'Server capaciteit';
$string['shortname'] = 'Site korte naam';
$string['shortnamesummary'] = 'Korte naam en samenvatting';
$string['siteicon'] = 'Site afbeelding';
$string['siteicondesc'] = 'Als je geen logo hebt kun je hier een icoon invullen om op de plaats van het logo te tonen. De volledige lijst staat op <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voer het gedeelte achter "fa-" hier in.';
$string['skype'] = 'Skype Account';
$string['skypedesc'] = 'Skype gebruikersnaam van je organisatie. (bvb. mijn.organisatie)';
$string['slidebuttoncolor'] = 'Slide buttonkleur';
$string['slidebuttoncolordesc'] = 'Kies hier de kleur voor de navigatie knoppen.';
$string['slidebuttonhovercolor'] = 'Slide knop "hover" kleur';
$string['slidecaption'] = 'Slide tekst';
$string['slidecaptiondesc'] = 'Voer hier de tekst in die op de slide getoond zal worden.';
$string['slidecolor'] = 'Slide tekstkleur';
$string['slidecolordesc'] = 'Kies hier de kleur van de hoofdtekst op de slide.';
$string['slideimage'] = 'Slide afbeelding';
$string['slideimagedesc'] = 'Gebruik hier een transparante png (formaat is 256px x 256px voor de kleine afbeelding, en 300px x 1200px voor de achtergrond afbeelding)';
$string['slideintervaldesc'] = 'Dia transitie-interval in milliseconden.';
$string['slideno'] = 'Dia {$a->slide}';
$string['slidenodesc'] = 'Vul de instellingen in voor dia {$a->slide}';
$string['slideshowdesc'] = 'Indien ingeschakeld wordt er een dynamische slideshow met maximaal 4 slides getoond om belangrijke informatie aantrekkelijk weer te geven.';
$string['slideshowheading'] = 'Voorpagina slideshow';
$string['slideshowheadingsub'] = 'Een dynamische slideshow voor de voorpagina';
$string['slidetitle'] = 'Slide titel';
$string['slidetitledesc'] = 'Voer een titel in voor je slide.';
$string['slideurl'] = 'Slide link';
$string['slideurldesc'] = 'Voer hier in waar de link achter "Verder lezen" naar moet verwijzen.';
$string['slideurltarget'] = 'Link doel';
$string['slideurltargetdesc'] = 'Voer hier in hoe de link geopend moet worden';
$string['slideurltargetnew'] = 'Open in nieuwe pagina';
$string['slideurltargetparent'] = 'Open in hoofdframe';
$string['slideurltargetself'] = 'Open in huidige pagina';
$string['socialdesc'] = 'Geef hier directe links naar de locaties op sociale netwerken waar jouw merk of organisatie voorkomt. Deze links worden overal in de koptekst van de pagina getoond.';
$string['socialheading'] = 'Sociale netwerk sites';
$string['socialheadingsub'] = 'Bind je gebruikers door gebruik te maken van sociale netwerken.';
$string['socialnetworks'] = 'Sociale netwerk sites';
$string['themecolor'] = 'Thema kleuren';
$string['themecolordesc'] = 'Welke kleur wil je het thema hebben? Dit heeft invloed op meerdere componenten binnen Moodle en bepaalt de basis kleur voor je thema.';
$string['themecolors'] = 'Themakleuren';
$string['themehovercolor'] = 'Thema hover kleuren';
$string['themehovercolordesc'] = 'Welke kleuren moeten de hovers in het thema hebben? Dit wordt bijvoorbeeld gebruikt voor links.';
$string['themeiconcolor'] = 'Icoon kleur';
$string['themeiconcolordesc'] = 'Kies de kleur voor alle iconen';
$string['themenavcolor'] = 'Navigatietekstkleur';
$string['themenavcolordesc'] = 'Kies de kleur van de tekst in de navigatie. Het gaat om de navigatie balk en het kruimelpad fancy stijl';
$string['themetextcolor'] = 'Tekstkleur';
$string['themetextcolordesc'] = 'Selecteer de kleur voor je tekst.';
$string['themeurlcolor'] = 'Linkkleur';
$string['themeurlcolordesc'] = 'Selecteer de kleur voor de tekst hyperlink.';
$string['thiscourse'] = 'In deze cursus';
$string['togglemarketing'] = 'Marketing blokken inschakelen';
$string['togglemarketingdesc'] = 'Kies hier of je de marketing blokken wil tonen.';
$string['toggleslideshow'] = 'Slideshow inschakelen';
$string['toggleslideshowdesc'] = 'Kies hier of je de slideshow in wil schakelen.';
$string['twitter'] = 'Twitter URL';
$string['twitterdesc'] = 'Link naar je Twitter feed. (bvb. https://twitter.com/mijnorganisatie)';
$string['unreadnewnotification'] = 'Nieuwe mededeling';
$string['usecategoryicon'] = 'Enable Category Icons';
$string['usecategoryicondesc'] = 'Use custom icons for categories';
$string['variablewidth'] = 'Volledige breedte';
$string['versionalerttext1'] = 'Dit thema is niet ontwikkeld voor deze Moodle versie';
$string['versionalerttext2'] = 'Onverwachte problemen kunnen zich voordoen, installeer de juiste themaversie voor je Moodle versie.';
$string['versionalerttitle'] = 'Versiewaarschuwing:';
$string['visibleadminonly'] = 'Blokken in deze regio worden alleen aan beheerders getoond';
$string['vk'] = 'VKontakte URL';
$string['vkdesc'] = 'Link naar je VKontakte profiel. (bvb. http://vk.com/mijnorganisatie)';
$string['website'] = 'Website URL';
$string['websitedesc'] = 'Link naar je website. (bvb. http://www.uplearning.nl)';
$string['windowsdesc'] = 'Geef een URL op voor je Moodle APP in de Window Store. Als je zelf geen URL hebt, overweeg dan de link van de officiële Moodle App te gebruiken. (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['winphonedesc'] = 'Geef een URL op voor je Moodle APP in de Google Play Store. Als je zelf geen URL hebt, overweeg dan de link van de officiële Moodle App te gebruiken. (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['youtube'] = 'YouTube URL';
$string['youtubedesc'] = 'Link naar je YouTube kanaal. (bvb. https://www.youtube.com/user/mijnorganisatie)';
