<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'ru', branch 'MOODLE_28_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Вы уже вошли в систему под именем «{$a}». Вам нужно выйти из системы чтобы войти от имени другого пользователя.';
$string['authnotexisting'] = 'Плагин авторизации отсутствует';
$string['backupcontainexternal'] = 'Этот файл резервной копии содержит внешние узлы Moodle Network, которые не настроены локально';
$string['backuptablefail'] = 'НЕ удалось настроить таблицы для резервных копий!';
$string['blockcannotconfig'] = 'Этот блок не поддерживает глобальные настройки';
$string['blockcannotinistantiate'] = 'Проблема при создании экземпляра объекта блока';
$string['blockcannotread'] = 'Не удалось прочитать данные для блока с ID = {$a}';
$string['blockdoesnotexist'] = 'Этот блок не существует';
$string['blockdoesnotexistonpage'] = 'Этот блок (ID={$a->instanceid}) не существует на текущей странице ({$a->url}).';
$string['blocknameconflict'] = 'Конфликт наименований: блок «{$a->name}» повторяет название существующего блока: «{$a->conflict}»!';
$string['callbackrejectcomment'] = 'Комментарий отклонен функцией проверки комментариев.';
$string['cannotaddcoursemodule'] = 'Не удалось добавить новый модуль курса';
$string['cannotaddcoursemoduletosection'] = 'Не удалось добавить новый модуль курса в этот раздел';
$string['cannotaddmodule'] = 'Невозможно добавить модуль «{$a}» в список модулей!';
$string['cannotaddnewmodule'] = 'Не удалось добавить новый модуль «{$a}»';
$string['cannotaddrss'] = 'У Вас нет прав на добавление RSS-лент';
$string['cannotaddthisblocktype'] = 'Вы не можете добавить блок «{$a}» на эту страницу.';
$string['cannotassignrole'] = 'Невозможно назначить роль в курс';
$string['cannotassignrolehere'] = 'Вы не можете назначить эту роль (ID = {$a->roleid}) в этом контексте ({$a->context})';
$string['cannotassignselfasparent'] = 'Невозможно назначить себя как родителя!';
$string['cannotcallscript'] = 'Вы не можете вызвать этот скрипт таким образом';
$string['cannotcallusgetselecteduser'] = 'Нельзя вызывать user_selector::get_selected_user, если multi select = true.';
$string['cannotcreatebackupdir'] = 'Не удалось создать каталог backupdata (для резервных копий). Администратору сайта необходимо исправить права доступа к файлам';
$string['cannotcreatecategory'] = 'Не удалось вставить категорию';
$string['cannotcreatedboninstall'] = '<p> Невозможно создать базу данных. </p><p> Указанная база данных не существует, и данный пользователь не имеет разрешения на создание базы данных. </p><p> Администратор сайта  должен проверить конфигурацию базы данных. </p>';
$string['cannotcreategroup'] = 'Ошибка при создании группы';
$string['cannotcreatelangbase'] = 'Ошибка: не удалось создать каталог базового языка';
$string['cannotcreatelangdir'] = 'Не удается создать каталог языка';
$string['cannotcreateorfindstructs'] = 'Ошибка поиска или создания структуры разделов для этого курса';
$string['cannotcreatepopupwin'] = 'Элемент неопределенный  - не удается создать всплывающее окно';
$string['cannotcreatesitedir'] = 'Не удается создать каталог сайта. Администратору сайта необходимо исправить права доступа к файлам.';
$string['cannotcreatetempdir'] = 'Не удается создать временный каталог';
$string['cannotcreateuploaddir'] = 'Не удается создать каталог загрузки. Администратору сайта необходимо исправить права доступа к файлам.';
$string['cannotcustomisefiltersblockuser'] = 'Вы не можете настроить параметры фильтров в контексте пользователя или блока.';
$string['cannotdeletebackupids'] = 'Не удалось удалить предыдущие резервные копии';
$string['cannotdeletecategorycourse'] = 'Не удалось удалить курс «{$a}».';
$string['cannotdeletecategoryquestions'] = 'Не удалось удалить вопросы из категории «{$a}»';
$string['cannotdeletecourse'] = 'У Вас нет прав на удаление этого курса';
$string['cannotdeletecustomfield'] = 'Ошибка удаления поля пользовательских данных';
$string['cannotdeletedir'] = 'Не удается удалить ({$a})';
$string['cannotdeletefile'] = 'Не удается удалить этот файл';
$string['cannotdeleterole'] = 'Это не может быть удалено, так как {$a}';
$string['cannotdeleterolewithid'] = 'Не удалось удалить роль с ID {$a}';
$string['cannotdeletethisrole'] = 'Вы не можете удалить эту роль, поскольку она используется в системе. Возможно, что это последняя роль с правами администратора.';
$string['cannotdisableformat'] = 'Вы не можете отключить формат по умолчанию';
$string['cannotdownloadcomponents'] = 'Невозможно загрузить компоненты.';
$string['cannotdownloadlanguageupdatelist'] = 'Не удалось загрузить список обновлений языковых пакетов с download.moodle.org';
$string['cannotdownloadzipfile'] = 'Не удалось загрузить ZIP-файл';
$string['cannoteditcomment'] = 'Вы не можете изменять чужие комментарии!';
$string['cannoteditcommentexpired'] = 'Вы не можете это отредактировать. Время истекло!';
$string['cannoteditpostorblog'] = 'Вы не можете создавать или редактировать записи блогов';
$string['cannoteditsiteform'] = 'Вы не можете редактировать курс уровня сайта с помощью этой формы';
$string['cannotedityourprofile'] = 'К сожалению, Вы не можете редактировать свой профиль';
$string['cannotexecduringupgrade'] = 'Не может быть выполнено во время обновления';
$string['cannotfindcategory'] = 'Не удалось найти категорию в базе данных (ID = {$a})';
$string['cannotfindcomponent'] = 'Не удалось найти компонент';
$string['cannotfindcontext'] = 'Не удалось найти контекст';
$string['cannotfindcourse'] = 'Не удалось найти курс';
$string['cannotfinddocs'] = 'Не удается найти файлы документации на языке «{$a}»';
$string['cannotfindgradeitem'] = 'Не удалось найти grade_item (элемент оценки)';
$string['cannotfindgroup'] = 'Не удалось найти группу';
$string['cannotfindhelp'] = 'Не удается найти файлы справки на языке «{$a}»';
$string['cannotfindinfo'] = 'Не удалось найти информацию для: «{$a}»';
$string['cannotfindlang'] = 'Не удается найти языковой пакет «{$a}»!';
$string['cannotfindteacher'] = 'Не удалось найти учителя';
$string['cannotfinduser'] = 'Не удалось найти пользователя с логином «{$a}»';
$string['cannotgeoplugin'] = 'Не удается подключиться к серверу geoPlugin http://www.geoplugin.com. Проверьте настройки прокси-сервера или лучше установите MaxMind GeoLite City';
$string['cannotgetblock'] = 'Не удалось восстановить блоки из базы данных';
$string['cannotgetcats'] = 'Не удалось получить запись для категории';
$string['cannotgetdata'] = 'Не удалось получить данные';
$string['cannotgradeuser'] = 'Не удалось оценить этого пользователя';
$string['cannothaveparentcate'] = 'Категория курса не может иметь родительскую!';
$string['cannotimport'] = 'Ошибка импорта';
$string['cannotimportformat'] = 'К сожалению, импортирование этого формата еще не реализовано!';
$string['cannotimportgrade'] = 'Ошибка импорта оценки';
$string['cannotinsertgrade'] = 'Не удается вставить элемент оценки без ID курса!';
$string['cannotinsertrate'] = 'Не удалось вставить новую оценку ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Не удалось вставить новую запись с ID = {$a}';
$string['cannotmailconfirm'] = 'Ошибка при отправке по электронной почте подтверждения об изменении пароля';
$string['cannotmanualctrack'] = 'Элемент курса не предусматривает ручного отслеживания завершения';
$string['cannotmapfield'] = 'Обнаружено противоречие сопоставления - два сопоставляемых поля соответствуют одинаковому элементу оценивания {$a}';
$string['cannotmarktopic'] = 'Не удалось отметить эту тему для этого курса';
$string['cannotmigratedatacomments'] = 'Не удалось перенести комментарии данных модуля';
$string['cannotmodulename'] = 'Не удалось получить имя модуля для построения навигации';
$string['cannotmoduletype'] = 'Не удалось получить тип модуля в для построения навигации';
$string['cannotmovecategory'] = 'Невозможно переместить категорию';
$string['cannotmovecourses'] = 'Не удается переместить курсы из категории, в которой они находятся, в другую категорию.';
$string['cannotmoverolewithid'] = 'Не удалось переместить роль с ID ={$a}';
$string['cannotopencsv'] = 'Не удалось открыть CSV-файл';
$string['cannotopenfile'] = 'Не удалось открыть файл ({$a})';
$string['cannotopenforwrit'] = 'Не удалось открыть для записи: {$a}';
$string['cannotopentemplate'] = 'Не удалось открыть файл шаблона ({$a})';
$string['cannotopenzip'] = 'Не удалось открыть ZIP-файл, вероятно из-за ошибки расширения ZIP на 64-битных ОС';
$string['cannotoverridebaserole'] = 'Не удалось переопределить права основной роли';
$string['cannotoverriderolehere'] = 'Вы не можете переопределить эту роль (ID = {$a->roleid}) в этом контексте ({$a->context})';
$string['cannotreadfile'] = 'Не удалось прочитать файл ({$a})';
$string['cannotreadtmpfile'] = 'Ошибка при чтении временного файла';
$string['cannotreaduploadfile'] = 'Не удалось прочитать загруженный файл';
$string['cannotremovefrommeta'] = 'Не удалось удалить выбранный курс из этого метакурса!';
$string['cannotresetguestpwd'] = 'Вы не можете сбросить пароль гостя';
$string['cannotresetmail'] = 'Ошибка сброса пароля и отправки Вам нового пароля по почте';
$string['cannotresetthisrole'] = 'Невозможно сбросить эту роль';
$string['cannotrestore'] = 'Произошла ошибка, и восстановление не может быть завершено!';
$string['cannotrestoreadminorcreator'] = 'Вам необходимы права создателя курса или администратора для восстановления в новый курс!';
$string['cannotrestoreadminoredit'] = 'Вам необходимы права учителя или администратора для восстановления в выбранный курс!';
$string['cannotsaveagreement'] = 'Не удалось сохранить Ваше согласие';
$string['cannotsaveblock'] = 'Ошибка при сохранении конфигурации блока';
$string['cannotsavecomment'] = 'Невозможно сохранить комментарий';
$string['cannotsavedata'] = 'Невозможно сохранить данные';
$string['cannotsavefile'] = 'Невозможно сохранить файл «{$a}»!';
$string['cannotsavemd5file'] = 'Не удалось сохранить MD5-файл';
$string['cannotsavezipfile'] = 'Не удалось сохранить ZIP-файл';
$string['cannotservefile'] = 'Не удалось обработать файл - проблемы с конфигурацией сервера.';
$string['cannotsetparentforcatoritem'] = 'Не удалось установить родительскую категорию или элемент курса!';
$string['cannotsetpassword'] = 'Не удалось установить пароль пользователя!';
$string['cannotsetprefgrade'] = 'Не удалось установить значение «{$a}» параметра «способ объединения» для этой категории оценки';
$string['cannotsettheme'] = 'Не удалось установить тему!';
$string['cannotsetupblock'] = 'НЕ удалось настроить таблицы блоков!';
$string['cannotsetupcapformod'] = 'Не удается установить возможности для модуля {$a}';
$string['cannotsetupcapforplugin'] = 'Не удается установить возможности для плагина {$a}';
$string['cannotshowhidecoursesincategory'] = 'Не удалось показать/скрыть курсы в категории «{$a}».';
$string['cannotsignup'] = 'Вы не можете создать новую учетную запись, поскольку Вы уже зашли в систему как {$a}.';
$string['cannotunassigncap'] = 'Не удалось отозвать устаревшее право «{$a->cap}» у роли «{$a->role}»';
$string['cannotunassignrolefrom'] = 'Не удалось отменить назначение роли с ID = {$a} для этого пользователя';
$string['cannotunzipfile'] = 'Не удалось распаковать файл';
$string['cannotupdatemod'] = 'Не удалось обновить {$a}';
$string['cannotupdatepasswordonextauth'] = 'Не удалось обновить пароль в источнике внешней аутентификации: {$a}. Смотрите более подробную информацию в журнале ошибок сервера.';
$string['cannotupdateprofile'] = 'Ошибка при обновлении записи пользователя';
$string['cannotupdaterecord'] = 'Не удалось обновить запись с ID = {$a}';
$string['cannotupdaterss'] = 'Не удалось обновить RSS-ленту';
$string['cannotupdatesubcourse'] = 'Не удалось обновить дочерний курс!';
$string['cannotupdateusermsgpref'] = 'Не удалось обновить настройки сообщений пользователя';
$string['cannotupdateuseronexauth'] = 'Не удалось обновить данные пользователя внешней аутентификации: {$a}. Смотрите логи сервера для более подробной информации.';
$string['cannotuploadfile'] = 'Ошибка обработки загруженного файла';
$string['cannotuseadmin'] = 'Вы должны быть администратором, чтобы использовать эту страницу';
$string['cannotuseadminadminorteacher'] = 'Вы должны быть преподавателем или администратором, чтобы использовать эту страницу';
$string['cannotusepage'] = 'Только преподаватели и администраторы могут использовать эту страницу';
$string['cannotusepage2'] = 'Извините, но Вам не разрешено использовать эту страницу';
$string['cannotviewprofile'] = 'Вы не можете просматривать профиль этого пользователя';
$string['cannotviewreport'] = 'Вы не можете просматривать этот отчет';
$string['cannotwritefile'] = 'Ошибка записи в файл ({$a})';
$string['categoryerror'] = 'Ошибка категории';
$string['categoryidnumbertaken'] = 'Идентификационный номер уже используется для другой категории';
$string['categorynamerequired'] = 'Требуется название категории';
$string['categorytoolong'] = 'Название категории слишком длинное';
$string['commentmisconf'] = 'Настроен неверный ID комментария';
$string['componentisuptodate'] = 'Компонент не нуждается в обновлении';
$string['confirmsesskeybad'] = 'Произошла ошибка проверки ключа сеанса (sessionkey), а это необходимо для проведения этой операции. Эта функция безопасности предотвращает случайное или злонамеренное выполнение важных функций от Вашего имени. Пожалуйста, убедитесь, что Вы действительно хотели выполнить это действие.';
$string['couldnotassignrole'] = 'Серьезная, но неопределенная ошибка произошла при попытке назначить Вам роль';
$string['couldnotupdatenoexistinguser'] = 'Не удалось обновить пользователя - пользователь не существует';
$string['countriesphpempty'] = 'Ошибка: файл countries.php в языковом пакете «{$a}» пуст или отсутствует.';
$string['coursedoesnotbelongtocategory'] = 'Курс не принадлежит к этой категории';
$string['courseformatnotfound'] = 'Формат курса «{$a}» не существует, либо не распознан';
$string['coursegroupunknown'] = 'Курс, соответствующий группе {$a} не определен';
$string['courseidnotfound'] = 'ID курса не существует';
$string['courseidnumbertaken'] = 'Этот номер ID уже используется для другого курса ({$a})';
$string['coursemisconf'] = 'Курс неверно сконфигурирован';
$string['courserequestdisabled'] = 'Извините, но запросы на создание курсов отключены администратором.';
$string['csvcolumnduplicates'] = 'Обнаружены повторяющиеся столбцы';
$string['csvemptyfile'] = 'CSV файл пуст.';
$string['csvfewcolumns'] = 'Не хватает столбцов. Пожалуйста, проверьте настройки разделителя';
$string['csvinvalidcols'] = '<b> Неправильный файл CSV: </b> Первая строка должна содержать «Названия полей» и файл должен быть типа <br /> «Расширенные поля, разделенные запятыми» <br /> или <br /> «Расширенные поля с CAVV Result Code, разделенные запятыми»';
$string['csvinvalidcolsnum'] = 'Неверный CSV-файл - каждая строка должна содержать 49 или 70 полей';
$string['csvloaderror'] = 'Во время загрузки CSV-файла произошла ошибка: {$a}';
$string['csvweirdcolumns'] = 'Некорректный формат CVS-файла - количество столбцов не постоянно!';
$string['dbconnectionfailed'] = '<p>Ошибка: не удалось произвести подключение к базе данных.</p> <p>Возможно, что база данных перегружена или не работает должным образом.</p> <p>Администратору сайта следует также проверить, что в файле config.php указаны правильные параметры соединения с базой данных.</p>';
$string['dbdriverproblem'] = '<p>Ошибка: обнаружены проблемы с драйвером базы данных.</p> <p>Администратору сайта следует проверить конфигурацию сервера</p> <p>{$a}</p>';
$string['dbsessionbroken'] = 'Обнаружена серьезная проблема сессии базы данных.<br /><br /> Пожалуйста, сообщите об этом администратору сервера.';
$string['dbsessionhandlerproblem'] = 'Не удалось установить сессию базы данных. Сообщите об этом администратору сервера.';
$string['dbsessionmysqlpacketsize'] = 'Обнаружена серьезная ошибка сессии.<br /><br />Пожалуйста, сообщите об этом администратору сервера. Эта проблема, скорее всего, вызвана слишком маленьким значением max_allowed_packet параметра MySQL.';
$string['dbupdatefailed'] = 'Ошибка обновления базы данных';
$string['ddldependencyerror'] = '{$a->targettype} «{$a->targetname}» не может быть изменен. Найдена зависимость от {$a->offendingtype} «{$a->offendingname}»';
$string['ddlexecuteerror'] = 'Ошибка выполнения SQL в DDL';
$string['ddlfieldalreadyexists'] = 'Поле «{$a}» уже существует';
$string['ddlfieldnotexist'] = 'Поле «{$a->fieldname}» отсутствует в таблице «{$a->tablename}»';
$string['ddltablealreadyexists'] = 'Таблица «{$a}» уже существует';
$string['ddltablenotexist'] = 'Таблица «{$a}» не существует';
$string['ddlunknownerror'] = 'Неизвестная ошибка библиотеки DDL';
$string['ddlxmlfileerror'] = 'Найдены ошибки в XML-файле описания базы данных';
$string['ddsequenceerror'] = 'Некорректное определение таблицы «{$a}», может быть только одно поле с автоматической нумерацией и оно должно быть ключевым.';
$string['destinationcmnotexit'] = 'Модуль курса назначения не существует';
$string['detectedbrokenplugin'] = 'Плагин «{$a}» дефектный или устаревший. Продолжение невозможно.';
$string['dmlexceptiononinstall'] = '<p>Произошла ошибка базы данных [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlreadexception'] = 'Ошибка чтения из базы данных';
$string['dmltransactionexception'] = 'Ошибка транзакции базы данных';
$string['dmlwriteexception'] = 'Ошибка записи в базу данных';
$string['downgradedcore'] = 'ОШИБКА! Используемый программный код БОЛЕЕ СТАРЫЙ, чем версия, в которой была создана эта база данных!';
$string['downloadedfilecheckfailed'] = 'Ошибка проверки загруженного файла';
$string['duplicatefieldname'] = 'Обнаружено повторяющееся имя поля «{$a}»';
$string['duplicatenosupport'] = 'Активный элемент «{$a->modname}» не может быть продублирован, так как модуль {$a->modtype} не поддерживает резервное копирование и восстановление.';
$string['duplicateparaminsql'] = 'ОШИБКА: в запросе есть параметры с дублирующимся именами';
$string['duplicaterolename'] = 'Роль с таким названием уже существует!';
$string['duplicateroleshortname'] = 'Роль с таким кратким названием уже существует';
$string['duplicateusername'] = 'Повторение имени пользователя - пропускаем запись';
$string['emailfail'] = 'Не удалось отправить сообщение электронной почты';
$string['error'] = 'Произошла ошибка';
$string['errorcleaningdirectory'] = 'Ошибка очистки каталога «{$a}»';
$string['errorcopyingfiles'] = 'Ошибка копирования файлов';
$string['errorcreatingdirectory'] = 'Ошибка создания каталога «{$a}»';
$string['errorcreatingfile'] = 'Ошибка создания файла «{$a}»';
$string['errorcreatingrole'] = 'Ошибка создания роли';
$string['errorfetchingrssfeed'] = 'Ошибка при получении RSS-ленты.';
$string['erroronline'] = 'Ошибка в строке {$a}';
$string['errorparsingxml'] = 'Ошибка анализа XML: {$a->errorstring}, строка {$a->errorline}, символ {$a->errorchar}';
$string['errorprocessingarchive'] = 'Ошибка обработки файла архива';
$string['errorreadingfile'] = 'Ошибка чтения файла «{$a}»';
$string['errorsavingrequest'] = 'При попытке сохранения Вашего запроса произошла ошибка.';
$string['errorsettinguserpref'] = 'Ошибка установки пользовательских настроек';
$string['errorunzippingfiles'] = 'Ошибка разархивирования файлов';
$string['expiredkey'] = 'Срок действия ключа истек';
$string['externalauthpassworderror'] = 'Не пустой пароль для аутентификации во внешнем источнике';
$string['externalfilenolocation'] = 'Отстутсвует путь к внешнему файлу';
$string['failtoloadblocks'] = 'Не удалось загрузить один или несколько блоков, хотя они зарегистрированы в базе данных!';
$string['fieldrequired'] = '«{$a}» необходимое поле';
$string['fileexists'] = 'Файл существует';
$string['filemismatch'] = 'Несоответствие имени файла. Файл «{$a->current}» должен быть «{$a->file}»';
$string['filenotfound'] = 'Извините, не удалось найти запрашиваемый Вами файл';
$string['filenotreadable'] = 'Невозможно прочитать файл';
$string['filterdoesnothavelocalconfig'] = 'Фильтр «{$a}» не поддерживает локальную конфигурацию.';
$string['filternotactive'] = 'Фильтр «{$a}» не активен в настоящее время';
$string['filternotenabled'] = 'Фильтр не включен!';
$string['filternotinstalled'] = 'Фильтр «{$a}» не установлен';
$string['forumblockingtoomanyposts'] = 'Вы превысили порог количества сообщений для данного форума';
$string['generalexceptionmessage'] = 'Исключение - {$a}';
$string['gradecantregrade'] = 'Произошла ошибка при вычислении оценки: {$a}';
$string['gradepubdisable'] = 'Публикация оценок отключена';
$string['groupalready'] = 'Пользователь уже принадлежит к группе {$a}';
$string['groupexistforcourse'] = 'В данном курсе уже существует группа «{$a}»';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Группа «{$a->name}» с ID-номером «{$a->idnumber}» уже существует в этом курсе';
$string['grouphasidnumber'] = 'Группа «{$a}» имеет ID-номер и, возможно, была автоматически создана внешней системой. У Вас нет прав на удаление этой группы.';
$string['groupinghasidnumber'] = 'Поток «{$a}» имеет ID-номер и, возможно, был автоматически создан внешней системой. У Вас нет прав на удаление этого потока.';
$string['groupingnotaddederror'] = 'Поток «{$a}» не добавлен';
$string['groupnotaddederror'] = 'Группа {$a} не добавлена';
$string['groupnotaddedtogroupingerror'] = 'Группа «{$a->groupname}» не добавлена к потоку «{$a->groupingname}»';
$string['groupunknown'] = 'Группа «{$a}» не связана с указанным курсом';
$string['groupusernotmember'] = 'Пользователь не является участником этой группы.';
$string['guestcantaccessprofiles'] = 'Гости не имеют доступа к профилям пользователей. Для продолжения войдите под учетной записью пользователя.';
$string['guestnocomment'] = 'Гости не могут отправлять комментарии к сообщения!';
$string['guestnoeditprofile'] = 'Гости не могут редактировать свой профиль';
$string['guestnoeditprofileother'] = 'Нельзя редактировать профиль гостя';
$string['guestnorate'] = 'Гости не могут ставить оценки';
$string['guestsarenotallowed'] = 'Гостю не разрешается делать это';
$string['hackdetected'] = 'Обнаружена атака хакеров!';
$string['hashpoolproblem'] = 'Некорректное содержимое объединенного файла {$a}.';
$string['headersent'] = 'Заголовки уже отправлены';
$string['idnumbertaken'] = 'Этот идентификационный номер уже используется';
$string['idnumbertoolong'] = 'ID-номер слишком длинный';
$string['importformatnotimplement'] = 'К сожалению, импорт в этом формате еще не реализован!';
$string['incorrectext'] = 'Файл имеет неправильное расширение';
$string['installproblem'] = 'Обычно не представляется возможным исправить ошибки, возникшие во время установки. Возможно, потребуется создать новую базу данных или использовать другой префикс базы данных, если Вы захотите повторить установку.';
$string['internalauthpassworderror'] = 'Пароль отсутствует или не соответствует политике паролей для внутренней аутентификации';
$string['invalidaccess'] = 'Доступ к странице был некорректный';
$string['invalidaccessparameter'] = 'Неверный параметр доступа';
$string['invalidaction'] = 'Неверный параметр действия';
$string['invalidactivityid'] = 'Неверный ID элемента курса';
$string['invalidadminsettingname'] = 'Неверная административный параметр ({$a})';
$string['invalidargorconf'] = 'Нет правильно предоставленных аргументов или сервер неверно сконфигурирован';
$string['invalidarguments'] = 'Нет правильно предоставленных агрументов';
$string['invalidblockinstance'] = 'Неверный экземпляр блока для: {$a}';
$string['invalidbulkenrolop'] = 'Запрошена неверная операция массовой регистрации';
$string['invalidcategory'] = 'Некорректная категория!';
$string['invalidcategoryid'] = 'Неверный ID категории!';
$string['invalidcomment'] = 'Некорректный комментарий';
$string['invalidcommentarea'] = 'Неверная зона комментария';
$string['invalidcommentid'] = 'Неверный id комментария';
$string['invalidcommentitemid'] = 'Неверный itemid комментария';
$string['invalidcommentparam'] = 'Неверный параметр комментария';
$string['invalidcomponent'] = 'Неверное имя компонента';
$string['invalidconfirmdata'] = 'Неверные подтвержденные данные';
$string['invalidcontext'] = 'Недопустимый контекст';
$string['invalidcourse'] = 'Ошибочный курс';
$string['invalidcourseid'] = 'Вы пытаетесь использовать неправильный ID курса';
$string['invalidcourselevel'] = 'Неправильный уровень контекста';
$string['invalidcoursemodule'] = 'Неправильный ID модуля курса';
$string['invalidcoursenameshort'] = 'Неправильное краткое название курса';
$string['invaliddata'] = 'Отправлены некорректные данные';
$string['invaliddatarootpermissions'] = 'Для каталога $CFG->dataroot назначены неверные права доступа, администратор должен их исправить.';
$string['invaliddevicetype'] = 'Неверный тип устройства';
$string['invalidelementid'] = 'Неверный ID элемента!';
$string['invalidentry'] = 'Это некорректная запись!';
$string['invalidevent'] = 'Неверное событие';
$string['invalidfieldname'] = 'Некорректное имя поля «{$a}»';
$string['invalidfiletype'] = 'Некорректный тип файла «{$a}»';
$string['invalidformatpara'] = 'Неверный формат для выбранного параметра';
$string['invalidformdata'] = 'Неверная форма данных';
$string['invalidfunction'] = 'Некорректная функция';
$string['invalidgradeitemid'] = 'Некорректный ID оцениваемого элемента';
$string['invalidgroupid'] = 'Определен неверный идентификатор группы';
$string['invalidipformat'] = 'Неверный формат IP-адреса';
$string['invaliditemid'] = 'Неверный id элемента';
$string['invalidkey'] = 'Неверный ключ';
$string['invalidlegacy'] = 'Неверная наследуемая роль для типа: {$a}';
$string['invalidmd5'] = 'Некорректная md5';
$string['invalidmode'] = 'Неверный режим ({$a})';
$string['invalidmodule'] = 'Неверный модуль';
$string['invalidmoduleid'] = 'Неверный id модуля: {$a}';
$string['invalidmodulename'] = 'Неверное имя модуля: {$a}';
$string['invalidnum'] = 'Неверное числовое значение';
$string['invalidnumkey'] = 'Массив $conditions не может содержать цифры - исправьте код!';
$string['invalidoutcome'] = 'Некорректный id показателя';
$string['invalidpagesize'] = 'Неверный размер страницы';
$string['invalidpasswordpolicy'] = 'Некорректная политика паролей';
$string['invalidpaymentmethod'] = 'Неверный метод оплаты: {$a}';
$string['invalidqueryparam'] = 'ОШИБКА: неверное количество параметров запроса. Ожидается {$a->expected}, получено {$a->actual}';
$string['invalidratingarea'] = 'Неверная область рейтинга';
$string['invalidrecord'] = 'Не удается найти данную запись в таблице {$a} базы данных.';
$string['invalidrecordunknown'] = 'Не удается найти данную запись в базе данных';
$string['invalidrequest'] = 'Некорректный запрос';
$string['invalidrole'] = 'Некорректная роль';
$string['invalidroleid'] = 'Неверный идентификатор роли';
$string['invalidscaleid'] = 'Неверный идентификатор шкалы';
$string['invalidsection'] = 'Запись модуля курса содержит неверный раздел';
$string['invalidsesskey'] = 'Отправлен неверный ключ сеанса (sesskey), форма не принята!';
$string['invalidshortname'] = 'Это некорректное краткое название курса';
$string['invalidsourcefield'] = 'Неверное поле источника файлов проекта';
$string['invalidstatedetected'] = 'Что-то пошло не так: {$a}.
Такого обычно никогда не должно происходить.';
$string['invalidurl'] = 'Некорректный URL';
$string['invaliduser'] = 'Некорректный пользователь';
$string['invaliduserfield'] = 'Неверное пользовательское поле: {$a}';
$string['invaliduserid'] = 'Неверный ID пользователя';
$string['invalidusername'] = 'Данное имя пользователя содержит недопустимые символы';
$string['invalidxmlfile'] = '«{$a}» - некорректный XML файл';
$string['iplookupfailed'] = 'Невозможно определить гео-информацию об этом IP-адресе {$a}.';
$string['iplookupprivate'] = 'Невозможно отобразить расположение локального IP-адреса.';
$string['ipmismatch'] = 'Несоответствие IP-адреса клиента';
$string['listcantmovedown'] = 'Невозможно переместить элемент вниз, так как он и так на последнем месте';
$string['listcantmoveleft'] = 'Невозможно переместить элемент влево, так как он не имеет родительского объекта';
$string['listcantmoveright'] = 'Невозможно переместить элемент вправо и сделать его дочерним, поскольку над ним нет элементов этого же уровня. Переместите его под другой элемента такого же уровня, и тогда Вы сможете переместить его вправо.';
$string['listcantmoveup'] = 'Невозможно переместить элемент вверх, поскольку он является первым среди элементов одного уровня';
$string['listnochildren'] = 'Дочерних элементов не найдено';
$string['listnoitem'] = 'Элемент не найден';
$string['listnopeers'] = 'На данном уровне не найдено больше элементов';
$string['listupdatefail'] = 'Операция с базой данных завершена с ошибкой во время редактирования списка иерархии';
$string['logfilenotavailable'] = 'Журнал событий не доступен';
$string['loginasnoenrol'] = 'Вы не можете записываться на курс или отписываться от курса, когда находитесь в режиме «Зайти под именем»';
$string['loginasonecourse'] = 'Вы не можете войти в этот курс. <br />Вам необходимо выйти из режима «Зайти под именем», прежде чем войти в любой другой курс.';
$string['maxareabytes'] = 'Файл больше, чем оставшееся пространство в этой области.';
$string['maxbytes'] = 'Этот файл больше максимального разрешенного размера';
$string['messagingdisable'] = 'На этом сайте выключен обмен сообщениями';
$string['mimetexisnotexist'] = 'Ваша система не настроена на работу mimeTeX. Вам нужно скачать версию mimeTeX для своей операционной системы по ссылке <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a>, или скачать исходный код на C по ссылке <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>, скомпилировать его и поместить в свой каталог  moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'mimetex не является выполняемым!';
$string['missingfield'] = 'Отсутствует поле «{$a}»';
$string['missingkeyinsql'] = 'ОШИБКА: в запросе отсутствует параметр «{$a}»';
$string['missing_moodle_backup_xml_file'] = 'В резервной копии отсутствует XML-файл: {$a}';
$string['missingparam'] = 'Отсутствует обязательный параметр ({$a})';
$string['missingparameter'] = 'Параметр отсутствует';
$string['missingrequiredfield'] = 'Отсутствуют некоторые обязательные поля';
$string['missinguseranditemid'] = 'Отсутствуют поля userid и itemid';
$string['missingvarname'] = 'Отсутствует имя обязательной  переменной!';
$string['mixedtypesqlparam'] = 'ОШИБКА: смешанные типы параметров SQL запроса!';
$string['mnetdisable'] = 'MNET отключено';
$string['mnetlocal'] = 'Внешние пользователи MNET не могут входить локально';
$string['moduledisable'] = 'Этот модуль ({$a}) был отключен в этом курсе';
$string['moduledoesnotexist'] = 'Этот модуль не существует';
$string['moduleinstancedoesnotexist'] = 'Нет экземпляр этого модуля не существует';
$string['modulemissingcode'] = 'В модуле {$a} отсутствует код, необходимый для выполнения этой функции';
$string['movecatcontentstoroot'] = 'Перемещение содержимого категории в корневой каталог не допускается. Вы должны переместить содержимое в существующую категорию!';
$string['movecategorynotpossible'] = 'Вы не можете переместить категорию «{$a}» в выбранную категорию.';
$string['movecategoryownparent'] = 'Вы не можете сделать категорию «{$a}» родительской по отношению к самой себе.';
$string['movecategoryparentconflict'] = 'Вы не можете сделать категорию «{$a}» подкатегорией в одной из её собственных подкатегорий.';
$string['mssqlrcsmodemissing'] = 'База данных не использует режим READ_COMMITTED_SNAPSHOT, что может привести к неправильным результатам, особенно при одновременном выполнении большого количества сценариев. Пожалуйста, включите его для правильного поведения. Более подробную информацию можно найти в  <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP#Configuration">документации Moodle</a>.';
$string['multiplerecordsfound'] = 'Найдено несколько записей, хотя ожидалась только одна.';
$string['multiplerestorenotallow'] = 'Выполнение многократных восстановлений не допускается!';
$string['mustbeloggedin'] = 'Вы должны войти в систему, чтобы сделать это';
$string['mustbeteacher'] = 'Вы должны быть преподавателем, чтобы просматривать эту страницу';
$string['myisamproblem'] = 'Таблицы базы данных хранятся в системе MyISAM. Рекомендуется использовать ACID-совместимые системы с полной поддержкой транзакций, такие как, например, InnoDB.';
$string['needcopy'] = 'Вам нужно сначала что-нибудь скопировать!';
$string['needcoursecategroyid'] = 'Должен быть указан ID курса или категории';
$string['needphpext'] = 'Вам необходимо добавить расширение {$a} к вашей установке PHP';
$string['noadmins'] = 'Нет администраторов!';
$string['noblocks'] = 'Блоки не найдены!';
$string['nocapabilitytousethisservice'] = 'Пользователь не имеет необходимых прав на использование этой службы';
$string['nocategorydelete'] = 'Категория {$a} не может быть удалена!';
$string['nocontext'] = 'Извините, но этот курс имеет некорректный контекст';
$string['nodata'] = 'Нет данных';
$string['noexistingcategory'] = 'Нет существующих категорий';
$string['nofile'] = 'Файл не указан';
$string['nofiltersenabled'] = 'Фильтры не включены.';
$string['nofolder'] = 'Запрашиваемый каталог не существует';
$string['noformdesc'] = 'Не найден файл описания формы formslib для этого элемента курса.';
$string['noguest'] = 'Гостям запрещено находиться здесь!';
$string['noinstances'] = 'Нет случаев появления {$a} в этом курсе';
$string['nologinas'] = 'Вам не разрешено заходить под именем этого пользователя';
$string['nonmeaningfulcontent'] = 'Нет значимого содержимого';
$string['noparticipants'] = 'Не найдены участники для этого курса.';
$string['noparticipatorycms'] = 'Извините, нет модулей курса с участниками, нечего выводить в отчете';
$string['nopermissions'] = 'Извините, но у Вас нет прав сделать это ({$a})';
$string['nopermissiontocomment'] = 'Вы не можете добавлять комментарии';
$string['nopermissiontodelentry'] = 'Вы не можете удалять записи других людей!';
$string['nopermissiontoeditcomment'] = 'Вы не можете редактировать комментарии других людей!';
$string['nopermissiontohide'] = 'Нет права скрывать!';
$string['nopermissiontoimportact'] = 'У Вас нет необходимых прав для импорта элементов в этот курс';
$string['nopermissiontolock'] = 'Нет права на блокировку!';
$string['nopermissiontomanagegroup'] = 'У Вас нет необходимых прав для управления группами';
$string['nopermissiontorate'] = 'Оценивание элементов запрещено!';
$string['nopermissiontoshow'] = 'Нет права просматривать это!';
$string['nopermissiontounlock'] = 'Нет прав  для разблокировки!';
$string['nopermissiontoupdatecalendar'] = 'Извините, но сейчас у вас нет прав на обновление события календаря';
$string['nopermissiontoviewgrades'] = 'Не удается просмотреть оценки.';
$string['nopermissiontoviewletergrade'] = 'Отсутствует разрешение на просмотр буквенных оценок';
$string['nopermissiontoviewpage'] = 'Вы не можете просматривать эту страницу';
$string['nosite'] = 'Не удалось найти курс верхнего уровня!';
$string['nositeid'] = 'Нет ID сайта';
$string['nostatstodisplay'] = 'Нет данных для отображения';
$string['notallowedtoupdateprefremotely'] = 'Вы не можете удаленно обновить предпочтения этого пользователя';
$string['notavailable'] = 'Сейчас это недоступно.';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Вы не являетесь участником этой группы';
$string['notownerofkey'] = 'Вы не являетесь владельцем этого ключа';
$string['nousers'] = 'Нет такого пользователя!';
$string['onlyadmins'] = 'Это могут делать только администраторы';
$string['onlyeditingteachers'] = 'Это могут делать только редактирующие преподаватели';
$string['onlyeditown'] = 'Вы можете редактировать только свою собственную информацию';
$string['orderidnotfound'] = 'Упорядочение идентификатора {$a} не найдено';
$string['pagenotexist'] = 'Возникла необычная ошибка';
$string['pathdoesnotstartslash'] = 'Указаны некорректные параметры, путь не начинается с знака «/»!';
$string['pleasereport'] = 'Если у Вас есть время, пожалуйста расскажите нам, что Вы пытались сделать, когда возникла ошибка';
$string['pluginrequirementsnotmet'] = 'Невозможно установить плагин «{$a->pluginname}» ({$a->pluginversion}). Для этого требуется более новая версия Moodle (в настоящее время Вы используете версию {$a->currentmoodle}, необходима версия {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>Ошибка: префикс имен таблиц базы данных не может быть пустым ({$a})</p><p>Администратор сайта должен решить эту проблему.</p>';
$string['prefixtoolong'] = '<p>Ошибка: префикс имен таблиц таблиц базы данных слишком длинный ({$a->dbfamily})</p> <p>Администратор сайта должен решить эту проблему. Максимальная длина префикса таблицы для {$a->dbfamily} должна быть {$a->maxlength} символов(а).</p>';
$string['processingstops'] = 'Обработка закончилась здесь. Оставшиеся записи не обработаны.';
$string['protected_cc_not_supported'] = 'Защищенные модули не поддерживаются.';
$string['querystringcannotbeempty'] = 'Строка запроса не может быть пустой.';
$string['redirecterrordetected'] = 'Обнаружено не поддерживаемое перенаправление, выполнение скрипта прекращено';
$string['refoundto'] = 'Может быть возвращено {$a}';
$string['refoundtoorigi'] = 'Возврат исходного количества: {$a}';
$string['remotedownloaderror'] = '<p>Не удалось загрузить компонент на сервер. Проверьте настройки прокси-сервера; настоятельно рекомендуется установка расширения  PHP cURL.</p>
<p>Вам следует вручную загрузить файл по ссылке <a href="{$a->url}">{$a->url}</a>, скопировать его в папку «{$a->dest}» на своем сервере и там его распаковать.</p>';
$string['remotedownloadnotallowed'] = 'Загрузка компонентов на Ваш сервер не разрешена (allow_url_fopen выключено) <br /><br />. Вы должны загрузить <a href="{$a->url}">{$a->url}</a> файл вручную, скопировав его в «{$a->dest}» на сервер и там его распаковать.';
$string['reportnotavailable'] = 'Этот тип отчета доступен только для курса уровня сайта';
$string['requirecorrectaccess'] = 'Неверный адрес или порт';
$string['requireloginerror'] = 'Курс или элемент курса не доступны.';
$string['restorechecksumfailed'] = 'Некоторые проблемы произошли при восстановлении данных сессии. Пожалуйста проверьте в своем PHP ограничения размера памяти/пакета базы данных. Восстановление остановлено.';
$string['restore_path_element_missingmethod'] = 'Метод восстановления {$a} отсутствует. Он должен быть определен разработчиком';
$string['restore_path_element_noobject'] = 'Восстанавливаемый объект {$a} не является объектом';
$string['restrictedcontextexception'] = 'К сожалению, выполнению внешней функции нарушает ограничения по контексту.';
$string['restricteduser'] = 'Извините, но Ваш текущий аккаунт «{$a}» не позволяет Вам делать это.';
$string['reverseproxyabused'] = 'Используется реверсивный прокси-сервер, невозможно подключиться к серверу напрямую.<br /> Пожалуйста, обратитесь к администратору сервера.';
$string['rpcerror'] = 'Ошибка соединения MNET! Вот сообщение об ошибке для администратора: {$a}';
$string['scheduledbackupsdisabled'] = 'Запланированное резервирование было отключено администратором сервера';
$string['secretalreadyused'] = 'Эта ссылка для подтверждения смены пароля уже использовалась, пароль не был изменен';
$string['sectionnotexist'] = 'Этот раздел не существует';
$string['sendmessage'] = 'Отправить сообщение';
$string['serverconnection'] = 'Ошибка соединения с сервером';
$string['servicedonotexist'] = 'Служба не существует';
$string['sessioncookiesdisable'] = 'Неверное использование require_key_login() - куки сессии должны быть отключены!';
$string['sessiondiskfull'] = 'На диске заполнен раздел, в котором хранятся данные сессий. Из-за этого сейчас невозможно войти в систему. Пожалуйста, сообщите об этом администратору сервера.';
$string['sessionerroruser'] = 'Время Вашего сеанса истекло. Пожалуйста, войдите в систему еще раз.';
$string['sessionerroruser2'] = 'На сервере возникла ошибка, касающаяся Вашего сеанса. Пожалуйста, войдите в систему снова или перезапустите браузер.';
$string['sessionhandlerproblem'] = 'Обработчик сессии неправильно настроен';
$string['sessionipnomatch'] = 'Извините, но Ваш IP адрес был изменен с момента Вашего входа в систему. Эта возможность системы безопасности предотвращает попытки взломщиков получить Ваши учетные данные во время Вашего пребывания на сайте. Обычно пользователи не должны видеть это сообщение. Пожалуйста, свяжитесь с администратором сайта.';
$string['sessionipnomatch2'] = 'Извините, но похоже что Ваш IP-адрес изменился с момента входа в систему. Эта функция предотвращает похищение Ваших данных хакерами во время работы на сайте. Эта ошибка может возникать, если Вы используете беспроводные сети или перемещаетесь между различными сетями. Вы можете обратитесь за более подробной информацией к администратору сайта. <br /> <br /> Если Вы хотите продолжить работу, нажмите клавишу F5, чтобы обновить эту страницу.';
$string['sessionwaiterr'] = 'Тайм-аут в ожидании блокировки сессии. <br /> Подождите, пока Ваши текущие запросы будут завершены и позже попробуйте еще раз.';
$string['shortnametaken'] = 'Это краткое название уже используется другим курсом ({$a})';
$string['socksnotsupported'] = 'Прокси SOCKS5 не поддерживается PHP4';
$string['spellcheckernotconf'] = 'Проверка правописания не настроена';
$string['sslonlyaccess'] = 'По соображениям безопасности разрешены только HTTPS-соединения.';
$string['statscatchupmode'] = 'В настоящее время статистика обрабатывается. Пока обработано дней - {$a->daysdone}, не закончено - {$a->dayspending}. Следите за ходом событий!';
$string['statsdisable'] = 'Статистика не включена';
$string['statsnodata'] = 'Нет данных, соответствующих сочетанию курса с  периодом времени.';
$string['storedfilecannotcreatefile'] = 'Невозможно создать файл локального пула файлов, пожалуйста, проверьте разрешения в DataRoot и наличие свободного места на диске.';
$string['storedfilecannotcreatefiledirs'] = 'Невозможно создать каталоги локальной файловой области, проверьте разрешения в каталоге dataroot.';
$string['storedfilecannotread'] = 'Не удалось прочитать файл. Файл не существует или неверно настроены права доступа.';
$string['storedfilenotcreated'] = 'Не удалось создать файл «{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}»';
$string['storedfileproblem'] = 'Неизвестное исключение, связанное с локальными файлами ({$a})';
$string['tagdisabled'] = 'Теги запрещены!';
$string['tagnotfound'] = 'Указанный тег не был найден в базе данных';
$string['targetdatabasenotempty'] = 'Целевая база данных не пуста. Передача прервана по соображениям безопасности.';
$string['textconditionsnotallowed'] = 'Не допускаются условия, содержащее сравнения полей типа text. Пожалуйста, используйте в запросе sql_compare_text().';
$string['themenotinstall'] = 'Эта тема не установлена!';
$string['TODO'] = 'Сделать';
$string['tokengenerationfailed'] = 'Невозможно создать новый ключ.';
$string['transactionvoid'] = 'Транзакция не может быть аннулирована, поскольку она уже была аннулирована';
$string['unenrolerror'] = 'Произошла ошибка при попытке отчисления этого человека';
$string['unicodeupgradeerror'] = 'К сожалению, ваша база данных еще не в кодировке Unicode, а эта версия Moodle не в состоянии перевести базу данных в Юникод. Пожалуйста, сначала обновите Moodle до 1.7.x и выполните миграцию в Unicode на страницы администратрирования. После этого Вы сможете перейти на Moodle {$a}';
$string['unknowaction'] = 'Неизвестное действие!';
$string['unknowcategory'] = 'Неизвестная категория!';
$string['unknowcontext'] = 'Неизвестный контекст ({$a}) в get_child_contexts!';
$string['unknowformat'] = 'Неизвестный формат ({$a})';
$string['unknownbackupexporterror'] = 'Неизвестная ошибка при подготовке информации для импорта';
$string['unknownblockregion'] = 'Область блока «{$a}» не определена для этой страницы';
$string['unknowncontext'] = 'Неизвестный контекст.';
$string['unknowncourse'] = 'Неизвестное название курса «{$a}»';
$string['unknowncourseidnumber'] = 'Неизвестный ID курса «{$a}»';
$string['unknowncourserequest'] = 'Неизвестный запрос курса';
$string['unknowncoursesection'] = 'Неизвестный раздел в курсе «{$a}»';
$string['unknownevent'] = 'Неизвестное событие';
$string['unknownfiletype'] = 'Ошибка - неизвестный тип фильтра';
$string['unknowngroup'] = 'Неизвестная группа «{$a}»';
$string['unknownhelp'] = 'Неизвестный раздел справки «{$a}»';
$string['unknownjsinrequirejs'] = 'Не удалось найти библиотеку JavaScript: {$a}';
$string['unknownmodulename'] = 'Неизвестное название модуля для формы';
$string['unknownrole'] = 'Неизвестная роль «{$a}»';
$string['unknownsortcolumn'] = 'Неизвестный столбец для сортировки {$a}';
$string['unknownuseraction'] = 'К сожалению, это действие пользователя непонятно.';
$string['unknownuserselector'] = 'Неизвестный селектор пользователя';
$string['unknoworder'] = 'Неизвестный порядок';
$string['unknowparamtype'] = 'Неизвестный тип параметра: {$a}';
$string['unknowquestiontype'] = 'Неподдерживаемый тип вопроса {$a}';
$string['unknowuploadaction'] = 'Ошибка: неизвестное действие при загрузке ({$a})';
$string['unspecifycourseid'] = 'Необходимо указать ID курса или его краткое название';
$string['unsupportedevent'] = 'Неподдерживаемый тип события';
$string['unsupportedstate'] = 'Неподдерживаемое состояние завершения';
$string['unsupportedwebserver'] = 'К сожалению, программное обеспечение веб-сервера ({$a}) не поддерживается';
$string['upgraderequires19'] = 'Ошибка: Новая версия Moodle была установлена на сервере, к сожалению, обновление с предыдущей версии не поддерживается.<br />Сначала обновите до последней версии 1.9.x. Вы также можете вернуться к предыдущей версии путем переустановки оригинальных файлов.';
$string['upgraderunning'] = 'Сайт обновляется, повторите попытку позже.';
$string['urlnotdefinerss'] = 'Для RSS-ленты не указан адрес';
$string['useradmineditadmin'] = 'Только администраторы могут изменять учетные записи других администраторов.';
$string['useradminodelete'] = 'Учетная запись администратора не может быть удалена';
$string['userautherror'] = 'Неизвестный плагин аутентификации';
$string['userauthunsupported'] = 'Плагин аутентификации не поддерживается здесь';
$string['useremailduplicate'] = 'Повторяющийся адрес';
$string['usermustbemnet'] = 'Пользователи в списке управления доступом к MNET должны быть внешними пользователями MNET';
$string['usernotaddederror'] = 'Пользователь не добавлен - ошибка';
$string['usernotaddedregistered'] = 'Пользователь не добавлен - он уже зарегистрирован';
$string['usernotavailable'] = 'Информация о данном пользователе Вам не доступна.';
$string['usernotdeletedadmin'] = 'Пользователь не удален - нельзя удалять учетные записи администраторов';
$string['usernotdeletederror'] = 'Ошибка - пользователь не удален';
$string['usernotdeletedmissing'] = 'Пользователь не удален - не удается найти имя пользователя';
$string['usernotdeletedoff'] = 'Пользователь не удален - удаление не разрешено';
$string['usernotincourse'] = 'Этого пользователь нет в этом курсе!';
$string['usernotrenamedadmin'] = 'Невозможно переименовать учетные записи администраторов';
$string['usernotrenamedexists'] = 'Пользователь не переименован - новое имя пользователя уже используется';
$string['usernotrenamedmissing'] = 'Пользователь не переименован - невозможно найти старое имя пользователя';
$string['usernotrenamedoff'] = 'Пользователь не переименован - переименование не разрешено';
$string['usernotupdatedadmin'] = 'Невозможно обновить учетные записи администраторов';
$string['usernotupdatederror'] = 'Пользователь не обновлен - ошибка';
$string['usernotupdatednotexists'] = 'Пользователь не обновлен - не существует';
$string['userquotalimit'] = 'Вы достигли предела квоты на объем личных файлов.';
$string['userselectortoomany'] = 'В user_selector было выбрано более одного пользователя, хотя  параметр multiselect был установлен false.';
$string['wrongcall'] = 'Этот скрипт был вызыван некорректно';
$string['wrongcontextid'] = 'Некорректный ID контекста (не удалось его найти)';
$string['wrongdestpath'] = 'Ошибочный путь назначения';
$string['wrongroleid'] = 'Некорректный ID роли!';
$string['wrongsourcebase'] = 'Неправильный адрес источника';
$string['wrongusernamepassword'] = 'Неверное имя пользователя/пароль';
$string['wrongzipfilename'] = 'Неверное имя ZIP-файла';
$string['wscouldnotcreateecoursenopermission'] = 'WS - не удалось создать курс - нет разрешения';
$string['wwwrootmismatch'] = 'Обнаружена попытка некорректного доступа. Этот сервер доступен только по адресу «{$a}». <br /> Пожалуйста, сообщите об этом администратору сервера.';
$string['wwwrootslash'] = 'В файле config.php указан некорректный параметр $CFG->wwwroot. Он не должен содержать знак «/» в конце.<br />Пожалуйста, сообщите об этом администратору сервера.';
$string['xmldberror'] = 'Ошибка XMLDB!';
$string['youcannotdeletecategory'] = 'Вы не можете удалить категорию «{$a}», потому что не можете ни удалить содержимое, ни переместить его в другое место.';
