<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'ru', branch 'MOODLE_28_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Контроль доступа';
$string['actionaftercorrectanswer'] = 'Действие после правильного ответа';
$string['actionaftercorrectanswer_help'] = 'После правильного ответа на вопрос, существует 3 варианта действия при переходе к следующей странице:

* Обычное - согласно пути лекции
* Показывать непросмотренные страницы - страницы отображаются в случайном порядке; показанные ранее страницы не отображаются.
* Показывать вопросы, оставшиеся без ответа - страницы отображаются в случайном порядке; повторно отображаются страницы, содержащие оставшиеся без ответа вопросы.';
$string['actions'] = 'Действия';
$string['activitylink'] = 'Ссылка на следующий элемент курса';
$string['activitylink_help'] = 'Чтобы по окончании лекции предложить студенту переход к другому элементу этого курса, выберите этот элемент курса в этом списке.';
$string['activitylinkname'] = 'Перейти к: {$a}';
$string['activityoverview'] = 'У Вас есть непройденные лекции';
$string['addabranchtable'] = 'Добавить информационную страницу / оглавление раздела';
$string['addanendofbranch'] = 'Добавить конец раздела';
$string['addanewpage'] = 'Добавить новую страницу';
$string['addaquestionpage'] = 'Добавить страницу с вопросом';
$string['addaquestionpagehere'] = 'Добавить сюда страницу с вопросом';
$string['addbranchtable'] = 'Добавить информационную страницу / оглавление раздела';
$string['addcluster'] = 'Добавить кластер';
$string['addedabranchtable'] = 'Добавлена информационная страница / оглавление раздела';
$string['addedanendofbranch'] = 'Добавлен конец раздела';
$string['addedaquestionpage'] = 'Добавлена страница с вопросом';
$string['addedcluster'] = 'Добавлен кластер';
$string['addedendofcluster'] = 'Добавлен конец кластера';
$string['addendofcluster'] = 'Добавить конец кластера';
$string['addpage'] = 'Добавить страницу';
$string['anchortitle'] = 'Начало основного содержимого';
$string['and'] = 'И';
$string['answer'] = 'Ответ';
$string['answeredcorrectly'] = 'ответили правильно';
$string['answersfornumerical'] = 'Ответы для числового вопроса сравниваются с парой, состоящей из минимального и максимального значения';
$string['arrangebuttonshorizontally'] = 'Расположить кнопки горизонтально?';
$string['attempt'] = 'Попытка: {$a}';
$string['attempts'] = 'Попытки';
$string['attemptsdeleted'] = 'Удаленные попытки';
$string['attemptsremaining'] = 'У вас осталось {$a} попыток';
$string['available'] = 'Лекция доступна с';
$string['averagescore'] = 'Средний балл';
$string['averagetime'] = 'Среднее время';
$string['branch'] = 'Содержимое';
$string['branchtable'] = 'Список разделов';
$string['cancel'] = 'Отменить';
$string['cannotfindanswer'] = 'Ошибка: ответ не найден';
$string['cannotfindattempt'] = 'Ошибка: попытка не найдена';
$string['cannotfindessay'] = 'Ошибка: не удалось найти эссе';
$string['cannotfindfirstgrade'] = 'Ошибка: не удалось найти оценки';
$string['cannotfindfirstpage'] = 'Невозможно найти первую страницу';
$string['cannotfindgrade'] = 'Ошибка: не удалось найти оценки';
$string['cannotfindnewestgrade'] = 'Ошибка: не удалось найти новую оценку';
$string['cannotfindnextpage'] = 'Резервная копия лекции: следующая страница не найдена!';
$string['cannotfindpagerecord'] = 'Добавить конец раздела: запись страницы не найдена';
$string['cannotfindpages'] = 'Не удалось найти страницы лекции';
$string['cannotfindpagetitle'] = 'Подтвердить удаление: заголовок страницы не найден';
$string['cannotfindpreattempt'] = 'Запись предыдущих попыток не может быть найдена!';
$string['cannotfindrecords'] = 'Ошибка: не удалось найти записи лекции';
$string['cannotfindtimer'] = 'Ошибка: не удалось найти записи таймера лекции';
$string['cannotfinduser'] = 'Ошибка: не удалось найти пользователей';
$string['canretake'] = 'Разрешены переэкзаменовки';
$string['casesensitive'] = 'Использовать регулярные выражения';
$string['casesensitive_help'] = 'При включении этого параметра можно будет указывать регулярные выражения для проверки ответов.';
$string['checkbranchtable'] = 'Проверить страницу содержания';
$string['checkedthisone'] = 'Выбрали этот ответ.';
$string['checknavigation'] = 'Испытать навигацию';
$string['checkquestion'] = 'Испытать карточку вопроса';
$string['classstats'] = 'Статистика класса';
$string['clicktodownload'] = 'Щелкните по следующей ссылке, чтобы загрузить файл';
$string['clicktopost'] = 'Нажмите здесь, чтобы опубликовать Вашу оценку в списке лучших результатов.';
$string['closebeforeopen'] = 'Невозможно обновить лекцию. Вы указали дату завершения до даты начала.';
$string['cluster'] = 'Кластер';
$string['clusterjump'] = 'Непросмотренный вопрос в кластере';
$string['clustertitle'] = 'Заголовок кластера';
$string['collapsed'] = 'Свернуто';
$string['comments'] = 'Ваши комментарии';
$string['completed'] = 'Лекция завершена';
$string['completederror'] = 'Завершить лекцию';
$string['completethefollowingconditions'] = 'Вы должны выполнить следующие условия в лекции <b>{$a}</b> перед тем, как сможете продолжить.';
$string['conditionsfordependency'] = 'Условия для зависимости';
$string['configactionaftercorrectanswer'] = 'Действие по умолчанию после правильного ответа';
$string['configmaxanswers'] = 'По умолчанию максимальное количество ответов на страницу';
$string['configmaxhighscores'] = 'Количество отображаемых высоких баллов';
$string['configmediaclose'] = 'Отображает кнопку закрытия всплывающего окна, созданного для связанного медиа-файла';
$string['configmediaheight'] = 'Устанавливает высоту всплывающего окна, в котором отображается  связанный медиа-файл';
$string['configmediawidth'] = 'Устанавливает ширину всплывающего окна, в котором отображается  связанный медиа-файл';
$string['configslideshowbgcolor'] = 'Цвет фона для слайд-шоу, если оно включено';
$string['configslideshowheight'] = 'Устанавливает высоту слайд-шоу, если оно включено';
$string['configslideshowwidth'] = 'Устанавливает ширину слайд-шоу, если оно включено';
$string['confirmdelete'] = 'Удалить страницу';
$string['confirmdeletionofthispage'] = 'Подтвердите удаление этой страницы';
$string['congratulations'] = 'Поздравления - лекция завершена';
$string['continue'] = 'Продолжить';
$string['continuetoanswer'] = 'Продолжить изменение ответов.';
$string['continuetonextpage'] = 'Перейти к следующей странице';
$string['correctanswerjump'] = 'Переход при правильном ответе:';
$string['correctanswerscore'] = 'Баллы за правильный ответ';
$string['correctresponse'] = 'Комментарий на правильный ответ';
$string['createaquestionpage'] = 'Создать страницу с вопросом';
$string['credit'] = 'Кредит';
$string['customscoring'] = 'Баллы за каждый вариант ответа';
$string['customscoring_help'] = '<p>Эта опция позволит вам определить оценку за каждый ответ в вопросе. Ответы могут иметь отрицательные или положительные значения оценки. Для импортированных вопросов автоматически будет задана 1 для правильных ответов и 0 для неправильных, но это можно будет изменить после импорта.</p>';
$string['deadline'] = 'Крайний срок сдачи';
$string['defaultessayresponse'] = 'Ваше эссе будет оценено преподавателем курса.';
$string['deleteallattempts'] = 'Удалить все попытки пройти урок';
$string['deletedefaults'] = 'Удалено {$a} умолчаний урока';
$string['deletedpage'] = 'Страница удалена';
$string['deletepagenamed'] = 'Удалить страницу: {$a}';
$string['deleting'] = 'Удаление';
$string['deletingpage'] = 'Удаление страницы: {$a}';
$string['dependencyon'] = 'Эта лекция зависит от';
$string['dependencyon_help'] = 'Этот параметр позволяет ограничить доступ к этой лекции в зависимости от результата студента в другой лекции этого курса. Может быть использована любая комбинация из параметров «Затраченное время», «Лекция завершена» или «Оценка выше, чем...»';
$string['description'] = 'Описание';
$string['detailedstats'] = 'Подробная статистика';
$string['didnotanswerquestion'] = 'Студент не ответил на этот вопрос.';
$string['didnotreceivecredit'] = 'Кредит не получен';
$string['displaydefaultfeedback'] = 'Использовать комментарий по умолчанию';
$string['displaydefaultfeedback_help'] = 'Если параметр включен, то при выборе конкретного ответа (в случае отсутствия комментария к нему) будет показан комментарий по умолчанию - «Это правильный ответ» или «Это неправильный ответ».';
$string['displayhighscores'] = 'Показать лучшие результаты';
$string['displayinleftmenu'] = 'Показывать в меню?';
$string['displayleftif'] = 'Минимальная оценка для отображения меню лекции';
$string['displayleftif_help'] = 'Этот параметр определяет, должен ли студент получить определенную оценку, чтобы увидеть меню лекции. Это можно использовать для того, чтобы при первой попытке студент обязательно прошёл всю лекцию, а затем, после получения необходимой оценки, он мог воспользоваться меню при повторном просмотре.';
$string['displayleftmenu'] = 'Показывать меню';
$string['displayleftmenu_help'] = 'При включенном параметре будет отображаться меню, с помощью которого пользователи смогут перемещаться по списку страниц.';
$string['displayofgrade'] = 'Показать оценки (только для студентов)';
$string['displayreview'] = 'Давать возможность повторно ответить на вопрос';
$string['displayreview_help'] = 'При включении этого параметра после каждого неправильного ответа студенту будет предложено либо попробовать ответить на вопрос ещё раз (уже без получения баллов) либо просто продолжить лекцию.';
$string['displayscorewithessays'] = '<p>Вы получили {$a->score} баллов из {$a->tempmaxgrade} за вопросы, оцененные автоматически.</p>
<p> Оценки за {$a->essayquestions} эссе будут поставлены и учтены позднее при выставлении итоговой оценки.</p>
<p>Ваша текущая оценка (без учета эссе): {$a->score} из {$a->grade}</p>.';
$string['displayscorewithoutessays'] = 'Оценка за ответы на вопросы: {$a->score} из {$a->grade}';
$string['edit'] = 'Редактировать';
$string['editingquestionpage'] = 'Редактирование страницы с вопросом {$a}';
$string['editlessonsettings'] = 'Редактировать настройки лекции';
$string['editpage'] = 'Редактировать содержимое страницы';
$string['editpagecontent'] = 'Редактировать страницу';
$string['email'] = 'Email';
$string['emailallgradedessays'] = 'Разослать ВСЕ оцененные эссе';
$string['emailgradedessays'] = 'Разослать оцененные эссе';
$string['emailsuccess'] = 'Сообщение отправлено';
$string['emptypassword'] = 'Пароль не может быть пустым';
$string['endofbranch'] = 'Конец раздела';
$string['endofcluster'] = 'Конец кластера';
$string['endofclustertitle'] = 'Конец кластера';
$string['endoflesson'] = 'Конец лекции';
$string['enteredthis'] = 'ввели это.';
$string['entername'] = 'Введите ник для показа в списке лучших результатов';
$string['enterpassword'] = 'Пожалуйста, введите пароль:';
$string['eolstudentoutoftime'] = 'Внимание! Время прохождения лекции закончилось, поэтому Ваш последний ответ мог быть не учтен, если Вы ответили на вопрос за пределами отпущенного времени.';
$string['eolstudentoutoftimenoanswers'] = 'Вы не ответили ни на один вопрос. Вы получили 0 за эту лекцию.';
$string['essay'] = 'Эссе';
$string['essayemailmessage'] = '<p>Задание на эссе: <blockquote>{$a->question}</blockquote></p><p>Ваш ответ:<blockquote><em>{$a->response}</em></blockquote></p><p>{$a->teacher}:<blockquote><em>{$a->comment}</em></blockquote></p><p>Вы получили {$a->earned} из {$a->outof} за это эссе.</p><p>Ваша оценка за лекцию была изменена на {$a->newgrade}%.</p>';
$string['essayemailmessage2'] = '<p> Эссе: <blockquote> {$a->question} </blockquote></p><p> Ваш ответ: <blockquote> <em>{$a->response}</em> </blockquote></p><p> Комментарии преподавателя: <blockquote> <em>{$a->comment}</em> </blockquote></p><p> Вы получили {$a->earned} из {$a->outof} за это эссе. </p><p> Ваша оценка за лекцию была изменена и равна {$a->newgrade}%. </p>';
$string['essayemailsubject'] = 'Ваша оценка за ответ на {$a} вопрос(а)';
$string['essays'] = 'Эссе';
$string['essayscore'] = 'Баллы за эссе';
$string['eventessayassessed'] = 'Эссе оценено';
$string['eventessayattemptviewed'] = 'Просмотрен ответ на задание типа «Эссе»';
$string['eventhighscoreadded'] = 'Высшие баллы добавлены';
$string['eventhighscoresviewed'] = 'Высшие баллы просмотрены';
$string['eventlessonended'] = 'Лекция закончена';
$string['eventlessonstarted'] = 'Лекция начата';
$string['false'] = 'Неверно';
$string['fileformat'] = 'Формат файла';
$string['finish'] = 'Завершить';
$string['firstanswershould'] = 'Первый ответ должен переводить на «правильную» страницу';
$string['firstwrong'] = 'Вы ответили неправильно. Хотите снова попробовать ответить на вопрос? (Даже в случае верного ответа его результат не будет засчитан в Вашей итоговой оценке.)';
$string['flowcontrol'] = 'Контроль прохождения';
$string['fractionsaddwrong'] = 'Положительные оценки в сумме не составляют 100%. <br />Их сумма {$a}%.<br /> Вы хотите вернуться и исправить этот вопрос?';
$string['fractionsnomax'] = 'Один из ответов должен быть оценен в 100%, чтобы за этот вопрос можно было получить оценку. Вы хотите вернуться и исправить вопрос?';
$string['full'] = 'Развернуто';
$string['general'] = 'Общие';
$string['gotoendoflesson'] = 'Перейти к концу лекции';
$string['grade'] = 'Оценка';
$string['gradebetterthan'] = 'Оценка выше, чем (%)';
$string['gradebetterthanerror'] = 'Получить оценку выше, чем {$a} процентов.';
$string['gradeessay'] = 'Оценить эссе ({$a->notgradedcount} не оценены и {$a->notsentcount} не отправлены)';
$string['gradeis'] = 'Оценка: {$a}';
$string['gradeoptions'] = 'Параметры выставления оценки';
$string['handlingofretakes'] = 'Обработка результатов попыток';
$string['handlingofretakes_help'] = 'Если повторно прохождение лекции разрешено, то этот параметр определяет, будет ли оценка за лекцию средней или максимальной из оценок за все попытки.';
$string['havenotgradedyet'] = 'Пока не оценено.';
$string['here'] = 'здесь';
$string['highscore'] = 'Высший результат';
$string['highscores'] = 'Высшие результаты';
$string['hightime'] = 'Наибольшее время';
$string['importcount'] = 'Импортировано вопросов: {$a}';
$string['importquestions'] = 'Импортировать вопросы';
$string['importquestions_help'] = 'Эта функция позволяет из внешнего текстового файла импортировать вопросы в различных форматах.';
$string['insertedpage'] = 'Страница вставлена';
$string['invalidfile'] = 'Неверный файл';
$string['invalidid'] = 'Не был указан ID модуля или ID лекции';
$string['invalidlessonid'] = 'ID лекции некорректен';
$string['invalidpageid'] = 'Неверный ID страницы';
$string['jump'] = 'Переход';
$string['jumps'] = 'Переходы';
$string['jumps_help'] = 'Каждый ответ (для вопросов) или описание (для страниц содержания) имеет соответствующий переход. Переход может быть относительным, например «текущая страница» или «следующая страница», или абсолютным, указывающим на любую из страниц лекции.';
$string['jumpsto'] = 'Переход к <em>{$a}</em>';
$string['leftduringtimed'] = 'Вы просрочили время, отведенное на прохождение лекции. <br/> Щелкните по кнопке «Продолжить», чтобы начать лекцию заново.';
$string['leftduringtimednoretake'] = 'Вы просрочили время, отведенное на прохождение лекции и не можете продолжить её или пройти заново.';
$string['leftduringtimedsession'] = 'Вы просрочили время, отведенное на прохождение лекции';
$string['lesson:addinstance'] = 'Добавить новую лекцию';
$string['lessonattempted'] = 'Лекция начата';
$string['lessonclosed'] = 'Эта лекция закрылась {$a}.';
$string['lessoncloses'] = 'Лекция закрывается';
$string['lessoncloseson'] = 'Лекция закрывается {$a}';
$string['lesson:edit'] = 'Редактировать лекцию';
$string['lessonformating'] = 'Форматирование лекции';
$string['lesson:grade'] = 'Оценивать  в лекции ответы на вопросы эссе';
$string['lesson:manage'] = 'Управлять лекцией';
$string['lessonmenu'] = 'Меню лекции';
$string['lessonnotready'] = 'Лекция не готова. Пожалуйста, свяжитесь с {$a}';
$string['lessonnotready2'] = 'Эту лекция ещё не готова к просмотру.';
$string['lessonopen'] = 'Эта лекция откроется {$a}';
$string['lessonopens'] = 'Лекция открывается';
$string['lessonpagelinkingbroken'] = 'Первая страница не найдена. Вероятно, связи страниц лекции нарушены. Пожалуйста, свяжитесь с администратором.';
$string['lessonstats'] = 'Статистика лекции';
$string['linkedmedia'] = 'Связанное медиа';
$string['loginfail'] = 'Логин неверный, пожалуйста, попробуйте еще раз...';
$string['lowscore'] = 'Низший балл';
$string['lowtime'] = 'Наименьшее время';
$string['manualgrading'] = 'Оценить эссе';
$string['matchesanswer'] = 'Соответствие для ответа';
$string['matching'] = 'На соответствие';
$string['matchingpair'] = 'Соответствующие пары {$a}';
$string['maxgrade'] = 'Максимальная оценка';
$string['maxgrade_help'] = 'Этот параметр определяет максимальную оценку за лекцию в диапазоне от 0 до 100%. Если значение параметра установлено в 0, то лекция не отображается на страницах, содержащих оценки.';
$string['maxhighscores'] = 'Число отображаемых лучших результатов';
$string['maximumnumberofanswersbranches'] = 'Максимальное количество ответов/переходов';
$string['maximumnumberofanswersbranches_help'] = 'Этот параметр определяет максимальное число ответов, которое может быть использовано на страницах лекции. Например, если используются только ответы «Верно/Неверно», то можно установить значение 2. Этот параметр можно изменять в любое время, так как он влияет только на представление для преподавателя, на ранее введенные данные он не влияет.';
$string['maximumnumberofattempts'] = 'Максимальное количество попыток';
$string['maximumnumberofattempts_help'] = 'Этот параметр определяет максимальное разрешенное количество попыток ответа на каждый вопрос. При неоднократном неправильном ответе и достижении максимума, отображается следующая страница лекции.';
$string['maximumnumberofattemptsreached'] = 'Достигнуто максимальное количество попыток - переходим к следующей странице';
$string['maxtime'] = 'Ограничение по времени (в минутах)';
$string['maxtimewarning'] = 'У Вас осталось {$a} минут(а), чтобы завершить лекцию.';
$string['mediaclose'] = 'Показать кнопку закрытия';
$string['mediafile'] = 'Файл во всплывающем окне';
$string['mediafile_help'] = 'Выберите нужный файл, чтобы в начале лекции показать его в всплывающем окне. Каждая страница лекции будет содержать ссылку, чтобы при необходимости вновь открыть всплывающее окно.';
$string['mediafilepopup'] = 'Щелкните здесь для просмотра.';
$string['mediaheight'] = 'Высота всплывающего окна';
$string['mediawidth'] = 'Ширина всплывающего окна';
$string['messageprovider:graded_essay'] = 'Уведомление об оценке эссе';
$string['minimumnumberofquestions'] = 'Минимальное количество вопросов';
$string['minimumnumberofquestions_help'] = 'Этот параметр определяет минимальное количество вопросов, которые будут использоваться для расчета оценки.';
$string['missingname'] = 'Пожалуйста, введите имя';
$string['modattempts'] = 'Разрешить студентам повторное прохождение';
$string['modattempts_help'] = 'При включении этого параметра студенты могут снова пройти лекцию с самого начала.';
$string['modattemptsnoteacher'] = 'Только студенты могут повторно проходить лекцию.';
$string['modulename'] = 'Лекция';
$string['modulename_help'] = 'Активный элемент «Лекция» позволяет преподавателю располагать контент и/или практические задания (тесты) в интересной и гибкой форме. Преподаватель может использовать линейную схему лекции, состоящую из ряда обучающих страниц или создать древовидную схему, которая содержит различные пути или варианты для учащегося. В любом случае для увеличения активного взаимодействия и контроля понимания преподаватели могут использовать различные вопросы, такие как Множественный выбор, На соответствие и Короткий ответ. В зависимости от выбранного студентом ответа и стратегии, разработанной преподавателем, студенты могут перейти на другую страницу, возвратиться на предыдущую страницу или быть перенаправленными совершенно по другому пути.

Лекцию можно оценивать, оценки записываются в журнал оценок.

Лекции могут быть использованы

* Для самостоятельного изучения новой темы
* Для сценариев или упражнений по моделированию/принятию решений
* Для различающегося контроля, с разными наборами вопросов в зависимости от ответов на первые вопросы.';
$string['modulenameplural'] = 'Лекции';
$string['move'] = 'Переместить страницу';
$string['movedpage'] = 'Страница';
$string['movepagehere'] = 'Переместить страницу сюда';
$string['movepagenamed'] = 'Переместить страницу: {$a}';
$string['moving'] = 'Переместить страницу: {$a}';
$string['multianswer'] = 'Множественный ответ';
$string['multianswer_help'] = 'Установите флажок, если есть более одного варианта правильного ответа.';
$string['multichoice'] = 'Множественный выбор';
$string['multipleanswer'] = 'Множественный ответ';
$string['nameapproved'] = 'Имя принято';
$string['namereject'] = 'Извините, выбранное Вами имя не может быть принято. <br/> Попробуйте ввести другое имя.';
$string['new'] = 'новый';
$string['nextpage'] = 'Следующая страница';
$string['noanswer'] = 'На один или несколько вопросов не получено ответа. Пожалуйста, вернитесь и представьте ответ.';
$string['noattemptrecordsfound'] = 'Записи о попытках не найдены: Нет полученных оценок';
$string['nobranchtablefound'] = 'Не найдены страницы оглавлений разделов';
$string['nocommentyet'] = 'Пока комментариев нет.';
$string['nocoursemods'] = 'Элементы курса не найдены';
$string['nocredit'] = 'Нет кредита';
$string['nodeadline'] = 'Нет сроков';
$string['noessayquestionsfound'] = 'В этой лекции нет вопросов типа «Эссе»';
$string['nohighscores'] = 'Нет высоких результатов.';
$string['nolessonattempts'] = 'Не было попыток пройти лекцию.';
$string['nooneansweredcorrectly'] = 'Никто не ответил правильно на этот вопрос.';
$string['nooneansweredthisquestion'] = 'Никто не ответил на этот вопрос.';
$string['noonecheckedthis'] = 'Никто не выбрал этот ответ.';
$string['nooneenteredthis'] = 'Никто не ввёл этот текст.';
$string['noonehasanswered'] = 'Никто еще не написал эссе.';
$string['noretake'] = 'Вы не можете пройти заново эту лекцию.';
$string['normal'] = 'Обычное - согласно пути лекции';
$string['notcompleted'] = 'Лекция не завершена';
$string['notdefined'] = 'Не определено';
$string['notenoughsubquestions'] = 'Было указано недостаточное количество подвопросов!<br />Вы хотите вернуться к редактированию вопроса?';
$string['nothighscore'] = 'Вы не набрали необходимых баллов в списке {$a} лучших.';
$string['notitle'] = 'Без заголовка';
$string['numberofcorrectanswers'] = 'Количество правильных ответов: {$a}';
$string['numberofcorrectmatches'] = 'Количество правильных соответствий: {$a}';
$string['numberofpagestoshow'] = 'Количество показываемых страниц';
$string['numberofpagestoshow_help'] = 'Этот параметр определяет количество страниц, отображаемых в лекции. Он применим только для лекций со страницами, отображаемыми в случайном порядке (когда параметр «Действие после правильного ответа»  установлен на «Показать непросмотренную страницу»  или «Показать страницу с пропущенным ответом»). Если параметр равен нулю, то все страницы отображаются.';
$string['numberofpagesviewed'] = 'Количество просмотренных страниц : {$a}';
$string['numberofpagesviewednotice'] = 'Количество вопросов, на которые дан ответ: {$a->nquestions} (Вы должны ответить минимум на {$a->minquestions})';
$string['numerical'] = 'Числовой';
$string['ongoing'] = 'Отображать текущий балл';
$string['ongoingcustom'] = 'К настоящему времени Вы заработали баллов: {$a->score}  из {$a->currenthigh} возможных.';
$string['ongoing_help'] = 'При включении этого параметра студент будет видеть на каждой странице количество полученных баллов из максимума возможных на текущий момент.';
$string['ongoingnormal'] = 'Вы ответили правильно на {$a->correct} вопрос(ов) из {$a->viewed} просмотренных.';
$string['onpostperpage'] = 'Только одна проводка каждой оценки';
$string['options'] = 'Параметры';
$string['or'] = 'ИЛИ';
$string['ordered'] = 'Упорядоченно';
$string['other'] = 'Другие параметры';
$string['outof'] = 'Из {$a}';
$string['overview'] = 'Обзор';
$string['overview_help'] = 'Лекция состоит из нескольких страниц и, возможно, страниц содержания. Страница содержит некоторое содержимое и обычно заканчивается вопросом. Каждый ответ на вопрос связан с переходом. Переход может быть относительным (например, «Текущая страница» или «Следующая страница») или абсолютным (с указанием любой из страниц лекции). Страница содержания - это страница лекции, содержащая набор ссылок (например, оглавление) на другие страницы.';
$string['page'] = 'Страница: {$a}';
$string['pageanswers'] = 'Страница ответов';
$string['pagecontents'] = 'Содержание страницы';
$string['page-mod-lesson-edit'] = 'Редактировать страницу лекции';
$string['page-mod-lesson-view'] = 'Просмотр или предпросмотр страницы лекции';
$string['page-mod-lesson-x'] = 'Любая страница лекции';
$string['pageresponses'] = 'Страница отзывов';
$string['pages'] = 'Страницы';
$string['pagetitle'] = 'Заголовок страницы';
$string['password'] = 'Пароль';
$string['passwordprotectedlesson'] = '{$a} - лекция, защищенная паролем';
$string['pleasecheckoneanswer'] = 'Пожалуйста, выберите один ответ';
$string['pleasecheckoneormoreanswers'] = 'Пожалуйста, выберите один или несколько ответов';
$string['pleaseenteryouranswerinthebox'] = 'Пожалуйста, введите свой ответ в поле';
$string['pleasematchtheabovepairs'] = 'Пожалуйста, поставьте в соответствие';
$string['pluginadministration'] = 'Управление лекцией';
$string['pluginname'] = 'Лекция';
$string['pointsearned'] = 'Полученные баллы';
$string['postprocesserror'] = 'Возникла ошибка при заключительной обработке!';
$string['postsuccess'] = 'Публикация успешна';
$string['practice'] = 'Тренировочная лекция';
$string['practice_help'] = 'Тренировочная лекция не отображается в журнале оценок.';
$string['preprocesserror'] = 'Произошла ошибка во время предварительной обработки!';
$string['prerequisitelesson'] = 'Зависимость от другой лекции';
$string['preview'] = 'Просмотр';
$string['previewlesson'] = 'Предпросмотр {$a}';
$string['previewpagenamed'] = 'Предварительный просмотр: {$a}';
$string['previouspage'] = 'Предыдущая страница';
$string['processerror'] = 'Возникла ошибка при обработке!';
$string['progressbar'] = 'Отображать индикатор выполнения';
$string['progressbar_help'] = 'При включении этого параметра в нижней части страниц лекции будет отображаться индикатор выполнения, показывающий примерный процент завершения лекции.';
$string['progressbarteacherwarning'] = 'Индикатор выполнения не отображается для {$a}';
$string['progressbarteacherwarning2'] = 'Вы не увидите индикатор выполнения, потому что можете редактировать эту лекцию.';
$string['progresscompleted'] = 'Вы прошли {$a}% лекции';
$string['qtype'] = 'Тип страницы';
$string['question'] = 'Вопрос';
$string['questionoption'] = 'Параметр вопроса';
$string['questiontype'] = 'Тип вопроса';
$string['randombranch'] = 'Случайное оглавление разделов';
$string['randompageinbranch'] = 'Страница случайного вопроса из раздела';
$string['rank'] = 'Ранг';
$string['rawgrade'] = 'Предварительная оценка';
$string['receivedcredit'] = 'Полученный кредит';
$string['redisplaypage'] = 'Повторно показать страницу';
$string['report'] = 'Отчет';
$string['reports'] = 'Отчеты';
$string['response'] = 'Отзыв';
$string['retakesallowed'] = 'Разрешить повторное прохождение';
$string['retakesallowed_help'] = 'Если параметр включен, то студенты смогут пройти лекцию более одного раза.';
$string['returnto'] = 'Вернуться к {$a}';
$string['returntocourse'] = 'Вернуться к курсу';
$string['review'] = 'Пересмотр';
$string['reviewlesson'] = 'Пересмотр лекции';
$string['reviewquestionback'] = 'Да, мне хотелось бы попробовать еще раз';
$string['reviewquestioncontinue'] = 'Нет, я просто хочу перейти к следующему вопросу';
$string['sanitycheckfailed'] = 'Ошибка при проверке: Эта попытка была удалена';
$string['savechanges'] = 'Сохранить изменения';
$string['savechangesandeol'] = 'Сохранить все изменения и перейти к концу лекции';
$string['savepage'] = 'Сохранить страницу';
$string['score'] = 'Баллы за ответ';
$string['score_help'] = 'Баллы используются только при включенном пользовательском оценивании. На каждый ответ может быть дан балл в числовом значении (положительном или отрицательном).';
$string['scores'] = 'Баллы';
$string['secondpluswrong'] = 'Не совсем правильно. Вы хотите попробовать еще раз?';
$string['selectaqtype'] = 'Выберите тип вопроса';
$string['shortanswer'] = 'Краткий ответ';
$string['showanunansweredpage'] = 'Показывать вопросы, оставшиеся без ответа';
$string['showanunseenpage'] = 'Показывать непросмотренные страницы';
$string['singleanswer'] = 'Одиночный ответ';
$string['skip'] = 'Пропустить навигацию';
$string['slideshow'] = 'Слайд-шоу';
$string['slideshowbgcolor'] = 'Цвет фона слайд-шоу';
$string['slideshowheight'] = 'Высота слайд-шоу';
$string['slideshow_help'] = 'Этот параметр отвечает за отображение лекции в режиме слайд-шоу, с фиксированными шириной и высотой.';
$string['slideshowwidth'] = 'Ширина слайд-шоу';
$string['startlesson'] = 'Начать лекцию';
$string['studentattemptlesson'] = '{$a->lastname} {$a->firstname} Номер попытки: {$a->attempt}';
$string['studentname'] = 'Имя студента {$a}';
$string['studentoneminwarning'] = 'Внимание! У Вас осталось меньше 1 минуты на завершение лекции.';
$string['studentresponse'] = 'Ответ студента {$a}';
$string['submit'] = 'Отправить';
$string['submitname'] = 'Отправить имя';
$string['teacherjumpwarning'] = 'В лекции используются переходы «{$a->cluster}» или «{$a->unseen}». Сейчас вместо них будет использован переход «Следующая страница». Зайдите как студент, чтобы протестировать эти переходы.';
$string['teacherongoingwarning'] = 'Текущий балл отображается только для студентов. Чтобы протестировать текущий балл, зайдите как студент.';
$string['teachertimerwarning'] = 'Таймер отображается только для студентов. Чтобы протестировать таймер, зайдите как студент.';
$string['thatsthecorrectanswer'] = 'Это правильный ответ';
$string['thatsthewronganswer'] = 'Это неправильный ответ';
$string['thefollowingpagesjumptothispage'] = 'Со следующих страниц осуществляется переход к этой странице';
$string['thispage'] = 'Текущая страница';
$string['timeisup'] = 'Время вышло';
$string['timeremaining'] = 'Оставшееся время';
$string['timespenterror'] = 'Вы должны работать с лекцией по меньшей мере {$a} минут';
$string['timespentminutes'] = 'Затраченное время (в минутах)';
$string['timetaken'] = 'Затраченное время';
$string['topscorestitle'] = '{$a} самых высоких баллов';
$string['true'] = 'Верно';
$string['truefalse'] = 'Верно/неверно';
$string['unabledtosavefile'] = 'Загруженный файл не может быть сохранен';
$string['unknownqtypesnotimported'] = 'Вопросы ({$a}) с неподдерживаемыми типами вопросов не были импортированы';
$string['unseenpageinbranch'] = 'Страница непросмотренного вопроса из раздела';
$string['unsupportedqtype'] = 'Неподдерживаемый тип вопроса ({$a})!';
$string['updatedpage'] = 'Страница обновлена';
$string['updatefailed'] = 'Обновление не произошло';
$string['updatepagenamed'] = 'Обновить страницу: {$a}';
$string['usemaximum'] = 'Максимальная оценка';
$string['usemean'] = 'Средняя оценка';
$string['usepassword'] = 'Защитить лекцию паролем';
$string['usepassword_help'] = 'При включении этого параметра для доступа к лекции потребуется указать пароль.';
$string['viewgrades'] = 'Посмотреть оценки';
$string['viewhighscores'] = 'Посмотреть список лучших результатов';
$string['viewreports'] = 'Просмотреть попытки ({$a->attempts}), завершенные {$a->student}';
$string['viewreports2'] = 'Просмотр завершенных попыток ({$a})';
$string['welldone'] = 'Отлично!';
$string['whatdofirst'] = 'Что Вы хотите сделать в первую очередь?';
$string['wronganswerjump'] = 'Переход при неправильном ответе';
$string['wronganswerscore'] = 'Баллы за неправильный ответ';
$string['wrongresponse'] = 'Комментарий на неправильный ответ';
$string['xattempts'] = 'попыток - {$a}';
$string['youhaveseen'] = 'Вы уже работали с этой лекцией.<br /> Хотите продолжить с того места, на котором Вы остановились?';
$string['youmadehighscore'] = 'Вы достигли одного из {$a} лучших результатов';
$string['youranswer'] = 'Ваш ответ';
$string['yourcurrentgradeis'] = 'Ваша текущая оценка: {$a}';
$string['yourcurrentgradeisoutof'] = 'Ваша текущая оценка: {$a->grade} из {$a->total}';
$string['youshouldview'] = 'Вы должны ответить, по меньшей мере на: {$a}';
