<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'pl', branch 'MOODLE_28_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Brak dostępu';
$string['accounts'] = 'Konta';
$string['addcategory'] = 'Dodaj kategorię';
$string['additionalhtml'] = 'Dodatkowy HTML';
$string['additionalhtml_desc'] = 'Te ustawienia pozwalają na określenie, jaki kod HTML zostanie dodany do każdej strony. Można tu ustawić kod HTML dodany w sekcji HEAD dokumentu, zaraz po otwarciu znacznika BODY lub tuż przed jego zamknięciem.<br />Pozwala to na tworzenie własnych nagłówków lub stopek każdej strony, czy włączanie wsparcia ze strony serwisów takich, jak Google Analytics, niezależnie od wybranej skórki serwisu.';
$string['additionalhtmlfooter'] = 'Zanim BODY jest zamknięte';
$string['additionalhtmlfooter_desc'] = 'Zawartość zostanie dodana do kodu strony tuż przed znacznikiem zamykającym sekcję BODY.';
$string['additionalhtmlhead'] = 'W ramach HEAD';
$string['additionalhtmlhead_desc'] = 'Zawartość zostanie dodana do kodu strony tuż przed znacznikiem zamykającym sekcję HEAD.';
$string['additionalhtml_heading'] = 'Dodatkowy HTML do dodania na każdej stronie.';
$string['additionalhtmltopofbody'] = 'Gdy BODY jest otwarte';
$string['additionalhtmltopofbody_desc'] = 'Zawartość zostanie dodana do kodu strony tuż przed znacznikiem otwierającym sekcję BODY.';
$string['admincategory'] = 'Kategoria: {$a}';
$string['adminseesall'] = 'Administratorzy mają wgląd we wszystko';
$string['adminseesallevents'] = 'Administratorzy widzą wszystkie wydarzenia';
$string['adminseesownevents'] = 'Administratorzy są tacy jak inni użytkownicy';
$string['advancedfeatures'] = 'Zaawansowane funkcje';
$string['allcountrycodes'] = 'Wszystkie kody kraju';
$string['allowbeforeblock'] = 'Lista dozwolonych IP będzie przetwarzana jako pierwsza';
$string['allowbeforeblockdesc'] = 'Domyślnie, najpierw porównywane są wpisy z listy zablokowanych adresów IP. Jeśli opcja jest zaznaczona, przed lista zablokowanych adresów IP przetwarzana jest lista otwartych adresów IP.';
$string['allowblockstodock'] = 'Zezwalaj blokom na umiejscowienie tego bloku';
$string['allowcategorythemes'] = 'Zezwól na kompozycje dla kategorii';
$string['allowcoursethemes'] = 'Zezwól na kompozycję kursów';
$string['allowediplist'] = 'Lista dozwolonych adresów IP';
$string['allowemailaddresses'] = 'Dozwolone domeny poczty elektronicznej';
$string['allowframembedding'] = 'Zezwalaj na umieszczanie ramek';
$string['allowframembedding_help'] = 'Zezwalaj na umieszczanie tej strony w ramkach na  zewnętrznych stronach. Włączenie tej funkcji nie jest zalecane ze względów bezpieczeństwa.';
$string['allowguestmymoodle'] = 'Zezwól gościom na dostęp do Mojej strony domowej';
$string['allowobjectembed'] = 'Zezwalaj na znaczniki EMBED i OBJECT';
$string['allowthemechangeonurl'] = 'Zezwalaj na zmiany szablonu graficznego w adresie URL';
$string['allowuserblockhiding'] = 'Zezwalaj użytkownikom na ukrywanie bloków';
$string['allowuserswitchrolestheycantassign'] = 'Zezwalaj użytkownikom bez możliwości przypisywania ról na ich przełączanie';
$string['allowuserthemes'] = 'Zezwalaj na kompozycje użytkowników';
$string['alternativefullnameformat'] = 'Alternatywny format pełnej nazwy';
$string['antivirus'] = 'Antywirus';
$string['appearance'] = 'Wygląd';
$string['aspellpath'] = 'Ścieżka do aspell';
$string['authentication'] = 'Uwierzytelnianie';
$string['authpreventaccountcreation'] = 'Nie pozwalaj na tworzenie kont przy uwierzytelnianiu';
$string['authpreventaccountcreation_help'] = 'Podczas uwierzytelnienia użytkownika zostaje założone jego konto, o ile jeszcze nie istnieje. Jeśli do uwierzytelniania wykorzystuje się zewnętrzną bazę danych, jak na przykład LDAP, lecz dostęp do strony ma być ograniczony wyłącznie do posiadaczy kont, tę opcję należy włączyć. Nowe konta będą w takim przypadku tworzone ręcznie lub poprzez przesłanie danych użytkowników. Uwaga: to ustawienie nie dotyczy uwierzytelniania MNet.';
$string['authsettings'] = 'Zarządzaj uwierzytelnianiem';
$string['autolang'] = 'Automatyczne wykrywanie języka';
$string['autologinguests'] = 'Automatyczne logowanie gości';
$string['availablelicenses'] = 'Dostępne licencje';
$string['availableto'] = 'Dostępne dla';
$string['backgroundcolour'] = 'Przezroczysty kolor';
$string['backups'] = 'Kopie zapasowe';
$string['backup_shortname'] = 'Użyj nazwy kursu w nazwie pliku kopii zapasowej';
$string['backup_shortnamehelp'] = 'Użyj nazwy kursu jako części nazwy pliku kopii zapasowej zamiast numeru ID kursu.';
$string['badwordsconfig'] = 'Wprowadź listę złych słów rozdzielone przecinkami';
$string['badwordsdefault'] = 'Jeżeli ręcznie edytowalna lista jest pusta, użyta będzie domyślna lista z paczki językowej.';
$string['badwordslist'] = 'Ręcznie robiona lista złych słów';
$string['blockediplist'] = 'Lista zablokowanych adresów IP';
$string['blockeditingmenu'] = 'Blokuj menu edycji';
$string['blockeditingmenu_desc'] = 'Jeżeli włączony, wiele ikon edytowanych bloków, pokazywanych podczas włączonej edycji będzie wyświetlanych w menu rozwijanym. To zmniejsza zawartość na ekranie przez ukrywanie ikon, dopóki nie zostaną użyte.';
$string['blockinstances'] = 'Użyć';
$string['blockmultiple'] = 'Wielokrotny';
$string['blockprotect'] = 'Chroń przed usunięciem';
$string['blockprotect_help'] = 'Wybrane bloki będą chronione przed usunięciem dla całego serwisu. Najczęściej to ustawienie stosuje się do ochrony bloków nawigacji i ustawień, których przywrócenie po skasowaniu może być bardzo utrudnione.';
$string['blocksettings'] = 'Zarządzaj blokami';
$string['blockunprotect'] = 'Niechroniony';
$string['bloglevel'] = 'Widoczność bloga';
$string['bookmarkadded'] = 'Dodano do zakładek';
$string['bookmarkalreadyexists'] = 'Ta strona jest już dodana do zakładek';
$string['bookmarkdeleted'] = 'Zakładka skasowana';
$string['bookmarkthispage'] = 'Dodaj stronę do zakładek';
$string['cacheapplication'] = 'Pamięć podręczna aplikacji';
$string['cacheapplicationhelp'] = 'Buforowane elementy są wspólne dla wszystkich użytkowników i wygasną z określonym TTL';
$string['cachejs'] = 'Obsługuj Javascript z wykorzystaniem pamięci podręcznej';
$string['cachejs_help'] = 'Pamięć podręczna dla Javascriptu i jego kompresja znacznie przyspieszają ładowanie stron. Ustawienie jest zalecane dla serwisów przeznaczonych dla użytkowników. Deweloperzy najczęściej jednak wyłączają tę opcję.';
$string['cacherequest'] = 'Pytanie o pamięć podręczną';
$string['cacherequesthelp'] = 'Specyficzna pamięć podręczna użytkownika, wygaśnie w przypadku gdy wniosek jest kompletny. Zaprojektowany w celu zastąpienia obszarów, w których używamy statycznych sklepów';
$string['cachesession'] = 'Pamięć podręczna sesji';
$string['cachesessionhelp'] = 'Pamięć podręczna konkretnego użytkownika, która wygasa kiedy sesja użytkownika kończy się. Zaprojektowane do złagodzenia napięć/rozrostu sesji.';
$string['cachesettings'] = 'Ustawienia pamięci podręcznej';
$string['caching'] = 'Buforowanie';
$string['calendarexportsalt'] = 'Dodatkowe dane kryptograficzne dla procesu eksportu kalendarza';
$string['calendarsettings'] = 'Kalendarz';
$string['calendartype'] = 'Typ kalendarza';
$string['calendartype_desc'] = 'Wybierz domyślny typ kalendarza dla całej witryny. To ustawienie może być zmienione w ustawieniach kursu lub przez użytkowników we własnym profilu.';
$string['calendar_weekend'] = 'Dni weekendowe';
$string['cannotdeletemodfilter'] = 'Nie możesz odinstalować \'{$a->filter}\', ponieważ jest on częscią modułu \'{$a->module}\' .';
$string['cannotuninstall'] = '{$a} nie można odinstalować';
$string['cfgwwwrootslashwarning'] = 'Zdefiniowałeś $CFG->wwwroot niewłaściwie w pliku config.php. Wstawiłeś znak \'/\' na końcu. Usuń znak, albo doświadczysz dziwnych zachowania jak <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Zdefiniowałeś $CFG->wwwroot niewłaściwie w pliku config.php. Adres URL nie pasuje do tego, którego używasz, aby otworzyć tą stronę. Popraw ustawienia albo doświadczysz dziwnych zachowań jak <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'zmiana';
$string['checkboxno'] = 'Nie';
$string['checkboxyes'] = 'Tak';
$string['choosefiletoedit'] = 'Wybierz plik do edycji';
$string['clamfailureonupload'] = 'Na niepowodzenie clam AV';
$string['cleanup'] = 'Uporządkuj';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 't';
$string['cliincorrectvalueerror'] = 'Błąd, niepoprawna wartość "{$a->value}" dla "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Nieprawidłowa wartość, spróbuj ponownie';
$string['clistatusdisabled'] = 'Status: wyłączony';
$string['clistatusenabled'] = 'Status: włączony';
$string['clistatusenabledlater'] = 'status: tryb konserwacji CLI może być włączone {$a}';
$string['clitypevalue'] = 'typ wartości';
$string['clitypevaluedefault'] = 'typ wartości, naciśnij Enter, aby użyć wartości domyślnej ({$a})';
$string['cliunknowoption'] = 'Nieznana opcja:
  {$a}
Proszę użyć pomocy.';
$string['cliupgradefinished'] = 'Uaktualnienie z wiersza poleceń zakończone pomyślnie.';
$string['cliupgradenoneed'] = 'Do zainstalowanej wersji {$s} nie są wymagane uaktualnienia. Dziękujemy za odwiedziny.';
$string['cliyesnoprompt'] = 'wpisz y (czyli tak) lub n (czyli nie)';
$string['commentsperpage'] = 'Komentarze wyświetlane na stronie';
$string['commonfiltersettings'] = 'Wspólne ustawienia filtrowania';
$string['commonsettings'] = 'Ustawienia podstawowe';
$string['componentinstalled'] = 'Zainstalowany komponent';
$string['computedfromlogs'] = 'Wyliczone z logów od {$a}.';
$string['condifmodeditdefaults'] = 'Ustawienia w tej sekcji staną się ustawieniami domyślnymi podczas tworzenia nowych aktywności. Można tu tez ustalić, które ustawienia aktywności mają status ustawień zaawansowanych.';
$string['confeditorhidebuttons'] = 'Wybierz przyciski które powinny być ukryte w edytorze HTML.';
$string['configallcountrycodes'] = 'Lista krajów, które można wybrać w kilku miejscach serwisu, na przykład w profilu użytkownika. Jeśli lista pozostanie pusta (domyślnie), zostanie wykorzystana lista z pliku countries.php standardowego angielskiego pakietu językowego, pochodząca ze standardu ISO 3166-1. W innych przypadkach można podać listę kodów krajów oddzielając je przecinkami, np. "GB,FR,ES". Jeśli do listy zostaną dopisane nowe, niestandardowe, kody, należy je dodać do pliku countries.php angielskiego i lokalnie wykorzystywanego pakietu językowego.';
$string['configallowassign'] = 'Zezwalaj użytkownikom o rolach z wiersza przypisywać role z kolumny';
$string['configallowblockstodock'] = 'Jeżeli opcja jest włączona i wspierana przez wybrane skórki, użytkownicy mogą zadokować bloki.';
$string['configallowcategorythemes'] = 'Jeśli włączysz tą opcję, będziesz mógł ustawić kompozycje dla kategorii. Ustawienie to będzie miało wpływ na wszystkie podrzędne kategorie. OSTRZEŻENIE: Włączenie kompozycji dla kategorii może mieć wpływ na wydajność.';
$string['configallowcoursethemes'] = 'Jeśli włączysz tą opcję, użytkownicy będą mieli możliwość użycia swoich własnych kompozycji. Kompozycje kursu napisują wszystkie inne wybrane kompozycje (strony, użytkownika, sesji)';
$string['configallowemailaddresses'] = 'Jeśli chcesz zastrzec adresy email do pewnych domen, dodaj te domeny do listy, oddzielając je spacją. Wszystkie inne domeny nie znajdujące się na liście zostaną odrzucone. Aby dodać subdomenę dodaj ją wykorzystując \'.\'. np <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'Jeśli włączone goście mają dostęp do Mojej strony domowej, w przeciwnym razie goście zostaną przekierowani do strony głównej';
$string['configallowobjectembed'] = 'Z powodu bezpieczeństwa, zwykli użytkownicy nie mają prawa wstawiania kodów HTML zawierających znaczniki EMBED i OBJECT. Może to być robione jedynie przez odpowiedni bezpieczny filtr dla multimediów. Jeśli jednak chcesz zezwolić na użycie tych tagów włącz tą opcję.';
$string['configallowoverride'] = 'Zezwalaj rolom po lewej stronie odrzucać role w każdej kolumnie***';
$string['configallowoverride2'] = 'Wybierz które role mogą być nadpisane przez rolę podaną w lewej kolumnie.<br />
Zwróć uwagę, że te ustawienia dotyczą tylko użytkowników którzy mają również włączone uprawnienia do moodle/role:override lub moodle/role:safeoverride.';
$string['configallowswitch'] = 'Wybierz, na jakie role może przełączyć się użytkownik, na podstawie ról już przypisanych. Oprócz dokonania wpisu w tej tabeli, żeby użytkownik mógł przełączać role musi mieć włączoną opcję moodle/role:switchroles.<br />Można przełączyć się tylko na role z włączoną opcją moodle/course:view, nie mając przy tym włączonej opcji moodle/site:doanything, więc niektóre opcje w tej tabeli są niedostępne.';
$string['configallowthemechangeonurl'] = 'Po włączeniu tej opcji możliwe jest zmienianie tematów poprzez dodanie:<br />?theme=nazwa_tematu do adresu URL, na przykład mymoodlesite.com/?theme=afterburner lub<br />&theme=nazwa_tematu do wewnętrznego adresu URL Moodle, np. mymoodlesite.com/course/view.php?id=2&theme=afterburner.';
$string['configallowuserblockhiding'] = 'Czy chcesz zezwolić użytkownikom aby mogli używać przyciski "pokaż/ukryj blok"? Ta funkcjonalność wykorzystuje wykorzystuje javascript i pozwala na indywidualne ukrywanie bloków przez użytkowników.';
$string['configallowuserswitchrolestheycantassign'] = 'Domyślnie, by użytkownicy mogli przełączać swoje role, wymagane jest włączenie opcji moodle/role:assign. Aktywowanie niniejszej opcji znosi tę konieczność i uzależnia role dostępne w menu „Przełącz na rolę” wyłącznie od zawartości tabeli „Pozwól na przypisywanie ról”. Zaleca się by ustawienia w tabeli „Pozwól na przypisywanie ról” nie pozwalały użytkownikom przełączyć się do ról o wyższych uprawnieniach niż aktualne.';
$string['configallowuserthemes'] = 'Jeśli włączysz tą opcję, pozwolisz użytkownikom używać ich własnych kompozycji. Kompozycje użytkownika mają pierwszeństwo przed kompozycjami strony (ale nie przed kompozycjami kursu)';
$string['configallusersaresitestudents'] = 'Czy w przypadku aktywności na stronie głównej WSZYSCY powinni być traktowani jako studenci? Jeżeli odpowiesz "Tak", każdy potwierdzony użytkownik będzie mógł skorzystać z tych aktywności jako student. Jeżeli odpowiesz "Nie", wtedy tylko użytkownicy, którzy są już uczestnikami co najmniej jednego kursu będą mogli wziąć udział w aktywnościach na stronie głównej. Tylko administratorzy i użytkownicy ze szczególnie przypisaną rolą mają uprawnienia nauczyciela w aktywnościach dostępnych na stronie głównej.';
$string['configauthenticationplugins'] = 'Wybierz wtyczki uwierzytelniania, których pragniesz użyć i uporządkuj je w odpowiedniej kolejności działania.';
$string['configautolang'] = 'Wykrywa domyślny język z ustawień przeglądarki. Jeśli opcja jest wyłączona wówczas zostaną wprowadzone ustawienia domyślne strony.';
$string['configautologinguests'] = 'Czy niezalogowani użytkownicy mają być zalogowani automatycznie jako gość jeśli wchodzą do kursu jako goście?';
$string['configbloglevel'] = 'To ustawienie pozwala określić stopień ograniczeń wyświetlania blogów. Ustawia ono zakres samego WYŚWIETLANIA. Nie dotyczy wpisów ani typów wpisów bloga. Jeżeli nie chcesz blogów, możesz je wyłączyć całkowicie.';
$string['configcalendarcustomexport'] = 'Włącz niestandardowy zakres dat eksportu kalendarza';
$string['configcalendarexportsalt'] = 'Ten przypadkowy tekst służy do poprawy bezpieczeństwa tokenów uwierzytelniających stosowanych do eksportu kalendarzy. Proszę pamiętać, że wszystkie tokeny będą unieważnione, jeśli zmienisz ten tekst.';
$string['configclamactlikevirus'] = 'Traktuj pliki jako wirusy';
$string['configclamdonothing'] = 'Traktuj pliki jako nie uszkodzone';
$string['configclamfailureonupload'] = 'Jeśli ustawiłeś clam ażeby skanowała załadowane pliki, lecz zostało to skonfigurowane niepoprawnie lub zawodzi z jakiś nieznanych powodów, co należy zrobić? Jeśli wybierzesz \'Traktuj pliki jak wirusy\', zostaną one przeniesione do obszaru kwarantanny, lub skasowane. Jeśli wybierzesz \'Zaakceptuj pliki\', pliki zostaną zwyczajnie przeniesione do katalogu docelowego. W innym przypadku, administratorzy  zostaną ostrzeżeni iż  clam zawiodła. Jeśli wybierzesz \'Traktuj pliki jak wirusy\', a clam z jakichś powodów zawiedzie (zazwyczaj ponieważ wprowadziłeś błędną ścieżkę), WSZYSTKIE pliki, które zostały załadowane będą przeniesione do oznaczonego obszaru kwarantanny, lub skasowane. Uważnie używaj tego ustawien';
$string['configcookiehttponly'] = 'Włącza nową funkcję PHP 5.2.0 - przeglądarki mają wysłać plik cookie tylko w prawdziwych żądaniach HTTP, cookie nie powinny być dostępne dla języków skryptowych. To nie jest dostępne we wszystkich przeglądarkach i może nie być w pełni zgodne z bieżącym kodem. Funkcja pomaga zapobiegać niektórym rodzajom ataków XSS.';
$string['configcookiesecure'] = 'Jeśli serwer akceptuje tylko połączenia https: zaleca się włączyć wysyłanie bezpiecznych ciasteczek. Jeśli włączono, upewnij się, że serwer nie akceptuje http:// lub ustaw stałe przekierowanie na https://. Kiedy adres <em>wwwroot</em> nie zaczyna się od https://, to ustawienie jest automatycznie wyłączone.';
$string['configcountry'] = 'Jeśli ustawisz tutaj kraj wtedy będzie on wybierany jako domyslny dla nowo towrzonych kont. Aby zmusić użytkowników do samodzielnego wyboru nie ustawiaj tutaj kraju.';
$string['configcourseoverviewfilesext'] = 'Lista oddzielonych przecinkami dozwolonych rozszerzeń plików podsumowania kursu';
$string['configcourseoverviewfileslimit'] = 'Max. liczba plików, które mogą być dołączone do podsumowania kursu';
$string['configcourserequestnotify'] = 'Wpisz użytkownika, który ma być powiadomiony, gdy nowy kurs jest zamówiony.';
$string['configcourserequestnotify2'] = 'Użytkownicy, którzy zostaną powiadomieni, gdy nowy kurs będzie zamówiony. Tylko użytkownicy, którzy mogą zatwierdzać zamówienia, są tutaj wymienieni.';
$string['configcoursesperpage'] = 'Wpisz liczbę kursów które mają być wyświetlone na stronę w liście kursów';
$string['configcourseswithsummarieslimit'] = 'Max. liczba kursów do wyświetlenia na liście kursów, włączając w to podsumowania przed wycofaniem się do prostszego wyświetlania.';
$string['configcronclionly'] = 'Jeśli zaznaczono, skrypt cron może być uruchamiany tylko z linii poleceń, a nie przez Internet. To ustawienie jest nadrzędne wobec  hasła cron poniżej.';
$string['configcronremotepassword'] = 'Oznacza to, że skryptu cron.php nie można uruchomić z poziomu przeglądarki internetowej bez podania hasła. Obowiązuje następująca składnia URL: <pre> http://site.example.com/admin/cron.php?password=naszeHaslo</pre> Jeśli pole jest puste, hasło nie jest wymagane.';
$string['configcurlcache'] = 'Czas ważności cache cURL w sekundach.';
$string['configcustommenuitems'] = 'Można tutaj skonfigurować własne menu, które będzie wyświetlane tematów. Każda linia zawiera tekst menu, link URL (opcjonalnie) i tytuł podpowiedzi (opcjonalnie), oddzielonych od siebie znakami pionowej kreski |. Można zbudować strukturę hierarchiczną za pomocą łączników. Na przykład: <pre>
Społeczność Moodle | http://moodle.org Moodle
-bezpłatne wsparcie | http://moodle.org/support -Moodle rozwój | http://moodle.org/development
--Moodle Tracker | http://tracker.moodle.org
--Moodle Docs | http://docs.moodle.org
-Moodle Nowości | http://moodle.org/news
Firma Moodle
-Moodle hosting | http://moodle.com/hosting -Moodle wsparcie | http://moodle.com/support </pre>';
$string['configdbsessions'] = 'Jeśli to ustawienie zostanie zaznaczone – pozwoli użyć bazy danych do przechowywania informacji o aktualnej sesji. Jest to szczególnie użyteczne dla dużych / często odwiedzanych stron lub stron budowanych na klastrach serwerów. Dla większości stron powinno zostać to odznaczone, a wówczas używany będzie dysk serwera. Należy zauważyć, że zmiana tego ustawienia w danej chwili wyloguje wszystkich aktualnie zalogowanych użytkowników (włączając w to również Ciebie).';
$string['configdebug'] = 'Jeśli włączysz tą opcję, wówczas zostanie pokazywanych więcej błędów w raporcie PHP. Ta opcja jest przydatna tylko dla programistów';
$string['configdebugdisplay'] = 'Włączone oznacza, że raporty błędów trafią na strony HTML. Jest to praktyczne, ale zakłóca nagłowni XHTML, JS, cookies i HTTP w ogóle. Wyłączone wyśle raporty do logów serwera, umożliwiając lepsze debugowanie. Ustawienie PHP error_log wskazuje, do którego dziennika pójdą raporty.';
$string['configdebugpageinfo'] = 'Włącz, jeśli chcesz aby informacje o stronie były wyświetlane w stopce strony.';
$string['configdebugsmtp'] = 'Włącz pełne debugowanie informacji podczas wysyłania wiadomości emailem na serwer SMTP.';
$string['configdebugvalidators'] = 'Włącz, jeśli chcesz mieć w stopce strony linki do zewnętrznych walidatorów  Być może trzeba będzie utworzyć nowego użytkownika o nazwie <em>w3cvalidator</em> i włączyć dostęp gościa. Zmiany te mogą umożliwić nieautoryzowany dostęp do serwera, nie należy włączać na oficjalnych witrynach';
$string['configdefaulthomepage'] = 'To determinuje stronę główną dla zalogowanych użytkowników';
$string['configdefaultrequestcategory'] = 'Kursy których żądają użytkownicy będą automatycznie umieszczane w tej kategorii';
$string['configdefaultrequestedcategory'] = 'Domyślna kategoria do umieszczania zamawianych kursów po ich zatwierdzeniu.';
$string['configdefaultuserroleid'] = 'Wszyscy zalogowani użytkownicy będą mieli uprawnienia roli, którą tu wymienisz na poziomie strony, DODATKOWO do innych ról, które mogą posiadać. Domyślną rolą jest \'Authenticated user\'. Zwróć uwagę, że nie będzie to wpływało negatywnie na inne role które posiadają użytkownicy, o ile nie stosujesz stanu Zabroń. Dzięki temu mamy gwarancję, że użytkownicy mają uprawnienia, których nie przydziela się na poziomie strony kursu (np. przeglądać forum dyskusyjne, zarządzać kalendarzem itd.).';
$string['configdeleteincompleteusers'] = 'Po tym okresie, stare i nie w pełni założone konta zostaną usunięte.';
$string['configdeleteunconfirmed'] = 'Jeśli używasz autentyfikacji przez email, jest to okres podczas, którego akceptowane będą potwierdzenia założenia konta. Po tym okresie niepotwierdzone konta zostaną usunięte.';
$string['configdenyemailaddresses'] = 'Aby zablokować adresy email z podanych domen należy wpisać je tutaj na listę. Jeśli chcesz zablokować wszystkie poddomeny poprzedź kropką całą domenę. Przykładowa lista: <strong>hotmail.com yahoo.co.uk .com.pl</strong> - zablokowane dwie domeny i wszystkie domeny z końcówką com.pl';
$string['configdisableuserimages'] = 'Wyłącz użytkownikom możliwość zmiany obrazków w profilu.';
$string['configdisplayloginfailures'] = 'Ta opcja pozwoli wyświetlać informacje wybranym użytkownikom o poprzednich nieprawidłowych próbach logowania.';
$string['configdndallowtextandlinks'] = 'Włącza lub wyłącza przeciąganie i upuszczanie linku i tekstu na stronie kursu, obok przeciągania i upuszczania plików. Należy pamiętać, że przeciąganie tekstu do Firefoxa lub między różnymi przeglądarkami jest zawodne i może skutkować brakiem wgrania danych, lub wgrania uszkodzonego tekstu.';
$string['configdoclang'] = 'Ten język będzie używany w linkach do stron dokumentacji.';
$string['configdocroot'] = 'Tutaj możesz zdefiniować ścieżkę do własnej dokumentacji moodle. Pamiętaj jednak aby zachować ten sam układ ścieżek i plików jak w przypadku dokumentacji dostępnej pod adresem http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Jeżeli włączysz tę opcję, linki do dokumentów Moodle będą pokazane w nowym oknie';
$string['configeditordictionary'] = 'Ta wartość będzie użyta jeśli aspell nie posiada słownika dla języka użytkownika';
$string['configeditorfontlist'] = 'Wybierz czcionki które powinny pojawić się w liście rozwijanej edytora.';
$string['configemailchangeconfirmation'] = 'Wymagaj potwierdzenia jeśli użytkownik zmieni swój adres email w profilu.';
$string['configenableblogs'] = 'Ten przełącznik zapewnia wszystkim stronom użytkowników własnego bloga.';
$string['configenablecalendarexport'] = 'Włącz eksport lub subskrypcję kalendarzy.';
$string['configenablecomments'] = 'Włącz komentarze';
$string['configenablecourserequests'] = 'To pozwala na zgłaszanie zapotrzebowania na kurs przez każdego użytkownika.';
$string['configenabledevicedetection'] = 'Umożliwia wykrywanie telefonów komórkowych, smartfonów, tabletów lub domyślnych urządzeń (komputery stacjonarne, laptopy, itp.) w celu stosowania tematów i innych funkcji.';
$string['configenablemobilewebservice'] = 'Włącz usługę mobilną wykorzystywaną przez oficjalną aplikację Moodle lub innych aplikacji. Aby uzyskać więcej informacji, zapoznaj się z {$a}';
$string['configenablerssfeeds'] = 'Ta opcja zezwala na działanie RSS na całej stronie. Właściwie aby zauważyć jakiekolwiek zmiany należy zezwolić na RSS także w trybach indywidualnych – idź do ustawień Trybów pod Ustawienia Administratora';
$string['configenablerssfeedsdisabled'] = 'To jest niemożliwe ponieważ wiadomości RSS są wyłączone na tej platformie. Aby to zmienić zmień ustawienia zmiennych w Konfiguracji Administracji.';
$string['configenablerssfeedsdisabled2'] = 'Kanały RSS zostały wyłączone na poziomie serwera. Musisz włączyć je wcześniej w Administracja serwisu - Serwer - RSS.';
$string['configenablesafebrowserintegration'] = 'Dodaje to opcję \'Wymagaj Safe Exam Browser\' do pola \'Zabezpieczenia przeglądarki" na formularzu ustawień quizu. Zobacz http://www.safeexambrowser.org/, aby uzyskać więcej informacji.';
$string['configenablestats'] = 'Jeśli wybierzesz \'tak\', cronjob Moodle będzie nadzorował logowania i generował statystyki. W zależności od ilości operacji na Twojej stronie realizacja tej opcji może chwilę potrwać. Jeśli zezwolisz na to, będziesz mógł obserwować interesujące wykresy i statystyki o każdym z twoich kursów lub o wszystkich równocześnie';
$string['configenabletrusttext'] = 'Moodle domyślnie wyczyści tekst, który przychodzi od użytkowników, aby usunąć wszelkie możliwe złe skrypty, media itd. mogące stwarzać ryzyko naruszenia bezpieczeństwa. System Zaufanej Treści jest sposobem nadania konkretnym użytkownikom, że ufa się możliwości zawarcia tych zaawansowanych właściwości w ich zawartości bez ingerencji. Aby uaktywnić ten system, na początku należy włączyć to ustawienie, a następnie zezwolić na Zaufaną Zawartość dla konkretnej roli Moodle. Tekst stworzony i ładowany przez takich użytkowników będzie oznaczony jako zaufany i nie będzie czyszczony przed wyświetleniem.';
$string['configenablewebservices'] = 'Usługi sieci Web pozwalają innym systemom zalogować się do tego Moodle i wykonywać na nim operacje. Dla bezpieczeństwa ta funkcja powinna być wyłączona, chyba że naprawdę jej potrzebujesz.';
$string['configenablewsdocumentation'] = 'Włączyć automatyczne generowanie dokumentacji webserwisów. Użytkownik może uzyskać dostęp do własnej dokumentacji na stronie bezpiecznych kluczy {$a}. Wyświetli się  dokumentacja tylko dla włączonych protokołów .';
$string['configerrorlevel'] = 'Wybierz ile ostrzeżeń PHP ma być wyświetlanych. Zazwyczaj nejlepszy w tym miejscu wybór to \'Normal\'.';
$string['configexportlookahead'] = 'Ile dni naprzód przyjąć podczas eksportu';
$string['configexportlookback'] = 'Ile dni wstecz przyjąć podczas eksportu';
$string['configextendedusernamechars'] = 'Opcja pozwala na użycie dowolnych znaków w nazwie użytkownika. Domyślne ustawienie na \'nie\' ogranicza nazwy użytkowników do znaków alfanumerycznych, podkreślenia (_), myślnika (-), kropki (.) oraz symbolu małpy (@).';
$string['configextramemorylimit'] = 'Niektóre skrypty (wyszukujące, tworzące kopie zapasowe lub cron) wymagają więcej pamięci. Ustaw większe wartości dla dużych witryn.';
$string['configfilterall'] = 'Filtruj wszystkie ciągi znaków, włączając w to nagłówki, tytuły, przyciski nawigacji itp. Zazwyczaj użyteczne podczas używania filtrów multilang, należy zauważyć, iż powoduje nadmierne obciążenie strony, przy niewielkich korzyściach';
$string['configfiltermatchoneperpage'] = 'Automatyczne linkowanie tworzy jedynie pojedynczy link do pierwszego wystąpienia tekstu znalezionego na stronie. Wszystkie następne są ignorowane.';
$string['configfiltermatchonepertext'] = 'Filtry automatycznego łączenia będą jedynie tworzyły pojedynczy link do pierwszego pasującego przykładu tekstu, znalezionego w każdym punkcie tekstu (np. zasób, blok) na  stronie. Wszystkie pozostałe zostaną zignorowane. To ustawienie jest ignorowane jeśli jedno z ustawień na stronie zostało zaznaczone jako \'Tak\'';
$string['configfilteruploadedfiles'] = 'Przepuszczaj wszystkie załadowane pliki HTML i tekstowe przez filtry zanim je pokażesz. Tylko załadowane pliki HTML albo żadne.';
$string['configforcelogin'] = 'Normalnie strona główna i zestawienie kursów (lecz nie same kursy) mogą być przeglądane bez logowania się na stronę. Jeśli chcesz wymusić na odwiedzającym konieczność zalogowania się, zanim wykona on JAKĄKOLWIEK czynność na stronie, wówczas powinieneś zaznaczyć to ustawienie.';
$string['configforceloginforprofiles'] = 'Zaznaczenie tego ustawienia zmusza odwiedzającego do zalogowania się na konkretne konto (nie jako gość) zanim zostanie przekierowany do stron profilu użytkownika. Jeśli wyłączysz to ustawienie, może okazać się, że niektórzy użytkownicy wysyłają reklamy (spam) lub inne niedozwolone treści w ich profilach, co będzie widoczne dla "reszty świata",';
$string['configfrontpage'] = 'Wybrane powyżej elementy zostaną wyświetlone na stronie głównej serwisu.';
$string['configfrontpagecourselimit'] = 'Maksymalna liczba kursów';
$string['configfrontpagecourselimithelp'] = 'Maksymalna liczba kursów, które mają być wyświetlane na stronie głównej witryny w spisie kursów.';
$string['configfrontpageloggedin'] = 'Wybrane powyżej elementy zostaną wyświetlone na stronie głównej gdy użytkownik jest zalogowany.';
$string['configfullnamedisplay'] = 'Ta opcja definiuje, jak zostaną wyświetlane pełne nazwy. Dla większości stron jednojęzycznych najkorzystniejszym ustawieniem jest domyślne "imiona + nazwisko", lecz możesz wybrać ukrywanie nazwisk lub pozostawić to do decyzji dla aktualnego pakietu językowego (niektóre języki mają inne reguły)';
$string['configgeoipfile'] = 'Lokalizacja pliku danych binarnych GeoIP City. Ten plik nie jest częścią dystrybucji Moodle i musi zostać pobrany osobno z <a href="http://www.maxmind.com/">MaxMind</a>. Można kupić wersję komercyjną lub używać w wersji bezpłatnej. <br /> Wystarczy pobrać <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> i rozpakować go do katalogu "{$a}" na serwerze.';
$string['configgetremoteaddrconf'] = 'Jeśli twój serwer jest za odwrotnym proxy, można użyć tego ustawienia, aby określić, które nagłówki HTTP zawierają poprawny zdalny adres IP. Nagłówki są czytane w kolejności, użyty będzie pierwszy dostępny.';
$string['configgradebookroles'] = 'Ustawienie umożliwia kontrolowanie kto pojawia się w dzienniku ocen. Użytkownicy muszą mieć co najmniej jedną z tych ról w kursie aby zostali wyświetleni w dzienniku ocen dla tego kursu.';
$string['configgradeexport'] = 'Które formaty eksportu dziennika ocen są podstawowymi metodami eksportowania ocen. Wybrane pluginy będą ustawiać i używać pola "ostatnio wyeksportowany" dla każdej oceny. W związku z tym wyeksportowane rekordy mogą być oznaczone jako "nowy" czy "aktualizowany". Jeśli nie jesteś pewien, nie zaznaczaj niczego.';
$string['confighiddenuserfields'] = 'Wybierz które pola informacji o użytkowniku pragniesz ukryć przed innymi użytkownikami, nie będącymi nauczycielami/administratorami. Ustawienie to reguluje poziom ochrony prywatności uczniów. Trzymaj klawisz CTRL w celu zaznaczenia wielu pól';
$string['configidnumber'] = 'Ta opcja określa czy (a) Użytkownicy nie są w ogóle proszeni o podanie numeru identyfikacyjnego ID, (b) Użytkownicy są proszeni o podanie numeru identyfikacyjnego ID, lecz mogą pozostawić pole pustym, lub (c) Użytkownicy są proszeni o podanie numeru identyfikacyjnego ID i nie mogą pozostawić pola pustym. Podany numer identyfikacyjny ID zostanie wyświetlony w ich Profilu';
$string['configintro'] = 'Na tej stronie możesz określić ilość zróżnicowanych konfiguracji, które pozwolą na prawidłową prace Moodle na Twoim serwerze. Nie należy się zbytnio tym przejmować – zazwyczaj ustawienia domyślne wystarczają w zupełności, a Ty zawsze możesz wrócić do tej strony później i zmienić te ustawienia';
$string['configintroadmin'] = 'Na tej stronie powinieneś skonfigurować  swoje główne konto administratora, które będzie zezwalało na całościowe kontrolowanie strony. Upewnij się, że podałeś bezpieczną nazwę użytkownika i hasło, jak również aktualny adres e-mail. W przyszłości możesz dodawać kolejne konta administratorów.';
$string['configintrosite'] = 'Ta strona pozwala na konfiguracje strony startowej i nazwę serwisu. Możesz wrócić później i zmienić te ustawienia używając menu administratora.';
$string['configiplookup'] = 'Po kliknięciu na adres IP (taki jak 34.12.222.93), taki jak w dzienniku zdarzeń, zostaje pokazana mapa z najlepszym trafieniem skąd może pochodzić dany adres IP. Istnieją różne pluginy z których można wybierać, każdy z nich ma swoje zalety i wady.';
$string['configkeeptagnamecase'] = 'Zaznacz, jeśli chcesz, aby w nazwach znaczników zachować wielkie-małe litery tak, jak wpisali je użytkownicy, którzy je stworzyli';
$string['configlang'] = 'Wybierz domyślny język dla całej strony. Użytkownicy mogą zmienić to ustawienie w menu języka lub profilu osobistym.';
$string['configlanglist'] = 'Pozostaw to pole czyste by umożliwić użytkownikom zmianę języka spośród zainstalowanych w tym Moodle. Jednakże możesz skrócić menu językowe przez wpisanie po przecinku, listy języków które chcesz. Na przykład: en, es_es, fr,it';
$string['configlangmenu'] = 'Wybierz zezwalanie (lub nie) na wyświetlanie menu zasad językowych na stronie głównej, stronie logowania itd. Nie ogranicza to możliwości ustawienia przez użytkownika preferowanego języka w jego własnym profilu';
$string['configlangstringcache'] = 'Buforuje wszystkie stringi językowe w skompilowanych plikach w katalogu danych. Jeśli tłumaczysz Moodle lub zmieniasz ciągi w kodzie źródłowym Moodle, możesz tę opcję wyłączyć. W przeciwnym razie pozostaw ją, aby serwer szybciej działał.';
$string['configlatinexcelexport'] = 'Wybierz kodowanie dla eksportu do Excel-a';
$string['configlocale'] = 'Wybierz lokalny format strony – spowoduje to zmianę wyświetlania formatu i języka danych. Informacje potrzebne do wyświetlania danych w formacie lokalnym muszą być zainstalowane w Twoim systemie operacyjnym (np. en_US lub es_ES). Jeśli nie wiesz co wybrać pozostaw to pole pustym';
$string['configloginhttps'] = 'Włączając tą opcję spowodujesz, że Moodle będzie używać bezpiecznego połączenia https tylko dla strony logowania (zapewnienie bezpiecznego logowania), a następnie powróci z powrotem do zwykłego http URL na zwykłej prędkości. UWAGA: to ustawienie WYMAGA, aby serwer zezwalał na specjalne połączenia https – jeśli nie MOŻE TO DOPROWADZIĆ DO SAMOCZYNNEGO ODRZUCENIA CIĘ Z TWOJEJ STRONY';
$string['configloglifetime'] = 'To ustawienie określa przedział czasu , z jakiego zostaną zachowane logowania na stronie. Logowania które nie mieszczą się w zaznaczonym przedziale czasowym są automatycznie usuwane. Zalecane jest zachowywać logowania tak długo, jak to tylko możliwe, w przypadku gdybyś ich potrzebował, lecz jeśli posiadasz bardzo zajęty serwer i w przeszłości miałeś problemy z jego wydajnością, wówczas możesz być zainteresowany ograniczeniem interesującego Cię przedziału czasu.
Wartości mniejsze niż 30 nie są zalecane, ponieważ wówczas statystyki mogą nie działać poprawnie';
$string['configlookahead'] = 'Dni do Lookahead';
$string['configmaxbytes'] = 'To ustawienie określa maksymalną wielkość plików, które można załadować na całą stronę. To ustawienie jest ograniczane przez ustawienie PHP upload_max_filesize oraz ustawienie Appache LimitRequestBody. Po kolei, limity wielkości plików, zakres wielkości przy wyborze poziomu kursu lub poziomu modułu';
$string['configmaxconsecutiveidentchars'] = 'Hasło nie może mieć więcej niż podaną liczbę kolejnych identycznych znaków. Użyj 0 aby wyłączyć tę opcję.';
$string['configmaxeditingtime'] = 'Ten parametr określa ile czasu jest przeznaczone na ponowną edycję wpisów i wpisów do słownika pojęć. Zazwyczaj 30 minut jest dobrą wartością. Po upływie tego czasu studenci nie mogą zmieniać już swoich wpisów.';
$string['configmaxevents'] = 'Maksymalna liczba nadchodzących wydarzeń';
$string['configmaxusersperpage'] = 'Max. liczba użytkowników wyświetlanych w selektorze użytkowników  w kursie, grupie, kohorcie, usług sieciowych, itd.';
$string['configmessaging'] = 'Czy wysyłanie wiadomości między użytkownikami ma być włączone?';
$string['configmessagingallowemailoverride'] = 'Zezwalaj użytkownikom na przesyłanie powiadomień na inny adres e-mail niż podany w profilu użytkownika';
$string['configmessagingdeletereadnotificationsdelay'] = 'Przeczytane powiadomienia mogą być usunięte w celu zaoszczędzenia miejsca. Po jakim czasie od przeczytania można je usunąć?';
$string['configmessaginghidereadnotifications'] = 'Ukryj przeczytane powiadomienia o wydarzeniach, takich jak wpisy na forum, podczas przeglądania historii wiadomości.';
$string['configminpassworddigits'] = 'Hasło musi zawierać conajmniej tyle cyfr.';
$string['configminpasswordlength'] = 'Hasło musi być conajmniej tak długie.';
$string['configminpasswordlower'] = 'Hasło musi zawierać conajmniej tyle małych liter.';
$string['configminpasswordnonalphanum'] = 'Hasło musi zawierać conajmniej tyle znaków nie znajdujących się w alfabecie.';
$string['configminpasswordupper'] = 'Hasło musi zawierać conajmniej tyle wielkich liter.';
$string['configmobilecssurl'] = 'Plik CSS, umożliwiający dostosowanie interfejsu aplikacji mobilnej.';
$string['configmodchooserdefault'] = 'Czy opcja "Wybór aktywności" powinna być domyślnie obecna?';
$string['configmycoursesperpage'] = 'Maksymalna liczba kursów, które będą wyświetlone na dowolnej liście kursów uzytkonika';
$string['configmymoodleredirect'] = 'To ustawienie zarządza przekierowaniami na /my dla logowania nie-administratorów i zmienia nagłówki strony najwyższego poziomu na /my';
$string['configmypagelocked'] = 'To ustawienie zapobiega edycji strony głównej przez nie-adminów';
$string['confignavcourselimit'] = 'Ogranicza liczbę kursów wyświetlanych przez użytkownika, który nie jest zalogowany lub nie jest zapisany na jakikolwiek kurs.';
$string['confignavshowallcourses'] = 'Jeśli opcja jest włączona, użytkownicy zobaczą kursy, do których są zapisani  zarówno w gałęzi Moje kursy jak i kursu w menu Nawigacja. Jeśli opcja jest wyłączona, użytkownicy zapisani będą widzieć tylko gałąź Moje kursy. Liczba wyświetlanych kursów nadal będzie ograniczona przez pole "(navcourselimit)", gdy użytkownik nie jest zalogowany lub nie jest zapisany na jakikolwiek kurs.';
$string['confignavshowcategories'] = 'Pokaż kategorie w menu Nawigacja. Kursy, do których użytkownik jest aktualnie zapisany, będą wyświetlane w gałęzi Moje kursy bez kategorii.';
$string['confignotifyloginfailures'] = 'Jeśli błędy logowania zostały zapisane mogą być wysłane e-maile powiadamiające o tym. Kto powinien mieć dostęp do tych powiadomień.”';
$string['confignotifyloginthreshold'] = 'Jeśli powiadomienia o błędnych loginach są aktywne, ile błędnych prób logowania przez jednego użytkownika lub jeden adres IP warto zachowywać';
$string['confignotloggedinroleid'] = 'Użytkownicy nie zalogowani na stronie będą mieli tę rolę zagwarantowaną w kontekście strony. W większości przypadków gość jest najbardziej pożądany, ale można chcieć utworzyć role które będą mniej lub bardziej ograniczone. Takie działania jak dodawanie komentarzy nadal wymagają żeby użytkownik był zalogowany.';
$string['configopentogoogle'] = 'Jeśli włączysz to ustawienie Google będzie mogło wejść do twojego serwisu jako Gość. Ponadto osoby wchodzące na swój serwis z użyciem linków znalezionych na Google będą automatycznie logowani jako goście. Pamiętaj, że dostęp do kursów będzie możliwy tylko wtedy gdy w poszczególnych kursach jest włączona dostęp dla gości.';
$string['configoverride'] = 'Zdefiniowane w pliku config.php';
$string['configpasswordpolicy'] = 'Włączenie tej opcji spowoduje, że Moodle będzie sprawdzał hasła użytkowników pod kątem zgodności z polityką haseł. Użyj ustawień poniżej by zdefiniować tę politykę. Ustawienia zostaną zignorowane jeśli ustawisz tę opcję na \'nie\'';
$string['configpasswordresettime'] = 'Określa ilość czasu potrzebnego ludziom na potwierdzenie prośby o zresetowanie hasła przed jego wygaśnięciem. Zazwyczaj 30 min. jest optymalną wartością.';
$string['configpathtoclam'] = 'Ścieżka dla programu antywirusowego calm. Najprawdopodobniej jest to /usr/bin/clamscan lub /usr/bin/clamdscan. Musisz podać ścieżkę aby program antywirusowy clam działał.';
$string['configpathtodu'] = 'Ścieżka do programu du (najczęściej jest to /usr/bin/du). Jeśli podasz w tym miejscu ścieżkę do tego programu wtedy wyświetlanie zawartości katalogów z dużą liczbą plików będzie wykonywane szybciej.';
$string['configperfdebug'] = 'Jeśli włączysz tą opcję wtedy w stopce stron standardowej kompozycji wyświetlana będzie informacja o wydajności.';
$string['configprofileroles'] = 'Lista ról, które są widoczne na stronie profilu użytkownika i uczestników.
';
$string['configprofilesforenrolledusersonly'] = 'Aby zablokować treści wpisywane przez  spamerów do opisów w automatycznie tworzonych profilach przez spamboty, opis w profilu jest zablokowany (niewidoczny) do czasu, użytkownik ten zapisze się do co najmniej jednego kursu.';
$string['configprotectusernames'] = 'Domyślnie forget_password.php, dotyczące zapomnianego hasła, nie wyświetla żadnych wskazówek które pozwoliłyby na odgadnięcie nazwy użytkownika lub adresu poczty elektronicznej.';
$string['configproxybypass'] = 'Lista oddzielonych przecinkami (częściowych) nazw hostów lub adresów IP, która powinna omijać proxy (np.: 192.168., .mojadomena.com)';
$string['configproxyhost'] = 'Jeśli ten <b>serwer</b> używa serwera proxy żeby dostac sie do Internetu wprowadź tutaj nazwę i port serwera proxy. Inaczej pozostaw puste.';
$string['configproxypassword'] = 'Hasło potrzebne do uzyskania dostępu do Internetu za pośrednictwem serwera proxy. Pozostaw puste, jeżeli hasło nie jest wymagane (rozszerzenie PHP cURL jest wymagane).';
$string['configproxyport'] = 'Jeżeli ten serwer wymaga wykorzystania komputera proxy, proszę o wprowadzenie portu proxy w tym miejscu.';
$string['configproxytype'] = 'Typ proxy (PHP5 i rozszerzenie cURL wymagane dla obsługi SOCKS5).';
$string['configproxyuser'] = 'Nazwa użytkownika potrzebne do uzyskania dostępu do Internetu za pośrednictwem serwera proxy. Pozostaw puste, jeżeli nie jest wymagana (rozszerzenie PHP cURL jest wymagane).';
$string['configquarantinedir'] = 'Jeśli chcesz, aby clam AV przeniósł zarażone pliki do katalogu kwarantanny, wskaż to tutaj. Na serwerze musi istnieć możliwość zapisywania do tego katalogu. Jeśli pozostawisz to pole pustym, lub jeśli określisz katalog który nie istnieje lub jest nie zapisywalny, zarażone pliki będą skasowane. Nie zapomnij o slashu na końcu';
$string['configrecaptchaprivatekey'] = 'Ciąg znaków używany do komunikacji między serwerem Moodle a serwerem reCAPTCHA. Uzyskaj go dla tej witryny, odwiedzając http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Ciąg znaków używany do wyświetlania elementu reCAPTCHA w formularzu rejestracji. Generowany przez http://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Pozwala wybrać kategorię przy żądaniu kursu.';
$string['configrequestedstudentname'] = 'Słowo definiujące studenta w kursach';
$string['configrequestedstudentsname'] = 'Słowo definiujące studentów w kursach';
$string['configrequestedteachername'] = 'Słowo definiujące nauczyciela w kursach';
$string['configrequestedteachersname'] = 'Słowo definiujące nauczycieli w kursach';
$string['configrequiremodintro'] = 'Wyłącz tę opcję, jeśli nie chcesz zmusić użytkowników do wprowadzenia opisu każdej aktywności.';
$string['configrunclamavonupload'] = 'Gdy włączone, Clam AV będzie skanował wszystkie załadowane pliki.';
$string['configrunclamonupload'] = 'Czy uruchamiać program Clam AV dla każdego wysyłanego pliku? Pamiętaj, że musisz ustawić właściwą ścieżkę do programu aby wykonywał skanowanie plików. (Clam AV jest darmowym programem antywirusowym dostępnym pod adresem: http://www.clamav.net/)';
$string['configsectioninterface'] = 'Interfejs';
$string['configsectionmail'] = 'poczta';
$string['configsectionmaintenance'] = 'Utrzymywanie (konserwacja)';
$string['configsectionmisc'] = 'Różne (Miscellaneous)';
$string['configsectionoperatingsystem'] = 'System operacyjny';
$string['configsectionpermissions'] = 'Uprawnienia';
$string['configsectionrequestedcourse'] = 'Żądania utworzenia kursów';
$string['configsectionsecurity'] = 'bezpieczeństwo';
$string['configsectionstats'] = 'Statystyki';
$string['configsectionuser'] = 'Użytkownik';
$string['configsecureforms'] = 'Moodle może używać dodatkowego poziomu zabezpieczeń podczas akceptowania danych pochodzących z różnych postaci stron web. Jeśli jest to zaznaczone ,wówczas parametr HTTP REFERER przeglądarki jest dodatkowo weryfikowany. W niektórych przypadkach może rodzić to problemy, jeśli użytkownik używa firewall’a (na przykład Zonealarm) skonfigurowanego na usuwanie HTTP REFERER z odwiedzanych stron web. Objawia się to \'zablokowaniem\'. Jeśli twoim użytkownicy mają problemy ze stroną logowania (na przykład) możesz chcieć odznaczyć to ustawienie, mimo iż, spowoduje to większą wrażliwość Twojej strony na prymitywne ataki hasłowe. Jeśli nie jesteś pewien pozostaw to ustawienie zaznaczone jako \'Tak\'';
$string['configsessioncookie'] = 'To ustawienie określa nazwę cookie używanego dla sesji Moodle. Jest to ustawienie opcjonalne, i użyteczne jedynie w celu unikania komplikujących cookies podczas uruchomienia kilku kopii Moodle działających w obrębie tej samej strony web';
$string['configsessioncookiedomain'] = 'To pozwala zmienić domenę, z której  ciasteczka Moodle są dostępne. Jest to przydatne przy dostosowywaniu Moodle (np. wtyczki uwierzytelniania lub zapisów), kiedy trzeba udostępniać informacje o sesji Moodle innej aplikacji internetowej w innej subdomenie. <strong>UWAGA: Zdecydowanie zaleca się, aby pozostawić ustawienie domyślne (puste) - nieprawidłowa wartość zablokuje możliwość logowania się do serwisu.</strong>';
$string['configsessioncookiepath'] = 'Jeśli musisz zmienić miejsce do którego przeglądarki przesyłają "ciasteczka" Moodle, możesz zmienić to ustawienie określając podkatalog twojej witryny (może lepiej: serwera). W przeciwnym przypadku domyślna wartość "/" powinna działać prawidłowo';
$string['configsessiontimeout'] = 'Jeśli użytkownicy zalogowani na tą stronę są bezczynni przez dłuższy czas (bez ładowania stron), są automatycznie wylogowywani (ich sesja zostaje zakończona). Ten parametr określa w/w przedział czasu.';
$string['configshowcommentscount'] = 'Pokaż liczbę komentarzy. Wywoła to jedną więcej kwerendę podczas wyświetlania linków komentarzy.';
$string['configshowicalsource'] = 'Pokazuje informacje źródłowe dla zdarzeń iCal';
$string['configshowsiteparticipantslist'] = 'Wszyscy z tych uczniów i nauczycieli będą zapisani w zestawieniu uczestników. Kto powinien mieć dostęp do tego zestawienia?';
$string['configsitedefaultlicense'] = 'Domyślna strona licencji';
$string['configsitedefaultlicensehelp'] = 'Domyślna licencja dla publikowania treści na tej stronie';
$string['configsitemaxcategorydepth'] = 'Maksymalna głębokość kategorii';
$string['configsitemaxcategorydepthhelp'] = 'Określa maksymalną głębokość pokazanych podkategorii';
$string['configslasharguments'] = 'Pliki (obrazy, załadowane pliki, itd.) są dostarczane poprzez skrypt używający ‘slash arguments’ (argumenty po ukośniku). Ta metoda pozwala na łatwiejsze używanie pamięci podręcznej przez przeglądarkę, serwery proxy itd. Niestety niektóre serwery PHP nie dopuszczają takiej metody, a więc jeśli masz problemy z przeglądaniem wgrywanych plików lub obrazów (np. zdjęć użytkowników), ustaw ten parametr na opcję pierwszą.';
$string['configsmartpix'] = 'Mając to, ikony są podawane przez skrypt PHP, który przeszukuje bieżący temat, następnie tematy nadrzędne, a później folder Moodle /pix. Zmniejsza to potrzebę odtworzenia plików graficznych w ramach tematów, ale ma niewielki koszt wykonania.';
$string['configstartwday'] = 'Początek tygodnia';
$string['configstatsfirstrun'] = 'To ustawienie określa jak odległe w czasie logowania powinny być zachowywane <b> pierwszy czas </b> w celu tworzenia statystyk przetwarzania. Jeśli zauważasz duży ruch na stronie i masz dzielone łącze, prawdopodobnie nie będzie dobrym rozwiązaniem ustawianie zbyt dużego przedziału czasowego, ponieważ może potrzebować na to zbyt długiego czasu i nazbyt obciążać dane źródłowe. (Należy zwrócić uwagę, iż dlatego ustawienia 1 miesiąc=28 dni. Na wykresach i generowanych raportach 1 miesiąc=1 miesiąc kalendarzowy.)';
$string['configstatsmaxruntime'] = 'Proces generowania statystyk może być dość intensywny, w celu jego ograniczenia użyj kombinacji tego pola i następnego do określenia kiedy statystyki mają być realizowane i przez jaki czas.';
$string['configstatsmaxruntime2'] = 'Przetwarzanie statystyk może być dość intensywny, określenie max. czasu pozwala na zbieranie statystyk w jednym dniu. Max. liczba dni przetwarzania w jednym wykonywaniu cron to 31.';
$string['configstatsmaxruntime3'] = 'Określ maksymalny dozwolony czas na obliczanie statystyk z jednego dnia pamiętając, że przetwarzanie statystyk bardzo obciąża serwer. Maksymalna liczba dni przetwarzanych w jednym wywołaniu cron jest określona poniżej.';
$string['configstatsruntimedays'] = 'Określa maksymalną liczbę dni przetwarzanych w każdej sesji obliczania statystyki. Kiedy statystyki są aktualne, tylko jeden dzień będzie przetwarzany. Można zmienić tę wartość w zależności od obciążenia serwera. Skróć okres, jeśli zależy ci na krótszych czasach wykonania crona';
$string['configstatsruntimestart'] = 'O której godzinie cronjob powinien rozpocząć proces generowania statystyk?';
$string['configstatsuserthreshold'] = 'To ustawienie określa minimalną liczbę użytkowników zapisanych na kurs, aby był on ujęty w statystykach.';
$string['configstrictformsrequired'] = 'Jeśli opcja jest włączona, w wymaganych polach w formularzach nie wystarczy wprowadzić samej spacji lub tylko białych znaków.';
$string['configstripalltitletags'] = 'Odznacz to ustawienie by zezwolić na kod HTML w aktywnościach i nazwach zasobów.';
$string['configsupportemail'] = 'Ten adres e-mail będzie widoczny dla użytkowników serwisu jako e-mail pomocy technicznej (na przykład, kiedy nowy użytkownik założy konto w serwisie). W przypadku pozostawienia pustego pola taki przydatny e-mail nie będzie dostępny dla użytkowników.';
$string['configsupportname'] = 'Imię osoby lub działu oferującego pomoc techniczną przez e-mail lub stronę internetową.';
$string['configsupportpage'] = 'Ta strona internetowa będzie widoczna dla użytkowników serwisu jako strona pomocy technicznej (na przykład, kiedy nowy użytkownik założy konto w serwisie). W przypadku pozostawienia pustego pola taka przydatna strona nie będzie dostępna dla użytkowników.';
$string['configthemedesignermode'] = 'Normalnie wszystkie obrazy motywu graficznego i arkusze stylów są buforowane w przeglądarkach i na serwerze przez bardzo długi czas, w związku z wydajnością. W przypadku projektowania motywów lub pisania kodu lepiej będzie włączyć ten tryb, aby nie korzystać ze zbuforowanej wersji. Ostrzeżenie: wtedy witryna będzie działać wolniej dla wszystkich użytkowników! Alternatywnie można również wyczyścić pamięć podręczną motywu ręcznie na stronie \'Wyboru kompozycji\'.';
$string['configthemelist'] = 'Pozostaw to pole puste jeśli chcesz zezwolić na używanie dowolnej kompozycji. Jeśli chcesz zawęzić listę dostępnych kompozycji możesz wpisać tutaj nazwy dostępnych kompozycji oddzielając je przecinkiem (Nie używaj spacji!). Na przykład: standard,orangewhite.';
$string['configtimezone'] = 'Masz możliwość ustawienia tutaj domyślnej strefy czasowej. Jest to główne ustawienie strefy czasowej dla wszelkich wyświetlanych dat – każdy użytkownik może weryfikować to ustawienie poprzez zdefiniowanie daty w swoim własnym profilu. ”Server time – wytyczne czasowe serwera” W tym miejscu będą powodowały odnoszenie się domyślnych ustawień Moodle do ustawień systemu operacyjnego serwera, lecz użycie ustawienia ”Server time w profilu użytkownika będzie powodowało odczytywanie czasu z tychże ustawień czasowych. Użycie cronjob-ów używających ustawień czasowych (o wyznaczonej godzinie dnia) będzie powodowało, iż będą one używały tego ustawienia strefy czasowej';
$string['configuseblogassociations'] = 'Czy użytkownicy powinni być w stanie kojarzyć wpisy na swoich blogach z kursami i modułami kursu?';
$string['configuseexternalyui'] = 'Zamiast korzystać z lokalnych plików, użyć plików online dostępnych na serwerach Yahoo. OSTRZEŻENIE: To wymaga połączenia z internetem lub  AJAX nie będzie działać na twojej witrynie. To ustawienie nie jest zgodne z witrynami korzystającymi z protokołu https:.';
$string['configuserquota'] = 'Maksymalna liczba bajtów, które użytkownik może przechowywać we własnym obszarze prywatnych plików. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Jeśli opcja jest włączona, odpowiednia gałąź menu Nawigacja zamiast nazwy \'Strony\' będzie wyświetlała krótką nazwę witryny.';
$string['configusetags'] = 'Czy funkcjonalność tagów ma być włączona w całym serwisie?';
$string['configvariables'] = 'Zmienne';
$string['configverifychangedemail'] = 'Umożliwia weryfikację adresów e-mail po ich zmianie poprzez sprawdzenie listy dopuszczalnych i zabronionych domen. Jeśli ta opcja jest wyłączona, domeny są tak weryfikowane tylko w przypadku tworzenia nowych użytkowników.';
$string['configvisiblecourses'] = 'Wyświetlaj kursy w ukrytych kategoriach normalnie';
$string['configwarning'] = 'Bądź ostrożny zmieniając te ustawienia - błędne wartości mogą powodować problemy.';
$string['configyuicomboloading'] = 'Ta opcja pozwala na optymalizację ładowania plików bibliotek YUI. To ustawienie powinno być włączone na witrynach produkcyjnych ze względu na wydajność.';
$string['confirmation'] = 'Potwierdzenie';
$string['confirmdeletecomments'] = 'Zamierzasz usunąć komentarze, czy jesteś pewien(a)?';
$string['confirmed'] = 'Potwierdzone';
$string['cookiehttponly'] = 'Tylko ciasteczka http';
$string['cookiesecure'] = 'Tylko bezpieczne ciasteczka';
$string['country'] = 'Domyślny kraj';
$string['coursecontact'] = 'Zarządzanie kursem';
$string['coursecontact_desc'] = 'To ustawienie pozwala na kontrolowanie kto jest wyświetlany w opisie kursu.';
$string['courselistshortnames'] = 'Wyświetl rozszerzone nazwy kursów (krótkie+pełne)';
$string['courselistshortnames_desc'] = 'Podczas wyświetlania listy kursów i na ekranach administracji, wyświetlaj zarówno Skrócone nazwy kursu, jak Pełne nazwy. W rzeczywistości, po włączeniu tego ustawienia, używany jest ciąg \'courseextendednamedisplay\', więc można go zmieniać za pomocą dostosowania języka.';
$string['coursemgmt'] = 'Dodaj/edytuj kursy';
$string['courseoverview'] = 'Przegląd kursów';
$string['courserequestnotify'] = 'Zgłaszanie zapotrzebowania na kursy';
$string['courserequestnotifyemail'] = 'Użytkownik {$a->user} poprosił o założenie nowego przedmiotu na {$a->link}';
$string['courserequests'] = 'Zamówienia kursów';
$string['courserequestspending'] = 'Żądania oczekujących kursów';
$string['courses'] = 'Kursy';
$string['coursesperpage'] = 'Ilość kursów co stronę';
$string['courseswithsummarieslimit'] = 'Kursy z limitem podsumowania';
$string['creatornewroleid'] = 'Rola Kreatora w nowych kursach';
$string['creatornewroleid_help'] = 'Jeśli użytkownik nie ma jeszcze uprawnień do zarządzania nowym kursem, jest on automatycznie zapisywany z wykorzystaniem tej roli.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Ustaw uruchamianie Cron-a tylko z linii poleceń';
$string['cronerrorclionly'] = 'Niestety, dostęp z internetu do tej strony został zablokowany przez administratora.';
$string['cronerrorpassword'] = 'Niestety, nie podałeś poprawnego hasła by uzyskać dostęp do tej strony.';
$string['cron_help'] = 'Skrypt cron.php pozwala modułom Moodle na wykonywanie określonych zadań "w tle", automatycznie według harmonogramu. Jest to np. rozsyłanie kopii nowych wpisów z forum. Należy spowodować, aby skrypt był uruchamiany regularnie, np. co 5 minut.';
$string['cronremotepassword'] = 'Hasło dla zdalnego dostępu do Cron-a';
$string['cronwarning'] = 'Skrypt <a href="cron.php">cron.php</a> nie był uruchamiany od co najmniej 24 godzin.';
$string['cronwarningcli'] = 'Skrypt konserwacyjny cli/cron.php nie został uruchomiony w ciągu przynajmniej 24 godzin.';
$string['ctyperequired'] = 'Rozszerzenie PHP ctype jest teraz wymagane przez Moodle w celu zwiększenia wydajności witryny i dla kompatybilności z wieloma językami.';
$string['curlcache'] = '"Czas życia" cache cURL';
$string['curlrequired'] = 'Rozszerzenie PHP cURL jest teraz wymagane przez Moodle, w celu komunikowania się z repozytoriami Moodle.';
$string['curltimeoutkbitrate'] = 'Bitrate używany przy obliczaniu limitów czasu cURL (kbps)';
$string['curltimeoutkbitrate_help'] = 'Ten parametr jest używany do obliczenia odpowiedniego limitu czasu podczas długotrwałych żądań cURL. W ramach tego obliczenia wysyłane jest żądanie HEAD HTTP w celu określenia rozmiaru zawartości. Ustawienie tej opcji na 0 wyłącza to żądanie.';
$string['currenttheme'] = 'Obecny schemat graficzny';
$string['customcheck'] = 'Inne kontrole';
$string['custommenu'] = 'Niestandardowe menu';
$string['custommenuitems'] = 'Elementy niestandardowego menu';
$string['customusermenuitems'] = 'Pozycja menu użytkownika';
$string['datarootsecurityerror'] = '<p><strong>OSTRZEŻENIE: LUKA BEZPIECZEŃSTWA!</strong></p><p>Twój główny katalog danych umieszczony jest w złym miejscu i przez to jest bezpośrednio dostępny z sieci. Oznacza to, że każdy użytkownik sieci internet może mieć dostęp do twoich prywatnych plików, a mogą być one użyte, aby uzyskać pełną kontrolę nad twoim serwisem!</p>
<p><em>Musisz</em> przenieść główny katalog danych ({$a}) <em>poza</em> katalog publicznie dostępny z sieci i uaktualnić ustawienie <code>$CFG->dataroot</code> w config.php .</p>';
$string['datarootsecuritywarning'] = 'Konfiguracja strony może nie być bezpieczna. Upewnij się, że główny katalog z danymi ({$a}) nie jest dostępny bezpośrednio z sieci.';
$string['dbsessions'] = 'Użyj bazy danych dla informacji sesji';
$string['debug'] = 'Komunikaty usuwania błędów';
$string['debugall'] = 'WSZYSCY: Pokaż wszystkie uzasadnione komunikaty naprawiania błędów PHP.';
$string['debugdeveloper'] = 'DEWELOPER: dodatkowe wiadomości dotyczące naprawiania błędów Moodle dla deweloperów.';
$string['debugdisplay'] = 'Wyświetl komunikaty błędów';
$string['debugging'] = 'Usuwanie błędów';
$string['debugminimal'] = 'MINIMALNIE: Pokaż tylko błędy krytyczne.';
$string['debugnone'] = 'ŻADNE: Nie pokazuj żadnych błędów ani komunikatów.';
$string['debugnormal'] = 'NORMALNE: Pokazuj błędy, ostrzeżenia i powiadomienia.';
$string['debugpageinfo'] = 'Pokaż stronę informacji';
$string['debugsmtp'] = 'Debuguj wysyłanie emaili';
$string['debugstringids'] = 'Pokaż oryginalne ciągi językowe';
$string['debugstringids_desc'] = 'Ta opcja jest przeznaczona dla tłumaczy. Kiedy jest włączona, jeśli doda się parametr \'strings=1\' do adresu URL żądania, obok każdego napisu pokaże się  identyfikator tego napisu i plik językowy, z którego pochodzi.';
$string['debugvalidators'] = 'Pokaż linki walidatora';
$string['defaultcity'] = 'Domyślne miasto';
$string['defaultcity_help'] = 'Miasto wprowadzone tutaj będzie domyślnym podczas tworzenia nowych kont użytkowników.';
$string['defaultformatnotset'] = 'Błąd podczas ustalania domyślnego formatu kursu. Proszę sprawdzić ustawienia strony.';
$string['defaulthomepage'] = 'Domyślna strona domowa dla użytkownika';
$string['defaultrequestcategory'] = 'Domyślna kategoria zapotrzebowania na kursy';
$string['defaultsettinginfo'] = 'Domyślna wartość: {$a}';
$string['defaultuserroleid'] = 'Domyślna rola dla wszystkich użytkowników';
$string['deleteincompleteusers'] = 'Wykasuj niepotwierdzonych  użytkowników po';
$string['deleteunconfirmed'] = 'Wykasuj niepotwierdzonych użytkowników po';
$string['deleteuser'] = 'Skasuj użytkownika';
$string['density'] = 'gęstość';
$string['denyemailaddresses'] = 'Niedozwolone domeny poczty elektronicznej';
$string['development'] = 'Rozwój';
$string['devicedetectregex'] = 'Wyrażenie regularne wykrywania urządzeń.';
$string['devicedetectregex_desc'] = '<p> Domyślnie Moodle wykrywa urządzenia typu domyślne (komputery stacjonarne, laptopy, itp.), mobilne (telefony i małe urządzenia przenośne), tablety (iPad, Android) i starszych (z Internet Explorer 6). Do tych typów można zastosować oddzielne motywy graficzne. Tu można wpisać wyrażenia regularne, które pozwalają na wykrycie dodatkowych typów urządzeń (są nadrzędne względem typów domyślnych). </p>
<p> Na przykład, możesz wpisać wyrażenie regularne \'/(MIDP-1.0|Maemo|Windows CE)/\', aby wykryć niektóre często używane telefony komórkowe i zwrócić  wartość "FeaturePhone". Wtedy  "FeaturePhone \'na selektorze motywu pojawi się wybór "FeaturePhone", co pozwoli na dodanie motywu, który będzie użyty na tych urządzeniach. Inne telefony nadal będą używać motywu wybranego dla mobilnych. </p>';
$string['devicedetectregexexpression'] = 'Wyrażenie regularne';
$string['devicedetectregexvalue'] = 'Zwróć wartość';
$string['devicetype'] = 'Typ urządzenia';
$string['disableuserimages'] = 'Wyłącz obrazki w profilu użytkownika';
$string['displayerrorswarning'] = '<p>Włączanie ustawienia PHP: <em>display_errors</em> nie jest zalecane na stronach komercyjnych, ponieważ komunikaty o błędach mogą ujawnić poufne informacje o twoim serwerze.</p>';
$string['displayloginfailures'] = 'Wyświetl nieudane logowania dla';
$string['dndallowtextandlinks'] = 'Upload linków/tekstu metodą przeciągnij-upuść';
$string['doclang'] = 'Język dla dokumentacji';
$string['docroot'] = 'Ścieżka bazowa dla Moodle Docs';
$string['doctonewwindow'] = 'Otwórz w nowym oknie';
$string['download'] = 'Pobierz';
$string['edithelpdocs'] = 'Edytuj dokumenty pomocy';
$string['editlang'] = '<b>Edytuj</b>';
$string['editorbackgroundcolor'] = 'Kolor tła';
$string['editordictionary'] = 'Edytor słownika';
$string['editorfontfamily'] = 'Rodzina czcionek';
$string['editorfontlist'] = 'Lista czcionek';
$string['editorfontsize'] = 'Rozmiar czcionki';
$string['editorhidebuttons'] = 'Ukryte przyciski';
$string['editorkillword'] = 'Filtr formatu słów';
$string['editorspelling'] = 'Edytor pisowni
';
$string['editorspellinghelp'] = 'Włącza lub wyłącza sprawdzanie pisowni. Jeśli włączone, <strong>aspell</strong> musi być zainstalowane na serwerze.';
$string['editstrings'] = 'Edytuj słowa albo łańcuchy znaków';
$string['emailchangeconfirmation'] = 'Potwierdzenie zmiany emaila';
$string['emoticonalt'] = 'Tekst alternatywny';
$string['emoticoncomponent'] = 'Komponent obrazka';
$string['emoticonimagename'] = 'Nazwa obrazu';
$string['emoticons'] = 'Emotikony';
$string['emoticons_desc'] = 'Na tej stronie pokazane są emotikony używane w witrynie. Aby usunąć wiersz z tabeli, zapisz formularz z pustą wartością w jednym z wymaganych pól. Aby wprowadzić nowy emotikon, wypełnij ostatni wiersz. Aby przywrócić wszystkie pola do wartości domyślnych, kliknij na link powyżej.
* Tekst (wymagane) - Ten tekst zostanie zastąpiony obrazem emotikona (r.męski wg słownika - przyp. tłum.). Musi mieć co najmniej dwa znaki.
* Nazwa obrazka (wymagane) - nazwa pliku obrazka emotikona bez rozszerzenia, względem katalogu pix.
* Komponent obrazka (wymagane) - komponent zawierający ikonę.
* Tekst alternatywny (opcjonalnie) - tekst zastępujący emotikon i jego komponent.';
$string['emoticonsreset'] = 'Resetuj ustawienia emotikon do wartości domyślnych';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Pusty';
$string['enableblogs'] = 'Włącz blogi';
$string['enablecalendarexport'] = 'Włącz eksportowanie kalendarza';
$string['enablecomments'] = 'Włącz komentarze';
$string['enablecourserequests'] = 'Włącz zgłaszanie zapotrzebowania na kursy';
$string['enablecssoptimiser'] = 'Włącz optymalizację CSS';
$string['enablecssoptimiser_desc'] = 'Po włączeniu CSS będzie uruchamiany przez proces optymalizacji zanim zostanie zbuforowany. Optymalizator przetwarza CSS, usuwa duplikaty reguł i stylów, a także białe znaki i ponownie formatuje. Należy pamiętać, że włączenie tego w tym samym czasie co tryb projektowania tematu jest okropne dla wydajności, ale może pomóc projektantom tematów stworzyć zoptymalizowany CSS.';
$string['enabled'] = 'Włączony';
$string['enabledevicedetection'] = 'Włącz wykrywanie urządzeń';
$string['enablegravatar'] = 'Włącz Gravatar';
$string['enablegravatar_help'] = 'Po włączeniu tej opcji Moodle spróbuje pobrać zdjęcie z profilu użytkownika z Gravatar, jeśli użytkownik nie dodał zdjęć.';
$string['enablemobilewebservice'] = 'Włącz mobilne usługi sieciowe';
$string['enablerecordcache'] = 'Włącz Record Cache';
$string['enablerssfeeds'] = 'Włącz kanały RSS';
$string['enablesafebrowserintegration'] = 'Włącz integrację Safe Exam Browser';
$string['enablestats'] = 'Włącz statystyki';
$string['enabletgzbackups'] = 'Włącz nowy format kopii zapasowej';
$string['enabletgzbackups_desc'] = 'Jeżeli opcja jest włączona, przyszłe kopie zapasowe będą tworzone w nowym formacie kompresji jako pliki .mbz (wewnętrznie przechowywane jako plik .tar.gz). To usuwa ograniczenie rozmiaru 4 GB kopii zapasowej i może przyczynić się do poprawy wydajności. Przywracanie obsługuje oba formaty i różnice powinny być widoczne dla użytkowników.';
$string['enabletrusttext'] = 'Zezwalaj na Zaufaną Zawartość';
$string['enablewebservices'] = 'Włącz usługi sieciowe';
$string['enablewsdocumentation'] = 'Dokumentacja usług sieciowych';
$string['enrolinstancedefaults'] = 'Domyślne ustawienia dla zapisów';
$string['enrolinstancedefaults_desc'] = 'Domyślne ustawienia zapisów w nowym kursie.';
$string['enrolmultipleusers'] = 'Zapisz użytkowników';
$string['environment'] = 'Środowisko';
$string['environmenterrortodo'] = 'Musisz usunąć wszystkie problemy (błędy) w środowisku serwera zanim rozpocznie się instalacja tej wersji Moodle!';
$string['environmenterrorupgrade'] = 'Ostrzeżenie: należy rozwiązać wszystkie znalezione powyżej problemy (błędy) środowiskowe przed przystąpieniem do aktualizacji tej wersji Moodle! Aktualizowanie bez rozwiązania tych wymagań może spowodować problemy tj. utratą danych. Czy jesteś pewny że chce kontynuować uaktualnianie?';
$string['environmentmustfixsetting'] = 'Ustawienia PHP muszą być zmienione.';
$string['environmentok'] = 'Środowisko twojego serwera spełnia minimalne wymagania.';
$string['environmentrecommendcustomcheck'] = 'Jeśli ten test się nie powiedzie, wskazuje to na potencjalne problemy';
$string['environmentrecommendinstall'] = 'jest zalecane, żeby było zainstalowane/włączone';
$string['environmentrecommendversion'] = 'wersja {$a->needed} jest zalecana a ty używasz wersji {$a->current}';
$string['environmentrequirecustomcheck'] = 'ten test musi być zaliczony';
$string['environmentrequireinstall'] = 'jest niezbędnę, żeby było zainstalowane/włączone';
$string['environmentrequireversion'] = 'wersja {$a->needed} jest niezbędna a ty używasz wersji {$a->current}';
$string['environmentsettingok'] = 'Wykryto zalecane ustawienia';
$string['environmentshouldfixsetting'] = 'Ustawienie PHP powinny być zmienione.';
$string['environmentxmlerror'] = 'Błąd odczytywania danych środowiska ({$a->error_code})';
$string['errordeletingconfig'] = 'Wystąpił błąd podczas usuwania danych konfiguracji wtyczki \'{$a}\'.';
$string['errorsetting'] = 'Nie można zapisać ustawień';
$string['errorwithsettings'] = 'Niektóre ustawienia nie zostały zmienione z powodu błędu';
$string['everyonewhocan'] = 'Każdy kto może \'{$a}\'';
$string['exceptions'] = 'wyjątki';
$string['execpathnotallowed'] = 'Ustawienie ścieżki wykonywalnej jest wyłączona w config.php';
$string['experimental'] = 'Eksperymentalne';
$string['experimentalsettings'] = 'Ustawienia eksperymentalne';
$string['extendedusernamechars'] = 'Zezwalaj na rozszerzony zestaw znaków w nazwach użytkowników';
$string['extramemorylimit'] = 'Dodatkowy limit pamięci PHP';
$string['fatalsessionautostart'] = '<p>Wykryto poważny błąd w konfiguracji, proszę powiadomić administratora serwera.</p><p> Aby działało prawidłowo, Moodle wymaga od administratora zmiany ustawień PHP.</p><p>
<code>session.auto_start</code> musi być ustawiony na <code>wyłączony</code>.</p><p> To ustawienie jest kontrolowane przez edycję <code>php.ini</code>, konfigurację <br /> Apache/IIS lub plik .htaccess na serwerze.</p>';
$string['filecreated'] = 'Nowy plik został utworzony';
$string['filestoredin'] = 'Zapisz plik w folderze';
$string['filestoredinhelp'] = 'Gdzie plik ma zostać zachowany';
$string['filterall'] = 'Filtruj wszystkie napisy';
$string['filtermatchoneperpage'] = 'Filtr dopasowuje raz co stronę';
$string['filtermatchonepertext'] = 'Filtr dopasowuje raz co tekst';
$string['filters'] = 'Filtry';
$string['filtersettings'] = 'Ustawienia filtrów';
$string['filtersettingsgeneral'] = 'Ogólne ustawienia dla filtra';
$string['filteruploadedfiles'] = 'Filtruj wgrane pliki';
$string['forcelogin'] = 'Zmuś użytkowników do zalogowania';
$string['forceloginforprofileimage'] = 'Zmuś użytkowników do logowania, aby wyświetlić zdjęcie w profilu.';
$string['forceloginforprofileimage_help'] = 'Jeśli opcja jest włączona, użytkownicy muszą być zalogowani, aby zobaczyć zdjęcia z profilu użytkownika, a we wszystkich powiadomieniach mailowych będzie używany domyślny obraz użytkownika.';
$string['forceloginforprofiles'] = 'Zmuś użytkowników do zalogowania do profili';
$string['forcetimezone'] = 'Wymuś domyślną strefę czasową';
$string['formatuninstallwithcourses'] = 'Istnieje {$a->count} kursów używające {$a->format}. Ich format zostanie zmieniony na {$a->defaultformat} (domyślny format dla tej strony). Niektóre dane specyficzne dla formatu mogą zostać utracone. Czy na pewno chcesz kontynuować?';
$string['frontpage'] = 'Strona główna';
$string['frontpagebackup'] = 'Kopia strony głównej';
$string['frontpagedefaultrole'] = 'Domyślna rola strony głównej';
$string['frontpagefilters'] = 'Filtry strony głównej';
$string['frontpageloggedin'] = 'Elementy strony głównej po zalogowaniu';
$string['frontpageoverrides'] = 'Strona główna nadpisuje uprawnienia';
$string['frontpagequestions'] = 'Pytania strony głównej';
$string['frontpagerestore'] = 'Odtwórz stronę główną';
$string['frontpageroles'] = 'Role strony głównej';
$string['frontpagesettings'] = 'Ustawienia strony głównej';
$string['fullnamedisplay'] = 'Format Pełnej Nazwy';
$string['fullnamedisplayprivate'] = 'Format pełnej nazwy - prywatny';
$string['gdrequired'] = 'Rozszerzenie GD jest teraz wymagane przez Moodle do konwersji obrazu.';
$string['generalsettings'] = 'Ogólne ustawienia';
$string['geoipfile'] = 'Plik danych dla GeoIP City';
$string['getremoteaddrconf'] = 'Źródło zalogowanego adresu IP';
$string['googlemapkey3'] = 'Klucz API Google Maps V3';
$string['googlemapkey3_help'] = 'Należy wprowadzić specjalny klucz, aby korzystać z Google Maps do wizualizacji wyszukiwania adresów IP. Możesz uzyskać klucz bezpłatnie na <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Idź do pierwszego brakującego łańcucha znaków';
$string['gradebook'] = 'Dziennik ocen';
$string['gradebookroles'] = 'Ocenione role';
$string['gradeexport'] = 'Podstawowa metoda eksportu ocen';
$string['gravatardefaulturl'] = 'URL domyślnego obrazu Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar wymaga domyślnego obrazu do wyświetlenia, gdy nie jest w stanie znaleźć zdjęcia danego użytkownika. Wpisz pełny adres URL obrazu. Jeśli zostawisz to pole puste, Moodle spróbuje użyć najbardziej odpowiedniego domyślnego obrazu dla przeglądanej strony. Należy zauważyć, że Gravatar zapewnia <a href="https://en.gravatar.com/site/implement/images/#default-image">obrazy domyślne</a> .';
$string['groupenrolmentkeypolicy'] = 'Zasady klucza dostępu dla grupy';
$string['groupenrolmentkeypolicy_desc'] = 'Włączając tą opcję Moodle będzie sprawdzał klucze dostępu dla grupy wykorzystując istniejące zasady klucza dostępu';
$string['guestroleid'] = 'Rola dla gości';
$string['guestroleid_help'] = 'Ta rola jest automatycznie przypisana do użytkownika gość. Jest ona również tymczasowo przydzielona do użytkowników, którzy wchodzą do kursu poprzez moduł zapisu gościa.';
$string['helpadminseesall'] = 'Czy administratorzy widzą wszystkie zdarzenia w kalendarzu czy tylko te które sami dopisali?';
$string['helpcalendarcustomexport'] = 'Włącz opcję eksportu niestandardowych zakresu dat w eksporcie kalendarza. Eksport kalendarza musi być włączony przed użyciem tego efektu.';
$string['helpexportlookahead'] = 'Ile dni w przyszłości kalendarza ma szukać wydarzeń podczas eksportu do niestandardowych opcji eksportu?';
$string['helpexportlookback'] = 'Ile dni w przeszłości kalendarza ma szukać wydarzeń podczas eksportu do niestandardowych opcji eksportu?';
$string['helpforcetimezone'] = 'Możesz pozowolić użytkownikom na indywidualny wybór strefy czasowej, lub wymusić strefę czasową dla wszystkich.';
$string['helpshowicalsource'] = 'Jeśli opcja jest włączona, nazwa subskrypcji i link zostanie pokazany dla importowanych wydarzeń iCal.';
$string['helpsitemaintenance'] = 'Do uaktualnień i do pozostałej pracy';
$string['helpstartofweek'] = 'Od jakiego dnia zaczyna się tydzień w kalendarzu';
$string['helpupcominglookahead'] = 'Jak wiele dni do przodu jest pokazywanych domyślnie w kalendarzu dla nadchodzących wydarzeń?';
$string['helpupcomingmaxevents'] = 'Jak wiele (maksymalnie) nadchodzących zdarzeń jest pokazywanych domyślnie użytkownikowi?';
$string['helpweekenddays'] = 'Które dni tygodnia są traktowane jako "weekend" i pokazywane innym kolorem?';
$string['hiddenuserfields'] = 'Ukryj pola użytkownika';
$string['hidefromall'] = 'Ukryj przed wszystkimi';
$string['hidefromnone'] = 'Nie ukrywaj';
$string['hidefromstudents'] = 'Ukryj przed uczniami';
$string['htmleditor'] = 'Edytor HTML';
$string['htmleditorsettings'] = 'Ustawienia edytora HTML';
$string['htmlsettings'] = 'Ustawienia HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Ochrona HTTP';
$string['hubs'] = 'Centra';
$string['iconvrequired'] = 'Instalacja rozszerzenia ICONV jest wymagana.';
$string['ignore'] = 'Ignoruj';
$string['includemoduleuserdata'] = 'Uwzględnij dane modułu użytkownika';
$string['incompatibleblocks'] = 'Niekompatybilne bloki';
$string['installhijacked'] = 'Instalacja musi być zakończona z oryginalnego adresu IP, przepraszamy.';
$string['installsessionerror'] = 'Nie można inicjalizować sesji PHP, upewnij się, że Twoja przeglądarka akceptuje pliki cookies.';
$string['intlrecommended'] = 'Rozszerzenie intl usprawnia obsługę wielu języków i np. zgodne z ustawieniami regionalnymi prawidłowe sortowanie.';
$string['invalidsection'] = 'Niewłaściwa sekcja';
$string['invaliduserchangeme'] = 'Nazwa "changeme" jest zarezerwowana - nie możesz użyć tej nazwy do stworzenia konta';
$string['ipblocked'] = 'Ta strona jest obecnie niedostępna.';
$string['ipblocker'] = 'Blokowanie IP';
$string['ipblockersyntax'] = 'Umieść każdy wpis w jednej linii. Poprawny wpis to: pełny adres IP (np. <b>192.168.10.1),</b> który pasuje do jednego hosta; częściowy adres (np. <b>192,168.),</b> który pasuje do każdego adresu rozpoczynającego się od tych liczb; notacja CIDR (np. <b>231.54.211.0/20)</b>; zakres adresów IP (np. <b>231.3.56.10-20),</b> gdzie zakres odnosi się do ostatniej części adresu. Tekstowe nazwy domen (jak \'example.com\') nie są obsługiwane. Puste wiersze są ignorowane.';
$string['iplookup'] = 'Wyszukaj adres IP';
$string['iplookupgeoplugin'] = 'Usługa <a href="http://www.geoplugin.com">geoPlugin</a> jest obecnie wykorzystywana do wyszukiwania informacji geograficznych. Na dokładniejsze wyniki zaleca się lokalną instalację kopii bazy danych MaxMind GeoLite.';
$string['iplookupinfo'] = 'Moodle domyślnej używa darmowego serwera NetGeo (Internet Database Geographic) do wyszukiwania lokalizacji adresów IP. Niestety ta baza danych nie jest już utrzymywana i może zwrócić <em>zupełne bzdury</em>. Zaleca się zainstalować lokalną kopię darmowej bazy danych GeoLite City od MaxMind. <br /> Lokalizacja IP wyświetlana jest na prostej mapce lub w Google Maps. Należy pamiętać, że trzeba mieć konto Google i uzyskać darmowy klucz API Google Maps, aby interaktywne mapy działały.';
$string['iplookupmaxmindnote'] = 'Ten produkt zawiera dane GeoLite stworzone przez MaxMind, dostępne na <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>. ';
$string['keeptagnamecase'] = 'Zachować wielkie-małe litery w tagach';
$string['lang'] = 'Domyślny język';
$string['langcache'] = 'Cache menu językowego';
$string['langcache_desc'] = 'Buforuj menu językowe. Jeśli opcja jest włączona, lista dostępnych tłumaczeń jest buforowana. Pamięć podręczna jest automatycznie odświeżana podczas instalacji lub usuwania paczki językowej za pośrednictwem wbudowanego narzędzia. Jeśli instalujesz nową paczkę językową ręcznie, trzeba użyć funkcji \'Wyczyść wszystkie bufory pamięci podręcznej\' w celu odświeżenia pamięci podręcznej.';
$string['langlist'] = 'Języki w menu językowym';
$string['langmenu'] = 'Wyświetl menu językowe';
$string['langpackwillbeupdated'] = 'Uwaga dla tłumaczy: Podczas uaktualniania, Moodle będzie próbował uaktualnić paczkę językową. Twoje własne modyfikacje języka robione poza lokalnym katalogiem będą nadpisane.';
$string['langstringcache'] = 'Buforuj wszystkie łańcuchy językowe';
$string['languagesettings'] = 'Ustawienia językowe';
$string['latinexcelexport'] = 'Kodowanie dla Excel-a';
$string['legacyfilesaddallowed'] = 'Zezwalaj na dodawanie do plików kursu';
$string['legacyfilesaddallowed_help'] = 'Jeżeli kurs ma pliki, zezwala nowym plikom i folderom na dodawanie do nich.';
$string['legacyfilesinnewcourses'] = 'Stare pliki kursu w nowym kursie';
$string['legacyfilesinnewcourses_help'] = 'Domyślnie pliki kursu starego formatu (wersja 1.9) są dostępne tylko w kursach, które były przeniesione z tej wersji. Uwaga: Niektóre funkcje, jak kopia zapasowa pojedynczej aktywności nie obsługują już takich plików.';
$string['licensesettings'] = 'Ustawienia licencji';
$string['linkadmincategories'] = 'Link do kategorii admina';
$string['linkadmincategories_help'] = 'Jeśli aktywny ustawienie kategorii admina będzie wyświetlane jako linki w nawigacji i będzie doprowadzać do kategorii stron administracyjnych.';
$string['loading'] = 'Ładowanie';
$string['localetext'] = 'Lokalizacja dla całego serwisu';
$string['localstringcustomization'] = 'Lokalne dostosowanie języka';
$string['location'] = 'Lokalizacja';
$string['locationsettings'] = 'Ustawienia lokalizacji';
$string['locked'] = 'zablokowany';
$string['lockoutduration'] = 'Czas trwania blokady konta';
$string['lockoutduration_desc'] = 'Zablokowane konto zostanie automatycznie odblokowane po tym czasie.';
$string['lockoutemailbody'] = 'Twoje konto z nazwą użytkownika {$a->username} na serwerze \'{$a->sitename}\' zostało zablokowane po wielu nieudanych próbach logowania.

Aby odblokować konto, natychmiast przejdź do poniższej strony

{$a->link}

W większości programów pocztowych, powinien pojawić się niebieski link, w który powinieś kliknąć. Jeżeli to nie zadziała, skopiuj i wklej adres do górnego paska adresowego okna przeglądarki.

Jeżeli potrzebujesz pomocy, proszę skontaktować się z administratorem strony,
{$a->admin}';
$string['lockoutemailsubject'] = 'Twoje konto na {$a} zostało zablokowane';
$string['lockouterrorunlock'] = 'Dostarczono nieprawidłowe informacje do odblokowania konta.';
$string['lockoutthreshold'] = 'Próg blokady konta';
$string['lockoutthreshold_desc'] = 'Wybierz liczbę nieudanych prób logowań, po których nastąpi blokada konta. Ta funkcja może być nadużywana w atakach typu DoS.';
$string['lockoutwindow'] = 'Okno obserwacji blokady konta';
$string['lockoutwindow_desc'] = 'Czas obserwacji dla progu blokady, jeżeli nie ma nieudanych prób logowania, licznik logowań zostanie zresetowany po tym czasie.';
$string['log'] = 'Dzienniki zdarzeń';
$string['logguests'] = 'Logi dostępu gości';
$string['logguests_help'] = 'To ustawienie umożliwia rejestrowanie działań konta gość i niezalogowanych użytkowników. Wiele profesjonalnych stron może żądać wyłączenia tego monitorowania z powodów wydajności. Zaleca się zachować to ustawienie na witrynach publicznych.';
$string['loginhttps'] = 'Użyj HTTPS do logowania';
$string['loginpageautofocus'] = 'Automatyczny fokus na stronie logowania';
$string['loginpageautofocus_help'] = 'Włączenie tej opcji poprawia użyteczność strony logowania, ale automatyczny fokus na polach niektórzy mogą uznać za problem z dostępnością.';
$string['loginpasswordautocomplete'] = 'Wyłącz automatyczne uzupełnianie hasła w formularzu logowania';
$string['loginpasswordautocomplete_help'] = 'Wyłączenie tej opcji pozwoli użytkownikom zapamiętywać swoje hasła w przeglądarce. Gdy włączysz to ustawienie, witryny nie będzie już zgodna z regułami poprawności XHTML Strict.';
$string['loglifetime'] = 'Zachowaj logi przez';
$string['logstorenotrequired'] = 'Magazyn logu nie jest wymagany';
$string['logstoressupported'] = 'Magazyny logów, które wspierają ten raport';
$string['longtimewarning'] = '<b>Zakończenie działania tego procesu może potrwać długo.</b>';
$string['maintenancemode'] = 'W trybie konserwacji';
$string['maintenancemodeisscheduled'] = 'Strona zostanie przełączona w tryb konserwacji za {$a} min.';
$string['maintfileopenerror'] = 'Błąd podczas otwierania plików konserwacyjnych!';
$string['maintinprogress'] = 'Konserwacja w trakcie...';
$string['manageformats'] = 'Zarządzaj formami kursów';
$string['manageformatsgotosettings'] = 'Domyślny format może być zmieniony w: {$a}';
$string['managelang'] = 'Zarządzaj';
$string['managelicenses'] = 'Zarządzaj licencjami';
$string['manageqbehaviours'] = 'Zarządzaj zachowaniem pytań';
$string['manageqtypes'] = 'Zarządzaj typami pytań';
$string['maturity100'] = 'Wersja beta';
$string['maturity150'] = 'Kandydat do wydania';
$string['maturity200'] = 'Wersja stabilna';
$string['maturity50'] = 'Wersja alfa';
$string['maturityallowunstable'] = 'Podpowiedź: możesz chcieć uruchomić ten skrypt z opcją --allow-unstable';
$string['maturitycoreinfo'] = 'Twoja witryna obecnie używa niestabilnej wersji kodu źródłowego - "{$a}"';
$string['maturitycorewarning'] = 'Wersja Moodle, którą zamierzasz zainstalować lub uaktualnić zawiera wersję niestabilną kodu &quot;{$a}&quot; który nie jest wskazana do stosowania w większości witryn produkcyjnych. Jeśli to nie było twoim zamiarem, upewnij się, że aktualizujesz do stabilnej gałęzi kodu Moodle. Więcej szczegółów znajdziesz w Dokumentacji Moodle.';
$string['maxbytes'] = 'Maksymalna wielkość załadowanego pliku';
$string['maxconsecutiveidentchars'] = 'Kolejne identyczne znaki';
$string['maxeditingtime'] = 'Maksymalny czas edycji komentarzy';
$string['maxtimelimit'] = 'Maksymalny czas limitu';
$string['maxtimelimit_desc'] = 'Aby ograniczyć maksymalny czas wykonania PHP, wprowadź tutaj wartość w sekundach. 0 oznacza, że są używane domyślne restrykcje Moodle. Jeżeli masz serwer nieprodukcyjny z własnym limitem czasu, ustaw tą wartość niżej aby otrzymywać błędy PHP w logach. Nie stosuje się tej opcji do skryptów CLI.';
$string['maxusersperpage'] = 'Maksymalna liczba użytkowników na stronie';
$string['mbstringrecommended'] = 'Zainstalowanie opcjonalnej biblioteki MBSTRING jest mocno zalecane, aby poprawić wydajność strony, szczególnie jeśli strona używa języków niełacińskich.';
$string['mediapluginavi'] = 'Włącz filtr dla plików .avi';
$string['mediapluginflv'] = 'Włącz filtr dla plików .flv';
$string['mediapluginimg'] = 'Włącz auto-osadzanie podlinkowanych obrazów';
$string['mediapluginmov'] = 'Włącz filtr dla plików .mov';
$string['mediapluginmp3'] = 'Włącz filtr dla plików .mp3';
$string['mediapluginmpg'] = 'Włącz filtr dla plików .mpg';
$string['mediapluginogg'] = 'Włącz filtr .ogg';
$string['mediapluginogv'] = 'Włącz filtr .ogv';
$string['mediapluginram'] = 'Włącz filtr dla plików .ram';
$string['mediapluginrm'] = 'Włącz filtr dla plików .rm';
$string['mediapluginrpm'] = 'Włącz filtr dla plików .rpm';
$string['mediapluginswf'] = 'Włącz filtr dla plików .swf';
$string['mediapluginswfnote'] = 'Jako domyślne zabezpieczenie, zwykli użytkownicy nie mogą umieszczać plików swf flash';
$string['mediapluginwmv'] = 'Włącz filtr dla plików .wmv';
$string['mediapluginyoutube'] = 'Włącz filtrowanie linków YouTube';
$string['messaging'] = 'Włącz system wymiany wiadomości';
$string['messagingallowemailoverride'] = 'Nadpisanie adresu email do powiadomień';
$string['messagingdeletereadnotificationsdelay'] = 'Usuń przeczytane powiadomienia';
$string['messaginghidereadnotifications'] = 'Ukryj przeczytane powiadomienia';
$string['minpassworddigits'] = 'Cyfry';
$string['minpasswordlength'] = 'Długość hasła';
$string['minpasswordlower'] = 'Małe litery';
$string['minpasswordnonalphanum'] = 'Litery spoza alfabetu';
$string['minpasswordupper'] = 'Wielkie litery';
$string['misc'] = 'Różne (Miscellaneous)';
$string['mnetrestore_extusers'] = '<strong>Uwaga:</strong> Ten plik kopii zapasowej zawiera zdalne konta użytkowników Moodle Network, które zostaną w ramach procesu przywrócone.';
$string['mnetrestore_extusers_admin'] = '<strong>Uwaga:</strong> Ten plik kopii prawdopodobnie pochodzi z innej instalacji Moodle i zawiera konta zdalnych użytkowników sieciowych Moodle Network. Proces odtwarzania będzie próbował odnaleźć zdalne hosty Moodle dla wszystkich utworzonych użytkowników. Ci użytkownicy, którzy nie zostaną odnalezieni, będą automatycznie przełączeni na wewnętrzne uwierzytelnianie (zamiast MNet). Dziennik odtwarzania poinformuje Cię o tym.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Uwaga:</strong> Ten plik kopii zapasowej pochodzi z innej instalacji Moodle i zawiera zdalne konta użytkowników Moodle Network, które mogą nie zostać przywrócone. Ta operacja nie jest obsługiwana. Jeżeli jesteś pewien, że plik został stworzony w tej instalacji Moodle, lub jesteś pewien, że wszystkie potrzebne hosty Moodle Network są skonfigurowane, możesz spróbować przywrócić.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Uwaga:</strong> Ten plik kopii prawdopodobnie pochodzi z innej instalacji Moodle i zawiera konta zdalnych użytkowników sieciowych Moodle Network. Nie masz uprawnień do wykonania tego typu odtwarzania. Skontaktuj się z administratorem witryny lub ewentualnie przywrócić ten kurs bez informacji o użytkownikach (modułów, plików...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Zdalny użytkownik Moodle Network {$a->username} (pochodzących z {$a->mnethosturl}) przełączony na  lokalnego uwierzytelnionego użytkownika {$a->auth}.';
$string['mobile'] = 'Mobilne';
$string['mobilecssurl'] = 'Kaskadowe Arkusze Stylów CSS';
$string['modchooserdefault'] = 'Domyślny wybór aktywności';
$string['modeditdefaults'] = 'Domyślne wartości dla ustawień aktywności';
$string['modeditingmenu'] = 'Aktywność menu edycji';
$string['modeditingmenu_desc'] = 'Jeżeli włączony, wiele pokazywanych ikon edycji aktywności podczas przeglądania kursu, z włączoną edycją będzie wyświetlanych w menu rozwijanym. To zmniejsza  zawartość na ekranie podczas edycji kursu przez ukrywanie ikon, dopóki nie będą potrzebne.';
$string['modsettings'] = 'Zarządzaj aktywnością';
$string['modulesecurity'] = 'Bezpieczeństwo modułów';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Wymuś starą składnię języka: <span> bez class="multilang" i <lang>';
$string['mustenablestats'] = 'Statystyki nie zostały jeszcze uaktywnione na tej stronie';
$string['mycoursesperpage'] = 'Liczba kursów';
$string['mydashboard'] = 'Domyślny panel sterowania systemu';
$string['mymoodle'] = 'Moja strona domowa';
$string['mymoodleredirect'] = 'Zmuś użytkowników do korzystania z Mój Moodle';
$string['mypage'] = 'Domyślna strona Moja strona domowa';
$string['mypagelocked'] = 'Zablokuj domyślną stronę';
$string['myprofile'] = 'Domyślna strona profilu';
$string['navadduserpostslinks'] = 'Dodaj linki do wpisów użytkownika';
$string['navadduserpostslinks_help'] = 'Dwa linki będą dodawane do każdego użytkownika w nawigacji: do dyskusji, które użytkownik zaczął, i do wiadomości, jakie wpisał na forach w całej witrynie lub w konkretnych kursach.';
$string['navcourselimit'] = 'Limit liczby kursów';
$string['navexpandmycourses'] = 'Pokaż Moje kursy w wersji rozszerzonej w Mojej stronie domowej';
$string['navigationupgrade'] = 'To uaktualnienie wprowadza dwa nowe bloki nawigacji, które zastąpią te bloki: Administracja, Kursy, Aktywności i Uczestnicy. Jeśli ustawiałeś jakieś specjalne uprawnienia do tych bloków, sprawdź, czy wszystko działa tak, jak powinno.';
$string['navshowallcourses'] = 'Pokaż wszystkie kursy';
$string['navshowcategories'] = 'Pokaż kategorie kursów';
$string['navshowfrontpagemods'] = 'Pokaż aktywności strony głównej w nawigacji';
$string['navshowfrontpagemods_help'] = 'Jeśli opcja będzie włączona, aktywności strony głównej będą wyświetlane w nawigacji na dole strony.';
$string['navshowfullcoursenames'] = 'Pokaż pełne nazwy kursów';
$string['navshowfullcoursenames_help'] = 'Jeśli aktywny, kursy w nawigacji zostaną pokazane z użyciem ich pełnej nazwy, zamiast nazwy krótkiej.';
$string['navshowmycoursecategories'] = 'Pokaż moje kategorie kursów';
$string['navshowmycoursecategories_help'] = 'Jeśli aktywny, kursy w oddziale moich kursów użytkowników zostanie pokazane w kategoriach.';
$string['navsortmycoursessort'] = 'Sortuj moje kursy';
$string['navsortmycoursessort_help'] = 'To określa, czy kursy są pokazywane poniżej Moich kursów wg kolejności sortowania (np. ustawienie kolejności w Ustawienia > Administracja strony > Kursy > Dodaj/Edytuj kursy) lub alfabetycznie wg ustawień kursu.';
$string['neverdeleteruns'] = 'Nigdy nie kasuj trwających';
$string['nobookmarksforuser'] = 'Nie masz żadnych zakładek';
$string['nodatabase'] = 'Brak bazy danych';
$string['nohttpsformobilewarning'] = 'Zaleca się włączyć HTTPS z ważnym certyfikatem.  Moodle będzie zawsze próbować używać bezpiecznego połączenia w pierwszej kolejności.';
$string['nomissingstrings'] = 'Nie ma brakujących fraz';
$string['nonewsettings'] = 'Podczas tego uaktualnienia nie dodano żadnych nowych ustawień';
$string['nonexistentbookmark'] = 'Zakładka o którą prosisz nie istnieje';
$string['noresults'] = 'Nie znaleziono wyników';
$string['noroles'] = 'Brak ról';
$string['nosupportedlogstore'] = 'Nie znaleziono wspieranego magaznu  logu';
$string['notifications'] = 'Powiadomienia';
$string['notifyloginfailures'] = 'Wyślij wiadomość e-mail o błędach logowania do';
$string['notifyloginthreshold'] = 'Próg dla powiadomień poczty elektronicznej';
$string['notloggedinroleid'] = 'Rola dla odwiedzających';
$string['numberofmissingstrings'] = 'Liczba brakujących łańcuchów: {$a}';
$string['numberofstrings'] = 'Całkowita liczba łańcuchów:  {$a->strings} <br />Brakuje: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'Buforowanie kodu operacji PHP zwiększa wydajność i zmniejsza zapotrzebowanie na pamięć, rozszerzenie OPcache jest zalecane i w pełni wspierane.';
$string['opensslrecommended'] = 'Instalacja opcjonalnej biblioteki OpenSSL jest wysoce zalecane -- aktywuje sieciową funkcjonalność Moodle.';
$string['opentogoogle'] = 'Otwórz dla Google';
$string['optionalmaintenancemessage'] = 'Opcjonalna wiadomość dla trybu konserwacji';
$string['order1'] = 'Pierwszy';
$string['order2'] = 'Drugi';
$string['order3'] = 'Trzeci';
$string['order4'] = 'Czwarty';
$string['passwordpolicy'] = 'Zasady dot. hasła';
$string['passwordresettime'] = 'Max. czas na potwierdzenie żądania zresetowania hasła';
$string['pathtoclam'] = 'Ścieżka do clam AV';
$string['pathtodot'] = 'Ścieżka do dot';
$string['pathtodot_help'] = 'Ścieżka do narzędzia dot. Najczęściej: /usr/bin/dot. Aby być w stanie generować grafikę z plików DOT, musisz mieć zainstalowane narzędzie dot i wskazać je tutaj. Należy pamiętać, że na razie jest ono używane tylko przez funkcje profilowania (Rozwój->Profilowanie) wbudowane w Moodle.';
$string['pathtodu'] = 'Ścieżka do du';
$string['pathtogs'] = 'Ścieżka do ghostscript';
$string['pathtopgdump'] = 'Ścieżka do pq_dump';
$string['pathtopgdumpdesc'] = 'Tego potrzeba tylko wtedy gdy w systemie jest więcej niż jeden pg_dump (np jeżeli masz zainstalowaną więcej niż jedną wersje postgresql)';
$string['pathtopgdumpinvalid'] = 'Błędna scieżka do pg_dump - albo błędna scieżka albo nie można wykonać polecenia.';
$string['pathtopsql'] = 'Ścieżka do psql';
$string['pathtopsqldesc'] = 'Tego potrzeba tylko wtedy gdy w systemie jest więcej niż jeden psql (np jeżeli masz zainstalowaną więcej niż jedną wersje postgresql)';
$string['pathtopsqlinvalid'] = 'Błędna scieżka do psql - albo błędna scieżka albo nie można wykonać polecenia.';
$string['pcreunicodewarning'] = 'Zalecamy używanie rozszerzenia PHP PCRE zgodnego z systemem znaków Unicode.';
$string['perfdebug'] = 'Informacja o wydajności';
$string['performance'] = 'Wydajność';
$string['pgcluster'] = 'Klaster PostgreSQL';
$string['pgclusterdescription'] = 'Parametry wersji/klastru do operacji z linii poleceń. Jeśli masz tylko jeden postgresql w systemie lub nie wiesz co z tym zrobić pozostaw puste.';
$string['phpfloatproblem'] = 'Wykryto nieoczekiwany problem w obsłudze liczb float w PHP - {$a}';
$string['pleaserefreshregistration'] = 'Twoja strona została zarejstrowana na moodle.org. Rozważ uaktualnienie danych rejestracyjnych jeśli zostały dokonane jakieś znaczące zmiany od ostatniej rejestracji dla {$a}';
$string['pleaseregister'] = 'Zarejstruj swoją stronę aby usunąć ten przycisk';
$string['plugin'] = 'Wtyczka';
$string['plugins'] = 'Wtyczki';
$string['pluginscheck'] = 'Kontrola zależności wtyczek';
$string['pluginscheckfailed'] = 'Kontrola zależności nie powiodła się dla {$a->pluginslist}';
$string['pluginschecktodo'] = 'Musisz uwzględnić wszystkie wymagania wtyczek przed przystąpieniem do instalacji tej wersji Moodle!';
$string['pluginsoverview'] = 'Przegląd wtyczek';
$string['pluginsoverviewsee'] = 'Wyświetl <a href="{$a->url}">przegląd wtyczek</a>, aby zobaczyć więcej informacji.';
$string['profilecategory'] = 'Kategoria';
$string['profilecategoryname'] = 'Nazwa kategorii (musi być unikatowa)';
$string['profilecategorynamenotunique'] = 'Ta nazwa kategorii jest już używana';
$string['profilecommonsettings'] = 'Pospolite ustawienia';
$string['profileconfirmcategorydeletion'] = 'Nie jest/są {$a} pole/pola w tej kategorii, które zostaną przeniesione do kategorii powyżej (lub poniżej, jeżeli w kategorii pierwszej). <br /> Czy nadal chcesz usunąć tę kategorię?';
$string['profileconfirmfielddeletion'] = 'Istnieją {$a} rekordy użytkownika dla tego pola które zostaną usunięte. <br /> Czy nadal chcesz usunąć to pole?';
$string['profilecreatecategory'] = 'Stwórz nową kategorię dla profilu';
$string['profilecreatefield'] = 'Stwórz nowe pole dla profilu';
$string['profilecreatenewcategory'] = 'Stwórz nową kategorię';
$string['profilecreatenewfield'] = 'Utwórz nowe &quot;{$a}&quot; pole profilu';
$string['profiledefaultcategory'] = 'Inne pola';
$string['profiledefaultchecked'] = 'Domyślnie zaznaczone';
$string['profiledefaultdata'] = 'Domyślna wartość';
$string['profiledeletecategory'] = 'Usuwanie kategorii';
$string['profiledeletefield'] = 'Usuwanie pola \'{$a}\'';
$string['profiledescription'] = 'Opis pola';
$string['profiledscript'] = 'Ten skrypt został sprofilowany';
$string['profiledscriptview'] = 'Zobacz informacje profilowania dla tego skryptu';
$string['profileeditcategory'] = 'Edycja kategorii: {$a}';
$string['profileeditfield'] = 'Edycja pola profilu: {$a}';
$string['profilefield'] = 'Pole profilu';
$string['profilefieldcolumns'] = 'Kolumny';
$string['profilefieldispassword'] = 'Czy jest to pole hasła?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Aby przekształcić tekst na link, należy wpisać adres URL zawierający znak $$, gdzie $$ zostanie zastąpiony tekstem. Na przykład, aby przekształcić Twitter ID na link, wprowadź http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Miejsce docelowe linku';
$string['profilefieldmaxlength'] = 'Maksymalna długość';
$string['profilefieldrows'] = 'Wiersze';
$string['profilefields'] = 'Pola w profilu użytkownika';
$string['profilefieldsize'] = 'Wielkość wyświetlania';
$string['profileforceunique'] = 'Czy dane powinny być unikalne?';
$string['profileinvaliddata'] = 'Niewłaściwa wartość';
$string['profilelocked'] = 'Czy to pole jest zablokowane?';
$string['profilemenudefaultnotinoptions'] = 'Wartość domyślna nie jest jedną z dostępnych opcji';
$string['profilemenunooptions'] = 'Nie podano opcji menu';
$string['profilemenuoptions'] = 'Opcje menu (jedna na linię)';
$string['profilemenutoofewoptions'] = 'Musisz wprowadzić co najmniej 2 opcje';
$string['profilename'] = 'Nazwa';
$string['profilenofieldsdefined'] = 'Żadne pole nie zostało zdefiniowane';
$string['profilerequired'] = 'Czy to pole jest wymagane?';
$string['profileroles'] = 'Widoczne role profilu';
$string['profilesforenrolledusersonly'] = 'Profile jedynie dla zapisanych użytkowników';
$string['profileshortname'] = 'Krótka nazwa (musi być unikalna)';
$string['profileshortnamenotunique'] = 'Ta krótka nazwa jest już używana';
$string['profilesignup'] = 'Wyświetlić na stronie zapisów?';
$string['profilespecificsettings'] = 'Specyficzne ustawienia';
$string['profilevisible'] = 'Dla kogo jest widoczne to pole?';
$string['profilevisibleall'] = 'Widoczny dla wszystkich';
$string['profilevisible_help'] = '* Nie widoczny - tylko dla prywatnych informacji widzianych przez administratora

* Widoczny dla użytkownika - tylko dla prywatnych informacji widzianych przez użytkownika oraz administratora

* Widoczny dla wszystkich';
$string['profilevisiblenone'] = 'Nie widoczny';
$string['profilevisibleprivate'] = 'Widoczny dla użytkownika';
$string['profiling'] = 'Profilowanie';
$string['profilingallowall'] = 'Ciągłe profilowanie';
$string['profilingallowall_help'] = 'Jeśli włączysz to ustawienie, w dowolnym momencie można użyć gdziekolwiek parametru PROFILEALL, aby włączyć profilowanie wszystkich skryptów wykonywanych w tej sesji Moodle. Analogicznie, można użyć parametru PROFILEALLSTOP, aby zatrzymać profilowanie.';
$string['profilingallowme'] = 'Profilowanie selektywne';
$string['profilingallowme_help'] = 'Jeśli włączysz to ustawienie, możesz użyć gdziekolwiek parametru PROFILEME, aby włączyć profilowanie konkretnego skryptu. Analogicznie można użyć parametru DONTPROFILEME, aby wyłączyć profilowanie.';
$string['profilingautofrec'] = 'Automatyczne profilowanie';
$string['profilingautofrec_help'] = 'Jesli skonfigurujesz to ustawienie, niektóre żądania (losowo, na podstawie określonej częstości - 1 z N) zostaną wybrane i automatycznie profilowane, a wyniki będą przechowane do dalszej analizy. Zauważ, że ten sposób profilowania uznaje ustawienia włączenia/wykluczenia profilowania. Ustaw na 0, aby wyłączyć automatyczne profilowanie.';
$string['profilingenabled'] = 'Włącz profilowanie';
$string['profilingenabled_help'] = 'Jeśli to ustawienie zostanie włączone, wtedy profilowanie będzie dostępne na tej stronie i będziesz mógł określić jego zachowanie poprzez konfigurację następnej opcji.';
$string['profilingexcluded'] = 'Wyklucz profilowanie';
$string['profilingexcluded_help'] = 'Lista adresów URL, które będą wyłączone z profilowania spośród tych, określonych jako "Skrypty do profilowania". (Lista rozdzielona przecinkami, adresy absolutne pomijając wwwroot, dające się wywołać)';
$string['profilingimportprefix'] = 'Profilowany przedrostek importu';
$string['profilingimportprefix_desc'] = 'Dla łatwiejszego wykrywania, wszystkie importowane działa profilowania zostaną poprzedzone z podaną tutaj wartością.';
$string['profilingincluded'] = 'Skrypty do profilowania';
$string['profilingincluded_help'] = 'Lista adresów URL, które będą automatycznie profilowane. (Lista rozdzielona przecinkami, adresy absolutne pomijając wwwroot, dające się wywołać) Przykłady: /index.php, /course/view.php. Znaki specjalne * są akceptowane w dowolnej pozycji. Przykłady: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Przechowaj przebiegi profilowania przez';
$string['profilinglifetime_help'] = 'Określ czas, przez który chcesz zachować informacje o starych przebiegach profilowania. Starsze będą usuwane okresowo. Zauważ, że tonie dotyczy profilowanie oznaczonego jako \'przebieg odniesienia\'.';
$string['protectusernames'] = 'Chroń nazwę użytkownika';
$string['proxybypass'] = 'Hosty, które omijają proxy';
$string['proxyhost'] = 'Host proxy';
$string['proxypassword'] = 'Hasło proxy';
$string['proxyport'] = 'Port proxy';
$string['proxytype'] = 'Typ proxy';
$string['proxyuser'] = 'Nazwa użytkownika proxy';
$string['purgecaches'] = 'Wyczyść wszystkie bufory pamięci podręcznej';
$string['purgecachesconfirm'] = 'Moodle może buforować motywy graficzne, JavaScript, łańcuchy językowe, przefiltrowany tekst, kanały RSS i wiele innych przetworzonych danych. Czyszczenie tych buforów  usuwa te dane z serwera i powoduje, że przeglądarek pobierają danych ponownie, dzięki czemu można mieć pewność, że wyświetlają się najnowsze dane produkowane przez aktualny kod. Czyszczenie pamięci podręcznej nie jest niebezpieczne, ale Twoja strona może przez chwilę działać wolniej, zanim bufory zapełnią się ponownie.';
$string['purgecachesfinished'] = 'Wszystkie bufory pamięci podręcznej zostały wyczyszczone.';
$string['quarantinedir'] = 'Katalog plików objętych kwarantanną';
$string['question'] = 'Pytanie';
$string['questionbehaviours'] = 'Zachowanie pytań';
$string['questioncwqpfscheck'] = 'Jeden lub więcej \'losowych\' pytań w quizie są ustawione do wybierania pytań z mieszaniny wspólnych i niewspólnych kategorii pytań. Jest bardziej szczegółowy raport <a href="{$a->reporturl}">tutaj</a> i odwiedź stronę dokumentacji Moodle <a href="{$a->docsurl}">tutaj</a>.';
$string['questioncwqpfsok'] = 'Dobrze. W quizach nie ma pytań &quot;Losowych&quot;, które pobierałyby pytania ze współdzielonych i nie współdzielonych kategorii.';
$string['questiontype'] = 'Rodzaj pytania';
$string['questiontypes'] = 'Rodzaje pytań';
$string['quizattemptsupgradedmessage'] = 'W Moodle 2.1 było ważne uaktualnienie dla pytań. Była możliwość opóźnienia części aktualizacji bazy danych, które mogły być uruchomione później. Przed aktualizacją do Moodle 2.7, ta aktualizacja musi być ukończona.';
$string['recaptchaprivatekey'] = 'klucz prywatny ReCAPTCHA';
$string['recaptchapublickey'] = 'klucz publiczny ReCAPTCHA';
$string['register'] = 'Zarejestruj swoją stronę';
$string['registermoodleorg'] = 'Kiedy zarejestrujesz swoją stronę:';
$string['registermoodleorgli1'] = 'Zostajesz dodany do listy mailowej otrzymującej ważne powiadomienia, takie jak informacje o nowych wersjach czy powiadomienia o bezpieczeństwie Moodle.';
$string['registermoodleorgli2'] = 'Statystyki o twojej stronie zostaną dodane do {$a} światowej społeczności Moodle.';
$string['registermoodleorgli3'] = 'Twoja strona jest również zarejestrowana na Moodle.net ({$a}), pozwalając użytkownikom z możliwością publikowania kursów (domyślnie tylko przez menedżerów) na możliwość publikowania kursów na Moodle.net.';
$string['registerwithmoodleorg'] = 'Zarejestruj się w Moodle.org';
$string['registration'] = 'Rejestracja';
$string['registration_help'] = 'Rejestracja strony w Moodle.org jest zalecana w celu otrzymywania powiadomień bezpieczeństwa, aby przyczynić się do <a href="http://moodle.org/stats">użytkowania statystyk Moodle</a> i móc dzielenia się kursami na <a href="http://moodle.net/">Moodle.net</a>.';
$string['registrationwarning'] = 'Witryna nie jest jeszcze zarejestrowana.';
$string['releasenoteslink'] = 'Aby zapoznać się z informacjami na temat tej wersji Moodla przeczytaj informacje zawarte w <a target="_blank" href="{$a}">Release Notes</a>.';
$string['rememberusername'] = 'Zapamiętaj login';
$string['rememberusername_desc'] = 'Włącz, jeśli chcesz przechowywać trwałe ciasteczka z nazwą użytkownika. Trwałe pliki cookie mogą być uznane za zagrożenie prywatności, jeśli są używane bez zgody.';
$string['reportsmanage'] = 'Zarządzaj raportami';
$string['requestcategoryselection'] = 'Włącz wybór kategorii';
$string['requiredentrieschanged'] = '<strong>WAŻNE - PRZECZYTAJ <br/> (Ten komunikat będzie wyświetlony tylko podczas tej aktualizacji)</strong> <br/> Ze względu na poprawkę błędu, zmieni się zachowanie aktywności bazy danych używających "Wymaganych wpisów" i "Wymaganych wpisów przed wyświetleniem ustawień". Bardziej szczegółowy opis zmian można przeczytać na <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">forum modułu bazy danych</a> . O oczekiwanym zachowaniu tych ustawień można także przeczytać na <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a> . <br/><br/> Ta zmiana dotyczy następujących baz danych w systemie: (Proszę zapisać tę listę teraz i po aktualizacji sprawdzić, czy te aktywności nadal działają tak, jak chciał nauczyciel). <br/> <strong>{$a->text}</strong> <br/>';
$string['requiremodintro'] = 'Wymagaj opisu aktywności';
$string['requires'] = 'Wymagania';
$string['restorecourse'] = 'Przywracanie kursu';
$string['restorernewroleid'] = 'Rola w kursie po odtworzeniu';
$string['restorernewroleid_help'] = 'Jeśli użytkownik nie ma jeszcze uprawnień do zarządzania nowo odtworzonym kursem, użytkownikowi automatycznie przypisze się tę rolę. Wybierz opcję &quot;None&quot;, jeśli nie chcesz, restauratorzy, aby móc zarządzać każdym przywrócony kurs.';
$string['reverseproxy'] = 'Odwrotne proxy';
$string['riskconfig'] = 'Użytkownicy mogą zmieniać konfigurację i zachowanie strony';
$string['riskconfigshort'] = 'Zagrożenie konfiguracji';
$string['riskdataloss'] = 'Użytkownicy mogą zniszczyć duże ilości danych';
$string['riskdatalossshort'] = 'Ryzyko utraty danych';
$string['riskmanagetrust'] = 'Użytkownicy mogą zmieniać zaufane ustawienia innych użytkowników';
$string['riskmanagetrustshort'] = 'Zarządzaj zaufaniami';
$string['riskpersonal'] = 'Użytkownicy mogą uzyskać dostęp do prywatnych danych innych użytkowników';
$string['riskpersonalshort'] = 'Zagrożenie prywatności';
$string['riskspam'] = 'Użytkownicy mogą wysyłać spam do użytkowników strony lub innych użytkowników';
$string['riskspamshort'] = 'Zagrożenie spamem';
$string['riskxss'] = 'Użytkownicy mogą dodawać pliki i teksty które pozwalają na cross-site scripting (XSS)';
$string['riskxssshort'] = 'Zagrożenie XSS';
$string['roleswithexceptions'] = '{$a->roles} z {$a->exceptions}';
$string['rssglobaldisabled'] = 'Wyłączone na poziomie serwera';
$string['runclamavonupload'] = 'Użyj ClamAV do sprawdzania wysyłanych plików';
$string['save'] = 'Zapisz';
$string['savechanges'] = 'Zapisz zmiany';
$string['search'] = 'Wyszukaj';
$string['searchinsettings'] = 'Wyszukaj w ustawieniach';
$string['searchresults'] = 'Wyniki wyszukiwania';
$string['sectionerror'] = 'Błąd sekcji!';
$string['secureforms'] = 'Użyj dodatkowej ochrony formularza';
$string['security'] = 'Ochrona';
$string['selectdevice'] = 'Wybierz urządzenie';
$string['selecttheme'] = 'Wybierz szablon graficzny dla urządzenia: {$a}';
$string['server'] = 'Serwer';
$string['serverchecks'] = 'Kontrola serwera';
$string['serverlimit'] = 'Limit serwera';
$string['sessionautostartwarning'] = '<p>Wykryto poważny błąd w konfiguracji, należy powiadomić administratora serwera. </p><p> Aby Moodle działał prawidłowo, administrator musi zmienić ustawienia PHP. </p><p> <code>session.auto_start</code> musi być ustawione na <code>off</code> . </p><p> Należy to zmienić poprzez edycję pliku <code>php.ini</code>, konfiguracji Apache/IIS lub <code>.htaccess</code> na serwerze. </p>';
$string['sessioncookie'] = 'Prefiks pliku cookie';
$string['sessioncookiedomain'] = 'Domena cookie';
$string['sessioncookiepath'] = 'Ścieżka do pliku cookie';
$string['sessionhandling'] = 'Obsługa sesji';
$string['sessiontimeout'] = 'Limit czasu';
$string['settingfileuploads'] = 'Przesyłanie plików  jest wymagane do normalnej pracy, proszę włączyć tą opcję w konfiguracji PHP.';
$string['settingmemorylimit'] = 'Wykryto za mało pamięci, ustaw większy limit pamięci w ustawieniach PHP.';
$string['settingsafemode'] = 'Moodle nie jest w pełni kompatybilny z trybem awaryjnym, należy poprosić administratora serwera, aby go wyłączył. Używanie Moodle w trybie awaryjnym nie jest obsługiwane i należy spodziewać się różnych problemów.';
$string['showcommentscount'] = 'Pokaż licznik komentarzy';
$string['showdetails'] = 'Pokaż szczegóły';
$string['showuseridentity'] = 'Pokazuj dodatkowo pola';
$string['showuseridentity_desc'] = 'Podczas wybierania lub poszukiwania i wyświetlania listy użytkowników, pola te mogą być wyświetlane obok pełnej nazwy użytkownika. Pola są widoczne tylko dla użytkowników, którzy mają uprawnienie moodle/site:viewuseridentity, domyślnie, nauczycieli i managerów. (Ta opcja może mieć zastosowanie w instytucji, gdzie dodatkowe jedno lub dwa pola są obowiązkowe).';
$string['simplexmlrequired'] = 'Rozszerzenie PHP SimpleXML jest teraz wymagane przez Moodle.';
$string['sitemaintenance'] = 'Trwają pracę administracyjne. Strona jest chwilowo niedostępna.';
$string['sitemaintenancemode'] = 'Tryb konserwacji';
$string['sitemaintenanceoff'] = 'Tryb konserwacji został wyłączony i strona jest wyświetlana normalnie';
$string['sitemaintenanceon'] = 'Strona jest aktualnie w trybie konserwacji (tylko administratorzy mogą się logować i używać stronę)';
$string['sitemaintenanceoncli'] = 'Twoja strona jest aktualnie w trybie konserwacji CLI, żadny dostęp do strony nie jest dozwolony.';
$string['sitemaintenancewarning'] = 'Strona jest aktualnie w trybie konserwacji (tylko administratorzy mogą się logować). Aby włączyć normalny tryb strony, <a href="maintenance.php">wyłącz tryb konserwacji</a>.';
$string['sitemaintenancewarning2'] = 'Twoja strona jest aktualnie w trybie konserwacji (tylko administratorzy mogą się logować). Aby wrócić do normalnej pracy, <a href="{$a}"> wyłącz tryb konserwacji</ a>.';
$string['sitepolicies'] = 'Zasady strony';
$string['sitepolicy'] = 'Zasady URL strony';
$string['sitepolicyguest'] = 'URL strony regulaminu dla gości';
$string['sitepolicyguest_help'] = 'Jeśli posiadasz politykę strony/regulamin, wszyscy goście muszą zobaczyć i zaakceptować go przed rozpoczęciem przeglądania witryny. Jeśli chcesz podać adres tej strony, wprowadź odpowiedni URL tutaj lub pozostaw pole pustym. To ustawienie może zawierać publiczne adresy URL. Uwaga: dostępowi niezalogowanych użytkowników można zapobiec poprzez ustawienie opcji: wymuszenie logowania.';
$string['sitepolicy_help'] = 'Jeśli masz ustawioną politykę zarządzania stroną, na którą wszyscy użytkownicy musza się zgodzić przed skorzystaniem ze strony, wówczas ustaw tutaj URL, w przeciwnym razie pozostaw to pole pustym. URL może wskazywać gdziekolwiek – dogodnym miejscem będzie plik pośród plików strony. Np. http://yoursite/file.php/1/policy.html';
$string['sitesectionhelp'] = 'Jeżeli wybrane, sekcja tematu zostanie wyświetlona na stronie głównej serwisu';
$string['slasharguments'] = 'Oddzielaj argumenty znakiem slash (Use slash arguments)';
$string['smartpix'] = 'Inteligentne wyszukiwanie obrazów';
$string['soaprecommended'] = 'Zainstalowanie opcjonalnego rozszerzenia SOAP jest przydatne dla usług internetowych i niektórych modułów dodanych.';
$string['sort_fullname'] = 'Pełna nazwa kursu';
$string['sort_idnumber'] = 'Numer ID kursu';
$string['sort_shortname'] = 'Krótka nazwa';
$string['sort_sortorder'] = 'Porządek sortowania';
$string['spellengine'] = 'Narzędzie sprawdzające pisownię';
$string['spelllanguagelist'] = 'Listę języków do sprawdzania pisowni';
$string['splrequired'] = 'Rozszerzenie PHP SPL jest obecnie wymagane przez Moodle.';
$string['stats'] = 'Statystyka';
$string['statsfirstrun'] = 'Maksymalny interwał przetwarzania';
$string['statsmaxruntime'] = 'Maksymalny czas wykonywania';
$string['statsmoodleorg'] = 'statystyk';
$string['statsruntimedays'] = 'Dni do przetworzenia';
$string['statsruntimestart'] = 'Wykonaj o';
$string['statsuserthreshold'] = 'Próg użytkownika';
$string['stickyblocks'] = 'Przylegające bloki';
$string['stickyblockscourseview'] = 'Strona kursu';
$string['stickyblocksduplicatenotice'] = 'Jeśli jakikolwiek blok dodany w tym miejscu istnieje już na pojedynczej stronie, spowoduje to stworzenie duplikatu. <br /> Jedynie załączony plik będzie nie edytowalny, duplikat ciągle pozostanie edytowalny';
$string['stickyblocksmymoodle'] = 'Moja strona domowa (Mój Moodle)';
$string['stickyblockspagetype'] = 'Typ strony do konfiguracji';
$string['strictformsrequired'] = 'Ścisłe sprawdzanie wymaganych pól';
$string['stripalltitletags'] = 'Usuń tagi HTML ze wszystkich nazw aktywności';
$string['supportcontact'] = 'Kontakt wsparcia';
$string['supportemail'] = 'Email wsparcia';
$string['supportname'] = 'Nazwa wsparcia';
$string['supportpage'] = 'Strona wsparcia';
$string['suspenduser'] = 'Zawieszono konto użytkownika';
$string['switchlang'] = 'Zmień katalog języków';
$string['systempaths'] = 'Ścieżki systemowe';
$string['tablenosave'] = 'Zmiany w powyższej tabeli są zapisywane automatycznie.';
$string['tablesnosave'] = 'Zmiany w powyższej tabeli są zapisywane automatycznie.';
$string['tabselectedtofront'] = 'W tabeli zakładkami, wiersz z aktualnym zaznaczeniem powinnien znaleźć się na początku';
$string['tabselectedtofronttext'] = 'Przenieść wybrany wiersz tabeli na wierzch';
$string['taskautomatedbackup'] = 'Automatyczne tworzenie kopii zapasowych';
$string['taskbackupcleanup'] = 'Wyczyść tabele kopii i dzienników';
$string['taskbadgescron'] = 'Przyznaj odznaki';
$string['taskblogcron'] = 'Synchronizuj zewnętrzne blogi';
$string['taskcachecleanup'] = 'Usuń wygasłe wpisy pamięci podręcznej';
$string['taskcachecron'] = 'Przetwarzanie w tle dla pamięci podręcznej';
$string['taskcalendarcron'] = 'Wyślij powiadomienia kalendarza';
$string['taskcheckforupdates'] = 'Sprawdź aktualizacje';
$string['taskcompletioncron'] = 'Oblicz ukończenie danych';
$string['taskcontextcleanup'] = 'Wyczyść konteksty';
$string['taskcreatecontexts'] = 'Utwórz brakujące konteksty';
$string['taskdeletecachetext'] = 'Usuń stare rekordy bufora tekstu';
$string['taskdeleteincompleteusers'] = 'Usuń niekompletnych użytkowników';
$string['taskdeleteunconfirmedusers'] = 'Usuń niepotwierdzonych użytkowników';
$string['taskeventscron'] = 'Przetwarzanie w tle dla wydarzeń';
$string['taskfiletrashcleanup'] = 'Wyczyść kosz z plików';
$string['taskgradecron'] = 'Przetwarzanie w tle dla dziennika ocen';
$string['tasklegacycron'] = 'Przetwarzanie zapisu cron dla wtyczek';
$string['taskmessagingcleanup'] = 'Przetwarzanie w tle dla wiadomości';
$string['taskpasswordresetcleanup'] = 'Oczyść reset haseł dla prób';
$string['taskplagiarismcron'] = 'Przetwarzanie w tle dla wtyczek plagiatów';
$string['taskportfoliocron'] = 'Przetwarzanie w tle dla wtyczek portfela';
$string['taskquestioncron'] = 'Przetwarzanie w tle dla silnika zapytań';
$string['taskregistrationcron'] = 'Rejestracja strony';
$string['tasksendfailedloginnotifications'] = 'Wyślij powiadomienie o niepowodzeniu logowania';
$string['tasksendnewuserpasswords'] = 'Wyślij hasła nowym użytkownikom';
$string['tasksessioncleanup'] = 'Oczyść ze starych sesji';
$string['taskstatscron'] = 'Przetwarzanie w tle dla statystyk';
$string['tasktagcron'] = 'Przetwarzanie w tle dla tagów';
$string['tasktempfilecleanup'] = 'Usuń nieaktualne pliki tymczasowe';
$string['testsiteupgradewarning'] = 'Obecnie używasz strony testowej {$a}, aby poprawnie to uaktualnić, użyj narzędzia interfejsu z linii poleceń';
$string['themedesignermode'] = 'Tryb projektowania szaty graficznej';
$string['themelist'] = 'Lista kompozycji';
$string['themenoselected'] = 'Brak wybranego tematu graficznego';
$string['themeresetcaches'] = 'Wyczyść pamięć podręczną tematów graficznych';
$string['themeselect'] = 'Zmień temat graficzny';
$string['themeselector'] = 'Wybór kompozycji';
$string['themesettings'] = 'Ustawienia kompozycji';
$string['therewereerrors'] = 'Wystąpiły błędy w twoich danych';
$string['thirdpartylibrary'] = 'Biblioteka';
$string['thirdpartylibrarylocation'] = 'Lokalizacja';
$string['thirdpartylibs'] = 'Biblioteki firm trzecich';
$string['timezone'] = 'Domyślna strefa czasowa';
$string['timezoneforced'] = 'To jest wymuszone przez administratora strony';
$string['timezoneisforcedto'] = 'Wymuś dla wszystkich użytkowników użycie';
$string['timezonenotforced'] = 'Użytkownicy mogą wybrać swoją własną strefę czasową';
$string['tokenizerrecommended'] = 'Instalowanie opcjonalnego rozszerzenie PHP Tokenizer jest zalecane - poprawia to funkcjonalność Sieci Moodle.';
$string['tools'] = 'Narzędzia admina';
$string['toolsmanage'] = 'Zarządzaj narzędziami admina';
$string['unattendedoperation'] = 'Nienadzorowana operacja';
$string['unbookmarkthispage'] = 'Usuń stronę z zakładek';
$string['unicoderequired'] = 'Wymagane jest aby składować wszystkie dane w formacie unicode (UTF-8). Nowe instalacje muszą być wykonane w bazach danych których domyślne kodowanie są ustawione jako Unicode. Jeżeli dokonywane jest uaktualnienie, należy przeprowadzić proces migracji UTF-8 (zobacz stronę Administratora).';
$string['uninstallplugin'] = 'Odinstaluj';
$string['unlockaccount'] = 'Odblokuj konto';
$string['unsettheme'] = 'Wyłącz motyw';
$string['unsupported'] = 'Niewspierany';
$string['unsupporteddbstorageengine'] = 'Wybrany silnik bazy danych nie jest już wspierany.';
$string['unsupportedphpversion7'] = 'PHP w wersji 7 nie jest wspierane';
$string['unsuspenduser'] = 'Aktywuj konto użytkownika';
$string['updateaccounts'] = 'Uaktualnij istniejące konta';
$string['updateautocheck'] = 'Automatycznie sprawdzaj czy dostępne są aktualizacje';
$string['updateautocheck_desc'] = 'Jeśli opcja jest włączona, witryna automatycznie sprawdzi czy dostępne są aktualizacje zarówno dla kodu Moodle oraz wszystkich dodatkowych wtyczek. Jeśli jest nowa aktualizacja, zgłoszenie to zostanie wysłane do administratorów witryny.';
$string['updateautodeploy'] = 'Włącz instalację aktualizacji';
$string['updateautodeploy_desc'] = 'Jeśli opcja jest włączona, możesz pobierać i instalować dostępne aktualizacje bezpośrednio ze strony administracji Moodle. Należy pamiętać, że serwer musi mieć uprawnienia zapisu do folderu instalacji Moodle. To może być widziane jako potencjalne zagrożenie bezpieczeństwa.';
$string['updateavailable'] = 'Istnieje nowsza wersja Moodle!';
$string['updateavailabledetailslink'] = 'Zapoznaj się ze szczegółami na {$a->url}';
$string['updateavailableforplugin'] = 'Istnieje nowa wersja niektórych z twoich wtyczek!';
$string['updateavailableinstall'] = 'Zainstaluj tę aktualizację';
$string['updateavailable_moreinfo'] = 'Więcej informacji ...';
$string['updateavailablenot'] = 'Twój kod Moodle jest aktualny!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Wersja {$a}';
$string['updatecomponent'] = 'Uaktualnij komponent';
$string['updateminmaturity'] = 'Wymagany kod termin płatności';
$string['updateminmaturity_desc'] = 'Powiadamiaj o dostępnych aktualizacjach, tylko jeżeli dostępny kod został wybrany co najmniej na poziomie stabilnym. Aktualizacje dla wtyczek, które nie deklarują dla ich kodu poziomu stabilnego są zawsze zgłaszane bez względu na to ustawienie.';
$string['updatenotificationfooter'] = 'Twój serwis Moodle {$a->siteurl} jest skonfigurowany do automatycznego sprawdzania dostępności aktualizacji.
Otrzymujesz tę wiadomość jako administrator witryny. Możesz wyłączyć automatyczne sprawdzanie aktualizacji w Administracji serwisu w sekcji Serwer.
Możesz także personalizować dostarczanie tych wiadomości poprzez osobiste ustawiania w ustawianiach swojego profilu.';
$string['updatenotifications'] = 'Aktualizuj powiadomienia';
$string['updatenotificationsubject'] = 'Dostępne są aktualizacje dla Twojej strony Moodle';
$string['updatenotifybuilds'] = 'Powiadamiaj o nowych wydaniach';
$string['updatenotifybuilds_desc'] = 'Jeśli opcja jest włączona, dostępna aktualizacja dla kodu Moodle jest także raportowana, kiedy nowa kompilacja dla bieżącej wersji jest dostępna. Kompilacje ciągle są udoskonalane dla danej wersji Moodle. Są one zazwyczaj wydawane co tydzień. Jeżeli wyłączone, dostępna aktualizacja będzie raportowana tylko wtedy, kiedy będzie miała wyższą wersję niż wydana wersja Moodle. Sprawdzanie wersji wtyczek nie jest objęte w tym ustawieniu.';
$string['upgradeerror'] = 'Wystąpił nieznany błąd podczas aktualizacji modułu {$a->plugin} do wersji {$a->version}, nie można kontynuować.';
$string['upgradeforumread'] = 'Nowa funkcjonalność została dodana w Moodle 1.5 aby śledzić przeczytane/nieprzeczytane wątki na forum. <br /> Aby użyć tej funkcji musisz <a href="{$a}">auaktualić tabele w bazie danych</a>.';
$string['upgradeforumreadinfo'] = 'Nowy program został dodany w Moodle 1.5 w celu śledzenia przeczytanych/nie przeczytanych opinii na forum. Aby skorzystać z tej opcji musisz zaktualizować swoje tabele za pomocą wszelkich informacji śledzących dla istniejących wpisów. W zależności od wielkości Twojej strony może zająć to dłuższy okres czasu (liczony nawet w godzinach) i może powodować znaczne obciążenia bazy danych, a więc zalecane jest stosowanie go podczas okresów bezczynności. Aktualizacja ta nie będzie miała wpływu na funkcjonalność Twojej strony, nie wpłynie ona również na obsługę użytkowników. Po rozpoczęciu procesu powinieneś przeprowadzić go do końca ( okno przeglądarki powinno pozostać otwarte). Nie należy jednak przejmować się przerwaniem procesu wynikłym wskutek zamknięcia strony, ponieważ można  <br /><br /> Czy chcesz teraz rozpocząć proces aktualizacji?”';
$string['upgradelogs'] = 'Dla pełnej funkcjonalności twoje dawne pliki logów muszą zostać zaktualizowane. <a href="{$a}">Więcej informacji</a>';
$string['upgradelogsinfo'] = 'Aby móc przeglądać stare logi musisz dokonać ich aktualizacji. W zależności od konfiguracji twojej strony internetowej proces ten może potrwać parę godzin i mocno wpłynąć na wydajność bazy danych. Gdy rozpoczniesz już proces aktualizacji, poczekaj aż on się skończy (nie zamykaj okna przeglądarki). Strona będzie działała poprawnie dla innych użytkowników.<br />Czy chcesz teraz dokonać aktualizacji logów?';
$string['upgradepluginsfirst'] = 'Musisz pobrać i zainstalować dostępne aktualizacje ręcznie';
$string['upgradepluginsinfo'] = 'Aktualizacja wtyczek';
$string['upgradepluginsinfo_help'] = 'Dostępne są aktualizacje dla niektórych twoich wtyczek. Moodle nie zaktualizuje ich automatycznie. Musisz pobrać aktualizację i zainstalować go na serwerze ręcznie.';
$string['upgradesettings'] = 'Nowe ustawienia';
$string['upgradesettingsintro'] = 'Ustawienia pokazane poniżej zostały dodane podczas ostatniego uaktualnienia Moodle. Dokonaj koniecznych zmian w wartościach domyślnych i kliknij "Zapisz ustawienia" na dole strony.';
$string['upgradestalefiles'] = 'Wykryto nieprawidłowe pliki instalacyjne, aktualizacja nie może być kontynuowana';
$string['upgradestalefilesinfo'] = 'Proces aktualizacji Moodle został wstrzymany, ponieważ co najmniej dwa skrypty PHP z głównych wersji Moodle zostały wykryte w katalogu Moodle.

To może później spowodować poważne problemy, więc należy przed kontynuacją upewnić się, że w katalogu Moodle są pliki dla pojedynczej wersji Moodle.

Zalecanym sposobem oczyszczenia katalogu Moodle jest podany poniżej:

* zmienić obecną nazwę katalogu Moodle na "moodle_old"
* stworzyć nowy katalog Moodle zawierający tylko pliki z pobranego standardowego pakietu Moodle, lub repozytorium Git Moodle
* przenieś ortyginalny plik config.php i wszelakie niestandardowe wtyczki z katalogu "moodle_old" do nowego katalogu Moodle

Kiedy masz czysty katalog Moodle, odśwież tą stroną aby wznowić proces aktualizacji Moodle.

To ostrzeżenie jest najczęściej spowodwane przez wypakowanie standardowego pakietu Moodle z poprzedniej wersji Moodle. Dopóki jest wporządku dla aktualizacji drobnych, to jest silnie odradzane dla głównych aktualizacji Moodle.

Ostrzeżenie to może być również spowodowane przez niekompletną operację ściągnięcia lub aktualizacji z repozytorium Git, w którym przypadku możesz poczekać na zakończenie operacji, lub uruchomić odpowiednie polecenie oczyszczenia i ponowić operację.

Więcej informacji znajdziesz w dokumentacji aktualizacji na <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Uaktualnij teraz bazę danych Moodle';
$string['upgradesure'] = 'Pliki Moodle zostały zmienione i zaraz rozpocznie się automatyczna aktualizacja do wersji: <br /><br />
<strong>{$a}</strong> <br /><br />
Wykonanej aktualizacji nie można cofnąć. <br /><br />
Proces aktualizacji może trwać długo. <br /><br />
Czy jesteś pewien że chcesz dokonać aktualizacji do tej wersji?';
$string['upgradetimedout'] = 'Przekroczono limit czasu aktualizacji, proszę uruchomić proces ponownie.';
$string['upgradingdata'] = 'Aktualizuje dane';
$string['upgradinglogs'] = 'Aktualizuje pliki logów';
$string['upgradingversion'] = 'Aktualizacja do nowszej wersji';
$string['upwards'] = 'w górę';
$string['useblogassociations'] = 'Włącz skojarzenia bloga';
$string['useexternalyui'] = 'Użyj bibliotek YUI online';
$string['user'] = 'Użytkownik';
$string['userbulk'] = 'Wielokrotne akcje na użytkownikach';
$string['userdefaultpreferences'] = 'Domyślne preferencje użytkownika';
$string['userlist'] = 'Przeglądaj listę użytkowników';
$string['userpolicies'] = 'Zasady użytkownika';
$string['userpreference'] = 'Preferencje użytkownika';
$string['userquota'] = 'Limit dyskowy użytkownika';
$string['users'] = 'Użytkownicy';
$string['usesitenameforsitepages'] = 'Użyj nazwy strony dla podstron';
$string['usetags'] = 'Włącz tagi';
$string['validateerror'] = 'Podana wartość była nieprawidłowa';
$string['verifychangedemail'] = 'Ogranicz domeny gdy jest zmieniany e-mail';
$string['warningcurrentsetting'] = 'Nieprawidłowa wartość: {$a}';
$string['warningiconvbuggy'] = 'Twoja wersja biblioteki iconv nie obsługuje identyfikatora //IGNORE. Możesz zainstalować rozszerzenie mbstring, który może być używany dla tekstów zawierających niepoprawne znaki w UTF-8.';
$string['webproxy'] = 'Serwer Proxy';
$string['webproxyinfo'] = 'Dostęp do Internetu jest konieczny z uwagi na dane środowiska, pakiety językowe, RSS, strefy czasowy, itd.<br> <em>Rozszerzenie PHP cURL jest wysoce zalecane.</em>';
$string['xmlrpcrecommended'] = 'Rozszerzenie xmlrpc jest niezbędne do komunikacji z hubem i przydatne dla usług internetowych i Moodle networking';
$string['yuicomboloading'] = 'Optymalizacja ładowania YUI';
$string['ziprequired'] = 'Rozszerzenie Zip PHP jest obecnie wymagane przez Moodle. Binaria info-ZIP i biblioteki PclZip nie są już używane.';
