<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'pl', branch 'MOODLE_28_STABLE'
 *
 * @package   badges
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Akcje';
$string['activate'] = 'Włącz dostęp';
$string['activatesuccess'] = 'Dostęp do odznak został pomyślnie włączony.';
$string['addbadgecriteria'] = 'Dodaj kryteria odznak';
$string['addcourse'] = 'Dodaj kursy';
$string['addcourse_help'] = 'Wybierz wszystkie kursy, które powinny zostać dodane do tego wymagania odznaki. Przytrzymaj klawisz CTRL aby wybrać wiele pozycji.';
$string['addcriteria'] = 'Dodaj kryteria';
$string['addcriteriatext'] = 'Aby rozpocząć dodawanie kryteriów, wybierz jedną z opcji z menu rozwijanego.';
$string['addtobackpack'] = 'Dodaj do plecaka';
$string['adminonly'] = 'Ta strona przeznaczona jest tylko dla administratorów.';
$string['after'] = 'od daty wystawienia.';
$string['aggregationmethod'] = 'Metoda agregacji';
$string['all'] = 'Wszystkie';
$string['allmethod'] = 'Wszystkie wybrane warunki są spełnione';
$string['allmethodactivity'] = 'Wszystkie wybrane czynności są zakończone';
$string['allmethodcourseset'] = 'Wszystkie wybrane kursy są kompletne';
$string['allmethodmanual'] = 'Wszystkie wybrane role przyznają odznaki';
$string['allmethodprofile'] = 'Wszystkie wybrane pola profilu zostały wypełnione';
$string['allowcoursebadges'] = 'Włącz odznaki kursu';
$string['allowcoursebadges_desc'] = 'Pozwól na tworzenie i przyznawanie odznak w ramach kursu';
$string['allowexternalbackpack'] = 'Włącz połączenie do zewnętrznych plecaków';
$string['allowexternalbackpack_desc'] = 'Zezwalaj użytkownikom na stworzenie połączenia i wyświetlanie odznak z ich zewnętrznymi dostawcami plecaków. Uwaga: Zaleca się, aby pozostawić tę opcję wyłączoną, jeśli strona nie jest dostępna w Internecie (np. ze względu na zaporę sieciową).';
$string['any'] = 'Dowolny';
$string['anymethod'] = 'Dowolny z wybranych warunków jest spełniony';
$string['anymethodactivity'] = 'Dowolna z wybranych czynności jest zakończona';
$string['anymethodcourseset'] = 'Dowolny z wybranych kursów jest zakończony';
$string['anymethodmanual'] = 'Dowolna z wybranych ról przyznaje odznakę';
$string['anymethodprofile'] = 'Dowolne z wybranych pól profilu zostało wypełnione';
$string['archivebadge'] = 'Chcesz usunąć odznakę "{$a}", ale chcesz zachować istniejące wystawione odznaki?';
$string['archiveconfirm'] = 'Usuń i zatrzymaj istniejące wydane odznaki';
$string['archivehelp'] = '<p>Ta opcja oznacza, że odznaka zostanie oznaczona jako "emerytowany" i nie będzie dłużej pojawiać się na liście odznaczeń. Użytkownicy nie będą mogli dłużej zdobyć tej odznaki, jednakże użytkownicy, którzy zdobyli tą odznakę, będą mogli ją wyświetlać na swoich stronach profilowych i będą mogli umieszczać ją do swoich zewnętrznych plecaków.</p>
<p>Jeżeli chcesz aby twoi użytkownicy mieli dostęp do zdobytych odznak, ważne jest wybranie tej opcji zamiast pełnego usuwania odznak.</p>';
$string['attachment'] = 'Dołącz odznakę do wiadomości';
$string['attachment_help'] = 'Jeśli zaznaczone, wydana odznaka zostanie dołączona do wiadomości email odbiorcy, którą będzie można pobrać. (Załączniki muszą być włączone w Administracji Strony > Wtyczki > Wyjścia wiadomości > Email do użycia tej opcji.)';
$string['award'] = 'Przyznaj odznakę';
$string['awardedtoyou'] = 'Wydane do mnie';
$string['awardoncron'] = 'Dostęp do odznaki został pomyślnie włączony. Zbyt wielu użytkowników może natychmiast otrzymać tę odznakę. W celu zapewnienia wydajności witryny, to działanie zajmie trochę czasu na przetworzenie.';
$string['awards'] = 'Beneficjenci';
$string['backpackavailability'] = 'Zewnętrzna weryfikacja odznaki';
$string['backpackavailability_help'] = 'Dla odbiorców odznaka może udowodnić im, że zdobyli swoje odznaki od ciebie, zewnętrzny serwis plecakowy powinien uzyskać dostęp do twojej witryny i sprawdzić wydane z niego odznaki. Twoja strona nie wydaje się aby była dostępna, co oznacza że odznaki które już wydałeś lub zostaną w przyszłości wydane nie będą zweryfikowane.

##Dlaczego widzę ten komunikat?

Może tak się zdarzyć, że zapora sieciowa blokuje dostęp użytkownikom zewnętrznym spoza twojej sieci, twoja strona jest chroniona hasłem, lub strona jest uruchomiona na komputerze, który nie jest dostępny dla Internetu (np. jako lokalna maszyna).

##Czy to problem?

Należy rozwiązać ten problem na dowolnej stronie produkcyjnej, na której planowane są odznaki, w przeciwnym wypadku odbiorcy nie będą w stanie udowodnić, że zdobyli odznaki od ciebie. Jeśli twoja witryna nie jest jeszcze gotowa, można tworzyć i wydawać odznaki testowe, tak długo, dopóki strona nie jest dostępna produkcyjnie.

##Co zrobić, jeżeli nie mogę udostępnić swojego serwisu publicznie?

Tylko URL jest wymagany do weryfikacji [your-site-url]/badges/assertion.php więc jeśli jesteś w stanie zmienić swoją zaporę sieciową, aby umożliwić dostęp z zewnątrz do tego pliku, weryfikacja odznaki będzie nadal działać.';
$string['backpackbadges'] = 'Masz {$a->totalbadges} odznakę/odznak wyświetlanych z {$a->totalcollections} zbiorów. <a href="mybackpack.php">Zmień ustawienia plecaka</a>.';
$string['backpackconnection'] = 'Połączenie plecaka';
$string['backpackconnection_help'] = 'Ta strona pozwala na ustawienie połączenia z zewnętrznym dostawcą plecaka. Połączenie z plecakiem pozwala na wyświetlenie zewnętrznych odznak na tej stronie i umieszczenie w twoim plecaku zdobytych tutaj odznak.

Obecnie tylko, <a href="http://backpack.openbadges.org">Mozilla OpenBadges Backpack</a> jest obsługiwany. Musisz się zapisać do usługi plecaka przed próbą ustawienia na tej stronie połączenia z plecakiem.';
$string['backpackdetails'] = 'Ustawienia plecaka';
$string['backpackemail'] = 'Adres e-mail';
$string['backpackemail_help'] = 'Adres email jest powiązany z twoim plecakiem.

Jeżeli połączenie z plecakiem jest ustanowione, ten adres zamiast twojego wewnętrznego adresu email jest używany do umieszczania odznak w twoim plecaku.';
$string['backpackimport'] = 'Ustawienia importu odznak';
$string['backpackimport_help'] = 'Po pomyślnym połączeniu z plecakiem, odznaki z twojego plecaka mogą być wyświetlane na stronie "Moje odznaki" i profilu.

Na tym obszarze, możesz wybrać odznaki z kolecji z twojego plecaka, które chcesz wyświetlić w twoim profilu.';
$string['badgedetails'] = 'Szczegóły odznak';
$string['badgeimage'] = 'Obraz';
$string['badgeimage_help'] = 'To jest obraz, który będzie używany, gdy ta odznaka zostanie wydana.

Aby dodać nowy obraz, przeglądnij i wybierz zdjęcie (w formacie JPG lub PNG), wtedy kliknij "Zapisz zmiany". Obraz zostanie przycięty do kwadratu i przeskalowany zgodnie z wymaganiami obrazu odznaki.';
$string['badgeprivacysetting'] = 'Ustawienia prywatności odznak';
$string['badgeprivacysetting_help'] = 'Odznaki które otrzymasz będą wyświetlone na twojej stronie profilu. To ustawienie pozwala na automatycznie ustawienie widoczności nowo zdobytych odznak.

Nadal możesz kontrolować ustawienia prywatności indywidualnych odznak na twojej stronie "Moje odznaki".';
$string['badgeprivacysetting_str'] = 'Automatyczne wyświetl odznaki, które zdobyłem, na mojej stronie profilu';
$string['badgesalt'] = 'Sól dla kodowanych adresów email odbiorców';
$string['badgesalt_desc'] = 'Użycie kodowania pozwala usłudze plecaka na potwierdzanie zdobytych odznak bez konieczności narażania ich adresów email. To ustawienie powinno używać tylko liczby i litery.';
$string['badgesdisabled'] = 'Odznaki nie są włączone na tej stronie.';
$string['badgesearned'] = 'Liczba zdobytych odznak: {$a}';
$string['badgesettings'] = 'Ustawienia odznak';
$string['badgestatus_0'] = 'Niedostępne dla użytkowników';
$string['badgestatus_1'] = 'Dostępne dla użytkowników';
$string['badgestatus_2'] = 'Niedostępne dla użytkowników';
$string['badgestatus_3'] = 'Dostępne dla użytkowników';
$string['badgestatus_4'] = 'Zarchiwizowany';
$string['badgestoearn'] = 'Liczba dostępnych odznak: {$a}';
$string['badgesview'] = 'Odznaki kursu';
$string['badgeurl'] = 'Link wydanej odznaki';
$string['bawards'] = 'Beneficjenci ({$a})';
$string['bcriteria'] = 'Kryteria';
$string['bdetails'] = 'Edytuj szczegóły';
$string['bmessage'] = 'Wiadomość';
$string['boverview'] = 'Przegląd';
$string['bydate'] = 'ukończone przez';
$string['clearsettings'] = 'Wyczyść ustawienia';
$string['completioninfo'] = 'Ta odznaka została wydana za ukończenie:';
$string['completionnotenabled'] = 'Zakończenie kursu nie może być włączone dla tego kursu, więc nie może być to uwzględnione w kryteriach odznaki. Zakończenie kursu może być włączone w ustawieniach kursu.';
$string['configenablebadges'] = 'Kiedy jest włączony, ta opcja pozwala tworzyć odznaki i nagrody dla użytkowników strony.';
$string['configuremessage'] = 'Wiadomość odznaki';
$string['connect'] = 'Połącz';
$string['connected'] = 'Połączono';
$string['connecting'] = 'Łączenie ...';
$string['contact'] = 'Połącz';
$string['contact_help'] = 'Adres email jest powiązany z wydawcą odznaki.';
$string['copyof'] = 'Kopia {$a}';
$string['coursebadges'] = 'Odznaki';
$string['coursebadgesdisabled'] = 'Odznaki kursu nie są włączone na tej stronie.';
$string['coursecompletion'] = 'Użytkownicy muszą ukończyć ten kurs.';
$string['create'] = 'Nowa odznaka';
$string['createbutton'] = 'Utwórz odznakę';
$string['creatorbody'] = '<p>{$a->user} ukończył wszystkie wymagania i został wyróżniony odznaką. Zobacz wydaną odznakę na {$a->link}</p>';
$string['creatorsubject'] = '\'{$a}\' został(a) nagrodzony(a)!';
$string['criteria_0'] = 'Ta odznaka jest przyznawana, gdy ..';
$string['criteria_1'] = 'Zakończenie aktywności';
$string['criteria_1_help'] = 'Pozwala odznace nagrodzić użytkowników na podstawie ukończenia zestawu aktywności w ramach kursu.';
$string['criteria_2'] = 'Ręcznie wydanie przez rolę';
$string['criteria_2_help'] = 'Pozwala odznace nagrodzić ręcznie użytkowników, którzy posiadają szczególną rolę na stronie lub w kursie.';
$string['criteria_3'] = 'Udział społeczny';
$string['criteria_3_help'] = 'Społeczny';
$string['criteria_4'] = 'Zakończenie kursu';
$string['criteria_4_help'] = 'Pozwala odznace nagrodzić użytkowników, którzy zakończyli kurs. To kryterium może mieć dodatkowe parametry, tj. min. ocena i data zakończenia kursu.';
$string['criteria_5'] = 'Zakończenie zestawu kursów';
$string['criteria_5_help'] = 'Pozwala odznace nagrodzić użytkowników, którzy zakończyli zestaw kursów. Każdy kurs może mieć dodatkowe parametry, tj. min. ocena i data zakończenia kursu.';
$string['criteria_6'] = 'Ukończenie profilu';
$string['criteria_6_help'] = 'Pozwala odznace nagrodzić użytkowników za wypełnienie niektórych pól w profilu. Możesz wybrać z profilu domyślne i własne pola, które będą dostępne dla użytkowników.';
$string['criteriacreated'] = 'Pomyślnie utworzono kryteria odznaki';
$string['criteriadeleted'] = 'Pomyślnie skasowano kryteria odznaki';
$string['criteria_descr'] = 'Użytkownicy otrzymują tą odznakę, kiedy zakończą następujące wymagania:';
$string['criteria_descr_0'] = 'Użytkownicy otrzymują tą odznakę, kiedy zakończą <strong>{$a}</strong> z wymienionych wymogów.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> z następujących aktywności są zakończone:';
$string['criteria_descr_2'] = 'Ta odznaka może być wydawana przez użytkowników <strong>{$a}</strong> z poniższymi rolami:';
$string['criteria_descr_4'] = 'Użytkownicy muszą ukończyć kurs';
$string['criteria_descr_5'] = '<strong>{$a}</strong> następujących kursów musi być ukończone:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> z następujących pól w profilu użytkownika musi być kompletne:';
$string['criteria_descr_bydate'] = 'przez <em>{$a}</em>';
$string['criteria_descr_grade'] = 'z minimalną oceną <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Zakończono <strong>{$a}</strong> z:';
$string['criteria_descr_short1'] = 'Zakończono <strong>{$a}</strong> z:';
$string['criteria_descr_short2'] = 'Przyznawany przez <strong>{$a}</strong> z:';
$string['criteria_descr_short4'] = 'Zakończony kurs';
$string['criteria_descr_short5'] = 'Zakończono <strong>{$a}</strong> z:';
$string['criteria_descr_short6'] = 'Zakończono <strong>{$a}</strong> z:';
$string['criteria_descr_single_1'] = 'Następująca aktywność musi być zakończona:';
$string['criteria_descr_single_2'] = 'Ta odznaka może być udzielona przez użytkownika z następującą rolą:';
$string['criteria_descr_single_4'] = 'Użytkownicy muszą ukończyć kurs';
$string['criteria_descr_single_5'] = 'Następujące kursy muszą być zakończone:';
$string['criteria_descr_single_6'] = 'Poniższe pole w profilu użytkownika musi być wypełnione:';
$string['criteria_descr_single_short1'] = 'Zakończony:';
$string['criteria_descr_single_short2'] = 'Przyznawane przez:';
$string['criteria_descr_single_short4'] = 'Ukończony kurs';
$string['criteria_descr_single_short5'] = 'Zakończone:';
$string['criteria_descr_single_short6'] = 'Zakończone:';
$string['criteriasummary'] = 'Podsumowanie kryteriów';
$string['criteriaupdated'] = 'Pomyślnie zaktualizowano kryteria odznaki';
$string['criterror'] = 'Aktualne problemy parametrów';
$string['criterror_help'] = 'Ten zestaw pól pokazuje wszystkie parametry, które zostały początkowo dodane do tych wymagań odznaki, ale nie są dłużej dostępne. Jest zalecane, abyś odznaczył takie parametry, aby mieć pewność, że użytkownicy będą mogli w przyszłości otrzymać tą odznakę.';
$string['currentimage'] = 'Aktualny obraz';
$string['currentstatus'] = 'Aktualny status';
$string['dateawarded'] = 'Data wydania';
$string['dateearned'] = 'Data: {$a}';
$string['day'] = 'Dzień/dni';
$string['deactivate'] = 'Wyłącz dostęp';
$string['deactivatesuccess'] = 'Dostęp do odznak został wyłączony.';
$string['defaultissuercontact'] = 'Domyślne dane kontaktowe wydawcy odznaki';
$string['defaultissuercontact_desc'] = 'Adres email jest powiązany z wydawcą odznaki';
$string['defaultissuername'] = 'Domyślna nazwa wydawcy odznaki';
$string['defaultissuername_desc'] = 'Nazwa agenta lub instytucji wydającej.';
$string['delbadge'] = 'Chcesz usunąć odznakę "{$a}" i chcesz usunąć wszystkie istniejące wystawione odznaczenia?';
$string['delconfirm'] = 'Usuń istniejące wydane odznaki';
$string['delcritconfirm'] = 'Czy jesteś pewien, że chcesz usunąć to kryterium?';
$string['deletehelp'] = '<p>Pełne skasowanie odznaki oznacza, że wszystkie informacje i rekordy kryterium zostaną bezpowrotnie skasowane. Użytkownicy, którzy zdobyli tą odznakę nie będą mieli do niej dostępu.</p>
<p>Uwaga: Użytkownicy, którzy zdobyli tą odznakę i mają umieszczoną ją w zewnętrznym plecaku, nadal mają dostęp do tej odznaki w tym plecaku, ale nie mają dostępu do odznaki na tej stronie.</p>';
$string['delparamconfirm'] = 'Czy jesteś pewien, że chcesz usunąć ten parametr?';
$string['description'] = 'Opis';
$string['disconnect'] = 'Rozłącz';
$string['donotaward'] = 'Obecnie ta odznaka nie jest aktywna, więc nie może być przyznana użytkownikom. Jeśli chcesz przyznać tą odznakę, ustaw jej status na aktywny.';
$string['editsettings'] = 'Edytuj ustawienia';
$string['enablebadges'] = 'Włącz odznaki';
$string['error:backpackdatainvalid'] = 'Zwrócone dane z plecaka są niepoprawne.';
$string['error:backpackemailnotfound'] = 'Email \'{$a}\'  nie jest przypisany do plecaka. Musisz <a href="http://backpack.openbadges.org">utworzyć plecak</a> dla tego konta lub zalogować się z innym emailem.';
$string['error:backpackloginfailed'] = 'Nie możesz połączyć do zewnętrznego plecaka z następującego powodu {$a}';
$string['error:backpacknotavailable'] = 'Twoja strona nie jest dostępna z Internetu, więc wszelakie odznaki wydane na tej stronie nie mogą zostać zweryfikowane przez zewnętrzną usługę plecaka.';
$string['error:backpackproblem'] = 'Wystąpił problem podczas połączenia się z dostawcą usługi plecaka. Spróbuj ponownie później.';
$string['error:badjson'] = 'Próba połączenia zwróciła niepoprawne dane.';
$string['error:cannotact'] = 'Nie można aktywować odznak.';
$string['error:cannotawardbadge'] = 'Nie można przyznać odznaki użytkownikowi.';
$string['error:clone'] = 'Nie można sklonować odznaki.';
$string['error:connectionunknownreason'] = 'Połączenie nie powiodło się, ale nie wiadomo z jakiego powodu.';
$string['error:duplicatename'] = 'Odznaka o takiej nazwie już istnieje w systemie.';
$string['error:externalbadgedoesntexist'] = 'Nie znaleziono odznaki';
$string['error:guestuseraccess'] = 'Jesteś zalogowany jako gość. Aby zobaczyć odznaczenia musisz zalogować się na swoje konto użytkownika.';
$string['error:invalidbadgeurl'] = 'Nieprawidłowy format URL wydawcy odznaki';
$string['error:invalidcriteriatype'] = 'Nieprawidłowy typ kryterium.';
$string['error:invalidexpiredate'] = 'Data ważności musi wskazywać na przyszłość.';
$string['error:invalidexpireperiod'] = 'Okres ważności nie może być wartością ujemną lub równą 0.';
$string['error:noactivities'] = 'Tutaj nie ma aktywności z włączonym kryterium ukończenia w tym kursie.';
$string['error:noassertion'] = 'Brak stwierdzeń zwróconych przez Persona. Może został zamknięty dialog przez zakończeniem procesu logowania.';
$string['error:nocourses'] = 'Zakończenie kursu nie jest włączone dla żadnego kursu na tej stronie, więc nic nie może być wyświetlane. Zakończenie kursu może być włączone w ustawieniach kursu.';
$string['error:nogroups'] = '<p>Nie mam tutaj publicznych kolekcji odznak dostępnych w twoim plecaku. </p><p>Tylko publiczne kolekcje są pokazywane, <a href="http://backpack.openbadges.org">odwiedź swój plecak</a>, aby utworzyć jakąś publiczną kolekcję.</p>';
$string['error:nopermissiontoview'] = 'Nie masz uprawnień, aby zobaczyć beneficjentów odznaki.';
$string['error:nosuchbadge'] = 'Odznaka o identyfikatorze {$a} nie istnieje.';
$string['error:nosuchcourse'] = 'Ostrzeżenie: Ten kurs nie jest już dostępny.';
$string['error:nosuchfield'] = 'Ostrzeżenie: To pole profilu użytkownika nie jest już dostępne.';
$string['error:nosuchmod'] = 'Ostrzeżenie: Ta aktywność nie jest już dostępna.';
$string['error:nosuchrole'] = 'Ostrzeżenie: Ta rola nie jest już dostępna.';
$string['error:nosuchuser'] = 'Użytkownik z tym adresem email, nie ma konta u obecnego dostawcy plecaka.';
$string['error:notifycoursedate'] = 'Ostrzeżenie: Odznaki powiązane z kursem i ukończeniem aktywności nie będą wydawane do dnia rozpoczęcia kursu.';
$string['error:parameter'] = 'Ostrzeżenie: co najmniej jeden parametr powinien być wybrany w celu zapewnienia poprawnej pracy wydającego odznakę.';
$string['error:personaneedsjs'] = 'Obecnie, Javascript jest wymagany do połączenia z twoim plecakiem. Jeżeli możesz, włącz Javascript i przeładuj stronę.';
$string['error:requesterror'] = 'Żądanie połączenia nie powiodło się (kod błędu {$a}).';
$string['error:requesttimeout'] = 'Upłynął limit czasu żądania połączenia przed jego wykonaniem.';
$string['error:save'] = 'Nie można zapisać odznaki.';
$string['error:userdeleted'] = '{$a->user} (Ten użytkownik nie istnieje już na {$a->site})';
$string['evidence'] = 'Dowód';
$string['existingrecipients'] = 'Istniejący odbiorcy odznaki';
$string['expired'] = 'Wygasła';
$string['expiredate'] = 'Ta odznaka wygasa {$a}.';
$string['expireddate'] = 'Ta odznaka wygasa {$a}.';
$string['expireperiod'] = 'Ta odznaka wygasa {$a} dni po wystawieniu.';
$string['expireperiodh'] = 'Ta odznaka wygasa {$a} godzin po wystawieniu.';
$string['expireperiodm'] = 'Ta odznaka wygasa {$a} minut po wystawieniu.';
$string['expireperiods'] = 'Ta odznaka wygasa {$a} sekund po wystawieniu.';
$string['expirydate'] = 'Data ważności';
$string['expirydate_help'] = 'Opcjonalnie, odznaki mogą wygasać o określonej dacie, lub dacie obliczonej na podstawie daty wydania odznaki użytkownikowi.';
$string['externalbadges'] = 'Moje odznaki z innych stron internetowych';
$string['externalbadges_help'] = 'Ten obszar wyświetla odznaki z twojego zewnętrznego plecaka.';
$string['externalbadgesp'] = 'Odznaki z innych stron internetowych:';
$string['externalconnectto'] = 'Aby wyświetlić zewnętrzne odznaki musisz <a href="{$a}">połączyć się z plecakiem</a>.';
$string['fixed'] = 'Stała data';
$string['hidden'] = 'Ukryty';
$string['hiddenbadge'] = 'Niestety, właściciel odznaki nie wpisał żadnych informacji.';
$string['issuancedetails'] = 'Wygaśnięcie odznaki';
$string['issuedbadge'] = 'Informacje o wydanej odznace';
$string['issuerdetails'] = 'Szczegóły o wydawcy';
$string['issuername'] = 'Nazwa wydawcy';
$string['issuername_help'] = 'Nazwa agenta lub instytucji wydającej.';
$string['issuerurl'] = 'URL wydawcy';
$string['localbadges'] = 'Moje odznaki ze strony internetowej {$a}';
$string['localbadgesh'] = 'Moje odznaki z tej strony';
$string['localbadgesh_help'] = 'Wszystkie odznaki na tej stronie są zdobyte przez zakończenie kursów, aktywności w kursie i innych wymagań.

Możesz tutaj zarządzać swoimi odznakami przez stworzenie ich jako odznaki publiczne lub prywatne na swojej stronie profilu.

Możesz ściągnąć wszystkie swoje odznaki lub każdą odznakę oddzielnie i zapisać je na komputerze. Ściągnięte odznaki mogą być dodane do twojej zewnętrznej usługi plecaka.';
$string['localbadgesp'] = 'Odznaki od: {$a}';
$string['localconnectto'] = 'Aby udostępnić te odznaki na zewnątrz tej strony musisz <a href="{$a}">połączyć się z plecakiem</a>.';
$string['makeprivate'] = 'Zrób prywatne';
$string['makepublic'] = 'Zrób publiczne';
$string['managebadges'] = 'Zarządzaj odznakami';
$string['message'] = 'Treść wiadomości';
$string['messagebody'] = '<p>Otrzymałeś odznakę "%badgename%"!</p>
<p>Więcej informacji o tej odznace można uzyskać na %badgelink%.</p>
<p>Jeżeli nie ma żadnej odznaki dołączonej to tego emaila, możesz zarządzać i ściągnąć ją ze strony {$a}.</p>';
$string['messagesubject'] = 'Gratulacje! Właśnie zdobyłeś odznakę!';
$string['method'] = 'To kryterium jest ukończone, gdy ...';
$string['mingrade'] = 'Minimalna wymagana ocena';
$string['month'] = 'Miesiąc(e)';
$string['mybackpack'] = 'Moje ustawienia plecaka';
$string['mybadges'] = 'Moje odznaki';
$string['never'] = 'Nigdy';
$string['newbadge'] = 'Dodaj nową odznakę';
$string['newimage'] = 'Nowy obraz';
$string['noawards'] = 'Ta odznaka nie została jeszcze zdobyta.';
$string['nobackpack'] = 'Nie ma tu żadnej usługi plecaka podłączonej do tego konta.<br/>';
$string['nobackpackbadges'] = 'Nie ma tu żadnych odznak w kolekcji którą wybrałeś. <a href="mybackpack.php">Dodaj więcej kolekcji</a>.';
$string['nobackpackcollections'] = 'Nie ma tu żadnych kolekcji które wybrałeś. <a href="mybackpack.php">Dodaj kolekcję</a>.';
$string['nobadges'] = 'Brak dostępnych odznak';
$string['nocriteria'] = 'Kryteria dla tej odznaki nie zostały jeszcze skonfigurowane.';
$string['noexpiry'] = 'Ta odznaka nie ma daty ważności.';
$string['noparamstoadd'] = 'Nie istnieją żadne dodatkowe parametru dostępne do dodania do tego wymogu odznaki.';
$string['notacceptedrole'] = 'Twoja obecnie przypisana rola nie należy do ról, które pozwalają ręcznie wydać tą odznakę.<br/>
Jeżeli chcesz zobaczyć użytkowników, którzy zdobyli już tą odznakę, możesz odwiedzić stronę {$a}.';
$string['notconnected'] = 'Nie podłączony';
$string['nothingtoadd'] = 'Brak kryteriów do dodania.';
$string['notification'] = 'Powiadomienie twórcy odznaki';
$string['notification_help'] = 'To ustawienie zarządza powiadomieniami wysyłanymi do twórcy odznaki, aby dać mu znać, że odznaka została wydana.

Dostępne są poniższe opcje:

* **NIGDY** - nie wysyła powiadomień.

* **ZA KAŻDYM RAZEM** - wysyła powiadomienia za każdym razem kiedy ta odznaka jest przyznawana.

* **CODZIENNY** - wysyła powiadomienia raz na dzień.

* **TYGODNIOWY** - wysyła powiadomienia raz na tydzień.

* **MIESIĘCZNY** - wysyła powiadomienia raz na miesiąc.';
$string['notifydaily'] = 'Codziennie';
$string['notifyevery'] = 'Za każdym razem';
$string['notifymonthly'] = 'Miesięcznie';
$string['notifyweekly'] = 'Tygodniowo';
$string['numawards'] = 'Ta odznaka została wydana <a href="{$a->link}">{$a->count}</a> użytkownikom.';
$string['numawardstat'] = 'Ta odznaka została wydana {$a} użytkownikom.';
$string['overallcrit'] = 'z wybranych kryteriów są ukończone.';
$string['personaconnection'] = 'Zaloguj się za pomocą swojego emaila';
$string['personaconnection_help'] = 'Persona jest systemem do identyfikacji samego siebie w Internecie, przy użyciu własnego adresu email. Plecak Open Badges używa Persony jako system logowania, więc aby móc połączyć się z plecakiem, musisz mieć konto na Personie.

Aby uzyskać więcej informacji na temat Persony odwiedź <a href="https://login.persona.org/about">https://login.persona.org/about</a>.';
$string['potentialrecipients'] = 'Potencjalni beneficjenci odznak';
$string['recipientdetails'] = 'Dane odbiorcy';
$string['recipientidentificationproblem'] = 'Nie można odnaleźć odbiorcy dla tej odznaki wśród dotychczasowych użytkowników.';
$string['recipients'] = 'Beneficjenci odznak';
$string['recipientvalidationproblem'] = 'Obecny użytkownik nie może zostać zweryfikowany jako odbiorca tej odznaki.';
$string['relative'] = 'Data względna';
$string['requiredcourse'] = 'Przynajmniej jeden kurs należy dodać do kryterium zestawu kursów.';
$string['reviewbadge'] = 'Przegląd kryterium odznaki';
$string['reviewconfirm'] = '<p>Ta akcja sprawdzi czy którykolwiek z użytkowników zakończył już wszystkie wymagania dla \'{$a}\' odznaki.</p><p>Czy chcesz kontynuować?</p>';
$string['save'] = 'Zapisz';
$string['searchname'] = 'Szukaj według nazwy';
$string['selectaward'] = 'Proszę wybrać rolę, którą chcesz używać do nadawania tej odznaki:';
$string['selectgroup_end'] = 'Tylko kolekcje publiczne są pokazywane, <a href="http://backpack.openbadges.org">odwiedź swój plecak</a> aby stworzyć więcej publicznych kolekcji.';
$string['selectgroup_start'] = 'Wybierz kolekcje ze swojego plecaka do wyświetlenia na tej stronie:';
$string['selecting'] = 'Z wybranymi odznakami ...';
$string['setup'] = 'Skonfiguruj połączenie';
$string['signinwithyouremail'] = 'Zaloguj się za pomocą swojego emaila';
$string['sitebadges'] = 'Strona odznak';
$string['sitebadges_help'] = 'Odznaki strony mogą być tylko przyznawane użytkownikom za aktywność na innych powiązanych stronach. Są to ukończenia zestawu kursów lub wypełnienie pól w profilu użytkownika. Odznaki strony mogą także być wydawane ręcznie przez jednego użytkownika innemu użytkownikowi.

Odznaki dla aktywności powiązanych kursów muszą być utworzone na poziomie kursu. Odznaki kursu mogą być znalezione w Administracji kursu > Odznaki.';
$string['status'] = 'Status odznak';
$string['status_help'] = 'Status odznaki określa jej zachowanie w systemie:

* **DOSTĘPNY** - oznacza, że ta odznaka może być zdobyta przez użytkowników. Dopóki odznaka jest dostępna dla użytkowników, jej kryteria nie mogą być zmienione.

* **NIEDOSTĘPNY** - oznacza, że ta odznaka nie jest dostępna użytkownikom i nie może być zdobyta lub ręcznie wydana. Jeżeli taka odznaka nie została przedtem nigdy wydana, jej kryteria mogą być zmieniane.

Jeżeli jedna z odznak zostanie wydana przynajmniej jednemu użytkownikowi, staje się automatycznie **ZABLOKOWANA**. Odznaki zablokowane nadal mogą być zdobyte przez użytkowników, ale ich kryteria nie mogą być dłużej zmieniane. Jeżeli potrzebujesz zmienić dane lub kryteria tej zablokowanej odznaki, możesz dokonać zdublowania tej odznaki i dokonać wtedy zmian na jej duplikacie.

*Dlaczego odznaki sa blokowane?*

Chcemy się upewnić, że wszyscy użytkownicy spełnili te same wymagania zdobycia odznaki. Obecnie nie jest możliwe wycofanie odznaki. Jeżeli zezwolono na zmianę wymagań dla odznak w różnym czasie, prawdopodobnie użytkownicy otrzymają tą samą odznakę w wyniku spełnienia różnych wymogów.';
$string['statusmessage_0'] = 'Ta odznaka nie jest obecnie dostępna dla użytkowników. Aktywuj dostęp do niej, jeśli chcesz, aby użytkownicy mogli ją zarobić.';
$string['statusmessage_1'] = 'Ta odznaka jest obecnie dostępna dla użytkowników. Wyłącz do niej dostęp, by wprowadzić zmiany.';
$string['statusmessage_2'] = 'Ta odznaka nie jest obecnie dostępna dla użytkowników, a jej kryteria są zablokowane. Włącz do niej dostęp, jeśli chcesz, aby użytkownicy mogli ją zarobić.';
$string['statusmessage_3'] = 'Ta odznaka jest obecnie dostępna dla użytkowników, a jej kryteria są zablokowane.';
$string['statusmessage_4'] = 'Ta odznaka jest obecnie w archiwum.';
$string['subject'] = 'Temat wiadomości';
$string['variablesubstitution'] = 'Zastępowanie zmiennych w wiadomościach.';
$string['variablesubstitution_help'] = 'W wiadomościach odnośnie odznak, pewne zmienne mogą być wstawione w temacie i/lub w treści wiadomości, więc zastępujemy je prawdziwymi wartościami, kiedy wiadomość jest wysyłana. Zmienne powinny być wstawiane w tekście dokładnie tak jak są pokazane poniżej. Mogą być użyte poniższe zmienne:

%badgename%
:   zostanie zastąpione przez pełną nazwę odznaki.

%username%
:   zostanie zastąpione przez pełną nazwę odbiorcy.

%badgelink%
:   zostanie zastąpione przez publiczny URL z informacją o wydanej odznace.';
$string['viewbadge'] = 'Zobacz wydaną odznakę';
$string['visible'] = 'Widoczne';
$string['warnexpired'] = '(Ta odznaka wygasła!)';
$string['year'] = 'Rok/lata';
