<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'pl', branch 'MOODLE_28_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Jesteś już zalogowany jako {$a}, musisz się  wylogować przed zalogowaniem się jako inny użytkownik.';
$string['authnotexisting'] = 'Moduł autoryzacji nie istnieje';
$string['backupcontainexternal'] = 'Ta kopia zapasowa zawiera zewnętrzne hosty Moodle Network, które nie są skonfigurowane lokalnie';
$string['backuptablefail'] = 'Tworzenie kopii zapasowych tabel NIE może zakończyć się powodzeniem!';
$string['blockcannotconfig'] = 'Ten blok nie wspiera globalnej konfiguracji';
$string['blockcannotinistantiate'] = 'Problem przy tworzeniu bloku';
$string['blockcannotread'] = 'Nie mogę czytać danych dla blockid= {$a}';
$string['blockdoesnotexist'] = 'Blok ten nie istnieje';
$string['blockdoesnotexistonpage'] = 'Blok (id={$a->instanceid}) nie istnieje na tej stronie ({$a->url}).';
$string['blocknameconflict'] = 'Konflikt nazwy: blok {$a->name} ma taką samą nazwę jak istniejący blok: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Callback odrzucił ten komentarz';
$string['cannotaddcoursemodule'] = 'Nie można dodać nowego modułu kursu';
$string['cannotaddcoursemoduletosection'] = 'Nie można dodać nowego modułu kursu do tej sekcji';
$string['cannotaddmodule'] = 'Moduł {$a} nie może być dodany do listy modułów!';
$string['cannotaddnewmodule'] = 'Nie udało się dodać nowego moduł {$a}';
$string['cannotaddrss'] = 'Nie masz uprawnień do dodawania kanałów RSS';
$string['cannotaddthisblocktype'] = 'Nie możesz dodać bloku:  {$a} do tej strony.';
$string['cannotassignrole'] = 'Nie można przypisać roli dla kursu';
$string['cannotassignrolehere'] = 'Nie możesz przypisać tej roli (id = {$a->roleid}) do tej zawartości ({$a->context})';
$string['cannotassignselfasparent'] = 'Nie możesz przydzielić sobie roli rodzica!';
$string['cannotcallscript'] = 'Nie możesz wywołać tego skryptu w ten sposób';
$string['cannotcallusgetselecteduser'] = 'Nie można wywołać user_selector::get_selected_user, jeśli multi select, jest włączone.';
$string['cannotcreatebackupdir'] = 'Nie można utworzyć folderu backupdata. Administrator musi naprawić uprawnienia plików.';
$string['cannotcreatecategory'] = 'Nie wprowadzono kategorii';
$string['cannotcreatedboninstall'] = '<p>Nie można utworzyć bazy danych.</p> <p>Określona baza danych nie istnieje, a dany użytkownik nie ma uprawnień do tworzenia bazy danych.</p> <p>Administrator strony powinien sprawdzić konfigurację bazy danych.</p>';
$string['cannotcreategroup'] = 'Błąd podczas tworzenia grupy';
$string['cannotcreatelangbase'] = 'Błąd: nie można utworzyć folderu podstawowego lang';
$string['cannotcreatelangdir'] = 'Nie można utworzyć katalogu lang/';
$string['cannotcreateorfindstructs'] = 'Nie znaleziono lub błąd przy  tworzeniu struktur sekcji tego kursu';
$string['cannotcreatepopupwin'] = 'Niezdefiniowany element - nie można utworzyć okna pop-up';
$string['cannotcreatesitedir'] = 'Nie można utworzyć folderu strony. Administrator strony musi naprawić uprawnienia plików.';
$string['cannotcreatetempdir'] = 'Nie można utworzyć katalogu tymczasowego';
$string['cannotcreateuploaddir'] = 'Nie można utworzyć folderu upload. Administrator strony musi naprawić uprawnienia plików.';
$string['cannotcustomisefiltersblockuser'] = 'Nie można dostosować ustawień filtru w kontekstach użytkowników lub bloków.';
$string['cannotdeletebackupids'] = 'Nie można skasować poprzednie identyfikatory kopii zapasowej.';
$string['cannotdeletecategorycourse'] = 'Nie udało sie usunąć kursu: \'{$a}\'';
$string['cannotdeletecategoryquestions'] = 'Nie można usunąć pytania z kategorii: \'{$a}\'';
$string['cannotdeletecourse'] = 'Nie masz uprawnień do usunięcia tego kursu';
$string['cannotdeletecustomfield'] = 'Błąd podczas usuwania niestandardowych pól użytkownika';
$string['cannotdeletedir'] = 'Nie można usunąć ({$a})';
$string['cannotdeletefile'] = 'Nie można usunąć pliku';
$string['cannotdeleterole'] = 'Nie może być usunięty, ponieważ {$a}';
$string['cannotdeleterolewithid'] = 'Nie można usunąć roli o identyfikatorze {$a}';
$string['cannotdeletethisrole'] = 'Nie można usunąć tej roli, ponieważ jest ona używana przez system lub jest to ostatnia rola z prawami administratora.';
$string['cannotdisableformat'] = 'Nie możesz wyłączyć domyślnego formatu';
$string['cannotdownloadcomponents'] = 'Nie można pobrać składowych (komponentów)';
$string['cannotdownloadlanguageupdatelist'] = 'Nie można pobrać listy uaktualnień języka z download.moodle.org';
$string['cannotdownloadzipfile'] = 'Nie można pobrać pliku ZIP';
$string['cannoteditcomment'] = 'Ten komentarz nie jest twój, więc nie możesz go edytować!';
$string['cannoteditcommentexpired'] = 'Nie możesz tego edytować. Czas wygasł!';
$string['cannoteditpostorblog'] = 'Nie możesz dodawać lub edytować blogów';
$string['cannoteditsiteform'] = 'Nie możesz edytować tej witryny za pomocą tego formularza';
$string['cannotedityourprofile'] = 'Przepraszamy, nie możesz edytować swojego profilu';
$string['cannotexecduringupgrade'] = 'Nie może być wykonywane podczas uaktualniania';
$string['cannotfindcategory'] = 'Nie może znaleźć rekordu kategorii w bazie danych przez ID - {$a}';
$string['cannotfindcomponent'] = 'Nie można znaleźć komponentu';
$string['cannotfindcontext'] = 'Nie można znaleźć kontekstu';
$string['cannotfindcourse'] = 'Nie można znaleźć kursu';
$string['cannotfinddocs'] = 'Nie można znaleźć "{$a}" plików dokumentacji języka';
$string['cannotfindgradeitem'] = 'Nie można znaleźć grade_item';
$string['cannotfindgroup'] = 'Nie można znaleźć grupy';
$string['cannotfindhelp'] = 'Nie można znaleźć "{$a}" plików pomocy języka';
$string['cannotfindinfo'] = 'Nie można znaleźć informacji dla: "{$a}"';
$string['cannotfindlang'] = 'Nie można znaleźć pakietu językowego: "{$a}"!';
$string['cannotfindteacher'] = 'Nie można znaleźć nauczyciela';
$string['cannotfinduser'] = 'Nie można znaleźć użytkownika "{$a}"';
$string['cannotgeoplugin'] = 'Nie można połączyć się do serwera geoPlugin http://www.geoplugin.com, proszę sprawdzić ustawienia proxy lub lepiej zainstalować pliki danych MaxMind GeoLite City';
$string['cannotgetblock'] = 'Nie można pobrać bloków z bazy danych';
$string['cannotgetcats'] = 'Nie można pobrać rekordu kategorii';
$string['cannotgetdata'] = 'Nie można pobrać danych';
$string['cannotgradeuser'] = 'Nie można ocenić tego użytkownika';
$string['cannothaveparentcate'] = 'Kategoria szkolenia nie może mieć rodziców!';
$string['cannotimport'] = 'Błąd importu';
$string['cannotimportformat'] = 'Przepraszamy, import tego formatu nie został jeszcze zaimplementowany!';
$string['cannotimportgrade'] = 'Błąd importu ocen';
$string['cannotinsertgrade'] = 'Nie można wstawić pozycji oceny bez course id!';
$string['cannotinsertrate'] = 'Nie można wstawić nowej oceny ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Nie można wprowadzić nowego rekordu ID {$a}';
$string['cannotmailconfirm'] = 'Błąd podczas wysłania e-maila potwierdzającego zmianę hasła';
$string['cannotmanualctrack'] = 'Aktywność nie umożliwia ręcznego śledzenie ukończenia';
$string['cannotmapfield'] = 'wykryta sprzeczność w Mapowanie - dwa pola mapowane są do tej samej oceny {$a}';
$string['cannotmarktopic'] = 'Nie można odznaczyć tego tematu dla tego kursu';
$string['cannotmigratedatacomments'] = 'Nie można migrować komentarzy modułu danych';
$string['cannotmodulename'] = 'Nie można uzyskać nazwę modułu w konstrukcji nawigacji';
$string['cannotmoduletype'] = 'Nie można uzyskać typu modułu w konstrukcji nawigacji';
$string['cannotmovecategory'] = 'Nie można przenieść kategorii';
$string['cannotmovecourses'] = 'Nie można przenieść kursów do innej kategorii z kategorii w której są.';
$string['cannotmoverolewithid'] = 'Nie można przenieść roli o identyfikatorze: {$a}';
$string['cannotopencsv'] = 'Nie można otworzyć pliku CSV';
$string['cannotopenfile'] = 'Nie można otworzyć pliku ({$a})';
$string['cannotopenforwrit'] = 'Nie można otworzyć do zapisu: {$a}';
$string['cannotopentemplate'] = 'Nie można otworzyć pliku szablonu ({$a})';
$string['cannotopenzip'] = 'Nie można otworzyć pliku zip, prawdopodobnie bug związany z rozszerzeniem zip na 64-bitowych systemach';
$string['cannotoverridebaserole'] = 'Nie może nadpisać uprawnień bazowych ról';
$string['cannotoverriderolehere'] = 'Nie masz uprawnień, aby zastąpić tę rolę (id = {$a->roleid})  w tym kontekście ({$a->context})';
$string['cannotreadfile'] = 'Nie można odczytać pliku ({$a})';
$string['cannotreadtmpfile'] = 'Błąd odczytu pliku tymczasowego';
$string['cannotreaduploadfile'] = 'Nie można odczytać przesłanego pliku';
$string['cannotremovefrommeta'] = 'Nie można usunąć zaznaczonego kursu z tego metakursu!';
$string['cannotresetguestpwd'] = 'Nie można zresetować hasła użytkownika: gość';
$string['cannotresetmail'] = 'Błąd resetowania hasła i wysłania e-maila';
$string['cannotresetthisrole'] = 'Nie można zresetować tej roli';
$string['cannotrestore'] = 'Wystąpił błąd i odtworzenie nie może być zakończone!';
$string['cannotrestoreadminorcreator'] = 'Musisz być twórcą lub administratorem, aby móc przywrócić do nowego kursu!';
$string['cannotrestoreadminoredit'] = 'Musisz być nauczycielem z prawami edycji lub administratorem, aby móc przywrócić do zaznaczonego kursu!';
$string['cannotsaveagreement'] = 'Nie udało się zapisać twojej zgody';
$string['cannotsaveblock'] = 'Błąd podczas zapisu konfiguracji bloku';
$string['cannotsavecomment'] = 'Nie można zapisać komentarza';
$string['cannotsavedata'] = 'Nie można zapisać danych';
$string['cannotsavefile'] = 'Nie można zapisać pliku "{$a}"!';
$string['cannotsavemd5file'] = 'Nie można zapisać pliku md5';
$string['cannotsavezipfile'] = 'Nie można zapisać pliku ZIP';
$string['cannotservefile'] = 'Problem z plikiem - problem z konfiguracja serwera.';
$string['cannotsetparentforcatoritem'] = 'Nie można ustawić rodzica dla kategorii lub elementu kursu!';
$string['cannotsetpassword'] = 'Nie można ustawić hasła użytkownika!';
$string['cannotsetprefgrade'] = 'Nie można ustawić preferencji widoku agregacji do {$a} dla tej kategorii oceny';
$string['cannotsettheme'] = 'Nie można ustawić motywu!';
$string['cannotsetupblock'] = 'Tabele bloków NIE mogą zostać pomyślnie ustawione!';
$string['cannotsetupcapformod'] = 'Nie można ustawić zdolności dla {$a}';
$string['cannotsetupcapforplugin'] = 'Nie można ustawić zdolności dla {$a}';
$string['cannotshowhidecoursesincategory'] = 'Nie można pokazać/ukryć kursów w kategorii {$a}';
$string['cannotsignup'] = 'Nie możesz utworzyć nowego konta, ponieważ jesteś już zalogowany jako {$a}.';
$string['cannotunassigncap'] = 'Nie można cofnąć przestarzałej uprawnienia {$a->cap} roli {$a->role}';
$string['cannotunassignrolefrom'] = 'Nie można wypisać tego użytkownika z id roli: {$a}';
$string['cannotunzipfile'] = 'Nie można rozpakować (unzip) pliku';
$string['cannotupdatemod'] = 'Nie można zaktualizować {$a}';
$string['cannotupdatepasswordonextauth'] = 'Nie udało się zaktualizować hasła z zewnętrznej autoryzacji: {$a}. Zobacz logi serwera, aby uzyskać więcej szczegółów.';
$string['cannotupdateprofile'] = 'Błąd podczas aktualizacji rekordu użytkownika';
$string['cannotupdaterecord'] = 'Nie można uaktualnić rekordu ID {$a}';
$string['cannotupdaterss'] = 'Nie można zaktualizować RSS';
$string['cannotupdatesubcourse'] = 'Nie można zaktualizować podrzędnego kursu!';
$string['cannotupdateusermsgpref'] = 'Ustawienia wiadomości nie mogły zostać zmienione';
$string['cannotupdateuseronexauth'] = 'Nie udało się zaktualizować danych użytkownika z zewnętrznej autoryzacji: {$a}. Zobacz logi serwera, aby uzyskać więcej szczegółów.';
$string['cannotuploadfile'] = 'Błąd przetwarzania przesyłanego pliku';
$string['cannotuseadmin'] = 'Musisz być administratorem, aby móc skorzystać z tej strony';
$string['cannotuseadminadminorteacher'] = 'Musisz być nauczycielem lub administratorem, aby móc skorzystać z tej strony';
$string['cannotusepage'] = 'Tylko nauczyciele i administratorzy mogą korzystać z tej strony';
$string['cannotusepage2'] = 'Przepraszamy, nie możesz korzystać z tej strony';
$string['cannotviewprofile'] = 'Nie możesz wyświetlić profilu tego użytkownika';
$string['cannotviewreport'] = 'Nie możesz zobaczyć tego raport';
$string['cannotwritefile'] = 'Nie można zapisać danych do pliku ({$a})';
$string['categoryerror'] = 'Błąd kategorii';
$string['categoryidnumbertaken'] = 'Numer ID jest już używany przez inną kategorię';
$string['categorynamerequired'] = 'Nazwa kategorii jest wymagana';
$string['categorytoolong'] = 'Nazwa kategorii jest zbyt długa';
$string['commentmisconf'] = 'ID komentarza jest źle skonfigurowany';
$string['componentisuptodate'] = 'Komponent jest aktualny';
$string['confirmsesskeybad'] = 'Przepraszamy, ale klucz sesji nie został potwierdzony co pozwoliłoby na wykonanie tej czynności. Zabezpieczenie te zapobiega przypadkowemu lub złośliwemu wykonaniu operacji w Twoim imieniu. Upewnij się czy napewno chciałeś wykonać tę operację.';
$string['couldnotassignrole'] = 'Podczas przypisywania roli wystąpił poważny, nieokreślony błąd.';
$string['couldnotupdatenoexistinguser'] = 'Nie można zaktualizować użytkownika - użytkownik nie istnieje';
$string['countriesphpempty'] = 'Błąd: Plik countries.php w paczce językowej {$a} jest pusty lub nie istnieje.';
$string['coursedoesnotbelongtocategory'] = 'Kurs nie należy do tej kategorii';
$string['courseformatnotfound'] = 'Format kursu \'{$a}\' nie istnieje lub nie został rozpoznany';
$string['coursegroupunknown'] = 'Nie określono kursu dla grupy {$a}';
$string['courseidnotfound'] = 'Identyfikator kursu nie istnieje';
$string['courseidnumbertaken'] = 'Numer ID jest już używany przez inny kurs ({$a})';
$string['coursemisconf'] = 'Kurs jest źle skonfigurowany';
$string['courserequestdisabled'] = 'Przykro nam, ale żądane kursy zostały wyłączone przez administratora';
$string['csvcolumnduplicates'] = 'Wykryto zduplikowane kolumny';
$string['csvemptyfile'] = 'Plik CSV jest pusty';
$string['csvfewcolumns'] = 'Niewystarczająca liczba kolumn. Sprawdź ustawienia ograniczeń.';
$string['csvinvalidcols'] = '<b>Nieprawidłowy plik CSV:</b> Pierwsza linia musi zawierać &quot;nagłówki pól&quot; i plik musi być typu <br /> &quot;Comma separated\',  rozdzielony przecinkami.';
$string['csvinvalidcolsnum'] = 'Nieprawidłowy plik CSV - każda linia musi zawierać 49 lub 70 pól';
$string['csvloaderror'] = 'Błąd podczas ładowania pliku CSV!';
$string['csvweirdcolumns'] = 'Niepoprawny format pliku CSV - liczba kolumn nie jest stała!';
$string['dbconnectionfailed'] = '<p> Błąd: Połączenie z bazą danych nie powiodło się </p><p> Możliwe, że baza danych jest przeciążony lub nie działa prawidłowo. </p><p> Administrator sieci powinien również sprawdzić, czy parametry bazy zostały poprawnie określone w config.php </p>';
$string['dbdriverproblem'] = '<p> Błąd: Wykryto problem ze sterownikiem bazy danych </p><p> Administrator sieci powinien sprawdzić konfigurację serwera </p><p> {$a} </p>';
$string['dbsessionbroken'] = 'Wykryto poważny problem z sesją bazy danych.<br /><br />Proszę powiadomić administratora serwera.';
$string['dbsessionhandlerproblem'] = 'Konfigurowanie sesji bazy danych nie powiodło się. <br /><br /> Proszę powiadomić administratora serwera.';
$string['dbsessionmysqlpacketsize'] = 'Wykryto poważny problem z sesją. <br /><br /> Proszę powiadomić administratora, problem jest prawdopodobnie spowodowany przez zbyt małą wartość max_allowed_packet w ustawieniach MySQL .';
$string['dbupdatefailed'] = 'Aktualizacja bazy danych nie powiodła się';
$string['ddldependencyerror'] = 'Nie można zmodyfikować {$a->targettype} "{$a->targetname}". Znaleziono zależność pomiędzy {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Błąd wykonania DDL sql';
$string['ddlfieldalreadyexists'] = 'Pole "{$a}" już istnieje';
$string['ddlfieldnotexist'] = 'Pole "{$a->fieldname}" nie istnieje w tabeli "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabela "{$a}" już istnieje';
$string['ddltablenotexist'] = 'Tabela "{$a}" nie istnieje';
$string['ddlunknownerror'] = 'Nieznany błąd biblioteki DDL';
$string['ddlxmlfileerror'] = 'Znaleziono błędy plików bazy danych XML';
$string['ddsequenceerror'] = 'Nieprawidłowa definicja tabeli "{$a}". Może istnieć tylko jedno pole auto i musi ono być zdefiniowane jako klucz.';
$string['destinationcmnotexit'] = 'Docelowy moduł kursu nie istnieje';
$string['detectedbrokenplugin'] = 'Plugin "{$a}" jest wadliwy lub nieaktualny, nie można kontynuować, przepraszamy.';
$string['dmlexceptiononinstall'] = '<p> Wystąpił błąd bazy danych [{$a->errorcode}]. <br /> {$a->debuginfo} </p>';
$string['dmlreadexception'] = 'Błąd odczytu z bazy danych';
$string['dmltransactionexception'] = 'Błąd transakcji bazy danych';
$string['dmlwriteexception'] = 'Błąd zapisu do bazy danych';
$string['downgradedcore'] = 'BŁĄD! Ta baza danych została wykonana na wersji kodu NOWSZEJ niż używana przez ciebie obecnie!';
$string['downloadedfilecheckfailed'] = 'Sprawdzenie pobranego pliku zakończyło się niepowodzeniem';
$string['duplicatefieldname'] = 'Wykryto powtarzającą się nazwę pola &quot;{$a}&quot;';
$string['duplicatenosupport'] = 'moduł aktywności \'{$a->modname}\' nie może być powielany, ponieważ moduł {$a->modtype} nie obsługuje tworzenia kopii zapasowych i przywracania.';
$string['duplicateparaminsql'] = 'ERROR: powtórzona nazwa parametru w zapytaniu';
$string['duplicaterolename'] = 'Istnieje już rola o tej nazwie!';
$string['duplicateroleshortname'] = 'Istnieje już rola z taką krótką nazwą!';
$string['duplicateusername'] = 'Nazwa użytkownika jest zduplikowana - rekord został pominięty';
$string['emailfail'] = 'Wysyłanie emaila nie powiodło się';
$string['error'] = 'Wystąpił błąd';
$string['errorcleaningdirectory'] = 'Błąd czyszczenia katalogu "{$a}"';
$string['errorcopyingfiles'] = 'Błąd podczas kopiowania plików';
$string['errorcreatingdirectory'] = 'Błąd podczas tworzenia katalogu "{$a}"';
$string['errorcreatingfile'] = 'Błąd podczas tworzenia pliku "{$a}"';
$string['errorcreatingrole'] = 'Błąd podczas tworzenia roli';
$string['errorfetchingrssfeed'] = 'Błąd podczas pobierania treści RSS.';
$string['erroronline'] = 'Błąd w linii {$a}';
$string['errorparsingxml'] = 'Błąd parsowania XML: {$a->errorstring} w linii {$a->errorline}, znak {$a->errorchar}';
$string['errorprocessingarchive'] = 'Błąd podczas przetwarzania pliku archiwum';
$string['errorreadingfile'] = 'Błąd podczas odczytu z pliku "{$a}"';
$string['errorsavingrequest'] = 'Wystąpił błąd podczas próby zapisania żądania.';
$string['errorsettinguserpref'] = 'Błąd podczas ustawianie preferencji użytkownika';
$string['errorunzippingfiles'] = 'Błąd podczas rozpakowywania plików';
$string['expiredkey'] = 'Klucz wygasł';
$string['externalauthpassworderror'] = 'Niepuste hasło zewnętrznego uwierzytelniania';
$string['externalfilenolocation'] = 'Zewnętrzny plik nie ma ścieżki lokalizacji';
$string['failtoloadblocks'] = 'Jeden lub więcej bloków jest zarejestrowanych w bazie danych, ale nie może zostać załadowane!';
$string['fieldrequired'] = '"{$a}" jest polem wymaganym';
$string['fileexists'] = 'Plik istnieje';
$string['filemismatch'] = 'Brak zgodności nazwy pliku. Plik "{$a->current}" powinien być {$a->file}';
$string['filenotfound'] = 'Żądany plik nie został znaleziony';
$string['filenotreadable'] = 'Odczyt pliku niemozliwy';
$string['filterdoesnothavelocalconfig'] = 'Filtr {$a} nie umożliwia lokalnej konfiguracji.';
$string['filternotactive'] = 'Filtr {$a} nie jest obecnie aktywny';
$string['filternotenabled'] = 'Filtr nie aktywny!';
$string['filternotinstalled'] = 'Filtr {$a} nie jest obecnie  zainstalowany';
$string['forumblockingtoomanyposts'] = 'Przekroczyłeś liczbę możliwych wpisów, które można zamieścić na tym forum';
$string['generalexceptionmessage'] = 'Wyjątek - {$a}';
$string['gradecantregrade'] = 'Wystąpił błąd podczas obliczenia oceny: {$a}';
$string['gradepubdisable'] = 'Publikowanie ocen jest wyłączone';
$string['groupalready'] = 'Użytkownik należy już do grupy {$a}';
$string['groupexistforcourse'] = 'Grupa "{$a}" została już utworzona w tym kursie';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Grupa "{$a->name}" z nr id "{$a->idnumber}" już istnieje dla tego kursu';
$string['grouphasidnumber'] = 'Grupa "{$a}" ma nr id i może być tworzona automatycznie przez system zewnętrzny. Nie masz uprawnień do usunięcia tej grupy.';
$string['groupinghasidnumber'] = 'Grupa nadrzędna "{$a}" ma nr id i może być tworzone automatycznie przez system zewnętrzny. Nie masz uprawnień do usunięcia tej grupy.';
$string['groupingnotaddederror'] = 'Grupa nadrzędna "{$a}" nie została dodana';
$string['groupnotaddederror'] = 'Grupa "{$a}" nie została utworzona';
$string['groupnotaddedtogroupingerror'] = 'Grupa "{$a->groupname}" nie została dodana do grupy nadrzędnej "{$a->groupingname}"';
$string['groupunknown'] = 'Grupa {$a} nie jest przypisana do tego kursu';
$string['groupusernotmember'] = 'Użytkownik nie jest członkiem tej grupy.';
$string['guestcantaccessprofiles'] = 'Goście nie mogą uzyskać dostępu do profili użytkowników. Zaloguj się zna swoje konto, aby kontynuować.';
$string['guestnocomment'] = 'Goście nie mogą pisać komentarzy!';
$string['guestnoeditprofile'] = 'Gość nie może edytować swojego profilu.';
$string['guestnoeditprofileother'] = 'Profil gościa nie może być zmieniony';
$string['guestnorate'] = 'Goście nie mogą oceniać wpisów';
$string['guestsarenotallowed'] = 'Gość nie może tego robić';
$string['hackdetected'] = 'Wykryto atak hakerski!';
$string['hashpoolproblem'] = 'Nieprawidłowy plik {$a}.';
$string['headersent'] = 'Nagłówki zostały już wysłane';
$string['idnumbertaken'] = 'Identyfikator kursu jest już wykorzystywany przez inny kurs';
$string['idnumbertoolong'] = 'Identyfikator jest zbyt długi';
$string['importformatnotimplement'] = 'Przepraszamy, importowanie z tego formatu nie zostało jeszcze wdrożone!';
$string['incorrectext'] = 'Plik ma nieprawidłowe rozszerzenie';
$string['installproblem'] = 'Zwykle nie ma możliwości skorygowania błędów pojawiających się podczas instalacji i kontynuacji; być może trzeba będzie utworzyć nową bazę danych lub użyć innego prefiksu bazy danych, jeśli chcesz ponowić instalację.';
$string['internalauthpassworderror'] = 'Brak hasła lub błąd polityki bezpieczeństwa dla wewnętrznego uwierzytelniania';
$string['invalidaccess'] = 'Ta strona nie była prawidłowo dostępna';
$string['invalidaccessparameter'] = 'Nieprawidłowy parametr dostępu';
$string['invalidaction'] = 'Nieprawidłowa akcja';
$string['invalidactivityid'] = 'Nieprawidłowe ID aktywności';
$string['invalidadminsettingname'] = 'Nieprawidłowe ustawienie administratora ({$a})';
$string['invalidargorconf'] = 'Nie podano argumentów lub nieprawidłowa konfiguracja serwera';
$string['invalidarguments'] = 'Nie podano prawidłowych argumentów';
$string['invalidblockinstance'] = 'Nieprawidłowy instancja bloku dla: {$a}';
$string['invalidbulkenrolop'] = 'Nieprawidłowa zbiorcza operacja zapisu na kurs.';
$string['invalidcategory'] = 'Niepoprawna kategoria!';
$string['invalidcategoryid'] = 'Niepoprawny identyfikator kategorii!';
$string['invalidcomment'] = 'Komentarz jest niepoprawny';
$string['invalidcommentarea'] = 'Nieprawidłowa wartość \'commentarea\'';
$string['invalidcommentid'] = 'Nieprawidłowa wartość \'commentid\'';
$string['invalidcommentitemid'] = 'Nieprawidłowa wartość \'itemid\' komentarza';
$string['invalidcommentparam'] = 'Nieprawidłowa parametry komentarza';
$string['invalidcomponent'] = 'Nieprawidłowa nazwa składnika';
$string['invalidconfirmdata'] = 'Błędne dane zatwierdzania użytkownika';
$string['invalidcontext'] = 'Niepoprawny kontekst';
$string['invalidcourse'] = 'Niepoprawny kurs';
$string['invalidcourseid'] = 'Próbujesz użyć nieważnego kursu ID';
$string['invalidcourselevel'] = 'Nieprawidłowy poziom kontekstu';
$string['invalidcoursemodule'] = 'Nieważny ID modułu kursu';
$string['invalidcoursenameshort'] = 'Nieprawidłowa krótka nazwa kursu';
$string['invaliddata'] = 'Podano nieprawidłowe dane';
$string['invaliddatarootpermissions'] = 'Wykryto nieprawidłowe uprawnienia folderu $CFG->dataroot. Administrator musi naprawić ten problem.';
$string['invaliddevicetype'] = 'Nieprawidłowy typ urządzenia';
$string['invalidelementid'] = 'Nieprawidłowy identyfikator elementu!';
$string['invalidentry'] = 'To jest nieprawidłowy wpis!';
$string['invalidevent'] = 'Nieprawidłowe wydarzenie';
$string['invalidfieldname'] = '"{$a}" nie jest nazwą dozwoloną.';
$string['invalidfiletype'] = '"{$a}" nie jest obsługiwanym typem pliku';
$string['invalidformatpara'] = 'Nieprawidłowy format dla wybranego parametru';
$string['invalidformdata'] = 'Nieprawidłowe dane formularza';
$string['invalidfunction'] = 'Niepoprawna funkcja';
$string['invalidgradeitemid'] = 'Nieprawidłowe id oceny';
$string['invalidgroupid'] = 'Określono nieprawidłowe id grupy';
$string['invalidipformat'] = 'Niewłaściwy format adresu IP';
$string['invaliditemid'] = 'Nieprawidłowe id elementu';
$string['invalidkey'] = 'Niewłaściwy klucz';
$string['invalidlegacy'] = 'Nieprawidłowa definicja przestarzałej roli dla typu: {$a}';
$string['invalidmd5'] = 'Niewłaściwy md5';
$string['invalidmode'] = 'Nieprawidłowy tryb ({$a})';
$string['invalidmodule'] = 'Nieprawidłowy moduł';
$string['invalidmoduleid'] = 'Nieprawidłowy identyfikator modułu: {$a}';
$string['invalidmodulename'] = 'Nieprawidłowa nazwa modułu: {$a}';
$string['invalidnum'] = 'Nieprawidłowa wartość liczbowa';
$string['invalidnumkey'] = 'Tablica $warunki nie może zawierać znaków numerycznych, należy poprawić kod!';
$string['invalidoutcome'] = 'Nieprawidłowy id efektu kształcenia';
$string['invalidpagesize'] = 'Błędny rozmiar strony';
$string['invalidpasswordpolicy'] = 'Niepoprawne zasady hasła';
$string['invalidpaymentmethod'] = 'Nieprawidłowa metoda płatności: {$a}';
$string['invalidqueryparam'] = 'BŁĄD: Nieprawidłowa liczba parametrów zapytania. Oczekiwano {$a->expected}, otrzymano {$a->actual}.';
$string['invalidratingarea'] = 'Nieprawidłowy parametr \'ratingarea\'';
$string['invalidrecord'] = 'Nie znaleziono rekordu danych w tabeli {$a}';
$string['invalidrecordunknown'] = 'Nie znaleziono rekordu w bazie danych';
$string['invalidrequest'] = 'Niewłaściwe żądanie';
$string['invalidrole'] = 'Niewłaściwa rola';
$string['invalidroleid'] = 'Nieprawidłowy ID roli';
$string['invalidscaleid'] = 'Nieprawidłowy ID skali';
$string['invalidsection'] = 'Rekord modułu kursu zawiera nieprawidłową sekcję';
$string['invalidsesskey'] = 'Przesłano nieprawidłowy sesskey, formularz nie został przyjęty!';
$string['invalidshortname'] = 'To niepoprawna nazwa skrócona kursu';
$string['invalidsourcefield'] = 'Pole pliku źródłowego szkicu jest nieprawidłowe';
$string['invalidstatedetected'] = 'Coś poszło nie tak: {$a}. Normalnie to się nie zdarza.';
$string['invalidurl'] = 'Niepoprawny URL';
$string['invaliduser'] = 'Nieprawidłowy użytkownik';
$string['invaliduserfield'] = 'Nieprawidłowe pole użytkownika: {$a}';
$string['invaliduserid'] = 'Nieprawidłowy identyfikator użytkownika';
$string['invalidusername'] = 'Podana nazwa użytkownika zawiera niedozwolone znaki';
$string['invalidxmlfile'] = '"{$a}" nie jest obsługiwanym plikiem XLM';
$string['iplookupfailed'] = 'Nie można znaleźć informacji o geograficznej lokalizacji tego adresu IP';
$string['iplookupprivate'] = 'Nie można wyświetlić prywatnych adresów IP';
$string['ipmismatch'] = 'Niezgodny adres IP klienta';
$string['listcantmovedown'] = 'Nie można przesunąć elementu w dół, ponieważ jest on już ostatnim z pośród elementów';
$string['listcantmoveleft'] = 'Nie można przesunąć elementu w lewo z powodu braku porzednika (parent)';
$string['listcantmoveright'] = 'Nie można przesunąć elementu w prawo, ponieważ nie ma żadnego innego elementu, którego byłby następcą. Przemieść go poniżej innego elementu aby móc przesunąć go w prawo';
$string['listcantmoveup'] = 'Nie można przesunąć elementu w górę, ponieważ jest on już pierwszym z pośród elementów';
$string['listnochildren'] = 'Nie znaleziono następcy (children) elementu';
$string['listnoitem'] = 'Nie znaleziono elementu';
$string['listnopeers'] = 'Nie znaleziono innych elementów';
$string['listupdatefail'] = 'Operacja na DB zakończyła się niepowodzeniem poczas edycji hierarchi listy';
$string['logfilenotavailable'] = 'Logi nie są dostępne';
$string['loginasnoenrol'] = 'Nie możesz używać funkcji \'zapisz na kurs\' i \'wypisz z kursu\', będąc \'zalogowanym jako\' inny użytkownik.';
$string['loginasonecourse'] = 'Nie możesz wejść do kursu.<br/> Musisz zakończyć sesję \'Zaloguj się jako\', aby wejść do innego kursu.';
$string['maxareabytes'] = 'Plik jest większy niż pozostałe miejsce w tym obszarze.';
$string['maxbytes'] = 'Plik jest większy niż maksymalny rozmiar';
$string['messagingdisable'] = 'Przesyłanie wiadomości jest wyłączone na tej stronie';
$string['mimetexisnotexist'] = 'W twoim systemie nie jest skonfigurowany mimeTeX. Musisz pobrać odpowiedni dla twojej platformy PHP_OS plik wykonywalny z <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a> lub ściągnąć źródła w języku C z <a href="http://www.forkosh.com/mimetex.zip">http://www.forkosh.com/mimetex.zip</a>, skompilować je i umieścić plik wykonywalny do swojej katalogu moodle/filter/tex/';
$string['mimetexnotexecutable'] = 'Niestandardowy mimetex nie jest plikiem wykonywalnym!';
$string['missingfield'] = 'Brakuje pola "{$a}" .';
$string['missingkeyinsql'] = 'BŁĄD: w zapytaniu brakuje parametru &quot;{$a}&quot;';
$string['missing_moodle_backup_xml_file'] = 'W kopii brakuje pliku XML: {$a}';
$string['missingparam'] = 'Brakowało wymaganego parametru ({$a})';
$string['missingparameter'] = 'Brak parametru';
$string['missingrequiredfield'] = 'Brak wymaganego pola';
$string['missinguseranditemid'] = 'Brak userid i itemid';
$string['missingvarname'] = 'Brakuje wymaganej nazwy zmiennej!';
$string['mixedtypesqlparam'] = 'BŁĄD: Niezgodność typów parametrów zapytania sql!';
$string['mnetdisable'] = 'MNET jest wyłączony';
$string['mnetlocal'] = 'Zdalni użytkownicy MNET nie mogą logować się lokalnie';
$string['moduledisable'] = 'Moduł ({$a}) został wyłączony dla tego kursu';
$string['moduledoesnotexist'] = 'Ten moduł nie istnieje';
$string['moduleinstancedoesnotexist'] = 'Instancja tego modułu nie istnieje';
$string['modulemissingcode'] = 'Modułowi {$a} brakuje kodu niezbędnego do działania tej funkcji';
$string['movecatcontentstoroot'] = 'Przeniesienie zawartości kategorii do korzenia nie jest dozwolone. Musisz przenieść zawartość do istniejącej kategorii!';
$string['movecategorynotpossible'] = 'Nie możesz przenieść kategorii \'{$a}\' do wybranej kategorii.';
$string['movecategoryownparent'] = 'Nie możesz stworzyć kategorii \'{$a}\' jako własnego rodzica.';
$string['movecategoryparentconflict'] = 'Nie możesz stworzyć kategorii \'{$a}\' jako podkategorię jednej z jej własnych podkategorii.';
$string['multiplerecordsfound'] = 'Wiele rekordów znaleziono, gdy oczekiwano tylko jednego';
$string['multiplerestorenotallow'] = 'Nie wolno wielokrotnie wykonywać przywracania!';
$string['mustbeloggedin'] = 'Musisz być zalogowany, aby to zrobić';
$string['mustbeteacher'] = 'Dostęp do tej strony mają tylko nauczyciele';
$string['myisamproblem'] = 'Tabele bazy danych używają silnika bazy danych MyISAM. Zaleca się używać silnika zgodnego z ACID z pełną obsługą transakcji, takich jak InnoDB.';
$string['needcopy'] = 'Najpierw należy coś  skopiować!';
$string['needcoursecategroyid'] = 'Należy określić albo id kursu, albo kategorii';
$string['needphpext'] = 'Musisz dodać {$a} do swojej instalacji PHP';
$string['noadmins'] = 'Brak administratorów!';
$string['noblocks'] = 'Nie znaleziono bloków!';
$string['nocapabilitytousethisservice'] = 'Użytkownik nie uprawnień wymaganych do korzystania z tej usługi';
$string['nocategorydelete'] = 'Kategoria \'{$a}\' nie może zostać usunięta!';
$string['nocontext'] = 'Przepraszamy, ale podany kurs nie stanowi spójnej całości';
$string['nodata'] = 'Brak danych';
$string['noexistingcategory'] = 'Nie istnieje kategoria';
$string['nofile'] = 'Nie określono pliku';
$string['nofiltersenabled'] = 'Żadne filtry nie  są włączone.';
$string['nofolder'] = 'Żądany katalog nie istnieje';
$string['noformdesc'] = 'Dla tej aktywności nie znaleziono pliku opisu formularza formslib';
$string['noguest'] = 'Tu nie ma gości!';
$string['noinstances'] = 'Przykłady {$a} nie występują w tym kursie';
$string['nologinas'] = 'Nie masz uprawnień, by zalogować się jako ten użytkownik';
$string['nonmeaningfulcontent'] = 'Brak znaczącej treści';
$string['noparticipants'] = 'Nie znaleziono uczestników w tym kursie';
$string['noparticipatorycms'] = 'Nie posiadasz modułów biorących udział w kursie odpowiedzialnych za możliwość zgłoszeń.';
$string['nopermissions'] = 'Brak odpowiednich uprawnień do wykonania ({$a})';
$string['nopermissiontocomment'] = 'Nie możesz dodać komentarzy';
$string['nopermissiontodelentry'] = 'Nie możesz usunąć wpisów innych osób!';
$string['nopermissiontoeditcomment'] = 'Nie możesz edytować komentarzy innych osób!';
$string['nopermissiontohide'] = 'Brak uprawnień do ukrycia!';
$string['nopermissiontoimportact'] = 'Nie masz odpowiednich uprawnień do importu aktywności do tego kursu';
$string['nopermissiontolock'] = 'Brak uprawnień do blokowania!';
$string['nopermissiontomanagegroup'] = 'Nie masz wystarczających uprawnień do zarządzania grupami';
$string['nopermissiontorate'] = 'Nie wolno oceniać elementów!';
$string['nopermissiontoshow'] = 'Brak uprawnień do wyświetlenia tego!';
$string['nopermissiontounlock'] = 'Brak uprawnień do odblokowania!';
$string['nopermissiontoupdatecalendar'] = 'Przepraszamy, ale obecnie nie masz uprawnień do aktualizacji wydarzenia w kalendarzu';
$string['nopermissiontoviewgrades'] = 'Nie można wyświetlić ocen.';
$string['nopermissiontoviewletergrade'] = 'Brak uprawnienia do wyświetlania ocen literowych';
$string['nopermissiontoviewpage'] = 'Nie masz prawa wyświetlać tej strony';
$string['nosite'] = 'Nie znaleziono kursu najwyższego poziomu!';
$string['nositeid'] = 'Brak ID strony';
$string['nostatstodisplay'] = 'Przepraszamy, dane do wyświetlenia są niedostępne';
$string['notallowedtoupdateprefremotely'] = 'Nie masz uprawnień do zdalnej  aktualizacji preferencji tego użytkownika';
$string['notavailable'] = 'Nie jest to w tej chwili dostępne';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Nie jesteś członkiem tej grupy';
$string['notownerofkey'] = 'Nie jesteś właścicielem tego klucza';
$string['nousers'] = 'Nie ma takiego użytkownika!';
$string['onlyadmins'] = 'Tylko administrator może to zrobić';
$string['onlyeditingteachers'] = 'Tylko nauczyciele z uprawnieniami do edycji mogą to zrobić.';
$string['onlyeditown'] = 'Możesz edytować tylko własne informacje';
$string['orderidnotfound'] = 'Nie znaleziono identyfikatora zamówienia: {$a}';
$string['pagenotexist'] = 'Pojawił się nieoczekiwany błąd
(próba połączenia z nieistniejącą stroną)';
$string['pathdoesnotstartslash'] = 'Nieprawidłowe argumenty, ścieżka nie zaczyna się od ukośnika "/"!';
$string['pleasereport'] = 'Aby lepiej zapobiegać takim sytuacjom w przyszłości, opisz, co próbowałeś zrobić, zanim pojawił się błąd.';
$string['pluginrequirementsnotmet'] = 'Wtyczka "{$a->pluginname}" ({$a->pluginversion}) nie może zostać zainstalowana. Potrzebna jest nowsza wersja Moodle (teraz używasz {$a->currentmoodle},  a potrzebujesz {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>Błąd: prefix tabeli bazy danych nie może być pusty ({$a})</p>
<p>Administrator strony musi rozwiązać ten problem.</p>';
$string['prefixtoolong'] = '<p>Błąd: prefiks tabeli bazy danych jest za długi ({$a->dbfamily})</p>
<p> Administrator strony musi rozwiązać ten problem. Maksymalna długość dla prefiksów tabeli w {$a->dbfamily} wynosi {$a->maxlength} znaków.</p>';
$string['processingstops'] = 'Operacja została zatrzymana. Operacja zapisu nie została wykonana';
$string['protected_cc_not_supported'] = 'Uwierzytelniane pakiety Common Cartrigde nie są obsługiwane.';
$string['querystringcannotbeempty'] = 'Łańcuch zapytania nie może być pusty.';
$string['redirecterrordetected'] = 'Wykryto nieobsługiwane przekierowanie, wykonanie skryptu zakończone';
$string['refoundto'] = 'Może zostać zwrócone {$a}';
$string['refoundtoorigi'] = 'Zwrócono całą kwotę: {$a}';
$string['remotedownloaderror'] = 'Pobieranie składnika na serwer nie powiodło się. Sprawdź ustawienia proxy. Rozszerzenie PHP cURL jest bardzo zalecane. <br /><br />Musisz pobrać następująćy plik <a href="{$a->url}">{$a->url}</a> ręcznie, skopiować go do lokalizacji "{$a->dest}" i rozpakować poleceniem unzip.';
$string['remotedownloadnotallowed'] = 'Pobieranie komponentów na Twój serwer jest niedozwolone. Musisz pobrać pliki ręcznie z <a href="{$a->url}">{$a->url}</a> i skopiować do "{$a->dest}" na swoim serwerze i tam go otworzyć';
$string['reportnotavailable'] = 'Ten typ raportu jest dostępna tylko dla strony głównej';
$string['requirecorrectaccess'] = 'Nieprawidłowy adres URL lub port.';
$string['requireloginerror'] = 'Kurs lub aktywność niedostępna.';
$string['restorechecksumfailed'] = 'Zdarzył się jakiś problem podczas przywracania informacji przechowywanych w twojej sesji. Proszę sprawdzić limit rozmiaru pakietu pamięci PHP / bazy danych. Przywracanie zatrzymane.';
$string['restore_path_element_missingmethod'] = 'Brak metody przywracanie {$a}. Musi ją zdefiniować programista.';
$string['restore_path_element_noobject'] = 'Obiekt przywracania {$a} nie jest obiektem.';
$string['restrictedcontextexception'] = 'Niestety, wykonanie zewnętrznych funkcji narusza ograniczenia kontekstu.';
$string['restricteduser'] = 'Twoje konto "{$a}" nie daje uprawnień do wykonania tej operacji.';
$string['reverseproxyabused'] = 'Włączono odwrotne proxy, serwer nie jest niestety dostępny bezpośrednio. <br /> Prosimy o kontakt z administratorem serwera.';
$string['rpcerror'] = 'Ooops! Komunikacja z siecią MNet nie powiodła się! Proszę przekazać administratorowi komunikat: {$a}';
$string['scheduledbackupsdisabled'] = 'Zaplanowane tworzenie kopii zapasowych zostało wyłączone przez administratora serwera';
$string['secretalreadyused'] = 'Link potwierdzający możliwość zamiany hasła został już wykorzystany, hasło nie zostało zmienione';
$string['sectionnotexist'] = 'Ta sekcja nie istnieje';
$string['sendmessage'] = 'Wyślij wiadomość';
$string['serverconnection'] = 'Błąd podczas łączenia się z serwerem';
$string['servicedonotexist'] = 'Usługa nie istnieje';
$string['sessioncookiesdisable'] = 'Niewłaściwe użycie require_key_login () - ciasteczka (cookies) sesyjne muszą być wyłączone!';
$string['sessiondiskfull'] = 'Partycja dysku na sesje jest pełna. Nie jest możliwe zalogowanie. <br /><br /> Proszę powiadomić administratora serwera.';
$string['sessionerroruser'] = 'Sesja wygasła. Zaloguj się ponownie.';
$string['sessionerroruser2'] = 'Błąd serwera wpłynął na Twoją sesję logowania. Zaloguj się ponownie. Możesz też najpierw zamknąć i ponownie otworzyć przeglądarkę internetową.';
$string['sessionhandlerproblem'] = 'Obsługa sesji jest źle skonfigurowana';
$string['sessionipnomatch'] = 'Twój numer IP został zmieniony, od kiedy zalogowałeś się po raz pierwszy. Zabezpieczenie to nie pozwala osobom niepowołanym wykorzystać Twojego identyfikatora do logowania się na tej stronie. Skontaktuj się z administratorem.';
$string['sessionipnomatch2'] = 'Przykro nam, ale twój adres IP zmienił od czasu zalogowania. Ta funkcja zabezpieczeń uniemożliwia kradzież twojej tożsamości, gdy jesteś zalogowany na tej stronie. Możesz zobaczyć ten błąd, jeśli używasz sieci bezprzewodowej lub jeśli przełączasz się pomiędzy różnymi sieciami. Proszę skontaktować się z administratorem witryny w celu uzyskania pomocy. <br /><br /> Jeśli chcesz kontynuować, naciśnij klawisz F5, aby odświeżyć stronę.';
$string['sessionwaiterr'] = 'Przekroczono limit czasu podczas oczekiwania na blokadę sesji. <br /> Poczekaj aż zakończy się przetwarzanie bieżące i spróbuj ponownie później.';
$string['shortnametaken'] = 'Krótka nazwa kursu jest już używana przez innego kurs';
$string['socksnotsupported'] = 'Proxy SOCKS5 nie jest obsługiwane w PHP4';
$string['spellcheckernotconf'] = 'Sprawdzanie pisowni nie jest skonfigurowane';
$string['sslonlyaccess'] = 'Ze względów bezpieczeństwa dozwolone są tylko połączenia https, przepraszamy.';
$string['statscatchupmode'] = 'Statystyki znajdują się obecnie w trybie aktualizacji. Przez {$a->daysdone} dni będą przetwarzane a przez {$a->dayspending} są oczekujące. Sprawdź ponownie wkrótce!';
$string['statsdisable'] = 'Statystyka nie jest włączona';
$string['statsnodata'] = 'Brak danych dotyczących tego kursu i okresu czasu';
$string['storedfilecannotcreatefile'] = 'Nie można utworzyć lokalnego pliku puli pliku, proszę zweryfikować uprawnienia w folderze danych i dostępność wolnego miejsca na dysku.';
$string['storedfilecannotcreatefiledirs'] = 'Nie można utworzyć katalogów na ładowane  plików, sprawdź uprawnienia w dataroot.';
$string['storedfilecannotread'] = 'Nie można odczytać pliku, albo plik nie istnieje albo są problemy z uprawnieniami';
$string['storedfilenotcreated'] = 'Nie można utworzyć pliku "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}"';
$string['storedfileproblem'] = 'Nieznany wyjątek związany z lokalnymi plikami ({$a})';
$string['tagdisabled'] = 'Tagi są wyłączone!';
$string['tagnotfound'] = 'Podany znacznik nie został znaleziony w bazie danych';
$string['targetdatabasenotempty'] = 'Docelowa baza danych nie jest pusta. Transfer został anulowany z powodów bezpieczeństwa.';
$string['textconditionsnotallowed'] = 'Porównania kolumn tekstowych nie są dozwolone. Proszę użyć sql_compare_text () w zapytaniu.';
$string['themenotinstall'] = 'Ten schemat graficzny nie jest zainstalowany!';
$string['TODO'] = 'Do zrobienia';
$string['tokengenerationfailed'] = 'Nie można wygenerować nowego tokenu.';
$string['transactionvoid'] = 'Transakcja nie może zostać unieważnione, ponieważ zostało ti już zrobione.';
$string['unenrolerror'] = 'Wystąpił błąd podczas próby wypisania tej osoby';
$string['unicodeupgradeerror'] = 'Twoja baza danych nie jest w formacie Unicode, a ta wersja Moodle nie może przenieść twojej bazy danych do Unicode. Najpierw aktualizuj wersję Moodle do 1.7.x i przeprowadź migrację Unicode ze strony Administracji. Później powinieneś móc przejść do Moodle {$a}';
$string['unknowaction'] = 'Nieznane działanie!';
$string['unknowcategory'] = 'Nieznana kategoria!';
$string['unknowcontext'] = 'Nieznany kontekst ({$a}) w get_child_contexts!';
$string['unknowformat'] = 'Nieznany format: ({$a})';
$string['unknownbackupexporterror'] = 'Nieznany błąd podczas przygotowania informacji dla importu';
$string['unknownblockregion'] = 'Region bloków o nazwie \'{$a}\' nie jest znany na tej stronie.';
$string['unknowncontext'] = 'To jest nieznany kontekst.';
$string['unknowncourse'] = 'Kurs o nazwie "{$a}" nie istnieje';
$string['unknowncourseidnumber'] = 'Nieznany ID kursu "{$a}"';
$string['unknowncourserequest'] = 'Żądanie nieznanego kursu';
$string['unknowncoursesection'] = 'Nieznana sekcja kursu w kursie "{$a}"';
$string['unknownevent'] = 'Nieznane wydarzenie';
$string['unknownfiletype'] = 'Nieznany błąd typu filtra';
$string['unknowngroup'] = 'Nieznana grupa "{$a}"';
$string['unknownhelp'] = 'Nieznany temat pomocy {$a}';
$string['unknownjsinrequirejs'] = 'Nie można znaleźć biblioteki JS: {$a}';
$string['unknownmodulename'] = 'Nieznana nazwa modułu dla formularza';
$string['unknownrole'] = 'Nieznana rola "{$a}"';
$string['unknownsortcolumn'] = 'Nieznana kolumna sortowania {$a}';
$string['unknownuseraction'] = 'Akcja użytkownika jest niezrozumiała';
$string['unknownuserselector'] = 'Nieznany selektor użytkownika';
$string['unknoworder'] = 'Nieznane sortowanie';
$string['unknowparamtype'] = 'Nieznany typ parametru: {$a}';
$string['unknowquestiontype'] = 'Niewspierany typ pytania {$a}';
$string['unknowuploadaction'] = 'Błąd: Nieznana operacja przesłania ({$a})';
$string['unspecifycourseid'] = 'Musisz podać identyfikator kursu, nazwę skróconą lub identyfikator';
$string['unsupportedevent'] = 'Nieobsługiwany typ zdarzenia';
$string['unsupportedstate'] = 'Nieobsługiwany stan ukończenia kursu';
$string['unsupportedwebserver'] = 'Oprogramowanie webserwera ({$a}) nie jest obsługiwane, przepraszamy.';
$string['upgraderequires19'] = 'Błąd: Nowa wersja Moodle został zainstalowana na serwerze, niestety uaktualnienie z poprzedniej wersji nie jest obsługiwane. <br /> Proszę uaktualnić najpierw do najnowszej wersji 1.9.x. Można także powrócić do poprzedniej wersji, ponownie instalując oryginalne pliki.';
$string['upgraderunning'] = 'Strona jest uaktualniana, proszę spróbować później.';
$string['urlnotdefinerss'] = 'Nie zdefiniowano URL dla kanału RSS';
$string['useradmineditadmin'] = 'Tylko administratorzy mogą modyfikować inne konta administratorów';
$string['useradminodelete'] = 'Konta administratorów nie mogą być usunięte.';
$string['userautherror'] = 'Nieznana wtyczka autoryzacyjna';
$string['userauthunsupported'] = 'Wtyczka autoryzacyjna nie obsługiwana';
$string['useremailduplicate'] = 'Zduplikowany adres';
$string['usermustbemnet'] = 'Użytkownicy z listy kontroli dostępu MNet muszą być zdalnymi użytkownikami MNet';
$string['usernotaddederror'] = 'Błąd - użytkownik nie został dodany.';
$string['usernotaddedregistered'] = 'Użytkownik nie został dodany - już istnieje.';
$string['usernotavailable'] = 'Szczegóły tego użytkownika nie są dla Ciebie dostępne';
$string['usernotdeletedadmin'] = 'Użytkownik nie został usunięty - nie można usunąć konta administratora';
$string['usernotdeletederror'] = 'Błąd - użytkownik nie został usunięty';
$string['usernotdeletedmissing'] = 'Użytkownik nie został usunięty - nie znaleziono nazwy użytkownika';
$string['usernotdeletedoff'] = 'Użytkownik nie został usunięty - operacja usuwania niedozwolona';
$string['usernotincourse'] = 'Ten użytkownik nie jest w tym kursie!';
$string['usernotrenamedadmin'] = 'Nie można zmienić nazwy kont administratora';
$string['usernotrenamedexists'] = 'Nazwa użytkownika nie została zmieniona – nowa nazwa jest już używana';
$string['usernotrenamedmissing'] = 'Nazwa użytkownika nie została zmieniona – nie można odnaleźć starej nazwy użytkownika';
$string['usernotrenamedoff'] = 'Nazwa użytkownika nie została zmieniona - operacja niedozwolona';
$string['usernotupdatedadmin'] = 'Nie można zaktualizować kont administracyjnych';
$string['usernotupdatederror'] = 'Błąd - użytkownik nie został zaktualizowany';
$string['usernotupdatednotexists'] = 'Użytkownik nie został zaktualizowany - nie istnieje';
$string['userquotalimit'] = 'Osiągnąłeś maksymalny limit przydziału wielkości pliku.';
$string['userselectortoomany'] = 'Wybrano więcej niż jednego użytkownika w user_selector, choć multiselect ustawiono na  fałszywe.';
$string['wrongcall'] = 'Ten skrypt został wywoływany błędnie';
$string['wrongcontextid'] = 'ID kontekstu było nieprawidłowe (nie można jego znaleźć)';
$string['wrongdestpath'] = 'Błędna ścieżka docelowa';
$string['wrongroleid'] = 'Niepoprawny identyfikator roli !';
$string['wrongsourcebase'] = 'Błędne źródło bazy URL';
$string['wrongusernamepassword'] = 'Niewłaściwa nazwa użytkownika lub hasło';
$string['wrongzipfilename'] = 'Błędna nazwa pliku ZIP';
$string['wscouldnotcreateecoursenopermission'] = 'WS - nie można utworzyć kursu - brak uprawnień';
$string['wwwrootmismatch'] = 'Wykryto nieprawidłowy adres, ten serwer może być dostępny tylko poprzez adres "{$a}". <br /> Proszę powiadomić administratora.';
$string['wwwrootslash'] = 'Wykryto nieprawidłową wartość $CFG->wwwroot w config.php, nie może kończyć się ukośnikiem "/". <br /> Proszę powiadomić administratora serwera.';
$string['xmldberror'] = 'Błąd XMLDB!';
$string['youcannotdeletecategory'] = 'Nie możesz usunąć kategorii \'{$a} ", bo nie możesz ani usunąć jej zawartości, ani przenieść jej gdzie indziej.';
