<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'hu', branch 'MOODLE_28_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Aktuális feladatai vannak';
$string['addattempt'] = 'Újabb próbálkozás engedélyezése';
$string['addnewattempt'] = 'Új próbálkozás hozzáadása';
$string['addnewattemptfromprevious'] = 'Új próbálkozás hozzáadása az előző leadás alapján';
$string['addnewattemptfromprevious_help'] = 'Az előző leadás tartalmát átmásolja új leadáson való munkálkodáshoz';
$string['addnewattempt_help'] = 'Új üres leadást szúr be munkálkodáshoz';
$string['addsubmission'] = 'Leadott munka hozzáadása';
$string['allocatedmarker'] = 'Hozzárendelt értékelő';
$string['allocatedmarker_help'] = 'A leadott munkához rendelt értékelő';
$string['allowsubmissions'] = 'Felhasználó számára további leadás engedélyezése az adott feladat esetén';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'A feladat részletei és a leadási űrlap <strong>{$a}</strong> időponttól lesznek elérhetők.';
$string['allowsubmissionsfromdate'] = 'Leadások engedélyezése ekkortól';
$string['allowsubmissionsfromdate_help'] = 'Bekapcsolása esetén a tanulók ezen időpont előtt nem adhatnak le munkát. Ellenkező esetben azonnal beküldhetnek munkákat.';
$string['allowsubmissionsfromdatesummary'] = 'A feladathoz <strong>{$a}</strong> időponttól lehet leadni munkát.';
$string['allowsubmissionsshort'] = 'Leadott munka módosításának engedélyezése';
$string['alwaysshowdescription'] = 'A leírás mindig jelenjen meg.';
$string['alwaysshowdescription_help'] = 'KIkapcsolása esetén a fenti Feladat leírása a tanulók számára csak a \'Leadások engedélyezése ekkortól\' alatt megadott időponttól lesz látható.';
$string['applytoteam'] = 'Osztályzatok és visszajelzés az egész csoportra kiterjesztve';
$string['assign:addinstance'] = 'Új feladat hozzáadása';
$string['assign:editothersubmission'] = 'Másik tanuló leadott munkájának szerkesztése';
$string['assign:exportownsubmission'] = 'Saját leadás exportálása';
$string['assignfeedback'] = 'Visszajelzés segédprogramja';
$string['assignfeedbackpluginname'] = 'Visszajelzés segédprogramja';
$string['assign:grade'] = 'Feladat pontozása';
$string['assign:grantextension'] = 'Meghosszabbítás';
$string['assign:manageallocations'] = 'A leadott munkához rendelt értékelők kezelése';
$string['assign:managegrades'] = 'Osztályzatok ellenőrzése és közzététele';
$string['assignmentisdue'] = 'A feladat teljesítendő';
$string['assignmentmail'] = '{$a->grader} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz leadott munkájára, melyet a leadott munkához mellékelve talál meg: {$a->url}.';
$string['assignmentmailhtml'] = '{$a->grader} visszajelzést küldött a(z) \'<i>{$a->assignment}</i>\'<br /><br />  feladathoz leadott munkájára, melyet a <a href="{$a->url}">leadott munkához</a> mellékelve talál meg.';
$string['assignmentmailsmall'] = '{$a->grader} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz leadott munkájára, melyet a leadott munkához mellékelve talál meg.';
$string['assignmentname'] = 'Feladat neve';
$string['assignmentplugins'] = 'Feladat segédprogramjai';
$string['assignmentsperpage'] = 'Oldalankénti feladatszám';
$string['assign:receivegradernotifications'] = 'Osztályozói leadásokról szóló értesítések fogadása';
$string['assign:releasegrades'] = 'Osztályzatok közzététele';
$string['assign:revealidentities'] = 'Tanuló kilétének felfedése';
$string['assign:reviewgrades'] = 'Osztályzatok ellenőrzése';
$string['assignsubmission'] = 'Leadási segédprogram';
$string['assignsubmissionpluginname'] = 'Leadási segédprogram';
$string['assign:submit'] = 'Feladat leadása';
$string['assign:view'] = 'Feladat megtekintése';
$string['assign:viewblinddetails'] = 'Tanulók kilétének megtekintése vakon osztályozás bekapcsolása esetén';
$string['assign:viewgrades'] = 'Pontok kijelzése';
$string['attemptheading'] = '{$a->attemptnumber}. próbálkozás: {$a->submissionsummary}';
$string['attempthistory'] = 'Előző próbálkozások';
$string['attemptnumber'] = 'Próbálkozás száma';
$string['attemptreopenmethod'] = 'Újból megnyitott próbálkozások';
$string['attemptreopenmethod_help'] = 'Meghatározza a leadási próbálkozások újbóli megnyitásának mikéntjét. Lehetőségek: <ul><li>Soha - A tanuló leadott munkáját nem lehet újból megnyitni.</li><li>Kézileg - A tanuló leadott munkáját egy tanár újból megnyithatja.</li><li>Automatikusan a teljesítésig - A tanuló leadott munkája mindaddig automatikusan megnyílik, amíg a tanuló a feladathoz az osztályozónaplóban beállított teljesítési értéket el nem éri.</li></ul>';
$string['attemptreopenmethod_manual'] = 'Kézileg';
$string['attemptreopenmethod_none'] = 'Soha';
$string['attemptreopenmethod_untilpass'] = 'Automatikusan a teljesítésig';
$string['attemptsettings'] = 'Próbálkozás beállításai';
$string['availability'] = 'Elérhetőség';
$string['backtoassignment'] = 'Vissza a feladathoz';
$string['batchoperationconfirmaddattempt'] = 'Új próbáűlkozás engedélyezése a kijelölt leadások esetén?';
$string['batchoperationconfirmgrantextension'] = 'Meghosszabbítás minden kiválasztott leadott munka esetén?';
$string['batchoperationconfirmlock'] = 'Zárolja az összes kiválasztott leadott munkát?';
$string['batchoperationconfirmreverttodraft'] = 'A kiválasztott leadott munkákat visszaállítja piszkozattá?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Minden kiválasztott leadott munkához legyen értékelő hozzárendelve?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Minden kiválasztott leadott munkához legyen értékelési folyamat állapota beállítva?';
$string['batchoperationconfirmunlock'] = 'Feloldja az összes kiválasztott leadott munkát?';
$string['batchoperationlock'] = 'leadott munkák zárolása';
$string['batchoperationreverttodraft'] = 'leadott munkák visszaállítása piszkozattá?';
$string['batchoperationsdescription'] = 'A kiválasztottal...';
$string['batchoperationunlock'] = 'leadott munkák feloldása';
$string['batchsetallocatedmarker'] = 'Hozzárendelt értékelő beállítása {$a} kiválasztott felhasználóhoz';
$string['batchsetmarkingworkflowstateforusers'] = 'Értékelési folyamat állapotának  beállítása {$a} kiválasztott felhasználóhoz';
$string['blindmarking'] = 'Értékelés vakon';
$string['blindmarking_help'] = 'Vakon értékelés esetén az értékelők elől rejtve marad a tanulók kiléte. Ha a feladattal kapcsolatos leadott munka vagy osztályozás elkészül, a vakon értékelés beállításai nem módosíthatók.';
$string['changegradewarning'] = 'A feladathoz osztályozott leadott munkák tartoznak, melyek módosítása nem jár automatikus újraszámolással. Ha módosítani kívánja az osztályzatot, minden leadott munkát újból le kell osztályoznia.';
$string['choosegradingaction'] = 'Osztályozási lépés';
$string['choosemarker'] = 'Választ';
$string['chooseoperation'] = 'Művelet kiválasztása';
$string['comment'] = 'Megjegyzés';
$string['completionsubmit'] = 'Befejezéshez a tanulónak munkát kell leadnia.';
$string['configshowrecentsubmissions'] = 'A tevékenységekről szóló utóbbi jelentésekben bárki megtekintheti a leadott munkákkal kapcsolatos értesítéseket.';
$string['confirmbatchgradingoperation'] = 'Biztosan végrehajt {$a->operation} műveletet {$a->count} tanuló esetén?';
$string['confirmsubmission'] = 'Biztosan leadja munkáját osztályozásra? További módosításokra nem lesz lehetősége.';
$string['conversionexception'] = 'A feladat átalakítása nem sikerült. A kivétel oka: {$a}.';
$string['couldnotconvertgrade'] = 'A feladatra adott osztályzat átalakítása {$a} felhaasználó esetén nem sikerült.';
$string['couldnotconvertsubmission'] = 'A feladathoz leadott munka átalakítása {$a} felhaasználó esetén nem sikerült.';
$string['couldnotcreatecoursemodule'] = 'A kurzusmodul létrehozása  nem sikerült.';
$string['couldnotcreatenewassignmentinstance'] = 'Az új feladatpéldány létrehozása  nem sikerült.';
$string['couldnotfindassignmenttoupgrade'] = 'Nincs meg a frissítendő régi feladat.';
$string['currentattempt'] = 'Ez a(z)  {$a}. próbálkozás';
$string['currentattemptof'] = 'Ez a lehetséges {$a->maxattempts}  közül a(z) {$a->attemptnumber}.  próbálkozás';
$string['currentgrade'] = 'Aktuális osztályzat az osztályozónaplóban';
$string['cutoffdate'] = 'Lezárás időpontja';
$string['cutoffdatefromdatevalidation'] = 'A Lezárás időpontja nem lehet korábban, mint a leadások engedélyezésének kezdő időpontja';
$string['cutoffdate_help'] = 'Beállítása esetén a feladathoz meghosszabbítás hiányában nem adhatók le munkák ezen időpontot követően.';
$string['cutoffdatevalidation'] = 'A lezárás időpontja nem lehet később, mint a leadási határidő';
$string['defaultsettings'] = 'Feladat alapbeállításai';
$string['defaultsettings_help'] = 'Ezek a beállítások lesznek érvényesek az összes új feladat esetén.';
$string['defaultteam'] = 'Alapcsoport';
$string['deleteallsubmissions'] = 'Az összes leadott munka törlése';
$string['description'] = 'Leírás';
$string['downloadall'] = 'Az összes leadott munka letöltése';
$string['duedate'] = 'Határidő';
$string['duedate_help'] = 'A feladat teljesítése ekkor esedékes. Ezen időpont után is adhatók le munkák, de ezek késedelmes megjelölést kapnak. A leadás adott időpont utáni megakadályozásához állítson be lezárási időpontot.';
$string['duedateno'] = 'Nincs határidő';
$string['duedatereached'] = 'A feladat teljesítésének határideje lejárt.';
$string['duedatevalidation'] = 'A feladat teljesítésének határideje a leadások engedélyezésének kezdetétől későbbi időpont lehet.';
$string['editaction'] = 'Lépések...';
$string['editattemptfeedback'] = '{$a}. számú próbálkozáshoz tartozó osztályzat és visszajelzés szerkesztése';
$string['editingpreviousfeedbackwarning'] = 'Egy korábbi próbálkozáshoz tartozó visszajelzést szerkeszt. Ez a(z) {$a->totalattempts} próbálkozás közül a(z) {$a->attemptnumber}.';
$string['editingstatus'] = 'Szerkesztés állapota';
$string['editsubmission'] = 'Leadott munkám szerkesztése';
$string['editsubmission_help'] = 'Leadott munkám módosítása';
$string['editsubmissionother'] = '{$a} leadott munkájának szerkesztése';
$string['enabled'] = 'Bekapcsolva';
$string['errornosubmissions'] = 'Nincs letölthető leadott munka';
$string['errorquickgradingvsadvancedgrading'] = 'Az osztályzatok mentésére nem került sor, mert a feladathoz részletes osztályozás kapcsolódik.';
$string['errorrecordmodified'] = 'Az osztályzatok mentésére nem került sor, mert valaki egy vagy több rekordot az oldal feltötése után módosított.';
$string['eventallsubmissionsdownloaded'] = 'Minden leadott munka letöltése folyamatban';
$string['eventassessablesubmitted'] = 'Leadtak egy munkát.';
$string['eventbatchsetmarkerallocationviewed'] = 'Ömlesztett jelzőkiosztás megtekintve';
$string['eventbatchsetworkflowstateviewed'] = 'Ömlesztett munkafolyamat állapota megtekintve';
$string['eventextensiongranted'] = 'Hosszabbítást kapott.';
$string['eventfeedbackupdated'] = 'Visszajelzés frissítve';
$string['eventfeedbackviewed'] = 'Visszajelzés megtekintve';
$string['eventgradingformviewed'] = 'Osztályozó űrlap megtekintve';
$string['eventgradingtableviewed'] = 'Osztályozó táblázat megtekintve';
$string['eventidentitiesrevealed'] = 'Azonosságok felfedve.';
$string['eventmarkerupdated'] = 'Kiejlölt értékelő frisstítve';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Azonosítást megerősítő oldal megtekintve';
$string['eventstatementaccepted'] = 'A felhasználó a leadott munka nyilatkozatát elfogadta.';
$string['eventsubmissionconfirmationformviewed'] = 'Leadást megerősítő űrlap megtekintve';
$string['eventsubmissioncreated'] = 'Leadott munka létrehozva';
$string['eventsubmissionduplicated'] = 'A felhasználó leadott munkájáról másolatot készített.';
$string['eventsubmissionformviewed'] = 'Leadási űrlap megtekintve';
$string['eventsubmissiongraded'] = 'A leadott munka osztályozása megtörtént.';
$string['eventsubmissionlocked'] = 'A leadott munkákat egy felhasználó számára zároltuk.';
$string['eventsubmissionstatusupdated'] = 'A leadott munka állapota frissítve.';
$string['eventsubmissionstatusviewed'] = 'Leadás állapota megtekintve';
$string['eventsubmissionunlocked'] = 'A leadott munkákat egy felhasználó számára feloldottuk.';
$string['eventsubmissionupdated'] = 'A felhasználó elmentett egy leadott munkát.';
$string['eventsubmissionviewed'] = 'Leadott munka megtekintve';
$string['eventworkflowstateupdated'] = 'A munkafolyamat állapota frissítve.';
$string['extensionduedate'] = 'Meghosszabbítás lejárata';
$string['extensionnotafterduedate'] = 'A meghosszabbítás lejárata az esedékesség utáni időpont lehet';
$string['extensionnotafterfromdate'] = 'A meghosszabbítás lejárata nem lehet korábbi időpont, mint a leadások kezdeti időpontja';
$string['feedback'] = 'Visszajelzés';
$string['feedbackavailablehtml'] = '{$a->username} visszajelzést küldött a(z) \'<i>{$a->assignment}</i>\' feladathoz leadott munkájára.<br /><br /> Megtekintheti a <a href="{$a->url}">leadott munka</a> mellett.';
$string['feedbackavailablesmall'] = '{$a->username} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz';
$string['feedbackavailabletext'] = '{$a->username} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz leadott munkájára.

Megtekintheti a leadott munka mellett: {$a->url.';
$string['feedbackplugin'] = 'Visszajelzés segédprogramja';
$string['feedbackpluginforgradebook'] = 'Visszajelzés segédprogramja, mely megjegyzéseket továbbít az osztályozónaplóba';
$string['feedbackpluginforgradebook_help'] = 'Csak egy feladathoz kapcsolódó visszajelzést kezelő segédprogram küldhet visszajelzést az osztályozó naplóba.';
$string['feedbackplugins'] = 'Visszajelzés segédprogramjai';
$string['feedbacksettings'] = 'Visszajelzés beállításai';
$string['feedbacktypes'] = 'Visszajelzési típusok';
$string['filesubmissions'] = 'Állományok leadása';
$string['filter'] = 'Szűrő';
$string['filternone'] = 'Nincs szűrő';
$string['filternotsubmitted'] = 'NIncs leadva';
$string['filterrequiregrading'] = 'Osztályozandó';
$string['filtersubmitted'] = 'Leadva';
$string['gradeabovemaximum'] = 'Az osztályzat értéke legfeljebb {$a} lehet.';
$string['gradebelowzero'] = 'Az osztályzat értéke legalább nulla lehet.';
$string['gradecanbechanged'] = 'Az osztályozás módosítható';
$string['graded'] = 'Pontozott';
$string['gradedby'] = 'Osztályozta';
$string['gradedon'] = 'Osztályozás időpontja';
$string['gradelocked'] = 'Ez az osztályzat zárolva van vagy felülírták az osztályozónaplóban';
$string['gradeoutof'] = '{$a} pontból';
$string['gradeoutofhelp'] = 'Osztályzat';
$string['gradeoutofhelp_help'] = 'A tanuló leadott munkájára adott osztályzatot itt adja meg. Használhat tizedeseket is.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} {$a->timeupdated}  időpontban frissítette a(z) <i>\'{$a->assignment}\'</i><br /><br /> feladathoz leadott munkáját.<br></br>Elérhető a(z) <a href="{$a->url}"> weboldalon</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} frissítette a(z) \'{$a->assignment}\' feladathoz leadott munkáját.';
$string['gradersubmissionupdatedtext'] = '{$a->username} {$a->timeupdated}  időpontban frissítette a(z) {$a->assignment}  feladathoz leadott munkáját. Itt érhető el: {$a->url}';
$string['gradestudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló osztályzata.';
$string['gradeuser'] = 'Osztályzat {$a}';
$string['grading'] = 'Osztályozás';
$string['gradingchangessaved'] = 'Az osztályzat módosításának a mentése megtörtént.';
$string['gradingmethodpreview'] = 'Osztályozási kritériumok';
$string['gradingoptions'] = 'Lehetőségek';
$string['gradingstatus'] = 'Osztályozás állapota';
$string['gradingstudent'] = 'Tanuló osztályozása';
$string['gradingsummary'] = 'Osztályozási összesítő';
$string['grantextension'] = 'Meghosszabbítás';
$string['grantextensionforusers'] = 'Meghosszabbítás {$a} számára';
$string['groupsubmissionsettings'] = 'Csoportos leadás beállításai';
$string['hiddenuser'] = 'Résztvevő';
$string['hideshow'] = 'Elrejt/Mutat';
$string['instructionfiles'] = 'Utasítások';
$string['introattachments'] = 'Kiegészítő állományok';
$string['introattachments_help'] = 'Kiegészítő állományokat, pl. válaszsablonokat adhat hozzá a feladatban való használatra. Letöltési ugrópontjaik a feladat oldalán a leírás alatt jelennek meg.';
$string['invalidfloatforgrade'] = 'Az adott osztályzat nem világos: {$a}';
$string['invalidgradeforscale'] = 'Az adott osztályzat nem érvényes erre a tartományra.';
$string['lastmodifiedgrade'] = 'Utolsó módosítás (osztályzat)';
$string['lastmodifiedsubmission'] = 'Utolsó módosítás (leadott munka)';
$string['latesubmissions'] = 'Későn leadott munkák';
$string['latesubmissionsaccepted'] = 'Csak a halasztás idejéig engedélyezett';
$string['locksubmissionforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló részéről további leadások megakadályozása';
$string['locksubmissions'] = 'Leadások zárolása';
$string['manageassignfeedbackplugins'] = 'Feladatra adott visszajelzések segédprogramjainak kezelése';
$string['manageassignsubmissionplugins'] = 'Feladathoz leadott munkák segédprogramjainak kezelése';
$string['marker'] = 'Értékelő';
$string['markerfilter'] = 'Értékelők szűrője';
$string['markerfilternomarker'] = 'Nincs jelölő';
$string['markingallocation'] = 'Értékelő-hozzárendelés használata';
$string['markingallocation_help'] = 'Bekapcsolása esetén értékelőket rendelhet az egyes tanulókhoz - ehhez az értékelési folyamatot engedélyezni kell';
$string['markingworkflow'] = 'Értékelési folyamat használata';
$string['markingworkflow_help'] = 'Bekapcsolása esetén a jegyek közzététel előtt több folyamaton mennek keresztül. Így a több értékelési kör révén a jegyeket minden tanuló egyszerre kaphatja meg.';
$string['markingworkflowstate'] = 'Értékelési folyamat állapota';
$string['markingworkflowstate_help'] = 'A választható folyamatállapotokat a feladathoz rendelt jogosultságai határozzák meg:

* Nincs értékelve - az értékelő még nem látott hozzá
* Értékelés alatt - az értékelő már  hozzálátott, de még nem készült el vele
* Értékelés kész - az értékelő már  befejezte, de még ránézhet
* Ellenőrzés alatt - az értékelést a minőség ellenőrzéséért felelős tanárhoz került
* Közzétételre kész - a tanár elégedett az értékeléssel, de még vár a közzététellel
* Közzétéve - az osztályzat/visszajelzés a tanuló rendelkezésére áll';
$string['markingworkflowstateinmarking'] = 'Értékelés alatt';
$string['markingworkflowstateinreview'] = 'Ellenőrzés alatt';
$string['markingworkflowstatenotmarked'] = 'Nincs értékelve';
$string['markingworkflowstatereadyforrelease'] = 'Közzétételre kész';
$string['markingworkflowstatereadyforreview'] = 'Az értékelés véget ért.';
$string['markingworkflowstatereleased'] = 'Közzétéve';
$string['maxattempts'] = 'Max. próbálkozás';
$string['maxattempts_help'] = 'A tanuló általi leadási próbálkozások maximális száma. Ezt követően a leadott munkát nem lehet újból megnyitni.';
$string['maxgrade'] = 'Maximális osztályzat';
$string['messageprovider:assign_notification'] = 'Feladattal kapcsolatos értesítések';
$string['modulename'] = 'Feladat';
$string['modulename_help'] = 'A Feladat tevékenységmodul révén a tanár a tanulók előmenetelét ellenőrizheti elvégzendő munkák kijelölése, értékelése, osztályozása és visszajelzés küldése révén.

A tanuló bármilyen digitális tartalmat (állományt) leadhat (dokumentumot, számolótáblát, képet, hangállományt és videoklipet), online tölthet ki feladatokat. A feladat használható az elkészítendő munkára való figyelmeztetés eszközeként is.

Ellenőrzés során a tanár visszajelzést küldhet a fenti formátumokban, tetszése szerinti skálán leosztályozhatja a leadott munkát, a végleges osztályzat pedig bekerül az osztályozónaplóba.';
$string['modulenameplural'] = 'Feladatok';
$string['moreusers'] = 'még {$a} ...';
$string['mysubmission'] = 'Leadott munkám';
$string['newsubmissions'] = 'Feladatok leadva';
$string['noattempt'] = 'Nincs próbálkozás';
$string['nofiles'] = 'Nincs állomány';
$string['nograde'] = 'Nincs osztályzat';
$string['nolatesubmissions'] = 'Kései leadásra nincs mód';
$string['nomoresubmissionsaccepted'] = 'Csak a halasztást kapók számára engedélyezett';
$string['noonlinesubmissions'] = 'Ehhez a feladathoz semmit nem kell neten keresztül leadnia.';
$string['nosavebutnext'] = 'Következő';
$string['nosubmission'] = 'A feladathoz nem érkezett leadott munka.';
$string['nosubmissionsacceptedafter'] = 'Ezt követően leadásra nincs mód';
$string['notgraded'] = 'Nincs osztályozva';
$string['notgradedyet'] = 'Még nincs pontozva';
$string['notifications'] = 'Értesítések';
$string['notsubmittedyet'] = 'Még nincs leadva';
$string['nousersselected'] = 'Nincs kiválasztva felhasználó';
$string['numberofdraftsubmissions'] = 'Piszkozatok';
$string['numberofparticipants'] = 'Résztvevők';
$string['numberofsubmissionsneedgrading'] = 'Osztályozandó';
$string['numberofsubmittedassignments'] = 'Leadva';
$string['numberofteams'] = 'Csoportok';
$string['offline'] = 'Nincs szükség neten keresztüli leadásra';
$string['open'] = 'Nyitva';
$string['outlinegrade'] = 'Osztályzat: {$a}';
$string['outof'] = '{$a->current} / {$a->total}';
$string['overdue'] = '<font color="red">A feladat lejárt: {$a}</font>';
$string['page-mod-assign-view'] = 'Feladat modul fő oldala';
$string['page-mod-assign-x'] = 'Feladat modul tetszőleges oldala';
$string['participant'] = 'Résztvevő';
$string['pluginadministration'] = 'Feladat kezelése';
$string['pluginname'] = 'Feladat';
$string['preventsubmissions'] = 'Tanuló számára a feladathoz további munkák leadásának megakadályozása';
$string['preventsubmissionsshort'] = 'Leadott munkák módosításának megakadályozása';
$string['previous'] = 'Előző';
$string['quickgrading'] = 'Gyors osztályozás';
$string['quickgradingchangessaved'] = 'Az osztályozás változásainak mentése megtörtént.';
$string['quickgrading_help'] = 'Gyors osztályozás esetén az osztályzatokat (és eredményeket) közvetlenül a leadott munka táblázatában rögzítheti. Gyors osztályozás nem alkalmazható részletes osztályozással együtt, használata több értékelő esetén nem ajánlott.';
$string['quickgradingresult'] = 'Gyors osztályozás';
$string['recordid'] = 'Azonosító';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Nyissa meg újra, amíg a teljesítési feltétel nem egyezik a vakon értékeléssel, mert az osztályzatok csak akkor kerülnek a naplóba, amikor a tanulók kilétére fény derül.';
$string['requireallteammemberssubmit'] = 'MInden csoporttagnak kell leadni munkát.';
$string['requireallteammemberssubmit_help'] = 'Bekapcsolása esetén minden csoporttagnak kattintania kell a Leadás gombra. Kikapcsolt állapotban a csoportszintű leadás bármely csoporttag Leadás gombra való kattintásával megtörténik.';
$string['requiresubmissionstatement'] = 'A leadási nyilatkozat tanulók általi elfogadásának előírása';
$string['requiresubmissionstatement_help'] = 'A leadási nyilatkozat tanulók általi elfogadásának előírása a feladat minden leadott munkájához.';
$string['revealidentities'] = 'Tanuló kilétének felfedése';
$string['revealidentitiesconfirm'] = 'Biztosan felfedi a tanulók kilétét ennél a feladatnál? A művelet nem érvényteleníthető, a jegyek pedig bekerülnek az osztályozónaplóba!';
$string['reverttodraft'] = 'Leadott munka visszaállítása piszkozattá';
$string['reverttodraftforstudent'] = 'Leadott munka visszaállítása piszkozattá (id={$a->id}, fullname={$a->fullname}) tanuló számára.';
$string['reverttodraftshort'] = 'Leadott munka visszaállítása piszkozattá';
$string['reviewed'] = 'Ellenőrizve';
$string['saveallquickgradingchanges'] = 'Az összes gyorspontozási változás mentése';
$string['savechanges'] = 'Módosítások mentése';
$string['savegradingresult'] = 'Osztályzat';
$string['savenext'] = 'Mentés és a következő megjelenítése';
$string['scale'] = 'Skála';
$string['selectedusers'] = 'Kiválasztott felhasználók';
$string['selectlink'] = 'Választás';
$string['selectuser'] = 'Választás: {$a}';
$string['sendlatenotifications'] = 'Értékelők értesítése kései leadásokról';
$string['sendlatenotifications_help'] = 'Bekapcsolása esetén az osztályozók (rendszerint a tanárok) értesítést kapnak, ha egy tanuló későn adta le a feladatát. Az üzenetküldés módja beállítható.';
$string['sendnotifications'] = 'Értesítések küldése az osztályozásban közreműködőknek';
$string['sendnotifications_help'] = 'Bekapcsolása esetén az osztályozásban közreműködők (általában a tanárokj) üzenetet kapnak, ha a tanuló (korán, időben vagy megkésve) ad le egy munkát. Az üzenetküldő módszereket testre szabhatja.';
$string['sendstudentnotifications'] = 'Tanulók értesítése';
$string['sendstudentnotificationsdefault'] = 'A "Tanulók értesítése" alapbeállítása';
$string['sendstudentnotificationsdefault_help'] = 'Az osztályozó űrlapon állítsa be a "Tanulók értesítése" jelölőnégyzet alapértékét.';
$string['sendstudentnotifications_help'] = 'Bekapcsolása esetén a tanulók a frissített osztályzatról vagy visszajelzésről üzenetet kapnak.';
$string['sendsubmissionreceipts'] = 'Leadott munkáról elismervény küldése a tanulóknak';
$string['sendsubmissionreceipts_help'] = 'Ezzel kapcsolja be a leadott munkáról szóló elismervény küldését a tanulóknak, akik minden sikeres leadást követően kapnak róla egy értesítést.';
$string['setmarkerallocationforlog'] = 'Értékelő hozzárendelése: (id={$a->id}, név={$a->fullname}, értékelő={$a->marker}).';
$string['setmarkingallocation'] = 'Hozzárendelt értékelő beállítása';
$string['setmarkingworkflowstate'] = 'Értékelési folyamat állapotának beállítása';
$string['setmarkingworkflowstateforlog'] = 'Értékelési folyamat állapotának beállítása : (id={$a->id}, név={$a->fullname}, állapot={$a->state}).';
$string['settings'] = 'Feladat beállításai';
$string['showrecentsubmissions'] = 'Legutóbbi leadott munkák megjelenítése';
$string['status'] = 'Állapot';
$string['studentnotificationworkflowstateerror'] = 'A tanulók értesítéséhez a munkamenetet \'Szabad\' állapottal kell megjelölni.';
$string['submission'] = 'Leadott munka';
$string['submissioncopiedhtml'] = 'Másolatot készített \'<i>{$a->assignment}</i>\' leadott munkájáról.<br /><br /> <a href="{$a->url}">Leadott munkájának</a> állapotát megtekintheti.';
$string['submissioncopiedsmall'] = 'Másolatot készített {$a->assignment} leadott munkájából.';
$string['submissioncopiedtext'] = 'Másolatot készített \'{$a->assignment}\' leadott munkájából.

Leadott munkájának állapotát megtekintheti: {$a->url}.';
$string['submissiondrafts'] = 'Tanulók számára a Leadás gombra kattintás előírása';
$string['submissiondrafts_help'] = 'Bekapcsolása esetén a tanulóknak  a Leadás gombra kattintva kell jelezni, hogy végeztek a leadandó munkával. Így a leadott munka piszkozatát megőrizhetik a rendszerben. Ha a beállítás a munkák leadása után "Nem"-ről "Igen"-re változik, a leadott munkákat a rendszert véglegesnek tekinti.';
$string['submissioneditable'] = 'A tanuló a leadandót szerkesztheti.';
$string['submissionempty'] = 'Nem történt leadás';
$string['submissionlog'] = 'Tanuló: {$a->fullname}, állapot: {$a->status}';
$string['submissionnotcopiedinvalidstatus'] = 'Leadott munkájáról nem készült másolat, mert újbóli megnyitása után szerkesztésre került sor.';
$string['submissionnoteditable'] = 'A tanuló a leadandót nem szerkesztheti.';
$string['submissionnotready'] = 'A feladathoz leadandó munka még nincs kész.';
$string['submissionplugins'] = 'Leadás segédprogramjai';
$string['submissionreceipthtml'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.<br /><br /> Állapotát megtekintheti a <a href="{$a->url}">leadott munka</a> alatt.';
$string['submissionreceiptotherhtml'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.<br /><br />
 Állapotát megtekintheti a <a href="{$a->url}">leadott munka</a> alatt.';
$string['submissionreceiptothersmall'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.';
$string['submissionreceiptothertext'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.

 Állapotát megtekintheti itt:
{$a->url}';
$string['submissionreceipts'] = 'Leadási értesítő küldése';
$string['submissionreceiptsmall'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.';
$string['submissionreceipttext'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.

Állapotát megtekintheti itt: {$a->url}';
$string['submissions'] = 'Leadott munkák';
$string['submissionsclosed'] = 'Leadás lezárva';
$string['submissionsettings'] = 'Leadás beállításai';
$string['submissionslocked'] = 'A feladathoz nem lehet munkát leadni.';
$string['submissionslockedshort'] = 'A leadott munka nem módosítható.';
$string['submissionsnotgraded'] = 'A leadott munkák osztályozása nem történt meg: {$a}';
$string['submissionstatement'] = 'Leadási nyilatkozat';
$string['submissionstatementacceptedlog'] = 'A leadási nyilatkozatot {$a} elfogadta.';
$string['submissionstatementdefault'] = 'A feladat saját munkám, kivéve azokat a részeket, ahol elismerem mások munkájának felhasználását.';
$string['submissionstatement_help'] = 'Feladatleadást megerősítő nyilatkozat';
$string['submissionstatus'] = 'Leadás állapota';
$string['submissionstatus_'] = 'Nincs leadott munka';
$string['submissionstatus_draft'] = 'Piszkozat (nincs leadva)';
$string['submissionstatusheading'] = 'Leadás állapota';
$string['submissionstatus_marked'] = 'Pontozott';
$string['submissionstatus_new'] = 'Nincs leadott munka';
$string['submissionstatus_reopened'] = 'Újból megnyitva';
$string['submissionstatus_submitted'] = 'Osztályozásra leadva';
$string['submissionsummary'] = '{$a->status}. Utolsó módosítás időpontja {$a->timemodified}';
$string['submissionteam'] = 'Csoport';
$string['submissiontypes'] = 'Leadási típusok';
$string['submitaction'] = 'Leadás';
$string['submitassignment'] = 'Feladat leadása';
$string['submitassignment_help'] = 'A feladat leadás után nem módosítható.';
$string['submitforgrading'] = 'Leadás osztályozásra';
$string['submitted'] = 'Leadva';
$string['submittedearly'] = 'Feladat {$a} idővel korábban leadva';
$string['submittedlate'] = 'Feladat {$a} idővel később leadva';
$string['submittedlateshort'] = '{$a} kései';
$string['subplugintype_assignfeedback'] = 'Visszajelzés segédprogramja';
$string['subplugintype_assignfeedback_plural'] = 'Visszajelzés segédprogramjai';
$string['subplugintype_assignsubmission'] = 'Leadás segédprogramja';
$string['subplugintype_assignsubmission_plural'] = 'Leadás segédprogramja';
$string['teamsubmission'] = 'Csoportos leadás';
$string['teamsubmissiongroupingid'] = 'Csoportosítás';
$string['teamsubmissiongroupingid_help'] = 'A feladat ezt a csoportosítást veszi figyelembe. Ha nincs beállítva, az alapkészletet használja.';
$string['teamsubmission_help'] = 'Bekapcsolása esetén a tanulók alapbeállítás vagy egyedi csoportosítás szerinti csoportokba kerülnek. A csoportos leadást a csoporttagok készítik el, akik látják egymás módosításait.';
$string['textinstructions'] = 'Feladat utasításai';
$string['timemodified'] = 'Utolsó módosítás';
$string['timeremaining'] = 'Hátralévő idő';
$string['unlimitedattempts'] = 'Korlátlan';
$string['unlimitedattemptsallowed'] = 'Korlátlan számú próbálkozás lehetséges';
$string['unlocksubmissionforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló részére leadások engedélyezése.';
$string['unlocksubmissions'] = 'Leadások feloldása';
$string['updategrade'] = 'Osztályzat frissítése';
$string['updatetable'] = 'Táblázat mentése és frissítése';
$string['upgradenotimplemented'] = '({$a->type} {$a->subtype}) segédprogram esetén a verziófrissítés nem történt meg.';
$string['userextensiondate'] = 'Halasztás engedélyezve eddig: {$a}';
$string['usergrade'] = 'Felhasználói osztályzat';
$string['userswhoneedtosubmit'] = 'Leadásra kötelezett tanulók: {$a}';
$string['validmarkingworkflowstates'] = 'Értékelési folyamat érvényes állapotai';
$string['viewbatchmarkingallocation'] = 'Értékelők ömlesztett hozzárendelésének megtekintése';
$string['viewbatchsetmarkingworkflowstate'] = 'Értékelési folyamatállapot ömlesztett megtekintése';
$string['viewfeedback'] = 'Visszajelzés megtekintése';
$string['viewfeedbackforuser'] = '{$a} felhasználó visszajelzésének megtekintése';
$string['viewfull'] = 'Teljes áttekintés';
$string['viewfullgradingpage'] = 'Visszajelzéshez nyissa meg a teljes osztályozó oldalt.';
$string['viewgradebook'] = 'Osztályozónapló megtekintése';
$string['viewgrading'] = 'Minden leadott munka megtekintése/osztályozása';
$string['viewgradingformforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló osztályozó oldalának megtekintése..';
$string['viewownsubmissionform'] = 'Saját feladatleadó oldal megtekintése';
$string['viewownsubmissionstatus'] = 'Saját leadott munka állapotát muató oldal megtekintése';
$string['viewrevealidentitiesconfirm'] = 'Tanulók kilétének felfedését megerősítő oldal megtekintése';
$string['viewsubmission'] = 'Leadott munka megtekintése';
$string['viewsubmissionforuser'] = '{$a} leadott munkájának megtekintése';
$string['viewsubmissiongradingtable'] = 'Leadott munka osztályozó táblázatának megtekintése';
$string['viewsummary'] = 'Összegzés megtekintése';
$string['workflowfilter'] = 'Folyamatszűrő';
