# pH7 Social Dating CMS

### The Most Secure and Powerful Professional Dating Web App Builder


[![Build Status](https://scrutinizer-ci.com/g/pH7Software/pH7-Social-Dating-CMS/badges/build.png?b=master)](https://scrutinizer-ci.com/g/pH7Software/pH7-Social-Dating-CMS/build-status/master) [![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/pH7Software/pH7-Social-Dating-CMS/badges/quality-score.png?b=master)](https://scrutinizer-ci.com/g/pH7Software/pH7-Social-Dating-CMS/?branch=master) [![PayPal donate button](http://img.shields.io/badge/paypal-donate-orange.svg)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=XWLDYLFKCLEJQ "Help keep me off the streets! ;)")


**pH7 Social Dating CMS** is a **Professional** & **Open Source** Social Dating CMS, fully responsive design, low-resource-intensive, powerful and very secure.

pH7CMS is included with 34 modules and based on its homemade framework (pH7Framework). It is also the first Professional, free and open source European Social Dating Site Builder Software and the first choice for creating enterprise level Dating Apps/Service or social networking sites.


![Professional PHP Social Dating Builder Software](https://cloud.githubusercontent.com/assets/1325411/19419476/5475b32c-93d0-11e6-9756-8e7db8df129f.png)


## Overview

**pH7 Dating CMS** is a **Social/Dating CMS** written in **Object-Oriented** PHP (*OOP*), fully compatible and highly optimised for PHP 7+ and based on **MVC** architecture (Model-View-Controller).

It is designed with the **KISS** principle in mind, and the all source code can be read and understood in minutes. For a better flexibility, the software uses **PDO** (PHP Data Objects) abstraction which allows the choice of the database. The principle of development is **DRY** (Don't Repeat Yourself) aimed at reducing repetition of information of all kinds (not duplicate code).

This Free and Open Source **Social Dating Site Builder** wants to be low resource-intensive, powerful, stable and secure. The software also comes with 34 system modules and is based on **pH7Framework** *(written specifically for this project)* that has over 52 packages.

To summarize, **pH7CMS** gives you **the perfect ingredients** to create the **best dating service** or **social networking** website on the World Wide Web!


## How Powerful is your future Dating App?

* Best Dating Features
* Advanced Search
* Blogs
* Notes
* Pages Management
* Friends/Mutual Friends, Visit, Messages, Instant messaging, Views, Like, Rating, Smileys, Geo Map, Avatar, Wallpaper, ...
* Related Profiles (for better user experience and faster match)
* Custom Profile (Background profile)
* Comments
* Hot or Not
* Love Calculator
* Geolocation
* Photo Albums
* Videos (and possibility to upload videos from API v3 YouTube, Vimeo, Metacafe and Dailymotion)
* Forums
* Full Moderation of all contents posted by your users
* Nudity Filter Option for all images uploaded by users
* Dating Scammer Detector (see if profile photos aren't used by scammers)
* Anti-Scam Tools
* Watermark Branding
* Chat Rooms
* Chatroulette
* Games (with high quality and viral games installed)
* Webcam Shot
* Affiliate
* Newsletter
* Activity Streams
* Member approval system
* Advanced Admin Panel
* Complete Membership System
* Payment Gateways Integration for PayPal, Stripe, Bitcoin and 2CheckOut
* Statistics & Analytics System
* Live Notification System
* Registration delay (to avoid spam)
* File Management
* Dynamic Field Forms Management
* Privacy Settings
* Banner/Advertisement Management
* Fake Profile Generator
* CSV User Importer
* Support for Multiple Languages, Internationalization and Localization (I18N)
* American & European for the Time and Date formats
* Cache system for the database, pH7Tpl (our template engine), static files (HTML, CSS, JS), string content, ...
* Maintenance Mode
* Database Backup
* Report
* SEO-Friendly (Title, Content, Code, ...), Sitemap module, [hreflang](https://support.google.com/webmasters/answer/189077), possibility to translate each URL, ...
* Multilingual URLs
* Check that all UGC (User-Generated Content) are Unique (to avoid spam and malicious users)
* RSS Feed
* Fully API for integration from an external app (iOS/Android, ...), website, program, ...
* Feedback
* Fully Responsive Templates
* CSV User Importer
* Fake Profile Generator
* Memberships/Groups Manager
* Publishable easily into Android/iPhone/iOS webview mobile app thanks its Mobile-Optimized Templates.
* Multiple-Themes and many customization possible
* Message templates
* Multi Themes and many personalizable
* Includes top HTML5 features
* Allow to sign in to your site with Facebook, Google and Twitter thanks pH7CMS's Connect module
* Invite Friends
* Social Bookmark (Social Media Sharing Buttons)
* Anti-spam system
* Full Security system against XSS, CSRF, SQL injection, authentication hacking, session fixation, brute-force, reverse tabnabbing phishing attacks, ... and can even prevent some DDoS attacks!
* Two-Factor Authentication Option available for Admins, Users and Affiliates
* Admin Panel - Block Access with IP Restriction
* Beautiful Code: Very thoroughly commented about what's happening throughout the PHP code, beautiful indentation and very readable, even for non-programmers
* Everyone can easily contribute to this great innovative project with our [GitHub repository](https://github.com/pH7Software/pH7-Social-Dating-CMS)


**It's not a hazard that pH7CMS is considered to be the first choice for creating enterprise level Dating Apps/Service or Social Networking Sites**

*If you want more, [here are other great features](http://ph7cms.com/social-dating-features/) included in pH7CMS (and obviously in [pH7CMS Pro](http://ph7cms.com/pro/) as well) that may interest you!*

![Build a Social Dating Web App with pH7CMS](https://cloud.githubusercontent.com/assets/1325411/19419481/657386a4-93d0-11e6-8eee-95deba2d30a0.png)


## Requirements

* **Application Server** PHP 5.6 or higher (Recommended Version: **PHP 7.0.4** or higher).

* **Database** MySQL/MariaDB 5.0.15 or higher.

* **Operating System** Linux/Unix (Red Hat, CentOS, Debian, FreeBSD, Mandrake, Mac OS, etc.), Windows.

* **Web Server** Apache with mod_php or with PHP in CGI, FastCGI mode (nginx, LiteSpeed and IIS should also work you should change some pieces of code and change the url rewriting to make it work).

* **URL rewriting extension module** Apache, nginx, LiteSpeed, IIS (for Web.config, you have a [good tutorial here](http://www.phpgenious.com/2010/04/url-rewriting-with-php-and-iis-7/)).

* **Specific Requirement** Server has to be connected to Internet.

* **Minimum Web Space** 2.0 GB

* **pH7CMS's Video Module Requirement (only if enabled)** [FFmpeg](http://ffmpeg.org)


## Installation

  * Github:
    * Clone pH7CMS from Github `git clone git@github.com:pH7Software/pH7-Social-Dating-CMS.git`
    * Install Composer (https://getcomposer.org)
    * From a command line opened in the folder, run `composer install` to install pH7CMS's dependencies.
  * Composer:
    * Install Composer (https://getcomposer.org)
    * `composer create-project ph7software/ph7cms --prefer-dist website`
  * Sourceforge:
    * Directly download the latest stable version [from Sourceforge](https://sourceforge.net/projects/ph7socialdating/)
  * Softaculous:
    * If your Web host offers Softaculous, you might be able to install [pH7CMS in one-click with Softaculous](http://www.softaculous.com/softwares/socialnetworking/pH7CMS)


## Nginx Configuration

In order to get pH7CMS working on nginx server, you need to add some custom nginx configuration.

Create `/etc/nginx/ph7cms.conf` and add the following:

```nginx
location / {
    try_files $uri $uri/ /index.php?$args;
    index index.php;
}
```

*Please note that the above code is the strict minimum and obviously you can add more by comparing with the [main Apache .htaccess file](https://github.com/pH7Software/pH7-Social-Dating-CMS/blob/master/.htaccess).*


Now in your nginx server configuration you will have to include `ph7cms.conf` file to complete the configuration like below:

In file, e.g., *`/etc/nginx/sites-enabled/yoursite.conf`* for Ubuntu and other OS based on Debian or `/etc/nginx/conf.d/yoursite.conf` for CentOS and other OS based on Red Hat.

```nginx
server {
    # Port number. In most cases, 80 for HTTP and 443 for HTTPS
    listen 80;

    server_name www.yoursite.com;
    root /var/www/ph7cms_public_root;
    index index.php; #you can use index.ph7; for hidding the *.php ...
    client_max_body_size 50M;

    error_log /var/log/nginx/yoursite.error.log;
    access_log /var/log/nginx/yoursite.access.log;

    # Include ph7cms.conf. You can also directly add the "location" rule instead of including the conf file
    include /etc/nginx/ph7cms.conf;
}
```

For more information, please refer to the nginx documentation.
<br />

![Create Your Own Niche Dating Service in New York City](https://cloud.githubusercontent.com/assets/1325411/19419480/65738a1e-93d0-11e6-9fbe-a48fa36fc53a.png)


## Translations

You can find and add other languages on the [I18N repo](https://github.com/pH7Software/pH7-Internationalization).


## Author

**[Pierre-Henry Soria](http://ph7.me)**


## Website

**[Social Dating Script](http://ph7cms.com)**


## Documentation

[pH7CMS Documentation](http://ph7cms.com/doc/)


## Contributing

![I Love Open Source](static/img/logo-lightbg.png)

Anyone can contribute on **[pH7CMS GitHub](https://github.com/pH7Software/pH7-Social-Dating-CMS)** repository!

Finding bugs, improving the CMS/doc or adding translations. Any contribution is welcome and highly appreciated!

Just clone the repository, make your changes and then make a push ;-)

*WARNING, your code/modification must be of excellent quality and follow the [Code Convention](http://ph7cms.com/doc/en/code-convention).* I manually validate all the improvements and changes.

You will also be eligible to [pH7CMS VIP members](http://ph7cms.com/get-one-tine-license-for-free/) and get all premium contents.


## Tools/Software Used to Develop pH7CMS

* LAMP on **Fedora/Ubuntu** (and Windows/Mac with WampServer/MAMP for testing purpose)

* **Geany &amp; Sublime Text** for coding the whole project. That's it! However, since pH7CMS 5.0, PhpStorm is used as well.

* **GIMP** for editing the assets, etc.

* **Trimage** (and ImageOptim when developing on Mac) for compressing &amp; optimizing the images

* **Poedit** for translating the Gettext files

* **FileZilla** for FTP client

* **Git** for the version control system


## Contact

You can send email for any suggestions or feedback at *hello {AT} ph7cms {D0T} com* OR *pierrehenrysoria {AT} gmail {D0T} com*


## License

**pH7CMS** is under **Open Source Free** License.

License: [General Public License 3](http://www.gnu.org/licenses/gpl.html) or later; See the *PH7.LICENSE.txt* and *PH7.COPYRIGHT.txt* files for more details.


![Admin Panel, Browse Users](https://cloud.githubusercontent.com/assets/1325411/14080251/b476e5c6-f4fb-11e5-825e-ddc992ba1055.png)
![pH7CMS allows anyone to start a web dating app like Tinder/Bumble or Badoo](https://cloud.githubusercontent.com/assets/1325411/19419477/5476b45c-93d0-11e6-823d-d293f186c0f7.png)
