<?php


##################################################
#                                                #
# GK~root - Creating a better web                #
# Copyright (c) GK~root. All Rights Reserved.    #
# Software: Remote Mx Wizard                     #
# Version: 1.0.3                                 #
# Create Date: Jan 07 2015                       #
# Website: http://www.gk-root.com                #
#                                                #
##################################################
#                                                #
# This software is released under a license.     #
# You cannot transfer it to any other person,    #
# resell it or claim any code as your own.       #
# By using the software you agree to this terms. #
#                                                #
##################################################

function SetLangFile() {
	global $LiveCpApi;
	$userlocale = $LiveCpApi->api2('Locale','get_user_locale');
	$UserLocalFile = '/usr/local/cpanel/base/3rdparty/RemoteMxWizard/lang/'.trim($userlocale['cpanelresult']['data'][0]['locale']).'.php';
	if (file_exists($UserLocalFile)) {
		$UserLangFile = $UserLocalFile;
	} else {
		$UserLangFile = '/usr/local/cpanel/base/3rdparty/RemoteMxWizard/lang/en.php';
	}
	return $UserLangFile;
}

function SetStdHeader() {
	global $LiveCpApi;
	$stdheader = $LiveCpApi->api1("Branding", "include", array("stdheader.html"));
	return $stdheader['cpanelresult']['data']['result'];
}

function SetStdFooter() {
	global $LiveCpApi;
	$stdfooter = $LiveCpApi->api1("Branding", "include", array("stdfooter.html"));
	return $stdfooter['cpanelresult']['data']['result'];
}

function UserTheme() {
	global $LiveCpApi;
	$statsbar = $LiveCpApi->api2('StatsBar','stat',array("display"=>"theme"));
	$cpTheme = trim($statsbar['cpanelresult']['data'][0]['value']);
	if (!empty($cpTheme)) {	
		return $cpTheme;
	} else {
		return false;
	}
}

function cpBase($UserTheme) {
	if (isset($_ENV['cp_security_token'])) {
		$cptokuri = $_ENV['cp_security_token'].'/frontend/';
	} else {
		$cptokuri = '/frontend/';
	}
	if ($UserTheme) {
		return $cptokuri.$UserTheme.'/';
	} else {
		return false;
	}
}

function cpToken() {
	$cp_security_token = getenv('cp_security_token');
	if (isset($_ENV['cp_security_token'])) {
		if (!empty($cp_security_token)) {
			return str_replace("/", "", $cp_security_token);
		}
	}
	return false;
}

function GetAlwaysAccept($domain) {
	global $LiveCpApi;
	$getalwaysaccept = $LiveCpApi->api2("Email", "getalwaysaccept", array("domain"=>$domain));
	$res['alwaysaccept'] = $getalwaysaccept['cpanelresult']['data'][0]['alwaysaccept'];
	$UserConfFile = getenv('HOME').'/.remotemxwizard/oldprovider.conf';
	if (file_exists($UserConfFile)) {
		$res['mxconf'] = $UserConfFile;
	} else {
		$res['mxconf'] = false;
	}
	return $res;
}

function SaveProviderConfig($ConfFile) {
	$UserConfDir = getenv('HOME').'/.remotemxwizard';
	if (!file_exists($UserConfDir)) {
		mkdir($UserConfDir);
	}
	$FullConfFile = '/usr/local/cpanel/base/3rdparty/RemoteMxWizard/mail_providers/'.$ConfFile;
	if (file_exists($FullConfFile)) {
		if (copy($FullConfFile, $UserConfDir.'/oldprovider.conf')) {
			return true;
		}
	}
	return false;
}

function RemoveProviderConfig() {
	$UserConfFile = getenv('HOME').'/.remotemxwizard/oldprovider.conf';
	$UserSpfFile = getenv('HOME').'/.remotemxwizard/oldspfrecord';
	if (file_exists($UserConfFile)) {
		if (unlink($UserConfFile)) {
			if (file_exists($UserSpfFile)) {unlink($UserSpfFile);}
			if (rmdir(getenv('HOME').'/.remotemxwizard')) {
				return true;
			}
		}
	}
	return false;
}

function FetchLocalDomainZone($domain,$services=false) {
	global $LiveCpApi;
	$domainzone = $LiveCpApi->api2('ZoneEdit','fetchzone_records',array("domain"=>$domain));
	$getmainserverip = $LiveCpApi->api2('SPFUI','getmainserverip',array("user"=>getenv('USER')));
	$res['serverip'] = $getmainserverip['cpanelresult']['data'][0]['mainserverip'];
	foreach($domainzone['cpanelresult']['data'] as $val) {
		if ($val['type'] == 'MX') {
			if ($val['name'] == $domain.'.') {
				$res['oldMxPri'] = $val['preference'];
			}
		}
		if ($val['type'] == 'TXT') {
			if ($val['name'] == $domain.'.') {
				if (preg_match("/v=spf/i", $val['record'])) {
					$res['RspfLine']	= $val['line'];
					$res['spfOld']		= $val['record'];
				}
			}
		}
		if ($val['type'] == '$TTL') {
			$res['GlobalTTL'] = $val['ttl'];
		}
		if (isset($val['name'])) {
			if ($val['name'] == 'mail.'.$domain.'.') {$res['mailLine'] = $val['line'];}
			if ($val['name'] == 'webmail.'.$domain.'.') {$res['webmailLine'] = $val['line'];}
			if ($services && is_array($services)) {
				foreach ($services as $Service) {
					$rType = trim($Service[0]);
					$rName = trim($Service[1]);
					$rDest = trim($Service[2]);
					$rOptional = trim($Service[3]);
					if ($val['name'] == $rName.'.'.$domain.'.') {$res['services'][$rName] = $val['line'];}
				}
			}
		}
	}
	return $res;
}


function EditMailLine($domain,$des,$mailLine,$ttl,$mailrecord) {
	global $LiveCpApi;
	global $LANG;
	if ($mailrecord == 'mail') {
		$type = 'CNAME';
		$destype = 'cname';
	} elseif ($mailrecord == 'webmail') {
		$type = 'A';
		$destype = 'address';
	}
	$EditMailLine = $LiveCpApi->api2('ZoneEdit','edit_zone_record',array("domain"=>$domain,"line"=>$mailLine,"name"=>$mailrecord,"type"=>$type,$destype=>$des,"ttl"=>$ttl));
	if ($EditMailLine['cpanelresult']['data'][0]['result']['status'] == "1") {
		print('<p>'.$LANG['funcmsg1'].' "'.$mailrecord.'.'.$domain.'" '.$LANG['funcmsg2'].' "'.$des.'" '.$LANG['funcmsg6'].' '.$type.' '.$LANG['funcmsg7'].'.</p>');
	} else {
		print('<p class="red">'.$EditMailLine['cpanelresult']['data'][0]['result']['statusmsg'].'</p>');
	}
}

function SetProviderServices($domain,$service,$cname,$Rtype,$ttl) {
	global $LiveCpApi;
	global $LANG;
	if (!empty($service)) {
		$AddRecord = $LiveCpApi->api2('ZoneEdit','add_zone_record',array("domain"=>$domain,"name"=>$service,"type"=>$Rtype,"cname"=>$cname,"ttl"=>$ttl));
		if ($AddRecord['cpanelresult']['data'][0]['result']['status'] == "1") {
			echo '<p>'.$LANG['funcmsg1'].' "'.$service.'.'.$domain.'" '.$LANG['funcmsg2'].' "'.$cname.'" '.$LANG['funcmsg6'].' '.$Rtype.' '.$LANG['funcmsg7'].'.</p>';
		} else {
			echo '<p class="red">'.$AddRecord['cpanelresult']['data'][0]['result']['statusmsg'].'</p>';
		}
	}
}

function SetProviderMXs($providername,$domain,$ProviderMXs,$oldpreference,$BackupMxPreference,$ProviderSPF,$ttl) {
	global $LiveCpApi;
	global $LANG;
	foreach ($ProviderMXs as $MXrecord=>$Preference) {
		$addmx = $LiveCpApi->api2('Email','addmx',array("domain"=>$domain,"exchange"=>$MXrecord,"preference"=>$Preference,"alwaysaccept"=>"remote"));
		if ($addmx['cpanelresult']['data'][0]['status'] == "1") {
			echo '<p>'.$LANG['funcmsg10'].' '.$providername.' '.$LANG['funcmsg16'].': "'.$MXrecord.'".</p>';
			if (isset($addmx['cpanelresult']['data'][0]['checkmx']['warnings']) && !empty($addmx['cpanelresult']['data'][0]['checkmx']['warnings'])) {
				echo '<p>'.$addmx['cpanelresult']['data'][0]['checkmx']['warnings'].'</p>';
			}
		} else {
			echo '<p class="red">'.$LANG['funcmsg11'].' '.$providername.' "'.$MXrecord.'".<br>'.$addmx['cpanelresult']['data'][0]['statusmsg'].'</p>';
		}
	}
	if (empty($BackupMxPreference)) {
		$delmx = $LiveCpApi->api2('Email','delmx',array("domain"=>$domain,"exchange"=>$domain,"preference"=>$oldpreference));
		if ($delmx['cpanelresult']['data'][0]['status'] == "1") {
			echo '<p>'.$LANG['funcmsg8'].' '.$LANG['funcmsg14'].': "'.$domain.'".</p>';
		} else {
			echo '<p class="red">'.$LANG['funcmsg9'].' '.$LANG['funcmsg14'].': "'.$domain.'".<br>'.$delmx['cpanelresult']['data'][0]['statusmsg'].'</p>';
		}
	} else {
		$changemx = $LiveCpApi->api2('Email','changemx',array("domain"=>$domain,"exchange"=>$domain,"oldexchange"=>$domain,"oldpreference"=>$oldpreference,"preference"=>$BackupMxPreference));
		if ($changemx['cpanelresult']['data'][0]['status'] == "1") {
			echo '<p>'.$LANG['funcmsg12'].'</p>';
			if (isset($changemx['cpanelresult']['data'][0]['checkmx']['warnings']) && !empty($changemx['cpanelresult']['data'][0]['checkmx']['warnings'])) {
				echo '<p>'.$changemx['cpanelresult']['data'][0]['checkmx']['warnings'].'</p>';
			}
		} else {
			echo '<p class="red">'.$LANG['funcmsg13'].'.<br>'.$CMX['cpanelresult']['data'][0]['statusmsg'].'</p>';
		}
	}
	if (!empty($ProviderSPF)) {
		$AddSpf = $LiveCpApi->api2('ZoneEdit','add_zone_record',array("domain"=>$domain,"name"=>$domain.'.','txtdata'=>$ProviderSPF,"type"=>"TXT","ttl"=>$ttl,"class"=>"IN"));
		if ($AddSpf['cpanelresult']['data'][0]['result']['status'] == "1") {
			echo '<p>'.$LANG['funcmsg10'].' '.$providername.' '.$LANG['funcmsg15'].': "'.$ProviderSPF.'".</p>';
		} else {
			echo '<p class="red">'.$AddSpf['cpanelresult']['data'][0]['result']['statusmsg'].'</p>';
		}
	}
}

function GetUserOldSpf() {
	$UserOldSpfFile = getenv('HOME').'/.remotemxwizard/oldspfrecord';
	if (file_exists($UserOldSpfFile)) {
		$OldSpfRecord = trim(file_get_contents($UserOldSpfFile));
		if (!empty($OldSpfRecord)) {
			return $OldSpfRecord;
		}
	}
	return false;
}

function RemoveProviderMXs($domain,$ttl,$OldProviderConf) {
	global $LiveCpApi;
	global $LANG;
	$UserOldSpfRecord = GetUserOldSpf();
	foreach ($OldProviderConf['MXs'] as $MXrecord=>$Preference) {
		$RMX = $LiveCpApi->api2('Email','delmx',array("domain"=>$domain,"exchange"=>$MXrecord,"preference"=>$Preference,"alwaysaccept"=>"local"));
		if ($RMX['cpanelresult']['data'][0]['status'] == "1") {
			print('<p>'.$LANG['funcmsg8'].' '.$OldProviderConf['NAME'].' '.$LANG['funcmsg16'].': "'.$MXrecord.'".</p>');
			if (isset($RMX['cpanelresult']['data'][0]['checkmx']['warnings']) && !empty($RMX['cpanelresult']['data'][0]['checkmx']['warnings'])) {
				print('<p>'.$RMX['cpanelresult']['data'][0]['checkmx']['warnings'].'</p>');
			}
		} else {
			print('<p class="red">'.$LANG['funcmsg9'].' '.$OldProviderConf['NAME'].' '.$LANG['funcmsg16'].': "'.$MXrecord.'".<br>'.$RMX['cpanelresult']['data'][0]['statusmsg'].'</p>');
		}
	}
	if (empty($OldProviderConf['BACKUPMX'])) {
		$BMXR = $LiveCpApi->api2('Email','addmx',array("domain"=>$domain,"exchange"=>$domain,"preference"=>"0","alwaysaccept"=>"local"));
		if ($BMXR['cpanelresult']['data'][0]['status'] == "1") {
			print('<p>'.$LANG['funcmsg10'].' '.$LANG['funcmsg14'].': "'.$domain.'".</p>');
		} else {
			print('<p class="red">'.$LANG['funcmsg11'].' '.$LANG['funcmsg14'].': "'.$domain.'".<br>'.$BMXR['cpanelresult']['data'][0]['statusmsg'].'</p>');
		}
	} else {
		$CBMXR = $LiveCpApi->api2('Email','changemx',array("domain"=>$domain,"exchange"=>$domain,"oldexchange"=>$domain,"oldpreference"=>$OldProviderConf['BACKUPMX'],"preference"=>"0","alwaysaccept"=>"local"));
		if ($CBMXR['cpanelresult']['data'][0]['status'] == "1") {
			print('<p>'.$LANG['funcmsg12'].'</p>');
			if (isset($CBMXR['cpanelresult']['data'][0]['checkmx']['warnings']) && !empty($CBMXR['cpanelresult']['data'][0]['checkmx']['warnings'])) {
				print('<p>'.$CBMXR['cpanelresult']['data'][0]['checkmx']['warnings'].'</p>');
			}
		} else {
			print('<p class="red">'.$LANG['funcmsg13'].'<br>'.$CBMXR['cpanelresult']['data'][0]['statusmsg'].'</p>');
		}
	}
	if ($UserOldSpfRecord) {
		$AddUserOldSpf = $LiveCpApi->api2('ZoneEdit','add_zone_record',array("domain"=>$domain,"name"=>$domain.'.','txtdata'=>$UserOldSpfRecord,"type"=>"TXT","ttl"=>$ttl,"class"=>"IN"));
		if ($AddUserOldSpf['cpanelresult']['data'][0]['result']['status'] == "1") {
			print('<p>'.$LANG['funcmsg10'].' '.$LANG['funcmsg17'].' "'.$UserOldSpfRecord.'".</p>');
		} else {
			print('<p class="red">'.$AddUserOldSpf['cpanelresult']['data'][0]['result']['statusmsg'].'</p>');
		}
	}
	if (RemoveProviderConfig()) {
		print('<p>'.$LANG['funcmsg18'].'</p>');
	} else {
		print('<p class="red">'.$LANG['funcmsg19'].'</p>');
	}
}

function RemoveZoneRecord($providername,$domain,$record,$line,$spf=false) {
	global $LiveCpApi;
	global $LANG;
	if ($spf) {
		$userdir = getenv('HOME').'/.remotemxwizard';
		if (!file_exists($userdir)) {mkdir($userdir);}
		if (file_put_contents($userdir.'/oldspfrecord',$spf)) {
			echo '<p>'.$LANG['funcmsg20'].' '.$LANG['funcmsg17'].': "'.$spf.'".</p>';
		} else {
			echo '<p>'.$LANG['funcmsg21'].' '.$LANG['funcmsg17'].': "'.$spf.'".</p>';
		}
		$Rspf = $LiveCpApi->api2('ZoneEdit','remove_zone_record',array("domain"=>$domain,"line"=>$line));
		if ($Rspf['cpanelresult']['data'][0]['result']['status'] == "1") {
			echo '<p>'.$LANG['funcmsg8'].' '.$LANG['funcmsg17'].' '.$LANG['funcmsg22'].': "'.$domain.'".</p>';
		} else {
			echo '<p class="red">'.$Rspf['cpanelresult']['data'][0]['result']['statusmsg'].'</p>';
		}
	} elseif (!empty($record) && $spf == false && !empty($line)) {
		sleep(1);
		$fetchzone = $LiveCpApi->api2('ZoneEdit','fetchzone_records',array("domain"=>$domain));
		foreach($fetchzone['cpanelresult']['data'] as $valz) {
			if (isset($valz['name'])) {
				if ($valz['name'] == $record.'.'.$domain.'.') {$rLine = $valz['line'];}
			}
		}
		$RZR = $LiveCpApi->api2('ZoneEdit','remove_zone_record',array("domain"=>$domain,"line"=>$rLine));
		if ($RZR['cpanelresult']['data'][0]['result']['status'] == "1") {
			echo '<p>'.$LANG['funcmsg8'].' '.$record.'.'.$domain.' '.$LANG['funcmsg7'].'.</p>';
		} else {
			echo '<p class="red">'.$RZR['cpanelresult']['data'][0]['result']['statusmsg'].'</p>';
		}
	} elseif (empty($record) && $spf == false && !empty($line)) {
		$sRZR = $LiveCpApi->api2('ZoneEdit','remove_zone_record',array("domain"=>$domain,"line"=>$line));
		if ($sRZR['cpanelresult']['data'][0]['result']['status'] == "1") {
			echo '<p>'.$LANG['funcmsg8'].' '.$providername.' '.$LANG['funcmsg15'].' '.$LANG['funcmsg22'].': "'.$domain.'".</p>';
		} else {
			echo '<p class="red">'.$sRZR['cpanelresult']['data'][0]['result']['statusmsg'].'</p>';
		}
	}
}

function GawMatchConfig($domain) {
	global $LiveCpApi;
	if (file_exists('/usr/local/cpanel/base/3rdparty/RemoteMxWizard/mail_providers/google_apps.conf')) {
		$GawConf = GetMailProviderConf('google_apps.conf');
		$listmxs = $LiveCpApi->api2('Email','listmxs',array("domain"=>$domain));
		foreach ($listmxs['cpanelresult']['data'][0]['entries'] as $mxrecord) {
			$userMXS = trim($mxrecord['mx']);
			if (array_key_exists($userMXS,$GawConf['MXs'])) {
				if (SaveProviderConfig('google_apps.conf')) {
					return true;
				}
			}
		}
	}
	return false;
}

?>