<?php


##################################################
#                                                #
# GK~root - Creating a better web                #
# Copyright (c) GK~root. All Rights Reserved.    #
# Software: Remote Mx Wizard                     #
# Version: 1.0.3                                 #
# Create Date: Jan 07 2015                       #
# Website: http://www.gk-root.com                #
#                                                #
##################################################
#                                                #
# This software is released under a license.     #
# You cannot transfer it to any other person,    #
# resell it or claim any code as your own.       #
# By using the software you agree to this terms. #
#                                                #
##################################################

function GetMailProviders($WHM=false) {
	$ProvidersDir = '/usr/local/cpanel/base/3rdparty/RemoteMxWizard/mail_providers/';
	foreach (glob($ProvidersDir."*.conf") as $file) {
		$conf = GetMailProviderConf(basename($file));
		if ($WHM) {
			$conf['CONFFILENAME'] = basename($file);
			$Providers[] = $conf;
		} else {
			if ($conf['STATUS']) {
				$conf['CONFFILENAME'] = basename($file);
				$Providers[] = $conf;
			}
		}
	}
	if (is_array($Providers)) {
		return $Providers;
	} else {
		return array();
	}
}

function GetMailProviderConf($FileName,$Remove=false) {
	$res = array();
	if ($Remove) {
		$ConfFileContent = file(getenv('HOME').'/.remotemxwizard/oldprovider.conf');
	} else {
		if ($FileName) {
			$ConfFileContent = file('/usr/local/cpanel/base/3rdparty/RemoteMxWizard/mail_providers/'.$FileName);	
		}
	}
	if (is_array($ConfFileContent)) {
		foreach ($ConfFileContent as $Line) {
			$fParts = explode('==',$Line);
			if (strpos($fParts[0],'MXR') !== false) {
				$mxlineP = explode(':',$fParts[1]);
				$mxrecord = trim($mxlineP[0]);
				$mxpri = ($mxlineP[1]);
				$res['MXs'][$mxrecord] = $mxpri;
			} elseif (strpos($fParts[0],'SERVICER') !== false) {
				$res['SERVICERS'][] = explode(':',$fParts[1]);
			} elseif (strpos($fParts[0],'CNAMER') !== false) {
				$res['CNAMER'] = trim($fParts[1]);
			} elseif (strpos($fParts[0],'SPFR') !== false) {
				$res['SPFR'] = trim($fParts[1]);
			} elseif (strpos($fParts[0],'BACKUPMX') !== false) {
				$res['BACKUPMX'] = trim($fParts[1]);
			} elseif (strpos($fParts[0],'DESCRIPTION') !== false) {
				$res['DESCRIPTION'] = trim($fParts[1]);
			} elseif (strpos($fParts[0],'STATUS') !== false) {
				$res['STATUS'] = trim($fParts[1]);
			} elseif (strpos($fParts[0],'PNAME') !== false) {
				$res['NAME'] = trim($fParts[1]);
			} elseif (strpos($fParts[0],'DISPLAYNAME') !== false) {
				$res['DISPLAYNAME'] = trim($fParts[1]);
			}
		}
	}
	return $res;
}

?>