<?php


##################################################
#                                                #
# GK~root - Creating a better web                #
# Copyright (c) GK~root. All Rights Reserved.    #
# Software: Remote Mx Wizard                     #
# Version: 1.0.3                                 #
# Create Date: Jan 07 2015                       #
# Website: http://www.gk-root.com                #
#                                                #
##################################################
#                                                #
# This software is released under a license.     #
# You cannot transfer it to any other person,    #
# resell it or claim any code as your own.       #
# By using the software you agree to this terms. #
#                                                #
##################################################

function ChangeProviderStatus($CpToken,$SetProviderStatus,$confFile) {
	if ($CpToken != $_ENV['cp_security_token']) {return false;}
	if (!validateConfFileName($confFile)) {return false;}
	$ProviderFile = '/usr/local/cpanel/base/3rdparty/RemoteMxWizard/mail_providers/'.$confFile;
	$ProviderFileContect = file_get_contents($ProviderFile);
	if (strpos($ProviderFileContect,'STATUS==1') !== false) {
		if (file_put_contents($ProviderFile,str_replace("STATUS==1", "STATUS==0", $ProviderFileContect))) {
			return true;
		}
	} elseif (strpos($ProviderFileContect,'STATUS==0') !== false) {
		$testValidConf = ValidateProviderConf($CpToken,$confFile);
		if ($testValidConf['status']) {
			if (file_put_contents($ProviderFile,str_replace("STATUS==0", "STATUS==1", $ProviderFileContect))) {
				return true;
			}
		}
	}
	return false;
}

function SaveMailProviderConf($CpToken) {
	$return['status'] = false;
	if ($CpToken == $_ENV['cp_security_token']) {
		$ConfFileStr = trim($_POST['Pconffile']);
		if (!validateConfFileName($ConfFileStr)) {$return['errors'][] = 'Invalid Provider File Name';}
		if (!empty($ConfFileStr)) {$Pconffile = '/usr/local/cpanel/base/3rdparty/RemoteMxWizard/mail_providers/'.$ConfFileStr;} else {$Pconffile = '';}		
		if (!empty($_POST['providername'])) {$Pname = ucwords(preg_replace('!\s+!', ' ', $_POST['providername']));} else {$Pname = '';}
		if (!empty($_POST['Pdescription'])) {$Pdescription = $_POST['Pdescription'];} else {$Pdescription = '';}
		if (!empty($_POST['backupmx'])) {$Pbackupmx = $_POST['backupmx'];} else {$Pbackupmx = '';}
		if (!empty($_POST['spfrecord'])) {$Pspf = $_POST['spfrecord'];} else {$Pspf = '';}
		if (!empty($_POST['Pstatus'])) {$Pstatus = $_POST['Pstatus'];} else {$Pstatus = '0';}
		if (!empty($_POST['MXS'])) {$Pmxs = $_POST['MXS'];} else {$Pmxs = '';}
		if (isset($_POST['additional'])) {if (is_array($_POST['additional'])) {$Pservices = $_POST['additional'];} else {$Pservices = array();}} else {$Pservices = array();}
		// Configuration file content
		$ConfFileContent = "PNAME==".$Pname."\nDESCRIPTION==".$Pdescription."\nBACKUPMX==".$Pbackupmx."\nSPFR==".$Pspf."\nSTATUS==".$Pstatus."\n";
		$mxArray = explode("\n",$Pmxs);
		$i=0;
		$ConfMxContent = '';
		$return['MXR'] = false;
		if (!empty($Pmxs) && preg_match('/^[a-z0-9.-:|\s]+$/i', $Pmxs)) {
			foreach ($mxArray as $line) {
				$cleanline = trim($line);
				if (!empty($cleanline)) {
					$LinePart = explode(':',$line);
					if (!empty($LinePart[0]) && !empty($LinePart[1])) {
						$ConfMxContent .= "MXR".$i."==".$LinePart[0].":".$LinePart[1]."\n";
						$i++;
					} else {
						$return['errors'][] = 'Invalid Provider MXs syntax for ['.$line.']';
					}
				}
			}
			$return['MXR'] = $Pmxs;
		} elseif (!empty($Pmxs)) {
			$return['errors'][] = 'Invalid Provider MXs syntax';
		}
		if (!empty($ConfMxContent)) {
			$ConfFileContent .= $ConfMxContent;
		}
		if (isset($Pservices['type'])) {
			$ii=0;
			$returnError = false;
			foreach ($Pservices['type'] as $key=>$type) {
				if (!empty($Pservices['record'][$key]) && !empty($Pservices['destination'][$key])) {
					if ($Pservices['settoselect'][$key] == 'yes') {$settoselect=1;} else {$settoselect=0;}
					$ConfFileContent .= "SERVICER".$ii."==".$type.":".$Pservices['record'][$key].":".$Pservices['destination'][$key].":".$settoselect."\n";
					$ii++;
				} elseif (empty($Pservices['record'][$key]) && empty($Pservices['destination'][$key])) {
					continue;
				} else {
					$returnError = true;
				}
			}
			if ($returnError) {
				$return['errors'][] = 'Missing values in the Provider Additional Records';
			}
		}
		//
		if (empty($return['errors'])) {
			if (file_put_contents($Pconffile,$ConfFileContent)) {
				$return['status'] = true;
			} else {
				$return['errors'][] = 'Cannot save the provider configuration';
			}
		}
	}
	return $return;
}

function RemoveMailProviderConf($CpToken,$ConfFile) {
	if ($CpToken == $_ENV['cp_security_token']) {
		if (validateConfFileName($ConfFile)) {
			if (file_exists('/usr/local/cpanel/base/3rdparty/RemoteMxWizard/mail_providers/'.$ConfFile)) {
				if (unlink('/usr/local/cpanel/base/3rdparty/RemoteMxWizard/mail_providers/'.$ConfFile)) {
					return true;
				}
			}
		}
	}
	return false;
}

function ValidateProviderConf($CpTokens,$ConfigFile) {
	if ($CpTokens == $_ENV['cp_security_token']) {
		$ProviderConfig = GetMailProviderConf($ConfigFile);
		if (empty($ProviderConfig['NAME'])) {
			$return['errors'][] = 'The provider name cannot be empty.';
		}
		if (empty($ProviderConfig['DESCRIPTION'])) {
			$return['errors'][] = 'The provider description cannot be empty.';
		}
		if (isset($ProviderConfig['MXs']) && is_array($ProviderConfig['MXs'])) {
			foreach ($ProviderConfig['MXs'] as $mx=>$pri) {
				if (!checkdnsrr($mx, 'ANY')) {
					$return['errors'][] = 'No public DNS records found for the domain: '.$mx;			
				}
				if (!checkIfNumber($pri)) {
					$return['errors'][] = $mx.' priority must be a number.';			
				}
			}
		} else {
			$return['errors'][] = 'The provider MXs cannot be empty.';			
		}
		if (!empty($ProviderConfig['BACKUPMX'])) {
			if (!checkIfNumber($ProviderConfig['BACKUPMX'])) {
				$return['errors'][] = 'The MX Backup priority must be a number.';
			} elseif ( isset($ProviderConfig['MXs']) && ( (int)max($ProviderConfig['MXs']) > (int)$ProviderConfig['BACKUPMX'] ) ) {
				$return['errors'][] = 'The MX Backup should have the highest priority.';
			}
		}
		if (isset($ProviderConfig['SERVICERS']) && is_array($ProviderConfig['SERVICERS'])) {
			foreach ($ProviderConfig['SERVICERS'] as $service) {
				if ($service[1] && $service[2] && $service[0] != 'TXT') {
					$services[$service[2]][$service[0]] = $service[0];
				}
			}
			foreach ($services as $serviceDomain=>$typeArr) {
				foreach ($typeArr as $type) {
					if ( ($type == 'CNAME') && (!checkdnsrr($serviceDomain, 'A') &&  !checkdnsrr($serviceDomain, 'CNAME')) ) {
						$return['errors'][] = 'No CNAME or A record found for the service domain: '.$serviceDomain;			
					} elseif ($type == 'A' && !ifValidIpAddress($serviceDomain) ) {
						$return['errors'][] = 'Invalid ip address '.$serviceDomain;
					}
				}
			}
		}
	}
	$return['status'] = (isset($return['errors'])) ? false : true;
	return $return;
}

function checkIfNumber($string) {
	$number = trim($string);
	if ( (int)($number) || ctype_digit($number) || is_numeric($number) ) {
		return true;
	} else {
		return false;
	}
}

function addNewMailProvider($CpToken) {
	$return['newfile'] = false;
	if ($CpToken == $_ENV['cp_security_token']) {
		$ConfFileName = trim($_POST['addnewprovider']);
		if (preg_match('/^[a-z0-9 ]+$/i', $ConfFileName)) {
			$filename = strtolower(preg_replace('!\s+!', '_', $ConfFileName));
			$Pconffile = '/usr/local/cpanel/base/3rdparty/RemoteMxWizard/mail_providers/'.$filename.'.conf';
			if (!file_exists($Pconffile)) {
				$ConfFileContent = "PNAME==\nDESCRIPTION==\nBACKUPMX==\nSPFR==\nSTATUS==0\n";
				if (file_put_contents($Pconffile,$ConfFileContent)) {
					$return['newfile'] = $filename.'.conf';
				} else {
					$return['error'] = 'Error creating the new provider';
				}
			} else {
				$return['error'] = 'This provider name is already exist';
			}
		} else {
			$return['error'] = 'You can use only alphanumeric characters for the new provider';
		}	
	} else {
		$return['error'] = 'Invalid cPanel security token';
	}
	return $return;
}

function validateConfFileName($confFile) {
	if (preg_match('/^[a-z0-9_.]+$/i', $confFile)) {
		preg_match('/\.[^\.]+[conf]$/i', $confFile, $ext);
		if ($ext[0] == '.conf') {
			if (file_exists('/usr/local/cpanel/base/3rdparty/RemoteMxWizard/mail_providers/'.$confFile)) {
				return true;
			}
		}
	}
	return false;
}

function fileToProviderName($file) {
	return ucwords(str_replace('_', ' ', rtrim($file, '.conf')));
}

function ifValidIpAddress($ip) {
	if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_RES_RANGE)) {
		return true;
	} else {
		return preg_match("/([0-9\.]+)\.([0-9]+)(\/|\-)([0-9]+)$/", $ip);
	}
}

?>