#!/bin/bash
########################################
# Remote Mx Wizard Installer v1.0 
# Generator : GK~root team
#
# If you are unable to run the installer then please 
# make sure that the file permissions are set correctly. 
# This can be done by typing the following:
# 
# chmod 0755 ds-installer.sh
#
########################################

ACTION=$1
Green='\e[1;32m'
Red='\e[0;31m'
NOCOLOR='\e[0m'

process_progress() {
	[ -z $1 ] && exit 0
	PROGRESS=(".      " " ..    " "  ...  " "    .. " "      ." "    .. " "  ...  " " ..    ")
	COUNTER=0
	echo -n "$2 "
	while `ps -p $1 > /dev/null`; do
		[ $COUNTER -eq 8 ] && COUNTER=0
		echo -n "${PROGRESS[$COUNTER]}"
		echo -n " Running "
		sleep 0.5
		printf "\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b"
		COUNTER=$(( $COUNTER + 1 ))
	done
	echo -e "...... ${Green}Complete${NOCOLOR}"
}

uninstallgaw () {
	echo "Removing Google Apps Wizard, Please wait..."
	/usr/local/cpanel/bin/unregister_appconfig /usr/local/cpanel/whostmgr/docroot/cgi/gaw/gaw.conf  >/dev/null 2>&1
	if [ ! -f "/usr/local/cpanel/whostmgr/docroot/gaw/version.txt" ]; then
		rm -rf /usr/local/cpanel/base/3rdparty/GoogleAppsWizard >/dev/null 2>&1
		rm -rf /usr/local/cpanel/whostmgr/docroot/gaw >/dev/null 2>&1
		rm -f /usr/local/cpanel/whostmgr/docroot/cgi/addon_gaw.cgi >/dev/null 2>&1
		rm -f /usr/local/cpanel/whostmgr/docroot/themes/x/icons/googleappswizard.gif >/dev/null 2>&1			
	fi
	
	if [ ! -f "/usr/local/cpanel/whostmgr/docroot/cgi/gaw/version.txt" ]; then
		if [ -f /usr/local/cpanel/whostmgr/docroot/cgi/gaw/gaw.conf ]; then
			/usr/local/cpanel/bin/unregister_appconfig /usr/local/cpanel/whostmgr/docroot/cgi/gaw/gaw.conf  >/dev/null 2>&1
		fi
		rm -rf /usr/local/cpanel/base/3rdparty/GoogleAppsWizard >/dev/null 2>&1
		rm -rf /usr/local/cpanel/whostmgr/docroot/cgi/gaw >/dev/null 2>&1
		if [ -f /usr/local/cpanel/whostmgr/docroot/cgi/addon_gaw.cgi ]; then
			rm -f /usr/local/cpanel/whostmgr/docroot/cgi/addon_gaw.cgi >/dev/null 2>&1
		fi
		rm -f /usr/local/cpanel/whostmgr/docroot/addon_plugins/gaw.png  >/dev/null 2>&1
	fi

	if [ -f /usr/local/cpanel/base/frontend/paper_lantern/gaw/index.php ]; then
		rm -rf /usr/local/cpanel/base/frontend/paper_lantern/gaw >/dev/null 2>&1
		if [ -f /usr/local/cpanel/base/frontend/paper_lantern/gaw/index.php ]; then
			echo "${Red}Error:${NOCOLOR} Remove the paper_lantern Google Apps Wizard theme file is not completed."
		fi	
	fi

	if [ -f /usr/local/cpanel/base/frontend/jupiter/gaw/index.php ]; then
		rm -rf /usr/local/cpanel/base/frontend/jupiter/gaw >/dev/null 2>&1
		if [ -f /usr/local/cpanel/base/frontend/jupiter/gaw/index.php ]; then
			echo "${Red}Error:${NOCOLOR} Remove the jupiter Google Apps Wizard theme file is not completed."
		fi	
	fi

	echo -e "Removing Google Apps Wizard files...... ${Green}Complete${NOCOLOR}"
	
	/usr/local/cpanel/bin/unregister_cpanelplugin /usr/local/cpanel/bin/googleappswizard.cpanelplugin > /dev/null &
	process_progress $! "Unregistering Google Apps Wizard cPanel feature"

	rm -f /usr/local/cpanel/bin/googleappswizard.cpanelplugin >/dev/null 2>&1
	
	echo -e "Removing Google Apps Wizard...... ${Green}Complete${NOCOLOR}"
}

install () {
	if [ -f "/usr/local/cpanel/base/3rdparty/GoogleAppsWizard/index.php" ] || [ -f "/usr/local/cpanel/base/3rdparty/GoogleAppsWizard/index.live.php" ] ; then
		echo "Google Apps Wizard is installed on this server."
		echo "Please use the command: sh rmw-installer.sh -update"
		exit 1
	else
		if [ -e "/usr/local/cpanel/bin/register_appconfig" ]; then		
			/bin/cp -r whm/remotemxwizard/  /usr/local/cpanel/whostmgr/docroot/cgi/  >/dev/null 2>&1
			/usr/local/cpanel/bin/register_appconfig /usr/local/cpanel/whostmgr/docroot/cgi/remotemxwizard/remotemxwizard.conf  >/dev/null 2>&1
			/bin/mkdir /usr/local/cpanel/whostmgr/docroot/addon_plugins  >/dev/null 2>&1
			/bin/cp -f whm/remotemxwizard.png /usr/local/cpanel/whostmgr/docroot/addon_plugins/  >/dev/null 2>&1

			/bin/cp -r cpanel/RemoteMxWizard/ /usr/local/cpanel/base/3rdparty/

			if [ -d /usr/local/cpanel/base/frontend/jupiter/ ]; then
				/bin/cp -r cpanel/RemoteMxWizard/ /usr/local/cpanel/base/frontend/jupiter/
				/usr/local/cpanel/scripts/install_plugin plugin/remotemxwizard.tar.bz2 --theme=jupiter > /dev/null &
				process_progress $! "Registering Remote Mx Wizard cPanel feature in jupiter theme"
			fi

			if [ -d /usr/local/cpanel/base/frontend/paper_lantern/ ]; then
				/usr/local/cpanel/scripts/install_plugin plugin/remotemxwizard.tar.bz2 --theme=paper_lantern > /dev/null &
				process_progress $! "Registering Remote Mx Wizard cPanel feature in paper_lantern theme"
			fi

			if [ -f /usr/local/cpanel/whostmgr/docroot/cgi/remotemxwizard/index.php ]; then
				if [ -f /usr/local/cpanel/base/3rdparty/RemoteMxWizard/index.live.php ]; then
					echo ""
					echo -e "Remote Mx Wizard installation... ${Green}Complete successfully${NOCOLOR}"
					echo ""
				fi
			fi
		else
			echo -e "${Red}Error:${NOCOLOR} whostmgr AppConfig is not installed you need to update your cPanel to v11.38.1!!!"
			exit 1
		fi
	fi
}

uninstall () {
	if [ -e "/usr/local/cpanel/bin/register_appconfig" ]; then
		/usr/local/cpanel/bin/unregister_appconfig /usr/local/cpanel/whostmgr/docroot/cgi/remotemxwizard/remotemxwizard.conf  >/dev/null 2>&1
		/bin/rm -f /usr/local/cpanel/whostmgr/docroot/addon_plugins/remotemxwizard.png  >/dev/null 2>&1
		/bin/rm -Rf /usr/local/cpanel/whostmgr/docroot/cgi/remotemxwizard >/dev/null 2>&1
		/bin/rm -Rf /usr/local/cpanel/base/3rdparty/RemoteMxWizard >/dev/null 2>&1
		/bin/rm -Rf /usr/local/cpanel/base/frontend/jupiter/RemoteMxWizard >/dev/null 2>&1
		/bin/rm -f /usr/local/cpanel/base/frontend/paper_lantern/dynamicui/dynamicui_remotemxwizard.conf
		/bin/rm -f /usr/local/cpanel/base/frontend/jupiter/dynamicui/dynamicui_remotemxwizard.conf
		/usr/local/cpanel/bin/unregister_cpanelplugin plugin/remotemxwizard.cpanelplugin > /dev/null &
		process_progress $! "Unregistering Remote Mx Wizard cPanel feature"
		echo ""
		echo -e "Remote Mx Wizard uninstallation... ${Green}Complete successfully${NOCOLOR}"
		echo ""
	fi
}

update () {
	if [ -f "/usr/local/cpanel/base/3rdparty/GoogleAppsWizard/index.php" ] || [ -f "/usr/local/cpanel/base/3rdparty/GoogleAppsWizard/index.live.php" ] ; then
		uninstallgaw
		install	
	else
		/bin/cp -rf whm/remotemxwizard/  /usr/local/cpanel/whostmgr/docroot/cgi/  >/dev/null 2>&1
		/bin/cp -f whm/remotemxwizard.png /usr/local/cpanel/whostmgr/docroot/addon_plugins/  >/dev/null 2>&1
		/bin/cp -rf cpanel/RemoteMxWizard/ /usr/local/cpanel/base/3rdparty/
		if [ -f /usr/local/cpanel/whostmgr/docroot/cgi/remotemxwizard/index.php ]; then
			if [ -f /usr/local/cpanel/base/3rdparty/RemoteMxWizard/index.live.php ]; then
				echo ""
				echo -e "Remote Mx Wizard update... ${Green}Complete successfully${NOCOLOR}"
				echo ""
			fi
		fi
	fi
}

versioncheck () {
	if [ -f "/usr/local/cpanel/whostmgr/docroot/remotemxwizard/version.txt" ]; then
		LOCALVERSION=(`cat /usr/local/cpanel/whostmgr/docroot/remotemxwizard/version.txt`)
		rmwinstalled="yes"
	elif [ -f "/usr/local/cpanel/whostmgr/docroot/cgi/remotemxwizard/version.txt" ]; then
		LOCALVERSION=(`cat /usr/local/cpanel/whostmgr/docroot/cgi/remotemxwizard/version.txt`)
		rmwinstalled="yes"
	else
		rmwinstalled="no"
	fi
	if [[ $dsinstalled == "yes" ]]; then
		echo "#######################################"
		echo "#  Remote Mx Wizard v${LOCALVERSION}            #"
		echo "#  Generator : GK~root team           #"
		echo "#  URL : www.gk-root.com              #"
		echo "#######################################"
	else
		echo -e "Remote Mx Wizard is not installed on this server ....... ${Red}Failed${NOCOLOR}"
		usage
	fi
}

usage () {
cat << EOF
#######################################
#  Remote Mx Wizard Installer v1.0    #
#  Generator : GK~root team           #
#  URL : www.gk-root.com              #
#######################################

Usage: sh rmw-installer.sh [ACTION]

Actions:
  -install       Remote Mx Wizard installation
  -update        Update from Google Apps Wizard
  -uninstall     Remove Remote Mx Wizard
  -ver           Checking the version installed on the server

** Simple installation
root[~]# sh rmw-installer.sh -install

** Update to the latest version or from Google Apps Wizard
root[~]# sh rmw-installer.sh -update

EOF
}

[ -z $ACTION ] && usage && exit 1

case $ACTION in
	"-ver")             versioncheck;;
	"-install")         install;;
	"-uninstall")       uninstall;;
	"-update")          update;;
	*)                  usage;;
esac

exit 0
