<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'he', branch 'MOODLE_28_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'הגישה נדחתה';
$string['accounts'] = 'חשבונות';
$string['addcategory'] = 'הוספת קטגוריה';
$string['additionalhtml'] = 'HTML נוסף';
$string['additionalhtmlfooter'] = 'לפני סגירת תג ה- BODY';
$string['additionalhtmlfooter_desc'] = 'התוכן כאן התווסף לכל עמוד ממש לפני שתג ה-BODY נסגר.';
$string['additionalhtmlhead'] = 'בתוך תג HEAD';
$string['additionalhtmlhead_desc'] = 'התוכן כאן התווסף בתחתית תג ה-HEAD עבור על עמוד.';
$string['additionalhtml_heading'] = 'קוד HTML נוסף התווסף עבור כל עמוד.';
$string['additionalhtmltopofbody'] = 'כאשר תג ה-BODY פתוח';
$string['additionalhtmltopofbody_desc'] = 'התוכן כאן התווסף לכל עמוד מייד לאחר פתיחת תג ה-BODY';
$string['admincategory'] = 'קטגוריה: {$a}';
$string['adminseesall'] = 'מנהלים רואים הכל';
$string['adminseesallevents'] = 'מנהלים רואים את כל הארועים';
$string['adminseesownevents'] = 'למנהלים אותם זכויות צפייה זהות למשתמשים אחרים.';
$string['advancedfeatures'] = 'תכונות מתקדמות';
$string['allcountrycodes'] = 'הקודים של כל הארצות';
$string['allowbeforeblock'] = 'איפשור רשימה יעובד בתחילה';
$string['allowbeforeblockdesc'] = 'כבררת־מחדל, נעשה שימוש ראשוני בכתובות שרתים ברשימות ה-IP החסומים תחילה, כאשר הגדרה זו פעילה, ערכים ברשימות ה-IP אשר מאושרות יעובדו לפני רשימות ה-IP החסומות.';
$string['allowblockstodock'] = 'אפשר למשבצות להשתמש בסרגל צדדי';
$string['allowcategorythemes'] = 'הרשה ערכת נושאי קטגוריות';
$string['allowcoursethemes'] = 'הרשה ערכת נושאי קורסים';
$string['allowediplist'] = 'רשימה של IP מותרים';
$string['allowemailaddresses'] = 'הרשה תחומי דוא"ל';
$string['allowframembedding'] = 'אפשר שיבוץ מסגרת';
$string['allowframembedding_help'] = 'אפשר שיבוץ אתר זה במסגרות על אתרים חיצוניים. איפשור פעולה זו לא מומלצת מסיבות אבטחה.';
$string['allowguestmymoodle'] = 'התרת גישה לעמוד הבית שלי לאורחים';
$string['allowobjectembed'] = 'הרשה תגי EMBED ו-OBJECT (אלמנטי HTML)';
$string['allowthemechangeonurl'] = 'הרשה שינויי ערכות נושא ב URL';
$string['allowuserblockhiding'] = 'הרשה למשתמשים להסתיר משבצות';
$string['allowuserswitchrolestheycantassign'] = 'הרשה למשתמשים ללא יכולת מנה התפקידים להחליף תפקידים';
$string['allowuserthemes'] = 'הרשה למשתמשים בחירת ערכת נושאים';
$string['alternativefullnameformat'] = 'תסדיר שם מלא חלופי';
$string['antivirus'] = 'אנטי וירוס';
$string['appearance'] = 'עיצוב הממשק';
$string['aspellpath'] = 'נתיב ל-aspell';
$string['authentication'] = 'אימות';
$string['authpreventaccountcreation'] = 'מנע יצירת חשבון כאשר האימות מתבצע';
$string['authsettings'] = 'ניהול אימות';
$string['autolang'] = 'זיהוי אוטומטי של שפה';
$string['autologinguests'] = 'כניסה אוטומטית לאורחים';
$string['availablelicenses'] = 'רשיונות זמינים';
$string['availableto'] = 'זמין ל-';
$string['backgroundcolour'] = 'צבע הרקע';
$string['backups'] = 'גיבויים';
$string['backup_shortname'] = 'שם הקורס יכתב בשם הקובץ של הגיבוי';
$string['backup_shortnamehelp'] = 'השתמש בשם הקורס כחלק משם קובץ הגיבוי במקום מספר ה-id של הקורס.';
$string['badwordsconfig'] = 'הכנס את המילים השגויות כאשר הן מופרדות בפסיק.';
$string['badwordsdefault'] = 'אם הרשימה המותאמת אישית ריקה, המערכת תשתמש ברשימת בררת־מחדל מחבילת השפות.';
$string['badwordslist'] = 'התאמה אישית לרשימת מילים שגויות';
$string['blockediplist'] = 'רשימה של IP חסומים';
$string['blockeditingmenu'] = 'תפריטי עריכת בלוק';
$string['blockinstances'] = 'צפיות';
$string['blockmultiple'] = 'מרובים';
$string['blockprotect'] = 'הגנה מפני מחיקה';
$string['blocksettings'] = 'ניהול משבצות';
$string['blockunprotect'] = 'לא מוגן';
$string['bloglevel'] = 'חזות הבלוג';
$string['bookmarkadded'] = 'סימניה נוספה';
$string['bookmarkalreadyexists'] = 'כבר סימנת בעבר את דף זה';
$string['bookmarkdeleted'] = 'סימניה נמחקה';
$string['bookmarkthispage'] = 'סמן את עמוד זה';
$string['cacheapplication'] = 'מטמון אפליקציה';
$string['cachejs'] = 'מטמון Javascript';
$string['cacherequest'] = 'בקשות מטמון';
$string['cachesession'] = 'מטמון נתוניי־חיבור־משתמש (session)';
$string['cachesettings'] = 'הגדרות מטמון';
$string['caching'] = 'מטמון';
$string['calendarexportsalt'] = 'יצוא לוח שנה';
$string['calendarsettings'] = 'לוח שנה';
$string['calendartype'] = 'סוג לוח שנה';
$string['calendar_weekend'] = 'סוף השבוע';
$string['cannotdeletemodfilter'] = 'לא ניתן להסיר את \'{$a->filter}\' ,  מכיוון שהוא חלק מרכיב ה-\'{$a->module}\' .';
$string['cannotuninstall'] = 'לא ניתן להסיר את התקנת {$a}.';
$string['cfgwwwrootslashwarning'] = '$ CFG->wwwroot הוגדר בצורה שגויה בקובץ config.php , התו \'/\' התווסף בסוף. אנא הסר אותו אחרת אתה עלול להתקל בשגיאות מוזרות כגון <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061זו </a>.';
$string['cfgwwwrootwarning'] = '$ CFG->wwwroot הוגדר בצורה שגויה בקובץ config.php , ואינו מתאים ל-URL שאתה משתמש לגשת עבור עמוד זה. אנא הסר אותו אחרת אתה עלול להתקל בשגיאות מוזרות כגון
 <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>זו MDL-11061 </a>';
$string['change'] = 'שינוי';
$string['checkboxno'] = 'לא';
$string['checkboxyes'] = 'כן';
$string['choosefiletoedit'] = 'בחירת קובץ לעריכה';
$string['clamfailureonupload'] = 'בכישלון של סריקת תוכנת האנטי-וירוס calm';
$string['cleanup'] = 'ניקוי מידע זמני';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'שגיאה: ערך לא תקין
"{$a->value}" עבור "{$a->option}"';
$string['cliincorrectvalueretry'] = 'ערך שגוי, נסה שנית';
$string['clistatusdisabled'] = 'מצב: אינו-זמין';
$string['clistatusenabled'] = 'מצב: מאופשר';
$string['clitypevalue'] = 'סוג הערך';
$string['clitypevaluedefault'] = 'יש להזין ערך, או להקיש על כפתור Enter לשימוש בערך בררת־המחדל ({$a})';
$string['cliunknowoption'] = 'אפשרויות לא מוכרות :
{$a}
אנא השתמש באפשרות העזרה.';
$string['cliupgradefinished'] = 'שדרוג שורת פקודה התבצע בהצלחה.';
$string['cliupgradenoneed'] = 'אין צורך בשדרוג נוסף עבור הגרסה המותקנת - {$a}. תודה בכל אופן';
$string['cliyesnoprompt'] = 'רשום y (שפרושו כן) או n (שפרושו לא)';
$string['commentsperpage'] = 'מספר ההערות המוצגות בדף';
$string['commonfiltersettings'] = 'הגדרות מסנן שכיחות';
$string['commonsettings'] = 'הגדרות שכיחות';
$string['componentinstalled'] = 'רכיבים הותקנו';
$string['computedfromlogs'] = 'מחושב מיומני המעקב החל מ- {$a}.';
$string['condifmodeditdefaults'] = 'ערכים שתקליד כאן יגדירו את ערכי בררת־המחדל בהגדרות הפעילות בעת יצירת פעילות חדשה.';
$string['confeditorhidebuttons'] = 'יש לבחור את הכפתורים אשר יהיו מוסתרים בדף התוכן המעוצב.';
$string['configallowassign'] = 'הרשה לאנשים עם תפקידים הרשומים בצד הימני להקצות חלק מתפקידי העמודה לאנשים אחרים';
$string['configallowblockstodock'] = 'אם מאופשר ונתמך על-ידי ערכת הנושא הנבחרת, משתמשים יוכלו לבחור הזזת משבצות (בלוקים) לסרגל הצדדי.';
$string['configallowcategorythemes'] = 'כאשר תאפשר זאת, ערכת נושאים יכולה להיות מוגדרת ברמת הקטגוריה. דבר השפיע על הבנים של הקטגוריות והקורסים אלא אם כן ערכת הנושאים מוגדרת בהם במפורש. אזהרה: איפשור ערכת נושאי קטגוריה עלולה להשפיע על ביצועי האתר.';
$string['configallowcoursethemes'] = 'אם תאפשר זאת, ניתן להגדיר ערכת נושא לכל קורס. ערכת נושא ברמת קורס רומסת כל הגדרה אחרת (ערכת נושא ברמת אתר, משתמש או חיבור נוכחי)';
$string['configallowemailaddresses'] = 'אם ברצונך להגביל את כל כתובות הדוא"ל החדשות לתחומים מסויימים, אזי רשום אותם כאן מופרדים ע"י רווחים. כתובות מכל תחום אחר יידחו. למשל <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'אם מאופשר, אז אורחים יכולים לראות את עמוד הבית שלי, אחרת הם ינותבו לעמוד הראשי של האתר.';
$string['configallowobjectembed'] = 'כבררת־המחדל של אמצעי האבטחה, משתמשים רגילים לא מורשים לשבץ קבצי מולטימדיה (כמו "פלאש") יחד עם טקסטים תוך שימוש מפורש ב EMBED ו OBJECT בתגי הHTML שלהם (אף על פי ש- הדבר יכול להיעשות בצורה בטוחה ע"י שימוש במסננים של תוספי המדיה).אם ברצונך להרשות את תגים אלו סמן את אפשרות זו.';
$string['configallowoverride'] = 'הרשה לאנשים עם תפקידים הרשומים בצד הימני לעקוף חלק מתפקידי העמודה';
$string['configallowoverride2'] = 'בחר אלו תפקידים יכולים להיעקף ע"י כל תפקיד בעמודה הימנית. <br/> שים לב כי הגדרות אלו ייושמו עבור משתמשים אשר להם קיימת איפשור היכולת moodle/role:override או moodle/role:safeoverride';
$string['configallowthemechangeonurl'] = 'אם מאופשר, ערכת הנושא יכולה להשתנות ע"י הוספת ערכת נושא= {themename} לכל  Moodle URL
(eg: mymoodlesite.com/?theme=afterburner )
או
<br />&theme=themename to any internal Moodle URL (eg: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'האם אתה מרשה למשתמשים להציג/להסתיר בלוקים באתר? תכונה זו משתמשת ב-Javascript ועוגיות כדי לזכור את המצב של כל בלוק הניתן להסתרה, ומשפיע רק על האופן בו המשתמש עצמו צופה באתר.';
$string['configallowuserthemes'] = 'אם תאפשר זאת, משתמשים יוכלו לבחור לעצמם ערכת נושא. ערכות נושא המוגדרות ע"י משתמשים רומסות את ערכת הנושא המוגדרת ברמת האתר (אך לא את ערכת הנושא שהוגדרה ברמת הקורס, אם יש כזו).';
$string['configallusersaresitestudents'] = 'האם יש להתייחס לכל המשתמשים כסטודנטים עבור פעילויות בעמוד הראשי של האתר? אם התשובה היא "כן", אזי כל חשבון משתמש מאושר יורשה להשתתף כסטודנט בפעילויות אלו. אם התשובה היא "לא", אזי רק משתמשים הרשומים לקורס אחד לפחות יורשו לטול חלק בפעילויות המופיעות בעמוד הראשי. רק מנהלים ומורים שקיבלו הרשאה מיוחדת יכולים להחשב כמורים עבור פעילויות אלו בעמוד הראשי.';
$string['configauthenticationplugins'] = 'יש לבחור את אימותי ההתקנים אשר תרצה להשתמש ומיינם לפי סדר הכשלונות הצפוי. הרשמה עצמית תטופל ע"י ההתקן הנבחר בעמודת ה-\'Registration\' (הרשמה בד"כ תתבצע ע"י \'email\').';
$string['configautolang'] = 'זיהוי שפת בררת־המחדל מהגדרת הדפדפן, כאשר בררת־המחדל של המערכת היא "זיהוי שפה אוטומטי אינו זמין".';
$string['configautologinguests'] = 'האם יש לחבר משתמשים כאורחים באופן אוטומטי כאשר נכנסים לקורס המתיר גישת אורחים?';
$string['configbloglevel'] = 'הגדרה זו מרשה לך להגביל את הרמה אשר משתמשי בלוגים יכולים לצפות בה, באתר זה. שים לב כי הרמות מציינים את הדרגה הגבוהה ביותר של ההקשר של ה-VIEWER ולא את רמת הפירסום או סוג הבלוגים שפורסמו.';
$string['configcalendarcustomexport'] = 'לאפשר טווח של תאריך מותאם אישית עבור יצוא לוח-שנה';
$string['configcalendarexportsalt'] = 'טקסט אקראי משומש עבור שיפור אסימוני אימות אשר הם משמשים יצוא לוחות השנה.
אנא שים לב כי כל האסימונים הנוכחיים יבוטלו אם תשנה את הגדרה זו.';
$string['configclamactlikevirus'] = 'התייחס לכל הקבצים כוירוסים';
$string['configclamdonothing'] = 'התייחס לכל הקבצים כתקינים';
$string['configclamfailureonupload'] = 'אם הגדרת את clam לסריקת קבצים מועלים לאתר, אך התוכנה אינה מוגדרת כראוי או היא אינה מצליחה לפעול מכל סיבה שהיא (לרוב בגלל הגדרת נתיב לא תקין לקובץ ההרצה של התוכנה), כיצד יש להתנהג? אם תבחר להתייחס לכל הקבצים כוירוסים, הקבצים יועברו לאיזור ההסגר או יימחקו. אם תבחר להתייחס לכל הקבצים כתקינים, הקבצים יועברו לספריית היעד כרגיל. בכל מקרה, המנהלים יקבלו הודעה שהפעלת clam נכשלה. מומלץ לנקוט משנה זהירות אם תבחר להתייחס לכל הקבצים כוירוסים.';
$string['configcookiehttponly'] = 'איפשור תכונה חדשה של  PHP 5.2.0  - דפדפנים שולחים עוגיה (cockie)  עם בקשות http אמיתיות בלבד, לא ניתן לגשת לעוגיות ע"י תסריטי שפות. הדבר אינו נתמך בכל הדפדפנים ועלול שלא להיות תואם עם הקוד הנוכחי בנוסף מונה סוגים מסויימים של התקפות XSS.';
$string['configcookiesecure'] = 'אם השרת מרשה חיבורי https בלבד מומלץ לאפשר שליחת עוגיות מאובטחות. אם מאופשרת, אנא וודא כי השרת לא מאפשר http:// או הגדר משתנה לניתוב מחדש עבור כתובות בעלי https:// . כאשר כתובות <em>wwwroot</em> אינן מתחילות ב https:// הגדרה זו תכובה באופן אוטומטי.';
$string['configcountry'] = 'אם תוגדר ארץ בשדה זה, אזי ארץ זו תבחר כבררת־המחדל עבור חשבונות משתמש חדשים. אם ברצונך לאלץ משתמשים לבחור ארץ, יש להשאיר שדה זה ללא ערך.';
$string['configcourseoverviewfilesext'] = 'רשימה מופרדת בפסיקים של סיומות סוגי הקבצים שניתן לצרף לתקציר קורס';
$string['configcourseoverviewfileslimit'] = 'מספר הקבצים המירבי שניתן לצרף לתקציר קורס (אשר יוצגו מחוץ לקורס באופן ציבורי ויהיו זמינים לאורחים שטרם נרשמו לקורס)';
$string['configcourserequestnotify'] = 'הקש את שם משתמש של המשתמש אשר לו תשלח הודעה כאשר נוצרה בקשת קורס חדשה.';
$string['configcourserequestnotify2'] = 'משתמשים אשר יקבלו הודעה כאשר קורס נדרש. רק המשתמשים אשר יאשרו את בקשות הקורס יופיעו ברשימה זו.';
$string['configcoursesperpage'] = 'הכנס את מספר הקורסים אשר תרצה להציג בכל עמוד בהרשמת הקורסים.';
$string['configcourseswithsummarieslimit'] = 'המספר המירבי של קורסים להצגה ברשימת הקורסים כולל תיאורי הקורס זאת לפני החזרה למצב רשימה פשוטה';
$string['configcronclionly'] = 'כאשר הגדרה זו מופעלת, תסריט ה-cron יוכל לפעול דרך שורת הפקודה במקום דרך הרשת. אפשרות זו למעשה רומסת את סיסמת ה cron.';
$string['configcronremotepassword'] = 'המשמעות היא שקוד תסריט (script) ה cron.php לא יוכל לפעול מהדפדפן מבלי לספק סיסמה ע"י שימוש במבנה ה-URL שלהלן: :<pre> http://site.example.com/admin.cron.php?password=opensesame </pre> אם תיבה זו נשארת ריקה, אין דרישה לסיסמה.';
$string['configcurlcache'] = 'Time-to-live for cURL cache,
בשניות';
$string['configdbsessions'] = 'הגדרה זו מאפשרת אחסון של מידע אודות התחברויות (session) המשתמשים הנוכחיות במסד הנתונים של המערכת. מנגנון זה שימושי במיוחד עבור מערכות מוודל גדולות/עמוסות או מערכות הפועלות על אשכול שרתים. ביטול השימוש במנגנון זה, יפעיל את מנגנון השמירה של נתוניי התחברות המשתמשים על קבצים בתיקיית ה moodledata של השרת.

(למעשה, עדיף שלא להפעיל מנגנון זה וגם לא את זה של הקבצים, אלא להשתמש במנגנון memcached, כאשר פועלים בסביבה מרובה שרתים/עמוסת משתמשים. מידע נוסף, בתעוד המקוון של מערכת מוודל. באתר מוודל העולמי)

יש לשים לב שכל שינוי של ערך זה יגרום לניתוק כל המשתמשים המחוברים כעת (כולל אותך).';
$string['configdebug'] = 'אם תאפשר הגדרה זו, אזי ערך המשתנה error_reporting של PHP יוגדל כך שיוצגו יותר הודעות שגיאה. הגדרה זו שימושית בעיקר למפתחים.';
$string['configdebugdisplay'] = 'באם הגדרה זאת מופעלת, דיווח השגיאה יתווסף לדף ה- HTML. תכונה זו שימושית, אולם משבשת, ברב המקרים, את כותרות ה-XHTML, JS, עוגיות האינטרנט ו-HTTP.

כאשר איננה מופעלת היא תנתב את הפלט ליומני מעקב השרת שלך. משתנה error_log ב-PHP מורה לאיזה קובץ יומן תנותב השגיאה.';
$string['configdebugpageinfo'] = 'אפשרו מנגנון זה לתצוגת מידע הנוגע לביצועי המערכת עבור העמוד בו אתם צופים, אשר יוצג בחלק התחתון של ההעמוד';
$string['configdebugsmtp'] = 'שימוש בניפוי מידע מורחב במהלך שליחת הודעות דוא"ל לשרת ה-SMTP.';
$string['configdefaulthomepage'] = 'קביעת הדף הראשי עבור המשתמשים המחוברים למערכת.';
$string['configdefaultrequestcategory'] = 'הקורסים שנבחרו ע"י משתמשים יושמו אוטומטית בקטגוריה זו.';
$string['configdefaultrequestedcategory'] = 'קטגורית בררת־המחדל להכנסת קורסים אשר נתבקשו, אם הם מאושרים.';
$string['configdefaultuserroleid'] = 'לכל המשתמשים המחוברים תינתנה יכולות התפקיד אשר יצויין כאן, ברמת האתר הזו, בנוסף לכל תפקיד אחר אשר ינתן להם. בררת־המחדל היא תפקיד האורח. יש לשים לב שהגדרה זו לא תעמוד בניגוד לתפקידים אחרים שיש, היא רק מבטיחה שכל המשתמשים יעשו משהו שימושי ברמת האתר (כגון קריאת שיחות פורום, משאבים וכדומה).';
$string['configdeleteincompleteusers'] = 'לאחר תקופה זו,חשבונות התקנה ישנות ולא שלמות ימחקו.';
$string['configdeleteunconfirmed'] = 'אם אתה משתמש באימות מבוסס דוא"ל, זהו משך הזמן שבו המשתמש יוכל לאשר את החשבון החדש. אחרי פרק זמן זה, חשבונות ישנים שלא אומתו ימחקו מהמערכת.';
$string['configdenyemailaddresses'] = 'על מנת לחסום כתובות דוא"ל מתחומים מסויימים יש לרשום בשדה זה את רשימת התחומים באותו אופן. כל תחום אחר יאופשר. למשל <strong>hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = 'מנע מהשתמשים אפשרות לשנות את תמונות פרופיל המשתמש.';
$string['configdisplayloginfailures'] = 'הגדרה זו תציג למשתמשים נבחרים הודעות אודות נסיונות התחברות כושלים.';
$string['configdoclang'] = 'שפה זו תשמש לקישורים לעמודי תיעוד.';
$string['configdocroot'] = 'מגדיר את הנתיב ל MOODLE DOCS. אתה יכול את תכונה זו אם תרצה ליצור תיעוד מקוונן ומותאם אישית. בכל אופן, אם תעשה כך דאג כי הנתיב בקבצי התיעוד שלך הוא באותה מבנה כמו http://docs.moodle.org .';
$string['configdoctonewwindow'] = 'באפשור הגדרה זו, קישורים ל Moodle Docs יוצגו בחלון חדש.';
$string['configeditordictionary'] = 'ערך זה יופעל אם ל-aspell אין סיפריית משתמשים בשפה שלהם.';
$string['configeditorfontlist'] = 'יש לבחור את הגופנים אשר יופיעו בתפריט נפתח של העורך.';
$string['configemailchangeconfirmation'] = 'נדרש אישור ע"י הדוא"ל כאשר המשתמשים משנים את כתובת הדוא"ל שלהם בפרופיל האישי.';
$string['configenableblogs'] = 'אפשרות זו מאפשרת לכל משתמשי המערכת לנהל בלוג משלהם.';
$string['configenablecalendarexport'] = 'אפשר יצוא או הרשמה כמנוי ללוחות השנה.';
$string['configenablecomments'] = 'אפשר הערות';
$string['configenablecourserequests'] = 'הגדרה זו תאפשר לכל משתמש לדרוש יצירת קורס.';
$string['configenabledevicedetection'] = 'איפשור איתור מכשירים סלולרים, מכשירים חכמים, מחשבי לוח או התקני בררת־המחדל (מחשבי נייחים, מחשבים ניידים וכד\') עבור יישומים של ערכות נושא ומאפיינים אחרים';
$string['configenablemobilewebservice'] = 'מתן גישה ושירותים מקוונים למכשירים ניידים עבור הישומון הרשמי של Moodle Mobile, או יישום אחר המבקש זאת. מידע נוסף זמין כאן: {$a}';
$string['configenablerssfeeds'] = 'הגדרה זו תאפשר הזנות RSS ברחבי האתר. על מנת לאפשר הזנות RSS בכל מקום בו הדבר נתמך, עליך לאפשר הזנות RSS גם עבור כל מודול - גש להגדרות המודולים המופיעות באיזור הגדרות ניהול.';
$string['configenablerssfeedsdisabled'] = 'לא זמין בגלל שהזנות RSS בוטלו בכל האתר. לאפשור הזנות RSS, גש להגדרות משתנים המופיעות באזור הגדרות ניהול.';
$string['configenablerssfeedsdisabled2'] = 'הזנות RSS אינם מאופשרים ברמת השרת. הינך צריך לאפשר אותם בצד השרת.';
$string['configenablesafebrowserintegration'] = 'הדבר מוסיף את הבחירה \'נדרש Safe Exam Browser\' לשדה \'אבטחת הדפדפן\' בטופס הגדרות הבוחן. ראה מידע נוסף: http://www.safeexambrowser.org';
$string['configenablestats'] = 'אם תבחר כאן "כן", cronjob של Moodle יכין את יומני המעקב ויאסוף את ההסטטיסטיקות. בהיחשב בעומס הרשת באתר שלך, הגדרה זו יכולה לקחת זמן-מה. בנוסף אם תאפשר הגדרה זו תוכל לראות סטטיסטיקות מעניינות בשילוב עם גרפים על כל אחד מהקורסים או של האתר בככלותו.';
$string['configenabletrusttext'] = 'כבררת־מחדל, מערכת Moodle תבצע ניקוי יסודי של תוכן המוזן במערת על ידי משתמשים בכדי להסיר אפשרות לשגיאות מערכת ושיבוש ממשק המשתמש כתוצאה של הפעלת תסריט (script) שגוי או זדוני  אשר יכול להוות פריצת אבטחה.

מנגנון "תוכן בטוח" הינו אמצעי לאפשר למשתמשים מסוימים, בהם אתם בוטחים, את היכולת לכלול תכונות מתקדמות (שיבוץ מולטימדיה ושרותי אינטרנט מגוונים) אלו בתכנים המוזנים בקורסים שלהם ללא הפרעה.

לשם כך עליכם (1) לאפשר, קודם כל, את ההגדרה הזו ולאחר מכן (2) להעניק/לאפשר הרשאת "תוכן הבטוח" (moodle/site:trustcontent) להגדרת התפקיד הרצוי.

תוכן הנוצרים או מועלים על ידי משתמשים אלו יסומנו כ"בטוחים" ולא ינוקו לפני הצגתם.

<a href="http://docs.moodle.org/25/en/Capabilities/moodle/site:trustcontent">מידע נוסף</a>';
$string['configenablewebservices'] = 'Web services  מאפשר למערכות אחרות להתחבר ל-moodle ולבצע פעולות. בשל סיבות אבטחה יש לכבות אפשרות זו אלא אם כן אתה באמת משתמש בזה.';
$string['configerrorlevel'] = 'יש לבחור את מספר הודעות האזהרה של PHP שברצונך לראות.  בררת־המחדל הרגילה היא הערך המומלץ ברוב המקרים.';
$string['configexportlookahead'] = 'כמה ימים קדימה ביצוא';
$string['configexportlookback'] = 'כמה ימים אחורה ביצוא';
$string['configextendedusernamechars'] = 'אפשר תכונה זו בכדי לאפשר לסטודנטים להשתמש בכל תו שהוא בשם המשתמש שלהם (שים לב שההגדרה אינה משפיעה על השמות האמיתיים). ערך בררת־המחדל הוא להגביל שימוש בתוים אלפאנומריים בלבד בשמות משתמש';
$string['configextramemorylimit'] = 'מנגנונים מסויימים כגון: חיפוש, גיבוי/שיחזור או corn דורשים זיכרון נוסף. יש להגדיר ערכים גבוהים עבור אתרים גדולים.';
$string['configfilterall'] = 'סנן את כל המחרוזות, כולל כותרות, סרגל ניווט וכו\'. תכונה זו שימושית כאשר משתמשים במסנן שפות מרובות, אחרת הגדרה זו תיצור עומס נוסף באתר ללא רווח כלשהו.';
$string['configfiltermatchoneperpage'] = 'מסנני קישור אוטומטיים ייצרו אך ורק קישור אחד להופעת הטקסט הראשון שימצא תואם על העמוד השלם. צפיות האחרים לא יסומנו';
$string['configfiltermatchonepertext'] = 'מסנני קישור אוטומטיים ייצרו אך ורק קישור אחד להופעת הטקסט הראשון שיימצא בכל פריט של טקסט (לדוגמה: משאב, בלוק) על העמוד. מכל האחרים יתעלמו. מהגדרה זאת מתעלמים באם ההגדרה "אחד לעמוד" היא "כן".';
$string['configfilteruploadedfiles'] = 'אפשור ערך זה תגרום ל-Moodle לעבד את כל קבצי הטקסט וקבצי HTML שהועלו בעזרת המסננים לפני הצגתם.';
$string['configforcelogin'] = 'בדרך כלל, העמוד הראשי של האתר ורשימת הקורסים (אך לא הקורסים עצמם) יכולים להיראות לאנשים הנכנסים לאתר מבלי שהם מחוברים לאתר. אם תרצה להכריח אנשים להתחבר לאתר לפני שהם יראו את דף הפתיחה תצטרך לאפשר הגדרה זו.';
$string['configforceloginforprofiles'] = 'הפעלת הגדרה זו תחייב אנשים להתחבר כמשתמשים אמיתיים (לא אורחים) לפני היכולת לראות את עמודי הפרופיל של המשתמש. כבררת־המחדל אפשרות זו אינה-זמינה כך שסטודנטים עתידיים יכולים לעיין על מידע המורים שבכל קורס, אך הגדרה זו מאפשרת למנועי החיפוש ברשת יהיו נגישים למידע זה.';
$string['configfrontpage'] = 'הפריטים שנבחרו מעל יוצגו בעמוד הראשי של האתר.';
$string['configfrontpagecourselimit'] = 'מספרי מירבי של קורסים';
$string['configfrontpagecourselimithelp'] = 'מספרי מירבי של קורסים שיוצגו בעמוד הראשי ברשימות קורסים.';
$string['configfrontpageloggedin'] = 'הפריטים שנבחרו מעל יוצגו בעמוד הראשי של האתר כאשר משתמש מחובר לאתר.';
$string['configfullnamedisplay'] = 'אפשרות זו מגדירה כיצד שמות יופיעו כאשר הם מוצגים בצורה מלאה.עבור מרבית האתרים המתשמשים אך ורק בשפה אחת ההגדרה היעילה ביותר היא הגדרת היסוד "שם פרטי + שם משפחה", אבל יש ביכולתך להעלים את שם השפחה או להשאיר החלטה זאת להתקנה הנוכחית של ערכת השפה מכיוון ולחלק משפות יש מוסכמות שונות.';
$string['configgetremoteaddrconf'] = 'אם האתר שלך נמצא תחת proxy הפוך, תוכל לציין בהגדרה זו אלו HTTP headers מהימנים להכיל את כתובת ה-IP מרוחקות. ה-headers יקראו בסדר מסויים כך שהשימוש יתחיל בראשון אשר יהיה זמין.';
$string['configgradebookroles'] = 'הגדרה זו מאפשרת לך לקבוע מי יופיע בגליון הציונים. המשתמשים חייבים להיות משוייכים לפחות לאחד מהתפקידים האלו בקורס בכדי שציוניהם יופיעו בפנקס.';
$string['configgradeexport'] = 'בחר אלו תסדירים של פנקסי הציונים המיוצאים יהיו שיטות עיקריות בעבור יצוא ציונים. תוספים שנבחרו יוגדרו וישתמשו בשדה ה"יצוא האחרון" לכל ציון. לדוגמה, תוצאה יכולה להיות ברשומה מיוצאת תזוהה כ"חדשה" או "מעודכנת". אם אינך בטוח לגבי זה השאר הכל ריק.';
$string['confighiddenuserfields'] = 'בחר אילו בחר אילו שדות מידע של הסטודנט תרצה להסתיר ממשתמשים אחרים  חוץ מאשר מורי הקורס ומנהלים. דבר אשר יגדיל את אבטחת הסטודנט. החזק את מקש ה-CTRL לבחירת שדות מרובה.';
$string['configidnumber'] = 'אפשרות זו מציינת באם: א)מתשמשים כלל לא יתבקשו לספק מספר ID , ב) משתמשים מתבקשים לציין מספר ID אך יכולים להשאיר את תיבה זו ריקה, ג) מתשמשים מתבקשים לציין מספר ID ואינם רשאים להשאירו ריק. כל זאת אם מספר ה-ID של המשתמש קיים בפרופיל שלהם.';
$string['configintro'] = 'בדף זה ניתן לציין מספר משתני הגדרה אשר יעזרו למערכת Moodle לתפקד כהלכה בצד השרת שלך. בררת־המחדל עובדת בצורה טובה, וניתן בכל שלב לחזור ולשנות את ההגדרות בדף זה.';
$string['configintroadmin'] = 'בדף זה תוכל לעצב את החשבון הראשי של מנהל האתר אשר לו תיהיה שליטה מלאה באתר. דאג כי אתה נותן שם משתמש וסיסמה מובטחת בנוסף כתובת דוא"ל תקפה. בנוסף תוכל ליצור עוד חשבונות מנהלים בהמשך.';
$string['configintrosite'] = 'דף זה מאפשר לך לעצב את את עמוד השער ושם אתר חדש זה. ניתן לחזור לכן בעתיד לשנות את הגדרות אלו בכל זמן ע"י שימוש בתפריטי הניהול.';
$string['configiplookup'] = 'כאשר תקיש את מען IP (כמו 34.12.222.93) הנמצא לדוגמה ביומני המעקב, תוצג מפה עם הניחוש המוצלח ביותר לאיתור אותו מספר IP. קיימוים מספר התקנים לכך שתוכל לבחור, לכל אחד יש את החסרונות ויתרונות שלו.';
$string['configkeeptagnamecase'] = 'בדוק זאת אם אתה מעוניין כי שמות התגים ישמרו על ההבדלים בין אותיות קטנות ורישיות כפי שהוכנסו על ידי המשתמשים שיצרו אותן';
$string['configlang'] = 'בחירת שפת בררת־מחדל לכל האתר. משתמשים יוכלו לשנות אפשרות זו בהמשך.';
$string['configlanglist'] = 'השאר תיבה זו ריקה לאפשר למשתמשים לבחור איזו שפה שיחפצו מתוך השפות הקיימות בהתקנת מערכת ה moodle שלך. בכל אופן תוכל לרשום את תפריט השפה ע"י הקלדת רשימת השפות בקיצור עם הפרדה בסימן פסיק לדוגמה';
$string['configlangmenu'] = 'בחר באם להציג או לא את תפריט השפה היעודית בדף הפתיחה וההתחברות הראשי. הגדרה זו לא משפיעה על היכולת המשתמש לקבוע שפה מועדפת בפרופיל שלהם.';
$string['configlangstringcache'] = 'מטמון מחרוזות השפה אל תוך קבצים מקומפלים בתוך ספריית ה-DATA.
אם הינך מתרגם את קוד Moodle שינוי מחרוזות בקוד ה-Moodle ,
תצטרך לכבות אפשות זו. אחרת השאר אפשרות זו פעילה ובחן את ביצועי האתר.';
$string['configlatinexcelexport'] = 'השתמש בקידוד עבור יצוא Excel';
$string['configlocale'] = 'בחירת הגדרות מקומיות משפיעות על כל המערכת - הגדרות אלו יחליפו את המבנה והשפה של תאריכים לכל ערכות השפה (אם כי שמות הימים היומן לא משתנים). יש לוודא כי הגדרות אלו מותקנות ברמת מערכת ההפעלה של השרת עליו מותקנת המערכת. למשל: במערכת LINUX ערכים כגון en_US.UTF-8 או he_IL.UTF-8. ברוב המקרים שדה זה ישאר ריק.';
$string['configloginhttps'] = 'בהפעלת רכיב זה תגרום ל-Moodle להתשמש בחיבור https מאובטח רק לעמוד התחברויות לאתר (מספק כניסת התחברות מאובטחת), ולאחר מכן לחזור למצב הקודם של http URL רגיל לשם מהירות רגילה. <br> היזהר: הגדרה זו מצריכה את ה-https להיות מאופשר ספציפית בשרת הרשת שלך - אם לא אתה עלול לנעול את עצמך לחלוטין.';
$string['configloglifetime'] = 'אפשרות זו מציינת את משך הזמן שתרצה להפעיל את יומני המעקב על פעילות משתמש. יומני מעקב אשר ארוכים מזמן זה ימחקו אוטומטית. מומלץ להשאיר את יומני המעקב למשך זמן רב ביותר שניתן , במקרה שאתם ממש צריכים בכך. אך קיים אצלך שרת עמוס מאוד ואתה חווה בעיות של ביצועים, עדיף להפחית במשך הזמן שתקצה ליומני המעקב.';
$string['configlookahead'] = 'מספר הימים לצפות';
$string['configmaxbytes'] = 'הגדרה זו מציינת את הנפח המירבי של קבצים המועלים לרשת ברחבי האתר. הגדרה זו היא מוגבלת ע"י הגדרת post_max_size ו-upload_max_filesize של ה-PHP , כמו כן הגדרת LimitRequestBody של Apache. לחילופין, maxbytes מגביל את הטווח של הגדלים שניתן לבחור בהם ברמת הקורס או ברמת המודול.';
$string['configmaxconsecutiveidentchars'] = 'סיסמאות אינן יכולות לכלוליותר מרצף מספרי זהה של תווים. השתמש ב-0 לכיבוי אפשרות זו.';
$string['configmaxeditingtime'] = 'הגדרת הגבלת הזמן בו משתמשים יכולים לערוך הודעה לאחרה פרסומה בפורום, במילון ,בתגובות וכד\'. בדרך כלל 30 דקות הוא ערך מומלץ.';
$string['configmaxevents'] = 'מאורעות לצפות';
$string['configmaxusersperpage'] = 'מספר מירבי של משתמשים המוצגים עם בחירת המשתמש, קבוצה, קבוצה מערכתית ,webservice וכד\'';
$string['configmessaging'] = 'האם מערכת שליחה וקבלת הודעות בין משתמשי האתר תותר?';
$string['configmessagingallowemailoverride'] = 'אפשר למשתמשים לשלוח הודעות דוא"ל לכתובת דוא"ל או כתובת אחרת מהכתובת של הפרופיל שלהם.';
$string['configmessagingdeletereadnotificationsdelay'] = 'קריאת ההודעות יכולה להימחק בכדי להרוויח זמן. כמה זמן לאחר קריאת ההודעה תרצה שהיא תמחק?';
$string['configmessaginghidereadnotifications'] = 'הסתרת הודעות אירועים שנקראו כגון פרסומי פורום, כאשר צופים בהיסטוריית ההודעות';
$string['configminpassworddigits'] = 'סיסמאות חייבות להכיל לפחות כמות כזו של ספרות.';
$string['configminpasswordlength'] = 'סיסמאות חייבות להכיל לפחות את אורך כמות תווים זו.';
$string['configminpasswordlower'] = 'סיסמאות חייבות להכיל לפחות כמות כזו של אותיות קטנות.';
$string['configminpasswordnonalphanum'] = 'סיסמאות חייבות להכיל לפחות כמות כזו של תווים שהם לא אלפא-נומרים.';
$string['configminpasswordupper'] = 'סיסמאות חייבות להכיל לפחות כמות כזו של אותיות גדולות.';
$string['configmobilecssurl'] = 'קובץ CSS המשמש להתאמת עיצוב ממשק המשתמש ביישום מוודל הזמין למכשיר הנייד שלך.';
$string['configmodchooserdefault'] = 'האם יש להציג את בורר הפעילויות למשתמשים כבררת־מחדל?';
$string['configmycoursesperpage'] = 'המספר המירבי של קורסים שיוצגו ברשימת הקורסים אליהם משוייך המשתמש';
$string['configmymoodleredirect'] = 'הגדרה זו מאלצת תצוגת עמוד "עדכונים בקורסים שלי" בעת הכניסה למערכת, למשתמשים שאינם מנהלי מערכת.';
$string['configmypagelocked'] = 'הגדרה זו מונעת מהעמוד בררת־המחדל להיות זמין לעריכה ע"י משתמש אשר איננו מנהל המערכת.';
$string['confignavcourselimit'] = 'הגבלת מספר הקורסים המוצג למשתמשים אשר אינם מחוברים למערכת או שאינם משוייכים לתפקיד באף קורס.';
$string['confignavshowallcourses'] = 'הגדרה זו מבטיחה כי כל הקורסים שהמשתמשים משוייכים לתפקיד בהם יוצגו בניווט הקורס וב"קורסים שלי". כאשר מבטלים הגדרה הזו משתמשים משוייכים לתפקיד יראו רק את "הקורסים שלי" בסרגל הניווט.';
$string['confignavshowcategories'] = 'הצגת קטגוריות קורסים בסרגל הניווט ובמשבצת הניווט. הדבר איננו מתרחש בקורסים אשר המשתמשים משוייכים לתפקיד בהם, הם עדיין יהיו ברשימת ה"קורסים שלי" ללא קטגוריות.';
$string['confignotifyloginfailures'] = 'כאשר כשלונות התחברות לאתר מוקלטים, הודעות דוא"ל יכולות להישלח. מי יוכל לראות את הודעות אלו?';
$string['confignotifyloginthreshold'] = 'אם הודעות על כשלונות התחברות פועלות, כמה נסיונות התחברות כושלים שנעשו ע"י משתמש בודד או כתובת IP כדאי ליידע?';
$string['confignotloggedinroleid'] = 'משתמשים אשר אינם מחוברים לאתר יקבלו מעמד הזהה לתפקיד המצויין בכלל האתר. אורח כמעט תמיד רצוי להיות מסומן כאן, אך לפעמים תרצה ליצור תפקידים פחות מגבילים. פעולות כמו פרסום הודעות עדיין ידרשו מהמשתמש להתחבר כרגיל לאתר.';
$string['configopentogoogle'] = 'באפשור הגדרה זו,Google יותיר להכניס את את האתר שלך כאורח. בנוסף, אנשים אשר יגיעו לאתר שלך דרך Google יחוברו אוטומטית כאורחים לאתר. שים לב אפשרות זו מספקת גישה שקופה לקורסים שמראש מאפשרים גישה לאורחים.';
$string['configoverride'] = 'מוגדר בקובץ config.php';
$string['configpasswordpolicy'] = 'הפעלת מנגנון זה תגרום ל-Moodle לבדוק סיסמאות משתמשים כנגד מדיניות סיסמה חוקית. השתמש בהגדרות למטה בכדי לציין את מדיניותך (התעלמו מההגדרות אלו אם תציין כאן "לא")';
$string['configpasswordresettime'] = 'הדבר מציין את כמות הפעמים שבהם משתמשים אימתו את בקשת איפוס הסיסמה שלהם לפני שפג תוקפה. בדרך-כלל 30 דקות הוא ערך מתאים.';
$string['configpathtoclam'] = 'נתיב לתוכנת אנטי-וירוס clam . כנראה /usr/bin/clamscan או /usr/bin/clamdscan , תצטרך זאת כדי שתוכנת האנטי-וירוס calm תרוץ במערכת.';
$string['configpathtodu'] = 'נתיב ל-du בדומה ל-/usr/bin/du. אם תקיש את זה, דפים אשר יציגו תכני תיקיות ירוצו מהר יותר עבור ספריות בעלי הרבה קבצים.';
$string['configperfdebug'] = 'הפעלת מנגנון זה, תציגת מידע על הביצועי המערכת אשר יופיעו בתחתית העמוד, כאשר אתם משתמשים בערכת הנושא standard.';
$string['configprofileroles'] = 'רשימת תפקידים אשר נראים בפרופיל המשתמש ובעמוד המשתתפים';
$string['configprofilesforenrolledusersonly'] = 'למנוע שימוש לרעה ע"י שולחי דואר זבל, תיאור פרופיל המשתמש עבור כאלו שעדיין לא משוייכים לתפקיד בקורס יוסתר. משתמשים חדשים חייבים להיות משוייכים לתפקיד בקורס אחד לפחות לפני שיוכלו להוסיף תיאור לפרופיל המשתמש שלהם.';
$string['configprotectusernames'] = 'כבררת־המחדל, מנגנון"שכחתי סיסמה" לא מציגה רמזים שמאפשרים ניחוש שמות משתמש או כתובות דוא"ל.';
$string['configproxybypass'] = 'רשימת כתובת מארחים או כתובות IP מופרדים בפסיק, אמורים לעקוף דרך פרוקסי.
(e.g., 192.168., .mydomain.com)
	';
$string['configproxyhost'] = 'אם <b>שרת זה</b> מצריך שימוש במחשב proxy (למשל חומת מגן) להתחברות לאינטרנט, אז יש להזין שם־מתחם (שם מחשב/שרת) לשרות ה proxy ומספר port. אחרת יש להשאיר ריק.';
$string['configproxypassword'] = 'סיסמה נדרשת כדי לגשת לאינטרנט דרך proxy אם נדרש, השאר ריק אם אין שימוש בכך (נדרשת הרחבת PHP ו-cURL).';
$string['configproxyport'] = 'כאשר מערכת זו עושה שימוש בשרות proxy, יש להזין את מספר ה port כאן.';
$string['configproxytype'] = 'סוג ה-web proxy (הרחבות PHP5 ו-cURL נדרשות עבור תמיכת SOCKS5).';
$string['configproxyuser'] = 'שם המשתמש נדרש כדי לגשת לאינטרנט דרך proxy אם נדרש, השאר ריק אם אין שימוש בכך (נדרשת הרחבת PHP ו-cURL).';
$string['configquarantinedir'] = 'אם תרצה שתוכנת האנטי-וירוס calm תעביר קבצים דבוקים לספריית הסגר, הכנס אותה כאן. לספרייה חייבת להיות הרשאת קריאה וכתיבה ע"י השרת. אם תשאיר כאן חלל ריק או לחילופין תרשום שם ספרייה שלא קיים או לא ניתן לכתיבה וקריאה, הקבצים הדבוקים ימחקו. אל תסיים את ה-URL עם לוכסן\'\'.';
$string['configrecaptchaprivatekey'] = 'מחרוזת של תווים משומשים עבור תקשורת בין שרת הMoodle שלך ושרת ה-recaptcha.net. לקבלת אחד עבור אתר זה בקר באתר - http://recaptcha.net';
$string['configrecaptchapublickey'] = 'מחרוזת של תווים משומשים להצגת אלמנט ה-reCAPTCHA בטופס הרישום הנוצר באתר http://recaptcha.net';
$string['configrequestcategoryselection'] = 'לאפשר בחירת קטגוריה כאשר מבקשים קורס.';
$string['configrequestedstudentname'] = 'המינוח למושג סטודנט בקורסים המבוקשים';
$string['configrequestedstudentsname'] = 'המינוח למושג סטודנטים בקורסים המבוקשים';
$string['configrequestedteachername'] = 'המינוח למושג מורה בקורסים המבוקשים';
$string['configrequestedteachersname'] = 'המינוח למושג מורים בקורסים המבוקשים';
$string['configrequiremodintro'] = 'נטרל אפשרות זו אם אינך רוצה לכפות על משתמשים כניסה לתיאור של כל פעילות.';
$string['configrunclamavonupload'] = 'כאשר מאופשר, תוכנת אנטי-וירוס calm תופעל לסריקה של כל הקבצים אשר הועלו.';
$string['configrunclamonupload'] = 'האם להריץ את תוכנת האנטי-וירוס calm כאשר קובץ מועלה? תצטרך נתיב תקין ב-pathtocalm כדי שזה יעבוד. (תוכנת אנטי-וירוס calm סורקת וירוסים שתקבל מ- http://www.clamav.net )';
$string['configsectioninterface'] = 'ממשק';
$string['configsectionmail'] = 'דואר';
$string['configsectionmaintenance'] = 'תחזוקה';
$string['configsectionmisc'] = 'שונות';
$string['configsectionoperatingsystem'] = 'מערכת הפעלה';
$string['configsectionpermissions'] = 'הרשאות';
$string['configsectionrequestedcourse'] = 'בקשות קורס';
$string['configsectionsecurity'] = 'אבטחה';
$string['configsectionstats'] = 'סטטיסטיקות';
$string['configsectionuser'] = 'משתמש';
$string['configsecureforms'] = 'מערכת Moodle תוכל להשתמש ברמה נוספת של אבטחה כאשר תקבל מידע מטפסי הרשת. באפשור הגדרה זו משתנה HTTP_REFERER של הדפדפן נבדק מול כתובת הטופס הנוכחי. במקרים מסויימים עלולות להיווצר בעיות אם משתמש המערכת משתמש בחומת מגן, למשל Zonealarm, ומורה לה למחוק את HTTP_REFERER מתעבורת רשת האינטרנט. סימנים לבעיות היא "תקיעה" בכת הצגת טופס. אם למשתמשים יש, למשל, תקלות בעמוד הרישום יתכן ותרצה למנוע הגדרה זאת, גם אם היא תשאיר את האתר שלך יותר חשוף לנסיונות חוזרים ונשנים של שבירת הסיסמאות. אם אתה בספק השאר את הערך "כן".';
$string['configsessioncookie'] = 'הגדרה זו קובעת את שם ה"עוגיה" (cookie) המשמשת את ההתקשרות למערכת Moodle. משתנה זה הינו רשות בלבד, ומשמש למניעת בלבול בין העוגיות כאשר יש יותר מעותק אחד של Moodle באותו שם מתחם (domain name).';
$string['configsessioncookiepath'] = 'ניתן לשנות את האופן בו הדפדפנים מזהים "עוגיות" (cookies) של Moodle, על ידי מתן שם ייחודי למערכת הנוכחית, וכל אחת אחרת תחת אותו שם מתחם. בררת־המחדל: \'/\'.';
$string['configsessiontimeout'] = 'אם המשתמשים הפועלים באופן מקוון במערכת זו מפסיקים להקליק על קישורים למשך זמן ארוך (כלומר לא טוענים דפים) אז הם ינותקו באופן אוטומטית (הקישור שלהם מופסק). משתנה זה מגדיר את משך הזמן שנחשב אי־פעילות אשר מפעיל את מנגנון הניתוק.';
$string['configshowcommentscount'] = 'הצגת ספירת הערות, הדבל יעלה בשאילתא אחת או יותר בתצוגת קישור ההערות.';
$string['configshowicalsource'] = 'הצגת מקור המידע עבור אירועי iCal';
$string['configshowsiteparticipantslist'] = 'כל הסטודנטים והמורים של האתר יומנו ברשימת המשתתפים. למי תיהיה הזכות לראות את רשימת משתתפים זו באתר?';
$string['configsitedefaultlicense'] = 'רשיון בררת־המחדל, מערכתי';
$string['configsitedefaultlicensehelp'] = 'רשיון בררת־המחדל, מערכתי עבור פרסום תוכן והעלאת משאבים';
$string['configsitemaxcategorydepth'] = 'עומק קטגוריה מירבי';
$string['configsitemaxcategorydepthhelp'] = 'הגדרה המציינת את העומק המירבי המוצג של תתי-הקטגוריה';
$string['configslasharguments'] = 'שיטת שליחת קבצים (תמונות, העלאות וכד\') בעזרת תסריט (script) מבוסס \'משתנים מופרדים בלוכסאנים\' (SlashArguments) מאפשרת לדפדפנים לשמור את הקישורים לקבצים בצורה קלה יותר בזיכרון המטמון שלהם, וגם בשרתי proxy וכד\'. וכך לקבל שיפור ביצועים בגלישה.

למרבה הצער, חלק משרתי ה-PHP לא מאפשרים שיטה זו, לכן אם אתם מתקשים להציג בדפדפנים קבצים או תמונות (למשל תמונות של משתמשים), יש לבטל אפשרות זו.';
$string['configsmartpix'] = 'כאשר פועל, חיפוש הצלמיות מתחיל בתסריט (script) PHP אשר מחפש את ערכת הנושא הנוכחית, לאחר מכן חיפוש בכל ערכות הנושא המקוריות ולאחר מכן בתיקיית  Moodle/pix folder. תכונה זו מקטינה את הצורך בקבצי תמונות כפולות בתוך ערכות הנושא, אך גורם לתוספת זעומה בעלות הביצוע.';
$string['configstartwday'] = 'התחלת שבוע';
$string['configstatsfirstrun'] = 'ערך זה מציין כמה דורות של יומני מעקב יעובדו <b> בפעם הראשונה </b> שתוכנת cronjob תבצע עיבוד סטטיסטי. אם במערכת שלך יש תעבורת רשת רבה והיא נמצאית על אירוח משותף, כנראה אין זה רעיון טוב ללכת רחוק מדי לעבר, משום שזה יכול לארוך זמן רב וידרוש הרבה משאבי מחשב. שים לב כי בהגרדה זאת חודש אחד שווה ל-28 ימים. לעומת זאת, בגרפים ובדוחות חודש איד זהה לחודש קלנדרי.';
$string['configstatsmaxruntime'] = 'עיבוד סטטיסטיקות יכול היות אינטנסיבי, בקרה זה השתמש בצירוף השדה הזה והבא אחריולציין מתי הוא ירוץ למשך כמה זמן.';
$string['configstatsmaxruntime2'] = 'עיבוד סטטיסטיקות עלול להיות די אינטנסיבי. ציין את הזמן המירבי לאיפשור איסוף סטטיסטיקות עבור יום אחד. המספר המירבי של ימים אשר מעובדים בביצוע cron הוא 31.';
$string['configstatsmaxruntime3'] = 'ציין את הזמן המירבי לאיפשור חישוב הסטטיסיקות עבור יום אחד, נזכור כי עיבוד סטטיסטיקות עלול להכביד על השרת. המספר המירבי של ימים אשר מעובדים ב-cron אחד יכול מפורט כאן.';
$string['configstatsruntimedays'] = 'ציין את מספר הימים המירבי המעובדים בכל ביצוע של סטטיסטיקות. כאשר הסטטיסטיקות מעודכנות, רק יום אחד יעובד, ווסת את ערך זה בהתאם לעומס בשרת שלך, הקטן ערך זה אם bjumho ביצועים קצרים של ה-cron.';
$string['configstatsruntimestart'] = 'לאיזו שעה <b> להתחיל </b> את ה-cronjob אשר מבצע את עיבוד הסטטיסטיקות';
$string['configstatsuserthreshold'] = 'המספר הנמוך ביותר של משתמשים המשוייכים לתפקיד בקורס, כדי שקורס ישוקלל בחישוב הסטטיסטיקה.';
$string['configstrictformsrequired'] = 'כאשר מסומן, תמנע מהמשתמשים האפשרות להכניס רווח או תו "ירידת שורה" בשדות המאפשרים זאת.';
$string['configstripalltitletags'] = 'בטל סימון הגדרה זו בכדי לאפשר תגי HTML בשמות משאבים ופעילויות.';
$string['configsupportemail'] = 'כתובת דואל זה תופץ למשתמשים של אתר זה ככתובת שאליה יש לפנות לעזרה כללית (למשל כאשר משתמשים חדשים יוצרים את החשבונות שלהם). את הכתובת נשארת ריקה אזי לא תסופק שום כתובת דואל למטרות עזרה.';
$string['configsupportname'] = 'זה שם האדם המציעים עזרה כללית באמצעות דואל התמיכה או באמצעות כתובת אתר.';
$string['configsupportpage'] = 'כתובת אתר זה תופץ למשתמשים של אתר זה ככתובת שאליה יש לפנות כאשר הם נזקקים לתמיכה כללית (למשל, כאשר משתמשים חדשים יוצרים את החשבונות שלהם). אם כתובת זאת נשארת ריקה לא יופץ כל קישור שהוא.';
$string['configthemelist'] = 'השאר כאן חלל ריק לאפשר שימוש בערכות נושא תקפים. אם תרצה לקצר את תפריט ערכת הנושא, תוכל לציין ע"י הפרדה בפסיק רשימת שמות כאן (אל תשתמש ברווחים!)לדוגמה: standard,orangewhite.';
$string['configtimezone'] = 'תוכל לקבוע איזורי זמן כברירת מחדל כאן. זוהי רק ברירת מחדל לאיזורי זמן כאשר מציגים תאריכים - כל משתמש יוכל לשנות זאת ע"י קביעת איזורי הזמן בפרופיל שלו. "זמן שרת" כאן יגרום לברירת המחדל של-Moodle להיות זהה לברירת מחדל של מערכת ההפעלה של השרת, אך "זמן שרת" בפרופיל המשתמש יגרום לברירת המחדל בפרופיל המשתמש להיות זהה לערך אזור הזמן שנקבע כאן. מאורעות Cronjobs אשר תלויים בשעת היום בכדי לפעול ישתמשו בהגדרת איזור זמן זה';
$string['configuseblogassociations'] = 'האם משתמשים יכולים לארגן את הבלוגים שלהם ע"י שיוך ערכים עם קורסים ורכיבי קורס?';
$string['configuseexternalyui'] = 'במקום להשתמש בקבצים מקומיים, השתמש בקבצים אונליין הזמינים בשרתי Yahoo. אזהרה: הדבר מצריך חיבור אינטרנט , אחרת AJAX לא יעבוד באתר שלך.';
$string['configuserquota'] = 'מספר מקסימלי של בתים אשר משתמש יכול לאחסן באיזור הקבצים הפרטי שלו.
{$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'אם מאופשר,סימון עמודי האתר בניווט ישתמש בשם המקוצר של האתר ולא במחרוזת  \'Site pages\'';
$string['configusetags'] = 'האם יש לאפשר את פונקצונליות התגים באופן סוחף לכל האתר?';
$string['configvariables'] = 'משתנים';
$string['configverifychangedemail'] = 'איפשור אימות שינוי כתובות דוא"ל בעזרת הגדרות שמות-מתחם מותרים/מוגבלים עבור כתובות הדוא"ל. אם הגדרה זו איננה-זמינה, אימות שמות-המתחם יואכפו רק בזמן יצירת משתמשים חדשים.';
$string['configvisiblecourses'] = 'מציג קורסים בקטגוריות מוסתרות בצורה נורמלית';
$string['configwarning'] = 'היזהר כאשר אתה משנה את הגדרות אלו. ערכים לא אופייניים יגרמו לבעיות.';
$string['configyuicomboloading'] = 'אפשרות זו מאפשרת לשלב קבצי טעינה המותאמים ל ספריות YUI. כדאי לאפשר הגדרה זו באתרים פעילים לייעל ביצועים.';
$string['confirmation'] = 'אישור';
$string['confirmdeletecomments'] = 'הינך עומד למחוק הערות, האם אתה בטוח?';
$string['confirmed'] = 'מאושר';
$string['cookiehttponly'] = 'עוגיות http בלבד';
$string['cookiesecure'] = 'עוגיות מאובטחות בלבד';
$string['country'] = 'ארץ נבחרת';
$string['coursecontact'] = 'מנהלי קורס';
$string['coursecontact_desc'] = 'הגדרה זו מאפשרת לך לשלוט מי נמצא בתיאור הקורס. למשתמשים צריך להיות לפחות את אחד מהתפקידים האלו בקורס לשם הצגתם בתיאור הקורס באותו קורס ספציפי.';
$string['courselistshortnames'] = 'הצגת שמות קורסים מורחבים';
$string['courselistshortnames_desc'] = 'שם מקוצר כמו השם המלא כאשר מציגים רשימת קורסים';
$string['coursemgmt'] = 'ניהול קורסים וקטגוריות';
$string['courseoverview'] = 'סקירה כללית של הקורס';
$string['courserequestnotify'] = 'הודעה על בקשות קורס';
$string['courserequestnotifyemail'] = 'משתמש {$a->user} ביקש קורס חדש ב-{$a->link}';
$string['courserequests'] = 'בקשות קורס';
$string['courserequestspending'] = 'בקשות הקורס הממתינות';
$string['courses'] = 'קורסים';
$string['coursesperpage'] = 'קורסים לכל דף';
$string['courseswithsummarieslimit'] = 'קורסים עם הגבלת תיאור הקורס';
$string['creatornewroleid'] = 'תפקיד יוצרים בקורסים חדשים';
$string['creatornewroleid_help'] = 'אם למשתמש אין עדיין את ההרשאות לנהל את הקורס החדש, המשתמש ירשם באופן אוטומטי כשתשתמש בתפקיד זה.';
$string['cron'] = 'CRON';
$string['cronclionly'] = 'הרצת Cron דרך שורת פקודה בלבד';
$string['cronerrorclionly'] = 'מצטערים, גישת האינטרנט לדף זה נוטרלה על-ידי מנהל המערכת.';
$string['cronerrorpassword'] = 'מצטערים, לא סיפקת סיסמה ברת-תוקף לדף זה';
$string['cron_help'] = 'תסריט ה-cron.php עוזר לרכיבי המערכת לבצע מטלות  מתוזמנות כמו שליחת דוא"ל מפרסומי הפורומים. נדרש מכניזם לריצת התסריט , בדר"כ כל 5 דקות.';
$string['cronremotepassword'] = 'סיסמת Cron לגישה מרחוק';
$string['cronwarning'] = 'קוד הפעלת <a href="{$a}">cron.php לתחזוקה</a> לא הופעל במשך 24 השעות האחרונות.';
$string['ctyperequired'] = 'הרחבת ה-ctype PHP כעת נדרשת ע"י Moodle, כדי לשפר את ביצועי האתר ולהציע תאימות רב-לשונית.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'התוסף cURL PHP נדרש ע"י המערכת בכדי להתקשר עם  Moodle Repositories
';
$string['curltimeoutkbitrate'] = 'Bitrate  כאשר משתמשים בחישוב זמני cURL (Kbps)';
$string['currenttheme'] = 'ערכת הנושא הנוכחית';
$string['customcheck'] = 'בדיקות אחרות';
$string['custommenu'] = 'תפריט מותאם אישית';
$string['custommenuitems'] = 'פריטי תפריט מותאם אישית';
$string['customusermenuitems'] = 'פריטי תפריט משתמש';
$string['datarootsecuritywarning'] = 'תצורת האתר שלך עלולה להיות פרוצה. אנא וודא שספריית {$a} ה-dataroot שלך אינה נגישה באופן ישיר מהרשת.';
$string['dbsessions'] = 'שימוש במסד־נתונים לאחסון נתוניי־חיבור־משתמש (session)';
$string['debug'] = 'הודעות ניפוי שגיאות';
$string['debugall'] = 'הכל: הצגת כל הודעות ניפוי השגיאות של ה-PHP';
$string['debugdeveloper'] = 'למפתח: הודעות הכוללות מידע נוסף לצורך ניפוי שגיאות';
$string['debugdisplay'] = 'תצוגת הודעות ניפוי שגיאות (debug)';
$string['debugging'] = 'ניפוי שגיאות';
$string['debugminimal'] = 'בסיסי: הצגת שגיאות מכריעות';
$string['debugnone'] = 'אף אחד: אל תראה בכלל שגיאות או אזהרות';
$string['debugnormal'] = 'רגיל: הצגת שגיאות, אזהרות והתראות';
$string['debugpageinfo'] = 'הצגת נתוני מידע המאפיינים את יצירת העמוד';
$string['debugsmtp'] = 'ניפוי שליחות דוא"ל';
$string['debugstringids'] = 'הצגת מקורן של מחרוזות השפה';
$string['debugvalidators'] = 'הצגת קישור למנגנון בדיקת תקינות העמוד של W3C';
$string['defaultcity'] = 'עיר בררת־מחדל';
$string['defaultcity_help'] = 'העיר שתוכנס כאן תהיה עיר בררת־המחדל כאשר יוצרים משתמשים חדשים';
$string['defaultformatnotset'] = 'שגיאה בקביעת תסדיר קורס כבררת־המחדל. אנא בדוק את הגדרות אתר.';
$string['defaulthomepage'] = 'בררת־המחדל של העמוד הראשי עבור משתמשים';
$string['defaultrequestcategory'] = 'בררת־המחדל קטגוריה עבור בקשות קורס.';
$string['defaultsettinginfo'] = '   בררת־המחדל: {$a}';
$string['defaultuserroleid'] = 'בררת־המחדל של התפקיד - לכל המשתמשים.';
$string['deleteincompleteusers'] = 'מחק משתמשים לא גמורים אחרי';
$string['deleteunconfirmed'] = 'סלק משתמשים שלא אושרו לאחר';
$string['deleteuser'] = 'מחק משתמש';
$string['density'] = 'צפיפות';
$string['denyemailaddresses'] = 'כתובות הדוא"ל החסומות.';
$string['development'] = 'פיתוח';
$string['devicedetectregex'] = 'זיהוי התקן בעזרת regular expressions';
$string['devicedetectregexexpression'] = 'ביטוי רגולרי';
$string['devicedetectregexvalue'] = 'החזרת ערך';
$string['devicetype'] = 'סוג התקן';
$string['disableuserimages'] = 'מניעת עדכון תמונה על-ידי משתמשים';
$string['displayerrorswarning'] = 'שימוש בהגדרת display_errors של PHP לא מומלצת במערכת המשמשת ללמידה ואשר אינה משמשת לפיתוח בלבד, זאת משום שהודעות שגיאה מסוימות עלולות לחשוף מידע רגיש אודות המערכת שלכם ואף לחשוף נתוניי משתמשים חסויים!';
$string['displayloginfailures'] = 'הצגת כשלונות התחברות ל';
$string['dndallowtextandlinks'] = 'גרירה והעלאת  של טקסט או קישור';
$string['doclang'] = 'שפות עבור תיעוד';
$string['docroot'] = 'שורש ספרית Moodle Docs.';
$string['doctonewwindow'] = 'פתח בחלון חדש';
$string['download'] = 'הורדה';
$string['edithelpdocs'] = 'עריכת מסמכי עזרה';
$string['editlang'] = '<b>עריכה</b>';
$string['editorbackgroundcolor'] = 'צבע הרקע';
$string['editordictionary'] = 'מילון עורך';
$string['editorfontfamily'] = 'משפחת גופן';
$string['editorfontlist'] = 'רשימת גופנים';
$string['editorfontsize'] = 'גודל גופן';
$string['editorhidebuttons'] = 'כפתורים נסתרים';
$string['editorkillword'] = 'מסנן Word';
$string['editorspelling'] = 'איות עורך';
$string['editorspellinghelp'] = 'אפשר או נטרל spell-checking כאשר מאופשר, <strong>aspell</strong> חייבת להיות מותקנת בשרת שלך.';
$string['editstrings'] = 'עריכת מחרוזות';
$string['emailchangeconfirmation'] = 'אישור שינוי כתובת הדוא"ל';
$string['emoticonalt'] = 'טקסט חלופי';
$string['emoticoncomponent'] = 'רכיב תמונה';
$string['emoticonimagename'] = 'שם תמונה';
$string['emoticons'] = 'פַּרְצוּפוֹנים';
$string['emoticonsreset'] = 'איפוס הגדרות פרצופונים (סמיילים) לערכי בררת־המחדל.';
$string['emoticontext'] = 'מלל (טקסט)';
$string['emptysettingvalue'] = 'ריק';
$string['enableblogs'] = 'לאפשר בלוגים';
$string['enablecalendarexport'] = 'אפשר יצוא לוח השנה';
$string['enablecomments'] = 'אפשר הערות';
$string['enablecourserequests'] = 'אפשר בקשות קורס';
$string['enablecssoptimiser'] = 'אפשר CSS optimise';
$string['enabled'] = 'מאופשר';
$string['enabledevicedetection'] = 'אפשר זיהוי התקן';
$string['enablegravatar'] = 'איפשור Gravatar';
$string['enablegravatar_help'] = 'כאשר מאפשרים, Moodle  ינסה להתאים את תמונת המשתמש מה-Gravatar  אם המשתמש לא העלאה אף תמונה.';
$string['enablemobilewebservice'] = 'מתן גישה לשרותים-מקוונים עבור התקן נייד (mobile)';
$string['enablerecordcache'] = 'אפשר שימוש בזיכרון מטמון לרשומות.';
$string['enablerssfeeds'] = 'אפשר הזנות RSS';
$string['enablesafebrowserintegration'] = 'אפשר שילוב Safe Exam Browser';
$string['enablestats'] = 'אפשר סטטיסטיקות';
$string['enabletgzbackups'] = 'אפשר תצורת גיבוי חדשה';
$string['enabletrusttext'] = 'מנגנון "תוכן אמין"';
$string['enablewebservices'] = 'אפשר web services';
$string['enablewsdocumentation'] = 'תיעוד web services';
$string['enrolinstancedefaults'] = 'ערכי בררת־המחדל למנגנון שיוך משתמשים לתפקיד בקורס';
$string['enrolinstancedefaults_desc'] = 'הגדרות בררת־המחדל של השיוך לתפקיד בקורסים חדשים.';
$string['enrolmultipleusers'] = 'שיוך המשתמשים לתפקיד בקורס';
$string['environment'] = 'תשתיות ותוספים';
$string['environmenterrortodo'] = 'אתה חייב לפתור את כל הבעיות (השגיאות) הסביבתיות הנמצאות למעלה לפני המשך הליך התקנת גירסה זו של Moodle.';
$string['environmenterrorupgrade'] = 'אזהרה: הינך צריך לפתור את כל הבעיות (שגיאות) הסביבתיות שנמצאו כאן לפני המשך שדרוג גרסת Moodle זו! שדרוג ללא תיקון דרישות אלו עלול לגרום לבעיות כמו אובדן מידע ונתונים. האם אתה בטוח כי ברצונך להמשיך בשדרוג?';
$string['environmentmustfixsetting'] = 'חובה לשנות את הגדרות ה-PHP.';
$string['environmentok'] = 'סביבת השרת שלך מספקת את כל הדרישות הבסיסיות.';
$string['environmentrecommendcustomcheck'] = 'אם בדיקה זו נכשלת, היא מצביע על בעיה פוטנציאלית.';
$string['environmentrecommendinstall'] = 'מומלץ להתקין/לאפשר זאת';
$string['environmentrecommendversion'] = 'גירסה {$a->needed} נדרשת והיא מומלצת ואתה מריץ גירסה {$a->current} נוכחית';
$string['environmentrequirecustomcheck'] = 'חובה שמבדק זה יצליח';
$string['environmentrequireinstall'] = 'נדרש להתקין/לאפשר זאת';
$string['environmentrequireversion'] = 'גירסת {$a->needed} נדרשת ואתה מריץ {$a->current}';
$string['environmentsettingok'] = 'זוהו הגדרות מומלצות';
$string['environmentshouldfixsetting'] = 'יש לשנות את הגדרות ה-PHP.';
$string['environmentxmlerror'] = 'שגיאה בקריאת נתוני סביבה {$a->error_code}';
$string['errordeletingconfig'] = 'התגלתה שגיאה בזמן מחיקת רשומות ההגדרה לתוסף \'{$a}\'.';
$string['errorsetting'] = 'לא ניתן לשמור את ההגדרות';
$string['errorwithsettings'] = 'כמה הגדרות לא שונו עקב שגיאה:';
$string['everyonewhocan'] = 'כל מי שיכול \'{$a}\'';
$string['exceptions'] = 'יוצאים מו הכלל';
$string['experimental'] = 'ניסיוני';
$string['experimentalsettings'] = 'הגדרות נסיוניות';
$string['extendedusernamechars'] = 'אפשר תווים מורחבים בשמות המשתמשים';
$string['extramemorylimit'] = 'תוספת גבול זיכרון ה-PHP (Extra PHP memory limit )';
$string['filecreated'] = 'קובץ חדש נוצר';
$string['filestoredin'] = 'שמירת קובץ לתיקיה:';
$string['filestoredinhelp'] = 'היכן הקובץ יאוחסן';
$string['filterall'] = 'סינון כל המחרוזות';
$string['filtermatchoneperpage'] = 'הפעל את המסנן פעם אחת בלבד לכל עמוד';
$string['filtermatchonepertext'] = 'הפעל את המסנן פעם אחת בלבד לכל טקסט';
$string['filters'] = 'מסננים';
$string['filtersettings'] = 'ניהול מסננים';
$string['filtersettingsgeneral'] = 'הגדרות מסנן כללי';
$string['filteruploadedfiles'] = 'סינון הקבצים המועלים';
$string['forcelogin'] = 'הכרחת משתמשים להתחבר למערכת';
$string['forceloginforprofileimage'] = 'הכרחת משתמשים להתחבר בכדי לצפות בתמונות המשתמש';
$string['forceloginforprofileimage_help'] = 'אם מאופשר, המשתמש מוכרח להתחבר בכדי לצפות בתמונות הפרופיל והודעות הדוא"ל ישתמשו בתמונת בררת־המחדל של המשתמש';
$string['forceloginforprofiles'] = 'הכרחת המשתמשים להתחבר אל המערכת לשם תצוגת הפרופילים';
$string['forcetimezone'] = 'אלץ אזור זמן';
$string['frontpage'] = 'העמוד הראשי';
$string['frontpagebackup'] = 'גיבוי';
$string['frontpagedefaultrole'] = 'תפקיד בררת־המחדל של משתמש בעמוד הראשי';
$string['frontpagefilters'] = 'מסננים';
$string['frontpageloggedin'] = 'רכיבים המוצגים בעמוד הראשי, כאשר מחוברים';
$string['frontpageoverrides'] = 'עקיפת הרשאות העמוד הראשי';
$string['frontpagequestions'] = 'שאלות';
$string['frontpagerestore'] = 'שחזור';
$string['frontpageroles'] = 'תפקידים';
$string['frontpagesettings'] = 'הגדרות';
$string['fullnamedisplay'] = 'השם המלא';
$string['fullnamedisplayprivate'] = 'תצורת שם מלא - מידע אישי';
$string['generalsettings'] = 'הגדרות כלליות';
$string['geoipfile'] = 'קובץ מידע GeoIP City';
$string['getremoteaddrconf'] = 'מקור כתובת IP מחוברת';
$string['googlemapkey3'] = 'מפתח API V3 של Google Maps';
$string['gotofirst'] = 'הצגת המחרוזת החסרה הראשונה';
$string['gradebook'] = 'פנקס ציונים';
$string['gradebookroles'] = 'תפקידים להם מתאפשר מתן ציון בקורס';
$string['gradeexport'] = 'השיטה העיקרית של יצוא בציונים';
$string['groupenrolmentkeypolicy'] = 'מדיניות מפתח הרשמה של קבוצה';
$string['groupenrolmentkeypolicy_desc'] = 'הפעלת הגדרה זו תגרום ל-Moodle לבדוק מפתחות הרשמה של קבוצה מול מדיניות סיסמאות  התקפה.';
$string['guestroleid'] = 'תפקיד עבור אורח';
$string['guestroleid_help'] = 'התפקיד מוקצה אוטומטית למשתמש האורח. התפקיד מוקצה באופן זמני למשתמשים אשר אינם רשומים הנכנסים לקורס דרך רכיב התחברות אורח.';
$string['helpadminseesall'] = 'האם מנהלים יכולים לראות את כל הארועים בלוח השנה או רק את אלו המתייחסים אליהן?';
$string['helpcalendarcustomexport'] = 'לאפשר טווח של תאריך מותאם אישית עבור יצוא לוח-שנה, יש לוודא קודם לכן כי יצוא לוח-שנה מאופשר.';
$string['helpexportlookahead'] = 'לכמה ימים בעתיד לכוונן את היצוא של לוח השנה?';
$string['helpexportlookback'] = 'לכמה ימים שחלפו יש לכוונן את יצוא לוח השנה?';
$string['helpforcetimezone'] = 'אתה יכול לאפשר למשתמשים לבחור את אזור הזמן שלהם, או לאלץ אזור זמן כלשהו.';
$string['helpshowicalsource'] = 'אם מאופשר, שם וקישור המנוייופיעו עבור אירועים מיובים של iCal.';
$string['helpsitemaintenance'] = 'לשדרוגים ועבודות תחזוקה אחרות';
$string['helpstartofweek'] = 'באיזה יום השבוע מתחיל השבוע המוצג בלוח השנה? (בישראל - יום ראשון)';
$string['helpupcominglookahead'] = 'בהצגת ארועים קרובים, כמה ימים קדימה יש לחפש ארועים בלוח השנה?';
$string['helpupcomingmaxevents'] = 'כמה ארועים קרובים (ערך מירבי) יש להציג למשתמשים כבררת־המחדל?';
$string['helpweekenddays'] = 'אילו ימים בשבוע נחשבים כ"סופשבוע" ולכן יש להציגם בצבע אחר? (בישראל - ימי שישי ושבת)';
$string['hiddenuserfields'] = 'הסתר שדות משתמש';
$string['hidefromall'] = 'הסתר מכל המשתמשים';
$string['hidefromnone'] = 'אל תסתיר מאף אחד';
$string['hidefromstudents'] = 'הסתר מהסטודנטים';
$string['htmleditor'] = 'דף תוכן מעוצב (html)';
$string['htmleditorsettings'] = 'הגדרות עורך תוכן מעוצב (HTML)';
$string['htmlsettings'] = 'הגדרות HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'אבטחת HTTP';
$string['hubs'] = 'רשת שרתיי Moodle';
$string['iconvrequired'] = 'נדרשת התקנת הרחבת ICONV';
$string['ignore'] = 'התעלם';
$string['includemoduleuserdata'] = 'להכליל מודול נתוני משתמש';
$string['incompatibleblocks'] = 'משבצות לא מוגדרות באופן תקין';
$string['installhijacked'] = 'ההתקנה חייבת להסתיים מכתובת ה-IP המקורית, מצטערים.';
$string['installsessionerror'] = 'לא ניתן לאתחל נתוניי־חיבור־משתמש הנשמרים ברמת PHP בעזרת "עוגיות", יש לוודא כי הדפדפן שלך מקבל "עוגיות".';
$string['intlrecommended'] = 'התוספת Intl  משמשת לשיפור תמיכת האינטרנציונליזציה כמו מיון (סיווג) מודע מקומי.';
$string['invalidsection'] = 'קטע לא חוקי';
$string['invaliduserchangeme'] = 'שם המשתמש "chaneme" שמור למערכת - לא ניתן ליצור חשבון משתמש איתו';
$string['ipblocked'] = 'אתר זה איננו זמין כרגע.';
$string['ipblocker'] = 'חסימת IP';
$string['iplookup'] = 'חיפוש כתובת IP';
$string['iplookupmaxmindnote'] = 'המוצר מכיל מידע GeoLite אשר נוצר ע"י MaxMind, זמין מ-<a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'הבדלה בין אותיות רשיות לרגילות בכל הנוגע לשמות תגיות';
$string['lang'] = 'שפת בררת־מחדל';
$string['langcache'] = 'תפריט שפות (מצב "מטמון")';
$string['langlist'] = 'שפות בתפריט השפות';
$string['langmenu'] = 'הצגת תפריט השפה';
$string['langpackwillbeupdated'] = 'הערה: במהלך השדרוג, Moodle ינסה להוריד ולהתקין עדכוני תרגום בהתאם לחבילת השפה שלכם.';
$string['langstringcache'] = 'מחרוזות תרגום שפת הממשק (מצב "מטמון")';
$string['languagesettings'] = 'הגדרות שפה';
$string['latinexcelexport'] = 'קידוד Excel';
$string['legacyfilesinnewcourses'] = 'יבוא קבצי קורס מגרסאות Moodle ישנות';
$string['legacyfilesinnewcourses_help'] = 'כבררת־המחדל, מנגנון תצוגת קבצי קורס ישנים אשר יובאו מקורסי מוודל בגרסאות 1.9, זמין רק כאשר משדרגם קורסים. שימו לב כי יתכן שמפסר יכולות (פעילויות או מאפיינים) לא יעבדו באופן תקין.';
$string['licensesettings'] = 'הגדרות רשיון';
$string['linkadmincategories'] = 'קישור לקטגוריות של מנהל המערכת';
$string['linkadmincategories_help'] = 'אם מאופשר, הגדרות הקטגוריות  יוצגו למנהל המערכת כקישורים בניווט של משבצת הניהול ויוביל לעמודים של קטגורית הניהול.';
$string['loading'] = 'טוען';
$string['localetext'] = 'הגדרות "מקומיות" עבור המערכת כולה';
$string['localstringcustomization'] = 'התאמת שפה מקומית';
$string['location'] = 'מיקום';
$string['locationsettings'] = 'הגדרות מיקום';
$string['locked'] = 'נעול';
$string['lockoutduration'] = 'משך נעילת חשבון';
$string['lockoutduration_desc'] = 'חשבון נעול משוחרר אוטומטית לאחר משך זמן זה.';
$string['lockoutemailsubject'] = 'החשבון שלכם ב- {$a} ננעל';
$string['lockoutthreshold'] = 'סף נעילת חשבון משתמש';
$string['log'] = 'יומני מעקב (logs)';
$string['logguests'] = 'דוח מעקב גישת אורח';
$string['logguests_help'] = 'הגדרה זו מאפשרת פעולות התחברות עבור חשבונות אורח ולא של משתמשים מחוברים, אתרים גדולים בעלי עומסים גדולים ינטו לכבות את ההגדרה הזו מסיבות ביצועי מערכת. ההמלצה היא להשאיר את ההגדרה הזו פעילה עבור אתרים רשמיים (פעילים)';
$string['loginhttps'] = 'שימוש ב-HTTPS עבור מנגנון ההזדהות (התחברות)';
$string['loginpageautofocus'] = 'מיקוד אוטומטי (Autofocus) בטופס עמוד התחברות';
$string['loginpageautofocus_help'] = 'איפשור הגדרה זו משפר את השימושיות של עמוד ההתחברות לאתר, אך שדות עם פוקוס אוטומטי יחשבו כנושא נגישות.';
$string['loginpasswordautocomplete'] = 'מניעת השלמה אוטומטית של הסיסמה בטופס ההתחברות';
$string['loginpasswordautocomplete_help'] = 'אם מאופשר, משתמשים לא יורשו לשמור את סיסמת חשבונם בדפדפן שלהם.';
$string['loglifetime'] = 'שמירת יומני המעקב למשך';
$string['logstorenotrequired'] = 'מאגר-ניטור לא נדרש';
$string['logstoressupported'] = 'מאגר-ניטור התומך בדוח זה';
$string['longtimewarning'] = '<b> אנא שים לב כי תהליך זה עלול לקחת זמן רב. </b>';
$string['maintenancemode'] = 'נמצא במצב תחזוקה';
$string['maintenancemodeisscheduled'] = 'אתר זה יועבר למצב תחזוקה בעוד {$a->min} דקות ו-{$a->sec} שניות';
$string['maintfileopenerror'] = 'שגיאה בפתיחת קבצי תחזוקה!';
$string['maintinprogress'] = 'מצב תחזוקה בפעולה...';
$string['manageformats'] = 'ניהול תבניות קורסים';
$string['manageformatsgotosettings'] = 'את תבנית בררת־המחדל ניתן לשנות ב- {$a}';
$string['managelang'] = 'ניהול';
$string['managelicenses'] = 'ניהול רשיונות';
$string['manageqbehaviours'] = 'ניהול התנהגויות שאלה';
$string['manageqtypes'] = 'ניהול סוגי שאלות';
$string['maturity100'] = 'בטה';
$string['maturity150'] = 'גירסה מועמדת לשחרור';
$string['maturity200'] = 'גירסה יציבה';
$string['maturity50'] = 'אלפא';
$string['maturityallowunstable'] = 'רמז: יש להריץ תסריט זה עם אפשרות  --allow-unstable';
$string['maturitycoreinfo'] = 'אתר זה פועל על בסיס קוד במצב "פיתוח"  "{$a}" ואינו מומלץ לשימוש כאתר פעיל לצורכי למידה/הוראה.';
$string['maturitycorewarning'] = 'גרסת ה-Moodle אותה הינך עומד להתקין או לשדרג מכילה קוד פיתוח "{$a}"  לא יציב אשר לא מותאם לשימוש ברוב האתרים הרשמיים. אם זהו אינו הדבר שרצית לעשות, אנא וודא כי הינך מעדכן מענף STABLE  של קוד ה-Moodle.
למידע נוסף ניתן לעיין ב-Moodle Docs.';
$string['maxbytes'] = 'גודל קבצים מועלים מירבי';
$string['maxconsecutiveidentchars'] = 'אותיות מזהות רצופות';
$string['maxeditingtime'] = 'זמן מירבי לעריכת הודעות';
$string['maxtimelimit'] = 'זמן מוגבל מירבי';
$string['maxusersperpage'] = 'מספר משתמשים מירבי לעמוד';
$string['mbstringrecommended'] = 'מתקין את ספריית MBSTRING האופציונלית מומלצת ביותר על-מנת לשפר את ביצועי האתר, במיוחד אם האתר נתמך בשפות לא-לטיניות.';
$string['mediapluginavi'] = 'אפשר מסנן avi.';
$string['mediapluginflv'] = 'אפשר מסנן flv.';
$string['mediapluginimg'] = 'איפשור שיבוץ אוטומטי של תמונות מקושרות';
$string['mediapluginmov'] = 'אפשר מסנן mov.';
$string['mediapluginmp3'] = 'אפשר מסנן mp3.';
$string['mediapluginmpg'] = 'אפשר מסנן mpg.';
$string['mediapluginogg'] = 'אפשר מסנן ogg.';
$string['mediapluginogv'] = 'אפשר מסנן ogv.';
$string['mediapluginram'] = 'אפשר מסנן ram.';
$string['mediapluginrm'] = 'אפשר מסנן rm.';
$string['mediapluginrpm'] = 'אפשר מסנן rpm.';
$string['mediapluginswf'] = 'אפשר מסנן swf.';
$string['mediapluginswfnote'] = 'כבררת־המחדל לאמצעי אבטחה, משתמשים לא יורשו לשבץ קבצי swf של "פלאש"';
$string['mediapluginwmv'] = 'אפשר מסנן wmv.';
$string['mediapluginyoutube'] = 'אפשר מסנן קישור "יוטיוב"';
$string['messaging'] = 'אפשר מערכת העברת הודעות בדרך אלקטרונית';
$string['messagingallowemailoverride'] = 'עקיפת הודעות דוא"ל';
$string['messagingdeletereadnotificationsdelay'] = 'מחיקת הודעות שנקראו';
$string['messaginghidereadnotifications'] = 'הסתרת הודעות שנקראו';
$string['minpassworddigits'] = 'ספרות';
$string['minpasswordlength'] = 'אורך הסיסמה';
$string['minpasswordlower'] = 'אותיות קטנות';
$string['minpasswordnonalphanum'] = 'סימנים שאינם ספרות או אותיות';
$string['minpasswordupper'] = 'אותיות רישיות';
$string['misc'] = 'שונות';
$string['mnetrestore_extusers'] = '<strong> הודעה: </strong>קובץ גיבוי זה מכיל חשבונות משתמש Moodle Network מרחוק אשר יאוחסן כחלק מהתהליך.';
$string['mnetrestore_extusers_mismatch'] = '<strong>הודעה: </strong> קובץ גיבוי זה לכאורה נוצר מהתקנת Moodle שונה ומכיל חשבונות משתמש Moodle Network מרחוק אשר עלול ליפול עבור שחזור. פעולה זו חסרת תמיכה. אם אתה בטוח שהקובץ כן נוצר בהתקנת Moodle זו, או שאתה יכול לוודא שכל Moodle Network Hosts הנחוצים מוגדרים, תוכל עדיין לנסות את השחזור.';
$string['mnetrestore_extusers_switchuserauth'] = 'משתמש מרוחק של Moodle Network
{$a->username} (מגיע מ- {$a->mnethosturl}) הוחלף לאימות משתמש מקומי   {$a->auth}';
$string['mobile'] = 'יישום Moodle לניידים';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'בררת־המחדל של בורר הפעילויות והמשאבים';
$string['modeditdefaults'] = 'ערך בררת־המחדל עבור הגדרות פעילות';
$string['modeditingmenu'] = 'תפריטי עריכת פעילות';
$string['modeditingmenu_desc'] = 'אם מאופשר, אז סמלי עריכת פעילות רבים יוצגו ברשימה נפתחת בעת צפייה בקורס כאשר העריכה מופעלת. אפשרות זו מקטינה את העומס במסך בעת עריכת הקורס על ידי הסתרת סמלים אלו עד שיש בהם צורך.';
$string['modsettings'] = 'ניהול פעילויות ומשאבים';
$string['modulesecurity'] = 'אבטחת רכיב';
$string['multilangforceold'] = 'הכרח תחביר ישן של שפות מרובות (multilang) : <span> ללא המחלקה : class="multilang" וגם
&lt;lang&gt;
 <lang>';
$string['mustenablestats'] = 'סטטיסטיקות לא אופשרו עדיין באתר זה';
$string['mycoursesperpage'] = 'מספר מירבי של קורסים';
$string['mydashboard'] = 'בררת־מחדל מערכתית לעמוד "עדכונים בקורסים שלי"';
$string['mymoodle'] = 'עמוד הבית שלי';
$string['mymoodleredirect'] = 'הכוונת משתמשים לצפיה בעמוד "עדכונים בקורסים שלי"';
$string['mypage'] = 'ברירת המחדל עבור עמוד הבית שלי';
$string['mypagelocked'] = 'נעילת עמוד בררת־המחדל';
$string['myprofile'] = 'עיצוב עמוד:<br>"הפרופיל שלי"';
$string['navadduserpostslinks'] = 'הוספת קישורים עבור צפייה בפרסומי משתמש';
$string['navadduserpostslinks_help'] = 'אם מאופשר, שני קישורים יוספו לכל משתמש בניווט בכדי לצפות בדיונים שהמשתמש החל בפורומים לרוחב כל האתר או בקורסים מסויימים.';
$string['navcourselimit'] = 'גבול קורס';
$string['navexpandmycourses'] = 'הצגת "הקורסים שלי" באופן מורחב בעמוד הבית';
$string['navexpandmycourses_desc'] = 'אם מאופשר, "הקורסים שלי" מאותחל באופן מורחב במשבצת הניווט בעמוד הבית.';
$string['navshowallcourses'] = 'הצגת כל הקורסים';
$string['navshowcategories'] = 'הצגת קטגוריות הקורס';
$string['navshowfrontpagemods'] = 'הצגת פעילויות עמוד ראשי בניווט';
$string['navshowfrontpagemods_help'] = 'אם מופעל, פעילויות עמוד הראשי יוצגו בניווט מתחת לעמודי האתר';
$string['navshowfullcoursenames'] = 'הצגת שמות מלאים של קורסים';
$string['navshowfullcoursenames_help'] = 'אם מאופשר, השם המלא של הקורס יופיע בניווט במקום השם המקוצר.';
$string['navshowmycoursecategories'] = 'הצגת קטגוריות הקורס שלי';
$string['navshowmycoursecategories_help'] = 'כאשר קיימים קורסים ברשימת "הקורסים שלי" הם יוצגו בקטגוריות קורסים';
$string['navsortmycoursessort'] = 'מיון הקורסים שלי';
$string['navsortmycoursessort_help'] = 'הגדרת מיון קורסים המוצגים בתפריט "הקורסים שלי" של משבצת הניווט. (בררת־המחדל מיון לפי א-ב)
ניתן לקבוע את המיון בעמוד הגדרות מערכת > קורסים > ניהול קורסים וקטגוריות.';
$string['neverdeleteruns'] = 'לעולם אל תמחק בדיקות ביצועים';
$string['nobookmarksforuser'] = 'אין לך סימניות.';
$string['nodatabase'] = 'אין מסד נתונים';
$string['nohttpsformobilewarning'] = 'מומלץ לאפשר תקשורת מאובטחת (https) הכוללת תעודת אישור דיגיטלית ברת-תוקף. היישום "מוודל לניידים" ינסה תחילה להשתמש בחיבור מאובטח.';
$string['nomissingstrings'] = 'אין מחרוזות חסרות';
$string['nonewsettings'] = 'לא נעשו כל שינויים חדשים בהגדרות במהלך שידרוג זה.';
$string['nonexistentbookmark'] = 'הסימניה אשר ביקשת לא קיימת.';
$string['noresults'] = 'לא נמצאות תוצאות';
$string['noroles'] = 'אין תפקידים';
$string['nosupportedlogstore'] = 'לא נמצא מאגר-ניטור נתמך';
$string['notifications'] = 'הודעות';
$string['notifyloginfailures'] = 'כשלונות התחברות לדוא"ל';
$string['notifyloginthreshold'] = 'ערך סף עבור הודעות דוא"ל';
$string['notloggedinroleid'] = 'תפקידים לאורחים';
$string['numberofmissingstrings'] = '{$a} מחרוזות עדיין חסרות';
$string['numberofstrings'] = 'סה"כ מספר מחרוזות: {$a->strings}<br />
חסר: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'התקנת ספרייה אופציונלית OpenSSL ממולצת מאוד -- מאפשרת את פנקציונליות Moodle Networking.';
$string['opentogoogle'] = 'פתח ל-Google';
$string['optionalmaintenancemessage'] = 'הודעה עבור "מצב תחזוקה"';
$string['order1'] = 'ראשון';
$string['order2'] = 'שני';
$string['order3'] = 'שלישי';
$string['order4'] = 'רביעי';
$string['passwordpolicy'] = 'מדיניות סיסמה';
$string['passwordresettime'] = 'הזמן המירבי למתן תוקף בקשת איפוס סיסמה';
$string['pathtoclam'] = 'נתיב לתוכנת אנטי-וירוס calm';
$string['pathtodot'] = 'נתיב לקבציי DOT';
$string['pathtodu'] = 'נתיב ל-du';
$string['pathtopgdump'] = 'נתיב ל-pg_dump';
$string['pathtopgdumpdesc'] = 'נחוץ עבור כניסה אם יש לך במערכת יותר מ-pg_dump אחד במערכת שלך (לדוגמה אם יש לך יותר מגירסה אחת מותקנת של postgresql)';
$string['pathtopgdumpinvalid'] = 'נתיב ל-pg_dump לא חוקי - או שהנתיב שגוי או שהוא לא ניתן לביצוע';
$string['pathtopsql'] = 'נתיב ל-psql';
$string['pathtopsqldesc'] = 'נחוץ עבור כניסה אם יש לך במערכת יותר מ-psql אחד במערכת שלך (לדוגמה אם יש לך יותר מגירסה אחת מותקנת של postgresql)';
$string['pathtopsqlinvalid'] = 'נתיב ל-psql לא חוקי - או שהנתיב שגוי או שהוא לא ניתן לביצוע';
$string['perfdebug'] = 'מידע על ביצועי המערכת';
$string['performance'] = 'ביצועים';
$string['pgcluster'] = 'אשכול PostgreSQL';
$string['pgclusterdescription'] = 'פרמטרי אשכול/גירסת PostgreSQL עבור פעולות בשורת הפקודה. אם יש לך רק postgresql אחד במערכת או שאינך בטוח בהגדרה זו, השאר תיבה זו ריקה.';
$string['phpfloatproblem'] = 'זוהתה בעיה בלתי צפויה לאחר טיפול במספרים מסוג float של PHP -
{$a}';
$string['pleaserefreshregistration'] = 'האתר שלך נרשם ל-moodle.org, אנא שקול לעדכן את הרישום שלך לאתר אם התבצעו שינויים משמעותיים מהפעם האחרונה ב-{$a}';
$string['pleaseregister'] = 'אנא רשום את האתר שלך כדי להסיר כפתור זה';
$string['plugin'] = 'תוסף';
$string['plugins'] = 'רכיבים';
$string['pluginscheck'] = 'בדיקת תלותיות הרכיב';
$string['pluginscheckfailed'] = 'בדיקת תלותיות הרכיב נכשלה עבור {$a->pluginslist}';
$string['pluginschecktodo'] = 'עליך לפתור את כל דרישות התוספים לפי המשך התקנת גרסת Moodle זו.';
$string['pluginsoverview'] = 'סקירת תוספי המערכת';
$string['pluginsoverviewsee'] = 'צפיה בדוח <a href="{$a->url}">סקירת תוספים</a> לקבלת פרטים נוספים.';
$string['profilecategory'] = 'קטגוריה';
$string['profilecategoryname'] = 'שם קטגוריה (חייב להיות ייחודי)';
$string['profilecategorynamenotunique'] = 'שם קטגוריה זה כבר נמצא בשימוש';
$string['profilecommonsettings'] = 'הגדרות שימוש';
$string['profileconfirmcategorydeletion'] = 'ישנו/ם שדה/ות {$a} בקטגוריה זו אשר יועברו לקטגוריה העליונה (או התחתונה אם היא נמצאת בראש הקטגוריה).<br> האם עדיין ברצונך למחוק את הקטגוריה';
$string['profileconfirmfielddeletion'] = 'ישנו/ם {$a} רשומות משתמש/ים עבור דשה זה אשר ימחקו.<br> האם ברצונך עדיין למחוק שדה זה?';
$string['profilecreatecategory'] = 'יצירת קטגוריית פרופיל חדשה';
$string['profilecreatefield'] = 'יצירת שדה פרופיל חדש';
$string['profilecreatenewcategory'] = 'יצירת קטגוריה חדשה';
$string['profilecreatenewfield'] = 'יצירת שדה פרופיל \'{$a}\' חדש';
$string['profiledefaultcategory'] = 'שדות אחרים';
$string['profiledefaultchecked'] = 'מסומן, כבררת־המחדל';
$string['profiledefaultdata'] = 'ערך בררת־המחדל';
$string['profiledeletecategory'] = 'מחיקת קטגוריה';
$string['profiledeletefield'] = 'מחיקת שדה  \'{$a}\'';
$string['profiledescription'] = 'תיאור שדה';
$string['profiledscript'] = 'לתסריט זה נקבע פרופיל';
$string['profiledscriptview'] = 'הצגת מידע הפרופיל לתסריט זה';
$string['profileeditcategory'] = 'עריכת קטגוריה';
$string['profileeditfield'] = 'עריכת שדה פרופיל: {$a}';
$string['profilefield'] = 'שדה פרופיל';
$string['profilefieldcolumns'] = 'עמודות';
$string['profilefieldispassword'] = 'האם זהו שדה סיסמה?';
$string['profilefieldlink'] = 'קישור';
$string['profilefieldlinktarget'] = 'קישור יעד';
$string['profilefieldmaxlength'] = 'אורך מירבי';
$string['profilefieldrows'] = 'שורות';
$string['profilefields'] = 'שדות פרופיל משתמש';
$string['profilefieldsize'] = 'תצוגת גודל';
$string['profileforceunique'] = 'האם הנתונים חייבים להיות יחודיים?';
$string['profileinvaliddata'] = 'ערך לא חוקי';
$string['profilelocked'] = 'האם שדה זה נעול?';
$string['profilemenudefaultnotinoptions'] = 'ערך בררת־המחדל אינו אחת מהאפשרויות';
$string['profilemenunooptions'] = 'לא הוזנו אפשרויות תפריט';
$string['profilemenuoptions'] = 'אפשרויות תפריט (אחת לכל שורה)';
$string['profilemenutoofewoptions'] = 'יש לספק לפחות 2 אפשרויות';
$string['profilename'] = 'שם';
$string['profilenofieldsdefined'] = 'לא הוגדרו שדות';
$string['profilerequired'] = 'האם שדה זה דרוש?';
$string['profileroles'] = 'התפקידים הגלויים של הפרופיל';
$string['profilesforenrolledusersonly'] = 'פרופילים עבור משתמשים רשומים בלבד';
$string['profileshortname'] = 'שם קצר באנגלית (חייב להיות ייחודי)';
$string['profileshortnamenotunique'] = 'שם קצר זה כבר בשימוש';
$string['profilesignup'] = 'האם להציג בדף הרישום?';
$string['profilespecificsettings'] = 'הגדרות תוכן';
$string['profilevisible'] = 'למי שדה זה גלוי';
$string['profilevisibleall'] = 'גלוי לכולם';
$string['profilevisible_help'] = '<p>לכל שדה מותאם אישית ניתן לתת אחת מתוך שלושת הגדרות הראות הבאות: בלתי נראה, כולם ומשתמש. הגדרת ה\'בלתי נראה\' תינתן לרוב על ידי מנהל שרוצה להסתיר מידע פרטי בנוגע למשתמשים. הגדרת ה\'משתמש\' תיבחר לרוב עבור שדה שמחזיק מידע רגיש, בעוד שבהגדרת ה\'כולם\' ניתן להשתמש עבור כל סוג של מידע.
</p>';
$string['profilevisiblenone'] = 'לא גלוי';
$string['profilevisibleprivate'] = 'גלוי למשתמש';
$string['profiling'] = 'בדיקות ביצועים';
$string['profilingallowall'] = 'בדיקות ביצועים מתמשכת';
$string['profilingallowme'] = 'בחירת בדיקות ביצועים ידנית';
$string['profilingautofrec'] = 'הצגת בדיקות ביצועים אוטומטית';
$string['profilingenabled'] = 'אפשר בדיקות ביצועים';
$string['profilingexcluded'] = 'מנע בדיקות ביצועים';
$string['profilingincluded'] = 'הצגת פרופיל של אלו';
$string['profilinglifetime'] = 'שמירת בדיקות ביצועים';
$string['profilinglifetime_help'] = 'ציין את משך זמן שברצונך לשמור מידע בעבור ריצות פרופילים ישנות.
ריצות ישנות יותר יסולקו באופן סדרתי. שים לב שזה לא כולל בדיקות ביצועים שסומנו כ \'בדיקות השוואה\'';
$string['protectusernames'] = 'שמות משתמשים מוגנים';
$string['proxybypass'] = 'מארחים העוקפים PROXY';
$string['proxyhost'] = 'ארוח Proxy';
$string['proxypassword'] = 'סיסמת Proxy';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'סוג Proxy';
$string['proxyuser'] = 'שם משתמש ה-Proxy';
$string['purgecaches'] = 'מחיקת כל המטמונים';
$string['purgecachesfinished'] = 'כל המטמונים נמחקו';
$string['quarantinedir'] = 'ספריית הסגר';
$string['question'] = 'שאלה';
$string['questionbehaviours'] = 'התנהגות שאלה';
$string['questioncwqpfscheck'] = 'שאלה \'אקראית\' אחת או יותר בבוחן הופעלו בכדי לבחור שאלות מתערובת של שאלות מקטגוריות משותפות ולא משותפות. דוח מפורט יותר ימצא <a href="{$a->reporturl}">כאן</a>. ראה גם את דף התיעוד של Moodle <a href="{$a->docsurl}">כאן</a>.';
$string['questioncwqpfsok'] = 'טוב. אין שאלות \'אקראיות\' בבחנים שלך שנבנו בכדי לבחור שאלות מתוך תעובת של שאלות מקטגוריות משותפות ולא משותפות.';
$string['questiontype'] = 'סוג השאלה';
$string['questiontypes'] = 'סוגי השאלה';
$string['recaptchaprivatekey'] = 'המפתח הפרטי של  ReCAPTCHA';
$string['recaptchapublickey'] = 'המפתח הציבורי של ReCAPTCHA';
$string['register'] = 'רישום האתר ל Moodle.org';
$string['registermoodleorg'] = 'כאשר אתה רושם את האתר שלך';
$string['registerwithmoodleorg'] = 'רשום את האתר שלך';
$string['registration'] = 'רישום ל Moodle.org';
$string['registrationwarning'] = 'מערכת זו טרם בצעה רישום באתר Moodle העולמי';
$string['releasenoteslink'] = 'לצפיה ברשימת העדכונים של גרסאת Moodle זו, אנא בקרו בעמוד: <a target="new" href="{$a}"> דוח שחרור הגרסה </a>';
$string['rememberusername'] = 'זכור שם משתמש/ת';
$string['rememberusername_desc'] = 'ניתן לאפשר כאשר ברצונך לאחסן עוגיות קבועות עם שמות משתמש בעת התחברות המשתמש. עוגיות קבועות יחשבו כנושאה פרטיות אם ישומשו ללא אישור.';
$string['reportsmanage'] = 'ניהול דוחות';
$string['requestcategoryselection'] = 'לאפשר בחירת קטגוריה';
$string['requiremodintro'] = 'נדרש תיאור פעילות';
$string['requires'] = 'נדרשים';
$string['restorecourse'] = 'שחזור קורס';
$string['restorernewroleid'] = 'תפקיד שחזורים בקורסים';
$string['reverseproxy'] = 'Proxy הפוך';
$string['riskconfig'] = 'משתמשים יכולים לשנות הגדרות והתנהגות האתר';
$string['riskconfigshort'] = 'סיכון שיבוש הגדרות מערכת';
$string['riskdataloss'] = 'משתמשים עלולים לשבש כמויות גדולות של תכנים או מידע';
$string['riskdatalossshort'] = 'סיכון אובדן מידע';
$string['riskmanagetrust'] = 'משתמשים יכולים לשנות את הגדרות האמון של משתמשים אחרים';
$string['riskmanagetrustshort'] = 'ניהול מערכת האמון';
$string['riskpersonal'] = 'משתמשים יכולים להשיג גישה למידע אישי של משתמשים אחרים';
$string['riskpersonalshort'] = 'סיכון אובדן פרטיות';
$string['riskspam'] = 'משתמשים יכולים לשלוח דואר זבל למשתמשי האתר או לאחרים';
$string['riskspamshort'] = 'סכנת דואר זבל';
$string['riskxss'] = 'משתמשים יכולים להוסיף קבצים ותוכן אשר מאפשרים שיבוץ יישומים זדוניים
XSS = cross-site-script';
$string['riskxssshort'] = 'סכנת שיבוץ יישום זדוני XSS';
$string['roleswithexceptions'] = '{$a->roles},עם {$a->exceptions}';
$string['rssglobaldisabled'] = 'נטרל בצד השרת';
$string['runclamavonupload'] = 'השתמש בתוכנת אנטי-וירוס calm על קבצים שהועלו';
$string['save'] = 'שמירה';
$string['savechanges'] = 'שמירת שינויים';
$string['search'] = 'חפש';
$string['searchinsettings'] = 'חיפוש בהגדרות';
$string['searchresults'] = 'חיפוש תוצאות';
$string['sectionerror'] = 'שגיאה בקטע';
$string['secureforms'] = 'השתמש בתוספות אבטחה';
$string['security'] = 'אבטחה';
$string['selectdevice'] = 'בחירת התקן';
$string['selecttheme'] = 'בחירת ערכת נושא עבור התקן {$a}';
$string['server'] = 'שרת';
$string['serverchecks'] = 'בדיקות שרת';
$string['serverlimit'] = 'הגבלת שרת';
$string['sessioncookie'] = 'תחילית ה"עוגיה"';
$string['sessioncookiedomain'] = 'שם־מתחם ה"עוגיה"';
$string['sessioncookiepath'] = 'נתיב ה"עוגיה"';
$string['sessionhandling'] = 'נתוניי־חיבור־משתמש (session)';
$string['sessiontimeout'] = 'משך זמן חיבור מירבי של משתמש (ללא פעילות)';
$string['settingfileuploads'] = 'העלאת קבצים נדרשת עבור פעולה רגילה, אנא אפשר אותה בקובץ הגדרות ה-PHP.';
$string['settingmemorylimit'] = 'זכרון לקוי נמצא, אנא כוונן גבול זכרון גבוה יותר (Memory Limit) בקובץ הגדרות ה-PHP.';
$string['settingsafemode'] = 'Moodle אינו מותאם באוםן מלא עם מצב בטוח, אנא בקש ממנהל המערכת לכבות אפשרות זו. ריצת Moodle תחת מצב בטוח איננה נתמכת, נא צפה לבעיות שאינן צפויות.';
$string['showcommentscount'] = 'הצגת כמות הערות';
$string['showdetails'] = 'הצגת פרטים';
$string['showuseridentity'] = 'הצגת זהות המשתמש';
$string['simplexmlrequired'] = 'הרחבת ה-SimpleXML PHP נדרשת כעת ב-Moodle.';
$string['sitemaintenance'] = 'אתר זה עובר כרגע פעולות תחזוקה ואינו זמין';
$string['sitemaintenancemode'] = 'מצב תחזוקה';
$string['sitemaintenanceoff'] = 'מצב תחזוקה בוטל, וכעת האתר פועל שוב כרגיך';
$string['sitemaintenanceon'] = 'מצב תחזוקה מופעל כרגע באתר (רק מנהלים יכולים להתחבר לאתר)';
$string['sitemaintenancewarning'] = 'מצב תחזוקה מופעל כרגע באתר (רק מנהלים יכולים להתחבר לאתר). להחזרת האתר למצבו הרגיל, <a href="maintenance.php">בטל את מצב התחזוקה</a>.';
$string['sitemaintenancewarning2'] = 'האתר עבר למצב תחזוקה ( רק מנהלים יכולים להתחבר). חזרה למצב רגיל נא
, <a href="{$a}">כבה את מצב התחזוקה</a>.';
$string['sitepolicies'] = 'מדיניות המערכת';
$string['sitepolicy'] = 'ה-URL שמצביע על מדיניות המערכת';
$string['sitepolicyguest'] = 'כתובת ה-URL של מדיניות המערכת עבור אורחים.';
$string['sitepolicyguest_help'] = 'אם ישנה מדיניות אתר אשר כל האורחים חייבים לצפות ולהסכים לפני השימוש באתר, אנא ציין את כתובת ה-URL כאן. אחרת השאר ריק. הגדרה זו יכולה להכיל כל כתובת URL ציבורית.
זכור: גישה למשתמשים שאינם מחוברים יכולה להימנע עם הגדרת הכרח ההתחברות - forcelogin.';
$string['sitepolicy_help'] = 'אם יש לך מדיניות אתר אשר כל המשתמשים מחוייבים לראות ולהסכים לפני השימוש באתר, הכנס את הקישור לכאן, אחרת השאר כאן חלל ריק. הקישור URL יכול להצביע לכל מקום - מקום נוח למשל יהיה קובץ הנמצא כבר בקבצי האתר. דוגמה - http://yoursite/file.php/1/policy.html';
$string['sitesectionhelp'] = 'מאפשר תצוגה של פעילויות ומשאבים בחלק המרכזי של העמוד הראשי';
$string['slasharguments'] = 'שימוש במשתנים מופרדים בלוכסאנים בכתובת המערכת';
$string['smartpix'] = 'חיפוש Smart pix';
$string['soaprecommended'] = 'התקנת הרחבת SOAP האופציונלית שימושית עבור web services ומודולים אחרים.';
$string['sort_fullname'] = 'שם מלא של הקורס';
$string['sort_idnumber'] = 'מספר זיהוי קורס';
$string['sort_shortname'] = 'שם מקוצר של הקורס';
$string['sort_sortorder'] = 'סדר המיון';
$string['spellengine'] = 'מנוע Spell';
$string['spelllanguagelist'] = 'רשימת בדיקות שפה';
$string['splrequired'] = 'התוסף SPL של PHP נדרש ע"י מערכת Moodle';
$string['stats'] = 'סטטיסטיקות';
$string['statsfirstrun'] = 'רווח עיבוד מירבי';
$string['statsmaxruntime'] = 'זמן ריצה מירבי';
$string['statsmoodleorg'] = 'סטטיסטיקות';
$string['statsruntimedays'] = 'ימים עבור התהליך';
$string['statsruntimestart'] = 'ריצה ב';
$string['statsuserthreshold'] = 'סף משתמש';
$string['stickyblocks'] = 'משבצות דביקות';
$string['stickyblockscourseview'] = 'דף קורס';
$string['stickyblocksduplicatenotice'] = 'באם המשבצת מתווספת כאן כבר קיים בדף כל שהוא, אזי תתבצע הופעה נוספת שלה. רק משבצות דביקות תהינה בלתי ניתנות לעריכה, המשבצת הנוספת תהיה ברת עריכה';
$string['stickyblocksmymoodle'] = 'עדכונים בקורסים שלי';
$string['stickyblockspagetype'] = 'סוג דף לשם עיצוב';
$string['strictformsrequired'] = 'אימות קפדני של השדות הדרושים';
$string['stripalltitletags'] = 'הסר תגי HTML מכל שמות הפעילויות';
$string['supportcontact'] = 'יצירת קשר לתמיכה';
$string['supportemail'] = 'דוא"ל התמיכה';
$string['supportname'] = 'שם התמיכה';
$string['supportpage'] = 'דף התמיכה';
$string['suspenduser'] = 'השהה חשבון משתמש';
$string['switchlang'] = 'החלף ספריית lang';
$string['systempaths'] = 'נתיבי מערכת';
$string['tablenosave'] = 'שינויים בטבלה מעל נשמרים אוטומטית';
$string['tablesnosave'] = 'שינויים בטבלה מעל נשמרים אוטומטית';
$string['tabselectedtofront'] = 'בטבלאות עם לשוניות, האם יש למקם מקדימה את השורה עם התגית הנבחרת';
$string['tabselectedtofronttext'] = 'הבאת שורת הלשונית הנבחרת קדימה';
$string['taskautomatedbackup'] = 'גיבויים אוטומטיים';
$string['taskbackupcleanup'] = 'ניקוי טבלאות גיבוי ויומני מעקב';
$string['taskbadgescron'] = 'הענקת הישגים';
$string['taskblogcron'] = 'סנכרון בלוגים חיצוניים';
$string['taskcachecleanup'] = 'הסר רשומות מטמונים שפג תוקפן';
$string['taskcachecron'] = 'עיבוד ברקע עבור מטמונים';
$string['taskcalendarcron'] = 'שליחת הודעות עדכונים ללוח השנה';
$string['taskcheckforupdates'] = 'בדוק עדכונים';
$string['taskcompletioncron'] = 'חשב נתוני השלמה';
$string['taskcontextcleanup'] = 'נקה הקשרים';
$string['taskcreatecontexts'] = 'צור הקשר חסרים';
$string['taskdeletecachetext'] = 'מחק רשומות מטמוני מלל ישנות';
$string['taskdeleteincompleteusers'] = 'מחק משתמשים לא מלאים';
$string['taskdeleteunconfirmedusers'] = 'מחק משתמשים שלא אישרו רישום';
$string['taskeventscron'] = 'עיבוד ברקע של אירועי מערכת';
$string['taskfiletrashcleanup'] = 'נקה קבצים בפח האשפה';
$string['taskgradecron'] = 'עיבוד ברקע של גיליון הציונים';
$string['taskmessagingcleanup'] = 'עיבוד ברקע של מסרים';
$string['taskpasswordresetcleanup'] = 'נקה ניסיונות איפוס סיסמא';
$string['taskplagiarismcron'] = 'עיבוד ברקע של תוספי גניבה ספרותית';
$string['taskquestioncron'] = 'עיבוד ברקע של מנוע השאלות';
$string['taskregistrationcron'] = 'רישום האתר';
$string['tasksendfailedloginnotifications'] = 'שליחת הודעות עבור כניסות לא תקינות לאתר';
$string['tasksendnewuserpasswords'] = 'שליחת סיסמאות משתמש חדשות';
$string['tasksessioncleanup'] = 'ניקוי נתוניי־חיבור־משתמש';
$string['taskstatscron'] = 'עיבוד ברקע של סטטיסטיקה';
$string['tasktagcron'] = 'עיבוד ברקע של תגיות';
$string['tasktempfilecleanup'] = 'מחיקת קבצים זמניים שאינם בשימוש';
$string['testsiteupgradewarning'] = 'הינך משתמש באתר הנסיוני {$a}, בכדי לשדרגו בצורה מיטבית עליך להשתמש בכלי ממשק של שורת פקודה (command line).';
$string['themedesignermode'] = 'מצב עיצוב ערכת הנושא';
$string['themelist'] = 'רשימת ערכת הנושאים';
$string['themenoselected'] = 'לא נבחרה ערכת נושא';
$string['themeresetcaches'] = 'ניקוי מטמונים של ערכות הנושא';
$string['themeselect'] = 'שינוי ערכת נושא';
$string['themeselector'] = 'בחירת ערכת נושא';
$string['themesettings'] = 'הגדרות ערכת הנושא';
$string['therewereerrors'] = 'נמצאו שגיאות במידע שלך';
$string['thirdpartylibrary'] = 'סיפריה';
$string['thirdpartylibrarylocation'] = 'מיקום';
$string['thirdpartylibs'] = 'סיפריות צד שלישי';
$string['timezone'] = 'בררת־המחדל של איזור הזמן';
$string['timezoneforced'] = 'אילוץ זה נקבע ע"י המנהל';
$string['timezoneisforcedto'] = 'אלץ את כל המשתמשים להשתמש';
$string['timezonenotforced'] = 'משתמשים יכולים לבחור את איזור הזמן שלהם';
$string['tokenizerrecommended'] = 'התקנת תוספת אופציונלית של PHP Talkenizer';
$string['tools'] = 'כלי ניהול מערכת';
$string['toolsmanage'] = 'הגדרות כלי ניהול';
$string['unattendedoperation'] = 'פעולה ללא השגחה';
$string['unbookmarkthispage'] = 'בטל סימון עמוד זה';
$string['unicoderequired'] = 'מומלץ לאחסן את כל המידע שלך בתסדיר - Uniucode. התקנות חדשות חייבות להופיע במסדי הנתונים אשר להם קבוצת התווים כבררת־מחדל המתאימה ל-Unicode. בעת שדרוג, יוצג ה: UTF-8 migration process (ראה בדף מנהל המערכת).';
$string['uninstallplugin'] = 'הסרה';
$string['unlockaccount'] = 'שחרור נעילת חשבון';
$string['unsettheme'] = 'ביטול הגדרות ערכת נושא';
$string['unsupported'] = 'חסר תמיכה';
$string['unsupportedphpversion7'] = 'גרסה 7 של PHP אינה נתמכת.';
$string['unsuspenduser'] = 'הפעלת חשבון המשתמש';
$string['updateaccounts'] = 'עדכון חשבונות קיימים';
$string['updateautocheck'] = 'בדיקת זמינות עידכונים אוטומטית';
$string['updateautodeploy'] = 'לאפשר הפעלת עדכונים';
$string['updateavailable'] = 'נמצאה גרסת Moodle חדשה והיא זמינה!';
$string['updateavailabledetailslink'] = 'כנס ל- {$a->url} לצפיה בפרטים נוספים';
$string['updateavailableforplugin'] = 'ישנם מספר עידכונים זמינים עבור כמה מהרכיבים';
$string['updateavailableinstall'] = 'להתקין עדכון זה';
$string['updateavailable_moreinfo'] = 'מידע נוסף...';
$string['updateavailablenot'] = 'קוד ה-Moodle שלך עדכני!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'גרסה Version {$a}';
$string['updatecomponent'] = 'עדכון רכיבים';
$string['updateminmaturity'] = 'נדרש ידע והבנה בקוד';
$string['updatenotifications'] = 'הודעות עדכוני מערכת';
$string['updatenotificationsubject'] = 'עדכונים עבור אתר Moodle הבא זמינים ({$a->siteurl})';
$string['updatenotifybuilds'] = 'תזכורות עבור עדכונים חדשים';
$string['upgradeerror'] = 'שגיאת שדרוג בלתי ידועה {$a->plugin} עבור גרסה {$a->version}, לא ניתן להמשיך.';
$string['upgradeforumread'] = 'תכונה חדשה החל מגירסה 1.5 של Moodle מאפשרת למשתמשים לעקוב אחרי הודעות שנקראו/לא נקראו בפורומים.<br />לאפשור תכונה זו עליך <a href="{$a}">לעדכן את טבלאות מסד הנתונים</a>.';
$string['upgradeforumreadinfo'] = 'מאפיין חדש נוסף ב Moodle 1.5 לרצועת פרסומי הפורום אשר נקראו/לא נקראו. בכדי להשתמש בפונקציונליות זו תצטרף לעדכן את הטבלאות שלך עם כל רצועות המידע של הפרסומי הפורום הקיימים. דבר זה עלול לקחת זמן רב (אף שעות) תלוי בגודלו של האתר שלך בנוסף עלול להכביד על מסד הנתונים, לכן ממולץ לעשות זאת בתקופה נטולץ עומס. בכל אופן האתר שלך ימשיך לתפקד במשך שדרוג זה ומשתמשים לא יושפעו מכך. ברגע שהתחלת תהליך זה תיהיה מוכרח להמשיכו עד לסיומו(השאר את חלון הדפדפן פתוח). בכל אופן, אם תפסיק את תהליך זה ע"י סגירת החלון: אל תדאג, תוכל להתחיל זאת מחדש. האם תרצה להתחיל את השדרוג התהליך עכשיו?';
$string['upgradelogs'] = 'להפעלת מלוא היכולות, יומני המעקב הישנים שלך צריכים להתעדכן. <a href="{$a}"> מידע נוסף</a>';
$string['upgradelogsinfo'] = 'לאחרונה נעשו מספר שינויים לאופן שבו נשמרים יומני המעקב. על מנת לאפשר צפיה בדוחות הישנים בחלוקה לפי פעילות, יש לשדרג את יומני המעקב הישנים שלך. כתלות באתר, פעולה זו יכולה לקחת זמן רב (לדוגמה מספר שעות) ולצרוך הרבה משאבים מבסיס הנתונים של אתרים גדולים. מרגע שהתחלת תהליך זה, רצוי לתת לו לסיים (על ידי השארת חלון הדפדפן פתוח). אל תדאג - האתר שלך יהיה זמין למבקרים אחרים בזמן שיומני המעקב מתעדכנים.<br /><br /> האם אתה רוצה לעדכן את יומני המעקב שלך כעת?';
$string['upgradepluginsfirst'] = 'עליך להוריד ולהתקין עדכונים זמינים בצורה ידנית';
$string['upgradepluginsinfo'] = 'מעדכן תוספים';
$string['upgradepluginsinfo_help'] = 'ישנן מספר עדכונים לכמה תוספים. Moodle לא מעדכן אותם בצורה אוטומטית. עליך להוריד את העדכונים ולהתקינם בשרת בעצמך.';
$string['upgradesettings'] = 'הגדרות חדשות';
$string['upgradesettingsintro'] = 'הגדרות המוצגות להלן נוספו במשך שדרוג האחרון של ה-Moodle שלך';
$string['upgradestalefiles'] = 'נמצאו גרסאות מעורבות של Moodle , לא ניתן להמשיך בשדרוג';
$string['upgradestart'] = 'שדרוג מסד הנתונים של Moodle';
$string['upgradesure'] = 'קבצי ה-Moodle הישנים שלך שונו, וכעת תוכנת השרת שלך תעודכן באופן אוטומטי לגירסה זו:
<p><b>{$a}</b></p>
<p>מרגע ביצוע השדרוג לא תוכל לחזור לגירסה קודמת.</p>
<p>האם אתה בטוח ברצונך לשדרג את תוכנת השרת לגירסה זו?</p>';
$string['upgradetimedout'] = 'השדרוג פסק מלפעול, נא להפעיל מחדש את השדרוג';
$string['upgradingdata'] = 'משדרג מידע';
$string['upgradinglogs'] = 'משדרג יומני מעקב (logs)';
$string['upgradingversion'] = 'משדרג לגרסה חדשה';
$string['upwards'] = 'כלפי מעלה';
$string['useblogassociations'] = 'אפשר אסוציאציות';
$string['useexternalyui'] = 'השתמש בספריות אונליין של YUI';
$string['user'] = 'משתמש';
$string['userbulk'] = 'ניהול חתך';
$string['userdefaultpreferences'] = 'מאפייני בררת־המחדל של משתמש';
$string['userlist'] = 'רשימת משתמשים';
$string['userpolicies'] = 'מדיניות משתמש';
$string['userpreference'] = 'העדפת המשתמש';
$string['userquota'] = 'מכסת משתמש';
$string['users'] = 'משתמשים';
$string['usesitenameforsitepages'] = 'השתמש בשם האתר עבור עמודי האתר';
$string['usetags'] = 'אפשר שימוש בתגים';
$string['validateerror'] = 'ערך זה אינו תקף';
$string['verifychangedemail'] = 'הגבלת שם-מתחם (Domain) כאשר קיים שינוי בדוא"ל';
$string['warningcurrentsetting'] = 'ערך נוכחי לא תקף.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'אנא מלא את אפשרויות הבאות במקרה ושרת ה-Moodle שלך לא מצליח לגשת ישירות לרשת האינטרנט. גישת אינטרנט צריכה להתאפשר להורדת מידע הסביבה, חבילות שפה, הזנות RSS, איזורי זמן, וכו\'. </br><em> הרחבת PHP cURL מומלץ להתקנה לצורך כך. </em>';
$string['xmlrpcrecommended'] = 'התקנת הרחבת ה-xmlrpc  נדרשת לצורך שרת קורסים (hub), הדבר חיוני עבור פונקציונליות של  web services ושל Moodle Networking.';
$string['yuicomboloading'] = 'YUI combo loading';
$string['ziprequired'] = 'הרחבת The Zip PHP נדרשת ע"י Moodle, ספריות PclZip  או info-ZIP binaries לא בשימוש יותר.';
