<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'it', branch 'MOODLE_28_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Accesso negato';
$string['accounts'] = 'Profili';
$string['addcategory'] = 'Aggiungi categoria';
$string['additionalhtml'] = 'HTML aggiuntivo';
$string['additionalhtml_desc'] = 'Le impostazioni seguenti consentono di aggiungere codice HTML che sarà incluso in tutte le pagine. E\' possibile specificare codice HTML da inserire all\'interno del tag HEAD, all\'interno del corpo pagina dopo l\'apertura del tag BODY oppure subito prima della chiusura del tag BODY.<br />Le impostazioni consentono di aggiungere intestazioni o piè di pagina personalizzati su tutte le pagine, oppure di aggiungere servizi quali Google Analytics con facilità ed indipendentemente dal tema utilizzato.';
$string['additionalhtmlfooter'] = 'Prima della chiusura del tag BODY';
$string['additionalhtmlfooter_desc'] = 'Il codice HTML verrà aggiunto in tutte le pagine prima della chiusura del tag BODY.';
$string['additionalhtmlhead'] = 'All\'interno del tag HEAD';
$string['additionalhtmlhead_desc'] = 'Il codice HTML verrà aggiunto in tutte le pagine al termine del tag HEAD.';
$string['additionalhtml_heading'] = 'Il codice HTML da aggiungere in tutte le pagine.';
$string['additionalhtmltopofbody'] = 'All\'apertura del tag BODY';
$string['additionalhtmltopofbody_desc'] = 'Il codice HTML verrà aggiunto in tutte le pagine subito dopo l\'apertura del tag BODY.';
$string['admincategory'] = 'Categoria: {$a}';
$string['adminseesall'] = 'Gli amministratori visualizzano qualsiasi evento';
$string['adminseesallevents'] = 'Gli amministratori visualizzano tutti gli eventi';
$string['adminseesownevents'] = 'Gli amministratori visualizzano solo i propri eventi';
$string['advancedfeatures'] = 'Funzionalità avanzate';
$string['allcountrycodes'] = 'Elenco codici nazione';
$string['allowbeforeblock'] = 'Elabora per primo l\'elenco degli IP autorizzati';
$string['allowbeforeblockdesc'] = 'Per default l\'elenco degli IP bloccati verrà elaborato per primo. Abilitando questa opzione, sarà elaborato per primo l\'elenco degli IP autorizzati.';
$string['allowblockstodock'] = 'Consenti ai blocchi di usare il dock';
$string['allowcategorythemes'] = 'Consenti la scelta dei temi per le categorie';
$string['allowcoursethemes'] = 'Consenti la scelta dei temi per i corsi';
$string['allowediplist'] = 'Elenco degli IP autorizzati';
$string['allowemailaddresses'] = 'Domini di posta autorizzati';
$string['allowframembedding'] = 'Consenti l\'embed in frame';
$string['allowframembedding_help'] = 'Consenti di incorporare questo sito dentro frame di altri siti.
Per motivi di sicurezza si sconsiglia l\'uso di questa impostazione.';
$string['allowguestmymoodle'] = 'Consenti agli ospiti l\'accesso a My home';
$string['allowobjectembed'] = 'Consenti i tag EMBED e OBJECT';
$string['allowthemechangeonurl'] = 'Consenti il cambio del tema tramite URL';
$string['allowuserblockhiding'] = 'Consenti agli utenti di nascondere i blocchi';
$string['allowuserswitchrolestheycantassign'] = 'Consenti agli utenti che non hanno il privilegio di attribuire ruoli di cambiare ruolo.';
$string['allowuserthemes'] = 'Consenti agli utenti di scegliere il tema';
$string['alternativefullnameformat'] = 'Formato alternativo del nome completo';
$string['alternativefullnameformat_desc'] = 'Imposta la visualizzazione del nome completo per i ruoli che hanno il privilegio "viewfullnames" (per default i ruoli manager, docente e docente non editor). I segnaposto utilizzabili sono gli stessi dell\'impostazione "Formato del nome completo"';
$string['antivirus'] = 'Anti-Virus';
$string['appearance'] = 'Aspetto';
$string['aspellpath'] = 'Percorso per aspell';
$string['authentication'] = 'Autenticazione';
$string['authpreventaccountcreation'] = 'Evita la creazione di account all\'atto dell\'autenticazione';
$string['authpreventaccountcreation_help'] = 'Un utente privo di account che si autentica tramite sistemi esterni (ad esempio LDAP), vedrà il suo account creato automaticamente. L\'impostazione è utile per impedire che gli account vengano creati automaticamente, consentendo l\'accesso solo agli account già esistenti. Sarà necessario creare gli account manualmente o caricarli tramite la funzione Importa utenti. L\'impostazione non ha effetto sulla autenticazione MNet';
$string['authsettings'] = 'Gestione autenticazione';
$string['autolang'] = 'Rilevazione automatica della lingua';
$string['autologinguests'] = 'Login automatico per gli ospiti';
$string['availablelicenses'] = 'Licenze disponibili';
$string['availableto'] = 'Disponibile per';
$string['backgroundcolour'] = 'Colore trasparente';
$string['backups'] = 'Backup';
$string['backup_shortname'] = 'Utilizza il titolo del corso nel nome del file di backup';
$string['backup_shortnamehelp'] = 'Utilizza il titolo del corso come parte del nome del file di backup.';
$string['badwordsconfig'] = 'Inserire l\'elenco personalizzato delle parole da censurare. Ciascuna parola deve essere separata dalle altre con una virgola.';
$string['badwordsdefault'] = 'In mancanza dell\'elenco personalizzato verrà utilizzato l\'elenco di default preso dal Language Pack.';
$string['badwordslist'] = 'Elenco personalizzato delle parole da censurare';
$string['blockediplist'] = 'Elenco degli IP bloccati';
$string['blockeditingmenu'] = 'Menu modifica blocchi';
$string['blockeditingmenu_desc'] = 'La maggior parte delle icone di modifica dei blocchi visualizzate quando la modifica è attiva saranno visualizzate all\'interno di un menu a discesa, riducendo l\'affollamento di icone nello schermo.';
$string['blockinstances'] = 'Istanze';
$string['blockmultiple'] = 'Multiplo';
$string['blockprotect'] = 'Proteggi istanze';
$string['blockprotect_help'] = 'Il bloccaggio impedisce l\'aggiunta o l\'eliminazione delle istanze dei blocchi. (Puoi sbloccare il tipo se devi modificare un\'istanza).

Lo scopo è quello di evitare l\'eliminazione accidentale di quei blocchi difficili da ripristinare, come il blocco Navigazione ed il blocco Impostazioni.';
$string['blocksettings'] = 'Gestione blocchi';
$string['blockunprotect'] = 'Rimuovi protezione';
$string['bloglevel'] = 'Visibilità del Blog';
$string['bookmarkadded'] = 'Segnalibro aggiunto.';
$string['bookmarkalreadyexists'] = 'Questa pagina è già presente nei tuoi segnalibri.';
$string['bookmarkdeleted'] = 'Segnalibro eliminato.';
$string['bookmarkthispage'] = 'Aggiungi pagina nei segnalibri';
$string['cacheapplication'] = 'Cache applicazione';
$string['cacheapplicationhelp'] = 'Gli elementi presenti in cache sono condivisi tra tutti gli utenti e scadono dopo un determinato "time to live" (ttl)';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'La cache e la compressione dei Javascript velocizza notevolmente il caricamento delle pagine ed è fortemente consigliato per i siti in produzione. Per gli sviluppatori è preferibile disabilitare l\'impostazione.';
$string['cacherequest'] = 'Request cache';
$string['cacherequesthelp'] = 'Cache specifiche dell\'utente che scadono al completamento del request. Utili per rimpiazzare aree dove vengono usati store statici';
$string['cachesession'] = 'Cache sessioni';
$string['cachesessionhelp'] = 'Cache specifiche dell\'utente che scadono al termine della sessione. Utili per ridurre problemi di sessione.';
$string['cachesettings'] = 'Impostazioni cache';
$string['caching'] = 'Caching';
$string['calendarexportsalt'] = 'Seme per l\'esportazione del calendario';
$string['calendarsettings'] = 'Calendario';
$string['calendartype'] = 'Tipo di calendario';
$string['calendartype_desc'] = 'Il calendario di default per il sito. Questa impostazione può essere modificata nelle impostazioni del corso oppure da ciascun utente nel proprio profilo.';
$string['calendar_weekend'] = 'Giorni del weekend';
$string['cannotdeletemodfilter'] = 'Non puoi disinstallare \'{$a->filter}\' in quanto fa parte del modulo \'{$a->module}\'.';
$string['cannotuninstall'] = 'Non è possibile disinstallare {$a}';
$string['cfgwwwrootslashwarning'] = 'Nel file config.php $CFG->wwwroot è stato definito in modo errato. E\' stato incluso un carattere \'/\' alla fine. Deve essere rimosso o si verificheranno errori imprevisti come <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Nel file config.php $CFG->wwwroot è stato definito in modo errato. Non corrisponde al URL usato per accedere a questa pagina. Deve essere modificato o si verificheranno errori imprevisti come <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'cambia';
$string['checkboxno'] = 'No';
$string['checkboxyes'] = 'Si';
$string['choosefiletoedit'] = 'Scegli un file da modificare';
$string['clamfailureonupload'] = 'In caso di errore di Clam AV';
$string['cleanup'] = 'Pulizia';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 's';
$string['cliincorrectvalueerror'] = 'Errore, il valore "{$a->value}" non è corretto per "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Valore non corretto, per favore riprova';
$string['clistatusdisabled'] = 'Stato: disabilitato';
$string['clistatusenabled'] = 'Stato: abilitato';
$string['clistatusenabledlater'] = 'stato: la modalità manutenzione CLI sarà attivata su {$a}';
$string['clitypevalue'] = 'inserisci valore';
$string['clitypevaluedefault'] = 'inserisci un valore oppure premi Invio per usare il valore di default ({$a})';
$string['cliunknowoption'] = 'Opzioni non riconosciute:
{$a}
. Per favore utilizza l\'opzione --help.';
$string['cliupgradefinished'] = 'L\'aggiornamento via linea di comando è stato completato correttamente.';
$string['cliupgradenoneed'] = 'Non sono necessari aggiornamenti per la versione installata: {$a}. Grazie comunque per la verifica!';
$string['cliyesnoprompt'] = 'inserisci s (per Si) o n (per No)';
$string['commentsperpage'] = 'Commenti visualizzati per pagina';
$string['commonfiltersettings'] = 'Impostazioni comuni dei filtri';
$string['commonsettings'] = 'Impostazioni comuni';
$string['componentinstalled'] = 'Componente installato';
$string['computedfromlogs'] = 'Calcolato dal log a partire da {$a}';
$string['condifmodeditdefaults'] = 'I valori di default verranno utilizzati durante la creazione di attività o risorse';
$string['confeditorhidebuttons'] = 'Seleziona i pulsanti dell\'editor HTML da nascondere.';
$string['configallcountrycodes'] = 'L\'elenco dei codici nazione che possono essere selezionate, ad esempio nel profilo dell\'utente. E\' possibile inserire un elenco di codici separati da virgola: \'GB,FR,ES\'. Se l\'elenco viene lasciato vuoto (default), verrà utilizzato l\'elenco presente in countries.php del language pack inglese standard, coincidente con l\'elenco ISO 3166-1.Se vengono inseriti codici non standard, è anche necessario  aggiunge tali codici al file countries.php del tuo language pack e nel language pack inglese.';
$string['configallowassign'] = 'Tramite la matrice sottostante puoi autorizzare i ruoli elencati nella colonna verticale a sinistra ad assegnare ad altri utenti uno o più tra i ruoli presenti sulla riga di intestazione';
$string['configallowblockstodock'] = 'Se il tema scelto supporta questa funzione, gli utenti potranno spostare i blocchi laterali nel dock.';
$string['configallowcategorythemes'] = 'Abilitando questa opzione, i temi potranno essere impostati a livello di categoria. L\'impostazione influenzerà tutte le sotto categorie ed i relativi corsi a meno che gli stessi non abbiano  impostato esplicitamente il tema da utilizzare. ATTENZIONE: L\'abilitazione dei temi di categoria può influenzare le prestazioni.';
$string['configallowcoursethemes'] = 'Se abilitato, sarà  possibile impostare un tema diverso per ogni corso. Il tema del corso avrà precedenza su ogni altra preferenza (tema di sito, tema dell\'utente, tema di sessione).';
$string['configallowemailaddresses'] = 'Se si desidera che le email utilizzabili appartengano solo a determinati domini, è possibile elencare i domini autorizzati in questa impostazione, avendo cura di separare i domini tra loro con uno spazio. Le email che non appartengono ai domini elencati non saranno accettate. Per autorizzare anche i sotto domini, elencare il dominio precedendolo con \'.\'. Ad esempio  <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'Consente l\'accesso alla pagina My home per gli i ospiti. Se l\'impostazione è disabilitata gli ospiti saranno reindirizzati alla home page del sito.';
$string['configallowobjectembed'] = 'Come misura standard di sicurezza, gli utenti normali non possono incorporare oggetti multimediali (come Flash) utilizzando esplicitamente i tag EMBED e OBJECT nei testi HTML (possono sempre utilizzare il filtro Plugin multimediali). Se preferisci consentire l\'utilizzo di questi tag, allora devi abilitare l\'opzione.';
$string['configallowoverride'] = 'E\' possibile consentire ai ruoli elencati a sinistra di modificare i ruoli riportati nelle colonne';
$string['configallowoverride2'] = 'Tramite la matrice sottostante puoi autorizzare i ruoli elencati nella colonna verticale a sinistra a modificare i ruoli di altri utenti.<br />Si precisa che queste impostazioni avranno effetto solamente per i ruoli che hanno i privilegi moodle/role:override oppure moodle/role:safeoverride.';
$string['configallowswitch'] = 'E\' possibile selezionare i ruoli che possono \'Cambiare ruolo\', in funzione dei ruoli che già si possiedono. Oltre alla impostazione in questa tabella, un utente  deve anche possedere il privilegio moodle/role:switchroles.<br />Da notare che possono cambiare ruolo solo i ruoli che hanno il privilegio moodle/course:view e che non hanno il privilegio moodle/site:doanything. Per questo motivo alcune colonne nella tabella sono disabilitate.';
$string['configallowthemechangeonurl'] = 'L\'impostazione consente di cambiare il tema, utilizzando in alternativa:  <br />?theme=nomedeltema posposto a qualsiasi URL di Moodle (esempio: mymoodlesite.com/?theme=afterburner ) oppure <br />&theme=nomedeltema posposto a qualsiasi URL interno di Moodle, (esempio: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'E\' possibile consentire agli utenti di espandere e minimizzare i blocchi laterali del sito. <br>Questa caratteristica utilizza Javascript e i cookie per ricordare lo stato di ogni blocco, influenzando pertanto solo la vista personale dell\'utente.';
$string['configallowuserswitchrolestheycantassign'] = 'Per cambiare ruolo gli utenti devono possedere il privilegio moodle/role:assign. Abilitando questa impostazione si rimuove la necessità di avere questo privilegio e i ruoli disponibili nel menù a discesa "Cambia ruolo in.." saranno controllati solamente dalle impostazioni della tabella "Autorizzati ad attribuire ruoli".
Si raccomanda che nella tabella "Autorizzati ad attribuire ruoli" non ci siano impostazioni tali da consentire agli utenti di cambiare il proprio ruolo con un ruolo che ha maggiori privilegi.';
$string['configallowuserthemes'] = 'Gli utenti potranno scegliere il loro tema personale. I temi personali hanno la precedenza sui temi del sito, ma non sui temi di corso.';
$string['configallusersaresitestudents'] = 'Ai fini delle attività poste sulla pagina home del sito, tutti gli utenti devono essere considerati studenti? Se si risponde "Si" allora ogni account utente confermato sarà  abilitato a partecipare come studente a queste attività . Se si risponde "No", allora solo gli utenti che sono anche studenti iscritti almeno ad un corso saranno abilitati a partecipare a queste attività  presenti nella pagina home. Solo gli amministratori e i docenti speciali assegnati potranno comportarsi come docenti per queste attività  della pagina home.';
$string['configauthenticationplugins'] = 'Nella tabella soprastante puoi abilitare i plugin di autenticazione ed ordinarli secondo la priorità di esecuzione desiderata.';
$string['configautolang'] = 'Rileva la lingua di default dalle impostazioni del browser.  Se l\'opzione è disabilitata sarà usata la lingua default del sito.';
$string['configautologinguests'] = 'Selezionando questa opzione, i visitatori potranno accedere direttamente ai corsi che consentono l\'accesso agli ospiti';
$string['configbloglevel'] = 'L\'impostazione consente di regolare la visibilità dei blog degli utenti. L\'impostazione regola la visibilità del blog per colui che legge i blog degli utenti ma non altera il privilegio degli utenti di scrivere nel proprio blog. Se non desiderati, i blog possono essere disabilitati.';
$string['configcalendarcustomexport'] = 'Abilita intervallo di date personalizzato per l\'esportazione del calendario';
$string['configcalendarexportsalt'] = 'Il seme generato casualmente viene utilizzato per rendere più sicuri i token di autenticazione usati per l\'esportazione dei calendari. Puoi cambiare il seme ma tutti i token di autenticazione al momento attivi non saranno più validi.';
$string['configclamactlikevirus'] = 'Considera infetti i file';
$string['configclamdonothing'] = 'Considera OK i file';
$string['configclamfailureonupload'] = 'Imposta il comportamento nel caso in cui Clam non funzioni correttamente oppure non sia configurato in modo appropriato.  Se imposti \'Considera infetti i file\', i file saranno spostati nell\'area di quarantena o saranno eliminati. Se imposti \'Considera OK i file\', i file verranno trasferiti nella cartella di destinazione. In ogni caso, se Clam antivirus dovesse andare in errore, gli amministratori verranno avvisati. Se imposti \'Considera infetti i file\' e per qualche motivo Clam antivirus dovesse andare in errore (spesso avviene se il valore di pathtoclam è errato), QULASIASI file caricato sarà spostato nell\'area di quarantena o eliminato. Si consiglia di impostare questa variabile con molta attenzione.';
$string['configcookiehttponly'] = 'Abilita le nuove caratteristiche disponibili in PHP 5.2.0. I browser verranno obbligati ad inviare cookie solo tramite protocollo http, in modo da non consentirne l\'accesso da parte di linguaggi di scripting. Non tutti i browser supportano questa caratteristica che potrebbe non essere compatibile con l\'attuale codice. Questa impostazione aiuta a prevenire alcuni tipi di attacchi XSS.';
$string['configcookiesecure'] = 'Se il server accetta solamente connessioni https, allora è opportuno abilitare l\'invio di cookie sicuri. Se abiliti questa impostazione, accertatati che il server web non accetti connessioni http://, oppure imposta un reindirizzamento permanente al protocollo https://. Nel caso in cui l\'indirizzo specificato per <em>wwwroot</em> nel file config.php non contenga https://, questa impostazione  verrà automaticamente disabilitata.';
$string['configcountry'] = 'Il Paese che comparirà per default nelle pagine di creazione di un account utente. Se non si imposta un Paese di default, il campo diventerà a compilazione obbligatoria.';
$string['configcourseoverviewfilesext'] = 'Elenco separato da virgola delle estensioni consentite per i file dell\'introduzione al corso';
$string['configcourseoverviewfileslimit'] = 'Il numero massimo di file che  possono essere caricati nei file dell\'introduzione al corso.';
$string['configcourserequestnotify'] = 'E\' possibile indicare lo username dell\'utente da avvertire in presenza di richieste di nuovi corsi.';
$string['configcourserequestnotify2'] = 'Gli utenti da avvertire in presenza di domande per Corsi a richiesta. L\'elenco riporta solo gli utenti che hanno il privilegio di approvare Corsi a richiesta.';
$string['configcoursesperpage'] = 'Numero di corsi da visualizzare nelle pagine contenenti elenchi di corsi.';
$string['configcourseswithsummarieslimit'] = 'Il numero massimo di corsi da visualizzare negli elenchi di corsi che includono l\'introduzione prima di utilizzare un elenco più semplice.';
$string['configcronclionly'] = 'Disabilita l\'esecuzione del cron via web, consentendola solo dalla linea di comando. L\'opzione annulla le eventuali impostazioni sottostanti relative alla password cron.';
$string['configcronremotepassword'] = 'Lo script cron.php potrà essere eseguito da un browser web solo fornendo la password, usando il seguente formato per l\'URL:<pre>
http://site.example.com/admin/cron.php?password=opensesame</pre>In assenza di impostazione, non sarà necessaria nessuna password.';
$string['configcurlcache'] = 'Time-to-live, espresso in secondi, della cache cURL';
$string['configcustommenuitems'] = 'E\' possibile configurare un menu orizzontale personalizzato. Ciascuna linea è composta da testo, un URL (opzionale), un testo per il tooltip (opzionale) e un codice lingua o elenco di codici lingua separati da virgola (opzionale, per visualizzare il testo in base alla lingua dell\'utente). Ciascun elemento è separato dal carattere “|” (pipe). E\' possibile anche indicare sotto menù anteponendo uno o più caratteri "#". Esempio:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-###
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
#####
Moodle.com|http://moodle.com/
</pre>';
$string['configcustomusermenuitems'] = 'E\' possibile configurare i contenuti del menu utente (ad eccezione del link di logout che verrà inserito automaticamente). Gli elementi su ciascuna linea devono essere separati dal carattere | e contengono 1) una stringa del tipo "langstringname, componentname" oppure di testo semplice, 2) un URL e 3) un\'icona specificata come icona pix oppure come URL. E\' possibile utilizzare separatori aggiungendo una line con uno più caratteri #.';
$string['configdbsessions'] = 'E\' possibile memorizzare le informazioni delle sessioni nel database. L\'impostazione è particolarmente utile per siti molto grandi, con molto traffico o per siti in cluster. Attenzione: cambiare questa impostazione provoca il logout dal sito di tutti gli utenti collegati, tu compreso.
Se viene utilizzato MySQL, accertarsi di impostare \'max_allowed_packet\' in my.cnf (o in my.ini) ad almeno 4M. E\' anche possibile configurare altri driver di sessione direttamente nel file config.php. Per maggiori informazioni vedere il file config-dist.php. Questa impostazione scompare se vengono specificati driver di sessione nel file config.php,';
$string['configdebug'] = 'L\'impostazione regola il dettaglio della reportistica del PHP. E\' utile esclusivamente per gli sviluppatori.';
$string['configdebugdisplay'] = 'Consente di indirizzare il report degli errori nella pagina HTML. Sebbene l\'opzione sia particolarmente comoda, va tenuto presente che l\'invio di messaggi di errore nella pagina HTML altererà l\'XHTML, i JS, i cookie e gli header HTTP. Se non si seleziona l\'opzione, il report sarà inviato nel log del  server, consentendo un debugging più facile. Il nome del log di destinazione è controllato dall\'impostazione PHP error_log.';
$string['configdebugpageinfo'] = 'Selezionare l\'opzione se si desidera visualizzare le informazione nel piè di pagina.';
$string['configdebugsmtp'] = 'Consente la visualizzazioni di informazioni di debug utili per individuare problemi relativi all\'invio dei email tramite server SMTP.';
$string['configdebugvalidators'] = 'Selezionare l\'opzione se si desidera visualizzare i link ai validator esterni. Per il corretto funzionamento è necessario creare un utente con username <em>w3cvalidator</em> ed abilitare l\'accesso agli ospiti. Tali impostazioni possono consentire accessi non autorizzati al  server, pertanto non va utilizzata su siti in produzione.';
$string['configdefaulthomepage'] = 'Imposta la pagina home per gli utenti autenticati';
$string['configdefaultrequestcategory'] = 'I corsi a richiesta, se approvati, saranno automaticamente inseriti nella categoria specificata.';
$string['configdefaultrequestedcategory'] = 'Categoria in cui inserire i corsi a richiesta, una volta approvati.';
$string['configdefaultuserroleid'] = 'A tutti gli utenti autenticati, nel contesto del sito, sarà assegnato il ruolo qui indicato. Tale ruolo viene assegnato in aggiunta ai ruoli che gli utenti già possiedono nel sito. Il valore di default è Utente autenticato. Il ruolo di Utente autenticato non entra in conflitto con nessun altro ruolo: il suo scopo è quello di garantire agli utenti autenticati alcuni privilegi, indipendenti dal fatto di essere iscritti ad un corso, come ad esempio inserire un intervento nel blog, gestire il proprio calendario, eccetera.';
$string['configdeleteincompleteusers'] = 'Dopo questo periodo di tempo, gli account non completati saranno eliminati.';
$string['configdeleteunconfirmed'] = 'Se si sta usando l\'autenticazione e-mail, questo parametro imposta il periodo di tempo entro il quale sarà  accettata la conferma da parte dagli utenti. Trascorso questo periodo, gli utenti non confermati vengono eliminati.';
$string['configdenyemailaddresses'] = 'Se si desidera impedire l\'uso di email appartenenti a taluni domini, in questa impostazione è possibile elencare i domini indesiderati . Le email appartenenti a domini non presenti nell\'elenco potranno invece essere utilizzate. Per includere anche i sotto domini, elencare il dominio precedendolo con \'.\'. Ad esempio, <strong>hotmail.com .yahoo.co.uk.live</strong>';
$string['configdisableuserimages'] = 'Gli utenti non potranno  cambiare l\' immagine del proprio profilo.';
$string['configdisplayloginfailures'] = 'Abilita la visualizzazione dei tentativi errati di login.';
$string['configdndallowtextandlinks'] = 'Abilita o disabilita il caricamento di testi e link tramite trascina e rilascia. Da notare che trascinare e rilasciare testi in Firefox o tra browser differenti potrebbe risultare in nessun caricamento o in un caricamento parziale.';
$string['configdoclang'] = 'La lingua da utilizzare nei link che portano alle pagine della documentazione.';
$string['configdocroot'] = 'Imposta il percorso per aprire Moodle Docs in base al contesto, tramite il link "Documentazione di Moodle per questa pagina" presente nei piè di pagina. Se l\'impostazione non è compilata, il link nel più di pagina non sarà visualizzato.';
$string['configdoctonewwindow'] = 'Abilitatando questa opzione, i collegamenti a Moodle Docs verranno visualizzati in una nuova finestra';
$string['configeditordictionary'] = 'Questo valore sarà utilizzato se lo spell checker aspell non dispone del dizionario corrispondente alla lingua degli utenti.';
$string['configeditorfontlist'] = 'Scegli i font che appariranno nella lista drop-down dell\'editor.';
$string['configemailchangeconfirmation'] = 'Obbliga gli utenti a confermare il cambio di email quando modificano l\'indirizzo di posta elettronica nel proprio profilo.';
$string['configenableblogs'] = 'L\'impostazione attiva  blog personali per tutti gli utenti del sito.';
$string['configenablecalendarexport'] = 'Abilita l\'esportazione o la sottoscrizione ai calendari.';
$string['configenablecomments'] = 'Abilita i commenti';
$string['configenablecourserequests'] = 'Questa impostazione consentirà agli utenti di richiedere corsi.';
$string['configenabledevicedetection'] = 'Abilita il riconoscimento di dispositivi mobili, smartphone, tablet, oppure dispositivi tradizionali (PC desktop, laptop, eccetera) per l\'impostazione dei temi ed altre funzionalità';
$string['configenablemobilewebservice'] = 'Abilita il servizio mobile per la app ufficiale Moodle o per altre app. Per maggiori informazioni leggere {$a}';
$string['configenablerssfeeds'] = 'Attiva il generatore RSS (RSS Feed) del sito. Per poter utilizzare i feed RSS è necessario attivare anche il generatore RSS nei singoli moduli di attività.';
$string['configenablerssfeedsdisabled'] = 'Non è disponibile poiché il generatore RSS è disabilitato a livello di sito. Per attivarlo, andate in \'configura variabili\' nel pannello di Amministrazione.';
$string['configenablerssfeedsdisabled2'] = 'I feed RSS sono disabilitati a livello di server. Devi abilitarli in Server/RSS.';
$string['configenablesafebrowserintegration'] = 'Aggiunge l\'opzione \'Safe Exam Browser\' nel menù a discesa \'Livello sicurezza browser\' presente nelle impostazioni dei quiz. Per maggiori informazioni: http://safeexambrowser.org.';
$string['configenablestats'] = 'Attivando le statistiche, Moodle elaborerà il log con cadenza giornaliera. La durata dell\'elaborazione  dipenderà dal traffico del sito. Le statistiche consentono di visualizzare graficamente dati sui corsi e sul sito.';
$string['configenabletrusttext'] = 'Per default Moodle ripulisce con cura tutti i testi inseriti dagli utenti, al fine di rimuovere ogni possibile script malevolo, oggetto multimediale od altro che possa mettere a repentaglio la sicurezza. Il sistema di Contenuto Affidabile è un modo per dare ad  utenti degni di fiducia la possibilità di usare funzioni evolute nei loro contenuti senza alcuna interferenza. Per attivare il sistema è necessario abilitare l\'impostazione e poi attribuire il privilegio Contenuto Affidabile ad uno specifico ruolo. I testi creati o caricati dagli utenti che hanno tale ruolo saranno contrassegnati come "affidabili" e non saranno ripuliti prima della visualizzazione.';
$string['configenablewebservices'] = 'I Web service consentono agli utenti di altri sistemi di collegarsi a Moodle e di effettuare varie operazioni. Per maggiore sicurezza, abilitate i Web service solo se avete realmente bisogno di usarli.';
$string['configenablewsdocumentation'] = 'Abilita la generazione automatica della documentazione web service. Un utente web service può accedere alla propria documentazione nella pagina delle chiavi. La documentazione visualizzata è relativa solamente ai protocolli abilitati.';
$string['configerrorlevel'] = 'Imposta il numero di messaggi di errore di PHP che si desidera visualizzare. \'Normale\' è solitamente l\'opzione migliore.';
$string['configexportlookahead'] = 'Giorni futuri da esportare:';
$string['configexportlookback'] = 'Giorni passati da esportare:';
$string['configextendedusernamechars'] = 'Gli utenti potranno utilizzare qualsiasi carattere per il proprio username (da notare che l\'impostazione non ha effetti sui loro nomi reali).
L\'impostazione di default consente l\'uso dei soli caratteri alfanumerici minuscoli, carattere di sottolineatura (_), segno meno (-), punto (.) o il simbolo "at" (@)';
$string['configextramemorylimit'] = 'Alcuni script, come la ricerca globale, il backup/ripristino o il cron, richiedono maggiore memoria. Aumentare questo valore per siti di grandi dimensioni.';
$string['configfilterall'] = 'Filtra tutte le stringhe, incluse le intestazioni, titoli, barre di navigazione ecc.
E\' utile solo se si usa il filtro multilingua, in mancanza del quale si creerà solo carico supplementare sul sito senza vantaggi apprezzabili.';
$string['configfiltermatchoneperpage'] = 'Il filtro di creazione automatica dei link (auto-link) genererà solo il collegamento alla prima occorrenza del testo trovato nella pagina. Tutte le altre saranno ignorate.';
$string['configfiltermatchonepertext'] = 'Il filtro di creazione automatica dei link (auto-link) genererà solo il collegamento alla prima occorrenza del testo trovata in ogni elemento di testo (es. risorsa, blocco) della pagina. Tutte le altre saranno ignorate. Questa impostazione non viene tenuta in considerazione se Filtra occorrenze una volta per pagina è impostato a <i>si</i>.';
$string['configfilteruploadedfiles'] = 'Imposta il filtraggio antecedente alla visualizzazione dei file caricati: Tutti i file, Solo file HTML oppure Nessuno.';
$string['configforcelogin'] = 'L\'elenco dei corsi e la pagina home del sito per default sono visibili senza doversi autenticare. Se si desidera obbligare i visitatori ad autenticarsi  prima che possano vedere la pagina home o svolgere una qualsiasi attività sul sito, abilitare questa opzione.';
$string['configforceloginforprofiles'] = 'Rende obbligatoria l\'autenticazione con credenziali valide (non ospite) per  visualizzare i profili di altri utenti. Disabilitando questa impostazione, alcuni utenti potrebbero usare il proprio profilo, visibile pubblicamente, per inserire pubblicità (spam) o altri tipi di contenuti inappropriati.';
$string['configfrontpage'] = 'Puoi impostare gli elementi da visualizzare nella pagina home del sito ed il loro ordine.';
$string['configfrontpagecourselimit'] = 'Numero massimo di corsi';
$string['configfrontpagecourselimithelp'] = 'Il numero massimo di corsi presenti negli elenchi di corsi visualizzati nella home page del sito';
$string['configfrontpageloggedin'] = 'Puoi impostare gli elementi da visualizzare nella pagina home del sito ed il loro ordine per gli utenti che si sono autenticati.';
$string['configfullnamedisplay'] = 'Definisce la modalità di visualizzazione dei nomi quando vengono visualizzati in forma  completa. Il valore di default "language" delega la modalità di visualizzazione alla stringa "fullnamedisplay" contenuta nel language pack in uso. Lingue diverse possono avere convenzioni diverse

Per la maggioranza dei siti mono lingua l\'impostazione preferibile è "firstname lastname", tuttavia è possibile scegliere di nascondere il cognome. I segnaposto che possono essere usati sono: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, e alternatename.';
$string['configgeoipfile'] = 'La posizione del file dati GeoIP City. Questo file non fa parte della distribuzione di Moodle e deve essere scaricato manualmente da <a href="http://www.maxmind.com/">MaxMind</a>. E\' possibile acquistare la versione commerciale o utilizzare la versione gratuita.<br />Per il download recarsi su <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz">http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> ed estrarre il file nella cartella "{$a}" del proprio server.';
$string['configgetremoteaddrconf'] = 'Se il server si trova dietro un reverse proxy,  tramite questa  impostazione è possibile indicare quali header HTTP possano ritenersi affidabili per gli indirizzi IP remoti. Gli header vengono letti sequenzialmente a partire dal primo disponibile.';
$string['configgradebookroles'] = 'Consente di indicare i ruoli che figureranno nel registro valutatore. E\' necessario che un utente possegga almeno uno di questi ruoli per figurare nel registro valutatore di un corso.';
$string['configgradeexport'] = 'E\' possibile scegliere i formati preferiti  da usare per l\'esportazione delle valutazioni. I formati scelti durante l\'esportazione imposteranno il campo "Formati utilizzati recentemente" per ciascun Registro valutazioni. Questo aspetto potrebbe far apparire le valutazioni esportate come "nuove" oppure come "aggiornate". Se non sei più che sicuri di come impostare i formati, allora non selezionare nulla.';
$string['confighiddenuserfields'] = 'E\' possibile nascondere alla vista degli utenti che non abbiano il ruolo di docente/amministratore alcuni dei campi presenti nel profilo utente. Lo scopo è quello di aumentare la privacy degli utenti. Per selezionare più campi tieni premuto il tasto CTRL o Command a seconda del sistema operativo in uso.';
$string['configidnumber'] = 'L\'opzione imposta se a) non viene richiesto all\'utente il codice identificativo, b) viene richiesto all\'utente il codice identificativo ma può non compilarlo, c) viene richiesto all\'utente il codice identificativo e deve compilarlo obbligatoriamente. Se compilato, il codice identificativo sarà visualizzato nel profilo utente.';
$string['configintro'] = 'In questa pagina si possono specificare un numero di variabili di configurazione che aiutano Moodle a lavorare al meglio.
Non ti preoccupare troppo a riguardo, i valori predefiniti in genere svolgono bene il loro compito e puoi sempre tornare su questa pagina in un secondo momento per modificare le impostazioni.';
$string['configintroadmin'] = 'In questa pagina devi configurare l\'account dell\'Amministratore primario che avrà  il controllo completo sul sito. Assicurati di fornire uno username e una password sicuri, così come un indirizzo email valido. In seguito sarà possibile assegnare il ruolo di amministratore ad  altri account.';
$string['configintrosite'] = 'Questa pagina consente di configurare la pagina home e il nome di questo sito.
In un secondo momento sarà possibile tornare su questa pagina e modificare le impostazioni tramite il menu Amministrazione';
$string['configiplookup'] = 'Quando si clicca su un indirizzo IP (come per es. 34.12.222.93), come riportato nei log, viene visualizzata una mappa con la localizzazione più probabile di quel IP. Ci sono diversi plugin che si possono scegliere per ottenere questo, ciascuno con i suoi pro e contro.';
$string['configkeeptagnamecase'] = 'I tag inseriti manterranno i caratteri maiuscoli/minuscoli.';
$string['configlang'] = 'La lingua di default del sito. Gli utenti che lo desiderano potranno modificare l\'impostazione nel proprio profilo.';
$string['configlanglist'] = 'Lascia vuoto se vuoi consentire agli utenti di scegliere tra tutte le lingue installate. Se preferisci, si può abbreviare il menu delle lingue inserendo un elenco dei codici lingua separati da virgole.
Per esempio: en, es_es, it, fr';
$string['configlangmenu'] = 'E\' possibile scegliere se pubblicare o meno il menu delle lingue generico sulla Home Page, nella pagina di Login, ecc.
Questa scelta non influisce sulla possibilità  da parte dell\'utente di scegliere la lingua preferita all\'interno del proprio profilo personale.';
$string['configlangstringcache'] = 'Esegue il caching delle stringhe delle lingue in file compilati nella cartella dati, migliorando le prestazioni. Se stai traducendo Moodle o modificando stringhe nel codice sorgente, è preferibile disabilitare il caching. ';
$string['configlatinexcelexport'] = 'Scegli la codifica per le esportazioni Excel.';
$string['configlocale'] = 'Scegli la localizzazione del sito - L\'impostazione avrà  effetto sulla visualizzazione delle date. È necessario avere la stessa localizzazione del server installata sul sistema operativo del proprio computer. (Per esempio: it_IT.UTF-8).
Se non sai come impostare, lascia il campo vuoto.';
$string['configloginhttps'] = 'Se attivata, questa impostazione consente a Moodle di utilizzare connessioni sicure di tipo https soltanto per la pagina di login (fornendo una login sicura), tornando successivamente ad una normale connessione http per il resto della navigazione degli altri URL.<br>
PRUDENZA: questa impostazione RICHIEDE che https venga specificatamente attivato sul web server - Se non lo fosse VERRETE BLOCCATI AL DI FUORI DAL SITO!';
$string['configloglifetime'] = 'L\'impostazione specifica la durata di conservazione dei log dell\'attività degli utenti. I log più vecchi del numero di giorni impostato verranno eliminati automaticamente.
Sebbene sia desiderabile conservare i log il più a lungo possibile, se si dispone di un server sovraccarico o in presenza di problemi di performance, è preferibile abbreviare la durata di conservazione. Impostazioni di 30 giorni o meno non sono consigliate in quanto le statistiche non funzionerebbero correttamente.';
$string['configlookahead'] = 'Giorni futuri da controllare';
$string['configmaxbytes'] = 'Imposta la dimensione massima per gli upload di file. Il valore massimo è limitato dalla variabile PHP  \'upload_max_filesize\' e \'post_max_size\'  e dal valore della variabile \'LimitRequestBody\' di Apache.
L\'impostazione a sua volta limita la dimensione massima degli upload nei corsi e nei moduli. Scegliendo \'Limite server\', sarà usato il valore di upload massimo consentito.';
$string['configmaxconsecutiveidentchars'] = 'Le password non devono contenere un numero di caratteri identici e consecutivi maggiori del valore specificato. Per disabilitare questa verifica inserite il valore 0.';
$string['configmaxeditingtime'] = 'Questo parametro specifica il tempo massimo a disposizione degli utenti per per modificare i loro interventi su forum, commenti del glossario, eccetera. Normalmente 30 minuti è un valore adeguato.';
$string['configmaxevents'] = 'Eventi da anticipare';
$string['configmaxusersperpage'] = 'Il numero massimo di utenti visualizzati nelle selezioni di utenti relative a corsi, gruppi, gruppi globali, webservice, eccetera.';
$string['configmessaging'] = 'Abilita il sistema di messaggistica interna';
$string['configmessagingallowemailoverride'] = 'Gli utenti potranno ridefinire l\'indirizzo email al quale inviare notifiche usando un indirizzo  diverso rispetto a quello memorizzato nel profilo utente.';
$string['configmessagingdeletereadnotificationsdelay'] = 'Le notifiche lette possono essere eliminate per ridurre lo spazio occupato. E\' possibile specificare per quanto tempo conservare le notifiche lette prima di eliminarle.';
$string['configmessaginghidereadnotifications'] = 'E\' possibile nascondere le notifiche lette, come i post dei forum, durante la visualizzazione dello storico dei messaggi.';
$string['configminpassworddigits'] = 'Le password devono avere almeno questo numero di caratteri numerici.';
$string['configminpasswordlength'] = 'Le password devono essere lunghe almeno questo numero di caratteri.';
$string['configminpasswordlower'] = 'Le password devono avere almeno questo numero di lettere minuscole.';
$string['configminpasswordnonalphanum'] = 'Le password devono avere almeno questo numero di caratteri non alfanumerici.';
$string['configminpasswordupper'] = 'Le password devono avere almeno questo numero di lettere maiuscole.';
$string['configmobilecssurl'] = 'Un file CSS per personalizzare l\'interfaccia della tua app mobille.';
$string['configmodchooserdefault'] = 'Il selettore attività sarà presentato agli utenti per default';
$string['configmycoursesperpage'] = 'Numero massimo di corsi presenti nell\'elenco dei corsi ai quali si è iscritti.';
$string['configmymoodleredirect'] = 'L\'impostazione reindirizza gli utenti non amministratori a /my dopo il login, sostituendo anche la navigazione verso la home page con /my';
$string['configmypagelocked'] = 'L\'impostazione impedisce la modifica della pagina di default da parte di utenti che non abbiamo il ruolo di amministratori';
$string['confignavcourselimit'] = 'Limita il numero di corsi visibili agli utenti quando non sono autenticati o non iscritti in nessun corso.';
$string['confignavshowallcourses'] = 'L\'impostazione stabilisce se gli utenti iscritti ad almeno un corso possano visualizzare la voce Corsi (elenco di tutti corsi)  nel blocco Navigazione. Tale voce sarà visualizzata in aggiunta alla voce I miei corsi (elenco dei corsi ai quali l\'utente è iscritto).';
$string['confignavshowcategories'] = 'Visualizza le categorie di corso nelle briciole e nel blocco Navigazione. Le categorie non saranno visualizzate nei corsi dove l\'utente è iscritto, che saranno elencati nel link I miei corsi.';
$string['confignotifyloginfailures'] = 'E\' possibile inviare avvisi sui login errati agli utenti selezionati. Prerequisito è l\'abilitazione di un log store interno (Ad esempio il log store standard)';
$string['confignotifyloginthreshold'] = 'Se è stata attivata la notifica dei login errati, l\'impostazione consente di definire il numero di login errati raggiunto il quale sarà inviata la mail di avviso.';
$string['confignotloggedinroleid'] = 'Ai visitatori (utenti non autenticati nel contesto del sito) sarà attribuito il ruolo indicato. Per i visitatori non dovreste scegliere nulla di diverso dal ruolo di Ospite, in ogni caso avete la possibilità di creare nuovi ruoli per i visitatori, con autorizzazioni diverse. Alcune attività, come ad esempio intervenire in un forum, richiederanno comunque all\'utente di autenticarsi.';
$string['configopentogoogle'] = 'Google potrà entrare nel tuo sito come Ospite. Inoltre, coloro che tramite Google raggiungeranno il sito saranno autenticati automaticamente come Ospite. Da notare che l\'impostazione fornisce un accesso trasparente solo a quei corsi che già consentono l\'accesso agli ospiti.';
$string['configoverride'] = 'Definito in config.php';
$string['configpasswordpolicy'] = 'Attivando questa opzione Moodle verificherà le password degli utenti secondo le regole indicate. Le impostazioni seguenti servono a specificare tali regole (le regole password saranno ignorate se questa opzione non è selezionata).';
$string['configpasswordresettime'] = 'Il tempo massimo entro il quale deve essere validata la richiesta di recupero password. In genere 30 minuti è un valore adeguato.';
$string['configpathtoclam'] = 'Percorso assoluto per Clam antivirus. Probabilmente usr/bin/clamscan oppure /usr/bin/clamdscan.
Questo percorso consente a Clam di funzionare.';
$string['configpathtodu'] = 'Percorso per du, in genere /usr/bin/du. Se questo campo viene compilato, le pagine che visualizzano il contenuto delle cartelle con molti file verranno elaborate più velocemente.';
$string['configperfdebug'] = 'Consente la visualizzazione di informazioni sulle prestazioni nel piè di pagina del tema standard';
$string['configprofileroles'] = 'Elenco dei ruoli visibili nelle pagine del profilo utente e della partecipazione.';
$string['configprofilesforenrolledusersonly'] = 'Per evitare abusi da parte di spammer, non verranno visualizzate le descrizioni dei profili degli utenti non iscritti a corsi. I nuovi utenti potranno aggiungere la  descrizione nel profilo solo dopo essere stati iscritti ad almeno un corso.';
$string['configprotectusernames'] = 'Lo script forget_password.php per default non visualizza nulla che possa aiutare ad indovinare username o email di utenti.';
$string['configproxybypass'] = 'Elenco separato da virgole dei nomi degli host o degli IP (anche parziali) che possono evitare il proxy (ad esempio, 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Se questo <b>server</b> ha bisogno di un  di un proxy (o di un firewall) per accedere a Internet, specificate il nome del proxy. Se non usate proxy, non compilate questo campo.';
$string['configproxypassword'] = 'Password per accedere a internet attraverso il proxy, lasciare vuoto se non utilizzata (è necessaria l\'estensione PHP cURL).';
$string['configproxyport'] = 'Specificate la porta usata dal proxy per accedere ad Internet';
$string['configproxytype'] = 'Tipo di proxy (per il supporto SOCKS5 sono necessari il PHP5 e l\'estensione cURL ).';
$string['configproxyuser'] = 'Username abilitato ad accedere ad internet attraverso il proxy, lasciare vuoto se non utilizzato (è necessaria l\'estensione PHP cURL).';
$string['configquarantinedir'] = 'Se desiderate che Clam antivirus sposti eventuali file infetti in una cartella di quarantena, inseritene il percorso qui. La cartella deve avere i permessi di scrittura da parte del server web. Se lasciate in bianco, o se configurate una directory inesistente o senza i permessi di scrittura necessari, i files infetti saranno eliminati. Non inserite slash di percorso.';
$string['configrecaptchaprivatekey'] = 'Stringa di caratteri usata per comunicare tra il proprio server Moodle e il server recaptcha.net. E\' possibile richiedere una chiave visitando il sito http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Stringa di caratteri usata per visualizzare l\'immagine reCAPTCHA nella pagina di creazione account. L\'immagine è generata dal sito ttp://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Consente di selezionare una categoria durante la richiesta di corsi';
$string['configrequestedstudentname'] = 'Termine per \'studente\' da utilizzare nel corsi richiesti';
$string['configrequestedstudentsname'] = 'Termine per \'studenti\' da utilizzare nel corsi richiesti';
$string['configrequestedteachername'] = 'Termine per \'docente\' da utilizzare nel corsi richiesti';
$string['configrequestedteachersname'] = 'Termine per \'docenti\' da utilizzare nel corsi richiesti';
$string['configrequiremodintro'] = 'Disabilitando l\'opzione la descrizione dell\'attività non sarà più obbligatoria.';
$string['configrunclamavonupload'] = 'Se abilitato, clam AV sarà usato per fare lo scan di tutti i files caricati.';
$string['configrunclamonupload'] = 'Attivare Clam antivirus sui file in trasferimento? Avrete bisogno di configurare correttamente il percorso nella variabile \'pathtoclam\' per farlo funzionare. (Clam è un antivirus gratuito che si può ottenere dal sito: http://www.clamav.net/)';
$string['configsectioninterface'] = 'Interfaccia';
$string['configsectionmail'] = 'Posta';
$string['configsectionmaintenance'] = 'Manutenzione';
$string['configsectionmisc'] = 'Miscellanea';
$string['configsectionoperatingsystem'] = 'Sistema operativo';
$string['configsectionpermissions'] = 'Permessi';
$string['configsectionrequestedcourse'] = 'Richieste di corsi';
$string['configsectionsecurity'] = 'Sicurezza';
$string['configsectionstats'] = 'Statistiche';
$string['configsectionuser'] = 'Utente';
$string['configsecureforms'] = 'Moodle può utilizzare un livello aggiuntivo di sicurezza nell\'accettazione di dati provenienti da form web. Se attivata, la variabile HTTP_REFERER del browser è confrontata con l\'indirizzo del form in uso. In alcuni rari casi questo può causare problemi se l\'utente sta utilizzando un firewall (ad esempio Zonealarm) configurato per rimuovere HTTP_REFERER dal suo traffico web. Uno dei sintomi è rimanere \'bloccato\' su di un form. Ad esempio, se gli utenti dovessero avere problemi con la pagina di login , è possibile disabilitare questa impostazione, anche se ciò potrebbe esporre il  sito ad attacchi con forzature di password. In caso di dubbio, lasciare l\'impostazione a \'Si\'.';
$string['configsessioncookie'] = 'E\' possibile personalizzare il prefisso del cookie usato per identificare le sessioni di Moodle. Questa impostazione è opzionale ma è indispensabile se più istanze di Moodle girano sul medesimo sito web.';
$string['configsessioncookiedomain'] = 'Consente di cambiare il dominio dal quale provengono i cookie di Moodle. E\' utile per alcune personalizzazioni di Moodle (ad esempio plugin di autenticazione o di iscrizione) per le quali si rende necessario scambiare le informazioni di sessione con applicazioni web o con sotto domini. <strong>ATTENZIONE: si consiglia di lasciare l\'impostazione al suo default (vuoto) - valori errati potrebbero impedire qualsiasi login al sito.</strong>';
$string['configsessioncookiepath'] = 'E\' possibile personalizzare dove i browser inviano i cookie di Moodle specificando una sotto cartella del sito web. In genere il default \'/\' dovrebbe andare bene.';
$string['configsessiontimeout'] = 'la sessione degli utenti autenticati che non svolgono attività per un dato periodo di tempo (ad esempio caricare pagine), viene conclusa automaticamente. Questa variabile specifica il tempo massimo di inattività oltre la quale la sessione sarà considerata conclusa.';
$string['configshowcommentscount'] = 'Visualizza il numero di commenti. Richiederà una query supplementare per visualizzare i link ai commenti.';
$string['configshowicalsource'] = 'Visualizza informazioni sull\'origine degli eventi iCal';
$string['configshowsiteparticipantslist'] = 'Tutti gli studenti di questo sito e i docenti del sito saranno visualizzati nell\'elenco dei partecipanti. Chi è abilitato a visualizzare la lista dei partecipanti di questo sito?';
$string['configsitedefaultlicense'] = 'Licenza di default del sito';
$string['configsitedefaultlicensehelp'] = 'La licenza di default sarà quella usata per pubblicare contenuti in questo sito';
$string['configsitemaxcategorydepth'] = 'Numero max. sotto categorie';
$string['configsitemaxcategorydepthhelp'] = 'La profondità massima di sotto categorie visualizzate aperte nelle pagine contenenti elenchi di categorie o  elenchi combinati. Le sotto categorie nidificate più profondamente del valore impostato saranno visualizzate come link e potranno essere aperte tramite richieste AJAX.';
$string['configslasharguments'] = 'L\'impostazione \'slash arguments\' (che utilizza <em>PATH_INFO</em>) è necessaria per eseguire pacchetti SCORM e per visualizzare correttamente risorse con più file. Qualora il web server dove è installato Moodle non supporti gli \'slash arguments\' è possibile disabilitare l\'impostazione sebbene questo comporterà il mancato funzionamento di alcuni elementi.<br />Nota: l\'impostazione \'slash arguments\' diventerà obbligatoria in future versioni di Moodle.';
$string['configsmartpix'] = 'Con questa impostazione, le icone sono gestite tramite uno script PHP che le cerca prima nel tema grafico corrente, poi in tutti i temi a livello superiore i quindi nella cartella di Moodle /pix. Questo riduce il bisogno di duplicare le immagini all\'interno dei temi, anche se con un piccolo costo di performance.';
$string['configstartwday'] = 'Inizio settimana';
$string['configstatsfirstrun'] = 'Questa impostazione definisce, per la <b>prima elaborazione</b> delle statistiche dei log, da quanto indietro nel tempo devono essere elaborati i log. Se avete molto traffico e non avete un server dedicato, probabilmente non è una buona idea tornare troppo indietro nel tempo, l\'elaborazione potrebbe essere abbastanza lunga ed esosa in termini di risorse necessarie. (Notare che nell\'impostazione , 1 mese = 28 giorni. Nei grafici e nei report generati, 1 mese = 1 mese del calendario.)';
$string['configstatsmaxruntime'] = 'L\'elaborazione delle statistiche può essere abbastanza lunga. Utilizzate una combinazione di questo e del prossimo campo per definire quando farla partire e per quanto tempo.';
$string['configstatsmaxruntime2'] = 'L\'elaborazione delle statistiche può essere molto onerosa. Puoi specificare il tempo massimo consentito per accumulare un giorno di statistiche. Il numero massimo di giorni elaborati nell\'esecuzione di un cron è 31.';
$string['configstatsmaxruntime3'] = 'Definisce il tempo massimo consentito per l\'elaborazione delle statistiche di un giorno. Va tenuto presente che l\'elaborazione delle statistiche è molto onerosa per il server. Il numero massimo di giorni da elaborare tramite cron può essere impostato sotto.';
$string['configstatsruntimedays'] = 'Definisce il numero massimo di giorni da elaborare. Se le statistiche sono aggiornate, viene elaborato solamente un giorno. Devi impstare questo parametro in funzione del carico sul server ed eventualmente ridurlo se sono preferibili elaborazioni più brevi.';
$string['configstatsruntimestart'] = 'Orario di avvio dell\'elaborazione tramite cron. Se nello stesso server sono installate più istanze Moodle, si suggerisce di specificare orari di avvio diversi per ciascuna istanza.';
$string['configstatsuserthreshold'] = 'Specifica il numero minimo di utenti necessario per includere il corso nel computo delle statistiche.';
$string['configstrictformsrequired'] = 'Nelle maschere con campi obbligatori gli utenti non potranno inserire spazi bianchi o interruzioni di linea.';
$string['configstripalltitletags'] = 'Per consentire l\'uso di tag HTML nei nomi delle risorse e delle attività è necessario deselezionare questa opzione.';
$string['configsupportemail'] = 'Indirizzo email al quale  gli utenti del sito possono rivolgersi per richieste di assistenza (ad esempio, quando nuovi utenti creano il proprio account). Se il campo è lasciato vuoto, l\'email non verrà fornita nessuna email di supporto.';
$string['configsupportname'] = 'Il nome della persona o della organizzazione che fornisce supporto tramite email o sito web.';
$string['configsupportpage'] = 'Questo indirizzo web, per gli utenti di questo sito, sarà quello da linkare se si ha bisogno di assistenza (per esempio, quando nuovi utenti creano il proprio account). Se tale indirizzo è lasciato vuoto, non sarà fornito alcun link.';
$string['configthemedesignermode'] = 'Le immagini ed i CSS appartenenti al tema sono conservati nella cache del browser e del server per un periodo di tempo molto lungo. Se stai sviluppando od ottimizzando un tema, attiva questa impostazione utile anche per gli sviluppatori di codice. E\' anche possibile annullare manualmente la cache del tema nella pagina di selezione temi. ATTENZIONE: la modalità theme designer ha un impatto negativo sulle performance del server!';
$string['configthemelist'] = 'Consente di abbreviare il menu di selezione dei temi specificando i nomi dei temi separati da virgole.Lasciando il campo vuoto sarà possibile selezionare qualsiasi tema installato. Esempio: standard,orangewhite.';
$string['configtimezone'] = 'E\' possibile impostare il fuso orario di default da utilizzare per la visualizzazione delle date. Ciascun utente nel proprio profilo potrà poi scegliere il fuso orario preferito. Impostando il fuso a "Ora locale del server", il fuso orario di default coinciderà con il fuso orario impostato nel PHP il sito e tale impostazione sarà usata anche come valore di default nel profilo degli utenti. Anche l\'\'elaborazione delle operazioni pianificate  tramite cron terrà conto del fuso orario di default.';
$string['configuseblogassociations'] = 'Consente agli utenti di organizzare i propri blog associandoli ai cori ed ai moduli di attività.';
$string['configuseexternalyui'] = 'Al posto dei file locali, è possibile usare i file online disponibili sui server Yahoo‘s . ATTENZIONE: è necessaria la connessione ad internet, altrimenti AJAX smetterà di funzionare sul tuo sito. L\'impostazione non è compatibile con i siti che usano https.';
$string['configuserquota'] = 'Il numero massimo di byte che un utente può utilizzare per memorizzare file personali. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Consente di usare il nome abbreviato del sito per il nodo pagine del sito nel blocco navigazione. Il nome del sito sostituirà la stringa "Pagine del sito"';
$string['configusetags'] = 'Abilita la funzionalità Tag nel sito.';
$string['configvariables'] = 'Variabili';
$string['configverifychangedemail'] = 'Abilita la funzione di verifica degli indirizzi di posta elettronica quando gli utenti nel loro profilo modificano l\'email. La verifica viene effettuata sulla base delle liste di domini presenti nelle impostazioni Domini di posta autorizzati e Domini di posta non autorizzati. Se questa impostazione è disabilitata, la verifica dei domini autorizzati verrà operata solo durante la creazione di nuovi account.';
$string['configvisiblecourses'] = 'Consente la visualizzazione e l\'accesso ai corsi presenti in categorie di corso nascoste.';
$string['configwarning'] = 'Fate attenzione a modificare queste impostazioni, valori anomali potrebbero causare problemi.';
$string['configyuicomboloading'] = 'L\'impostazione abilita il caricamento combinato ottimizzato dei file delle librerie YUI. Per motivi di performace l\'impostazione dovrebbe essere attiva nei siti in produzione.';
$string['confirmation'] = 'Conferma';
$string['confirmdeletecomments'] = 'Stai per eliminare commenti, sei sicuro ?';
$string['confirmed'] = 'Confermato';
$string['cookiehttponly'] = 'Solo cookies http';
$string['cookiesecure'] = 'Solo cookies sicuri';
$string['country'] = 'Paese di default';
$string['coursecontact'] = 'Gestori dei corsi';
$string['coursecontact_desc'] = 'E\' possibile indicare quali ruoli far comparire nella descrizione dei corsi. Affinché il nome di un utente compaia nella descrizione di un corso, l\'utente dovrà avere almeno uno dei ruoli qui specificati.';
$string['courselistshortnames'] = 'Visualizza titoli dei corsi estesi';
$string['courselistshortnames_desc'] = 'Consente la visualizzazione del titolo del corso assieme al titolo abbreviato del corso sia nella visualizzazione degli elenchi dei corsi sia nella pagine di amministrazione dove sono presenti titoli di corsi. Se l\'impostazione è attiva, la visualizzazione dei titoli dei corsi  utilizzerà la stringa \'courseextendednamedisplay\', che può essere modificata secondo necessità personalizzando il language pack.ta';
$string['coursemgmt'] = 'Gestione corsi e categorie';
$string['courseoverview'] = 'Panoramica sui corsi';
$string['courserequestnotify'] = 'Avvertire in caso di richieste';
$string['courserequestnotifyemail'] = 'L\'utente {$a->user} ha presentato richiesta per il corso {$a->link}';
$string['courserequests'] = 'Corsi che sono stati richiesti';
$string['courserequestspending'] = 'Richieste di nuovi corsi da approvare';
$string['courses'] = 'Corsi';
$string['coursesperpage'] = 'Corsi per pagina';
$string['courseswithsummarieslimit'] = 'Numero limite di corsi visualizzati in presenza di  introduzione';
$string['creatornewroleid'] = 'Ruolo del creatore di corsi nei nuovi corsi';
$string['creatornewroleid_help'] = 'Se l\'utente non ha il privilegio di gestire nuovi corsi, allora verrà iscritto al corso con questo ruolo.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Esecuzione cron solamente da linea comando';
$string['cronerrorclionly'] = 'Spiacente, l\'accesso via internet a questa pagina web è stato disabilitato dall\'amministratore.';
$string['cronerrorpassword'] = 'Spiacente, non è stata fornita una password valida per accedere a questa pagina.';
$string['cron_help'] = 'Lo script con.php è utilizzato da alcuni moduli di Moodle per eseguire azioni periodiche, come ad esempio inviare mail dei nuovi interventi sui forum. E\' necessario disporre di un sistema in grado di eseguire il cron con regolarità ad esempio ogni 5 minuti.';
$string['cronremotepassword'] = 'Cron password per accesso remoto';
$string['cronwarning'] = 'Lo <a href="{$a}">script cron.php</a> non è stato eseguito da almeno 24 ore.';
$string['cronwarningcli'] = 'Lo script cli/cron.php non è stato eseguito da almeno 24 ore';
$string['ctyperequired'] = 'L\'estensione ctype PHP è richiesta da Moodle, per migliorare le performance del sito e offrire compatibilità multilingua.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'L\'estensione PHP cURL è ora necessaria a Moodle per comunicare  con i repostory Moodle.';
$string['curltimeoutkbitrate'] = 'Bitrate da usare per calcolare il timeout del cURL (kbps)';
$string['curltimeoutkbitrate_help'] = 'L\'impostazione è utilizzata per calcolare il  timeout appropriato durante richieste cURL molto grandi. Il calcolo viene effettuato effettuando una request HTTP HEAD per conoscere la dimensione del contenuto. Impostando il valore a 0 , la request non verrà effettuata.';
$string['currenttheme'] = 'Tema in uso';
$string['customcheck'] = 'Altri controlli';
$string['custommenu'] = 'Menu personalizzato';
$string['custommenuitems'] = 'Elementi menu personalizzato';
$string['customusermenuitems'] = 'Elementi menu utente';
$string['datarootsecurityerror'] = '<p><strong>AVVISO PER LA SICUREZZA!</strong></p><p>La tua cartella dataroot directory è in una posizione sbagliata ed è esposta al web. Questo significa che tutti i tuoi file privati sono accessibili da chiunque nel mondo, e qualcuno di questi potrebbe essere usato da un cracker per ottenere un accesso non autorizzato come amministartore del tuo sito!</p>
<p><em>Devi</em> spostare la cartella dataroot ({$a}) in un\'altra posizione che non sia nella cartella pubblica per il web, e aggiornare di conseguenza l\'impostazione <code>$CFG->dataroot</code> nel tuo config.php.</p>';
$string['datarootsecuritywarning'] = 'La configurazione del tuo sito potrebbe non essere al sicuro. Accertati che la tua cartella dataroot ({$a}) non sia direttamente accessibile via web.';
$string['dbsessions'] = 'Usa il database per le informazioni di sessione';
$string['debug'] = 'Livello di debug';
$string['debugall'] = 'TUTTI: Visualizza i più significativi messaggi di debug del PHP';
$string['debugdeveloper'] = 'SVILUPPATORE: messaggi extra di debug per sviluppatori Moodle';
$string['debugdisplay'] = 'Visualizza messaggi di debug';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MINIMO: Visualizza solo gli errori irreversibili';
$string['debugnone'] = 'NESSUNO: Non visualizzare errori né warning';
$string['debugnormal'] = 'NORMALE: Visualizza errori, warning e notice';
$string['debugpageinfo'] = 'Visualizza le informazioni di pagina';
$string['debugsmtp'] = 'Debug per l\'invio di email';
$string['debugstringids'] = 'Visualizza la provenienza delle stringhe della lingua';
$string['debugstringids_desc'] = 'Consente la facilitazione del lavoro dei traduttori: attivandola, posponendo all\'URL il parametro strings=1, verrà visualizzata la provenienza di ciascuna  stringa della lingua.';
$string['debugvalidators'] = 'Visualizza i link ai validator';
$string['defaultcity'] = 'Città di default';
$string['defaultcity_help'] = 'La città utilizzata per default durante la creazione di nuovi account';
$string['defaultformatnotset'] = 'Si è verificato un errore durante l\'individuazione del formato di corso di default. Per favore controlla le impostazioni del sito.';
$string['defaulthomepage'] = 'Home page di default per gli utenti';
$string['defaultrequestcategory'] = 'Categoria per i corsi a richiesta';
$string['defaultsettinginfo'] = 'Default: {$a}';
$string['defaultuserroleid'] = 'Ruolo di default per tutti gli utenti';
$string['deleteincompleteusers'] = 'Elimina gli utenti con profilo non completato dopo';
$string['deleteunconfirmed'] = 'Elimina gli utenti non confermati dopo';
$string['deleteuser'] = 'Elimina l\'utente';
$string['density'] = 'Densità';
$string['denyemailaddresses'] = 'Domini di posta non autorizzati';
$string['development'] = 'Sviluppo';
$string['devicedetectregex'] = 'Regular expression per il riconoscimento del dispositivo';
$string['devicedetectregex_desc'] = '<p>Per default Moodle è in grado di riconoscere dispositivi tradizionali (PC desktop, laptop, ecc.), dispositivi mobili (telefoni e palmari), tablet (iPad e tablet Android) e dispositivi obsoleti (utenti di Internet Explorer 6). Il selettore tema può essere utilizzato per scegliere quale tema utilizzare in base al dispositivo riconsociuto. L\'impostazione consente l\'uso di regular experession per l\'individuazione di ulteriori dispositivi (che avranno la precedenza rispetto ai dispositivi di default).</p>
<p>Per esempio puoi utilizzare la regular expression \'/(MIDP-1.0|Maemo|Windows CE)/\' per riconoscere alcuni dispositivi di uso frequente e riportare il valore "featurephone". Tale impostazione farà comparire "featurephone" nel Selettore tema consentendoti di usare il tema appropriato al dispositivo. Gli altri telefoni useranno il tema scelto per i dispositivi Mobili.</p>';
$string['devicedetectregexexpression'] = 'Regular expression';
$string['devicedetectregexvalue'] = 'Valore di ritorno';
$string['devicetype'] = 'Tipo di dispositivo';
$string['disableuserimages'] = 'Disabilita immagini profilo utente';
$string['displayerrorswarning'] = 'Abilitare l\'impostazione PHP <em>display_errors</em> non è raccomandato sui siti di produzione perché alcuni messaggi di errore potrebbero rivelare informazioni sensibili del tuo server.';
$string['displayloginfailures'] = 'Visualizza login errati';
$string['dndallowtextandlinks'] = 'Caricamento testi/link via trascina e rilascia';
$string['doclang'] = 'Lingua per la documentazione';
$string['docroot'] = 'URL del sito di documentazione di Moodle';
$string['doctonewwindow'] = 'Apri in una nuova finestra';
$string['download'] = 'Download';
$string['edithelpdocs'] = 'Modifica documenti di Help';
$string['editlang'] = '<b>Modifica</b>';
$string['editorbackgroundcolor'] = 'Colore di sfondo';
$string['editordictionary'] = 'Dizionario per editor';
$string['editorfontfamily'] = 'Famiglia di font';
$string['editorfontlist'] = 'Elenco di font';
$string['editorfontsize'] = 'Dimensione font';
$string['editorhidebuttons'] = 'Pulsanti nascosti';
$string['editorkillword'] = 'Filtro Word';
$string['editorspelling'] = 'Spelling per editor';
$string['editorspellinghelp'] = 'Abilita o disabilita lo spell-checking. Se abilitato <strong>aspell</strong> deve essere installato sul server.';
$string['editstrings'] = 'Modifica parole o frasi';
$string['emailchangeconfirmation'] = 'Conferma cambio email';
$string['emoticonalt'] = 'Testo alternativo';
$string['emoticoncomponent'] = 'Componente immagine';
$string['emoticonimagename'] = 'Nome immagine';
$string['emoticons'] = 'Emoticon (faccine)';
$string['emoticons_desc'] = 'Il form presenta le faccine (emoticon) in uso nel sito. Per eliminare una riga, salva il form con il campo vuoto. Per aggiungere una faccina, inseriscila sull\'ultimo campo vuoto disponibile. Per reimpostare tutte le faccine, usa il link soprastante.

* Testo (obbligatorio) - Il testo sarà sostituito con la faccina. Il testo deve essere lungo almeno due caratteri.
* Nome immagine (obbligatorio) - Il nome del file contenente l\'immagine della faccina, senza estensione, relativo al folder pix del componente.
* Componente immagine (obbligatorio) - Il componente che fornisce l\'icona
* Testo alternativo (opzionale) - Identificativo della stringa e del componente del testo alternativo alla faccina.';
$string['emoticonsreset'] = 'Ripristina le impostazioni delle faccine ai valori di default';
$string['emoticontext'] = 'Testo';
$string['emptysettingvalue'] = 'Vuoto';
$string['enableblogs'] = 'Abilita blog';
$string['enablecalendarexport'] = 'Abilita l\'esportazione del calendario';
$string['enablecomments'] = 'Abilita commenti';
$string['enablecourserequests'] = 'Abilita Corsi a richiesta';
$string['enablecssoptimiser'] = 'Abilita ottimizzatore CSS';
$string['enablecssoptimiser_desc'] = 'I CSS saranno sottoposti ad un processo di ottimizzazione prima di essere memorizzati nella cache. L\'ottimizzazione rimuove stili e regole duplicati e spazi vuoti.
Da notare che l\'attivazione di questa opzione assieme alla modalità Theme designer avrà effetti pessimi sulle performance ma consentirà di creare CSS ottimizzati.';
$string['enabled'] = 'Abilitato';
$string['enabledevicedetection'] = 'Abilita riconoscimento dispositivo';
$string['enablegravatar'] = 'Abilita Gravatar';
$string['enablegravatar_help'] = 'Nel caso in cui l\'utente non abbia caricato la propria immagine nel profilo, Moodle tenterà di recuperarla da Gravatar';
$string['enablemobilewebservice'] = 'Abilita web service per dispositivi mobili';
$string['enablerecordcache'] = 'Abilita cache dei record';
$string['enablerssfeeds'] = 'Abilita feed RSS';
$string['enablesafebrowserintegration'] = 'Abilita integrazione Safe Exam Browser';
$string['enablestats'] = 'Abilita statistiche';
$string['enabletgzbackups'] = 'Abilita nuovo formato di backup';
$string['enabletgzbackups_desc'] = 'I backup saranno creati comprimendo internamente i file .mbz in .tar.gz, rimuovendo la limitazione dimensionale dei backup di 4GB.';
$string['enabletrusttext'] = 'Abilita contenuto affidabile';
$string['enablewebservices'] = 'Abilita Web service';
$string['enablewsdocumentation'] = 'Documentazione web service';
$string['enrolinstancedefaults'] = 'Default per le istanze del plugin di iscrizione';
$string['enrolinstancedefaults_desc'] = 'Le impostazioni di default del plugin di iscrizione quando si creano nuovi corsi.';
$string['enrolmultipleusers'] = 'Iscrivi gli utenti';
$string['environment'] = 'Ambiente';
$string['environmenterrortodo'] = 'Devi risolvere tutti i problemi ed errori riscontrati prima di procedere con l\'installazione della versione di Moodle selezionata.';
$string['environmenterrorupgrade'] = 'Attenzione: devono essere risolti tutti i problemi ambientali (errori) individuati prima di procedere con l\'aggiornamento della versione di Moodle! L\'aggiornamento senza la soluzione di questi problemi può causare problemi come la perdita di dati. Sei sicuro di continuare comunque con l\'aggiornamento?';
$string['environmentmustfixsetting'] = 'Le impostazioni del PHP devono essere modificate.';
$string['environmentok'] = 'Il tuo server possiede tutti i requisiti minimi necessari.';
$string['environmentrecommendcustomcheck'] = 'Se questo test non ha successo, esiste un potenziale problema.';
$string['environmentrecommendinstall'] = 'L\'installazione e attivazione è consigliata per ottenere migliori risultati';
$string['environmentrecommendversion'] = 'Versione minima consigliata: {$a->needed}.  Versione in uso: {$a->current}';
$string['environmentrequirecustomcheck'] = 'questo test deve passare con successo';
$string['environmentrequireinstall'] = 'E\' necessaria l\'installazione e attivazione';
$string['environmentrequireversion'] = 'Versione minima necessaria: {$a->needed}. Versione in uso: {$a->current}';
$string['environmentsettingok'] = 'Sono state riscontrate le impostazioni consigliate';
$string['environmentshouldfixsetting'] = 'Le impostazioni del PHP dovrebbero essere modificate.';
$string['environmentxmlerror'] = 'Errore durante la lettura dei dati dell\'ambiente ({$a->error_code})';
$string['errordeletingconfig'] = 'Si è verificato un errore durante l\'eliminazione del record di configurazioni del plugin \'{$a}\'.';
$string['errorsetting'] = 'Non è possibile salvare l\'impostazione:';
$string['errorwithsettings'] = 'Alcune impostazioni non sono state cambiate a causa di un errore.';
$string['everyonewhocan'] = 'Chiunque possa \'{$a}\'';
$string['exceptions'] = 'eccezioni';
$string['execpathnotallowed'] = 'Disabilitazione dei percorsi locali e degli eseguibili in config.php';
$string['experimental'] = 'Sperimentale';
$string['experimentalsettings'] = 'Impostazioni sperimentali';
$string['extendedusernamechars'] = 'Consenti l\'uso di caratteri speciali negli username';
$string['extramemorylimit'] = 'Extra PHP memory limit';
$string['fatalsessionautostart'] = '<p>E\' stato rilevato un grave errore di configurazione, per favore avvertire l\'amministratore del server.</p><p> Per funzionare correttamente, Moodle ha bisogno che l\'amministratore modifichi le impostazioni del PHP..</p><p><code>session.auto_start</code> deve essere impostato ad <code>off</code>.</p><p>E\' possibile modificare questa impostazione nel file <code>php.ini</code>, nella configurazione di Apache/IIS <br /> oppure usando file <code>.htaccess</code>.</p>';
$string['filecreated'] = 'Nuovo file creato';
$string['filestoredin'] = 'Salva il file nella cartella:';
$string['filestoredinhelp'] = 'Dove sarà memorizzato il file';
$string['filterall'] = 'Filtra tutte le stringhe';
$string['filtermatchoneperpage'] = 'Filtra occorrenze una volta per pagina';
$string['filtermatchonepertext'] = 'Filtra occorrenze una volta per testo';
$string['filters'] = 'Filtri';
$string['filtersettings'] = 'Gestione filtri';
$string['filtersettingsgeneral'] = 'Impostazioni generali filtro';
$string['filteruploadedfiles'] = 'Applica filtro sui file inviati';
$string['forcelogin'] = 'Autenticazione obbligatoria';
$string['forceloginforprofileimage'] = 'Autenticazione obbligatoria per  visualizzare le immagini utente';
$string['forceloginforprofileimage_help'] = 'Gli utenti dovranno autenticarsi per poter visualizzare le immagini contenute nel profilo personale di altri utenti. Nei messaggi email al posto dell\'immagine dell\'utente verrà utilizzata l\'immagine di default.';
$string['forceloginforprofiles'] = 'Autenticazione obbligatoria per accedere ai profili';
$string['forcetimezone'] = 'Forza il fuso orario';
$string['formatuninstallwithcourses'] = 'Sono presenti {$a->count} corsi che usano il formato  {$a->format}. Il formato di questi corsi sarà cambiato con il formato di default del sito,  {$a->defaultformat}. Alcuni dati specifici del formato potrebbero andare perduti. Sei sicuro di proseguire ?';
$string['frontpage'] = 'Pagina home';
$string['frontpagebackup'] = 'Backup';
$string['frontpagedefaultrole'] = 'Ruolo di default per la pagina home';
$string['frontpagefilters'] = 'Filtri';
$string['frontpageloggedin'] = 'Elementi della pagina home dopo il login';
$string['frontpageoverrides'] = 'Modifiche ai privilegi della Pagina home';
$string['frontpagequestions'] = 'Domande';
$string['frontpagerestore'] = 'Ripristino';
$string['frontpageroles'] = 'Ruoli';
$string['frontpagesettings'] = 'Impostazioni';
$string['fullnamedisplay'] = 'Formato del nome completo';
$string['fullnamedisplayprivate'] = 'Formato del nome completo - privato';
$string['gdrequired'] = 'L\'estensione GD è ora necessaria a Moodle per la conversione delle immagini.';
$string['generalsettings'] = 'Impostazioni generali';
$string['geoipfile'] = 'File dati GeoIP City';
$string['getremoteaddrconf'] = 'Sorgente degli indirizzi IP logged';
$string['googlemapkey3'] = 'Google Maps API V3 key';
$string['googlemapkey3_help'] = 'Per visualizzare con Google Maps le località corrispondenti agli indirizzi IP, è\' necessario inserire una chiave che può essere ottenuta gratuitamente su <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Vai alla prima stringa mancante';
$string['gradebook'] = 'Registro valutazioni';
$string['gradebookroles'] = 'Ruoli riportati nel registro';
$string['gradeexport'] = 'Formati preferiti per l\'esportazione delle valutazioni';
$string['gravatardefaulturl'] = 'URL di default per l\'immagine Gravatar';
$string['gravatardefaulturl_help'] = 'Il servizio Gravatar ha bisogno di un URL di un\'immagine di default nel caso in cui non riesca a reperire l\'immagine dell\'utente. E\' necessario inserire l\'URL completa dell\'immagine. Non impostando l\'URL di default, Moodle tenterà di usare l\'immagine più appropriata in relazione alla pagina visualizzata. Da notare che Gravatar consente di usare diversi codici per <a href="https://en.gravatar.com/site/implement/images/#default-image">generare immagini di default.</a>.';
$string['groupenrolmentkeypolicy'] = 'Regole chiavi iscrizione ai gruppi';
$string['groupenrolmentkeypolicy_desc'] = 'Attiva le stesse regole delle password per le chiavi di iscrizione ai gruppi.';
$string['guestroleid'] = 'Ruolo per gli ospiti';
$string['guestroleid_help'] = 'Questo ruolo viene assegnato automaticamente agli ospiti. Viene anche assegnato temporaneamente a quegli utenti che pur non iscritti ad un corso vi accedono tramite il plugin iscrizione ospiti.';
$string['helpadminseesall'] = 'Gli amministratori potranno visualizzare nel calendario tutti gli eventi anziché i soli  eventi che li riguardano.';
$string['helpcalendarcustomexport'] = 'Consente la configurazione di intervalli di date personalizzate per l\'esportazione del calendario. L\'impostazione funziona solo se è abilitata anche l\'esportazione del calendario';
$string['helpexportlookahead'] = 'Il numero di giorni futuri da includere nell\'esportazione:';
$string['helpexportlookback'] = 'Il numero di passati futuri da includere nell\'esportazione:';
$string['helpforcetimezone'] = 'E\' possibile autorizzare gli utenti a selezionare il proprio fuso orario, oppure imporre a tutti gli utenti l\'uso dello stesso fuso orario.';
$string['helpshowicalsource'] = 'Consente la visualizzazione del nome della sottoscrizione e del relativo link per gli eventi importati da iCal.';
$string['helpsitemaintenance'] = 'Per aggiornamenti e altro lavoro.';
$string['helpstartofweek'] = 'Il giorno con cui inizia la settimana';
$string['helpupcominglookahead'] = 'Valore predefinito del numero di giorni futuri dove il calendario cercherà i prossimi eventi.';
$string['helpupcomingmaxevents'] = 'Valore predefinito del numero massimo di eventi prossimi da visualizzare.';
$string['helpweekenddays'] = 'I giorni del weekend saranno visualizzati nel calendario con un colore diverso.';
$string['hiddenuserfields'] = 'Nascondi i campi utente';
$string['hidefromall'] = 'Nascondi a tutti gli utenti';
$string['hidefromnone'] = 'Non nascondere a nessuno';
$string['hidefromstudents'] = 'Nascondi agli studenti';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Impostazioni editor HTML';
$string['htmlsettings'] = 'Impostazioni HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Sicurezza HTTP';
$string['hubs'] = 'Hub';
$string['iconvrequired'] = 'E\' necessario installare l\'estensione ICONV.';
$string['ignore'] = 'Ignora';
$string['includemoduleuserdata'] = 'Includi i dati utente presenti nei moduli';
$string['incompatibleblocks'] = 'Blocchi non compatibili';
$string['installhijacked'] = 'Spiacente, l\'installazione deve essere completata dallo stesso indirizzo IP dal quale è stata avviata.';
$string['installsessionerror'] = 'Non è possibile inizializzare la sessione PHP, per favore verifica che il browser accetti i cookie.';
$string['intlrecommended'] = 'L\'estensione intl migliora il supporto all\'internazionalizzazione, come l\'ordinamento in accordo alle impostazioni locali';
$string['invalidsection'] = 'Sezione non valida';
$string['invaliduserchangeme'] = 'Il nome utente "changeme" è riservato - non è possibile creare utenti con quel nome utente.';
$string['ipblocked'] = 'Questo sito non è al momento disponibile.';
$string['ipblocker'] = 'Blocco IP';
$string['ipblockersyntax'] = 'Inserire un IP per ogni linea. E\' possibile inserire un indirizzo IP completo (ad esempio <b>192.168.10.1</b>) per un singolo host, oppure un indirizzo IP parziale (ad esempio <b>192.168.</b>) per includere tutti gli indirizzi che iniziano con questi numeri. E\' anche possibile usare la notazione CIDR (ad esempio <b>231.54.211.0/20</b>) oppure un intervallo (ad esempio <b>231.3.56.10-20</b>), dove l\'intervallo è specificato dalle ultime quattro cifre. I nomi di dominio non sono supportati. Le linee lasciate vuote non saranno utilizzate.';
$string['iplookup'] = 'Ricerca indirizzo IP';
$string['iplookupgeoplugin'] = 'Per ricavare le informazioni geografiche viene utilizzato il servizio <a href="http://www.geoplugin.com">geoPlugin</a>. Per informazioni più accurate si raccomanda di installare una copia locale del database MaxMind GeoLite.';
$string['iplookupinfo'] = 'Per default Moodle usa il server online gratuito NetGeo (The Internet Geographic Database) per cercare le località degli indirizzi IP. Sfortunatamente questo server non è più aggiornato e può rispondere con dati <em>non corretti</em>. Si raccomanda di installare localmente una copia del database gratuito GeoLite City da MaxMind.<br/>
Le località degli indirizzi IP sono visualizzate su una semplice mappa o usando Google Maps. Notare che bisogna avere un Google account e richiedere una Google Maps API key gratuita per abilitare le mappe interattive.';
$string['iplookupmaxmindnote'] = 'Questo prodotto include dati GeoLite creati da MaxMind, disponibili su <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Mantieni maiuscole/minuscole nei tag';
$string['lang'] = 'Lingua di default';
$string['langcache'] = 'Cache del menu delle lingue';
$string['langcache_desc'] = 'Cache del menu del lingue. Consente di avere in cache l\'elenco delle traduzioni disponibili. La cache viene aggiornata tutte le volte che si installa o si elimina in language pack tramite il gestore dei language pack di Moodle. Se installi un language pack a mano, per aggiornare la cache dovrai ricordarti di usare la funzione "Svuota tutte le cache".';
$string['langlist'] = 'Lingue sul menu delle lingue';
$string['langmenu'] = 'Visualizza il menu delle lingue';
$string['langpackwillbeupdated'] = 'NOTA: Durante l\'aggiornamento, Moodle cercherà di aggiornare il language pack in uso.';
$string['langstringcache'] = 'Usa la cache per tutte le stringhe delle lingue';
$string['languagesettings'] = 'Impostazioni lingua';
$string['latinexcelexport'] = 'Codifica Excel';
$string['legacyfilesaddallowed'] = 'Consenti utilizzo dei file legacy del corso';
$string['legacyfilesaddallowed_help'] = 'Consente di aggiungere file e cartelle usando i file legacy del corso.';
$string['legacyfilesinnewcourses'] = 'File del corso legacy per i nuovi corsi';
$string['legacyfilesinnewcourses_help'] = 'Per default l\'area file del corso legacy è disponibile solamente nei corsi migrati da versioni precedenti. Si precisa che alcune funzionalità, ad esempio il backup/ripristino di singole attività non sono compatibili con questa impostazione';
$string['licensesettings'] = 'Impostazioni licenza';
$string['linkadmincategories'] = 'Visualizza link alle categorie di amministrazione';
$string['linkadmincategories_help'] = 'Consente di visualizzare nel blocco navigazione i link alle pagine con le categorie della amministrazione del sito';
$string['loading'] = 'Caricamento in corso';
$string['localetext'] = 'Localizzazione del sito';
$string['localstringcustomization'] = 'Personalizzazione locale stringhe';
$string['location'] = 'Localizzazione';
$string['locationsettings'] = 'Impostazioni';
$string['locked'] = 'Bloccato';
$string['lockoutduration'] = 'Durata del blocco del profilo utente';
$string['lockoutduration_desc'] = 'I profili utente bloccati saranno sbloccati automaticamente non appena trascorso il tempo impostato.';
$string['lockoutemailbody'] = 'Il tuo profilo utente {$a->username} sul server \'{$a->sitename}\' è stato bloccato a causa di ripetuti tentativi di autenticazione falliti.

Per sbloccare il profilo puoi usare il seguente indirizzo:

{$a->link}

Nella maggioranza dei programmi di posta elettronica il link di solito appare colorato di blu ed è possibile fare click per utilizzarlo. Se il link non funziona, copialo ed incollalo nella barra degli indirizzi del browser.

Se hai bisogni di aiuto, contatta l\'amministratore del sito: {$a->admin}';
$string['lockoutemailsubject'] = 'Il tuo profilo utente su {$a} è stato bloccato';
$string['lockouterrorunlock'] = 'Sono state fornite informazioni non valide per lo sblocco del profilo utente.';
$string['lockoutthreshold'] = 'Soglia per il blocco del profilo utente';
$string['lockoutthreshold_desc'] = 'E\' possibile impostare la soglia di login errati oltre la quale il profilo utente sarà bloccato. Un attacco Denial of Service potrebbe abusare di questa impostazione.';
$string['lockoutwindow'] = 'Finestra temporale di osservazione per il blocco del profilo utente';
$string['lockoutwindow_desc'] = 'Il tempo di osservazione per la soglia di blocco, in assenza di login errati il contatore della soglia viene azzerato non appena trascorso il tempo impostato';
$string['log'] = 'Log';
$string['logguests'] = 'Log accesso ospite';
$string['logguests_help'] = 'L\'impostazione abilita il log delle azioni svolte dall\'account ospite e dagli utenti non autenticati. Siti molto trafficati possono disabilitare il logo di queste azioni per motivi di performance. Nei siti di produzione si raccomanda di mantenere log accesso ospite abilitato.';
$string['loginhttps'] = 'Usa HTTPS per i login';
$string['loginpageautofocus'] = 'Focus automatico nella maschera di autenticazione';
$string['loginpageautofocus_help'] = 'L\'impostazione migliora l\'usabilità della maschera di autenticazione, tuttavia il focus automatico dei campi può essere considerato un problema per l\'accessibilità.';
$string['loginpasswordautocomplete'] = 'Evita auto completamento password nella schermata di login';
$string['loginpasswordautocomplete_help'] = 'Gli utenti non potranno salvare la propria password nel browser.';
$string['loglifetime'] = 'Conserva i log per';
$string['logstorenotrequired'] = 'Log store non richiesto';
$string['logstoressupported'] = 'Log store che supportato il report';
$string['longtimewarning'] = '<b>Da notare che questo processo può durare molto tempo.</b>';
$string['maintenancemode'] = 'In modalità manutenzione';
$string['maintenancemodeisscheduled'] = 'Il sito sarà posto in modalità manutenzione tra {$a->min} minuti e  {$a->sec} secondi';
$string['maintfileopenerror'] = 'Errore aprendo i file di manutenzione!';
$string['maintinprogress'] = 'Manutenzione in corso...';
$string['manageformats'] = 'Gestione formati dei corsi';
$string['manageformatsgotosettings'] = 'Il formato di default può essere cambiato in {$a}';
$string['managelang'] = 'Gestione';
$string['managelicenses'] = 'Gestione licenze';
$string['manageqbehaviours'] = 'Gestione comportamenti domande';
$string['manageqtypes'] = 'Gestione tipi domande';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Release candidate';
$string['maturity200'] = 'Versione stabile';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Suggerimento: se desideri eseguire questo script, usa l\'opzione -allow-unstable';
$string['maturitycoreinfo'] = 'Il tuo sito gira con codice di sviluppo non stabile "{$a}".';
$string['maturitycorewarning'] = 'Stai per installare o aggiornare Moodle alla versione "{$a}". Non trattandosi di una versione pronta per andare in produzione, accertati che tu voglia effetivamente installare/aggiornare con questa versione e che tu abbia effettuato il checkout della versione desiderata del codice sorgente di Moodle.';
$string['maxbytes'] = 'Dimensione massima upload';
$string['maxconsecutiveidentchars'] = 'Caratteri identici consecutivi';
$string['maxeditingtime'] = 'Tempo massimo per l\'editing dei messaggi';
$string['maxtimelimit'] = 'Tempo massimo';
$string['maxtimelimit_desc'] = 'E\' possibile impostare il tempo massimo di elaborazione, espresso in secondi, che Moodle potrà attenderà in assenza di elementi da visualizzare. Con un valore pari a zero, Moodle userà i valori di default. In presenza di server di front end con propri limiti di tempo massimo, impostare questo valore ad un limite più basso per ricevere gli errori PHP nel log. Il valore non influenza gli script CLI.';
$string['maxusersperpage'] = 'Numero max. utenti per pagina';
$string['mbstringrecommended'] = 'Installare la libreria opzionale MBSTRING è fortemente consigliato per migliorare le prestazioni, in particolare se il sito usa lingue non latine.';
$string['mediapluginavi'] = 'Abilita filtro .avi';
$string['mediapluginflv'] = 'Abilita filtro .flv';
$string['mediapluginimg'] = 'Abilita incorporazione automatica di immagini collegate';
$string['mediapluginmov'] = 'Abilita filtro .mov';
$string['mediapluginmp3'] = 'Abilita filtro .mp3';
$string['mediapluginmpg'] = 'Abilita filtro .mpg';
$string['mediapluginogg'] = 'Abilita filtro .ogg';
$string['mediapluginogv'] = 'Abilita filtro .ogv';
$string['mediapluginram'] = 'Abilita filtro .ram';
$string['mediapluginrm'] = 'Abilita filtro .rm';
$string['mediapluginrpm'] = 'Abilita filtro .rpm';
$string['mediapluginswf'] = 'Abilita filtro .swf';
$string['mediapluginswfnote'] = 'Come misura di sicurezza, gli utenti normali non dovrebbero essere autorizzati ad includere file swf flash';
$string['mediapluginwmv'] = 'Abilita filtro .wmv';
$string['mediapluginyoutube'] = 'Abilita filtro link YouTube';
$string['messaging'] = 'Abilita il sistema di messaging';
$string['messagingallowemailoverride'] = 'Consenti ridefinizione notifiche email';
$string['messagingdeletereadnotificationsdelay'] = 'Elimina notifiche lette';
$string['messaginghidereadnotifications'] = 'Nascondi notifiche lette';
$string['minpassworddigits'] = 'Cifre';
$string['minpasswordlength'] = 'Lunghezza password';
$string['minpasswordlower'] = 'Lettere minuscole';
$string['minpasswordnonalphanum'] = 'Caratteri non alfanumerici';
$string['minpasswordupper'] = 'Lettere maiuscole';
$string['misc'] = 'Generale';
$string['mnetrestore_extusers'] = '<strong>Nota:</strong> Questo file di backup contiene registrazioni di utenti di Moodle remoti in rete che saranno restorate come parte del processo.';
$string['mnetrestore_extusers_admin'] = '<strong>Nota:</strong> Questo file di backup sembra essere stato generato da un\'altra installazione di Moodle e contiene account di utenti Moodle Network. Il processo di ripristino tenterà di associare gli host Moodle Network a ciascun utente da creare. Gli utenti per i quali non sarà possibile l\'associazione, saranno configurati con l\'autenticazione interna al posto della autenticazione mnet. I log del ripristino conterrà informazioni al riguardo.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Nota:</strong> Questo file di backup sembra essere stato generato da un\'altra installazione di Moodle e contiene account di utenti Moodle Network il cui ripristino potrebbe non andare a buon fine. Questa operazione non è supportata. Se sei sicuro che il backup sia stato creato da questa installazione di Moodle, o sei certi che tutti gli host Moodle Network sono configurati, allora è possibile provare ad eseguire il ripristino.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Nota:</strong> Questo file di backup sembra essere stato generato da un\'altra installazione di Moodle e contiene account di utenti Moodle Network. Non sei autorizzato ad eseguire questo tipo di ripristino. Contatta l\'amministratore del sito oppure ripristina il corso senza informazioni sugli utenti (moduli, file...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Il metodo di autenticazione dell\'utente remoto {$a->username} (proveniente da {$a->mnethosturl}) è stato cambiato in autenticazione {$a->auth} locale.';
$string['mobile'] = 'Mobile';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Usa il selettore attività per default';
$string['modeditdefaults'] = 'Valori di default dell\'attività';
$string['modeditingmenu'] = 'Menu modifica attività';
$string['modeditingmenu_desc'] = 'La maggior parte delle icone di modifica delle attività visualizzate quando la modifica del corso è attiva saranno visualizzate all\'interno di un menu a discesa, riducendo l\'affollamento di icone nello schermo.';
$string['modsettings'] = 'Gestione attività';
$string['modulesecurity'] = 'Restrizioni sui Moduli';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Forza la vecchia sintassi multilingua: &lt;span&gt; senza la class="multilang" e &lt;lang&gt;';
$string['mustenablestats'] = 'Le statistiche non sono state abilitate su questo sito';
$string['mycoursesperpage'] = 'Numero di corsi';
$string['mydashboard'] = 'Dashboard di sistema di default';
$string['mymoodle'] = 'My home';
$string['mymoodleredirect'] = 'Obbliga gli utenti a usare My Moodle';
$string['mypage'] = 'Pagina My home di default';
$string['mypagelocked'] = 'Blocca pagina di default';
$string['myprofile'] = 'Pagina profilo di default';
$string['navadduserpostslinks'] = 'Aggiungi link per visualizzare gli interventi dell\'utente';
$string['navadduserpostslinks_help'] = 'Consente di aggiungere due link per ciascun utente utili per visualizzare i suoi interventi e  discussioni nei forum a livello di sito o di corso';
$string['navcourselimit'] = 'Max. corsi';
$string['navexpandmycourses'] = 'Espandi \'I miei corsi\' nella pagina My home';
$string['navexpandmycourses_desc'] = 'Il ramo \'I miei corsi\' verrà visualizzato espanso quando si accede alla pagina My home e alle pagine di pertinenza dell\'area My home.';
$string['navigationupgrade'] = 'Questo aggiornamento introduce due nuovi blocchi per la navigazione che andranno a sostituire i seguenti blocchi: Amministrazione, Corsi, Attività e Partecipanti. Se hai configurato questi blocchi con privilegi particolari, dovrai verificare che tutto funzioni come atteso.';
$string['navshowallcourses'] = 'Visualizza tutti i corsi';
$string['navshowcategories'] = 'Visualizza categorie di corso';
$string['navshowfrontpagemods'] = 'Visualizza le attività della home page del sito nella navigazione';
$string['navshowfrontpagemods_help'] = 'Consente di visualizzare le attività presenti nella home page del sito nel blocco navigazione al link Pagine del sito';
$string['navshowfullcoursenames'] = 'Visualizza i titoli dei corsi in forma non abbreviata';
$string['navshowfullcoursenames_help'] = 'Nella navigazione saranno visualizzati i titoli dei corsi al posto dei titoli abbreviati.';
$string['navshowmycoursecategories'] = 'Visualizza le categorie ne I miei corsi';
$string['navshowmycoursecategories_help'] = 'Consente la visualizzazione del nome delle categorie nel link \'I miei corsi\' del blocco navigazione';
$string['navsortmycoursessort'] = 'Ordinamento corsi';
$string['navsortmycoursessort_help'] = 'Imposta la visualizzazione dei corsi nel ramo I Miei corsi in base all\'ordinamento impostato in "Amministrazione del sito > Corsi > Gestione corsi e categorie" oppure alfabeticamente in in base alle impostazioni del corso.';
$string['neverdeleteruns'] = 'Non eliminare i run';
$string['nobookmarksforuser'] = 'Non hai alcun segnalibro';
$string['nodatabase'] = 'Nessun database';
$string['nohttpsformobilewarning'] = 'Si consiglia vivamente di abilitare HTTPS con un certificato valido, la app Moodle al primo tentativo di collegamento cercherà sempre di utilizzare una connessione sicura.';
$string['nomissingstrings'] = 'Non ci sono stringhe mancanti';
$string['nonewsettings'] = 'Questo aggiornamento non include nuove impostazioni';
$string['nonexistentbookmark'] = 'Il segnalibro richiesto non esiste';
$string['noresults'] = 'Nessun risultato';
$string['noroles'] = 'Nessun ruolo';
$string['nosupportedlogstore'] = 'Non sono presenti log store supportati';
$string['notifications'] = 'Avvisi';
$string['notifyloginfailures'] = 'Destinatari degli avvisi sui login errati';
$string['notifyloginthreshold'] = 'Soglia per l\'invio di avvisi tramite email';
$string['notloggedinroleid'] = 'Ruolo per i visitatori';
$string['numberofmissingstrings'] = 'Numero stringhe mancanti: {$a}';
$string['numberofstrings'] = 'Totale stringhe: {$a->strings}<br />Mancanti: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'La cache PHP opcode migliora le prestazioni e riduce la memoria utilizzata. L\'estensione OPcache è sia consigliata sia supportata.';
$string['opensslrecommended'] = 'E\' fortemente raccomandata l\'installazione della libreria opzionale OpenSSL -- questa abilita la funzionalità Moodle Networking.';
$string['opentogoogle'] = 'Aperto a Google';
$string['optionalmaintenancemessage'] = 'Messaggio opzionale per la  modalità manutenzione';
$string['order1'] = 'Primo';
$string['order2'] = 'Secondo';
$string['order3'] = 'Terzo';
$string['order4'] = 'Quarto';
$string['passwordpolicy'] = 'Regole password';
$string['passwordresettime'] = 'Tempo massimo validazione recupero password';
$string['pathtoclam'] = 'Percorso per clam AV';
$string['pathtodot'] = 'Percorso per dot';
$string['pathtodot_help'] = 'Percorso assoluto per l\'eseguibile dot, del tipo /usr/bin/dot. Per generare grafici a partire dai file DOT, è necessario installare l\'eseguibile dot e configurare il percorso. Da notare che per il momento dot è usato solamente per le funzioni di profilazione presenti in Moodle (Sviluppo->Profilazione)';
$string['pathtodu'] = 'Percorso per du';
$string['pathtogs'] = 'Percorso per ghostscript';
$string['pathtogs_help'] = 'Generalmente su installazioni Linux è possibile usare \'/usr/bin/gs. Su Windows probabilmente è possibile usare \'c:gsbingswin32c.exe\'. Accertarsi che non ci siano spazi nel percorso, nel caso copiare i file \'gswin32c.exe\' e \'gsdll32.dll\' in una cartella il cui percorso è privo di spazi.';
$string['pathtopgdump'] = 'Percorso per pg_dump';
$string['pathtopgdumpdesc'] = 'E\' nescessario solo se hai più di un pg_dump sul sistema (per esempio hai più versioni di postgresql installate)';
$string['pathtopgdumpinvalid'] = 'Percorso non valido per pg_dump - percorso errato o non eseguibile';
$string['pathtopsql'] = 'Path per psql';
$string['pathtopsqldesc'] = 'E\' nescessario solo se hai più di un psql sul sistema (per esempio hai più versioni di postgresql installate)';
$string['pathtopsqlinvalid'] = 'Percorso non valido per pgsql - percorso errato o non eseguibile';
$string['pcreunicodewarning'] = 'Si raccomanda di utilizzare l\'estensione PHP PCRE che è compatibile con i caratteri Unicode.';
$string['perfdebug'] = 'Visualizza prestazioni';
$string['performance'] = 'Prestazioni';
$string['pgcluster'] = 'Cluster PostgreSQL';
$string['pgclusterdescription'] = 'Parametro per le operazioni a linea di comando della versione/cluster di PostgreSQL. Se hai un solo postgresql sul sistema o non sei sicuro di cosa significhi, lascialo vuoto.';
$string['phpfloatproblem'] = 'E\' stato rilevato un problema inatteso durante l\'utilizzo di numeri a virgola mobile tramite PHP - {$a}';
$string['pleaserefreshregistration'] = 'Il sito è stato registrato con moodle.org. Puoi aggiornare la registrazione manualmente in qualsiasi momento. Per default l\'elaborazione pianificata \'Registrazione del sito\' aggiornerà periodicamente la registrazione in modo automatico.';
$string['pleaseregister'] = 'Registrando il sito questo pulsante verrà  rimosso';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugin';
$string['pluginscheck'] = 'Controllo dipendenze plugin';
$string['pluginscheckfailed'] = 'Il controllo delle dipendenze plugin è fallito per {$a->pluginslist}';
$string['pluginschecktodo'] = 'Devi soddisfare tutti i requisiti richiesti dai plugin prima di continuare con l\'installazione di questa versione di Moodle';
$string['pluginsoverview'] = 'Panoramica plugin';
$string['pluginsoverviewsee'] = 'Per maggiori informazioni è disponibile la pagina <a href="{$a->url}">panoramica plugin</a>';
$string['profilecategory'] = 'Categoria';
$string['profilecategoryname'] = 'Nome categoria (deve essere unico)';
$string['profilecategorynamenotunique'] = 'Nome categoria già in uso';
$string['profilecommonsettings'] = 'Impostazioni comuni';
$string['profileconfirmcategorydeletion'] = 'Questa categoria contiene {$a} campo/i. Eliminando la categoria, i campi saranno spostati nella categoria immediatamente superiore (oppure in quella immediatamente inferiore se stai eliminando la categoria di primo livello).<br/>Sei sicuro di eliminare questa categoria?';
$string['profileconfirmfielddeletion'] = 'Sono presenti {$a} record che contengono valori per questo campo. Eliminando il campo questi i valori saranno perduti.<br/>Sei sicuro di  eliminare questo campo?';
$string['profilecreatecategory'] = 'Crea una categoria per i campi personalizzati';
$string['profilecreatefield'] = 'Crea un campo personalizzato:';
$string['profilecreatenewcategory'] = 'Creazione di una categoria per i campi personalizzati';
$string['profilecreatenewfield'] = 'Creazione di un campo personalizzato \'{$a}\'';
$string['profiledefaultcategory'] = 'Altri campi';
$string['profiledefaultchecked'] = 'Questo campo Checkbox per default è spuntato';
$string['profiledefaultdata'] = 'Valore di default';
$string['profiledeletecategory'] = 'Eliminazione di una categoria';
$string['profiledeletefield'] = 'Eliminazione del campo \'{$a}\'';
$string['profiledescription'] = 'Descrizione del campo';
$string['profiledscript'] = 'Lo script è stato profilato';
$string['profiledscriptview'] = 'Visualizza le informazioni di profilazione dello script';
$string['profileeditcategory'] = 'Modifica categoria: {$a}';
$string['profileeditfield'] = 'Modifica campo personalizzato: {$a}';
$string['profilefield'] = 'Campi personalizzati';
$string['profilefieldcolumns'] = 'Colonne';
$string['profilefieldispassword'] = 'E\' un campo password?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Per trasformare un testo in un link, inserisci un URL contenente $$, dove $$ sarà sostituita dal testo. Ad esempio per trasformare un ID Twitter in in link, inserisci http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Link target';
$string['profilefieldmaxlength'] = 'Numero massimo caratteri';
$string['profilefieldrows'] = 'Righe';
$string['profilefields'] = 'Campi personalizzati';
$string['profilefieldsize'] = 'Numero caratteri visualizzati';
$string['profileforceunique'] = 'I dati devono essere univoci';
$string['profileinvaliddata'] = 'Valore non valido';
$string['profilelocked'] = 'Campo bloccato';
$string['profilemenudefaultnotinoptions'] = 'Il valore default non è una delle opzioni';
$string['profilemenunooptions'] = 'Nessuna opzione menu inserita';
$string['profilemenuoptions'] = 'Opzioni menu (una per riga)';
$string['profilemenutoofewoptions'] = 'Devi inserire almeno 2 opzioni';
$string['profilename'] = 'Nome';
$string['profilenofieldsdefined'] = 'Non ci sono campi personalizzati';
$string['profilerequired'] = 'Compilazione obbligatoria';
$string['profileroles'] = 'Ruoli visibili';
$string['profilesforenrolledusersonly'] = 'Profili utente visibili solo agli iscritti ai corsi';
$string['profileshortname'] = 'Nome abbreviato (univoco)';
$string['profileshortnamenotunique'] = 'Nome abbreviato già in uso';
$string['profilesignup'] = 'Da compilare nella pagina di creazione account';
$string['profilespecificsettings'] = 'Impostazioni specifiche';
$string['profilevisible'] = 'Visibilità del campo';
$string['profilevisibleall'] = 'Visibile a tutti';
$string['profilevisible_help'] = '<p>Ad ogni campo creato dall\'utente può essere assegnata una impostazione di visibilità: non visibile, visibile a tutti, visibile all\'utente. L\'impostazione \'non visibile\' sarà normalmente assegnata da un amministratore che vuole mantenere dati privati riguardanti gli utenti. L\'impostazione \'visibile all\'utente\' sarà di solito scelta per un campo contenente informazioni sensibili, mentre \'visibile a tutti\' potrà essere utilizzata per ogni tipo di informazione.
</p>';
$string['profilevisiblenone'] = 'Non visibile';
$string['profilevisibleprivate'] = 'Visibile all\'utente';
$string['profiling'] = 'Profiling';
$string['profilingallowall'] = 'Profiling continuo';
$string['profilingallowall_help'] = 'L\'impostazione consente di usare ovunque il parametro PROFILELALL, volto  al profiling di tutti gli script eseguiti durante la sessione Moodle. Per fermare il profiling è possibile usare il parametro PROFILESTOP.';
$string['profilingallowme'] = 'Profiling selettivo';
$string['profilingallowme_help'] = 'L\'impostazione consente di usare selettivamente (PGC) il parametro PROFILEME per ul profiling di specifici script. Per fermare il profiling è possibile usare il parametro DONTPROFILEME.';
$string['profilingautofrec'] = 'Profiling automatico';
$string['profilingautofrec_help'] = 'L\'impostazione attiverà il profiling automatico e casuale di richieste (basata sulla frequenza impostata, 1 su N). I risultati saranno memorizzati per successive analisi. Da notare che questo tipo di profiling tiene conto delle impostazioni di include/exclude. Il valore 0 disabilita il profiling automatic';
$string['profilingenabled'] = 'Abilita profiling';
$string['profilingenabled_help'] = 'L\'impostazione abilita le funzioni di profiling, il cui comportamento può essere regolato con le impostazioni che seguono';
$string['profilingexcluded'] = 'Escludi profiling';
$string['profilingexcluded_help'] = 'Elenco di URL (separato da virgole, esclusi wwwroot assoluti, richiamabili) che saranno escluse dal profiling rispetto a quelle definite nell\'impostazione "Profila questi"';
$string['profilingimportprefix'] = 'Prefisso importazione profiling';
$string['profilingimportprefix_desc'] = 'Per una più facile identificazione, tutti i profiling run importati avranno il prefisso specificato.';
$string['profilingincluded'] = 'Profila questi';
$string['profilingincluded_help'] = 'Elenco di URL (assolute, senza wwwroot, raggiungibili) separato da virgole da profilare automaticamente. Esempio: /index.php, /course/view.php. E\' anche possibile specificare il carattere jolly * in qualsiasi posizione. Esempio: mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Mantieni profiling run';
$string['profilinglifetime_help'] = 'Imposta il periodo di conservazione dei profiling run precedenti. I run più vecchi saranno periodicamente eliminati. Da notare che i run di riferimento non saranno eliminati.';
$string['protectusernames'] = 'Proteggi gli username';
$string['proxybypass'] = 'Proxy bypass host';
$string['proxyhost'] = 'Proxy host';
$string['proxypassword'] = 'Proxy password';
$string['proxyport'] = 'Porta proxy';
$string['proxytype'] = 'Tipo proxy';
$string['proxyuser'] = 'Proxy username';
$string['purgecaches'] = 'Svuota le cache';
$string['purgecachesconfirm'] = 'Moodle può tenere in cache temi, javascript, stringhe di lingua, testo filtrato, feed rss ed altri tipi di dati. Svuotando le cache i dati saranno eliminati dal server e il browser verrà costretto a ricaricarli, in questo modo potrai essere certo di visualizzare i dati più aggiornati. Svuotare le cache non presenta rischi, tuttavia il sito potrebbe subire un rallentamento fino a quando le cache non saranno ripristinate. ';
$string['purgecachesfinished'] = 'Tutte le cache sono state svuotate';
$string['quarantinedir'] = 'Cartella per quarantena';
$string['question'] = 'Domanda';
$string['questionbehaviours'] = 'Comportamenti della domanda';
$string['questioncwqpfscheck'] = 'Una o più domande "a caso" in un quiz sono impostate in modo da pescare le domande da un misto di categorie condivise e non. Esiste un <a href="{$a->reporturl}">report più dettagliato</a> e leggi anche la <a href="{$a->docsurl}">pagina</a> di Moodle Docs.';
$string['questioncwqpfsok'] = 'Bene. Non ci sono domande "a caso" nei tuoi quiz impostate in modo da pescare le domande da un misto di categorie condivise e non.';
$string['questiontype'] = 'Tipo domanda';
$string['questiontypes'] = 'Tipi domande';
$string['quizattemptsupgradedmessage'] = 'Moodle 2.1 ha introdotto un significativo aggiornamento alle domande. Sebbene sia stato possibile ritardare l\'aggiornamento del database, prima di migrare a Moodle 2.7 è indispensabile effettuare l\'aggiornamento.';
$string['recaptchaprivatekey'] = 'Chiave privata reCAPTCHA';
$string['recaptchapublickey'] = 'Chiave pubblica reCAPTCHA';
$string['register'] = 'Registra il tuo sito';
$string['registermoodleorg'] = 'Sito registrato il';
$string['registermoodleorgli1'] = 'Verrai inserito in una mailing list a basso traffico utile per ricevere notifiche importanti come avvisi di sicurezza e disponibilità di nuove versioni di Moodle.';
$string['registermoodleorgli2'] = 'Le statistiche relative al tuo sito saranno inserite nella comunità mondiale {$a} di Moodle.';
$string['registermoodleorgli3'] = 'Il tuo sito è registrato anche con il Moodle.net ({$a}). Tutti gli utenti che hanno il privilegio di pubblicare corsi (per default solo il ruolo manager) avranno la possibilità di pubblicarli su Moodle.net.';
$string['registerwithmoodleorg'] = 'Registra il tuo sito';
$string['registration'] = 'Registrazione';
$string['registration_help'] = 'Si consiglia di registrare il sito per ricevere avvisi di sicurezza ed accedere a Moodle.net, la nostra piattaforma di condivisione di corsi.';
$string['registrationwarning'] = 'Il tuo sito non è ancora registrato.';
$string['releasenoteslink'] = 'Per informazioni su questa versione di Moodle, si prega di consultare le <a target="_blank" href="{$a}">Note di rilascio</a> in linea';
$string['rememberusername'] = 'Ricorda username';
$string['rememberusername_desc'] = 'Memorizza un cookie permanente con lo username usato per il login. Tenere presente che i cookie permanenti possono rappresentare un problema di privacy se utilizzati in assenza di consenso.';
$string['reportsmanage'] = 'Gestione report';
$string['requestcategoryselection'] = 'Abilita selezione categoria';
$string['requiredentrieschanged'] = '<strong>IMPORTANTE - LEGGERE PER FAVORE<br/>(Questo messaggio sarà visualizzato solo durante questo aggiornamento)</strong><br/>A causa di un bug fix, cambierà il comportamento delle attività database che fanno uso della impostazione \'Numero minimo di record da inserire\' e \'Numero minimo di record da inserire prima di poter visualizzare il Database\'. Maggiori informazioni su <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">forum del modulo database </a>. Il comportamento atteso da queste impostazioni può essere anche letto su  <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>.
<br/><br/>Queste modifiche impattano i seguenti database presenti nel tuo sistema: (Per favore salva adesso l\'elenco e dopo l\'aggiornamento verifica che le attività elencate funzionino come previsto dai docenti.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Descrizione dell\'attività obbligatoria';
$string['requires'] = 'Richiede';
$string['restorecourse'] = 'Ripristina corso';
$string['restorernewroleid'] = 'Ruolo nel corso per l\'utente che ripristina';
$string['restorernewroleid_help'] = 'Se l\'utente che ripristina corsi non è autorizzato a gestire corsi ripristinati, allora all\'utente verrà assegnato questo ruolo e, se necessario, iscritto al corso. Scegli "Nessuno" se non si desidera autorizzare l\'utente che ripristina i corsi a gestire qualsiasi corso ripristinato.';
$string['reverseproxy'] = 'Reverse proxy';
$string['riskconfig'] = 'Gli utenti possono modificare la configurazione e il comportamento del sito';
$string['riskconfigshort'] = 'Configurazione';
$string['riskdataloss'] = 'L\'utente potrebbe essere in grado di distruggere grandi quantità di dati';
$string['riskdatalossshort'] = 'Rischio di perdita di dati';
$string['riskmanagetrust'] = 'Gli utenti possono modificare le impostazioni di affidabilità di altri utenti';
$string['riskmanagetrustshort'] = 'Gestione rischi';
$string['riskpersonal'] = 'Gli utenti possono avere accesso alle informazioni personali di altri utenti';
$string['riskpersonalshort'] = 'Privacy';
$string['riskspam'] = 'Gli utenti possono inviare spam agli utenti del sito o ad altri';
$string['riskspamshort'] = 'Spam';
$string['riskxss'] = 'Gli utenti possono aggiungere files e testi che consentono il cross-site scripting (XSS)';
$string['riskxssshort'] = 'XSS';
$string['roleswithexceptions'] = '{$a->roles}, con {$a->exceptions}';
$string['rssglobaldisabled'] = 'Disabilitato a livello server';
$string['runclamavonupload'] = 'Usa clam AV sui files caricati';
$string['save'] = 'Salva';
$string['savechanges'] = 'Salva modifiche';
$string['search'] = 'Cerca';
$string['searchinsettings'] = 'Cerca nelle impostazioni';
$string['searchresults'] = 'Risultati ricerca';
$string['sectionerror'] = 'Errore di sezione!';
$string['secureforms'] = 'Applica maggiore sicurezza per i form';
$string['security'] = 'Sicurezza';
$string['selectdevice'] = 'Seleziona dispositivo';
$string['selecttheme'] = 'Seleziona tema per il dispositivo {$a}';
$string['server'] = 'Server';
$string['serverchecks'] = 'Verifiche server';
$string['serverlimit'] = 'Limite del server';
$string['sessionautostartwarning'] = '<p>E\' stato individutao un errore di configurazione grave, per favore avverti l\'ammnistratore</p><p> Moodle per funzionare correttamente ha bisogno di modifiche alle impostazioni PHP.</p><p><code>session.auto_start</code> deve essere impostato a <code>off</code>.</p><p>E\' possibile cambiare l\'impostazione modificando il file <code>php.ini</code>, la configurazione di Apache/IIS <br />oppure tramite il file  <code>.htaccess</code> sul server.</p>';
$string['sessioncookie'] = 'Prefisso cookie';
$string['sessioncookiedomain'] = 'Dominio cookie';
$string['sessioncookiepath'] = 'Percorso cookie';
$string['sessionhandling'] = 'Gestione sessione';
$string['sessiontimeout'] = 'Timeout di sessione';
$string['settingfileuploads'] = 'Il caricamento di file è necessario per usare l\'ambiente, per favore abilitatelo nelle impostazioni del PHP.';
$string['settingmemorylimit'] = 'E\' stato riscontrato un limite di memoria troppo basso. Per favore aumentate il limite della memoria nelle impostazioni del PHP.';
$string['settingsafemode'] = 'Moodle non è del tutto compatibile con il safe mode, per favore chiedete all\'amministratore del server di impostare il safe mode ad off. Far girare Moodle con il safe mode ad on non è supportato e potrete riscontrare numerosi problemi.';
$string['showcommentscount'] = 'Visualizza il totale dei commenti';
$string['showdetails'] = 'Visualizza dettagli';
$string['showuseridentity'] = 'Visualizza identità dell\'utente';
$string['showuseridentity_desc'] = 'Quando si selezionano o cercano utenti e quando si visualizzano elenchi di utenti, è possibile visualizzare anche campi aggiuntivi oltre al nome e cognome. I campi aggiuntivi saranno comunque visibili solo ai ruoli che hanno il privilegio moodle/site:viewuseridentity, privilegio assegnato per default al ruolo Docente e Manager. (L\'impostazione può essere utile se selezioni campi significativi per la tua organizzazione)';
$string['simplexmlrequired'] = 'Moodle richiede l\'estensione PHP SimpleXML.';
$string['sitemaintenance'] = 'Il sito è sottoposto a manutenzione e non è attualmente disponibile';
$string['sitemaintenancemode'] = 'Manutenzione';
$string['sitemaintenanceoff'] = 'La modalità manutenzione è stata disattivata e il sito è nuovamente operativo.';
$string['sitemaintenanceon'] = 'Il sito è attualmente in manutenzione (solo gli amministratori possono collegarsi o utilizzare il sito).';
$string['sitemaintenanceoncli'] = 'Il tuo sito è in modalità manutenzione CLI e non è consentito l\'accesso via web.';
$string['sitemaintenancewarning'] = 'Il sito al momento è in manutenzione (solo gli amministratori possono collegarsi o utilizzare il sito). Per ripristinare la normale operatività, <a href="maintenance.php">disattivare la modalità manutenzione</a>.';
$string['sitemaintenancewarning2'] = 'Il sito al momento è in manutenzione (solo gli amministratori possono collegarsi o utilizzare il sito). Per ripristinare la normale operatività, <a href="{$a}"> disattivare la modalità manutenzione</a>.';
$string['sitepolicies'] = 'Politiche del sito';
$string['sitepolicy'] = 'URL delle politiche del sito';
$string['sitepolicyguest'] = 'URL politiche del sito per gli ospiti';
$string['sitepolicyguest_help'] = 'E\' possibile specificare l\'URL delle politiche del sito per gli ospiti. Le politiche dovranno essere accettate per poter utilizzare il sito.
L\'impostazione può contenere un qualsiasi URL pubblico. Nota: l\'accesso di utenti non autenticato può essere evitato attraverso  l\'impostazione forcelogin.';
$string['sitepolicy_help'] = 'Se si dispone di una politica del sito (modalità  di utilizzo) che tutti gli utenti devono leggere e sottoscrivere prima di utilizzare il sito, specificarne qui l\'indirizzo (URL), altrimenti lasciare in bianco. L\'URL può puntare ad un qualsiasi URL pubblico.';
$string['sitesectionhelp'] = 'E\' possibile visualizzare una sezione nella Pagina home.';
$string['slasharguments'] = 'Utilizza gli "slash arguments"';
$string['slashargumentswarning'] = 'Si raccomanda di abilitare l\'utilizzo degli slash arguments poiché in futuro tale requisito sarà obbligatorio. Per maggiori informazioni: <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Utiilzzo degli slash arguments</a>.';
$string['smartpix'] = 'Ricerca icone intelligente';
$string['soaprecommended'] = 'L\'estensione opzionale SOAP è utile per i web service ed altri plugin.';
$string['sort_fullname'] = 'Titolo';
$string['sort_idnumber'] = 'Codice identificativo corso';
$string['sort_shortname'] = 'Titolo abbreviato';
$string['sort_sortorder'] = 'Ordinamento predefinito';
$string['spellengine'] = 'Correttore ortografico';
$string['spelllanguagelist'] = 'Elenco lingue per controllo ortografico';
$string['splrequired'] = 'Moodle ha ora bisogno della estensione PHP SPL.';
$string['stats'] = 'Statistiche';
$string['statsfirstrun'] = 'Intervallo massimo di elaborazione';
$string['statsmaxruntime'] = 'Tempo massimo di esecuzione';
$string['statsmoodleorg'] = 'statistiche';
$string['statsruntimedays'] = 'Giorni da elaborare';
$string['statsruntimestart'] = 'Eseguire alle';
$string['statsuserthreshold'] = 'Soglia utenti';
$string['stickyblocks'] = 'Blocchi permanenti';
$string['stickyblockscourseview'] = 'Pagina del corso';
$string['stickyblocksduplicatenotice'] = 'Se aggiungete blocchi permanenti che sono già presenti in una data pagina, tali blocchi risulteranno duplicati.<br />Se riscontrate questa situazione, tenete presente che solo i blocchi permanenti non potranno essere modificati, mentre i blocchi duplicati potranno essere spostati o eliminati.';
$string['stickyblocksmymoodle'] = 'Il mio Moodle';
$string['stickyblockspagetype'] = 'Tipo di pagina da configurare';
$string['strictformsrequired'] = 'Validazione stringente dei campi obbligatori';
$string['stripalltitletags'] = 'Rimuovi tag HTML dai nomi delle attività';
$string['supportcontact'] = 'Contatto di supporto';
$string['supportemail'] = 'Email assistenza';
$string['supportname'] = 'Nominativo assistenza';
$string['supportpage'] = 'Pagina web assistenza';
$string['suspenduser'] = 'Sospendi account';
$string['switchlang'] = 'Cambia la cartella della lingua';
$string['systempaths'] = 'Percorsi di sistema';
$string['tablenosave'] = 'Le modifiche apportate nella tabella soprastante saranno salvate automaticamente.';
$string['tablesnosave'] = 'Le modifiche apportate nelle tabelle soprastanti saranno salvate automaticamente.';
$string['tabselectedtofront'] = 'Nelle tabelle con tab, il tab selezionato deve essere portato in primo piano?';
$string['tabselectedtofronttext'] = 'Porta in primo piano il tab selezionato';
$string['taskautomatedbackup'] = 'Backup automatici';
$string['taskbackupcleanup'] = 'Pulizia tabelle e log di backup';
$string['taskbadgescron'] = 'Rilascio badge';
$string['taskblogcron'] = 'Sincronizzazione blog esterni';
$string['taskcachecleanup'] = 'Rimozione elementi cache scaduti';
$string['taskcachecron'] = 'Elaborazione in background per le cache';
$string['taskcalendarcron'] = 'Invio notifiche calendario';
$string['taskcheckforupdates'] = 'Controllo aggiornamenti';
$string['taskcompletioncron'] = 'Calcolo stati di completamento';
$string['taskcontextcleanup'] = 'Pulizia contesti';
$string['taskcreatecontexts'] = 'Creazione contesti mancanti';
$string['taskdeletecachetext'] = 'Eliminazione record di cache vecchi';
$string['taskdeleteincompleteusers'] = 'Eliminazione utenti con profilo non completato';
$string['taskdeleteunconfirmedusers'] = 'Eliminazione utenti non confermati';
$string['taskeventscron'] = 'Elaborazione in background per gli eventi';
$string['taskfiletrashcleanup'] = 'Pulizia file eliminati';
$string['taskgradecron'] = 'Elaborazione in background per il registro valutatore';
$string['tasklegacycron'] = 'Elaborazione cron legacy per i plugin';
$string['taskmessagingcleanup'] = 'Elaborazione in background per la messaggistica';
$string['taskpasswordresetcleanup'] = 'Pulizia tentativi recupero password';
$string['taskplagiarismcron'] = 'Elaborazione in background per i plugin prevenzione plagio';
$string['taskportfoliocron'] = 'Elaborazione in background per i plugin portfolio';
$string['taskquestioncron'] = 'Elaborazione in background per il motore delle domande';
$string['taskregistrationcron'] = 'Registrazione del sito';
$string['tasksendfailedloginnotifications'] = 'Invio avvisi sui login errati';
$string['tasksendnewuserpasswords'] = 'Invio password ai nuovi utenti';
$string['tasksessioncleanup'] = 'Pulizia sessioni vecchie';
$string['taskstatscron'] = 'Elaborazione in background per le statistiche';
$string['tasktagcron'] = 'Elaborazione in background per i tag';
$string['tasktempfilecleanup'] = 'Eliminazione file temporanei obsoleti';
$string['testsiteupgradewarning'] = 'Stai  utilizzando il sito di test {$a}, per aggiornarlo correttamente utilizzare l\'interfaccia a linea di comando.';
$string['themedesignermode'] = 'Modalità Theme designer';
$string['themelist'] = 'Elenco temi';
$string['themenoselected'] = 'Non è stato selezionato nessun tema';
$string['themeresetcaches'] = 'Elimina le cache dei temi';
$string['themeselect'] = 'Cambia tema';
$string['themeselector'] = 'Selettore tema';
$string['themesettings'] = 'Impostazioni tema';
$string['therewereerrors'] = 'Si sono verificati errori nei vostri dati';
$string['thirdpartylibrary'] = 'Libreria';
$string['thirdpartylibrarylocation'] = 'Posizione';
$string['thirdpartylibs'] = 'Librerie di terze parti';
$string['timezone'] = 'Fuso orario di default';
$string['timezoneforced'] = 'L\'amministratore può scegliere di non consentire agli utenti di scegliere il proprio fuso orario.';
$string['timezoneisforcedto'] = 'Obbligare tutti gli utenti all\'utilizzo';
$string['timezonenotforced'] = 'Gli utenti possono scegliere il proprio fuso orario';
$string['tokenizerrecommended'] = 'E\' raccomandata l\'installazione di Tokenizer - estensione opzionale del PHP - per migliorare la funzionalità del Moodle Networking.';
$string['tools'] = 'Tool amministrativi';
$string['toolsmanage'] = 'Gestione tool amministrativi';
$string['unattendedoperation'] = 'Operazione non assistita';
$string['unbookmarkthispage'] = 'Rimuovi questa pagina dai segnalibri';
$string['unicoderequired'] = 'E\' richiesto che tutti i dati vengano memorizzati in formato Unicode (UTF-8). Le nuove installazioni dovrebbero essere effettuate in database che hanno il proprio set di caratteri default impostato come Unicode. Se si sta facendo un aggiornamento, bisogna eseguire il processo di migrazione UTF-8 (vedi pagina di Amministrazione).';
$string['uninstallplugin'] = 'Rimuovi';
$string['unlockaccount'] = 'Sblocca profilo';
$string['unsettheme'] = 'Deseleziona tema';
$string['unsupported'] = 'Non supportato';
$string['unsupporteddbstorageengine'] = 'Lo storage engine utilizzato dal database non è più supportato.';
$string['unsupporteddbtablerowformat'] = 'Il database utilizza il formato file Antelope. Si raccomanda di convertire le tabelle nel formato file Barracuda. Per dettagli su come convertire le tabelle InnoDB in formato Barracuda, è disponibile la documentazione: <a href="https://docs.moodle.org/en/cli">Administration via command line</a>';
$string['unsupportedphpversion7'] = 'La versione 7 del PHP non è supportata.';
$string['unsuspenduser'] = 'Attiva account';
$string['updateaccounts'] = 'Aggiornare registrazioni esistenti';
$string['updateautocheck'] = 'Controllo automatico degli aggiornamenti';
$string['updateautocheck_desc'] = 'Attiva il controllo automatico degli aggiornamenti sia per Moodle e per plugin addizionali. In presenza di aggiornamenti, sarà inviato un messaggio all\'amministratore del sito.';
$string['updateautodeploy'] = 'Abilita installazione aggiornamenti';
$string['updateautodeploy_desc'] = 'Consente di scaricare ed installare gli aggiornamenti disponibili tramite le pagine di amministrazione di Moodle. Da notare che il server web deve avere i permessi di scrittura nei folder dove è installato Moodle. Questo può essere considerato come un possibile rischio per la sicurezza.';
$string['updateavailable'] = 'E\' disponibile una nuova versione di Moodle!';
$string['updateavailabledetailslink'] = 'Per maggiori informazioni: {$a->url}';
$string['updateavailableforplugin'] = 'Sono disponibili nuove versioni per alcuni plugin addizionali!';
$string['updateavailableinstall'] = 'Installa questo aggiornamento';
$string['updateavailable_moreinfo'] = 'Maggiori informazioni...';
$string['updateavailablenot'] = 'Il codice di Moodle è aggiornato!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versione {$a}';
$string['updatecomponent'] = 'Aggiornamento componenti';
$string['updateminmaturity'] = 'Code maturity richesta';
$string['updateminmaturity_desc'] = 'Avvisa sulla disponibilità degli aggiornamenti solo se il codice aggiornato ha la code maturity scelta. Gli aggiornamenti di plugin che non dichiarano la propria code maturity verranno riportati comunque indipendentemente da questa impostazione.';
$string['updatenotificationfooter'] = 'Il sito Moodle {$a->siteurl} è configurato per verificare automaticamente la disponibilità di aggiornamenti e ricevi questo messaggio in qualità di amministratore del sito. E\' possibile disabilitare il controllo automatico degli aggiornamenti nella sezione Amministrazione del sito presente nel blocco Impostazioni. E\' anche possibile personalizzare la consegna di questo messaggio attraverso le impostazioni del Messaging presente nella sezione Il mio profilo.';
$string['updatenotifications'] = 'Notifiche sugli aggiornamenti';
$string['updatenotificationsubject'] = 'Sono disponibili aggiornamenti Moodle per ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Avvisa sulla disponibilità di nuove build';
$string['updatenotifybuilds_desc'] = 'Consente la ricezione di avvisi sulla disponibilità di build più recenti per la versione di Moodle in uso. Le build sono miglioramenti continui di una data versione di Moodle e sono di norma rilasciate con cadenza settimanale. Se questa opzione è disabilitata, saranno inviati avvisi solo in caso di disponibilità di una nuova versione di Moodle. L\'impostazione non influenza la verifica degli aggiornamenti dei plugin.';
$string['upgradeerror'] = 'Si è verificato un errore sconosciuto durante l\'aggiornamento del plugin {$a->plugin} alla versione {$a->version}, non è possibile proseguire.';
$string['upgradeforumread'] = 'Una nuova caratteristica è stata aggiunta a Moodle 1.5 per tracciare gli interventi letti/non letti di un forum.<br />Per utilizzarla, bisogna<a href="{$a}">aggiornare le vostre tabelle</a>.';
$string['upgradeforumreadinfo'] = 'Una nuova caratteristica è stata aggiunta da Moodle 1.5 per tracciare i messaggi letti/non letti di un forum. Per utilizzarla, bisogna aggiornare le tabelle con tutte le informazioni di tracciamento dei messaggi pre-esistenti. Il tempo di esecuzione dipende dalle dimensioni del sito e potrebbe durare anche ore, sottoponendo il server ad un lavoro gravoso. E\' dunque consigliabile farlo in un momento tranquillo. In ogni caso, il sito continuerà a funzionare durante questa operazione e gli utenti non ne saranno interessati. Una volta lanciato, il processo non dovrebbe essere interrotto, lasciando aperta la finestra del browser. Se si fermasse il processo, chiudendo la finestra del browser, niente paura: si può sempre ricominciare. < br /><br />Si desidera iniziare adesso il processo di aggiornamento?';
$string['upgradelogs'] = 'Per la piena funzionalità, i vostri vecchi log devono essere aggiornati. <a href="{$a}">Ulteriori informazioni</a>';
$string['upgradelogsinfo'] = 'Alcune modifiche hanno cambiato il modo in cui vengono salvati alcuni log. Per poter visualizzare tutti i vecchi log su una base di per-attività , è necessario aggiornarli. In base al tuo sito questa operazione può richiedere molto tempo (es alcune ore) e può essere grosso lavoro per la base dati dei siti grandi. Una volta che l\'aggiornamento è iniziato devi lasciarlo terminare (mantenendo la finestra del browser aperta). Non preoccuparti - il tuo sito continuerà  a lavorare correttamente mentre i log vengono aggiornati.<br /><br />Vuoi aggiornare i log ora?';
$string['upgradepluginsfirst'] = 'Si consiglia di scaricare ed installare manualmente tutti gli aggiornamenti disponibili';
$string['upgradepluginsinfo'] = 'Aggiornamento plugin';
$string['upgradepluginsinfo_help'] = 'Sono disponibili aggiornamenti per uno o più plugin. E\' necessario installare le versioni aggiornate prima di eseguire l\'aggiornamento del Database di Moodle, Se l\'installazione automatica degli aggiornamenti è disabilitata, devi scaricare gli aggiornamenti ed installarli manualmente.';
$string['upgradesettings'] = 'Nuove impostazioni';
$string['upgradesettingsintro'] = 'Le impostazioni sotto elencate sono state aggiunte durante l\'ultimo aggiornamento di Moodle. Apporta  i cambiamenti necessari ai valori di default e poi clicca su "Salva modifiche" in fondo alla pagina';
$string['upgradestalefiles'] = 'Sono state individuate versioni di Moodle incoerenti, l\'upgrade non può proseguire';
$string['upgradestalefilesinfo'] = 'L\'aggiornamento di Moodle è stato sospeso poiché nella cartella di installazione sono stati individuati script PHP appartenenti ad almeno due versioni diverse di Moodle.

Poiché la cosa può causare problemi gravi, devi accertarti che la cartella di installazione contenga solo i file appartenenti alla stessa versione.

Si suggerisce di procedere nel modo seguente:

* rinomina la cartella di installazione in "moodle_old"
* crea una nuova cartella di installazione contenente solo i file provenienti da un download di un pacchetto Moodle oppure ottenuti via repository Git
* sposta dalla cartella"moodle_old" nella nuova cartella il file config.php  e tutti i plugin non appartenenti alla distribuzione ufficiale

Una volta ottenuta una cartella di installazione pulita, ricarica questa pagina per riavviare il processo di aggiornamento di Moodle.

Questo messaggio è spesso causato dalla decompressione di pacchetti Moodle in una cartella che contiene già una versione precedente. Sebbene sia possibile eseguire questa operazione per aggiornamenti della stessa versione, è invece fortemente sconsigliato di farla quando si aggiorna ad una nuova versione.

Lo stesso messaggio può essere generato da un checkout incompleto da un repository Git, nel qual caso devi solo attendere che il checkout si completi correttamente prima di proseguire.

Per maggiori informazion sull\'upgrade: <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Aggiorna il database di Moodle';
$string['upgradesure'] = '<p>I file di Moodle sono stati modificati e il sito sta per essere aggiornato alla versione:</p>
<p><strong>{$a}</strong></p>
<p>Una volta avviato l\'aggiornamento non sarà  possibile tornare indietro. Tenere presente che l\'elaborazione può durare a lungo.</p>
<p>Sei sicuro di continuare ?</p>';
$string['upgradetimedout'] = 'L\'aggiornamento è andato in timeout. Per favore riavvia l\'aggiornamento.';
$string['upgradingdata'] = 'Aggiornamento dei dati';
$string['upgradinglogs'] = 'Aggiornamento dei log';
$string['upgradingversion'] = 'Aggiornamento alla nuova versione';
$string['upwards'] = 'ed oltre';
$string['useblogassociations'] = 'Abilita associazioni';
$string['useexternalyui'] = 'Utilizza le librerie YUI online';
$string['user'] = 'Utente';
$string['userbulk'] = 'Azioni in massa';
$string['userdefaultpreferences'] = 'Preferenze utente di default';
$string['userlist'] = 'Elenco utenti';
$string['userpolicies'] = 'Politiche utente';
$string['userpreference'] = 'Preferenze utente';
$string['userquota'] = 'Quota utente';
$string['users'] = 'Utenti';
$string['usesitenameforsitepages'] = 'Utilizza il nome del sito per le pagine del sito';
$string['usetags'] = 'Abilita Tag';
$string['validateerror'] = 'Questo valore non è valido';
$string['verifychangedemail'] = 'Controlla i domini quando si cambia l\'email';
$string['warningcurrentsetting'] = 'Valore corrente non valido: {$a}';
$string['warningiconvbuggy'] = 'La versione della libreria iconv installata non supporta il modifier //IGNORE. Puoi installare l\'estensione mbstring che può essere utilizzata in alternativa per pulire le stringhe contenenti caratteri UTF-8 non validi.';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Usa le impostazioni seguenti se il tuo server Moodle non può accedere direttamente ad Internet. L\'accesso ad Internet è necessario per scaricare dati di ambiente, language pack, feed RSS, timezone, eccetera.<br /><em>L\'estensione PHP cURL è fortemente raccomandata.</em>';
$string['xmlrpcrecommended'] = 'L\'installazione della estensione opzionale xmlrpc è necessaria per la comunicazione dell\'hub ed è utile per i web service e il Moodle Networking.';
$string['yuicomboloading'] = 'Caricamento YUI combo';
$string['ziprequired'] = 'Moodle richiede l\'estensione Zip PHP. Gli eseguibili info-ZIP o la libreria PclZip non sono più utilizzati.';
