<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'it', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['appstoredescription'] = 'NOTA: l\'applicazione ufficiale Moodle Mobile funziona solamente con siti Moodle abilitati appositamente. In caso diproblemi di collegamento, contattare l\'amministratore del sito.

L\'app consente di:

- navigare nel contenuto del corso, anche oflfine
- ricevere notifiche istantanee di messaggi e di eventi
- trovare rapidamente e contattare altri partecipanti
- caricare dal dispositivo mobile immagini, audio, video e altri tipi di file
- visualizzare le valutazioni del corso
- molto altro ancora!

Per ulteriori informazioni: http://docs.moodle.org/en/Mobile_app

Saremo lieti di conoscere le tue impressioni sulle funzionalità disponibili e ricevere suggerimenti sulle funzionalità da implementare nella app.

L\'app ha bisogno delle seguenti autorizzazioni:
Registrare audio - Per registrare file audio da caricare su Moodle
Leggere è modificare il contenuto della memoria SD - Per scaricare i contenuti sulla memoria SD e visualizzarli offline
Accesso alla rete - Per collegarsi al sito Moodle, verificare lo stato del collegamento e impostare la modalità offline
Essere lanciata all\'avvio - Per ricevere le notifiche con l\'app in background
Evitare lo standby del telefono - Per ricever notifiche push in qualsiasi momento';
$string['mma.calendar.calendarevents'] = 'Eventi nel calendario';
$string['mma.calendar.errorloadevent'] = 'Si è verificato un errore durante il caricamento degli eventi.';
$string['mma.calendar.errorloadevents'] = 'Si è verificato un errore durante il caricamento degli eventi.';
$string['mma.calendar.noevents'] = 'Non ci sono eventi';
$string['mma.calendar.notifications'] = 'Notifiche';
$string['mma.coursecompletion.complete'] = 'Completato';
$string['mma.coursecompletion.completecourse'] = 'Corso completato';
$string['mma.coursecompletion.completed'] = 'Completato';
$string['mma.coursecompletion.completiondate'] = 'Data di completamento';
$string['mma.coursecompletion.couldnotloadreport'] = 'Non è stato possibile caricare il report di completamento del corso, per favore riporva.';
$string['mma.coursecompletion.coursecompletion'] = 'Completamento del corso';
$string['mma.coursecompletion.criteria'] = 'Criteri';
$string['mma.coursecompletion.criteriagroup'] = 'Gruppo di criteri';
$string['mma.coursecompletion.criteriarequiredall'] = 'E\' richiesto il soddisfacimento di tutti i criteri elencati';
$string['mma.coursecompletion.criteriarequiredany'] = 'E\' richiesto il soddisfacimento di almeno uno dei criteri elencati';
$string['mma.coursecompletion.inprogress'] = 'In svolgimento';
$string['mma.coursecompletion.manualselfcompletion'] = 'Conferma personale di completamento';
$string['mma.coursecompletion.notyetstarted'] = 'Non iniziato';
$string['mma.coursecompletion.pending'] = 'In attesa';
$string['mma.coursecompletion.required'] = 'Da soddisfare';
$string['mma.coursecompletion.requiredcriteria'] = 'Criteri da soddisfare';
$string['mma.coursecompletion.requirement'] = 'Requisito';
$string['mma.coursecompletion.status'] = 'Stato';
$string['mma.coursecompletion.viewcoursereport'] = 'Visualizza report del corso';
$string['mma.files.admindisableddownload'] = 'L\'amministratore del sito Moodle ha disabilitato il download dei file. Puoi navigare tra i file ma non potrai scaricarli.';
$string['mma.files.audio'] = 'Audio';
$string['mma.files.camera'] = 'Camera';
$string['mma.files.chooseaccountuploadfile'] = 'Seleziona l\'account dove caricare file.';
$string['mma.files.clicktoupload'] = 'Fai click sul pulsante sotto per caricare i file nei File personali';
$string['mma.files.confirmuploadfile'] = 'Stai per caricare {{size}}. Sei sicuro di continuare?';
$string['mma.files.couldnotloadfiles'] = 'Non è stato possibile caricare l\'elenco dei file.';
$string['mma.files.downloading'] = 'Scaricamento in corso';
$string['mma.files.emptyfilelist'] = 'Non ci sono file da visualizzare.';
$string['mma.files.errorcapturingaudio'] = 'Si è verificato un errore durante la registrazione dell\'audio';
$string['mma.files.errorcapturingimage'] = 'Si è verificato un errore durante l\'acquisizione dell\'immagine.';
$string['mma.files.errorcapturingvideo'] = 'Si è verificato un errore durante l\'acquisizione del video';
$string['mma.files.errorgettingimagealbum'] = 'Si è verificato un errore durante la ricezione dell\'immagine dall\'album.';
$string['mma.files.errormustbeonlinetoupload'] = 'Devi essere online per caricare file.';
$string['mma.files.errornoapp'] = 'Non hai un\'app per svolgere questa azione.';
$string['mma.files.errorreadingfile'] = 'Si è verificato un errore durante la lettura del file.';
$string['mma.files.errorreceivefilenosites'] = 'Non ci sono siti memorizzati. Devi aggiungere un sito prima di poter caricare file.';
$string['mma.files.errorwhiledownloading'] = 'Si è verificato un errore durante lo scaricamento del file.';
$string['mma.files.errorwhilerecordingaudio'] = 'Si è verificato un errore durante la registrazione del video';
$string['mma.files.errorwhileuploading'] = 'Si è verificato un errore durante il caricamento del file.';
$string['mma.files.file'] = 'File';
$string['mma.files.fileuploaded'] = 'File caricato correttamente';
$string['mma.files.myfiles'] = 'I miei file';
$string['mma.files.myprivatefiles'] = 'File personali';
$string['mma.files.myprivatefilesdesc'] = 'I file memorizzati nell\'omonima area di Moodle';
$string['mma.files.photoalbums'] = 'Album fotografico';
$string['mma.files.readingfile'] = 'Letture file in corso';
$string['mma.files.sitefiles'] = 'File del sito';
$string['mma.files.sitefilesdesc'] = 'Altri file del sito Moodle ai quali puoi accedere.';
$string['mma.files.success'] = 'Effettuato correttamente!';
$string['mma.files.uploadafile'] = 'Carica un file';
$string['mma.files.uploadfiles'] = 'Carica file';
$string['mma.files.uploading'] = 'Caricamento in corso';
$string['mma.files.video'] = 'Video';
$string['mma.frontpage.frontpage'] = 'Pagina home';
$string['mma.frontpage.sitehome'] = 'Home del sito';
$string['mma.grades.average'] = 'Media';
$string['mma.grades.contributiontocoursetotal'] = 'Quota di contribuzione sul totale del corso';
$string['mma.grades.feedback'] = 'Feedback';
$string['mma.grades.grade'] = 'Valutazione';
$string['mma.grades.grades'] = 'Valutazioni';
$string['mma.grades.itemname'] = 'Elemento di valutazione';
$string['mma.grades.lettergrade'] = 'Graduatoria letterale';
$string['mma.grades.percentage'] = 'Percentuale';
$string['mma.grades.range'] = 'Intervallo';
$string['mma.grades.rank'] = 'Classifica';
$string['mma.grades.viewgrades'] = 'Visualizza valutazioni';
$string['mma.grades.weight'] = 'Peso';
$string['mma.messages.contactlistempty'] = 'L\'elenco dei contatti è vuoto';
$string['mma.messages.contactname'] = 'Nome del contatto';
$string['mma.messages.errorwhileretrievingcontacts'] = 'Si è verificato un errore durante la ricezione dei contatti dal server.';
$string['mma.messages.errorwhileretrievingdiscussions'] = 'Si è verificato un errore durante la ricezione delle discussioni dal server.';
$string['mma.messages.errorwhileretrievingmessages'] = 'Si è verificato un errore durante la ricezione dei messaggi dal server.';
$string['mma.messages.messagenotsent'] = 'Il messaggio non è stato inviato, per favore riprova più tardi.';
$string['mma.messages.mustbeonlinetosendmessages'] = 'Per inviare messaggi devi essere online';
$string['mma.messages.newmessage'] = 'Nuovo messaggio...';
$string['mma.messages.nomessages'] = 'Non ci sono messaggi.';
$string['mma.messages.nousersfound'] = 'Non sono stati trovati utenti';
$string['mma.messages.send'] = 'Invia';
$string['mma.messages.type_blocked'] = 'Bloccato';
$string['mma.messages.type_offline'] = 'Offline';
$string['mma.messages.type_online'] = 'Online';
$string['mma.messages.type_search'] = 'Risultati della ricerca';
$string['mma.messages.type_strangers'] = 'Altri';
$string['mma.mod_assign.userwithid'] = 'Utente con id {{id}}';
$string['mma.mod_chat.errorwhileconnecting'] = 'Si è verificato un errore durante il collegamento alla chat.';
$string['mma.mod_chat.errorwhilegettingchatdata'] = 'Si è verificato un errore durante la ricezione dei dati della chat.';
$string['mma.mod_chat.errorwhilegettingchatusers'] = 'Si è verificato un errore durante la ricezione degli utenti della chat.';
$string['mma.mod_chat.errorwhileretrievingmessages'] = 'Si è verificato un errore durante la ricezione dei messaggi dal server.';
$string['mma.mod_chat.errorwhilesendingmessage'] = 'Si è verificato un errore durante l\'invio del messaggio.';
$string['mma.mod_chat.messagebeepsyou'] = '{{$a}} ti ha inviato un bip!';
$string['mma.mod_chat.messageenter'] = '{{$a}} è entrato nella chat';
$string['mma.mod_chat.messageexit'] = '{{$a}} è uscito dalla chat';
$string['mma.mod_chat.mustbeonlinetosendmessages'] = 'Per inviare messaggi devi essere online';
$string['mma.mod_chat.sessionstart'] = 'La prossima sessione di chat inizierà tra {{$a}}';
$string['mma.mod_choice.errorgetchoice'] = 'Si è verificato un errore durante la ricezione di dati della scelta.';
$string['mma.mod_choice.expired'] = 'Spiacente, l\'attività non è disponibile poiché si è chiusa il {{$a}}';
$string['mma.mod_choice.notopenyet'] = 'Spiacente, l\'attività non è disponibile poiché aprirà il {{$a}}';
$string['mma.mod_choice.previewonly'] = 'Questa è un\'anteprima delle opzioni disponibili. Potrai operare la tua scelta a partire dal {{$a}}.';
$string['mma.mod_choice.responsesresultgraphdescription'] = 'Il {{number}}% ha scelto l\'opzione {{text}}.';
$string['mma.mod_folder.emptyfilelist'] = 'Non ci sono file da visualizzare.';
$string['mma.mod_folder.errorwhilegettingfolder'] = 'Si è verificato un errore durante la ricezione dei dati della cartella.';
$string['mma.mod_forum.erroremptysubject'] = 'L\'oggetto dell\'intervento non può essere vuoto';
$string['mma.mod_forum.errorgetforum'] = 'Si è verificato un errore durante la ricezione dei dati del forum.';
$string['mma.mod_forum.errorgetgroups'] = 'Si è verificato un errore durante la ricezione delle impostazioni gruppo.';
$string['mma.mod_forum.forumnodiscussionsyet'] = 'In questo forum non sono presenti discussioni';
$string['mma.mod_forum.group'] = 'Gruppo';
$string['mma.mod_forum.numdiscussions'] = '{{numdiscussions}} discussioni';
$string['mma.mod_forum.numreplies'] = '{{numreplies}} interventi';
$string['mma.mod_imscp.showmoduledescription'] = 'Visualizza descrizione';
$string['mma.mod_label.label'] = 'Etichetta';
$string['mma.mod_label.taptoview'] = 'Tocca per visualizzare l\'etichetta.';
$string['mma.mod_lti.errorgetlti'] = 'Si è verificato un errore durante la ricezione dei dati del modulo.';
$string['mma.mod_lti.errorinvalidlaunchurl'] = 'l\'URL di lancio non è valida.';
$string['mma.mod_lti.launchactivity'] = 'Lancia l\'attività';
$string['mma.mod_page.errorwhileloadingthepage'] = 'Si è verificato un errore durante il caricamento della pagina.';
$string['mma.mod_resource.errorwhileloadingthecontent'] = 'Si è verificato un errore durante il caricamento del contenuto.';
$string['mma.mod_resource.openthefile'] = 'Apri il file';
$string['mma.mod_scorm.cannotcalculategrade'] = 'Non è stato possibile calcolare le valutazioni.';
$string['mma.mod_scorm.dataattemptshown'] = 'Questi dati appartengono al tentativo numero {{number}}.';
$string['mma.mod_scorm.errorcreateofflineattempt'] = 'Si è verificato un errore durante la creazione di un tentativo offline. Per favore riprova.';
$string['mma.mod_scorm.errordownloadscorm'] = 'Si è verificato un errore durante lo scaricamento dello SCORM "{{name}}".';
$string['mma.mod_scorm.errorgetscorm'] = 'Si è verificato un errore durante la ricezione dei dati SCORM.';
$string['mma.mod_scorm.errorinvalidversion'] = 'Spiacente, l\'applicazione supporta solamente SCORM 1.2.';
$string['mma.mod_scorm.errornotdownloadable'] = 'Lo scaricamento di pacchetti SCORM è disabilitato a livello di sito Moodle. Per favore contatta l\'amministratore del sito.';
$string['mma.mod_scorm.errornovalidsco'] = 'Questo SCORM non ha SCO visibili da caricare.';
$string['mma.mod_scorm.errorpackagefile'] = 'Spiacente, l\'applicazione supporta solamente pacchetti ZIP.';
$string['mma.mod_scorm.errorsyncscorm'] = 'Si è verificato un errore durante la sincronizzazione. Per favore riprova.';
$string['mma.mod_scorm.lastsync'] = 'Sincronizzazione più recente';
$string['mma.mod_scorm.offlineattemptnote'] = 'Questo tentativo ha dati non sincronizzati.';
$string['mma.mod_scorm.offlineattemptovermax'] = 'Questo tentativo non può essere inviato perché hai superato il numero massimo di tentativi.';
$string['mma.mod_scorm.scormstatusnotdownloaded'] = 'Questo SCORM non è stato scaricato, lo sarà non appena lo aprirai.';
$string['mma.mod_scorm.scormstatusoutdated'] = 'Questo SCORM è stato modificato dall\'ultimo scaricamento e sarà scaricato nuovamente non appena lo aprirai.';
$string['mma.mod_scorm.warningofflinedatadeleted'] = 'Alcuni dati offline del tentativo {{number}}  sono stati eliminati perché non è stato possibile inserirli in un nuovo tentativo.';
$string['mma.mod_scorm.warningsynconlineincomplete'] = 'Alcuni tentativi non sono stati sincronizzati sul sito poiché è presente un tentativo svolto online che non è stato terminato. Per sincronizzare, devi prima terminare il tentativo online.';
$string['mma.mod_survey.cannotsubmitsurvey'] = 'Si è verificato un errore durante l\'invio del sondaggio. Per favore riprova.';
$string['mma.mod_survey.errorgetsurvey'] = 'Si è verificato un errore durante la ricezione di dati del sondaggio.';
$string['mma.mod_survey.results'] = 'Risultati';
$string['mma.mod_url.accessurl'] = 'Accedi all\'URL';
$string['mma.mod_url.pointingtourl'] = 'URL dove punta la risorsa';
$string['mma.notes.addnewnote'] = 'Aggiungi annotazione';
$string['mma.notes.coursenotes'] = 'Annotazioni del corso';
$string['mma.notes.eventnotecreated'] = 'Creata annotazione';
$string['mma.notes.nonotes'] = 'Non sono presenti annotazioni di questo tipo.';
$string['mma.notes.note'] = 'Annotazione';
$string['mma.notes.notes'] = 'Annotazioni';
$string['mma.notes.personalnotes'] = 'Annotazioni personali';
$string['mma.notes.publishstate'] = 'Contesto';
$string['mma.notes.sitenotes'] = 'Annotazioni del sito';
$string['mma.notes.userwithid'] = 'Utente con id {{id}}';
$string['mma.notifications.errorgetnotifications'] = 'Si è verificato un errore durante la ricezione delle notifiche.';
$string['mma.notifications.notifications'] = 'Notifiche';
$string['mma.notifications.therearentnotificationsyet'] = 'Non ci sono notifiche';
$string['mma.participants.noparticipants'] = 'In questo corso non sono stati trovati partecipanti';
$string['mma.participants.participants'] = 'Partecipanti';
$string['mm.core.android'] = 'Android';
$string['mm.core.cannotconnect'] = 'Impossibile connettersi: verificare che l\'URL sia corretto e che il sito usi Moodle 2.4 o versioni successive.';
$string['mm.core.cannotdownloadfiles'] = 'Nel servizio Mobile Lo scaricamento di file è disabilitato. Per favore contatta l\'amministratore del sito.';
$string['mm.core.clearsearch'] = 'Pulisci la ricerca';
$string['mm.core.clicktoseefull'] = 'Click per visualizzare il contenuto completo.';
$string['mm.core.close'] = 'Chiudi';
$string['mm.core.completion-alt-auto-fail'] = 'Completato: {{$a}} (senza la sufficienza)';
$string['mm.core.completion-alt-auto-n'] = 'Non completato: {{$a}}';
$string['mm.core.completion-alt-auto-pass'] = 'Completato: {{$a}} (con la sufficienza)';
$string['mm.core.completion-alt-auto-y'] = 'Completato: {{$a}}';
$string['mm.core.completion-alt-manual-n'] = 'Non completato: {{$a}}. Selezionare per indicare come completato.';
$string['mm.core.completion-alt-manual-y'] = 'Completato: {{$a}}. Selezionare per indicare come non completato.';
$string['mm.core.confirmopeninbrowser'] = 'Desideri aprirlo nel browser?';
$string['mm.core.dfdayweekmonth'] = 'ddd, D MMM';
$string['mm.core.dflastweekdate'] = 'ddd';
$string['mm.core.dfmediumdate'] = 'LLL';
$string['mm.core.dftimedate'] = 'h[:]mm A';
$string['mm.core.downloading'] = 'Scaricamento incorso';
$string['mm.core.elementseparator'] = ',';
$string['mm.core.errorchangecompletion'] = 'Si è verificato un errore durante la modifica dello stato di completamento. Per favore riprova.';
$string['mm.core.errordownloading'] = 'Si è verificato un errore durante lo scaricamento del file.';
$string['mm.core.errordownloadingsomefiles'] = 'Si è verificato un errore durante lo scaricamento dei file del modulo. Possono mancare alcuni file.';
$string['mm.core.errorinvalidresponse'] = 'E\' stata ricevuta una risposta non valida. Se l\'errore persiste, contatta l\'amministratore del sito.';
$string['mm.core.erroropenfilenoapp'] = 'Si è verificato un errore durante l\'apertura del file: non sono disponibili app per aprire questo tipo di file.';
$string['mm.core.erroropenfilenoextension'] = 'Si è verificato un errore durante l\'apertura del file: il file non ha estensione.';
$string['mm.core.erroropenpopup'] = 'L\'attività tenta di aprirsi in una finestra popup. Le popup non sono supportate nella app.';
$string['mm.core.humanreadablesize'] = '{{size}} {{unit}}';
$string['mm.core.image'] = 'Immagine';
$string['mm.core.imageviewer'] = 'Visualizzatore immagine';
$string['mm.core.info'] = 'Informazioni';
$string['mm.core.ios'] = 'iOS';
$string['mm.core.loading'] = 'Caricamento in corso';
$string['mm.core.lostconnection'] = 'La connessione è stata perduta. Il tuo token non è più valido.';
$string['mm.core.mod_assign'] = 'Compito';
$string['mm.core.mod_assignment'] = 'Compito';
$string['mm.core.mod_book'] = 'Libro';
$string['mm.core.mod_chat'] = 'Chat';
$string['mm.core.mod_choice'] = 'Scelta';
$string['mm.core.mod_data'] = 'Database';
$string['mm.core.mod_database'] = 'Database';
$string['mm.core.mod_external-tool'] = 'Tool esterno';
$string['mm.core.mod_feedback'] = 'Feedback';
$string['mm.core.mod_file'] = 'File';
$string['mm.core.mod_folder'] = 'Cartella';
$string['mm.core.mod_forum'] = 'Forum';
$string['mm.core.mod_glossary'] = 'Glossario';
$string['mm.core.mod_ims'] = 'IMS content package';
$string['mm.core.mod_imscp'] = 'IMS content package';
$string['mm.core.mod_label'] = 'Etichetta';
$string['mm.core.mod_lesson'] = 'Lezione';
$string['mm.core.mod_lti'] = 'Tool esterno';
$string['mm.core.mod_page'] = 'Pagina';
$string['mm.core.mod_quiz'] = 'Quiz';
$string['mm.core.mod_resource'] = 'Risorsa';
$string['mm.core.mod_scorm'] = 'Pacchetto SCORM';
$string['mm.core.mod_survey'] = 'Sondaggio';
$string['mm.core.mod_url'] = 'URL';
$string['mm.core.mod_wiki'] = 'Wiki';
$string['mm.core.mod_workshop'] = 'Workshop';
$string['mm.core.networkerrormsg'] = 'La rete non è abilitata o non funziona.';
$string['mm.core.notapplicable'] = 'n/d';
$string['mm.core.numdays'] = '{{$a}} giorni';
$string['mm.core.numhours'] = '{{$a}} ore';
$string['mm.core.numminutes'] = '{{$a}} minuti';
$string['mm.core.nummonths'] = '{{$a}} mesi';
$string['mm.core.numseconds'] = '{{$a}} secondi';
$string['mm.core.numyears'] = '{{$a}} anni';
$string['mm.core.offline'] = 'Offline';
$string['mm.core.online'] = 'Online';
$string['mm.core.openfullimage'] = 'Click per visualizare l\'immagine a dimensioni reali';
$string['mm.core.openinbrowser'] = 'Apri nel browser';
$string['mm.core.percentagenumber'] = '{{$a}}%';
$string['mm.core.pulltorefresh'] = 'Trascina per aggiornare';
$string['mm.core.requireduserdatamissing'] = 'Nel profilo di questo utente mancano alcuni dati. Per favore compila i dati mancanti in Moodle e riprova.<br>{{$a}}';
$string['mm.core.searching'] = 'Ricerca in corso';
$string['mm.core.sending'] = 'Invio in c orso';
$string['mm.core.serverconnection'] = 'Si è verificato un errore durante il collegamento con il server.';
$string['mm.core.sizetb'] = 'TB';
$string['mm.core.success'] = 'OK!';
$string['mm.core.tablet'] = 'Tablet';
$string['mm.core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['mm.core.unexpectederror'] = 'Si è verificato un errore inatteso. Riprova chiudendo e riaprendo l\'applicazione';
$string['mm.core.unknown'] = 'Sconosciuto';
$string['mm.core.unzipping'] = 'Decompressione in corso';
$string['mm.core.windowsphone'] = 'Windows Phone';
$string['mm.core.wsfunctionnotavailable'] = 'La funzione webservice non è disponibile.';
$string['mm.course.activitynotyetviewable'] = 'Questa attività o risorsa non è visualizzabile nell\'app.';
$string['mm.course.activitynotyetviewablegothere'] = 'Questa attività o risorsa non è visualizzabile nell\'app, fai click sul pulsante sotto per accedervi tramite browser.';
$string['mm.course.allsections'] = 'Tutte le sezioni';
$string['mm.course.confirmdownload'] = 'Stai per scaricare {{size}}. Vuoi continuare?';
$string['mm.course.confirmdownloadsection'] = 'Stai per scaricare {{size}}. Vuoi continuare?';
$string['mm.course.confirmdownloadunknownsize'] = 'Non è stato possibile calcolare la dimensione del download. Vuoi scaricare lo stesso?';
$string['mm.course.contents'] = 'Contenuti';
$string['mm.course.couldnotloadsectioncontent'] = 'Non è stato possibile caricare il contenuto della sezione, per favore riprova più tardi.';
$string['mm.course.couldnotloadsections'] = 'Non è stato possibile caricare le sezioni, per favore riprova più tardi.';
$string['mm.course.errordownloadingsection'] = 'Si è verificato un errore durante lo scaricamento della sezione.';
$string['mm.course.gotothesite'] = 'Vai al sito';
$string['mm.course.nocontentavailable'] = 'Non sono presenti contenuti.';
$string['mm.courses.confirmselfenrol'] = 'Desideri iscriverti al corso?';
$string['mm.courses.enrolme'] = 'Iscrivimi';
$string['mm.courses.errorloadcourses'] = 'Si è verificato un errore durante il caricamento dei corsi.';
$string['mm.courses.errorsearching'] = 'Si è verificato un errore durante la ricerca.';
$string['mm.courses.errorselfenrol'] = 'Si è verificato un errore mentre ti stavi iscrivendo.';
$string['mm.courses.filter'] = 'Filtro';
$string['mm.courses.filtermycourses'] = 'Filtra i miei corsi';
$string['mm.courses.frontpage'] = 'Pagina home';
$string['mm.course.showall'] = 'Visualizza tutto';
$string['mm.courses.mycourses'] = 'I miei corsi';
$string['mm.courses.nocourses'] = 'Non sono presenti informazioni sul corso.';
$string['mm.courses.nosearchresults'] = 'La ricerca non ha prodotto risultati';
$string['mm.courses.notenroled'] = 'Non sei iscritto in questo corso';
$string['mm.courses.notenrollable'] = 'Non puoi iscriverti al corso.';
$string['mm.courses.password'] = 'Chiave di iscrizione';
$string['mm.courses.search'] = 'Cerca';
$string['mm.courses.searchcourses'] = 'Cerca corsi';
$string['mm.courses.searchcoursesadvice'] = 'Puoi utilizzare la ricerca corsi per accedere come ospite oppure iscriverti nei corsi che lo consentono.';
$string['mm.courses.selfenrolment'] = 'Iscrizione spontanea';
$string['mm.courses.totalcoursesearchresults'] = 'Totale corsi: {{$a}}';
$string['mm.course.whoops'] = 'Oops!';
$string['mm.login.authenticating'] = 'Autenticazione in corso';
$string['mm.login.cancel'] = 'Annulla';
$string['mm.login.cannotdownloadfiles'] = 'Lo scaricamento dei file è disabilitato nel servizio Mobile. l\'app non può funzionare con questa impostazione disabilitata, per favore contatta l\'amministratore dle sito.';
$string['mm.login.confirmdeletesite'] = 'Sei sicuro di eliminare il sito {{sitename}}?';
$string['mm.login.connect'] = 'Collegati!';
$string['mm.login.connecttomoodle'] = 'Collegati a Moodle';
$string['mm.login.credentials'] = 'Credenziali';
$string['mm.login.credentialsdescription'] = 'Per faovre inserisci username e password per l\'autenticazione';
$string['mm.login.erroraccesscontrolalloworigin'] = 'La chiamata Cross-Origin che stai effettuando è stata rifiutata. Per ulteriori informazioni: https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['mm.login.errordeletesite'] = 'Si è verificato un errore durante l\'eliminazione di questo sito. Per favore riprova.';
$string['mm.login.errorupdatesite'] = 'Si è verificato un errore durante l\'aggiornamento del token del sito.';
$string['mm.login.help'] = 'Aiuto';
$string['mm.login.helpmelogin'] = '<p>Esistono diverse migliaia di siti Moodle al mondo. Queta app può collegarsi solamente in quei siti dove è stato configurato l\'accesso Mobile app.</p><p>Se non riesci a collegarti al sito Moodle desiderato devi contattare l\'amministratore di quel sito e chiedergli di documentarsi su <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Per provare l\'applicazione su un sito Moodle demo inserire <i>teacher</i> oppure <i>student</i> nel campo <i>Username</i> e fare click sul pulsante <b>Aggiungi</b>.</p>';
$string['mm.login.invalidaccount'] = 'Verificare le proprie credenziali o chiedere all\'amministratore del sito di controllare la configurazione del sito.';
$string['mm.login.invalidmoodleversion'] = 'Versione di Moodle non valida. La versione minima richiesta:';
$string['mm.login.invalidsite'] = 'L\'URL del sito non è valida';
$string['mm.login.localmobileunexpectedresponse'] = 'Il controllo delle Moodle Mobile Additional Feature ha restituito una risposta inattesa, sarai autenticato tramite i servizi Mobile standard.';
$string['mm.login.login'] = 'Login';
$string['mm.login.loginbutton'] = 'Login!';
$string['mm.login.logininsiterequired'] = 'Devi autenticarti usando una finestra browser';
$string['mm.login.mobileservicesnotenabled'] = 'I servizi mobile non sono abilitati nel sito. Per richiederne l\'abilitazione, contattare l\'amministrazione del sito.';
$string['mm.login.newsitedescription'] = 'Inserisci l\'URL del sito Moodle al quale vuoi collegarti. Da notare che il sito deve essere configurato per funzionare con questa app.';
$string['mm.login.notloggedin'] = 'Devi essere autenticato';
$string['mm.login.password'] = 'Password';
$string['mm.login.passwordrequired'] = 'Password necessaria';
$string['mm.login.reconnect'] = 'Riconnetti';
$string['mm.login.reconnectdescription'] = 'Il token di autenticazione non è valido oppure è scaduto. Devi ricollegarti al sito.';
$string['mm.login.reconnectssodescription'] = 'Il token di autenticazione non è valido oppure è scaduto. Devi ricollegarti al sito autenticandoti tramite il browser.';
$string['mm.login.siteaddress'] = 'Indirizzo del sito';
$string['mm.login.siteinmaintenance'] = 'Il sito è in modalità manutenzione';
$string['mm.login.siteurl'] = 'URL del sito';
$string['mm.login.siteurlrequired'] = 'L\'URL del sito è obbligatoria. Esempio:<i>http://www.yourmoodlesite.abc or https://www.yourmoodlesite.efg</i>';
$string['mm.login.username'] = 'Username';
$string['mm.login.usernamerequired'] = 'Username obbligatorio';
$string['mm.login.webservicesnotenabled'] = 'Nel sito non sono stati abilitati i web service. Per favore contatta l\'amministratore del sito per verificare la configurazione.';
$string['mm.settings.about'] = 'Informazioni';
$string['mm.settings.appname'] = 'Moodle Mobile {{version}}';
$string['mm.settings.appready'] = 'App ready';
$string['mm.settings.cacheexpirationtime'] = 'Durata cache (millisecondi)';
$string['mm.settings.cordovadevicemodel'] = 'Modello del dispositivo Cordova';
$string['mm.settings.cordovadeviceosversion'] = 'Versione SO del dispositivo Cordova';
$string['mm.settings.cordovadeviceplatform'] = 'Piattaforma del dispositivo Cordova';
$string['mm.settings.cordovadeviceuuid'] = 'Uuid del dispositivo Cordova';
$string['mm.settings.cordovaversion'] = 'Versione Cordova';
$string['mm.settings.credits'] = 'Riconoscimenti';
$string['mm.settings.currentlanguage'] = 'Lingua in uso';
$string['mm.settings.deletesitefiles'] = 'Sei sicuro di eliminare i file scaricati da questo sito?';
$string['mm.settings.deletesitefilestitle'] = 'Elimina file del sito';
$string['mm.settings.development'] = 'Sviluppo';
$string['mm.settings.deviceinfo'] = 'Informazioni sul dispositivo';
$string['mm.settings.deviceos'] = 'SO del dispositivo';
$string['mm.settings.devicewebworkers'] = 'Dispositivi Web Worker supportati';
$string['mm.settings.displayformat'] = 'Formato di visualizzazione';
$string['mm.settings.enabledebugging'] = 'Abilita debugging';
$string['mm.settings.enablesyncwifi'] = 'Sincronizza solo tramite Wi-Fi';
$string['mm.settings.errordeletesitefiles'] = 'Si è verificato un errore durante l\'eliminazione dei file del sito.';
$string['mm.settings.errorsyncsite'] = 'Si è verificato un errore durante la sincronizzazione dei dati dal sito. Per favore verifica la connessione internet e riprova.';
$string['mm.settings.estimatedfreespace'] = 'Spazio libero stimato';
$string['mm.settings.filesystemroot'] = 'Root del filesystem';
$string['mm.settings.general'] = 'Generale';
$string['mm.settings.language'] = 'Lingua';
$string['mm.settings.license'] = 'Licenza';
$string['mm.settings.localnotifavailable'] = 'Notifiche locali disponibili';
$string['mm.settings.locationhref'] = 'URL Webview';
$string['mm.settings.navigatorlanguage'] = 'Navigator language';
$string['mm.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['mm.settings.networkstatus'] = 'Stato della connessione internet';
$string['mm.settings.reportinbackground'] = 'Invia errori automaticamente';
$string['mm.settings.settings'] = 'Impostazioni';
$string['mm.settings.sites'] = 'Siti';
$string['mm.settings.spaceusage'] = 'Spazio utilizzato';
$string['mm.settings.storagetype'] = 'Tipo di storage';
$string['mm.settings.success'] = 'Effettuato correttamente!';
$string['mm.settings.synchronization'] = 'Sincronizzazione';
$string['mm.settings.synchronizenow'] = 'Sincronizza adesso';
$string['mm.settings.synchronizing'] = 'Sincronizzazione in corso';
$string['mm.settings.syncsettings'] = 'Impostazioni di sincronizzazione';
$string['mm.settings.syncsitesuccess'] = 'I dati dei sito sono stati sincronizzati e le cache svuotate.';
$string['mm.settings.total'] = 'Totale';
$string['mm.settings.versioncode'] = 'Versione del codice';
$string['mm.settings.versionname'] = 'Nome della versione';
$string['mm.settings.wificonnection'] = 'Connessione WiFi';
$string['mm.sidemenu.appsettings'] = 'Impostazioni app';
$string['mm.sidemenu.changesite'] = 'Cambia sito';
$string['mm.sidemenu.help'] = 'Aiuto';
$string['mm.sidemenu.logout'] = 'Logout';
$string['mm.sidemenu.mycourses'] = 'I miei corsi';
$string['mm.sidemenu.togglemenu'] = 'Attiva/disattiva menu';
$string['mm.sidemenu.website'] = 'Sito web';
$string['mm.user.address'] = 'Indirizzo';
$string['mm.user.city'] = 'Città';
$string['mm.user.contact'] = 'Contatto';
$string['mm.user.country'] = 'Stato';
$string['mm.user.description'] = 'Descrizione';
$string['mm.user.details'] = 'Dettagli';
$string['mm.user.detailsnotavailable'] = 'Non puoi visualizzare i dettagli di questo utente.';
$string['mm.user.editingteacher'] = 'Docente';
$string['mm.user.email'] = 'Email';
$string['mm.user.interests'] = 'Interessi';
$string['mm.user.invaliduser'] = 'Utente non valido.';
$string['mm.user.manager'] = 'Manager';
$string['mm.user.phone1'] = 'Telefono';
$string['mm.user.phone2'] = 'Mobile';
$string['mm.user.roles'] = 'Ruoli';
$string['mm.user.student'] = 'Studente';
$string['mm.user.teacher'] = 'Docente non editor';
$string['mm.user.webpage'] = 'Pagina web';
$string['pluginname'] = 'Stringhe di lingua Moodle Mobile';
