<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'checklist', language 'pt', branch 'MOODLE_28_STABLE'
 *
 * @package   checklist
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomments'] = 'Adicionar comentários';
$string['additem'] = 'Adicionar';
$string['additemalt'] = 'Adicionar um novo item à lista';
$string['additemhere'] = 'Inserir novo item após este';
$string['addownitems'] = 'Adicionar itens próprios';
$string['addownitems-stop'] = 'Parar de adicionar itens próprios';
$string['allowmodulelinks'] = 'Permitir hiperligações para módulos';
$string['anygrade'] = 'Qualquer';
$string['autopopulate'] = 'Mostrar módulos da disciplina na lista de verificação';
$string['autopopulate_help'] = 'Isto irá adicionar automaticamente uma lista de todos os recursos e atividades da disciplina atual para a lista de verificação.<br />
Esta lista será atualizada com quaisquer alterações à disciplina, sempre que visitar a página "Editar" da lista de verificação. <br />
Alguns itens podem ser escondidos da lista, clicando no ícone de "ocultar" ao lado destes.<br />
Para remover os itens automáticos da lista, deve alterar esta opção para \'Não\', e em seguida clicar em \'Remover itens da disciplina" na página "Editar".';
$string['autoupdate'] = 'Assinalar quando os módulos são concluídos';
$string['autoupdate_help'] = 'Isto irá verificar automaticamente os itens na sua lista quando concluir a atividade na disciplina.<br />
\'**Concluir**\' uma atividade varia de uma atividade para outra - \'ver\' um recurso, \'submeter\' um questionário ou trabalho, \'publicar\' num fórum ou aceder a um chat, etc.<br />
Se a verificação da conclusão de atividades estiver ativa para uma determinada atividade, esta será usada para assinalar o item na lista.<br />
Para obter detalhes, sobre exatamente o que causa uma atividade ser marcada como **concluída**, pergunte ao administrador para procurar no ficheiro \'mod/checlist/autoupdate.php\'.<br />
**Nota:** pode demorar algum tempo para que a conclusão de uma atividade pelo aluno seja refletida na sua lista de verificação (quando a verificação da conclusão está ativa)';
$string['autoupdatenote'] = 'É a verificação do \'aluno\' que é atualizada automaticamente - nenhuma atualização serão mostrada nas listas de verificação de \'Professores apenas\'';
$string['autoupdatewarning_both'] = 'Há itens desta lista que serão atualizados automaticamente (logo que os alunos completam a actividade relacionada). No entanto, se for uma lista de \'Alunos e professores\', as barras de progresso não serão atualizadas até que um professor concorde com as verificações assinaladas pelo aluno.';
$string['autoupdatewarning_student'] = 'Há itens desta lista que serão atualizados automaticamente (logo que os alunos completam a actividade relacionada).';
$string['autoupdatewarning_teacher'] = 'A atualização automática está ativa para esta lista, mas estas marcas não serão mostradas uma vez que apenas as marcas do \'professor\' serão exibidas.';
$string['calendardescription'] = 'Este evento foi inserido pela lista de verificação: {$a}';
$string['canceledititem'] = 'Cancelar';
$string['changetextcolour'] = 'Cor do texto seguinte';
$string['checkeditemsdeleted'] = 'Foram eliminados os itens marcados';
$string['checklist'] = 'checklist';
$string['checklist:addinstance'] = 'Adicionar uma nova checklist';
$string['checklistautoupdate'] = 'Permitir a atualização automática das checklists';
$string['checklist:edit'] = 'Criar e editar checklists';
$string['checklist:emailoncomplete'] = 'Receber e-mails de conclusão';
$string['checklistfor'] = 'Checklist para';
$string['checklistintro'] = 'Descrição';
$string['checklist:preview'] = 'Pré-visualizar a checklist';
$string['checklistsettings'] = 'Definições';
$string['checklist:updatelocked'] = 'Atualizar marcações bloqueadas da lista de verificação';
$string['checklist:updateother'] = 'Atualizar marcações dos alunos da checklist';
$string['checklist:updateown'] = 'Atualizar as suas marcações da checklist';
$string['checklist:viewmenteereports'] = 'Visualização do progresso do aluno (apenas)';
$string['checklist:viewreports'] = 'Visualização do progresso do aluno';
$string['checks'] = 'Marcas de verificação';
$string['comments'] = 'Comentários';
$string['completionpercent'] = 'Percentagem de itens que devem ser desmarcados:';
$string['completionpercentgroup'] = 'É necessário desmarcar';
$string['configchecklistautoupdate'] = 'Antes de permitir isso, deve fazer algumas alterações ao código do core Moodle, consulte mod/checklist/README.txt para mais detalhes';
$string['configshowcompletemymoodle'] = 'Se estiver desmarcada, as listas de verificação completas estarão ocultas da "Minha página" do Moodle';
$string['configshowmymoodle'] = 'Se estiver desmarcada, as atividades \'listas de verificação\' (com barra de progressão) não aparecem na "Minha página" do Moodle';
$string['configshowupdateablemymoodle'] = 'Se estiver assinalada, apenas as listas de verificação atualizáveis estarão visíveis na "Minha página" do Moodle';
$string['confirmdeleteitem'] = 'Tem certeza de que deseja apagar permanentemente este item da checklist?';
$string['deleteitem'] = 'Apagar este item';
$string['duedatesoncalendar'] = 'Adicionar datas de prazo ao calendário';
$string['edit'] = 'Editar lista de verificação';
$string['editchecks'] = 'Editar verificações';
$string['editdatesstart'] = 'Editar datas';
$string['editdatesstop'] = 'Parar a edição de datas';
$string['edititem'] = 'Editar este item';
$string['emailoncomplete'] = 'Enviar e-mail quando a lista de verificação estiver concluída';
$string['emailoncompletebody'] = 'O utilizador {$a->user} concluiu a checklist \'{$a->checklist}\' da disciplina \'{$a->coursename}\'.
Veja a checklist aqui:';
$string['emailoncompletebodyown'] = 'Concluiu a checklist \'{$a->checklist}\' da disciplina \'{$a->coursename}\'.
Veja a checklist aqui:';
$string['emailoncomplete_help'] = 'Quando uma lista de verificação é concluída, uma notificação de e-mail pode ser enviada para o aluno que a completou, a todos os professores da disciplina ou a ambos.<br />
Um administrador pode controlar quem recebe este e-mail usando a permissão \'mod:checklist/emailoncomplete\' - por defeito, todos os professores e os professores não editores têm esta permissão.';
$string['emailoncompletesubject'] = 'O utilizador {$a->user} concluiu a checklist \'{$a->checklist}\'';
$string['emailoncompletesubjectown'] = 'Concluiu a checklist \'{$a->checklist}\'';
$string['eventchecklistcomplete'] = 'Checklist concluída';
$string['eventeditpageviewed'] = 'Página de edição visualizada';
$string['eventreportviewed'] = 'Relatório visualizado';
$string['eventstudentchecksupdated'] = 'Verificações do aluno atualizadas';
$string['eventteacherchecksupdated'] = 'Verificações do professor atualizadas';
$string['export'] = 'Exportar itens';
$string['forceupdate'] = 'Atualização das marcas de todos os itens automáticos';
$string['gradetocomplete'] = 'Nota de conclusão:';
$string['guestsno'] = 'Não tem permissão para visualizar esta checklist';
$string['headingitem'] = 'Este item é um título - não terá uma caixa de seleção ao lado';
$string['import'] = 'Importar itens';
$string['importfile'] = 'Escolha o ficheiro para importar';
$string['importfromcourse'] = 'A disciplina toda';
$string['importfromsection'] = 'Secção actual';
$string['indentitem'] = 'Avançar item';
$string['itemcomplete'] = 'Concluído';
$string['items'] = 'Itens da checklist';
$string['linktomodule'] = 'Hiperligação para este módulo';
$string['lockteachermarks'] = 'Bloquear verificações do professor';
$string['lockteachermarks_help'] = 'Quando essa configuração está ativa, assim que um professor guardar uma marca \'Sim\', não é possível alterá-la. < br/>Só os utilizadores com a permissão \'mod/checklist:updatelocked\' serão capazes de alterar a marca.';
$string['lockteachermarkswarning'] = 'Nota: Depois de guardar estas marcas, não será possível alterar qualquer marcas \'Sim\'';
$string['modulename'] = 'Checklist';
$string['modulename_help'] = 'O módulo **Checklist** permite ao professor criar uma lista de verificação / lista de tarefas para os seus alunos trabalharem / completarem.';
$string['modulenameplural'] = 'Checklists';
$string['moveitemdown'] = 'Mover para baixo';
$string['moveitemup'] = 'Mover para cima';
$string['noitems'] = 'Nenhum item na checklist';
$string['optionalhide'] = 'Ocultar itens opcionais';
$string['optionalitem'] = 'Este item é opcional';
$string['optionalshow'] = 'Mostrar itens opcionais';
$string['percentcomplete'] = 'Itens obrigatórios';
$string['percentcompleteall'] = 'Todos os itens da lista';
$string['pluginadministration'] = 'Administração da Checklist';
$string['pluginname'] = 'Checklist';
$string['preview'] = 'Pré-visualizar';
$string['progress'] = 'Progresso';
$string['removeauto'] = 'Remover os itens da disciplina';
$string['report'] = 'Ver progresso dos alunos';
$string['reporttablesummary'] = 'Tabela onde estão registados os itens da checklist que cada aluno já concluiu';
$string['requireditem'] = 'Este item é obrigatório - tem de ser ser concluído';
$string['resetchecklistprogress'] = 'Repôr o progresso da checklist e os itens do utlizador';
$string['savechecks'] = 'Guardar';
$string['showcompletemymoodle'] = 'Mostrar listas de verificação completas na "Minha página" do Moodle';
$string['showfulldetails'] = 'Mostrar todos os detalhes';
$string['showmymoodle'] = 'Mostrar listas de verificação na "Minha página" do Moodle';
$string['showprogressbars'] = 'Mostrar barras de progresso';
$string['showupdateablemymoodle'] = 'Mostrar apenas listas de verificação atualizáveis na "Minha página" do Moodle';
$string['teacheralongsidecheck'] = 'Alunos e professores';
$string['teachercomments'] = 'Professores podem adicionar comentários';
$string['teacherdate'] = 'Data da última atualização deste item por um professor';
$string['teacheredit'] = 'Atualizada por';
$string['teacherid'] = 'O professor que fez a última atualização desta marca';
$string['teachermarkno'] = 'O professor declara que ainda NÃO concluíste';
$string['teachermarkundecided'] = 'O professor ainda não marcou';
$string['teachermarkyes'] = 'O professor declara que já concluíste';
$string['teachernoteditcheck'] = 'Apenas os alunos';
$string['teacheroverwritecheck'] = 'Apenas os professores';
$string['theme'] = 'Tema de visualização da checklist';
$string['togglecolumn'] = 'Alternar coluna';
$string['toggledates'] = 'Mostar/ocultar nomes & datas';
$string['togglerow'] = 'Alternar linha';
$string['unindentitem'] = 'Não avançar item';
$string['updatecompletescore'] = 'Guardar notas de conclusão';
$string['updateitem'] = 'Atualizar';
$string['userdate'] = 'Data em que o utilizador atualizou este item pela última vez';
$string['useritemsallowed'] = 'Utilizador pode adicionar os seus próprios itens';
$string['useritemsdeleted'] = 'Foram eliminados os itens do utlizador';
$string['view'] = 'Ver checklist';
$string['viewall'] = 'Ver todos os alunos';
$string['viewallcancel'] = 'Cancelar';
$string['viewallsave'] = 'Guardar';
$string['viewsinglereport'] = 'Ver o progresso deste utilizador';
$string['viewsingleupdate'] = 'Atualizar o progresso deste utilizador';
$string['yesnooverride'] = 'Sim, sem substituir';
$string['yesoverride'] = 'Sim, pode substituir';
