<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'pt', branch 'MOODLE_28_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'Adicionar imagens';
$string['advertise'] = 'Divulgar esta disciplina para atrair participantes';
$string['advertised'] = 'Em divulgação';
$string['advertiseon'] = 'Divulgar esta disciplina em {$a}';
$string['advertiseonhub'] = 'Divulgar esta disciplina num hub';
$string['advertiseonmoodleorg'] = 'Divulgar esta disciplina em moodle.org';
$string['advertisepublication_help'] = 'Ao divulgar uma disciplina num servidor de comunidades hub permite que as pessoas encontrem essas disciplinas e se inscrevam.';
$string['all'] = 'Todo(a)s';
$string['allowglobalsearch'] = 'Publicar este hub e permitir a pesquisa global de todas as disciplinas';
$string['allowpublicsearch'] = 'Publicar este hub para que as pessoas se possam registar';
$string['audience'] = 'Público-alvo';
$string['audienceadmins'] = 'Administradores do Moodle';
$string['audienceeducators'] = 'Educadores';
$string['audience_help'] = 'Defina o público-alvo pretendido para a disciplina';
$string['audiencestudents'] = 'Alunos';
$string['badgesnumber'] = 'Número de Medalhas ({$a})';
$string['badurlformat'] = 'Formato de URL inválido';
$string['cannotsearchcommunity'] = 'Não possui as permissões necessárias para ver esta página';
$string['community'] = 'Comunidade';
$string['communityremoved'] = 'A hiperligação da disciplina foi removida da sua lista';
$string['confirmregistration'] = 'Confirmar registo';
$string['contactable'] = 'Contacto do público';
$string['contactable_help'] = 'Se definir o valor "Sim" o seu e-mail vai ser disponibilizado pelo hub';
$string['contactemail'] = 'E-mail de contacto';
$string['contactname'] = 'Nome de contacto';
$string['contactphone'] = 'Telefone';
$string['contactphone_help'] = 'Os contactos telefónicos apenas estão visíveis para o administrador do hub e não ao público em geral.';
$string['continue'] = 'Continuar';
$string['contributornames'] = 'Outros colaboradores';
$string['contributornames_help'] = 'Este campo pode ser usado para indicar os nomes das pessoas que colaboraram na construção desta disciplina.';
$string['coursemap'] = 'Mapa da disciplina';
$string['coursename'] = 'Nome';
$string['courseprivate'] = 'Privado(a)';
$string['coursepublic'] = 'Público(a)';
$string['coursepublished'] = 'Esta disciplina foi disponibilizada com sucesso em  "{$a}".';
$string['courseshortname'] = 'Nome curto';
$string['courseshortname_help'] = 'Indique um nome curto para a sua disciplina. Não tem que ser único.';
$string['coursesnumber'] = 'Total de disciplinas ({$a})';
$string['courseunpublished'] = 'A disciplina {$a->courseshortname} já não está disponível em {$a->hubname}.';
$string['courseurl'] = 'URL da disciplina';
$string['courseurl_help'] = 'Este é o URL da disciplina e é apresentado como uma hiperligação nos resultados das pesquisas.';
$string['creatorname'] = 'Criador';
$string['creatorname_help'] = 'A pessoa que cria a da disciplina.';
$string['creatornotes'] = 'Notas do criador';
$string['creatornotes_help'] = 'As notas do criador auxiliam os professores na forma como devem usar a disciplina.';
$string['deletescreenshots'] = 'Apagar estas imagens';
$string['deletescreenshots_help'] = 'Apagar todas as imagens que foram enviadas agora';
$string['demourl'] = 'URL de demonstração';
$string['demourl_help'] = 'Indique um URL de demostração da disciplina. O valor predefinido é o URL da própria disciplina. Este URL é mostrado como uma hiperligação nos resultados das pesquisas.';
$string['description'] = 'Descrição';
$string['description_help'] = 'Esta descrição será apresentada na lista de disciplinas no hub.';
$string['detectednotexistingpublication'] = 'O hub {$a->hubname} está a mostrar uma disciplina que já não existe. Informe o administrador deste hub que o número de publicação {$a->id} deve ser apagado.';
$string['downloadable'] = 'Para descarregar';
$string['educationallevel'] = 'Nível educacional';
$string['educationallevel_help'] = 'Selecione o nível educacional mais adequado para a disciplina em questão';
$string['edulevelassociation'] = 'Associação';
$string['edulevelcorporate'] = 'Empresa';
$string['edulevelgovernment'] = 'Estado';
$string['edulevelother'] = 'Outro';
$string['edulevelprimary'] = 'Primário';
$string['edulevelsecondary'] = 'Secundário';
$string['eduleveltertiary'] = 'Superior';
$string['emailalert'] = 'Notificações por e-mail';
$string['emailalert_help'] = 'Se ativar esta configuração o administrador do hub enviar-lhe-á e-mails sobre questões de segurança e outras notícias importantes.';
$string['enrollable'] = 'Aceita inscrições';
$string['errorbadimageheightwidth'] = 'A imagem deve ter um tamanho máximo de {$a->width} X {$a->height}';
$string['errorcourseinfo'] = 'Ocorreu um erro ao obter meta-informação da disciplina no hub ({$a}). Por favor repita a operação mais tarde voltando a aceder a esta página ou fazendo Refresh. Em alternativa, pode optar por continuar o seu registo com a seguinte meta-informação predefinida.';
$string['errorcoursepublish'] = 'Ocorreu um erro durante a publicação da disciplina ({$a}). Por favor tente mais tarde.';
$string['errorcoursewronglypublished'] = 'O hub reportou um erro de publicação. Por favor tente mais tarde.';
$string['errorcron'] = 'Ocorreu um erro no processo de atualização do registo no hub "{$a->hubname}". Mensagem de erro: ({$a->errormessage})';
$string['errorcronnoxmlrpc'] = 'Para ser possível atualizar o registo é necessário que a extensão XML-RPC do PHP esteja instalada e ativa.';
$string['errorhublisting'] = 'Ocorreu um erro ao obter a lista de hubs do site moodle.org. Por favor tente mais tarde. ({$a})';
$string['errorlangnotrecognized'] = 'O idioma fornecidoa não é reconhecido pelo Moodle. Por favor, contacte {$a}';
$string['errorregistration'] = 'Ocorreu um erro durante no registo. Por favor tente mais tarde. ({$a})';
$string['errorunpublishcourses'] = 'Ocorreu um erro no processo de remoção de disciplinas do hub. Por favor tente mais tarde (ação recomendada) ou contacte o administrador do hub.';
$string['existingscreenshotnumber'] = '{$a} imagens disponíveis. Apenas poderá consultar estas imagens quando o administrador do hub disponibilizar esta disciplina';
$string['existingscreenshots'] = 'Imagens disponíveis';
$string['forceunregister'] = 'Sim, elimine a informação de registo';
$string['forceunregisterconfirmation'] = 'O seu site não consegue comunicar com o hub {$a}. É possível que este hub esteja momentaneamente indisponível. A não ser que tenha a certeza de que pretende continuar com a remoção do registo localmente, cancele a operação e tente mais tarde.';
$string['geolocation'] = 'Geolocalização';
$string['geolocation_help'] = 'É possível que de futuro seja disponibilizada pesquisa baseada na localização geográfica. Se pretender indicar a localização da sua disciplina indique aqui os valores de latitude e longitude. Ex: 31.947884,115.871285. Uma forma de obter esta informação é usar o Google Maps.';
$string['hub'] = 'Hub';
$string['imageurl'] = 'URL da imagem';
$string['imageurl_help'] = 'Esta imagem será exibido no hub. Esta imagem deve estar disponível a partir do hub a qualquer momento. A imagem deve ter um tamanho máximo de {$a->width} X {$a->height}';
$string['information'] = 'Informação';
$string['issuedbadgesnumber'] = 'Número de Medalhas emitidas ({$a})';
$string['language'] = 'Idioma';
$string['language_help'] = 'O idioma principal desta disciplina';
$string['lasttimechecked'] = 'Última verificação';
$string['licence'] = 'Licença';
$string['licence_help'] = 'Indique a licença sob a qual pretende disponibilizar a disciplina.';
$string['licence_link'] = 'licenças';
$string['logourl'] = 'URL do logótipo';
$string['modulenumberaverage'] = 'Número médio de módulos por disciplina ({$a})';
$string['moodleorg'] = 'Moodle';
$string['mustselectsubject'] = 'É obrigatória a seleção de um assunto';
$string['name'] = 'Nome';
$string['name_help'] = 'Este nome será mostrado na lista de disciplinas.';
$string['neverchecked'] = 'Nunca foi verificado(a)';
$string['next'] = 'Seguinte';
$string['no'] = 'Não';
$string['nocheckstatusfromunreghub'] = 'O site não está registo no hub pelo que o seu estado não pode ser verificado.';
$string['nohubselected'] = 'Não foi selecionado nenhum hub.';
$string['none'] = 'Nenhum';
$string['nosearch'] = 'Não disponibilizar hubs nem disciplinas';
$string['notregisteredonhub'] = 'O administrador terá que registar este site em pelo menos um hub para que possa publicar uma disciplina. Contacte o administrador do site.';
$string['notregisteredonmoodleorg'] = 'O administrador terá que registar este site em moodle.org.';
$string['operation'] = 'Ações';
$string['orenterprivatehub'] = 'Em alternativa indique o URL de um hub privado:';
$string['participantnumberaverage'] = 'Número médio de participantes ({$a})';
$string['postaladdress'] = 'Morada';
$string['postaladdress_help'] = 'Morada deste site ou da entidade por ele representada.';
$string['postsnumber'] = 'Número de mensagens ({$a})';
$string['previousregistrationdeleted'] = 'O registo anterior foi apagado de {$a}. Pode reiniciar o processo de registo. Obrigado.';
$string['prioritise'] = 'Dê prioridade';
$string['privacy'] = 'Privacidade';
$string['privacy_help'] = 'O hub pode querer disponibilizar uma lista de sites registados. Neste caso, poderá indicar se pretende ou não aparecer nessa lista.';
$string['private'] = 'Privado(a)';
$string['privatehuburl'] = 'URL de hub privado';
$string['publicationinfo'] = 'Informação sobre publicação de disciplina';
$string['publichub'] = 'Hub público';
$string['publishcourse'] = 'Publicar {$a}';
$string['publishcourseon'] = 'Publicar em {$a}';
$string['publishedon'] = 'Publicado em {$a}';
$string['publisheremail'] = 'E-mail do publicador';
$string['publisheremail_help'] = 'Este e-mail permite ao administrador do hub alertar o publicador sobre alterações de estado da disciplina em questão.';
$string['publishername'] = 'Publicador';
$string['publishername_help'] = 'O publicador é a pessoa ou organização que publica oficialmente a disciplina.';
$string['publishon'] = 'Publicar em';
$string['publishonspecifichub'] = 'Publicar noutro hub';
$string['questionsnumber'] = 'Número de perguntas ({$a})';
$string['readvertiseon'] = 'Atualizar informação de divulgação em {$a}';
$string['registeredcourses'] = 'Disciplinas registadas';
$string['registeredmoodleorg'] = 'Moodle ({$a})';
$string['registeredon'] = 'Hubs em que está registado';
$string['registeredsites'] = 'Sites registados';
$string['registermoochtips'] = 'Registe o seu site em Moodle.org para receber alertas de segurança e ter acesso ao Moodle.net, a nossa plataforma de partilha de disciplinas.';
$string['registersite'] = 'Registar em {$a}';
$string['registerwith'] = 'Registar-se num centro Moodle';
$string['registrationconfirmed'] = 'Confirmação de registo do site';
$string['registrationconfirmedon'] = 'O site foi registado no hub {$a}. Poderá agora publicar disciplinas neste hub utilizando o link "Publicar" nos menus de administração da disciplina.';
$string['registrationinfo'] = 'Informação do registo';
$string['registrationupdated'] = 'O registo foi atualizado.';
$string['registrationupdatedfailed'] = 'A atualização do registo falhou.';
$string['removefromhub'] = 'Remover do hub';
$string['renewregistration'] = 'Renovar registo';
$string['resourcesnumber'] = 'Número de registos ({$a})';
$string['restartregistration'] = 'Reiniciar registo';
$string['roleassignmentsnumber'] = 'Número de atribuições de papéis ({$a})';
$string['screenshots'] = 'Imagens';
$string['screenshots_help'] = 'Todas as imagens da disciplina serão apresentadas nos resultados das pesquisas.';
$string['search'] = 'Pesquisa';
$string['selecthub'] = 'Selecionar hub';
$string['selecthubforadvertise'] = 'Selecionar hub para divulgação';
$string['selecthubforsharing'] = 'Selecionar hub para envio';
$string['selecthubinfo'] = 'Um hub de comunidade é um servidor que disponibiliza listas de disciplinas. Só é possível publicar disciplinas num hub se o site estiver registado nesse hub. Se o hub onde pretende fazer o registo não está na lista contacte o administrador do site.';
$string['sendfollowinginfo'] = 'Mais informação';
$string['sendfollowinginfo_help'] = 'A seguinte informação será enviada exclusivamente para tratamento estatístico. Não será tornada pública.';
$string['sendingcourse'] = 'A enviar disciplina';
$string['sendingsize'] = 'Aguarde por favor enquanto o ficheiro da disciplina é enviado ({$a->total}Mb)…';
$string['sent'] = '… terminado';
$string['settings'] = 'Configurações';
$string['settingsupdated'] = 'As configurações foram atualizadas.';
$string['share'] = 'Partilhe esta disciplina para que as pessoas possam descarregá-la';
$string['shared'] = 'Partilhada';
$string['shareon'] = 'Enviar esta disciplina para {$a}';
$string['shareonhub'] = 'Enviar esta disciplina para um hub';
$string['sharepublication_help'] = 'Ao enviar esta disciplina para um servidor hub de comunidade permitirá às pessoas descarregar e instalar essa disciplina nos seus sites.';
$string['siteadmin'] = 'Administrador';
$string['siteadmin_help'] = 'Nome completo do administrador do site.';
$string['sitecountry'] = 'País';
$string['sitecountry_help'] = 'O país onde se situa a sua organização.';
$string['sitecreated'] = 'O site foi criado';
$string['sitedesc'] = 'Descrição';
$string['sitedesc_help'] = 'Esta descrição será apresentada na lista de sites. Utilize apenas texto sem formatação.';
$string['siteemail'] = 'Endereço de e-mail';
$string['siteemail_help'] = 'É necessário indicar um endereço de e-mail para o caso de o administrador do hub precisar entrar em contacto. Esta informação não será usada para qualquer outro fim. É recomendado que seja utilizado um e-mail referente a uma função (ex: administrador@exemplo.pt) e não o de uma pessoa específica.';
$string['sitegeolocation'] = 'Geolocalização';
$string['sitegeolocation_help'] = 'É possível que de futuro seja disponibilizada pesquisa baseada na localização geográfica nos hubs. Se pretender indicar a localização do site indique aqui os valores de latitude e longitude. Ex: 31.947884,115.871285. Uma forma de obter esta informação é usar o Google Maps.';
$string['sitelang'] = 'Idioma';
$string['sitelang_help'] = 'O idioma do seu site será mostrado na lista de sites.';
$string['sitename'] = 'Nome';
$string['sitename_help'] = 'O nome do site será apresentado na lista de sites disponibilizada pelo hub.';
$string['sitephone'] = 'Telefone';
$string['sitephone_help'] = 'O seu contacto telefónico apenas estará visível para o administrador do hub.';
$string['siteprivacy'] = 'Privacidade';
$string['siteprivacylinked'] = 'Publicar o nome do site com uma hiperligação';
$string['siteprivacynotpublished'] = 'Não publicar este site';
$string['siteprivacypublished'] = 'Publicar apenas o nome do site';
$string['siteregconfcomment'] = 'Para evitar spam em {$a} o seu site precisa de uma confirmação final';
$string['siteregistrationcontact'] = 'Formulário de contacto';
$string['siteregistrationcontact_help'] = 'Se assim o desejar, poderá ser contactado através de um formulário de contacto disponível no hub. O seu e-mail não será divulgado.';
$string['siteregistrationemail'] = 'Notificações por e-mail';
$string['siteregistrationemail_help'] = 'Se ativar esta configuração o administrador do hub enviar-lhe-á e-mails sobre questões de segurança e outras notícias importantes.';
$string['siteregistrationupdated'] = 'O registo do site foi atualizado';
$string['siterelease'] = 'Versão do Moodle';
$string['siterelease_help'] = 'Versão do Moodle';
$string['siteupdatedcron'] = 'O registo do site foi atualizado em {$a}';
$string['siteupdatesend'] = 'A atualização do registo nos hubs foi concluída.';
$string['siteupdatesstart'] = 'A iniciar atualização dos registos nos hubs…';
$string['siteurl'] = 'URL do site';
$string['siteurl_help'] = 'O URL é o endereço deste site. Se as configurações de privacidade o permitirem, então será este o URL que será divulgado publicamente.';
$string['siteversion'] = 'Release do Moodle';
$string['siteversion_help'] = 'A versão do Moodle instalada neste site.';
$string['specifichubregistrationdetail'] = 'Pode também registar o site em outros hubs de comunidade.';
$string['statistics'] = 'Privacidade das estatísticas';
$string['status'] = 'Lista de hubs';
$string['statuspublished'] = 'Está na lista';
$string['statusunpublished'] = 'Não está na lista';
$string['subject'] = 'Assunto';
$string['subject_help'] = 'Selecione o assunto principal da disciplina';
$string['tags'] = 'Etiquetas';
$string['tags_help'] = 'A utilização de etiquetas permite classificar de forma mais completa as disciplinas e facilitar aos utilizadores a sua localização. Devem ser utilizadas palavras significativas, intuitivas (separadas por vírgulas). Ex: matemática, álgebra, geometria';
$string['trustme'] = 'Confiança';
$string['type'] = 'Divulgada / Partilhada';
$string['unknownstatus'] = 'Desconhecido(a)';
$string['unlistedurl'] = 'O URL do hub não está na lista';
$string['unprioritise'] = 'Retirar prioridade';
$string['unpublish'] = 'Remover publicação';
$string['unpublishalladvertisedcourses'] = 'Remover a divulgação de todas as disciplinas disponíveis no hub';
$string['unpublishalluploadedcourses'] = 'Remover todas as disciplinas que foram enviadas para um hub';
$string['unpublishconfirmation'] = 'Tem a certeza de que quer apagar a disciplina "{$a->courseshortname}" do hub "{$a->hubname}"?';
$string['unpublishcourse'] = 'Remover publicação {$a}';
$string['unregister'] = 'Remover registo';
$string['unregisterconfirmation'] = 'Está prestes a remover o registo deste site no hub {$a}. Uma vez removido este registo não poderá gerir as disciplina que tiver enviado para este hub. Tem a certeza de que pretende apagar este registo?';
$string['unregisterfrom'] = 'Remover registo do hub {$a}';
$string['unregistrationerror'] = 'Ocorreu um erro ao tentar remover o registo do site no hub: {$a}';
$string['untrustme'] = 'Não é de confiança';
$string['update'] = 'Atualizar';
$string['updatesite'] = 'Atualizar registo em {$a}';
$string['updatestatus'] = 'Verificar agora.';
$string['uploaded'] = 'Enviada';
$string['url'] = 'URL do hub';
$string['urlalreadyregistered'] = 'Aparentemente este site já está registado no hub indicado, o que indica que ocorreu erro. Por favor contacte o administrador do hub para que seja limpo o seu registo e possa efetuar um novo.';
$string['usersnumber'] = 'Número de utilizadores ({$a})';
$string['warning'] = 'AVISO';
$string['wrongtoken'] = 'O registo falhou devido a um erro desconhecido (falha na rede?). Por favor tente novamente.';
$string['wrongurlformat'] = 'Formato de URL inválido';
$string['xmlrpcdisabledcommunity'] = 'Não é possível pesquisar e descarregar disciplinas porque a extensão XML-RPC do PHP não está instalada ou não está ativa.';
$string['xmlrpcdisabledpublish'] = 'Não é possível publicar nem gerir disciplinas publicadas porque a extensão XML-RPC do PHP não está instalada ou não está ativa.';
$string['xmlrpcdisabledregistration'] = 'Não é possível remover nem atualizar o seu registo no servidor porque a extensão XML-RPC do PHP não está instalada ou não está ativa.';
