<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'pt', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['appstoredescription'] = 'NOTA: Este aplicativo oficial Moodle Mobile vai funcionar apenas com sites Moodle que foram configurados para o permitir. Fale com o administrador do seu Moodle se tiver quaisquer dificuldades em se conectar. Se o seu site Moodle foi configurado corretamente, você pode usar este aplicativo para:

- Navegar no conteúdo das suas disciplinas, mesmo quando estiver offline
- Receber notificações instantâneas de mensagens e outros eventos
- Encontrar de forma rápida e entrar em contato com outras pessoas nas suas disciplinas
- Carregar imagens, áudio, vídeos e outros ficheiros do seu dispositivo móvel
- Visualizar as suas notas das disciplinas
- E mais!

Por favor, consulte http://docs.moodle.org/en/Mobile_app para aceder à informação mais atualizada.

Gostaríamos muito de receber boas opiniões sobre a funcionalidade até agora implementada e as suas sugestões sobre outras coioisas que desejaria que este aplicativo fizesse!

O aplicativo requer as seguintes permissões:
Gravar áudio - Para gravação de áudio e carregar no Moodle
Ler e modificar o conteúdo do cartão SD - Os conteúdos são descarregados para o cartão SD para que os possa consultar offline
Acesso à rede - Para ser capaz de se conectar com seu site Moodle e verificar se você está conectado para mudar para o modo offline
Executar na inicialização do sistema - Para receber notificações, mesmo quando o aplicativo está a ser executado em segundo plano
Impedir telefone de dormir - Para que possa receber notificações a qualquer momento';
$string['mma.calendar.calendarevents'] = 'Eventos do calendário';
$string['mma.calendar.errorloadevent'] = 'Erro ao carregar evento.';
$string['mma.calendar.errorloadevents'] = 'Erro ao carregar eventos.';
$string['mma.calendar.noevents'] = 'Sem eventos';
$string['mma.calendar.notifications'] = 'Notificações';
$string['mma.coursecompletion.complete'] = 'Concluído';
$string['mma.coursecompletion.completecourse'] = 'Disciplina concluída';
$string['mma.coursecompletion.completed'] = 'Concluído';
$string['mma.coursecompletion.completiondate'] = 'Data de conclusão';
$string['mma.coursecompletion.couldnotloadreport'] = 'Não foi possível carregar o relatório de conclusão da disciplina, por favor tente mais tarde.';
$string['mma.coursecompletion.coursecompletion'] = 'Conclusão da disciplina';
$string['mma.coursecompletion.criteria'] = 'Critérios';
$string['mma.coursecompletion.criteriagroup'] = 'Grupo de critérios';
$string['mma.coursecompletion.criteriarequiredall'] = 'É exigido o cumprimento de todos os critérios abaixo';
$string['mma.coursecompletion.criteriarequiredany'] = 'É exigido o cumprimento de qualquer um dos critérios abaixo';
$string['mma.coursecompletion.inprogress'] = 'Em progresso';
$string['mma.coursecompletion.manualselfcompletion'] = 'Conclusão manual pelo próprio';
$string['mma.coursecompletion.notyetstarted'] = 'Não iniciou';
$string['mma.coursecompletion.pending'] = 'Pendente';
$string['mma.coursecompletion.required'] = 'Exigido';
$string['mma.coursecompletion.requiredcriteria'] = 'Critério exigido';
$string['mma.coursecompletion.requirement'] = 'Requisito';
$string['mma.coursecompletion.status'] = 'Estado';
$string['mma.coursecompletion.viewcoursereport'] = 'Ver relatório da disciplina';
$string['mma.files.admindisableddownload'] = 'Por favor note que o administrador do Moodle desativou a opção de descarregar ficheiros, poderá navegar nos ficheiros, mas não conseguirá descarregá-los.';
$string['mma.files.audio'] = 'Áudio';
$string['mma.files.camera'] = 'Câmera';
$string['mma.files.chooseaccountuploadfile'] = 'Escolha uma conta para enviar o ficheiro.';
$string['mma.files.clicktoupload'] = 'Clique no botão abaixo para carregar ficheiros para os seus ficheiros privados.';
$string['mma.files.confirmuploadfile'] = 'Está prestes a carregar {{size}}. Tem a certeza que quer continuar?';
$string['mma.files.couldnotloadfiles'] = 'Não foi possível carregar a lista de ficheiros';
$string['mma.files.downloading'] = 'Descarregando';
$string['mma.files.emptyfilelist'] = 'Não há ficheiros';
$string['mma.files.errorcapturingaudio'] = 'Erro ao capturar áudio.';
$string['mma.files.errorcapturingimage'] = 'Erro ao capturar imagem.';
$string['mma.files.errorcapturingvideo'] = 'Erro ao capturar  vídeo.';
$string['mma.files.errorgettingimagealbum'] = 'Erro ao obter imagem do álbum';
$string['mma.files.errormustbeonlinetoupload'] = 'Necessita de estar online para enviar ficheiros';
$string['mma.files.errornoapp'] = 'Não possui a aplicação móvel necessária para executar esta ação.';
$string['mma.files.errorreadingfile'] = 'Erro ao ler o ficheiro';
$string['mma.files.errorreceivefilenosites'] = 'Não existem sites armazenados. Por favor adicione um site antes de carregar um ficheiro.';
$string['mma.files.errorwhiledownloading'] = 'Ocorreu um erro ao descarregar o ficheiro';
$string['mma.files.errorwhilerecordingaudio'] = 'Ocorreu um erro durante a gravação do áudio.';
$string['mma.files.errorwhileuploading'] = 'Ocorreu um erro durante o carregamento do ficheiro.';
$string['mma.files.file'] = 'Ficheiro';
$string['mma.files.fileuploaded'] = 'Ficheiro carregado com sucesso';
$string['mma.files.myfiles'] = 'Meus ficheiros';
$string['mma.files.myprivatefiles'] = 'Meus ficheiros privados';
$string['mma.files.myprivatefilesdesc'] = 'Ficheiros disponíveis na sua área privada neste site Moodle';
$string['mma.files.photoalbums'] = 'Álbuns de fotos';
$string['mma.files.readingfile'] = 'A ler ficheiros';
$string['mma.files.sitefiles'] = 'Ficheiros do site';
$string['mma.files.sitefilesdesc'] = 'Os outros ficheiros que estão disponíveis para si neste site Moodle.';
$string['mma.files.success'] = 'Sucesso!';
$string['mma.files.uploadafile'] = 'Carregar um ficheiro';
$string['mma.files.uploadfiles'] = 'Carregar ficheiros';
$string['mma.files.uploading'] = 'A carregar';
$string['mma.files.video'] = 'Video';
$string['mma.frontpage.frontpage'] = 'Página principal';
$string['mma.frontpage.sitehome'] = 'Página inicial';
$string['mma.grades.average'] = 'Média';
$string['mma.grades.contributiontocoursetotal'] = 'Contribuição para o total da disciplina';
$string['mma.grades.feedback'] = 'Feedback';
$string['mma.grades.grade'] = 'Nota';
$string['mma.grades.grades'] = 'Notas';
$string['mma.grades.itemname'] = 'Item de avaliação';
$string['mma.grades.lettergrade'] = 'Nota alfabética';
$string['mma.grades.percentage'] = 'Percentagem';
$string['mma.grades.range'] = 'Intervalo';
$string['mma.grades.rank'] = 'Posição';
$string['mma.grades.viewgrades'] = 'Ver notas';
$string['mma.grades.weight'] = 'Peso';
$string['mma.messages.contactlistempty'] = 'A lista de contactos está vazia';
$string['mma.messages.contactname'] = 'Nome do contacto';
$string['mma.messages.errordeletemessage'] = 'Erro ao eliminar a mensagem.';
$string['mma.messages.erroruseronlyacceptsmessagefromcontacts'] = 'O utilizador apenas recebe mensagens dos seus contactos';
$string['mma.messages.errorwhileretrievingcontacts'] = 'Erro ao obter os contactos do servidor.';
$string['mma.messages.errorwhileretrievingdiscussions'] = 'Erro ao obter os tópicos de discussão do servidor.';
$string['mma.messages.errorwhileretrievingmessages'] = 'Erro ao obter as mensagens do servidor.';
$string['mma.messages.messagenotsent'] = 'A mensagem não foi enviada. Por favor, tente novamente mais tarde.';
$string['mma.messages.mustbeonlinetosendmessages'] = 'Precisa de estar online para enviar mensagens';
$string['mma.messages.newmessage'] = 'Nova mensagem...';
$string['mma.messages.nomessages'] = 'Sem mensagens.';
$string['mma.messages.nousersfound'] = 'Nenhum utilizador encontrado';
$string['mma.messages.send'] = 'Enviar';
$string['mma.messages.type_blocked'] = 'Bloqueado';
$string['mma.messages.type_offline'] = 'Offline';
$string['mma.messages.type_online'] = 'Online';
$string['mma.messages.type_search'] = 'Resultados da pesquisa';
$string['mma.messages.type_strangers'] = 'Outros';
$string['mma.mod_assign.userwithid'] = 'Utilizador com ID {{id}}';
$string['mma.mod_chat.errorwhileconnecting'] = 'Erro ao entrar no chat.';
$string['mma.mod_chat.errorwhilegettingchatdata'] = 'Erro ao obter os dados do chat.';
$string['mma.mod_chat.errorwhilegettingchatusers'] = 'Erro ao obter os utilizadores do chat.';
$string['mma.mod_chat.errorwhileretrievingmessages'] = 'Erro ao obter as mensagens do servidor.';
$string['mma.mod_chat.errorwhilesendingmessage'] = 'Erro ao enviar a mensagem.';
$string['mma.mod_chat.messagebeepsyou'] = '{{$a}} acabou de chamá-lo!';
$string['mma.mod_chat.messageenter'] = '{{$a}} acabou de entrar na sala de chat';
$string['mma.mod_chat.messageexit'] = '{{$a}} acabou de sair da sala de chat';
$string['mma.mod_chat.mustbeonlinetosendmessages'] = 'Tem de estar online para enviar mensagens';
$string['mma.mod_chat.sessionstart'] = 'A próxima sessão de chat irá começar em {{$a}}';
$string['mma.mod_choice.errorgetchoice'] = 'Erro ao obter os dados da sondagem.';
$string['mma.mod_choice.expired'] = 'Esta atividade terminou em {{$a}} e já não está disponível';
$string['mma.mod_choice.notopenyet'] = 'Lamentamos mas esta atividade só estará disponível em {{$a}}';
$string['mma.mod_choice.numberofuser'] = 'Número de participantes';
$string['mma.mod_choice.numberofuserinpercentage'] = 'Percentagem de participantes';
$string['mma.mod_choice.previewonly'] = 'Esta é apenas uma pré-visualização das opções disponíveis para esta atividade. Não poderá submeter a sua resposta até {{$a}}.';
$string['mma.mod_choice.responsesresultgraphdescription'] = '{{number}}% dos utilizadores escolheram esta opção: {{text}}.';
$string['mma.mod_folder.emptyfilelist'] = 'Não há ficheiros para mostrar.';
$string['mma.mod_folder.errorwhilegettingfolder'] = 'Erro ao obter os dados da pasta.';
$string['mma.mod_forum.erroremptysubject'] = 'A assunto da mensagem não pode estar em branco';
$string['mma.mod_forum.errorgetforum'] = 'Erro ao obter dados do fórum.';
$string['mma.mod_forum.errorgetgroups'] = 'Erro ao obter as configurações do grupo.';
$string['mma.mod_forum.forumnodiscussionsyet'] = 'Ainda não foram criados tópicos de discussão neste fórum.';
$string['mma.mod_forum.group'] = 'Grupo';
$string['mma.mod_forum.numdiscussions'] = '{{numdiscussions}} tópicos de discussão';
$string['mma.mod_forum.numreplies'] = '{{numreplies}} respostas';
$string['mma.mod_glossary.browsemode'] = 'Ver entradas';
$string['mma.mod_glossary.byalphabet'] = 'Alfabeticamente';
$string['mma.mod_glossary.byauthor'] = 'Agrupar por autor';
$string['mma.mod_glossary.bynewestfirst'] = 'Ordenar por mais recentes';
$string['mma.mod_glossary.byrecentlyupdated'] = 'Recentemente atualizados';
$string['mma.mod_glossary.bysearch'] = 'Pesquisar';
$string['mma.mod_glossary.entrypendingapproval'] = 'Este termo aguarda aprovação.';
$string['mma.mod_glossary.errorloadingentries'] = 'Ocorreu um erro ao carregar os termos.';
$string['mma.mod_glossary.errorloadingentry'] = 'Ocorreu um erro ao carregar o termo.';
$string['mma.mod_glossary.errorloadingglossary'] = 'Ocorreu um erro ao carregar o glossário.';
$string['mma.mod_glossary.noentriesfound'] = 'Não foi encontrado nenhum termo.';
$string['mma.mod_glossary.searchquery'] = 'Pesquisa';
$string['mma.mod_imscp.showmoduledescription'] = 'Mostrar descrição';
$string['mma.mod_label.label'] = 'Separador';
$string['mma.mod_label.taptoview'] = 'Clique para ver o separador.';
$string['mma.mod_lti.errorgetlti'] = 'Erro ao obter os dados do módulo.';
$string['mma.mod_lti.errorinvalidlaunchurl'] = 'O URL de lançamento não é válido.';
$string['mma.mod_lti.launchactivity'] = 'Iniciar a atividade';
$string['mma.mod_page.errorwhileloadingthepage'] = 'Erro ao carregar o conteúdo da página.';
$string['mma.mod_resource.errorwhileloadingthecontent'] = 'Erro ao carregar o conteúdo.';
$string['mma.mod_resource.openthefile'] = 'Abrir o ficheiro';
$string['mma.mod_scorm.cannotcalculategrade'] = 'Não foi possível calcular a nota.';
$string['mma.mod_scorm.dataattemptshown'] = 'Estes dados pertencem à tentativa número {{number}}.';
$string['mma.mod_scorm.errorcreateofflineattempt'] = 'Ocorreu um erro ao criar uma nova tentativa offline. Por favor, tente novamente.';
$string['mma.mod_scorm.errordownloadscorm'] = 'Erro ao descarregar o SCORM: "{{name}}".';
$string['mma.mod_scorm.errorgetscorm'] = 'Erro ao obter os dados do SCORM.';
$string['mma.mod_scorm.errorinvalidversion'] = 'A aplicação apenas suporta a versão SCORM 1.2.';
$string['mma.mod_scorm.errornotdownloadable'] = 'O seu site Moodle não permite descarregar pacotes SCORM. Por favor contacte o administrador do site.';
$string['mma.mod_scorm.errornovalidsco'] = 'Este SCORM não possui um SCO visível para carregar.';
$string['mma.mod_scorm.errorpackagefile'] = 'A aplicação apenas suporta pacotes ZIP.';
$string['mma.mod_scorm.errorsyncscorm'] = 'Ocorreu um erro durante o processo de sincronização. Por favor, tente novamente.';
$string['mma.mod_scorm.lastsync'] = 'Última sincronização';
$string['mma.mod_scorm.offlineattemptnote'] = 'Esta tentativa possui dados que ainda não foram sincronizados.';
$string['mma.mod_scorm.offlineattemptovermax'] = 'Esta tentativa não pode ser enviada porque já ultrapassou o número máximo de tentativas.';
$string['mma.mod_scorm.scormstatusnotdownloaded'] = 'Este SCORM não foi descarregado. Será descarregado assim que o abrir.';
$string['mma.mod_scorm.scormstatusoutdated'] = 'Este SCORM foi modificado desde a última vez que o descarregou. A versão mais recente do mesmo será descarregada automaticamente assim que o abrir.';
$string['mma.mod_scorm.warningofflinedatadeleted'] = 'Alguns dados offline da tentativa {{number}} foram excluídos porque não podem ser utilizados numa nova tentativa.';
$string['mma.mod_scorm.warningsynconlineincomplete'] = 'Algumas tentativas ainda não foram sincronizadas com o site porque a última tentativa não se encontra finalizada. Por favor, termine a tentativa online primeiro.';
$string['mma.mod_survey.cannotsubmitsurvey'] = 'Ocorreu um problema durante a submissão do seu inquérito. Por favor, tente novamente.';
$string['mma.mod_survey.errorgetsurvey'] = 'Erro ao obter os dados do inquérito.';
$string['mma.mod_survey.results'] = 'Resultados';
$string['mma.mod_url.accessurl'] = 'Aceder ao URL';
$string['mma.mod_url.pointingtourl'] = 'O URL deste recurso aponta para';
$string['mma.notes.addnewnote'] = 'Adicionar uma nova anotação';
$string['mma.notes.coursenotes'] = 'Anotações da disciplina';
$string['mma.notes.eventnotecreated'] = 'Anotação criada';
$string['mma.notes.nonotes'] = 'Ainda não existem anotações deste tipo';
$string['mma.notes.note'] = 'Anotação';
$string['mma.notes.notes'] = 'Anotações';
$string['mma.notes.personalnotes'] = 'Anotações pessoais';
$string['mma.notes.publishstate'] = 'Contexto';
$string['mma.notes.sitenotes'] = 'Anotações do site';
$string['mma.notes.userwithid'] = 'Utilizador com o ID {{id}}';
$string['mma.notifications.errorgetnotifications'] = 'Erro ao obter notificações';
$string['mma.notifications.notifications'] = 'Notificações';
$string['mma.notifications.therearentnotificationsyet'] = 'Não existem notificações';
$string['mma.participants.noparticipants'] = 'Nenhum participante encontrado nesta disciplina';
$string['mma.participants.participants'] = 'Participantes';
$string['mm.contentlinks.chooseaccount'] = 'Escolha a conta';
$string['mm.contentlinks.chooseaccounttoopenlink'] = 'Escolha uma conta para abrir a hiperligação.';
$string['mm.contentlinks.confirmurlothersite'] = 'Esta hiperligação pertence a outro site. Pretende abri-la?';
$string['mm.contentlinks.errornoactions'] = 'Não foi possível encontrar uma ação para executar com esta hiperligação.';
$string['mm.contentlinks.errornosites'] = 'Não foi possível encontrar um site que suporte esta hiperligação.';
$string['mm.core.android'] = 'Android';
$string['mm.core.cannotconnect'] = 'Não é possível estabelecer a ligação: Verifique se digitou o URL corretamente e se o seu site Moodle possui a versão 2.4 ou superior.';
$string['mm.core.cannotdownloadfiles'] = 'O seu serviço Moodle não permite descarregar ficheiros. Por favor, contacte o administrador do site.';
$string['mm.core.clearsearch'] = 'Limpar pesquisa';
$string['mm.core.clicktoseefull'] = 'Clique para ver todos os conteúdos.';
$string['mm.core.close'] = 'Fechar';
$string['mm.core.completion-alt-auto-fail'] = 'Concluído: {{$a}} (não alcançou a nota mínima para passar)';
$string['mm.core.completion-alt-auto-n'] = 'Não concluído: {{$a}}';
$string['mm.core.completion-alt-auto-pass'] = 'Concluído: {{$a}} (alcançou a nota mínima para passar)';
$string['mm.core.completion-alt-auto-y'] = 'Concluído: {{$a}}';
$string['mm.core.completion-alt-manual-n'] = 'Não concluído: {{$a}}. Selecione para marcar como concluída.';
$string['mm.core.completion-alt-manual-y'] = 'Concluído: {{$a}}. Selecione para marcar como não concluída.';
$string['mm.core.confirmopeninbrowser'] = 'Pretende abrir a ligação no navegador?';
$string['mm.core.deleting'] = 'A apagar';
$string['mm.core.dfdayweekmonth'] = 'ddd, D MMM';
$string['mm.core.dflastweekdate'] = 'ddd';
$string['mm.core.dfmediumdate'] = 'LLL';
$string['mm.core.dftimedate'] = 'hh[:]mm';
$string['mm.core.downloading'] = 'A descarregar';
$string['mm.core.elementseparator'] = ',';
$string['mm.core.errorchangecompletion'] = 'Ocorreu um erro ao alterar o estado de conclusão. Por favor, tente novamente.';
$string['mm.core.errordownloading'] = 'Erro ao descarregar ficheiro.';
$string['mm.core.errordownloadingsomefiles'] = 'Erro ao descarregar os ficheiros do módulo. Alguns ficheiros poderão estar em falta.';
$string['mm.core.errorinvalidresponse'] = 'Resposta inválida recebida. Por favor, contate o administrador do site Moodle se o erro persistir.';
$string['mm.core.erroropenfilenoapp'] = 'Erro ao abrir o ficheiro: não foi encontrada nenhuma aplicação compatível com este tipo de ficheiro.';
$string['mm.core.erroropenfilenoextension'] = 'Erro ao abrir o ficheiro: o ficheiro não possui uma extensão.';
$string['mm.core.erroropenpopup'] = 'Esta atividade está a tentar abrir uma janela pop-up, o que é incompatível com esta aplicação.';
$string['mm.core.humanreadablesize'] = '{{size}} {{unit}}';
$string['mm.core.image'] = 'Imagem';
$string['mm.core.imageviewer'] = 'Visualizador de imagens';
$string['mm.core.info'] = 'Informações';
$string['mm.core.ios'] = 'iOS';
$string['mm.core.loading'] = 'A carregar';
$string['mm.core.lostconnection'] = 'O seu token é inválido ou expirou, terá de se autenticar novamente no site.';
$string['mm.core.mod_assign'] = 'Trabalho';
$string['mm.core.mod_assignment'] = 'Trabalho';
$string['mm.core.mod_book'] = 'Livro';
$string['mm.core.mod_chat'] = 'Chat';
$string['mm.core.mod_choice'] = 'Sondagem';
$string['mm.core.mod_data'] = 'Base de dados';
$string['mm.core.mod_database'] = 'Base de dados';
$string['mm.core.mod_external-tool'] = 'Ferramenta externa';
$string['mm.core.mod_feedback'] = 'Inquérito';
$string['mm.core.mod_file'] = 'Ficheiro';
$string['mm.core.mod_folder'] = 'Pasta';
$string['mm.core.mod_forum'] = 'Fórum';
$string['mm.core.mod_glossary'] = 'Glossário';
$string['mm.core.mod_ims'] = 'Pacote de conteúdos IMS';
$string['mm.core.mod_imscp'] = 'Pacote de conteúdos IMS';
$string['mm.core.mod_label'] = 'Separador';
$string['mm.core.mod_lesson'] = 'Lição';
$string['mm.core.mod_lti'] = 'Ferramenta externa';
$string['mm.core.mod_page'] = 'Página';
$string['mm.core.mod_quiz'] = 'Teste';
$string['mm.core.mod_resource'] = 'Recurso';
$string['mm.core.mod_scorm'] = 'Pacote SCORM';
$string['mm.core.mod_survey'] = 'Inquérito';
$string['mm.core.mod_url'] = 'URL';
$string['mm.core.mod_wiki'] = 'Wiki';
$string['mm.core.mod_workshop'] = 'Workshop';
$string['mm.core.networkerrormsg'] = 'A rede está desativada ou não se encontra a trabalhar.';
$string['mm.core.notapplicable'] = 'n/a';
$string['mm.core.numdays'] = '{{$a}} dias';
$string['mm.core.numhours'] = '{{$a}} horas';
$string['mm.core.numminutes'] = '{{$a}} minutos';
$string['mm.core.nummonths'] = '{{$a}} meses';
$string['mm.core.numseconds'] = '{{$a}} segundos';
$string['mm.core.numyears'] = '{{$a}} anos';
$string['mm.core.offline'] = 'Offline';
$string['mm.core.online'] = 'Online';
$string['mm.core.openfullimage'] = 'Clique aqui para exibir a imagem em tamanho real';
$string['mm.core.openinbrowser'] = 'Abrir no navegador';
$string['mm.core.percentagenumber'] = '{{$a}}%';
$string['mm.core.pulltorefresh'] = 'Puxe para atualizar';
$string['mm.core.requireduserdatamissing'] = 'Este utilizador não possui todos os dados de perfil obrigatórios. Por favor, preencha estes dados no seu Moodle e tente novamente. <br> {{$a}}';
$string['mm.core.searching'] = 'A procurar';
$string['mm.core.sending'] = 'A enviar';
$string['mm.core.serverconnection'] = 'Erro ao ligar ao servidor';
$string['mm.core.sizetb'] = 'TB';
$string['mm.core.success'] = 'Sucesso!';
$string['mm.core.tablet'] = 'Tablet';
$string['mm.core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['mm.core.unexpectederror'] = 'Erro inesperado. Por favor, feche e abra novamente a aplicação para tentar de novo';
$string['mm.core.unknown'] = 'Desconhecido';
$string['mm.core.unzipping'] = 'A descomprimir';
$string['mm.core.windowsphone'] = 'Windows Phone';
$string['mm.core.wsfunctionnotavailable'] = 'A função do webservice não está disponível.';
$string['mm.course.activitynotyetviewable'] = 'Não é possível visualizar esta atividade ou recurso nesta aplicação.';
$string['mm.course.activitynotyetviewablegothere'] = 'Não é possível visualizar esta atividade ou recurso nesta aplicação, clique no botão abaixo para aceder aos conteúdos a partir do site.';
$string['mm.course.allsections'] = 'Todas as secções';
$string['mm.course.confirmdownload'] = 'Está prestes a descarregar {{size}}. Tem a certeza que pretende continuar?';
$string['mm.course.confirmdownloadsection'] = 'Está prestes a descarregar {{size}}. Tem a certeza que pretende continuar?';
$string['mm.course.confirmdownloadunknownsize'] = 'Não foi possível calcular o tamanho da transferência. Tem a certeza que pretende continuar?';
$string['mm.course.contents'] = 'Conteúdos';
$string['mm.course.couldnotloadsectioncontent'] = 'Não foi possível carregar o conteúdo da secção, por favor tente novamente mais tarde.';
$string['mm.course.couldnotloadsections'] = 'Não foi possível carregar as secções, por favor tente novamente mais tarde.';
$string['mm.course.errordownloadingsection'] = 'Erro ao descarregar a secção.';
$string['mm.course.errorgetmodule'] = 'Erro ao obter os dados do módulo.';
$string['mm.course.gotothesite'] = 'Ir para o site';
$string['mm.course.nocontentavailable'] = 'Nenhum conteúdo disponível neste momento.';
$string['mm.courses.confirmselfenrol'] = 'Tem certeza de que deseja inscrever-se nesta disciplina?';
$string['mm.courses.enrolme'] = 'Inscreva-me';
$string['mm.courses.errorloadcourses'] = 'Ocorreu um erro ao carregar as disciplinas.';
$string['mm.courses.errorsearching'] = 'Ocorreu um erro durante a pesquisa.';
$string['mm.courses.errorselfenrol'] = 'Ocorreu um erro na autoinscrição.';
$string['mm.courses.filter'] = 'Filtro';
$string['mm.courses.filtermycourses'] = 'Filtrar as minhas disciplinas';
$string['mm.courses.frontpage'] = 'Página principal do site';
$string['mm.course.showall'] = 'Mostrar todos';
$string['mm.courses.mycourses'] = 'As minhas disciplinas';
$string['mm.courses.nocourses'] = 'Sem informações das disciplinas para mostrar';
$string['mm.courses.nosearchresults'] = 'Não foram encontrados resultados na sua pesquisa';
$string['mm.courses.notenroled'] = 'Não está inscrito nesta disciplina';
$string['mm.courses.notenrollable'] = 'Não se pode inscrever nesta disciplina.';
$string['mm.courses.password'] = 'Senha de inscrição';
$string['mm.courses.search'] = 'Pesquisar';
$string['mm.courses.searchcourses'] = 'Pesquisar disciplinas';
$string['mm.courses.searchcoursesadvice'] = 'Pode usar o botão de pesquisa de disciplinas para aceder às mesmas como visitante ou autoinscrever-se caso o permitam.';
$string['mm.courses.selfenrolment'] = 'Autoinscrição';
$string['mm.courses.totalcoursesearchresults'] = 'Total de disciplinas: {{$a}}';
$string['mm.course.whoops'] = 'Ops!';
$string['mm.login.authenticating'] = 'Autenticação';
$string['mm.login.cancel'] = 'Cancelar';
$string['mm.login.cannotdownloadfiles'] = 'O seu serviço Mobile não permite descarregar ficheiros e a aplicação não funciona sem ativar esta configuração. Por favor, contacte o administrador do site.';
$string['mm.login.confirmdeletesite'] = 'Tem a certeza que pretende remover o site {{sitename}}?';
$string['mm.login.connect'] = 'Ligar!';
$string['mm.login.connecttomoodle'] = 'Ligação ao Moodle';
$string['mm.login.credentials'] = 'Credenciais';
$string['mm.login.credentialsdescription'] = 'Por favor digite o seu nome de utilizador e senha para entrar';
$string['mm.login.erroraccesscontrolalloworigin'] = 'A acção de Cross-Origin que tentou executar foi rejeitada. Por favor, consulte mais informações em https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['mm.login.errordeletesite'] = 'Ocorreu um erro ao apagar este site. Por favor tente novamente.';
$string['mm.login.errorupdatesite'] = 'Ocorreu um erro enquanto atualizava o token do site.';
$string['mm.login.help'] = 'Ajuda';
$string['mm.login.helpmelogin'] = '<p>Existem milhares de sites Moodle no mundo. Esta aplicação apenas consegue aceder a sites Moodle que tenham o acesso a dispositivos móveis ativo.</p><p>
Caso não consiga aceder ao seu site Moodle através da aplicação, terá de entrar em contacto com o administrador do seu site e solicitar o acesso.<a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Para testar a aplicação num site demo do Moodle digite <i>teacher</i> ou <i>student</i> no campo <i>Site URL</i> e clique em <b>Add button</b>.</p>';
$string['mm.login.invalidaccount'] = 'Por favor, verifique os detalhes dos seus dados de utilizador ou peça ao administrador do site para verificar as configurações do site.';
$string['mm.login.invalidmoodleversion'] = 'A versão do Moodle é inválida. É necessária a versão 2.4 ou superior.';
$string['mm.login.invalidsite'] = 'O URL do site é inválido.';
$string['mm.login.localmobileunexpectedresponse'] = 'A verificação do Moodle Mobile Additional Features teve um erro inesperado, a ligação será feita através do serviço Mobile padrão.';
$string['mm.login.login'] = 'Entrar';
$string['mm.login.loginbutton'] = 'Entrar!';
$string['mm.login.logininsiterequired'] = 'Precisa de entrar no site através de uma janela de navegador.';
$string['mm.login.mobileservicesnotenabled'] = 'O seu site não tem os serviços móveis ativos. Por favor, contacte o administrador do seu site Moodle se pretende que esta funcionalidade seja ativada.';
$string['mm.login.newsitedescription'] = 'Por favor, digite o URL do seu site Moodle. Note que o mesmo poderá não estar configurado para funcionar nesta aplicação.';
$string['mm.login.notloggedin'] = 'Precisa de estar autenticado.';
$string['mm.login.password'] = 'Senha';
$string['mm.login.passwordrequired'] = 'Senha necessária';
$string['mm.login.reconnect'] = 'Entrar novamente';
$string['mm.login.reconnectdescription'] = 'O seu token de autenticação é inválido ou expirou, terá de entrar novamente no site.';
$string['mm.login.reconnectssodescription'] = 'O seu token de autenticação é inválido ou expirou, terá de entrar novamente no site. Precisa de entrar no site através de uma janela de navegador.';
$string['mm.login.siteaddress'] = 'Endereço do site';
$string['mm.login.siteinmaintenance'] = 'O seu site está em modo de manutenção';
$string['mm.login.siteurl'] = 'URL do site';
$string['mm.login.siteurlrequired'] = 'URL do site exigido, i.e <i>http://www.yourmoodlesite.abc ou https://www.yourmoodlesite.efg</i>';
$string['mm.login.username'] = 'Nome de utilizador';
$string['mm.login.usernamerequired'] = 'Nome de utilizador exigido';
$string['mm.login.webservicesnotenabled'] = 'Os serviços móveis não estão ativos no seu site. Por favor, contacte o administrador do seu site Moodle se pretende que esta funcionalidade seja ativada.';
$string['mm.settings.about'] = 'Sobre';
$string['mm.settings.appname'] = 'Moodle Mobile {{version}}';
$string['mm.settings.appready'] = 'Aplicação pronta';
$string['mm.settings.cacheexpirationtime'] = 'Intervalo de tempo para a cache expirar (milisegundos)';
$string['mm.settings.cordovadevicemodel'] = 'Modelo do Cordova Device';
$string['mm.settings.cordovadeviceosversion'] = 'Versão OS do Cordova Device';
$string['mm.settings.cordovadeviceplatform'] = 'plataforma Cordova Device';
$string['mm.settings.cordovadeviceuuid'] = 'Cordova Device uuid';
$string['mm.settings.cordovaversion'] = 'Versão do Cordova';
$string['mm.settings.credits'] = 'Créditos';
$string['mm.settings.currentlanguage'] = 'Idioma atual';
$string['mm.settings.deletesitefiles'] = 'Tem a certeza que pretende apagar os ficheiros descarregados a partir do site \'{{sitename}}\'?';
$string['mm.settings.deletesitefilestitle'] = 'Excluir os ficheiros do site';
$string['mm.settings.development'] = 'Desenvolvimento';
$string['mm.settings.deviceinfo'] = 'Informação do dispositivo';
$string['mm.settings.deviceos'] = 'Dispositivo OS';
$string['mm.settings.devicewebworkers'] = 'Device Web Workers suportados';
$string['mm.settings.displayformat'] = 'Formato de visualização';
$string['mm.settings.enabledebugging'] = 'Ativar a depuração';
$string['mm.settings.enabledownloadsection'] = 'Ativar secções de transferência';
$string['mm.settings.enabledownloadsectiondescription'] = 'Desative esta opção para acelerar o carregamento das secções da disciplina.';
$string['mm.settings.enablesyncwifi'] = 'Permitir sincronização apenas através de Wi-Fi';
$string['mm.settings.errordeletesitefiles'] = 'Erro ao apagar os ficheiros do site.';
$string['mm.settings.errorsyncsite'] = 'Erro ao sincronizar os dados do site, por favor verifique a sua ligação à internet e tente novamente.';
$string['mm.settings.estimatedfreespace'] = 'Espaço livre estimado';
$string['mm.settings.filesystemroot'] = 'Raíz do sistema de ficheiros';
$string['mm.settings.general'] = 'Geral';
$string['mm.settings.language'] = 'Idioma';
$string['mm.settings.license'] = 'Licença';
$string['mm.settings.localnotifavailable'] = 'Notificações locais disponíveis';
$string['mm.settings.locationhref'] = 'URL do Webview';
$string['mm.settings.navigatorlanguage'] = 'Idioma do navegador';
$string['mm.settings.navigatoruseragent'] = 'UserAgent do navegador';
$string['mm.settings.networkstatus'] = 'Estado da ligação à internet';
$string['mm.settings.reportinbackground'] = 'Reportar erros automaticamente';
$string['mm.settings.settings'] = 'Configurações';
$string['mm.settings.sites'] = 'Sites';
$string['mm.settings.spaceusage'] = 'Utilização do espaço';
$string['mm.settings.storagetype'] = 'Tipo de armazenamento';
$string['mm.settings.success'] = 'Sucesso!';
$string['mm.settings.synchronization'] = 'Sincronização';
$string['mm.settings.synchronizenow'] = 'Sincronizar agora';
$string['mm.settings.synchronizing'] = 'A sincronizar';
$string['mm.settings.syncsettings'] = 'Configurações de sincronização';
$string['mm.settings.syncsitesuccess'] = 'Os dados do site foram sincronizados e toda a cache foi apagada.';
$string['mm.settings.total'] = 'Total';
$string['mm.settings.versioncode'] = 'Versão do código';
$string['mm.settings.versionname'] = 'Nome da versão';
$string['mm.settings.wificonnection'] = 'Ligação Wi-Fi';
$string['mm.sidemenu.appsettings'] = 'Configurações da aplicação';
$string['mm.sidemenu.changesite'] = 'Mudar de site';
$string['mm.sidemenu.help'] = 'Ajuda';
$string['mm.sidemenu.logout'] = 'Sair';
$string['mm.sidemenu.mycourses'] = 'As minhas disciplinas';
$string['mm.sidemenu.togglemenu'] = 'Alternar menu';
$string['mm.sidemenu.website'] = 'Site';
$string['mm.user.address'] = 'Endereço';
$string['mm.user.city'] = 'Cidade';
$string['mm.user.contact'] = 'Contacto';
$string['mm.user.country'] = 'País';
$string['mm.user.description'] = 'Descrição';
$string['mm.user.details'] = 'Detalhes';
$string['mm.user.detailsnotavailable'] = 'Não tem acesso aos detalhes deste utilizador.';
$string['mm.user.editingteacher'] = 'Professor';
$string['mm.user.email'] = 'Email';
$string['mm.user.interests'] = 'Interesses';
$string['mm.user.invaliduser'] = 'Utilizador inválido';
$string['mm.user.manager'] = 'Gestor';
$string['mm.user.phone1'] = 'Telefone';
$string['mm.user.phone2'] = 'Telemóvel';
$string['mm.user.roles'] = 'Papéis';
$string['mm.user.student'] = 'Aluno';
$string['mm.user.teacher'] = 'Professor não editor';
$string['mm.user.webpage'] = 'Página da internet';
$string['pluginname'] = 'Strings de idioma do Moodle Mobile';
