<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'pt', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodleorg
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'O Moodle pode ser copiado em forma livre sem ser obrigatório nenhum registo; consequentemente, não temos informação completa sobre todos os que o utilizam. No entanto, utilizando o que sabemos, geramos automaticamente números e gráficos interessantes na nossa página de estatísticas.';
$string['aboutstatisticsheading'] = 'Estatísticas Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Estatísticas Moodle';
$string['activeusers24hours'] = 'Utilizadores registrados que acederam nas últimas 24 horas:';
$string['activeuserspastmonth'] = 'Utilizadores registrados que acederam no último mês:';
$string['communityintro'] = 'Moodle tem uma comunidade de utilizadores grande e diversificada, com mais de <a href="http://moodle.org/userpics">{$a->usercount} utilizadores registrados</a>  que se comunicam em <a href="http://download.moodle.org/lang16/">{$a-> langcount} idiomas</a> em <a href="http://moodle.org/sites"> {$a->countrycount} países</a> (pode consultar mais estatísticas <a href="http://moodle.org/stats">neste sítio</a>).';
$string['conferencecenter'] = 'Centro de conferência Moodle';
$string['connectedsites'] = 'Alguns sítios Moodle estão ligados ao moodle.org utilizando o Moodle Networkin; assim, pode entrar neles diretamente, visto já estar autenticado aqui.';
$string['donations'] = 'Moodle é completamente livre de obrigações financeiras; porém várias pessoas da comunidade têm feito doações para o nosso projeto para ajudar a pagar os programadores que contribuem no desenvolvimento do Moodle.';
$string['donationsmoney'] = 'Pode também contribuir com dinheiro por meio de uma doação. Todo o dinheiro é usado para transformar os nossos planos em características reais das que todos poderemos usufruir. Para fazer uma doação usando cartão de crédito, na maioria das principais moedas, por favor clique no botão Paypal abaixo.<br /><br />Doadores de US$ 10 podem adicionar o seu nome a esta página por um ano. Não se esqueça de clicar no botão "continuar" depois de pagar para ver o formulário onde pode editar como será visualizado o seu nome.';
$string['donationsservices'] = 'Se precisar de serviços de hospedagem Moodle, suporte, instalação, codificação personalizada, desenvolvimento de disciplinas ou consultoria, entre em contato com o <a href="http://moodle.com/"> Parceiro Moodle do moodle.com </a> na sua localidade (esse sítio inclui publicidade). Os nossos parceiros contribuem com uma percentagem fixa de todos os seus ganhos para o fundo de desenvolvimento do Moodle Trust, para o benefício de todos.';
$string['donationstitle'] = 'Doações';
$string['donationstrust'] = 'O Moodle tem um fundo de desenvolvimento, gerido pelo Moodle Trust, usado para contratar programadores para o seu desenvolvimento e para suportar as despesas de moodle.org.';
$string['downloadcore'] = 'O nosso principal método de distribuição é por meio de pacotes com o núcleo básico do Moodle. Pacotes esses que contêm varios módulos mantidos pelos programadores do projeto e  que podem ser instalados em praticamente qualquer plataforma que disponha de PHP e duma base de dados.';
$string['downloadcoretitle'] = 'Pacotes básicos do Moodle';
$string['downloadintro'] = 'Moodle é Software Livre sob a <a href="http://docs.moodle.org/en/License">licença GPL</a>. Tudo o que produzimos está disponível para ser descarregado e usado livremente.';
$string['downloadlang'] = 'Nas versões atuais do Moodle, adição de suporte para novas línguas foram automatizadas a partir do menu de administração em seu sítio. No entanto, para algumas versões antigas do Moodle, novos pacotes de idiomas precisam ser baixado manualmente.';
$string['downloadlangtitle'] = 'Pacotes de idioma';
$string['downloadmac'] = 'Se tiver um servidor Web já criado, estes pacotes "all-in-one" (tudo em um) tornam muito fácil a instalação do Moodle em qualquer computador da Apple com o Mac OS X.';
$string['downloadmactitle'] = 'Moodle para Mac OS X';
$string['downloadmodules'] = 'Navegue pela nossa base de dados repleta de módulos extras e plugins que podem ser instalados no seu sítio Moodle dando funcionalidades adicionais para além dos pacotes básicos.';
$string['downloadmodulestitle'] = 'Módulos e plugins';
$string['downloadthemes'] = 'A aparência de um sítio Moodle pode ser modificada totalmente utilizando um tema diferente. Mantemos uma base de dados onde são partilhados temas criados por outros utilizadores Moodle.';
$string['downloadthemestitle'] = 'Temas';
$string['downloadwin'] = 'Se não tiver um servidor Web já criado, estes pacotes "all-in-one" (tudo em um) tornam mais fácil a instalação do Moodle em qualquer computador com Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle para Windows';
$string['erroradminonly'] = 'Apenas os administradores podem usar esta interface.';
$string['erroralreadyvoted'] = 'Já votou a favor de {$a}';
$string['errormaxmessages'] = 'Lamentamos, mas não pode enviar mais do que 3 mensagens.';
$string['errornomainnews'] = 'Não foi possível encontrar ou criar um fórum de notícias principal para o sítio';
$string['errorsendingmail'] = 'Houve um erro no envio da sua mensagem. Por favor, tente mais tarde ou contate o administrador do sítio.';
$string['events'] = 'Embora a nossa especialidade seja a aprendizagem remota, é sempre agradável reunir-se pessoalmente! Consulte estes sítios para obter mais informações sobre as nossas conferências (designadas de MoodleMoots) e outros eventos.';
$string['eventstitle'] = 'Eventos';
$string['generaldeveloperforum'] = 'Fórum geral de programadores';
$string['graphpopulation'] = 'Gráfico populacional do Moodle';
$string['graphregistrationmap'] = 'Mapa de registros do Moodle';
$string['graphregistrationmapdesc'] = '10 primeiros dos sítios registrados em {$a} países';
$string['graphusersites'] = 'Comparação de sítios Moodle por utilizadores';
$string['jobs'] = 'Visite a nossa base de dados de empregos para informações sobre as oportunidades de empregos relacionados com o Moodle em todo o mundo.';
$string['newregistrations'] = 'Novas inscrições';
$string['noenrolledcoursesyet'] = 'Ainda não está inscrito em nenhuma disciplina deste sítio.';
$string['permalink'] = 'Permalink';
$string['popularissues'] = 'Questões mais populares';
$string['recentpart'] = 'Esta página mostra algumas das pessoas que estão usando moodle.org hoje.';
$string['registeredsites'] = 'As instituições não são obrigadas a informar  quando utilizam o Moodle, já que o Moodle é Software Livre. No entanto, alguns sítios Moodle optaram por registrar-se e constam da nossa lista.';
$string['registeredsitestitle'] = 'Sítios registrados';
$string['registereduserslastday'] = 'Novos utilizadores nas últimas 24 horas:';
$string['registereduserstotal'] = 'Total de utilizadores registrados:';
$string['registrationgraphalt'] = 'Todos os registros do Moodle ao longo do tempo';
$string['registrationgraphdesc'] = 'Realizamos regularmente uma <a href="http://docs.moodle.org/en/Usage">verificação dos sítios</a> para conferir que ainda estão ativos. Assim, poderá reparar flutuações nesse número.';
$string['registrationslast6months'] = 'Registros nos últimos 6 meses';
$string['registrationstotal'] = 'Todos os registros atuais';
$string['roadmap'] = 'Roteiro Moodle';
$string['shop'] = 'Procurando alguma forma de mostrar que faz parte da nossa comunidade? Veja a loja de roupa, canecas e todos os tipos de lembranças.';
$string['statscountries'] = 'Países';
$string['statscourses'] = 'Disciplinas';
$string['statsenrolments'] = 'Inscrições';
$string['statsposts'] = 'Mensagens no fórum';
$string['statsquestions'] = 'Questões nos testes';
$string['statsresources'] = 'Recursos';
$string['statsteachers'] = 'Professores';
$string['statsusers'] = 'Utilizadores';
$string['supportbooks'] = 'Temos uma lista de livros sobre o Moodle disponíveis para compra.';
$string['supportcommercial'] = 'Os <a href="http://moodle.com/"> Parceiros Moodle (Moodle Partners)</ a> são um grupo mundial de empresas de serviço autorizado obrigadas a apoiar financeiramente o desenvolvimento do Moodle. Elas oferecem uma gama de serviços comerciais opcionais para os utilizadores do Moodle em todo o mundo:';
$string['supportdocs1'] = 'Moodle Docs é um ótimo lugar para começar, especialmente as páginas de Perguntas Mais Frequentes (FAQ).';
$string['supportdocs2'] = 'Um bom modo de ter acesso à documentação relevante é usar o apontador "Ajuda para esta página no Moodle Docs" no rodapé de cada página do seu sítio Moodle.';
$string['supportdocsfaq'] = 'Perguntas Mais Frequentes';
$string['supportdocslang'] = 'Moodle Docs em outros idiomas';
$string['supportforums'] = 'A nossa comunidade de utilizadores comunica principalmente através de fóruns nas "disciplinas" disponíveis neste sítio Moodle. Pecisa "inscrever-se" na disciplina para enviar mensagens nos fóruns (a inscrição é totalmente livre).';
$string['supportforumsenglish'] = 'As discussões principais dos programadores e o suporte a outros utilizadores estão (em inglês) aqui:';
$string['supportforumsenglishname'] = 'Utilização do Moodle';
$string['supportforumslang'] = 'O fórum chave para os utilizadores do Moodle interagirem (em inglês) está aqui:';
$string['supportforumslangname'] = 'Moodle Lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Temos muitos outros fóruns também, em várias línguas:';
$string['supportforumslistname'] = 'Lista de os todos fóruns';
$string['supportintro'] = 'Não está sozinho! Há muitas maneiras de receber ajuda com o Moodle caso chegue a precisar.';
$string['top10sitesbycourses'] = 'Primeiros 10 sítios por disciplinas';
$string['top10sitesbyusers'] = 'Primeiros 10 sítios por utilizadores';
