<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'de', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['appstoredescription'] = 'Die App \'Moodle Mobile\' funktioniert mit Moodle-Websites, sobald diese für mobile Dienste freigegeben wurden. Bei Problemen mit der Verbindung wenden Sie sich an Ihren Moodle-Administrator.

Wenn Ihre Moodle-Website richtig konfiguriert ist, können Sie die App für folgende Aufgaben benutzen:

- Kursinhalte durchblättern, auch wenn Sie offline sind
- Push-Mitteilungen zu Nachrichten und Events empfangen
- Kontakt zu Personen in Ihren Kursen aufnehmen
- Bilder, Audio, Video und andere Dateien hochladen
- Übersicht zu Ihren persönlichen Leistungen anzeigen
- und mehr!

Aktuelle Informationen finden Sie unter http://docs.moodle.org/de/Mobile_App

Über gute Kritiken und Ihre Anregungen zur App würden wir uns freuen.

Die App benötigt folgende Berechtigungen:
- Zugriff auf Fotoalbum, Kamera und Audio
- Zugriff auf das Netzwerk
- Zugriff auf die SD-Karte (Lesen und Schreiben), um Inhalte herunterladen und offline anzeigen zu können
- Beim Start ausführen, um Mitteilungen empfangen zu können, auch wenn die App im Hintergrund läuft
- Ruhezustand deaktivieren, um jederzeit Push-Mitteilungen empfangen zu können';
$string['mma.calendar.calendarevents'] = 'Kalendereinträge';
$string['mma.calendar.errorloadevent'] = 'Fehler beim Laden des Kalendereintrags';
$string['mma.calendar.errorloadevents'] = 'Fehler beim Laden der Kalendereinträge';
$string['mma.calendar.noevents'] = 'Keine Kalendereinträge';
$string['mma.calendar.notifications'] = 'Nachrichten';
$string['mma.coursecompletion.complete'] = 'Abschließen';
$string['mma.coursecompletion.completecourse'] = 'Kurs abschließen';
$string['mma.coursecompletion.completed'] = 'Abgeschlossen';
$string['mma.coursecompletion.completiondate'] = 'Abschlussdatum';
$string['mma.coursecompletion.couldnotloadreport'] = 'Fehler beim Laden der Kursabschlussübersicht. Versuchen Sie es später nochmal.';
$string['mma.coursecompletion.coursecompletion'] = 'Kursabschluss';
$string['mma.coursecompletion.criteria'] = 'Kriterien';
$string['mma.coursecompletion.criteriagroup'] = 'Kriteriengruppe';
$string['mma.coursecompletion.criteriarequiredall'] = 'Alle nachfolgenden Kriterien sind notwendig';
$string['mma.coursecompletion.criteriarequiredany'] = 'Eines der nachfolgenden Kriterien ist notwendig';
$string['mma.coursecompletion.inprogress'] = 'In Arbeit';
$string['mma.coursecompletion.manualselfcompletion'] = 'Manueller Selbstabschluss';
$string['mma.coursecompletion.notyetstarted'] = 'Nicht begonnen';
$string['mma.coursecompletion.pending'] = 'Unerledigt';
$string['mma.coursecompletion.required'] = 'Notwendig';
$string['mma.coursecompletion.requiredcriteria'] = 'Notwendige Kriterien';
$string['mma.coursecompletion.requirement'] = 'Anforderung';
$string['mma.coursecompletion.status'] = 'Status';
$string['mma.coursecompletion.viewcoursereport'] = 'Kursbericht anzeigen';
$string['mma.files.admindisableddownload'] = 'Das Herunterladen von Dateien ist deaktiviert. Sie können nur die Dateiliste sehen.';
$string['mma.files.audio'] = 'Audioaufnahme';
$string['mma.files.camera'] = 'Kamera';
$string['mma.files.chooseaccountuploadfile'] = 'Nutzerkonto zum Hochladen wählen';
$string['mma.files.clicktoupload'] = 'Tippen Sie auf die Taste, um Dateien in \'Meine persönlichen Dateien\' hochzuladen.';
$string['mma.files.confirmuploadfile'] = 'Möchten Sie wirklich {{size}} hochladen?';
$string['mma.files.couldnotloadfiles'] = 'Die Dateiliste konnte nicht geladen werden.';
$string['mma.files.downloading'] = 'Herunterladen';
$string['mma.files.emptyfilelist'] = 'Keine Dateien zum Anzeigen';
$string['mma.files.errorcapturingaudio'] = 'Fehler bei der Audioaufnahme';
$string['mma.files.errorcapturingimage'] = 'Fehler bei der Fotoaufnahme';
$string['mma.files.errorcapturingvideo'] = 'Fehler bei der Videoaufnahme';
$string['mma.files.errorgettingimagealbum'] = 'Fehler beim Laden aus dem Fotoalbum';
$string['mma.files.errormustbeonlinetoupload'] = 'Dateien können nur online hochgeladen werden.';
$string['mma.files.errornoapp'] = 'Keine App zum Ausführen dieser Aktion gefunden';
$string['mma.files.errorreadingfile'] = 'Fehler beim Lesen der Datei';
$string['mma.files.errorreceivefilenosites'] = 'Bisher ist noch keine Website gespeichert. Fügen Sie eine Website hinzu, bevor Sie das Hochladen einer Datei versuchen.';
$string['mma.files.errorwhiledownloading'] = 'Fehler beim Herunterladen der Datei';
$string['mma.files.errorwhilerecordingaudio'] = 'Fehler bei der Audioaufnahme';
$string['mma.files.errorwhileuploading'] = 'Fehler beim Hochladen der Datei';
$string['mma.files.file'] = 'Datei';
$string['mma.files.fileuploaded'] = 'Datei hochgeladen';
$string['mma.files.myfiles'] = 'Meine Dateien';
$string['mma.files.myprivatefiles'] = 'Meine persönlichen Dateien';
$string['mma.files.myprivatefilesdesc'] = 'Dateien, die in Ihrem persönlichen Bereich auf dieser Website verfügbar sind';
$string['mma.files.photoalbums'] = 'Fotoalbum';
$string['mma.files.readingfile'] = 'Datei lesen';
$string['mma.files.sitefiles'] = 'Dateien der Webseite';
$string['mma.files.sitefilesdesc'] = 'Dateien, die für Sie auf dieser Website verfügbar sind';
$string['mma.files.success'] = 'Fertig!';
$string['mma.files.uploadafile'] = 'Datei hochladen';
$string['mma.files.uploadfiles'] = 'Dateien hochladen';
$string['mma.files.uploading'] = 'Hochladen';
$string['mma.files.video'] = 'Videoaufnahme';
$string['mma.frontpage.frontpage'] = 'Startseite';
$string['mma.frontpage.sitehome'] = 'Startseite';
$string['mma.grades.average'] = 'Durchschnitt';
$string['mma.grades.contributiontocoursetotal'] = 'Teilbewertung';
$string['mma.grades.feedback'] = 'Feedback';
$string['mma.grades.grade'] = 'Bewertung';
$string['mma.grades.grades'] = 'Bewertungen';
$string['mma.grades.itemname'] = 'Bewertungsaspekt';
$string['mma.grades.lettergrade'] = 'Buchstabenwertung';
$string['mma.grades.percentage'] = 'Prozentsatz';
$string['mma.grades.range'] = 'Bandbreite';
$string['mma.grades.rank'] = 'Rang';
$string['mma.grades.viewgrades'] = 'Bewertungen anzeigen';
$string['mma.grades.weight'] = 'Gewichtung';
$string['mma.messages.contactlistempty'] = 'Die Kontaktliste ist leer';
$string['mma.messages.contactname'] = 'Name';
$string['mma.messages.errordeletemessage'] = 'Fehler beim Löschen der Nachricht';
$string['mma.messages.erroruseronlyacceptsmessagefromcontacts'] = 'Fehler: Person erlaubt nur Nachrichten von ihren Kontakten';
$string['mma.messages.errorwhileretrievingcontacts'] = 'Fehler beim Lesen der Kontakte vom Server';
$string['mma.messages.errorwhileretrievingdiscussions'] = 'Fehler beim Lesen der Themen vom Server';
$string['mma.messages.errorwhileretrievingmessages'] = 'Fehler beim Lesen der Nachrichten vom Server';
$string['mma.messages.messagenotsent'] = 'Die Nachricht wurde nicht gesendet. Versuchen Sie es später nochmal.';
$string['mma.messages.mustbeonlinetosendmessages'] = 'Sie müssen online sein, um Nachrichten zu senden';
$string['mma.messages.newmessage'] = 'Neue Nachnicht';
$string['mma.messages.nomessages'] = 'Keine Nachrichten';
$string['mma.messages.nousersfound'] = 'Keine Personen gefunden';
$string['mma.messages.send'] = 'Senden';
$string['mma.messages.type_blocked'] = 'Blockiert';
$string['mma.messages.type_offline'] = 'Offline';
$string['mma.messages.type_online'] = 'Online';
$string['mma.messages.type_search'] = 'Suchergebnisse';
$string['mma.messages.type_strangers'] = 'Andere Personen';
$string['mma.mod_assign.userwithid'] = 'Nutzer/in mit ID {{id}}';
$string['mma.mod_chat.errorwhileconnecting'] = 'Fehler beim Verbinden zum Chat';
$string['mma.mod_chat.errorwhilegettingchatdata'] = 'Fehler beim Lesen der Chatdaten';
$string['mma.mod_chat.errorwhilegettingchatusers'] = 'Fehler beim Lesen der Personen im Chat';
$string['mma.mod_chat.errorwhileretrievingmessages'] = 'Fehler beim Empfangen der Nachrichten vom Server';
$string['mma.mod_chat.errorwhilesendingmessage'] = 'Fehler beim Senden der Nachricht';
$string['mma.mod_chat.messagebeepsyou'] = '{{$a}} hat Ihnen ein Beep gesendet!';
$string['mma.mod_chat.messageenter'] = '{{$a}} hat den Chat betreten';
$string['mma.mod_chat.messageexit'] = '{{$a}} hat den Chat verlassen';
$string['mma.mod_chat.mustbeonlinetosendmessages'] = 'Sie müssen online sein, um Nachrichten zu senden';
$string['mma.mod_chat.sessionstart'] = 'Der nächste Chat beginnt in {{$a}}';
$string['mma.mod_choice.errorgetchoice'] = 'Fehler beim Laden der Abstimmungsdaten';
$string['mma.mod_choice.expired'] = 'Die Abstimmung wurde beendet {{$a}} und ist nicht weiter verfügbar';
$string['mma.mod_choice.notopenyet'] = 'Die Abstimmung ist nicht verfügbar bis {{$a}}';
$string['mma.mod_choice.numberofuser'] = 'Teilnehmerzahl';
$string['mma.mod_choice.numberofuserinpercentage'] = 'Anteil von Teilnehmer/innen';
$string['mma.mod_choice.previewonly'] = 'Die Vorschau zeigt die verfügbaren Optionen der Abstimmung. Sie können Ihre Auswahl aber nicht vor {{$a}} abgeben.';
$string['mma.mod_choice.responsesresultgraphdescription'] = '{{number}}% haben die Option gewählt: {{text}}.';
$string['mma.mod_folder.emptyfilelist'] = 'Keine Dateien zum Anzeigen';
$string['mma.mod_folder.errorwhilegettingfolder'] = 'Fehler beim Empfangen der Verzeichnisdaten';
$string['mma.mod_forum.erroremptysubject'] = 'Der Nachrichtenbetreff darf nicht leer sein.';
$string['mma.mod_forum.errorgetforum'] = 'Fehler beim Emfang der Forumsdaten';
$string['mma.mod_forum.errorgetgroups'] = 'Fehler beim Lesen der Gruppenenstellungen';
$string['mma.mod_forum.forumnodiscussionsyet'] = 'Keine Themen im Forum';
$string['mma.mod_forum.group'] = 'Gruppe';
$string['mma.mod_forum.numdiscussions'] = '{{numdiscussions}} Themen';
$string['mma.mod_forum.numreplies'] = '{{numreplies}} Antworten';
$string['mma.mod_glossary.browsemode'] = 'Einträge blättern';
$string['mma.mod_glossary.byalphabet'] = 'Alphabetisch';
$string['mma.mod_glossary.byauthor'] = 'Sortieren nach Autor/in';
$string['mma.mod_glossary.bynewestfirst'] = 'Neueste zuerst';
$string['mma.mod_glossary.byrecentlyupdated'] = 'Aktuelle zuerst';
$string['mma.mod_glossary.bysearch'] = 'Suchen';
$string['mma.mod_glossary.entrypendingapproval'] = 'Dieser Eintrag wartet auf Freigabe.';
$string['mma.mod_glossary.errorloadingentries'] = 'Fehler beim Laden von Einträgen';
$string['mma.mod_glossary.errorloadingentry'] = 'Fehler beim Laden des Eintrags';
$string['mma.mod_glossary.errorloadingglossary'] = 'Fehler beim Laden des Glossars';
$string['mma.mod_glossary.noentriesfound'] = 'Keine EInträge gefunden.';
$string['mma.mod_glossary.searchquery'] = 'Suchanfrage';
$string['mma.mod_imscp.showmoduledescription'] = 'Beschreibung anzeigen';
$string['mma.mod_label.label'] = 'Textfeld';
$string['mma.mod_label.taptoview'] = 'Tippen, um das Textfeld anzuzeigen';
$string['mma.mod_lti.errorgetlti'] = 'Fehler beim Empfangen der Moduldaten';
$string['mma.mod_lti.errorinvalidlaunchurl'] = 'Die Start-URL ist falsch.';
$string['mma.mod_lti.launchactivity'] = 'Aktivität starten';
$string['mma.mod_page.errorwhileloadingthepage'] = 'Fehler beim Laden des Seiteninhalts';
$string['mma.mod_resource.errorwhileloadingthecontent'] = 'Fehler beim Laden des Inhalts';
$string['mma.mod_resource.openthefile'] = 'Datei öffnen';
$string['mma.mod_scorm.cannotcalculategrade'] = 'Die Bewertung konnte nicht berechnet werden.';
$string['mma.mod_scorm.dataattemptshown'] = 'Diese Daten gehören zu Versuch {{number}}.';
$string['mma.mod_scorm.errorcreateofflineattempt'] = 'Fehler beim Hinzufügen eines Offline-Versuchs. Versuchen Sie es noch einmal.';
$string['mma.mod_scorm.errordownloadscorm'] = 'Fehler beim Laden des Lernpakets \'{{name}}\'.';
$string['mma.mod_scorm.errorgetscorm'] = 'Fehler beim Laden von Lernpaketdaten.';
$string['mma.mod_scorm.errorinvalidversion'] = 'Die App unterstützt ausschließlich Lernpakete mit SCORM 1.2.';
$string['mma.mod_scorm.errornotdownloadable'] = 'Das Herunterladen von Lernpaketen ist für Ihr Moodle deaktiviert. Fragen Sie den Administrator.';
$string['mma.mod_scorm.errornovalidsco'] = 'Dieses Lernpaket hat kein sichtbares SCO zum Laden.';
$string['mma.mod_scorm.errorpackagefile'] = 'Die App unterstützt ausschließlich ZIP-Pakete.';
$string['mma.mod_scorm.errorsyncscorm'] = 'Fehler beim Synchronisieren. Versuchen Sie es noch einmal.';
$string['mma.mod_scorm.lastsync'] = 'Letzte Synchronisation';
$string['mma.mod_scorm.offlineattemptnote'] = 'Dieser Versuch enthält Daten, die noch nicht synchronisiert wurden.';
$string['mma.mod_scorm.offlineattemptovermax'] = 'Dieser Versuch kann nicht gesendet werden, weil Sie die maximale Anzahl von Versuchen überschritten haben.';
$string['mma.mod_scorm.scormstatusnotdownloaded'] = 'Dieses Lernpaket ist noch nicht geladen. Es wird automatisch heruntergeladen, wenn Sie es öffnen.';
$string['mma.mod_scorm.scormstatusoutdated'] = 'Dieses Lernpaket wurde seit dem Herunterladen verändert. Es wird automatisch heruntergeladen, wenn Sie es öffnen.';
$string['mma.mod_scorm.warningofflinedatadeleted'] = 'Offline-Daten von Versuch {{number}} wurden gelöscht, weil sie nicht für einen neuen Versuch verwendet werden können.';
$string['mma.mod_scorm.warningsynconlineincomplete'] = 'Mehrere Versuche konnten nicht synchronisiert werden, weil der letzte Online-Versuch auf der Website nicht beendet ist. Beenden Sie zuerst den Online-Versuch.';
$string['mma.mod_survey.cannotsubmitsurvey'] = 'Fehler beim Übermitteln der Umfragedaten. Versuchen Sie es nochmal.';
$string['mma.mod_survey.errorgetsurvey'] = 'Fehler beim Empfangen der Umfragedaten';
$string['mma.mod_survey.results'] = 'Ergebnisse';
$string['mma.mod_url.accessurl'] = 'URL öffnen';
$string['mma.mod_url.pointingtourl'] = 'Die Ressource hat folgende URL';
$string['mma.mod_wiki.errorloadingpage'] = 'Fehler beim Laden der Seite';
$string['mma.mod_wiki.errornowikiavailable'] = 'Kein Wiki zum Anzeigen vorhanden';
$string['mma.mod_wiki.gowikihome'] = 'Zur Wiki-Startseite';
$string['mma.mod_wiki.subwiki'] = 'Teilwiki';
$string['mma.mod_wiki.viewpage'] = 'Seite anzeigen';
$string['mma.notes.addnewnote'] = 'Anmerkung hinzufügen';
$string['mma.notes.coursenotes'] = 'Anmerkungen zum Kurs';
$string['mma.notes.eventnotecreated'] = 'Anmerkung angelegt';
$string['mma.notes.nonotes'] = 'Keine Anmerkungen';
$string['mma.notes.note'] = 'Anmerkung';
$string['mma.notes.notes'] = 'Anmerkungen';
$string['mma.notes.personalnotes'] = 'Meine Anmerkungen';
$string['mma.notes.publishstate'] = 'Kontext';
$string['mma.notes.sitenotes'] = 'Anmerkungen zur Website';
$string['mma.notes.userwithid'] = 'Nutzer/in mit ID {{id}}';
$string['mma.notifications.errorgetnotifications'] = 'Fehler beim Abrufen von Mitteilungen';
$string['mma.notifications.notifications'] = 'Mitteilungen';
$string['mma.notifications.therearentnotificationsyet'] = 'Keine Mitteilungen';
$string['mma.participants.noparticipants'] = 'Keine Teilnehmer/innen für diesen Kurs gefunden';
$string['mma.participants.participants'] = 'Personen';
$string['mm.contentlinks.chooseaccount'] = 'Nutzerkonto wählen';
$string['mm.contentlinks.chooseaccounttoopenlink'] = 'Nutzerkonto wählen, mit dem der Link geöffnet werden soll';
$string['mm.contentlinks.confirmurlothersite'] = 'Dieser Link gehört zu einer anderen Website. Möchten Sie den Link öffnen?';
$string['mm.contentlinks.errornoactions'] = 'Aktion nicht gefunden, die zu dem Link gehört';
$string['mm.contentlinks.errornosites'] = 'Website nicht gefunden, die zu dem Link gehört';
$string['mm.core.android'] = 'Android';
$string['mm.core.cannotconnect'] = 'Die Verbindung ist nicht möglich. Prüfen Sie, ob die URL richtig ist und dass mindestens Moodle 2.4 verwendet wird.';
$string['mm.core.cannotdownloadfiles'] = 'Das Herunterladen von Dateien ist im Webservices deaktiviert. Wenden Sie sich an Ihren Administrator.';
$string['mm.core.clearsearch'] = 'Suche löschen';
$string['mm.core.clicktoseefull'] = 'Klicken zum Anzeigen aller Inhalte';
$string['mm.core.close'] = 'Schließen';
$string['mm.core.completion-alt-auto-fail'] = 'Abgeschlossen: {{$a}} (Anforderung nicht erreicht)';
$string['mm.core.completion-alt-auto-n'] = 'Nicht abgeschlossen: {{$a}}';
$string['mm.core.completion-alt-auto-pass'] = 'Abgeschlossen: {{$a}} (Anforderung erreicht)';
$string['mm.core.completion-alt-auto-y'] = 'Abgeschlossen: {{$a}}';
$string['mm.core.completion-alt-manual-n'] = 'Nicht abgeschlossen: {{$a}}. Auswählen, um als abgeschlossen zu markieren.';
$string['mm.core.completion-alt-manual-y'] = 'Abgeschlossen: {{$a}}. Auswählen, um als nicht abgeschlossen zu markieren.';
$string['mm.core.confirmopeninbrowser'] = 'Möchten Sie es im Browser öffnen?';
$string['mm.core.deleting'] = 'Löschen...';
$string['mm.core.dfdayweekmonth'] = 'ddd, D MMM';
$string['mm.core.dflastweekdate'] = 'ddd';
$string['mm.core.dfmediumdate'] = 'LLL';
$string['mm.core.dftimedate'] = 'HH[:]mm';
$string['mm.core.downloading'] = 'Herunterladen...';
$string['mm.core.elementseparator'] = ',';
$string['mm.core.errorchangecompletion'] = 'Fehler beim Ändern des Abschlussstatus. Versuchen Sei es später nochmal.';
$string['mm.core.errordownloading'] = 'Fehler beim Laden der Datei';
$string['mm.core.errordownloadingsomefiles'] = 'Fehler beim Laden der Moduldateien. Einige Dateien könnten fehlen.';
$string['mm.core.errorinvalidresponse'] = 'Ungültige Antwort. Wenden Sie sich an den Administrator, wenn der Fehler weiter auftritt.';
$string['mm.core.erroropenfilenoapp'] = 'Fehler: Keine App zum Öffnen dieses Dateityps gefunden.';
$string['mm.core.erroropenfilenoextension'] = 'Fehler: Die Datei hat keine Extension.';
$string['mm.core.erroropenpopup'] = 'Die Aktivität versucht, ein Popup zu öffnen. Popups werden von dieser App nicht unterstützt.';
$string['mm.core.humanreadablesize'] = '{{size}} {{unit}}';
$string['mm.core.image'] = 'Bild';
$string['mm.core.imageviewer'] = 'Bildanzeige';
$string['mm.core.info'] = 'Info';
$string['mm.core.ios'] = 'iOS';
$string['mm.core.loading'] = 'Laden';
$string['mm.core.lostconnection'] = 'Das Authentifizierungstoken ist abgelaufen oder ungültig. Sie müssen sich neu verbinden.';
$string['mm.core.mod_assign'] = 'Aufgabe';
$string['mm.core.mod_assignment'] = 'Aufgabe';
$string['mm.core.mod_book'] = 'Buch';
$string['mm.core.mod_chat'] = 'Chat';
$string['mm.core.mod_choice'] = 'Abstimmung';
$string['mm.core.mod_data'] = 'Datenbank';
$string['mm.core.mod_database'] = 'Datenbank';
$string['mm.core.mod_external-tool'] = 'Externes Tool';
$string['mm.core.mod_feedback'] = 'Feedback';
$string['mm.core.mod_file'] = 'Datei';
$string['mm.core.mod_folder'] = 'Verzeichnis';
$string['mm.core.mod_forum'] = 'Forum';
$string['mm.core.mod_glossary'] = 'Glossar';
$string['mm.core.mod_ims'] = 'IMS Content Package';
$string['mm.core.mod_imscp'] = 'IMS Content Package';
$string['mm.core.mod_label'] = 'Textfeld';
$string['mm.core.mod_lesson'] = 'Lektion';
$string['mm.core.mod_lti'] = 'Externes Tool';
$string['mm.core.mod_page'] = 'Textseite';
$string['mm.core.mod_quiz'] = 'Test';
$string['mm.core.mod_resource'] = 'Material';
$string['mm.core.mod_scorm'] = 'Lernpaket';
$string['mm.core.mod_survey'] = 'Umfrage';
$string['mm.core.mod_url'] = 'URL';
$string['mm.core.mod_wiki'] = 'Wiki';
$string['mm.core.mod_workshop'] = 'Workshop';
$string['mm.core.mygroups'] = 'Meine Gruppen';
$string['mm.core.networkerrormsg'] = 'Kein Netzwerk';
$string['mm.core.notapplicable'] = 'n/a';
$string['mm.core.numdays'] = '{{$a}} Tage';
$string['mm.core.numhours'] = '{{$a}} Stunden';
$string['mm.core.numminutes'] = '{{$a}} Minuten';
$string['mm.core.nummonths'] = '{{$a}} Monate';
$string['mm.core.numseconds'] = '{{$a}} Sekunden';
$string['mm.core.numyears'] = '{{$a}} Jahre';
$string['mm.core.offline'] = 'Offline';
$string['mm.core.online'] = 'Online';
$string['mm.core.openfullimage'] = 'Klicken Sie hier, um das Bild in voller Größe anzuzeigen';
$string['mm.core.openinbrowser'] = 'Im Browser öffnen';
$string['mm.core.othergroups'] = 'Weitere Gruppen';
$string['mm.core.percentagenumber'] = '{{$a}}%';
$string['mm.core.pictureof'] = 'Bild von {{$a}}';
$string['mm.core.pulltorefresh'] = 'Zum Erneuern ziehen';
$string['mm.core.requireduserdatamissing'] = 'In diesem Nutzerprofil fehlen notwendige Daten. Füllen Sie die Daten in Moodle aus und versuchen Sie es nochmal.<br> {{$a}}';
$string['mm.core.searching'] = 'Suchen';
$string['mm.core.sending'] = 'Senden';
$string['mm.core.serverconnection'] = 'Fehler beim Verbinden zum Server';
$string['mm.core.sizetb'] = 'TB';
$string['mm.core.success'] = 'Fertig!';
$string['mm.core.tablet'] = 'Tablet';
$string['mm.core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['mm.core.unexpectederror'] = 'Unerwarteter Fehler! Starten Sie die App neu und versuchen Sie es noch einmal.';
$string['mm.core.unknown'] = 'Unbekannt';
$string['mm.core.unzipping'] = 'Entpacken';
$string['mm.core.windowsphone'] = 'Windows Phone';
$string['mm.core.wsfunctionnotavailable'] = 'Die Webservice-Funktion ist nicht verfügbar.';
$string['mm.course.activitynotyetviewable'] = 'Aktivität oder Material wird in der App bisher nicht angezeigt.';
$string['mm.course.activitynotyetviewablegothere'] = 'Aktivität oder Material wird in der App bisher nicht angezeigt. Tippen Sie auf die Taste, um die Website im Browser anzuzeigen.';
$string['mm.course.allsections'] = 'Alle Abschnitte';
$string['mm.course.confirmdownload'] = 'Möchten Sie wirklich {{size}} herunterladen?';
$string['mm.course.confirmdownloadsection'] = 'Möchten Sie wirklich {{size}} herunterladen?';
$string['mm.course.confirmdownloadunknownsize'] = 'Die Datenmenge kann nicht berechnet werden. Möchten Sie wirklich herunterladen?';
$string['mm.course.contents'] = 'Inhalte';
$string['mm.course.couldnotloadsectioncontent'] = 'Die Abschnittsinhalte konnten nicht geladen werden. Versuchen Sie es später nochmal.';
$string['mm.course.couldnotloadsections'] = 'Die Abschnitte konnten nicht geladen werden. Versuchen Sie es später nochmal.';
$string['mm.course.errordownloadingsection'] = 'Fehler beim Herunterladen des Abschnitts';
$string['mm.course.errorgetmodule'] = 'Fehler beim Laden von Moduldaten';
$string['mm.course.gotothesite'] = 'Zur Website';
$string['mm.course.nocontentavailable'] = 'Aktuell sind keine Inhalte verfügbar';
$string['mm.courses.confirmselfenrol'] = 'Möchten Sie sich selbst in diesen Kurs einschreiben?';
$string['mm.courses.enrolme'] = 'Selbst einschreiben';
$string['mm.courses.errorloadcourses'] = 'Fehler beim Laden der Kurse';
$string['mm.courses.errorsearching'] = 'Fehler beim Suchen';
$string['mm.courses.errorselfenrol'] = 'Fehler bei der Selbsteinschreibung';
$string['mm.courses.filter'] = 'Filter';
$string['mm.courses.filtermycourses'] = 'Meine Kurse filtern';
$string['mm.courses.frontpage'] = 'Startseite';
$string['mm.course.showall'] = 'Alles anzeigen';
$string['mm.courses.mycourses'] = 'Meine Kurse';
$string['mm.courses.nocourses'] = 'Keine Kursinformation';
$string['mm.courses.nosearchresults'] = 'Keine Suchergebnisse';
$string['mm.courses.notenroled'] = 'Sie sind nicht in diesen Kurs eingeschrieben.';
$string['mm.courses.notenrollable'] = 'Sie können sich nicht selbst in diesen Kurs einschreiben.';
$string['mm.courses.password'] = 'Einschreibeschlüssel';
$string['mm.courses.search'] = 'Suchen';
$string['mm.courses.searchcourses'] = 'Kurse suchen';
$string['mm.courses.searchcoursesadvice'] = 'Sie können Kurse suchen, um als Gast teilzunehmen oder sich selbst einzuschreiben, falls dies erlaubt ist.';
$string['mm.courses.selfenrolment'] = 'Selbsteinschreibung';
$string['mm.courses.totalcoursesearchresults'] = 'Alle Kurse: {{$a}}';
$string['mm.course.whoops'] = 'Uuups!';
$string['mm.login.authenticating'] = 'Authentifizieren';
$string['mm.login.cancel'] = 'Abbrechen';
$string['mm.login.cannotdownloadfiles'] = 'Das Herunterladen von Dateien ist für den mobilen Webservice deaktiviert. Die App funktioniert nicht ohne diese Option. Wenden Sie sich an den Administrator.';
$string['mm.login.confirmdeletesite'] = 'Möchten Sie wirklich die Website \'{{sitename}}\' aus der Liste löschen?';
$string['mm.login.connect'] = 'Verbinden!';
$string['mm.login.connecttomoodle'] = 'Website verbinden';
$string['mm.login.credentials'] = 'Bewertungen';
$string['mm.login.credentialsdescription'] = 'Geben Sie Ihren Anmeldenamen und Ihr Kennwort ein, um sich einzuloggen auf ';
$string['mm.login.erroraccesscontrolalloworigin'] = 'Der Cross-Origin Aufruf wurde zurückgewiesen. Weitere Informationen: https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['mm.login.errordeletesite'] = 'Fehler beim Löschen der Website aus der Liste. Versuchen Sie es nochmal.';
$string['mm.login.errorupdatesite'] = 'Fehler beim Aktualisieren des Authentifizierungstokens';
$string['mm.login.help'] = 'Hilfe';
$string['mm.login.helpmelogin'] = '<p>Die App \'Moodle Mobile\' funktioniert mit Moodle-Websites, sobald diese für mobile Dienste freigegeben wurden. Bei Problemen mit der Verbindung wenden Sie sich an Ihren Moodle-Administrator.</p>
<p>Lesen Sie die aktuellen Informationen auf <a href="http://docs.moodle.org/de/Mobile_App" target="_blank">http://docs.moodle.org/de/Mobile_App</a>.</p>
<p>Um die App mit einer Demo-Website zu testen, tragen Sie bitte <i>teacher</i> oder <i>student</i> in das Feld <i>URL der Website</i> ein. Tippen Sie dann auf die Taste <b>Hinzufügen</b>.</p>';
$string['mm.login.invalidaccount'] = 'Prüfen Sie Ihre Anmeldedaten oder wenden Sie sich an den Administrator.';
$string['mm.login.invalidmoodleversion'] = 'Falsche Version. Notwendig ist mindestens Moodle 2.4.';
$string['mm.login.invalidsite'] = 'Die URL der Website ist ungültig.';
$string['mm.login.localmobileunexpectedresponse'] = 'Der Verbindungsversuch mit dem Plugin \'Moodle Mobile - Zusatzfeatures\' ist fehlgeschlagen. Sie werden über den standardmäßigen mobilen Webservices authentifiziert.';
$string['mm.login.login'] = 'Login';
$string['mm.login.loginbutton'] = 'Login!';
$string['mm.login.logininsiterequired'] = 'Sie müssen sich für diese Website im Browser anmelden.';
$string['mm.login.mobileservicesnotenabled'] = 'Die mobilen Webservices sind für diese Website nicht aktiviert. Wenden Sie sich an den Administrator, wenn Sie den mobilen Zugriff aktiviert haben möchten.';
$string['mm.login.newsitedescription'] = 'Geben Sie die URL zu Ihrer Website ein. Eventuell ist Ihre Website nicht für diese App freigegeben.';
$string['mm.login.notloggedin'] = 'Sie müssen eingeloggt sein.';
$string['mm.login.password'] = 'Kennwort';
$string['mm.login.passwordrequired'] = 'Kennwort fehlt';
$string['mm.login.reconnect'] = 'Neu verbinden';
$string['mm.login.reconnectdescription'] = 'Das Authentifizierungstoken ist abgelaufen oder ungültig. Sie müssen sich neu verbinden.';
$string['mm.login.reconnectssodescription'] = 'Das Authentifizierungstoken ist abgelaufen oder ungültig. Sie müssen sich mit einem Browser neu einloggen.';
$string['mm.login.siteaddress'] = 'URL der Website';
$string['mm.login.siteinmaintenance'] = 'Die Website ist im Wartungsmodus';
$string['mm.login.siteurl'] = 'URL der Website';
$string['mm.login.siteurlrequired'] = 'Die URL der Website ist notwendig, z.B. https://www.website.de';
$string['mm.login.username'] = 'Anmeldename';
$string['mm.login.usernamerequired'] = 'Anmeldename fehlt';
$string['mm.login.webservicesnotenabled'] = 'Die Webservices sind für diese Website nicht aktiviert. Wenden Sie sich an den Administrator, wenn Sie den mobilen Zugriff aktiviert haben möchten.';
$string['mm.settings.about'] = 'Über Moodle Mobile';
$string['mm.settings.appname'] = 'Moodle Mobile {{version}}';
$string['mm.settings.appready'] = 'Mit der App nutzbar';
$string['mm.settings.cacheexpirationtime'] = 'Speicherdauer im Cache (Millisekunden)';
$string['mm.settings.cordovadevicemodel'] = 'Cordova Device Model';
$string['mm.settings.cordovadeviceosversion'] = 'Cordova Device OS Version';
$string['mm.settings.cordovadeviceplatform'] = 'Cordova Device Platform';
$string['mm.settings.cordovadeviceuuid'] = 'Cordova Device UUID';
$string['mm.settings.cordovaversion'] = 'Cordova Version';
$string['mm.settings.credits'] = 'Mitwirkende';
$string['mm.settings.currentlanguage'] = 'Aktuelle Sprache';
$string['mm.settings.deletesitefiles'] = 'Möchten Sie wirklich alle von der Website \'{{sitename}}\' herunter geladenen Dateien löschen?';
$string['mm.settings.deletesitefilestitle'] = 'Website-Dateien löschen';
$string['mm.settings.development'] = 'Entwicklung';
$string['mm.settings.deviceinfo'] = 'Geräteinfo';
$string['mm.settings.deviceos'] = 'Geräte-OS';
$string['mm.settings.devicewebworkers'] = 'Device Web Workers unterstützt';
$string['mm.settings.displayformat'] = 'Anzeigeformat';
$string['mm.settings.enabledebugging'] = 'Debugging';
$string['mm.settings.enabledownloadsection'] = 'Herunterladen von Abschnitten aktivieren';
$string['mm.settings.enabledownloadsectiondescription'] = 'Deaktivieren Sie diese Option, um das Laden von Kursabschnitten zu beschleunigen.';
$string['mm.settings.enablesyncwifi'] = 'Synchronisieren nur mit Wifi';
$string['mm.settings.errordeletesitefiles'] = 'Fehler beim Löschen der Website-Dateien';
$string['mm.settings.errorsyncsite'] = 'Fehler beim Synchronisieren der Website. Prüfen Sie die Verbindung und versuchen Sie es nochmal.';
$string['mm.settings.estimatedfreespace'] = 'Verfügbarer Speicher';
$string['mm.settings.filesystemroot'] = 'Basislink zum Dateisystem';
$string['mm.settings.general'] = 'Allgemein';
$string['mm.settings.language'] = 'Sprache';
$string['mm.settings.license'] = 'Lizenz';
$string['mm.settings.localnotifavailable'] = 'Lokale Mitteilung verfügbar';
$string['mm.settings.locationhref'] = 'URL der Browseransicht';
$string['mm.settings.navigatorlanguage'] = 'Navigator Sprache';
$string['mm.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['mm.settings.networkstatus'] = 'Status der Internetverbindung';
$string['mm.settings.reportinbackground'] = 'Fehler automatisch senden';
$string['mm.settings.settings'] = 'Einstellungen';
$string['mm.settings.sites'] = 'Websites';
$string['mm.settings.spaceusage'] = 'Speicherplatz';
$string['mm.settings.storagetype'] = 'Speicherart';
$string['mm.settings.success'] = 'Fertig!';
$string['mm.settings.synchronization'] = 'Synchronisation';
$string['mm.settings.synchronizenow'] = 'Synchronisieren';
$string['mm.settings.synchronizing'] = 'Synchronisieren';
$string['mm.settings.syncsettings'] = 'Synchronisationseinstellungen';
$string['mm.settings.syncsitesuccess'] = 'Die Website-Daten wurden synchronisiert.';
$string['mm.settings.total'] = 'Summe';
$string['mm.settings.versioncode'] = 'Versionscode';
$string['mm.settings.versionname'] = 'Versionsname';
$string['mm.settings.wificonnection'] = 'Wifi-Verbindung';
$string['mm.sidemenu.appsettings'] = 'Einstellungen';
$string['mm.sidemenu.changesite'] = 'Website wechseln';
$string['mm.sidemenu.help'] = 'Hilfe';
$string['mm.sidemenu.logout'] = 'Website wechseln';
$string['mm.sidemenu.mycourses'] = 'Meine Kurse';
$string['mm.sidemenu.togglemenu'] = 'Menü umschalten';
$string['mm.sidemenu.website'] = 'Website';
$string['mm.user.address'] = 'Adresse';
$string['mm.user.city'] = 'Stadt';
$string['mm.user.contact'] = 'Kontakt';
$string['mm.user.country'] = 'Land';
$string['mm.user.description'] = 'Beschreibung';
$string['mm.user.details'] = 'Details';
$string['mm.user.detailsnotavailable'] = 'Die Nutzerdetails für diese Person sind für Sie nicht verfügbar.';
$string['mm.user.editingteacher'] = 'Trainer/in';
$string['mm.user.email'] = 'E-Mail';
$string['mm.user.interests'] = 'Interessen';
$string['mm.user.invaliduser'] = 'Ungültige Nutzer/in';
$string['mm.user.manager'] = 'Manager/in';
$string['mm.user.phone1'] = 'Telefon';
$string['mm.user.phone2'] = 'Mobil';
$string['mm.user.roles'] = 'Rollen';
$string['mm.user.student'] = 'Teilnehmer/in';
$string['mm.user.teacher'] = 'Trainer/in ohne Bearbeitungsrecht';
$string['mm.user.viewprofile'] = 'Profil anzeigen';
$string['mm.user.webpage'] = 'Website';
$string['pluginname'] = 'Sprachpaket für Moodle Mobile';
