<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'de', branch 'MOODLE_28_STABLE'
 *
 * @package   questionnaire
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aktion';
$string['activityoverview'] = 'Sie haben unbeantwortete Befragungen.';
$string['additionalinfo'] = 'zusätzliche Information';
$string['additionalinfo_help'] = 'Text, der auf der ersten Seite am Anfang dieses Fragebogens angezeigt werden soll, z.B. Anleitungen, Hintergrundinfos, usw.';
$string['addnewquestion'] = '{$a} Fragen hinzufügen';
$string['addquestions'] = 'Fragen hinzufügen';
$string['addselqtype'] = 'Fragetyp hinzufügen';
$string['alignment'] = 'Anordnung der Radio-Buttons';
$string['alignment_help'] = 'Anordnung wählen: senkrecht (Standard) oder waagerecht';
$string['all'] = 'Alle';
$string['alreadyfilled'] = 'Sie haben diese Befragung bereits ausgefüllt. {$a}';
$string['andaveragevalues'] = 'und durchschnittliche Werte';
$string['anonymous'] = 'Anonym';
$string['answerquestions'] = 'Beantworten Sie die Fragen ...';
$string['attempted'] = 'Der Fragebogen wurde abgegeben.';
$string['attemptstillinprogress'] = 'In Bearbeitung. Gespeichert unter:';
$string['autonumbering'] = 'Automatische Nummerierung';
$string['autonumbering_help'] = 'Automatische Nummerierung der Fragen und Seiten. Falls Sie abhängige Verzweigungen nutzen, sollten Sie dies ggfs. deaktivieren.';
$string['autonumberno'] = 'Keine Nummerierung der Fragen oder Seiten';
$string['autonumberpages'] = 'Automatische Nummerierung der Seiten';
$string['autonumberpagesandquestions'] = 'Automatische Nummerierung der Seiten und Fragen';
$string['autonumberquestions'] = 'Automatische Nummerierung der Fragen';
$string['average'] = 'Durchschnitt';
$string['averageposition'] = 'Mittlere Position';
$string['averagerank'] = 'Durchschnittsbewertung';
$string['bodytext'] = 'Texterläuterung';
$string['boxesnbexact'] = 'Genau {$a} Kästchen';
$string['boxesnbmax'] = 'Maximal {$a} Kästchen';
$string['boxesnbmin'] = 'Mindestens {$a} Kästchen';
$string['boxesnbreq'] = 'Antwort(en) auswählen';
$string['by'] = 'von';
$string['cannotviewpublicresponses'] = 'Sie können keine Antworten zu dieser öffentlichen Befragung sehen.';
$string['chart:bipolar'] = 'Bipolare Achse';
$string['chart:hbar'] = 'Horizontale Achse';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rose';
$string['chart:type'] = 'Grafiktyp';
$string['chart:type_help'] = 'Wählen Sie den Grafiktyp den Sie für dieses Feedback verwenden möchten.';
$string['chart:vprogress'] = 'Vertikaler Fortschrittsbalken';
$string['checkallradiobuttons'] = 'Prüfen Sie bitte <strong>{$a}</strong> Radio Buttons!';
$string['checkboxes'] = 'Auswahlkästchen';
$string['checkboxes_help'] = 'Tragen Sie jeweils eine Option pro Zeile ein. Die Teilnehmer/innen können eine oder mehrere Antworten auswählen.';
$string['checkbreaksadded'] = 'Neuer Seitenumbruch/Seitenumbrüche an folgenden Positione(n) eingefügt:';
$string['checkbreaksok'] = 'Alle erforderlichen Seitenumbrüche sind vorhanden!';
$string['checkbreaksremoved'] = '{$a} zusätzliche(n) Seitenumbruch/Seitenumbrüche entfernt.';
$string['checknotstarted'] = 'Auswahl nicht gestartet';
$string['checkstarted'] = 'Auswahl gestartet';
$string['clicktoswitch'] = '(klicken um zu Wechseln)';
$string['closed'] = 'Die Befragung wurde am {$a} beendet. Danke.';
$string['closedate'] = 'Enddatum verwenden';
$string['closedate_help'] = 'Sie können hier ein Abgabedatum für den Fragebogen bestimmen. Markieren Sie das Feld und wählen Sie Datum und Uhrzeit aus.
Teilnehmer werden den Fragebogen nach diesem Zeitpunkt nicht mehr ausfüllen können. Wenn hier keine Angabe gemacht wird, wird der Fragebogen nie geschlossen.';
$string['closeson'] = 'Befragung schließt am {$a}';
$string['completionsubmit'] = 'Teilnehmer müssen den Frageboten einreichen um ihn zu beenden';
$string['confalts'] = '---oder--- <br />Bestätigungsseite';
$string['configusergraph'] = 'Zeigen Sie die Grafiken für das "Personality Test"-Feedback';
$string['configusergraphlong'] = 'Nutzen Sie die <a href="http://www.rgraph.net/">Rgraph</a> library um die "Personality Test"-Feedback Grafiken zu zeigen.';
$string['confirmdelallresp'] = 'Möchten Sie wirklich alle Antworten in dieser Befragung löschen?';
$string['confirmdelchildren'] = 'Wenn Sie diese Frage löschen wird/werden die abhängige(n) Frage(n) ebenfalls gelöscht:';
$string['confirmdelgroupresp'] = 'Möchten Sie wirklich alle Antworten von {$a} löschen?';
$string['confirmdelquestion'] = 'Sind Sie sicher dass Sie die Frage an Position {$a} löschen möchten?';
$string['confirmdelquestionresps'] = 'Dies wird auch die {$a} Antwort(en) löschen, die für die Frage bereits gegeben wurden.';
$string['confirmdelresp'] = 'Möchten Sie wirklich die Antwort von {$a} löschen?';
$string['confpage'] = 'Überschrift';
$string['confpagedesc'] = 'Überschrift (fett) und Beschreibung für die "Bestätigungsseite", die nach der Abgabe der Befragung angezeigt wird. (Falls eine URL angegeben, wird diese angezeigt, anstatt die Bestätigungsseite.)';
$string['confpage_help'] = 'Überschrift (fett) und Beschreibung für die "Bestätigungsseite", die nach der Abgabe der Befragung angezeigt wird. (Falls eine URL angegeben, wird diese angezeigt, anstatt die Bestätigungsseite.)
Fall dieses Feld leer bleibt, wird nach der Abgabe eine Standard-Meldung angezeigt: Danke fürs Ausfüllen dieser Befragung.';
$string['contentoptions'] = 'Inhaltsoptionen';
$string['couldnotcreatenewsurvey'] = 'Neue Befragung konnte nicht angelegt werden!';
$string['couldnotdelresp'] = 'Antwort konnte nicht gelöscht werden';
$string['createcontent'] = 'Neuen Inhalt festlegen';
$string['createcontent_help'] = 'Wählen Sie eine Option für die Radio-Buttons ("neu erstellen" ist der Standard).';
$string['createnew'] = 'Neuen Inhalt festlegen';
$string['date'] = 'Datum';
$string['dateformatting'] = 'Verwenden Sie das Format tag/monat/jahr z.B. für den 14. März 1945: <strong>14/3/1945</strong>';
$string['date_help'] = 'Verwenden Sie diesen Fragetyp, wenn die Antwort in einem korrekten Datumsformat vorliegen soll.';
$string['deleteallresponses'] = 'Alle Antworten löschen';
$string['deletecurrentquestion'] = 'Frage {$a} löschen';
$string['deletedallgroupresp'] = 'Alle Antworten in der Gruppe  {$a} löschen';
$string['deletedallresp'] = 'Abgaben gelöscht';
$string['deletedisabled'] = 'Diese Objekt kann nicht gelöscht werden';
$string['deletedresp'] = 'Antwort löschen';
$string['deleteresp'] = 'Diese Antwort löschen';
$string['deletingresp'] = 'Antort wird gelöscht';
$string['dependquestion'] = 'Übergeordnete Frage';
$string['dependquestion_help'] = 'Sie können eine übergeordnete Frage und eine Auswahlmöglichkeit für die Frage wählen. Eine untergeordnete Frage wird Nutzer/innen nur dargestellt wenn die übergeordnete Frage und die Wahlmöglichkeit vorher ausgewählt wurden.';
$string['displaymethod'] = 'Anzeigemethode für Frage nicht definiert';
$string['download'] = 'Herunterladen';
$string['downloadtextformat'] = 'Im Test-Format herunterladen';
$string['downloadtextformat_help'] = 'Diese Funktion ermöglicht es Ihnen alle Antworten eines Fragebogend in einer Textdatei (DSV) zu speichern. Diese Datei kann in ein Tabellenkalkulationsprogramm importiert oder von einer Statistik-Software weiter verarbeitet werden.';
$string['dropdown'] = 'Dropdown-Feld';
$string['dropdown_help'] = 'Es gibt keinen eindeutigen Vorteil eine Dropdown-Box Radio-Buttons vorzuziehen außer um Platz zu sparen und die Länge der Liste zu reduzieren.';
$string['edit'] = 'Bearbeiten';
$string['editingquestionnaire'] = 'Einstellungen der Befragung bearbeiten';
$string['editquestion'] = 'Frage {$a} bearbeiten';
$string['email'] = 'E-Mail';
$string['errnewname'] = 'Sorry. Dieser Name wird bereits genutzt. Wählen Sie einen neuen Namen.';
$string['erroropening'] = 'Fehler beim Öffnen der Befragung.';
$string['errortable'] = 'Fehler. Befragungstabelle beschädigt.';
$string['essaybox'] = 'Freitextfeld';
$string['essaybox_help'] = 'Diese Frage wird ein Textbox mit x Spalten (oder der entsprechenden Breite) und y Reihen (Anzahl der Textzeilen) anzeigen.

Wenn Sie beides auf dem Standardwert 0 belassen (oder es auf 0 setzen) wird der Moodle Html-Editor mit Standardhöhe und -breite  angezeigt (Werte aus dem Kurs- oder Nutzerprofil).';
$string['event_all_responses_deleted'] = 'Alle Antworten gelöscht';
$string['event_all_responses_saved_as_text'] = 'Alle Antworten als Text gespeichert';
$string['event_all_responses_viewed'] = 'Bericht aller Antworten angezeigt';
$string['event_individual_responses_viewed'] = 'Bericht aller individuellen Antworten angezeigt';
$string['event_non_respondents_viewed'] = 'Nicht-Antwortende angezeigt';
$string['event_previewed'] = 'Befragungsvorschau angesehen';
$string['event_question_created'] = 'Frage erstellt';
$string['event_question_deleted'] = 'Frage gelöscht';
$string['event_response_deleted'] = 'Individuelle Antworten gelöscht';
$string['event_resumed'] = 'Versuch aufgenommen';
$string['event_saved'] = 'Antworten gespeichert';
$string['event_submitted'] = 'Antworten abgesendet';
$string['feedback'] = 'Feedback';
$string['feedbackaddmorefeedbacks'] = 'Füge {keine} weiteren Feedback Felder hinzu';
$string['feedbackbysection'] = 'Abschnittsfeedback';
$string['feedbackeditingglobal'] = 'Globales Feedback des Fragebogens bearbeiten';
$string['feedbackeditingmessages'] = 'Feedback-Mitteilungen des Fragebogens bearbeiten';
$string['feedbackeditingsections'] = 'Feedback der Abschnitte des Fragebogens bearbeiten';
$string['feedbackeditmessages'] = 'Einstellungen des Abschnitts speichern und Feedback-Mitteilungen bearbeiten';
$string['feedbackeditsections'] = 'Einstellungen speichern und Abschnittsfeedback bearbeiten';
$string['feedbackerrorboundaryformat'] = 'Die Grenzwerte eines Feedbacks müssen entweder in Prozent oder einer Zahl angegeben werden. Der Wert {$a} den Sie eingegeben haben, wird nicht erkannt.';
$string['feedbackerrorboundaryoutofrange'] = 'Die Grenzwerte eines Feedbacks müssen zwischen 0% und 100% liegen. Der Wert, den Sie bei der Grenze angegeben angegeben haben {$a} ist außerhalb des Bereichs.';
$string['feedbackerrorjunkinboundary'] = 'Sie müssen die Grenzwerte für das Feedback in den Boxen ohne Lücken eintragen.';
$string['feedbackerrorjunkinfeedback'] = 'Sie müssen die Feedback Felder ohne Lücken ausfüllen.';
$string['feedbackerrororder'] = 'Die Grenzwerte eines Feedbacks müssen in einer Reihenfolge sein. Der Wert, den Sie angegeben haben {$a}, liegt außerhalb des Bereichs.';
$string['feedbackglobal'] = 'Globales Feedback';
$string['feedbackglobalheading'] = 'Überschrift des globalen Feedbacks';
$string['feedbackglobalmessages'] = 'Text des globalen Feedbacks';
$string['feedbackhdr'] = 'Feedbacks';
$string['feedbackheading'] = 'Feedback Überschrift';
$string['feedbackheading_help'] = 'In der Überschrift des Feedbacks können Sie 2 Variablen nutzen: $scorepercent und $oppositescorepercent.';
$string['feedback_help'] = 'Feedback Hilfe';
$string['feedbackmessages'] = 'Feedbacktext für Abschnitt {$a}';
$string['feedbacknextsection'] = 'Nächster Abschnitt {$a}';
$string['feedbacknone'] = 'Kein Feedbacktext';
$string['feedbacknotes'] = 'Feedback Anmerkungen';
$string['feedbacknotes_help'] = 'Der hier eingetragene Text, wird den Antwortenden am Ende Ihres Feedback Berichts angezeigt.';
$string['feedbackoptions'] = 'Feedback Auswahlmöglichkeiten';
$string['feedbackoptions_help'] = 'Die Feedback Auswahlmöglichkeiten sind verfügbar wenn Ihre Befragung eine der folgenden Fragetypen oder Frageeinstellungen enthält: Radiobuttons, Dropdown oder Rate. Diese Fragen müssen als \'erforderlich\' gesetzt werden, der Name der Frage darf NICHT leer sein und die vorhandenen Frageauswahlmöglichkeiten muss einen Wert enthalten.';
$string['feedbackremovequestionfromsection'] = 'Diese Frage ist Teil des Feedback Abschnitts [{$a}]';
$string['feedbackremovesection'] = 'Das Löschen dieser Frage wird den Feedback Abschnitt [{$a}] komplett löschen.';
$string['feedbackreport'] = 'Feedbackbericht';
$string['feedbackscore'] = 'Feedback Auswertung';
$string['feedbackscoreboundary'] = 'Grenzen der Feedback Auswertung';
$string['feedbackscores'] = 'Anzeige der Auswertung';
$string['feedbackscores_help'] = 'Anzeige der Tabelle der Feedback Auswertung';
$string['feedbacksection'] = 'Abschnitt';
$string['feedbacksectionheading'] = 'Feedback Titel für Abschnitt {$a}';
$string['feedbacksectionheadingmissing'] = 'Sie müssen einen Titel für diesen Feedback Abschnitt eingeben!';
$string['feedbacksectionheadingtext'] = 'Überschrift';
$string['feedbacksectionlabel'] = 'Beschriftung';
$string['feedbacksectionlabel_help'] = 'Diese Beschriftung wird bei den Diagrammen genutzt. Bitte halten Sie ihn so kurz wie möglich.';
$string['feedbacksections'] = '{$a} Feedback Abschnitt';
$string['feedbacksectionsselect'] = 'Abschnitte';
$string['feedbacksectionsselect_help'] = 'Platzieren Sie Ihre Fragen in diese Abschnitte';
$string['feedbacksettingssaved'] = 'Feedback Einstellungen gespeichert';
$string['feedbacktype'] = 'Feedback Typ';
$string['field'] = 'Frage {$a}';
$string['fieldlength'] = 'Eingabelänge';
$string['fieldlength_help'] = 'Für den Fragetyp **Textfeld** können Sie die "Textfeldlänge" und die "Max. Textlänge" angeben.
Standardlängen sind 20 Zeichen für das Textfeld und 25 Zeichen für die maximale Textlänge.';
$string['finished'] = 'Sie haben alle Fragen dieser Befragung beantwortet!';
$string['firstrespondent'] = 'Erste/r Befragte/r';
$string['formateditor'] = 'HTML Editor';
$string['formatplain'] = 'Text';
$string['grade'] = 'Abgabe-Bewertung';
$string['gradesdeleted'] = 'Befragungsbenotung gelöscht';
$string['headingtext'] = 'Überschrift';
$string['horizontal'] = 'Waagerecht';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Auswahlcode einbeziehen';
$string['includechoicetext'] = 'Auswahltext einbeziehen';
$string['incorrectcourseid'] = 'Falsche Kurs-ID';
$string['incorrectmodule'] = 'Falsche Kursmodul-ID';
$string['incorrectquestionnaire'] = 'Falsche Befragung';
$string['invalidresponse'] = 'Falsche Antwort angegeben';
$string['invalidresponserecord'] = 'Falscher Antwortdatensatz angegeben';
$string['invalidsurveyid'] = 'Falsche Befragungs-ID';
$string['kindofratescale'] = 'Typ der Bewertungsskala';
$string['kindofratescale_help'] = 'Rechtsklick auf den "Hilfe"-Link unten.';
$string['lastrespondent'] = 'Letze Abgabe';
$string['length'] = 'Länge';
$string['managequestions'] = 'Fragen bearbeiten';
$string['managequestions_help'] = 'In der "Fragen bearbeiten"-Sektion der "Frage hinzufügen"-Seite können Sie mehre Aktionen an den Fragebogen-Fragen vornehmen.';
$string['maxdigitsallowed'] = 'Max. erlaubte Ziffern';
$string['maxdigitsallowed_help'] = 'Durch die Verwendung von Max. erlaubte Ziffern und Anzahl der Nachkomastellen können Sie die Länge und Anzahl der geforderten Nachkommastellen bestimmen.';
$string['maxforcedresponses'] = 'Max. geforderte Antworten';
$string['maxtextlength'] = 'Max. Textlänge';
$string['messageprovider:message'] = 'Fragebogen Reminder';
$string['minforcedresponses'] = 'Min. geforderte Antworten';
$string['minforcedresponses_help'] = 'Diese Optionen erlauben es, vom Teilnehmer ein Minimum von **Min.** bzw. Maximum von **Max.** an angekreuzten Kästchen zu fordern.
Um eine genaue Anzahl einzufordern, sind **Min.** und **Max.** auf den selben Wert zu setzen.
Falls nur Minimum bzw. Maximum gewünscht ist, einfach den andern Wert auf dem Standard **0** belassen.
Wenn **Min.** bzw. **Max.** anders als 0 gesetzt sind, wird der User eine Warnmeldung erhalten, wenn er sich nicht an die geforderte Anzahl Antworten hält.
Es ist wichtig, die Anforderungen an den Nutzer auch explizit zu verdeutlichen, sei es in allgemeinen Hinweisen zur Befragung oder im Text zur je spezifischen Frage.';
$string['misconfigured'] = 'Der Kurs ist falsch konfiguriert';
$string['missingname'] = 'Die Frage {$a} kann in diesem Feedback nicht genutzt werden, weil sie keinen Namen hat.';
$string['missingnameandrequired'] = 'Die Frage {$a} kann in diesem Feedback nicht genutzt werden, weil sie keinen Namen hat und nicht auf \'erforderlich\' gesetzt ist.';
$string['missingquestion'] = 'Bitte beantworten Sie die Pflichtfrage';
$string['missingquestions'] = 'Bitte beantworten Sie die Pflichtfragen:';
$string['missingrequired'] = 'Die Frage {$a} kann in diesem Feedback nicht genutzt werden, weil sie nicht auf \'erforderlich\' gesetzt ist.';
$string['modulename'] = 'Befragung';
$string['modulename_help'] = 'Das Befragung-Modul ermöglicht es Ihnen Fragebögen zu erstellen, die die Nutzer anschließend beantworten sollen.';
$string['modulenameplural'] = 'Befragungen';
$string['movedisabled'] = 'Dieses Objekt kann nicht bewegt werden';
$string['myresponses'] = 'Alle Ihre Antworten';
$string['myresponsetitle'] = 'Ihre {$a} Antworten';
$string['myresults'] = 'Ihre Ergebnisse';
$string['name'] = 'Name';
$string['navigate'] = 'Verzweigte Fragen erlauben';
$string['navigate_help'] = 'Aktivieren Sie die Option, das Ja/Nein-Fragen und Radio-Button-Fragen abhängig von der Auswahl eine A';
$string['next'] = 'Weiter';
$string['nextpage'] = 'Nächste Seite';
$string['nlines'] = '{$a} Zeilen';
$string['noanswer'] = 'Keine Antwort';
$string['noattempts'] = 'Niemand hat angefangen, diese Befragung auszufüllen.';
$string['nodata'] = 'Keine Daten angegeben.';
$string['noduplicates'] = 'Keine doppelte Auswahl';
$string['noduplicateschoiceserror'] = 'Sie müssen mindestens zwei mögliche Antworten für die "Keine Duplikate"-Option angeben.';
$string['noneinuse'] = 'Der Fragebogen enthält keine Fragen.';
$string['non_respondents'] = 'Teilnehmer/innen, die keine noch keine Antworten zu diesem Fragebogen eingereicht haben.';
$string['nopublicsurveys'] = 'Keine öffentlichen Befragungen';
$string['noresponsedata'] = 'Keine Antworten zu dieser Frage';
$string['noresponses'] = 'Keine Antworten';
$string['normal'] = 'Normal';
$string['notanumber'] = '<strong>{$a}</strong> ist kein mögliches Zahlenformat.';
$string['notapplicable'] = 'entfällt';
$string['notapplicablecolumn'] = 'Spalte entf.';
$string['notavail'] = 'Die Befragung steht nicht länger zur Verfügung. Die Befragung kann gelöscht werden.';
$string['noteligible'] = 'Sie können an dieser Befragung nicht teilnehmen.';
$string['notemplatesurveys'] = 'Keine Befragungs-Templates';
$string['notenoughscaleitems'] = 'Sie müssen mindestens zwei Werte für die Skala angeben!';
$string['notopen'] = 'Diese Befragung steht ab {$a} zur Verfügung.';
$string['notrequired'] = 'Antwort ist nicht erforderlich';
$string['not_started'] = 'nicht gestartet';
$string['nousersselected'] = 'Keine Teilnehmer/innen ausgewählt';
$string['num'] = 'Nr.';
$string['numattemptsmade'] = '{$a} Versuche bei dieser Befragung';
$string['numberfloat'] = 'Die eingegebene Zahl <strong>{$a->number}</strong> wurde neu gerundet mit <strong>{$a->precision}</strong> Dezimalstelle(n).';
$string['numberofdecimaldigits'] = 'Dezimalstellen';
$string['numberscaleitems'] = 'Skalenstufen';
$string['numberscaleitems_help'] = 'Skalenstufen bezeichnet die Anzahl der Einheiten Ihrer Bewertungsskala.

In der Regel sind 3 bis 5 Einheiten sinnvoll (Standard ist 5).';
$string['numeric'] = 'Nummerisch';
$string['numeric_help'] = 'Wählen Sie diesen Fragetyp, wenn Sie eine korrekt formatierte Zahl als Antwort erwarten.';
$string['of'] = 'von';
$string['opendate'] = 'Startdatum verwenden';
$string['opendate_help'] = 'Hier können Sie ein Anfangszeitpunkt für den Fragebogen festlegen. Markieren Sie das Feld und wählen Sie die gewünschte Datum und Uhrzeit.
Teilnhemer können vor dem angegebenen Zeitpunkt den Fragebogen nicht ausfüllen. Ohne Angabe steht der Fragebogen sofort zur Verfügung.';
$string['option'] = 'Option {$a}';
$string['optionalname'] = 'Name der Frage';
$string['optionalname_help'] = 'Der Fragetitel wird nur benutzt, wenn Sie die Antworten in das CSV/Excel-Format exportieren. Wenn Sie diese Funktion nicht verwenden, müssen Sie sich über die Fragetitel keine Gedanken machen. Wenn Sie einen regelmäßigen Export der Daten ins CSV-Format Planen, haben Sie die Wahl von zwei';
$string['or'] = '---oder---';
$string['order_ascending'] = 'Aufsteigend';
$string['order_default'] = 'Standardreihenfolge';
$string['order_descending'] = 'Absteigend';
$string['orderresponses'] = 'Antworten sortieren';
$string['orderresponses_help'] = 'Bei der Anzeige Alle Antworten können Sie die Auswahl nach der Anzahl der Anworten (die anordnen';
$string['osgood'] = 'Semantisches Differential';
$string['other'] = 'Andere:';
$string['otherempty'] = 'Wenn Sie dies ankreuzen, müssen Sie etwas ins Textfeld eingeben.';
$string['overviewnumresplog'] = 'Antworten';
$string['overviewnumresplog1'] = 'Antwort';
$string['overviewnumrespvw'] = 'Antworten';
$string['overviewnumrespvw1'] = 'Antwort';
$string['owner'] = 'Ersteller';
$string['page'] = 'Seite';
$string['pageof'] = 'Seite {$a->page} von {$a->totpages}';
$string['participant'] = 'Teilnehmer/in';
$string['pleasecomplete'] = 'Bitte Auswahl vervollständigen';
$string['pluginadministration'] = 'Befragungsadministration';
$string['pluginname'] = 'Befragung';
$string['position'] = 'Position';
$string['possibleanswers'] = 'Mögliche Antworten';
$string['posteddata'] = 'Letzte Seite mit bereits gesendeten Daten';
$string['previewing'] = 'Befragung wird als Vorschau angezeigt.';
$string['preview_label'] = 'Vorschau';
$string['preview_questionnaire'] = 'Fragebogen Vorschau';
$string['previous'] = 'Zurück';
$string['previouspage'] = 'Vorherige Seite';
$string['print'] = 'Druckversion (mit aktuellen Antworten)';
$string['printblank'] = 'Druckversion (ohne Antworten)';
$string['printblanktooltip'] = 'Ein Fenster mit einer druckfreundlichen Version der Befragung wird geöffnet (ohne Antworten)';
$string['printtooltip'] = 'Ein Fenster mit einer druckfreundlichen Version der Befragung wird geöffnet (mit den aktuellen Antworten).';
$string['private'] = 'Privat';
$string['public'] = 'Öffentlich';
$string['publiccopy'] = 'Kopie:';
$string['publicoriginal'] = 'Orginal:';
$string['qtype'] = 'Typ';
$string['qtypedaily'] = 'täglich beantworten';
$string['qtype_help'] = 'Wählen Sie aus, ob Teilnehmer/innen die Befragung einmal, täglich, wöchentlich, monatlich oder beliebig oft ausfüllen können.';
$string['qtypemonthly'] = 'monatlich beantworten';
$string['qtypeonce'] = 'einmal beantworten';
$string['qtypeunlimited'] = 'mehrfach beantworten';
$string['qtypeweekly'] = 'wöchentlich beantworten';
$string['questionnaire:addinstance'] = 'Eine neue Befragung hinzufügen';
$string['questionnaireadministration'] = 'Befragungsadministration';
$string['questionnairecloses'] = 'Befragung wird beendet';
$string['questionnaire:copysurveys'] = 'Vorlagen und persönliche Befragungen kopieren';
$string['questionnaire:createpublic'] = 'Öffentliche Befragungen anlegen';
$string['questionnaire:createtemplates'] = 'Vorlagen für Befragungen anlegen';
$string['questionnaire:deleteresponses'] = 'Jede Antwort löschen';
$string['questionnaire:downloadresponses'] = 'Antworten als Textdatei herunterladen';
$string['questionnaire:editquestions'] = 'Fragen für Befragungen erstellen und bearbeiten';
$string['questionnaire:manage'] = 'Befragungen erstellen und bearbeiten';
$string['questionnaire:message'] = 'Nachricht an Nicht-Antwortende schicken';
$string['questionnaireopens'] = 'Befragung beginnt';
$string['questionnaire:preview'] = 'Befragungsvorschau';
$string['questionnaire:printblank'] = 'Leere Befragung drucken';
$string['questionnaire:readallresponseanytime'] = 'Alle Antworten jederzeit sehen';
$string['questionnaire:readallresponses'] = 'Zusammenfassung der Antworten sehen';
$string['questionnaire:readownresponses'] = 'Eigene Antworten sehen';
$string['questionnairereport'] = 'Bericht zur Befragung';
$string['questionnaire:submit'] = 'Befragung abschliessen und abgeben';
$string['questionnaire:view'] = 'Befragung sehen';
$string['questionnaire:viewsingleresponse'] = 'Alle persönlichen Antworten sehen';
$string['questionnum'] = 'Frage-Nr.';
$string['questions'] = 'Fragen';
$string['questionsinsection'] = 'Fragen in diesem Abschnitt:';
$string['questiontypes'] = 'Fragentypen';
$string['questiontypes_help'] = 'Beachten Sie die Moodle-Dokumentation';
$string['radiobuttons'] = 'Radio Buttons';
$string['radiobuttons_help'] = 'Bei diesem Fragetyp, muss eine von mehreren Antwortvorgaben gewählt werden.';
$string['rank'] = 'Rang';
$string['ratescale'] = 'Bewertung (Skala 1..5)';
$string['ratescale_help'] = 'Beachten Sie die Moodle-Dokumentation';
$string['realm'] = 'Befragungstyp';
$string['realm_help'] = '**Es gibt 3 Typen von Befragungen**
* Privat: gehört ausschliesslich zum Kurs in dem sie erstellt wurde.
* Vorlage: kopierbar und editierbar.
* Öffentlich: kann in verschiedenen Kursen mehrfach eingesetzt werden.';
$string['redirecturl'] = 'URL, zu welcher ein Nutzer nach Abschluss der Befragung weiter geleitet wird.';
$string['remove'] = 'Löschen';
$string['removeallquestionnaireattempts'] = 'Alle Abgaben der Befragung löschen';
$string['removenotinuse'] = 'Diese Befragung beruhte auf einer Öffentlichen Befragung, die gelöscht wurde. Sie kann nicht länger eingesetzt werden und sollte gelöscht werden.';
$string['required'] = 'Anwort ist erforderlich';
$string['required_help'] = 'Wenn Sie **Ja** wählen, ist eine Antwort auf diese Frage obligatorisch, d.h. der Nutzer wird die Befragung nicht abgeben können, bis diese Frage beantwortet ist.';
$string['requiredparameter'] = 'Ein notwendiger Parameter fehlt.';
$string['reset'] = 'Zurücksetzen';
$string['respeligiblerepl'] = 'Ersetzt durch Rollenüberschreibung';
$string['respondent'] = 'Befragte Person';
$string['respondenteligibleall'] = 'alle';
$string['respondenteligiblestudents'] = 'nur Teilnehmer/innen';
$string['respondenteligibleteachers'] = 'nur Trainer/innen';
$string['respondents'] = 'Befragte';
$string['respondenttype'] = 'Gruppe der befragten Personen';
$string['respondenttypeanonymous'] = 'anonym';
$string['respondenttypefullname'] = 'vollständiger Name';
$string['respondenttype_help'] = 'Sie können die vollständigen Namen der User zu jeder Antwort anzeigen lassen, wenn Sie diese Option auf "mit Namen" setzen.
Sie können die Identitäten der Nutzer verstecken, wenn Sie diese Option auf "anonym" setzen.';
$string['response'] = 'Antworten';
$string['responsefieldlines'] = 'Größe des Eingabefelds';
$string['responseformat'] = 'Format der Antwort';
$string['responseoptions'] = 'Antwortoptionen';
$string['responses'] = 'Antworten';
$string['responseview'] = 'Alle Antworten den Teilnehmenden anzeigen';
$string['responseview_help'] = 'Sie können festlegen, wer die Antworten aller Befragten auf abgegebene Befragungen sehen darf (allgemeine Auswertungstabelle).';
$string['responseviewstudentsalways'] = 'Immer';
$string['responseviewstudentsnever'] = 'Nie';
$string['responseviewstudentswhenanswered'] = 'Nach dem Aufüllen der Befragung';
$string['responseviewstudentswhenclosed'] = 'Nach dem Ende der Befragung';
$string['restrictedtoteacher'] = 'Diese Funktionen sind nur für Trainer/innen mit Editier-Rechten.';
$string['resume'] = 'Speichern/Fortsetzen';
$string['resume_help'] = 'Wenn diese Option aktiv ist, können Teilnehmer/innen die Antworten der Befragung speichern bevor Sie sie einreichen. Teilnehmer/innen können die Befragung unvollendet verlassen und zu einem späteren Zeitpunkt wieder auf den gespeicherten Zustand zugreifen.';
$string['resumesurvey'] = 'Weitermachen';
$string['return'] = 'Zurück';
$string['save'] = 'Speichern';
$string['saveasnew'] = 'Als neue Frage sichern';
$string['savedbutnotsubmitted'] = 'Die Befragung wurde gespeichert aber noch nicht abgeschickt';
$string['savedprogress'] = 'Ihr Stand wurde gespeichert. Sie können jederzeit zurückkehren um die Befragung zu vervollständigen.';
$string['saveeditedquestion'] = 'Frage {$a} sichern';
$string['savesettings'] = 'Einstellungen sichern';
$string['section'] = 'Beschreibung';
$string['sectionbreak'] = '-----Seitenumbruch-----';
$string['sectionbreak_help'] = '-----Seitenumbruch-----';
$string['sectionsnotset'] = 'Sie müssen mindestens EINE Frage pro Abschnitt auswählen!<br> Nicht ausgewählte Abschnitte: {$a}';
$string['sectiontext'] = 'Beschriftung';
$string['sectiontext_help'] = 'Dies ist keine Frage, sondern ein (kurzer) Text, der zur Einleitung/Erläuterung von Fragen dienen wird.';
$string['selecttheme'] = 'Wählen Sie ein Theme (css) für diese Befragung.';
$string['send'] = 'Senden';
$string['sendemail'] = 'E-Mail versenden';
$string['sendemail_help'] = 'Sendet eine Kopie jeder Einsendung an die angegebene(n) Adresse(n). Sie können mehrere Mail-Adressen durch Kommas getrennt eingeben.
Für kein zusätzliches Mail-Backup lassen Sie dieses Feld leer.';
$string['send_message'] = 'Ausgewählten Teilnehmer/innen eine Nachricht senden';
$string['send_message_to'] = 'Nachricht senden an:';
$string['settings'] = 'Einstellungen';
$string['settingssaved'] = 'Einstellungen gesichert';
$string['show_nonrespondents'] = 'Nicht-Teilnehmende';
$string['started'] = 'gestartet';
$string['strfdate'] = '%d.%m.%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['subject'] = 'Thema';
$string['submitoptions'] = 'Abgabeoptionen';
$string['submitpreview'] = 'Vorschau der Abgabe';
$string['submitpreviewcorrect'] = 'Die Einreichung wurde als korrekt ausgefüllt akzeptiert.';
$string['submitsurvey'] = 'Befragung abgeben';
$string['submitted'] = 'Abgegeben:';
$string['subtitle'] = 'Untertitel';
$string['subtitle_help'] = 'Untertitel dieser Befragung, wird unterhalb des Titels (nur auf der ersten Seite) angezeigt.';
$string['summary'] = 'Zusammenfassung';
$string['surveynotexists'] = 'Die Befragung existiert nicht.';
$string['surveyowner'] = 'Sie müssen Eigentümer der Befragung sein, um diesen Vorgang auszuführen';
$string['surveyresponse'] = 'Antwort von der Befragung';
$string['template'] = 'Vorlage';
$string['templatenotviewable'] = 'Vorlagen-Befragungen stehen nicht zur Ansicht zur Verfügung.';
$string['text'] = 'Fragetext';
$string['textareacolumns'] = 'Textbereich Spalten';
$string['textareacolumns_help'] = 'Diese Frage wird ein Feld für einfachen Text anziegen (textarea, x columns / y rows) als Angaben für Breite und Menge der Textzeilen.
Werden x und y auf 0 belassen (oder auf 0 gesetzt), dann wird der HTML-Editor mit Standard-Höhe/Breite verwendet (falls im aktuellen Kontext der Berechtigungen verfügbar).';
$string['textarearows'] = 'Textbereich Zeilen';
$string['textbox'] = 'Textfeld';
$string['textbox_help'] = 'Für den Fragetyp **Textfeld** können Sie die "Textfeldlänge" und die "Max. Textlänge" angeben.
Standardlängen sind 20 Zeichen für das Textfeld und 25 Zeichen für die maximale Textlänge.';
$string['textdownloadoptions'] = 'Optionen für das Herunterladen (CSV)';
$string['thank_head'] = 'Danke für das Beantworten dieser Befragung.';
$string['theme'] = 'Theme';
$string['thismonth'] = 'dieser Monat';
$string['thisresponse'] = 'Diese Antwort';
$string['thisweek'] = 'diese Woche';
$string['title'] = 'Titel';
$string['title_help'] = 'Titel der Befragung, der oben auf jeder Seite angezeigt wird.
Standardmässig ist dies der Name der Befragung, Sie können dies aber editieren und nach Bedarf ändern.';
$string['today'] = 'heute';
$string['total'] = 'Gesamt';
$string['type'] = 'Typ';
$string['undefinedquestiontype'] = 'Undefinierte Fragetyp';
$string['unknown'] = 'Unbekannt';
$string['unknownaction'] = 'Unbekannte Befragungsaktion angegeben...';
$string['url'] = 'URL';
$string['url_help'] = 'URL, zu welcher ein Nutzer nach Abschluss der Befragung weiter geleitet wird.';
$string['useprivate'] = 'Kopie existiert';
$string['usepublic'] = 'Öffentlich nutzen';
$string['usetemplate'] = 'Vorlage benutzen';
$string['vertical'] = 'Senkrecht';
$string['view'] = 'Anzeigen';
$string['viewallresponses'] = 'Alle Antworten sehen';
$string['viewallresponses_help'] = 'Wenn die Befragung im **Gruppen Modus** auf *Sichtbare Gruppen* oder *Getrennte Gruppen* gesetzt ist und der/die aktuelle Nutzer/in das Recht *moodle/site:accessallgroups* hat (im aktuellen Kontext) und im aktuellen Kurs Gruppen definiert wurden, dann hat der/die Nutzer/in Zugriff auf eine dropdown Liste der Gruppen. Diese dropdown Liste ermöglicht es dem/der Nutzer/in die Antworten der Befragung nach Gruppen zu filtern. Bei der Einstellung **Gruppen Modus**: *Getrennte Gruppen* haben Nutzer/innen, die nicht das Recht *moodle/site:accessallgroups* haben (meist \'students\' oder \'non-editing teachers\', etc.) nur Zugriff auf die Antworten der Gruppe in die sie eingetragen sind.';
$string['viewbyresponse'] = 'Liste der Antworten';
$string['viewindividualresponse'] = 'Individuelle Antworten';
$string['viewindividualresponse_help'] = 'Klicken Sie auf die Namen der Antwortenden unten um ihre individuellen Antworten zu sehen.';
$string['viewresponses'] = 'Alle Antworten: ({$a})';
$string['viewyourresponses'] = 'Ihre Antworten: zeige  {$a}';
$string['warning'] = 'Warnung: Fehler aufgetreten';
$string['wronganswers'] = 'Es ist etwas fehlerhaft bei Ihren Antworten (siehe unten)';
$string['wrongdateformat'] = 'Das eingegebene Datum <strong>{$a}</strong> entspricht nicht dem vorgegebenen Format.';
$string['wrongdaterange'] = 'Fehler: die Jahreszahl muss zwischen 1902 und 2037 liegen.';
$string['wrongformat'] = 'Es ist etwas fehlerhaft bei Ihrer Antwort zu der Frage:  ';
$string['wrongformats'] = 'Es ist etwas fehlerhaft bei Ihrer Antwort zu den Fragen:&nbsp;';
$string['yesno'] = 'Ja/Nein';
$string['yesno_help'] = 'Einfache Ja/Nein-Frage';
$string['yourresponse'] = 'Ihre Antwort';
$string['yourresponses'] = 'Ihre Antworten';
