<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'de', branch 'MOODLE_28_STABLE'
 *
 * @package   reservation
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Buchung hinzufügen';
$string['after10min'] = '10 Minuten nach Beginn';
$string['after12h'] = '12 Stunden nach Beginn';
$string['after1d'] = '1 Tag nach Beginn';
$string['after1h'] = '1 Stunde nach Beginn';
$string['after1w'] = '1 Woche nach Beginn';
$string['after2d'] = '2 Tage nach Beginn';
$string['after2h'] = '2 Stunden nach Beginn';
$string['after2w'] = '2 Wochen nach Beginn';
$string['after30min'] = '30 Minuten nach Beginn';
$string['after3w'] = '3 Wochen nach Beginn';
$string['after4h'] = '4 Stunden nach Beginn';
$string['after4w'] = '4 Wochen nach Beginn';
$string['after5min'] = '5 Minuten nach Beginn';
$string['after6h'] = '6 Stunden nach Beginn';
$string['alreadybooked'] = 'Sie haben bereits gebucht<>';
$string['atstart'] = 'Ab Ereignisstart';
$string['autohide'] = 'Buchungsliste automatisch ausblenden';
$string['availablerequests'] = 'Freie Plätze';
$string['badcourse'] = 'Kurs existiert nicht';
$string['badsection'] = 'Abschnitt existiert nicht im Kurs "{$a}"';
$string['badteachers'] = 'Spezifizierte Trainer E-Mail mit ({$a}) wurde nicht gefunden';
$string['badteachersmail'] = 'Spezifizierte Trainer E-Mail mit ({$a}) ist falsch';
$string['badtimeclose'] = 'Schließzeit ist falsch';
$string['badtimeend'] = 'Endzeit ist falsch';
$string['badtimeopen'] = 'Öffnungszeit ist falsch';
$string['badtimestart'] = 'Startzeit ist falsch';
$string['by'] = 'mit';
$string['bydate'] = 'Veranstaltungsdatum';
$string['byname'] = 'Name';
$string['bysection'] = 'Thema/Woche';
$string['cancelledon'] = 'Abgesagt';
$string['checkclashes'] = 'Ort- und Zeitüberschneidungen prüfen';
$string['clashesfound'] = 'Ort- oder Zeitüberschneidungen gefunden';
$string['clashesreport'] = 'Überschneidungsbericht';
$string['cleanview'] = 'Nur aktuelle Reservierungen anzeigen';
$string['close'] = 'Schließen';
$string['closed'] = 'Geschlossen';
$string['completionreserved'] = 'Sie müssen reservieren, um die Aktion abzuschließen';
$string['config'] = 'Globale Einstellungen für das Modul Reservierung';
$string['configautohide'] = 'Definieren Sie ab wann Reservierungen auf der Buchungsliste (mod/reservation/index.php) ausgeblendet werden sollen. Dies könnte nützlich sein, um bei öffentlichen Listen eine "bereinigte" Aufstellung anzuzeigen.';
$string['configcheckclashes'] = 'Mit dieser Einstellung können Sie den Schalter "Ort- und Zeit Überschneidungen prüfen" auf der Bearbeitungsseite sichtbar machen.';
$string['configconnectto'] = 'Definieren Sie womit die Reservierung verbunden werden soll.';
$string['configdownload'] = 'Definieren Sie das Standard-Downloadformat für alle Listen.';
$string['configevents'] = '';
$string['configfields'] = 'Definieren Sie welche weiteren Felder in der Reservierungstabelle auf der Bearbeitungsseite angezeigt werden sollen.';
$string['configlocations'] = 'Auf dieser Seite können Sie Standardorte für Reservierungen definieren und verwalten.';
$string['configmanualusers'] = '';
$string['configmaxoverbook'] = 'Definieren Sie den maximalen Prozentsatz für Überbuchung.';
$string['configmaxrequests'] = 'Definieren Sie die Obergrenze für Reservierungen im dazugehörigen Drop-Down-Menü auf der Bearbeitungsseite.';
$string['configminduration'] = 'Definieren Sie die Mindestdauer einer Reservierung, für die keine Endzeit festgelegt wurde. Diese Einstellung wird verwendet, um Ort- und Zeitverfügbarkeit zu prüfen.';
$string['confignotifies'] = 'Definieren Sie welche Benachrichtigungen gesendet werden sollen.';
$string['configoverbookstep'] = 'Definieren Sie die prozentuale Schrittweite für Überbuchung.';
$string['configpubliclists'] = 'Definieren Sie ob Buchungslisten veröffentlicht werden sollen. Das ermöglicht Einsichtnahme ohne Anmeldung!';
$string['configsortby'] = 'Definieren Sie wonach die Buchungslisten sortiert werden sollen.';
$string['configsublimits'] = 'Definieren Sie die Anzahl der Limitierungsregeln (Zeilen) auf der Bearbeitungsseite.';
$string['confirmdelete'] = 'Sind Sie sicher, dass Sie die ausgewählten Reservierungsanfragen löschen wollen?';
$string['connectedto'] = 'Verbunden mit';
$string['connectto'] = 'Verbinden der Reservierung mit';
$string['description'] = 'Beschreibung';
$string['downloadas'] = 'Standard Downloadformat';
$string['duration10h'] = '10 Stunden';
$string['duration10min'] = '10 Minuten';
$string['duration11h'] = '11 Stunden';
$string['duration12h'] = '12 Stunden';
$string['duration15min'] = '15 Minuten';
$string['duration20min'] = '20 Minuten';
$string['duration2h'] = '2 Stunden';
$string['duration30min'] = '30 Minuten';
$string['duration3h'] = '3 Stunden';
$string['duration45min'] = '45 Minuten';
$string['duration4h'] = '4 Stunden';
$string['duration5h'] = '5 Stunden';
$string['duration5min'] = '5 Minuten';
$string['duration60min'] = '60 Minuten';
$string['duration6h'] = '6 Stunden';
$string['duration7h'] = '7 Stunden';
$string['duration8h'] = '8 Stunden';
$string['duration90min'] = '90 Minuten';
$string['duration9h'] = '9 Stunden';
$string['enablenote'] = 'Benutzeranmerkung zulassen';
$string['equal'] = 'gleich';
$string['err_sublimitsgreater'] = 'Die Summe der Limitierungen übersteigt die Obergrenze für Reservierungen.';
$string['err_timeendlower'] = 'Der Endtermin liegt vor dem Starttermin';
$string['err_timeopengreater'] = 'Der Starttermin liegt nach dem Endtermin';
$string['eventevent'] = 'Veranstaltungszeitraum (Dauer der Veranstaltung)';
$string['eventrequestadded'] = 'Reservierung hinzugefügt';
$string['eventrequestcancelled'] = 'Reservierung storniert';
$string['eventrequestdeleted'] = 'Reservierung gelöscht';
$string['events'] = 'Kalendereinträge';
$string['eventsettings'] = 'Allgemeine Einstellungen';
$string['explainconfig'] = 'Administratoren können hier globale Einstellungen für das Reservierungsmodul definieren.';
$string['fields'] = 'anzeigbare Felder';
$string['fullview'] = 'Zeige gelöschte Reservierungen';
$string['gradedmail'] = '{$a->teacher} hat ein Feedback zu Ihrer Reservierung geschrieben \'{$a->reservation}\' Sie können es hier einsehen: {$a->url}';
$string['gradedmailhtml'] = '{$a->teacher} hat ein Feedback zu Ihrer Reservierung geschrieben \'<i>{$a->reservation}</i>\'<br /><br /> Sehen Sie <a href="{$a->url}">hier</a>.';
$string['importreservations'] = 'Reservierungen importieren';
$string['justbooked'] = 'Sie haben gebucht als: {$a}';
$string['linenumber'] = '#';
$string['location'] = 'Ort';
$string['locations'] = 'Orte verwalten';
$string['locationslist'] = 'Orte auflisten';
$string['mail'] = 'Reservierung \'{$a->reservation}\' wurde geschlossen.

Sie können Ihre Reservierungsliste herunterladen von:

    {$a->url}';
$string['mailhtml'] = 'Reservierung <em>{$a->reservation}</em> wurde geschlossen.<br/><br/>
Sie können Ihre Reservierungsliste <a href="{$a->url}">hier</a> herunterladen.';
$string['mailrequest'] = 'Reservierung \'{$a->reservation}\' wurde geschlossen.

Sie erhalten Ihre Reservierungsnummer unter:

    {$a->url}';
$string['mailrequesthtml'] = 'Reservierung <em>{$a->reservation}</em> wurde geschlossen. <br/>
Sie können Ihre Reservierungsnummer <a href="{$a->url}">hier</a> abrufen.';
$string['manage'] = 'Verwaltung';
$string['manualusers'] = '';
$string['maxoverbook'] = 'Obergrenze für Überbuchung in Prozent';
$string['maxrequest'] = 'Obergrenze für Reservierungen';
$string['message'] = 'Nachricht an die Teilnehmer';
$string['minduration'] = 'Mindestdauer';
$string['modulename'] = 'Reservierung';
$string['modulename_help'] = '<p>Das Hauptziel dieser Aktivität ist die Planung von Laborveranstaltungen und Prüfungen, Sie können aber auch alle anderen Dinge planen.</p><p>Trainer können die Anzahl der verfügbaren Plätze für die Veranstaltung, das Datum des Ereignisses, sowie die Verfügbarkeit der Reservierung festlegen.<br/>Eine Reservierung kann Noten oder Punkte haben.<br/>Die Lernenden können einen Platz buchen und eine Notiz für diese Reservierung hinzufügen.</p><p>Nach beginnt die Veranstaltung kann der Trainer diese  Bewerten. Die Lernenden werden per Mail benachrichtigt.</p><p>Buchungslisten können in verschiedenen Formaten heruntergeladen werden.</p>';
$string['modulenameplural'] = 'Reservierungen';
$string['newlocation'] = 'Neuer Ort';
$string['noclashes'] = 'Keine Ort- und Zeitüberschneidungen gefunden';
$string['nocourseswithnsections'] = 'Kein Kurs mit {$a} Abschnitten';
$string['nolimit'] = 'Keine Obergrenze für Reservierung';
$string['nomorerequest'] = 'Keine Plätze mehr vorhanden';
$string['nooverbook'] = 'Keine Überbuchung';
$string['noparent'] = 'Keine';
$string['noreservations'] = 'Keine Reservierungen anzeigbar';
$string['note'] = 'Anmerkung zur Buchung';
$string['noteachers'] = 'Keine Trainer verfügbar';
$string['notequal'] = 'ungleich';
$string['notifies'] = 'Benachrichtigung senden';
$string['notifygrades'] = 'Reservierung bewertet, Benachrichtigung an Lernenden';
$string['notifystudents'] = 'Reservierung geschlossen, Benachrichtigung an Lernenden';
$string['notifyteachers'] = 'Reservierung geschlossen, Benachrichtigung an Trainer';
$string['notopened'] = 'Nicht geöffnet';
$string['novalues'] = 'Keine verfügbaren Werte für dieses Feld';
$string['number'] = 'Reservierungsnummer';
$string['otherlocation'] = 'Anderen Ort bestimmen';
$string['overbook'] = 'Überbuchung';
$string['overbookonly'] = 'Nur noch überbuchte Plätze frei';
$string['overbookstep'] = 'Überbuchen (Schrittweite)';
$string['overview'] = 'Überblick';
$string['parent'] = 'Reservierung verbinden mit';
$string['pluginadministration'] = 'Reservierung Administration';
$string['pluginname'] = 'Reservierung';
$string['publiclists'] = 'Buchungslisten veröffentlichen';
$string['requestoverview'] = 'Buchungsübersicht';
$string['requests'] = 'Buchungen';
$string['reservation:addinstance'] = 'Neue Reservierung hinzufügen';
$string['reservationcancelled'] = 'Reservierung storniert';
$string['reservationclosed'] = 'Reservierung geschlossen';
$string['reservationdenied'] = 'Reservierung nicht zugelassen';
$string['reservation:downloadrequests'] = 'Buchungsliste herunterladen';
$string['reservationevent'] = 'Definieren Sie einen offenen Zeitraum von Tagen (Reservierungszeit)';
$string['reservation:grade'] = 'Bewertung hinzufügen';
$string['reservation_listing'] = 'Einstellungen für Seitenindex';
$string['reservation:manualdelete'] = 'Anträge anderer Benutzer löschen';
$string['reservation:manualreserve'] = 'Anträge für anderer Benutzer einreichen';
$string['reservationnotopened'] = 'Reservierung noch nicht geöffnet';
$string['reservation_other'] = 'Weitere Einstellungen';
$string['reservation:reserve'] = 'Eigene Anträge einreichen';
$string['reservations'] = 'Reservierungen';
$string['reservationsettings'] = 'Einstellungen für Reservierung';
$string['reservation_settings'] = 'Einstellungen bearbeiten';
$string['reservation:uploadreservations'] = 'Reservierungen hochladen';
$string['reservation_view'] = 'Einstellungen für Seitenansicht';
$string['reservation:viewnote'] = 'Hinweis zur Buchungsliste einsehen';
$string['reservation:viewrequest'] = 'Die Buchungsliste einsehen';
$string['reserve'] = 'Reservieren';
$string['reservecancel'] = 'Reservierung stornieren';
$string['reserved'] = 'Reserviert';
$string['reservedon'] = 'Reserviert am';
$string['reservedonconnected'] = 'Sie haben die ausgewählte Veranstaltung bereits gebucht:{$a}';
$string['resetreservation'] = 'Alle Reservierungen löschen';
$string['save'] = 'Bewertung speichern';
$string['selectvalue'] = 'Wählen Sie einen der verfügbaren Werte';
$string['showrequest'] = 'Buchungsliste anzeigen';
$string['sortby'] = 'Buchungsliste sortiert nach';
$string['sublimit'] = 'Limit {$a}';
$string['sublimitrules'] = 'Regeln für Limitierung';
$string['sublimits'] = 'Limitierung';
$string['timeclose'] = 'Buchungsvorgang endet am';
$string['timeend'] = 'Enddatum';
$string['timeopen'] = 'Buchungsvorgang beginnt am';
$string['timestart'] = 'Startdatum';
$string['upload'] = 'Reservierungen hochladen';
$string['upload_help'] = '<p>Reservierung können per Text-Datei hochgeladen werden. Das Format der Datei sollte wie folgt aussehen:</p><ul><li> Jede Zeile der Datei enthält einen Datensatz</li><li>Jeder Datensatz ist eine Reihe von Daten, die durch Kommas (oder andere Trennzeichen) getrennt sind</li><li>Der erste Datensatz enthält eine Liste von Feldnamen, die das Format vom Rest der Datei definieren</li><li> Pflichtfelder sind Abschnitt, Name und Startzeit</li><li>Optionale Feldnamen sind Kurs, Einführung, Trainer, Endzeit, Höchstnote, Öffnungszeit, Schließzeit, max. Anfragen</li><li>Wenn nichts angegeben wird, muss nach Vorschau</li></ul>ausgewählt werden.';
$string['uploadreservations'] = 'Reservierungen hochladen';
$string['uploadreservationspreview'] = 'Vorschau für hochzuladende Reservierungen anzeigen';
$string['uploadreservationsresult'] = 'Ergebnis der hochgeladenen Reservierungen anzeigen';
$string['with'] = 'mit';
$string['withselected'] = 'Mit Auswahl...';
$string['yourgrade'] = 'Ihre Bewertung zu dieser Reservierung: {$a->grade}/${a->maxgrade}';
$string['yourscale'] = 'Ihre Bewertung zu dieser Reservierung: {$a}';
