<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'pt_br', branch 'MOODLE_28_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Você já está autenticado como {$a}. Você precisa sair para então acessar como outro usuário.';
$string['authnotexisting'] = 'Esse módulo de autorização não existe.';
$string['backupcontainexternal'] = 'Este arquivo referencia Servidores da Rede Moodle externos que não estão configurados localmente';
$string['backuptablefail'] = 'As tabelas de arquivamento NÃO pôde ser configurado adequadamente!';
$string['blockcannotconfig'] = 'Este bloco não permite configuração global';
$string['blockcannotinistantiate'] = 'Problema para instanciar objeto de bloco';
$string['blockcannotread'] = 'Não foi possível ler dados de blockid={$a}';
$string['blockdoesnotexist'] = 'Este  bloco não existe';
$string['blockdoesnotexistonpage'] = 'Este bloco (id={$a->instanced}) não existe nesta página ($a->url).';
$string['blocknameconflict'] = 'Conflito de nomes: o bloco {$a->name} tem o mesmo título que um bloco existente: {$a->conflict}!';
$string['callbackrejectcomment'] = 'O módulo rejeita acrescentar este comentário';
$string['cannotaddcoursemodule'] = 'Não foi adicionado um novo módulo de curso';
$string['cannotaddcoursemoduletosection'] = 'Não foi adicionado o novo módulo de curso nesta seção';
$string['cannotaddmodule'] = 'O módulo {$a} não pode ser acrescentado à lista de módulos!';
$string['cannotaddnewmodule'] = 'Não foi adicionado um novo módulo de {$a}';
$string['cannotaddrss'] = 'Você não tem autorização para acrescentar alimentadoresde notícias RSS';
$string['cannotaddthisblocktype'] = 'Você não pode adicionar um bloco {$a} nesta página';
$string['cannotassignrole'] = 'Impossível designar papéis no curso';
$string['cannotassignrolehere'] = 'Você não tem permissão para atribuir este papel (id = {$a->roleid}) neste contexto ({$a->context}).';
$string['cannotassignselfasparent'] = 'Não pode se autodesignar como pai!';
$string['cannotcallscript'] = 'Este "script" não pode invocado desta forma';
$string['cannotcallusgetselecteduser'] = 'user_selector::get_selected_user não pode ser chamado se multi select for verdadeiro.';
$string['cannotcreatebackupdir'] = 'Não foi possível criar a pasta backupdata. O admnistrador da plataforma tem que mudar as permissões de arquivos.';
$string['cannotcreatecategory'] = 'A categoria não foi inserida';
$string['cannotcreatedboninstall'] = '<p> Não é possível criar o banco de dados. </p>
<p> O banco de dados especificado não existe e o determinado usuário não tem permissão para criar o banco de dados. </p>
<p> O administrador do site deve verificar a configuração do banco de dados. </p>';
$string['cannotcreategroup'] = 'Erro ao criar grupo';
$string['cannotcreatelangbase'] = 'Erro: Não foi possível criar o diretório base lang';
$string['cannotcreatelangdir'] = 'Impossível criar diretório lang';
$string['cannotcreateorfindstructs'] = 'Erro ao criar ou buscar estruturas de seção para este curso';
$string['cannotcreatepopupwin'] = 'Elemento indefinido. Não é possível criar uma nova janela';
$string['cannotcreatesitedir'] = 'Não é possível criar uma pasta global. O administrador da plataforma tem que mudar as permissões de arquivos.';
$string['cannotcreatetempdir'] = 'Impossível criar diretório temp';
$string['cannotcreateuploaddir'] = 'Não é possível criar uma pasta para envio de arquivos. O administrador da plataforma tem que mudar as permissões de arquivos.';
$string['cannotcustomisefiltersblockuser'] = 'Você não pode personalizar a configuração dos filtros nos contextos de usuários ou blocos';
$string['cannotdeletebackupids'] = 'Não foi possível apagar as ids dos arquivamentos anteriores';
$string['cannotdeletecategorycourse'] = 'Falha ao excluir curso \'{$a}\'.';
$string['cannotdeletecategoryquestions'] = 'Não foi possível excluir questões da categoria \'{$a}\'';
$string['cannotdeletecourse'] = 'Você não tem permissões para excluir este curso';
$string['cannotdeletecustomfield'] = 'Erro apagando dados de campo personalizado';
$string['cannotdeletedir'] = 'Não foi possível excluir ({$a})';
$string['cannotdeletefile'] = 'Não foi possível excluir este arquivo';
$string['cannotdeleterole'] = 'Não pode ser apagado porque {$a}';
$string['cannotdeleterolewithid'] = 'Não pode apagar o papel com ID: {$a}';
$string['cannotdeletethisrole'] = 'Você não pode excluir esse papel porque ele é usado pelo sistema, ou porque é o último papel com permissões de administrador.';
$string['cannotdisableformat'] = 'Você não pode desativar o formato padrão';
$string['cannotdownloadcomponents'] = 'Impossível fazer download dos componentes';
$string['cannotdownloadlanguageupdatelist'] = 'Impossível baixar lista de atualizações de idioma de download.moodle.org';
$string['cannotdownloadzipfile'] = 'Impossível fazer download do arquivo ZIP';
$string['cannoteditcomment'] = 'Este comentário não lhe pertence para editar!';
$string['cannoteditcommentexpired'] = 'O tempo para permitir editar acabou!';
$string['cannoteditpostorblog'] = 'Você não pode enviar mensagens ou editar nos blogs';
$string['cannoteditsiteform'] = 'Você não pode editar o portal deste curso usando este formulário';
$string['cannotedityourprofile'] = 'Desculpe, você não pode editar o próprio perfil';
$string['cannotexecduringupgrade'] = 'Não pode ser executado durante a atualização';
$string['cannotfindcategory'] = 'Não é possível encontrar o registro da categoria no banco de dados pelo ID - {$a}';
$string['cannotfindcomponent'] = 'Impossível achar componente';
$string['cannotfindcontext'] = 'Não foi possível achar o contexto';
$string['cannotfindcourse'] = 'Não é possível encontrar o curso';
$string['cannotfinddocs'] = 'Não foram encontrados os arquivos de documentação do idioma "{$a}"';
$string['cannotfindgradeitem'] = 'Não foi possível encontrar o elemento de nota grade_item';
$string['cannotfindgroup'] = 'Grupo não encontrado';
$string['cannotfindhelp'] = 'Não foram encontrados os arquivos de ajuda do idioma "{$a}"';
$string['cannotfindinfo'] = 'Não foi encontrada informação para: "{$a}"';
$string['cannotfindlang'] = 'Não foi encontrado o pacote da linguagem "{$a}"!';
$string['cannotfindteacher'] = 'Não é possível encontrar professor';
$string['cannotfinduser'] = 'Não é possível encontrar o usuário de nome "{$a}"';
$string['cannotgeoplugin'] = 'Não foi possível conectar com o servidor geoPlugin em http://www.geoplugin.com, por favor verifique as configurações de proxy ou instale o arquivo de dados do MaxMind GeoLite City';
$string['cannotgetblock'] = 'Não foi possível obter blocos do banco de dados';
$string['cannotgetcats'] = 'Não é possível obter registro de categoria';
$string['cannotgetdata'] = 'Não foi possível obter dados';
$string['cannotgradeuser'] = 'Não é possível avaliar este usuário';
$string['cannothaveparentcate'] = 'Esta categoria de cursos não pode ter pai!';
$string['cannotimport'] = 'Erro de importação';
$string['cannotimportformat'] = 'Desculpe, a importação deste formato ainda não está implementada!';
$string['cannotimportgrade'] = 'Erro na importação de notas';
$string['cannotinsertgrade'] = 'Não é possível inserir item de nota sem id do curso!';
$string['cannotinsertrate'] = 'Não foi possível inserir uma nova avaliação ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Impossível inserir novo record ID {$a}';
$string['cannotmailconfirm'] = 'Erro ao enviar e-mail de confirmação de mudança de senha';
$string['cannotmanualctrack'] = 'A atividade não permite o acompanhamento manual de conclusão de tarefas';
$string['cannotmapfield'] = 'Foi detectada colisão de mapeamento. Dois campos correspondem ao mesmo item de nota {$a}';
$string['cannotmarktopic'] = 'Não foi possível atribuir nota a este tópico neste curso';
$string['cannotmigratedatacomments'] = 'Não é possível migrar comentários do módulos de dados';
$string['cannotmodulename'] = 'Não foi possível obter o nome do módulo na construção da navegação';
$string['cannotmoduletype'] = 'Não foi possível obter o tipo do módulo na construção da navegação';
$string['cannotmovecategory'] = 'Não é possível mover categoria';
$string['cannotmovecourses'] = 'Não é possível mover os cursos da categoria que estão em outro.';
$string['cannotmoverolewithid'] = 'Impossível mover papel com ID {$a}';
$string['cannotopencsv'] = 'Não é possível abrir o arquivo CSV';
$string['cannotopenfile'] = 'Não é possível abrir o arquivo ({$a})';
$string['cannotopenforwrit'] = 'Não é possível abrir para escrita: {$a}';
$string['cannotopentemplate'] = 'Não é possível abir o arquivo de referência (template) {$a}';
$string['cannotopenzip'] = 'Não é possível abrir o arquivo zipado. Provavelmente problema com a extensão do arquivo ou sistema operacional de 64 bits';
$string['cannotoverridebaserole'] = 'Não é possível ignorar as permissões do papel básico';
$string['cannotoverriderolehere'] = 'Você não tem permissão para sobrescrever este papel (id ={$a->roleid}) neste contexto ({$a->context})';
$string['cannotreadfile'] = 'Não é possível ler o arquivo ({$a})';
$string['cannotreadtmpfile'] = 'Erro ao ler o arquivo temporário';
$string['cannotreaduploadfile'] = 'Não foi possível ler o arquivo enviado';
$string['cannotremovefrommeta'] = 'Não foi possível apagar o curso selecionado deste metacurso!';
$string['cannotresetguestpwd'] = 'Você não pode redefinir a senha do convidado';
$string['cannotresetmail'] = 'Erro ao mudar a senha e envia-la para você';
$string['cannotresetthisrole'] = 'Não é possível reconfigurar este papel';
$string['cannotrestore'] = 'Ocorreu um erro e a restauração não pôde ser concluída!';
$string['cannotrestoreadminorcreator'] = 'Você tem que ser criador de cursos ou administrador para restaurar num novo curso!';
$string['cannotrestoreadminoredit'] = 'Você precisa ser professor com poder de edição ou administrador para restaurar no curso selecionado!';
$string['cannotsaveagreement'] = 'Não foi possível gravar sua concordância';
$string['cannotsaveblock'] = 'Erro ao gravar a configuração do bloco';
$string['cannotsavecomment'] = 'Não foi possível gravar o comentário';
$string['cannotsavedata'] = 'Não foi possível gravar os dados';
$string['cannotsavefile'] = 'Não é possível gravar o arquivo "{$a}"!';
$string['cannotsavemd5file'] = 'Impossível salvar arquivo md5';
$string['cannotsavezipfile'] = 'Impossível salvar arquivo ZIP';
$string['cannotservefile'] = 'Não foi possível o acesso a esse arquivo. Problema na configuração do serivdor.';
$string['cannotsetparentforcatoritem'] = 'Não é possível definir o pai para a categoria ou item do curso!';
$string['cannotsetpassword'] = 'Não foi possível definir senha de usuário!';
$string['cannotsetprefgrade'] = 'Não foi possível definir a preferência aggregationview a {$a} para esta categoria de notas';
$string['cannotsettheme'] = 'Não foi possível definir o tema!';
$string['cannotsetupblock'] = 'NÃO foi possível definir as tabelas do bloco!';
$string['cannotsetupcapformod'] = 'Não foi possível definir as permissões para {$a}';
$string['cannotsetupcapforplugin'] = 'Não foi possível definir as permissões para {$a}';
$string['cannotshowhidecoursesincategory'] = 'Não é possível ocultar/mostrar os cursos nesta categoria, {$a}.';
$string['cannotsignup'] = 'Você não pode criar uma nova conta, porque você já está conectado como {$a}.';
$string['cannotunassigncap'] = 'Não foi possível retirar a permissão obsoleta {$a->cap} do papel {$a->role}';
$string['cannotunassignrolefrom'] = 'Não foi possível retirar este usuário do papel com id: {$a}';
$string['cannotunzipfile'] = 'Impossível descompactar arquivo ZIP';
$string['cannotupdatemod'] = 'Não foi possível atualizar {$a}';
$string['cannotupdatepasswordonextauth'] = 'Não foi possível atualizar a senha no módulo de autenticação externo: {$a}. Ver os registros do servidor para mais detalhes.';
$string['cannotupdateprofile'] = 'Erro ao atualizar registro de usuário';
$string['cannotupdaterecord'] = 'Impossível atualizar record ID {$a}';
$string['cannotupdaterss'] = 'Não foi possível atualizar o RSS';
$string['cannotupdatesubcourse'] = 'Não foi possível atualizar um curso filho!';
$string['cannotupdateusermsgpref'] = 'Não é possível atualizar as preferências mensagem de usuário';
$string['cannotupdateuseronexauth'] = 'Não foi possível atualizar os dados do usuário no módulo de autenticação externo: {$a}. Veja os registros do servidor para mais detalhes.';
$string['cannotuploadfile'] = 'Erro ao processar o arquivo enviado';
$string['cannotuseadmin'] = 'Você precisa ser um administrador para utilizar esta página';
$string['cannotuseadminadminorteacher'] = 'Você precisa ser um professor ou um administrador para utilizar esta página';
$string['cannotusepage'] = 'Só professores e administradores podem usar esta página';
$string['cannotusepage2'] = 'Desculpe, você não pode usar esta página';
$string['cannotviewprofile'] = 'Não foi possível ver o perfil desse usuário.';
$string['cannotviewreport'] = 'Você não pode ver este relatório';
$string['cannotwritefile'] = 'Não é possível escrever no arquivo ({$a})';
$string['categoryerror'] = 'Erro de categoria';
$string['categoryidnumbertaken'] = 'Número de identificação já é usado para outra categoria';
$string['categorynamerequired'] = 'Nome da categoria é necessário';
$string['categorytoolong'] = 'Nome da categoria muito longo';
$string['commentmisconf'] = 'O ID do comentário está mal configurado';
$string['componentisuptodate'] = 'Componente está atualizado';
$string['confirmsesskeybad'] = 'Sinto muito mas não foi possível confirmar a chave da sua sessão para completar esta ação. Esta medida de segurança evita a execução de funções importantes em seu nome, causadas por terceiros maliciosos ou por erros acidentais. Certifique-se que a execução desta função seja realmente intencional.';
$string['couldnotassignrole'] = 'Um erro sério mas não especificado ocorreu ao tentar atribuir um papel para você';
$string['couldnotupdatenoexistinguser'] = 'Não foi possível atualizou o usuário - usuário não existe';
$string['countriesphpempty'] = 'O arquivo countries.php é ausente ou vazio no idioma {$a}';
$string['coursedoesnotbelongtocategory'] = 'O curso não pertence a esta categoria';
$string['courseformatnotfound'] = 'Formato de curso \'{$a}\' não existe ou não foi reconhecido';
$string['coursegroupunknown'] = 'O curso correspondente ao grupo {$a} não foi definido';
$string['courseidnotfound'] = 'Id do curso não existe';
$string['courseidnumbertaken'] = 'Número ID já está sendo usado para outro curso ({$a})';
$string['coursemisconf'] = 'O curso está mal configurado';
$string['courserequestdisabled'] = 'Desculpe, mas a solicitação de cursos está desabilitada pelo administador';
$string['csvcolumnduplicates'] = 'Colunas duplicadas foram encontradas.';
$string['csvemptyfile'] = 'O arquivo CSV está vazio.';
$string['csvfewcolumns'] = 'Não há colunas suficientes, verifique a configuração do delimitador.';
$string['csvinvalidcols'] = '<b>Arquivo CSV inválido:</b> A primeira linha deve incluir os "Cabeçalhos dos Campos"  e o arquivo tem que ser do tipo <br /> "Campos Expandidos/Separados por Vírgulas"<br /> ou <br /> "Campos Expandidos com Código de Resultados CAVV/Separados por Vírgulas"';
$string['csvinvalidcolsnum'] = 'Arquivo CSV inválido - cada linha deve incluir 49 ou 70 campos';
$string['csvloaderror'] = 'Ocorreu um erro durante o carregamento do arquivo CSV: {$a}';
$string['csvweirdcolumns'] = 'O formato do arquivo CSV é inválido - o número de colunas não é constante!';
$string['dbconnectionfailed'] = '<p>Erro: Conexão com o banco de dados falhou</p>
<p>É possível que o banco de dados esteja sobrecarregado ou não está funcionando adequadamente</p>
<p>O administrador do site também deve verificar se os dados do banco de dados foram corretamente especificados no config.php</p>';
$string['dbdriverproblem'] = '<p>Erro: Foi detectado um problema no driver do banco de dados</p>
<p>O administrador do site deve verificar as configurações do servidor</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Foram detectados sérios problemas na sessão de banco de dados. <br /><br />Favor notificar o administrador da máquina.';
$string['dbsessionhandlerproblem'] = 'Falha ao estabelecer sessão do banco de dados. Por favor, comunique ao administrador do servidor.';
$string['dbsessionmysqlpacketsize'] = 'Foram detectados sérios problemas de sessão. <br /> <br />Favor notificar o administrador. A causa mais provável deste problema é um valor baixo para max_allowed_packet na configuração do MySQL.';
$string['dbupdatefailed'] = 'A atualização do banco de dados falhou.';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" não pode ser modificado. Há uma dependencia com {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Erro de execução DDL SQL';
$string['ddlfieldalreadyexists'] = 'Campo "{$a}" já existe';
$string['ddlfieldnotexist'] = 'Campo "{$a->fieldname}" não existe na tabela "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabela "{$a}" já existe';
$string['ddltablenotexist'] = 'Tabela "{$a}" não existe';
$string['ddlunknownerror'] = 'Erro desconecido na biblioteca DDL';
$string['ddlxmlfileerror'] = 'Foram encontrados erros no arquivo XML do banco de dados';
$string['ddsequenceerror'] = 'Definição incorreta da tabela "{$a}". Só pode ter uma coluna "auto" e ela deve ser definida como chave.';
$string['destinationcmnotexit'] = 'O módulo de curso de destino nao existe';
$string['detectedbrokenplugin'] = 'Plugin "{$a}" está com defeito ou desatualizado, impossível continuar, me desculpe.';
$string['dmlexceptiononinstall'] = '<p> Ocorreu um erro no banco de dados [{$a->errorcode}].<br />{$a->debuginfo} </p>';
$string['dmlreadexception'] = 'Erro ao ler a base de dados';
$string['dmltransactionexception'] = 'Erro de transação da base de dados';
$string['dmlwriteexception'] = 'Erro ao gravar na base de dados';
$string['downgradedcore'] = 'ERRO! O código que você está utilizando é ANTERIOR ao da versão deste banco de dados!';
$string['downloadedfilecheckfailed'] = 'A verificação do arquivo baixado falhou';
$string['duplicatefieldname'] = 'Nome de campo duplicado "{$a}" identificado';
$string['duplicatenosupport'] = 'A atividade \'{$a->modname}\' não poderia ser duplicada porque o módulo {$a->modtype} não suporta backup e restauração.';
$string['duplicateparaminsql'] = 'ERRO: nome do parâmetro duplicado na consulta';
$string['duplicaterolename'] = 'Já há um papel com esse nome!';
$string['duplicateroleshortname'] = 'Já há um papel com esse nome curto!
';
$string['duplicateusername'] = 'Identificação de usuário duplicado - ignorando registro';
$string['emailfail'] = 'O envio de email falhou';
$string['error'] = 'Ocorreu um erro';
$string['errorcleaningdirectory'] = 'Erro limpando o diretório "{$a}"';
$string['errorcopyingfiles'] = 'Erro copiando arquivos';
$string['errorcreatingdirectory'] = 'Erro criando o diretório "{$a}"';
$string['errorcreatingfile'] = 'Erro criando o arquivo "{$a}"';
$string['errorcreatingrole'] = 'Erro na criação do papel';
$string['errorfetchingrssfeed'] = 'Erro no contato com o alimentador de notícias RSS';
$string['erroronline'] = 'Erro na linha {$a}';
$string['errorparsingxml'] = 'Erro de XML: {$a->errorstring} na linha {$a->errorline}, char {$a->errorchar}';
$string['errorprocessingarchive'] = 'Erro ao processar o arquivo';
$string['errorreadingfile'] = 'Erro na leitura do arquivo "{$a}"';
$string['errorsavingrequest'] = 'Ocorreu um erro ao salvar o pedido.';
$string['errorsettinguserpref'] = 'Erro ao configurar as preferências de usuário';
$string['errorunzippingfiles'] = 'Erro ao descompactar arquivos';
$string['expiredkey'] = 'Chave expirada';
$string['externalauthpassworderror'] = 'Senha não vazia para autenticação externa';
$string['externalfilenolocation'] = 'Arquivo externo não possui caminho de localização';
$string['failtoloadblocks'] = 'Há um ou mais blocos registrados no banco de dados, mas não foi possível carregar nenhum deles!';
$string['fieldrequired'] = '"{$a}" é um campo obrigatório';
$string['fileexists'] = 'O arquivo já existe';
$string['filemismatch'] = 'Os nomes dos arquivos não conferem. O arquivo "{$a->current}" deveria ser {$a->file}
';
$string['filenotfound'] = 'Sinto muito, o arquivo não foi encontrado';
$string['filenotreadable'] = 'Arquivo não é legível';
$string['filterdoesnothavelocalconfig'] = 'O filtro {$a} não permite configuração local.';
$string['filternotactive'] = 'O filtro {$a} está desativado';
$string['filternotenabled'] = 'Filtro não ativado!';
$string['filternotinstalled'] = 'Filtro {$a} não está instalado';
$string['forumblockingtoomanyposts'] = 'Você ultrapassou o limite de mensagens permitido neste fórum.';
$string['generalexceptionmessage'] = 'Exceção - {$a}';
$string['gradecantregrade'] = 'Ocorreu um erro durante o cálculo do grau: {$a}';
$string['gradepubdisable'] = 'A publicação de notas está desativada';
$string['groupalready'] = 'O usuário já participa do grupo {$a}';
$string['groupexistforcourse'] = 'O grupo "{$a}" já existe nesse curso';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Grupo "{$a->name}" com id "{$a->idnumber}" já existe neste curso';
$string['grouphasidnumber'] = 'Grupo "{$a}" possui um número id e pode ter sido criado por um sistema externo. Você não tem permissão para remover este grupo.';
$string['groupinghasidnumber'] = 'Agrupamento "{$a}" possui um número id e pode ter sido criado por um sistema externo. Você não tem permissão para remover este grupo.';
$string['groupingnotaddederror'] = 'Agrupamento &quot;{$a}&quot; não adicionado';
$string['groupnotaddederror'] = 'O grupo "{$a}" não foi adicionado';
$string['groupnotaddedtogroupingerror'] = 'Group "{$a->groupname}" não adicionado ao agrupamento "{$a->groupingname}"';
$string['groupunknown'] = 'O grupo {$a} não é associado ao curso especificado';
$string['groupusernotmember'] = 'O usuário não é participante deste grupo';
$string['guestcantaccessprofiles'] = 'Visitantes não podem acessar os perfis de usuário. Acesse com uma conta completa de usuário para continuar.';
$string['guestnocomment'] = 'Os convidados não podem enviar comentários';
$string['guestnoeditprofile'] = 'O usuário visitante não pode modificar o seu perfil';
$string['guestnoeditprofileother'] = 'O perfil do usuário visitante não pode ser modificado';
$string['guestnorate'] = 'Os convidados não podem avaliar mensagens';
$string['guestsarenotallowed'] = 'O usuário visitante não tem permissão para fazer isto';
$string['hackdetected'] = 'Detectado um ataque de Hackers!';
$string['hashpoolproblem'] = 'Conteúdo do arquivo {$a} incorreto.';
$string['headersent'] = 'Cabeçalhos já foram enviados';
$string['idnumbertaken'] = 'Número ID já é usado em outro curso';
$string['idnumbertoolong'] = 'Número ID muito longo';
$string['importformatnotimplement'] = 'Desculpe, a importação deste formato ainda não foi implementada!';
$string['incorrectext'] = 'Este arquivo tem uma extensão errada';
$string['installproblem'] = 'Normalmente não é possível se recuperar de erros ocorridos durante a instalação, você pode precisar criar uma nova base de dados ou usar um novo prefixo para os nome das tabelas se quiser prosseguir com a instalação.';
$string['internalauthpassworderror'] = 'Falta senha ou política de senha inválida para autenticação interna';
$string['invalidaccess'] = 'Esta página não foi acessada corretamente';
$string['invalidaccessparameter'] = 'Parâmetro de acesso inválido';
$string['invalidaction'] = 'Parâmetro de ação inválido';
$string['invalidactivityid'] = 'ID de atividade inválido';
$string['invalidadminsettingname'] = 'Configuração inválida ({$a})';
$string['invalidargorconf'] = 'Nenhum argumentos válidos fornecidos ou configuração incorreta do servidor';
$string['invalidarguments'] = 'Nenhum argumentos válidos fornecidos';
$string['invalidblockinstance'] = 'Instância de bloco inválida para: {$a}';
$string['invalidbulkenrolop'] = 'Operação inválida de inscrição de usuários em lote requisitada.';
$string['invalidcategory'] = 'Categoria incorreta!';
$string['invalidcategoryid'] = 'Id de categoria incorreta!';
$string['invalidcomment'] = 'Comentário está incorreto';
$string['invalidcommentarea'] = 'Área de comentário inválida';
$string['invalidcommentid'] = 'id de comentário inválido';
$string['invalidcommentitemid'] = 'itemid de comentário inválido';
$string['invalidcommentparam'] = 'Parâmetros de comentário inválido';
$string['invalidcomponent'] = 'Nome de componente inválido';
$string['invalidconfirmdata'] = 'Confirmação de dados inválidos';
$string['invalidcontext'] = 'Contexto não válido';
$string['invalidcourse'] = 'Curso não válido';
$string['invalidcourseid'] = 'Você está tentando usar um ID de curso inválido';
$string['invalidcourselevel'] = 'Nível de contexto incorreto';
$string['invalidcoursemodule'] = 'ID de módulo de curso não válido';
$string['invalidcoursenameshort'] = 'Nome breve de curso inválido';
$string['invaliddata'] = 'Os dados enviados são inválidos';
$string['invaliddatarootpermissions'] = 'Permissões inválidas detectadas no diretório  $CFG->dataroot, o administrador tem que corrigir as permissões.';
$string['invaliddevicetype'] = 'Tipo de dispositivo inválido';
$string['invalidelementid'] = 'Id de elemento incorreto!';
$string['invalidentry'] = 'Esta não é uma entrada válida!';
$string['invalidevent'] = 'Evento inválido';
$string['invalidfieldname'] = '"{$a}" não é um nome de campo válido';
$string['invalidfiletype'] = '"{$a}" não é um tipo de arquivo válido';
$string['invalidformatpara'] = 'Formato incorreto para parâmetro escolhido';
$string['invalidformdata'] = 'Dados em forma incorreta';
$string['invalidfunction'] = 'Função incorreta';
$string['invalidgradeitemid'] = 'Item de avaliação incorreto';
$string['invalidgroupid'] = 'Especificação de ID de grupo incorreta';
$string['invalidipformat'] = 'Formato inválido de endereço IP';
$string['invaliditemid'] = 'Id de item incorreto';
$string['invalidkey'] = 'Chave incorreta';
$string['invalidlegacy'] = 'Definição de papel legado incorreta para o tipo: {$a}
';
$string['invalidmd5'] = 'A variável de verificação estava errada - tente novamente';
$string['invalidmode'] = 'Modo inválido ({$a})';
$string['invalidmodule'] = 'Módulo inválido';
$string['invalidmoduleid'] = 'ID de módulo inválido: {$a}';
$string['invalidmodulename'] = 'Nome de módulo inválido: {$a}';
$string['invalidnum'] = 'Valor numérico inválido';
$string['invalidnumkey'] = 'O arranjo $conditions não pode conter chaves numéricas. Favor corrigir o código!';
$string['invalidoutcome'] = 'ID de resultado incorreto';
$string['invalidpagesize'] = 'Tamanho de página incorreto';
$string['invalidpasswordpolicy'] = 'Política de senhas inválida';
$string['invalidpaymentmethod'] = 'Método de pagamento inválido: {$a}';
$string['invalidqueryparam'] = 'ERRO: Número incorreto de parâmetros de consulta. Esperado {$a->expected}, obtido {$a->actual}.';
$string['invalidratingarea'] = 'Área de classificação inválida';
$string['invalidrecord'] = 'Não foi encontrada nenhum dado gravado na tabela de banco de dados {$a}.';
$string['invalidrecordunknown'] = 'Não foi encontrada nenhum dado gravado no banco de dados';
$string['invalidrequest'] = 'Requisição inválida';
$string['invalidrole'] = 'Papel inválido';
$string['invalidroleid'] = 'ID de papel inválido';
$string['invalidscaleid'] = 'ID de escala incorreto';
$string['invalidsection'] = 'Os registros do módulo de curso tem uma seção inválida';
$string['invalidsesskey'] = 'O form foi recusado, a chave da sessão não é correta.';
$string['invalidshortname'] = 'Este nome breve de curso é inválido';
$string['invalidsourcefield'] = 'Rascunho de campo fonte de arquivo inválido';
$string['invalidstatedetected'] = 'Há algo errado: {$a}. Isto nunca deveria acontecer, normalmente.';
$string['invalidurl'] = 'Url inválida';
$string['invaliduser'] = 'Usuário inválido';
$string['invaliduserfield'] = 'Campo de usuário inválido: {$a}';
$string['invaliduserid'] = 'ID de usuário inválido';
$string['invalidusername'] = 'A identificação de usuário fornecido contém caracteres inválidos';
$string['invalidxmlfile'] = '"{$a}" não é um arquivo XML válido';
$string['iplookupfailed'] = 'Impossível rastrear informações desse endereço IP: {$a};';
$string['iplookupprivate'] = 'Não foi possível mostrar o resultado do rastreamento de IP.';
$string['ipmismatch'] = 'O IP do cliente não confere';
$string['listcantmovedown'] = 'Impossível mover o item para baixo, está no final da lista.';
$string['listcantmoveleft'] = 'Impossível mover para a esquerda, pois não há um elemento pai.';
$string['listcantmoveright'] = 'Impossível mover para a direita, não há local para descer na hierarquia. Mova para outra seção e então tente novamente para a direita.';
$string['listcantmoveup'] = 'Impossível mover para cima, é o primeiro da lista.';
$string['listnochildren'] = 'Esse item não tem filhos.';
$string['listnoitem'] = 'Item não encontrado';
$string['listnopeers'] = 'Não há items no mesmo nível.';
$string['listupdatefail'] = 'Falha do banco de dados ao editar a hierarquia da lista.';
$string['logfilenotavailable'] = 'Registros não disponíveis';
$string['loginasnoenrol'] = 'Você não pode usar a inscrição enquanto a sessão "Logar como" estiver ativa.';
$string['loginasonecourse'] = 'Impossível entrar nesse curso.<br /> Você precisa finalizar a sessão "Logar como" antes de entrar em outro curso.';
$string['maxareabytes'] = 'O arquivo é maior do que o espaço restante nesta área.';
$string['maxbytes'] = 'O arquivo é maior do que o tamanho máximo permitido.';
$string['messagingdisable'] = 'As mensagens não estão habilitadas nesta instalação';
$string['mimetexisnotexist'] = 'Seu sistema não está configurado para executar mimeTex. Você precisa baixar o arquivo executável apropriado para sua plataforma PHP_OS em <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a>, ou obter o código fonte C em <a href="http://www.forkosh.com/mimetex.zip">http://www.forkosh.com/mimetex.zip</ a>, compilar e colocar o seu executável no diretório moodle/filter/tex.
';
$string['mimetexnotexecutable'] = 'O mimetex personalizado não é executável!';
$string['missingfield'] = 'O campo "{$a}" está faltando';
$string['missingkeyinsql'] = 'ERRO: falta o parâmetro "{$a}" na consulta';
$string['missing_moodle_backup_xml_file'] = 'Falta o arquivo XML {$a} para poder fazer o arquivamento';
$string['missingparam'] = 'Falta o parâmetro requerido {$a}';
$string['missingparameter'] = 'Falta um parâmetro';
$string['missingrequiredfield'] = 'Faltam informações obrigatórias';
$string['missinguseranditemid'] = 'Falta userid e itemid';
$string['missingvarname'] = 'Falta nome de variável requerido!';
$string['mixedtypesqlparam'] = 'ERRO: Tipos de par6ametros misturados na consulta SQL!';
$string['mnetdisable'] = 'MNET não está habilitado';
$string['mnetlocal'] = 'Usuários remotos MNET não podem entrar localmente';
$string['moduledisable'] = 'Este módulo ({$a}) foi desabilitado para este curso';
$string['moduledoesnotexist'] = 'Este módulo não existe';
$string['moduleinstancedoesnotexist'] = 'A instância deste módulo não existe';
$string['modulemissingcode'] = 'O módulo {$a} está sem o código necessário para executar esta função';
$string['movecatcontentstoroot'] = 'Mover o conteúdo da categoria para a raiz não é permitido. Você deve mover o conteúdo para uma categoria existente!';
$string['movecategorynotpossible'] = 'Você não pode mover a categoria \'{$a}\' para a categoria selecionada.';
$string['movecategoryownparent'] = 'Você não pode fazer a categoria \'{$a}\' um pai de si mesmo.';
$string['movecategoryparentconflict'] = 'Você não pode fazer da categoria \'{$a}\' uma subcategoria de suas próprias subcategorias.';
$string['mssqlrcsmodemissing'] = 'O banco de dados não está usando o modo de READ_COMMITTED_SNAPSHOT esperado que pode levar a resultados errados, especialmente em cenários de alta concorrência. Ative-o para o comportamento correto. Você pode encontrar mais informações no <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP#Configuration"> Moodle Docs </a>.';
$string['multiplerecordsfound'] = 'Foram encontrados registros múltiplos.Espera-se um único registro.';
$string['multiplerestorenotallow'] = 'Restauração múltipla não é permitida!';
$string['mustbeloggedin'] = 'Você deve entrar no ambiente para fazer isto';
$string['mustbeteacher'] = 'Apenas os professores podem consultar esta página';
$string['myisamproblem'] = 'As tabelas do banco de dados estão usando a máquina MyISAM. Recomenda-se usar uma máquina de banco de dados compatível com ACID, com suporte completo a transações, como, por exemplo, InnoDB';
$string['needcopy'] = 'Você precisa copiar algo primeiro!
';
$string['needcoursecategroyid'] = 'Deve ser especificado o ID do curso ou da categoria';
$string['needphpext'] = 'Você deve acrescentar suporte {$a} para sua instalação de PHP';
$string['noadmins'] = 'Não há administradores!';
$string['noblocks'] = 'Não foi encontrado nenhum bloco!';
$string['nocapabilitytousethisservice'] = 'O usuário não tem as permissões necessáriaspara usar este serviço';
$string['nocategorydelete'] = 'A categoria \'{$a}\' não pode ser apagada!';
$string['nocontext'] = 'O contexto desse curso é inválido';
$string['nodata'] = 'Sem dados';
$string['noexistingcategory'] = 'Categoria inexistente.';
$string['nofile'] = 'Arquivo não especificado.';
$string['nofiltersenabled'] = 'Não há filtros ativados.';
$string['nofolder'] = 'O diretório solicitado não existe!';
$string['noformdesc'] = 'Não foi encontrado nenhum arquivo de descrição de formulário formslib para esta atividade.';
$string['noguest'] = 'Aqui não há nenhum convidado!';
$string['noinstances'] = 'Nenhuma instância de {$a} neste curso!';
$string['nologinas'] = 'Você não pode logar como esse usuário';
$string['nonmeaningfulcontent'] = 'Nenhum conteúdo significativo';
$string['noparticipants'] = 'Nenhum participante encontrado para este curso';
$string['noparticipatorycms'] = 'Desculpe, você não tem módulos de participação em cursos para informar';
$string['nopermissions'] = 'Você não tem permissão para {$a}';
$string['nopermissiontocomment'] = 'Você não pode adicionar comentários';
$string['nopermissiontodelentry'] = 'Você não pode apagar as mensagens de outras pessoas!';
$string['nopermissiontoeditcomment'] = 'Você não pode editar os comentários de outras pessoas!';
$string['nopermissiontohide'] = 'Sem permissão para ocultar!';
$string['nopermissiontoimportact'] = 'Você não possui as devidas permissões para importar atividades para este curso';
$string['nopermissiontolock'] = 'Sem permissão para trancar! ';
$string['nopermissiontomanagegroup'] = 'Você não term as permissões necessárias para gerenciar grupos';
$string['nopermissiontorate'] = 'Não é permitido avaliar items!';
$string['nopermissiontoshow'] = 'Sem permissão para ver isto!';
$string['nopermissiontounlock'] = 'Sem permissão para destrancar!';
$string['nopermissiontoupdatecalendar'] = 'Desculpe, mas você não tem permissões para atualizar os eventos do calendário';
$string['nopermissiontoviewgrades'] = 'Não é possível ver as notas';
$string['nopermissiontoviewletergrade'] = 'Sem permissào para ver notas na escala de letras';
$string['nopermissiontoviewpage'] = 'Você não tem acesso a esta página';
$string['nosite'] = 'Não foi possível achar um curso do primeiro nível!';
$string['nositeid'] = 'Sem ID no ambiente';
$string['nostatstodisplay'] = 'Não há dados a serem mostrados';
$string['notallowedtoupdateprefremotely'] = 'Você não tem permissões para atualizar as preferências desse usuário remotamente';
$string['notavailable'] = 'Atualmente não é disponível';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Você não é membro deste grupo do curso';
$string['notownerofkey'] = 'Você não é proprietário desta chave';
$string['nousers'] = 'O usuário não existe!';
$string['onlyadmins'] = 'Apenas administradores podem fazer isto';
$string['onlyeditingteachers'] = 'Apenas os professores com direitos de edição podem fazer isto.';
$string['onlyeditown'] = 'Você pode modificar apenas os seus dados';
$string['orderidnotfound'] = 'ID do pedido {$a} não encontrado';
$string['pagenotexist'] = 'Um erro incomum aconteceu (tentativa de acessar uma página que não existe)';
$string['pathdoesnotstartslash'] = 'Argumento inválido! O caminho do arquivo não inicia com uma barra!';
$string['pleasereport'] = 'Por favor dedique alguns minutos à descrição do que você estava tentando fazer quando aconteceu o erro:';
$string['pluginrequirementsnotmet'] = 'O Plugin "{$a->pluginname}" ({$a->pluginversion}) não foi instalado. Isto requer uma nova versão de Moodle (você está usando a versão {$a->currentmoodle}, mas precisa da {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p> Erro: prefixo da tabela do banco de dados não pode estar vazio ({$a}) </ p><p> O administrador do site deve corrigir esse problema </ p>.';
$string['prefixtoolong'] = '<p> Erro: prefixo da tabela do banco de dados é muito grande ({$a->dbfamily})</p> <p> O administrador do site deve corrigir esse problema. Tamanho máximo para prefixos de tabela no {$a->dbfamily} é {$a->maxlength} caracteres.</p>';
$string['processingstops'] = 'Processamento interrompido aqui. Os demais registros foram ignorados.';
$string['protected_cc_not_supported'] = 'Cartuchos protegidos não suportados.';
$string['querystringcannotbeempty'] = 'A consulta não pode ser vazia.';
$string['redirecterrordetected'] = 'Detectado redirecionamento não suportado. A execução do script foi cancelada
';
$string['refoundto'] = 'Pode ser reembolsado ao {$a}';
$string['refoundtoorigi'] = 'Devolução do montante original: {$a}';
$string['remotedownloaderror'] = '<p>O download do componente falhou, por favor verifique as configurações do proxy. A extensão cURL do PHP é altamente recomendada.<p/><p>Você precisar baixar o <a href="{$a->url}">arquivo</a> manualmente, copiar para "{$a->dest}" e descompactar lá.<p/>';
$string['remotedownloadnotallowed'] = 'Não é permitido baixar componentes no seu servidor (allow_url_fopen está desabilitado).).<br /><br />Você deve baixar o arquivo <a href="{$a->url}">{$a->url}</a> manualmente, copiar em "{$a->dest}" no seu servidor e descomprimir o arquivo nesta posição.';
$string['reportnotavailable'] = 'Este tipo de informe só está disponível para o curso global';
$string['requirecorrectaccess'] = 'Url inválida ou alterada.';
$string['requireloginerror'] = 'Curso ou atividade não acessível.';
$string['restorechecksumfailed'] = 'Erro ao restaurar a informação relativa à sessão. Controle os limites memory/DB do PHP.';
$string['restore_path_element_missingmethod'] = 'Método de restauração {$a} está faltando. Precisa ser definido por um desenvolvedor.';
$string['restore_path_element_noobject'] = 'Restauração do objeto {$a} não é um objeto.';
$string['restrictedcontextexception'] = 'Desculpe, a execução da função externa viola restrição de contexto.';
$string['restricteduser'] = 'Sinto muito, mas a sua conta atual, "{$a}" , não tem permissão para fazer isto.';
$string['reverseproxyabused'] = 'Proxy reverso habilitado. Não é possível o acesso direto ao servidor. <br />Favor entre em contato com o administrador.';
$string['rpcerror'] = 'A comunicação com MNET falhou! Eis a mensagem de erro para que você repasse para seu administrador: {$a}';
$string['scheduledbackupsdisabled'] = 'Os backups agendados foram desativados pelo administrador';
$string['secretalreadyused'] = 'Esta referencia para confirmar a mudança de senha já foi usada, a senha não foi mudada';
$string['sectionnotexist'] = 'Esta seção não existe';
$string['sendmessage'] = 'Enviar mensagem';
$string['serverconnection'] = 'Erro ao conectar ao servidor';
$string['servicedonotexist'] = 'Este serviço não existe';
$string['sessioncookiesdisable'] = 'Uso incorreto de rrequire_key_login(). Os cookies de sessão não devem estar habilitados!';
$string['sessiondiskfull'] = 'A partição desta sessão esta cheia. Não é possível fazer login neste momento. Por favor, avise o administrador.';
$string['sessionerroruser'] = 'Sua sessão expirou. Por favor, identifique-se novamente.';
$string['sessionerroruser2'] = 'Foi detectado um erro no servidor relativo ao seu login. Por favor faça um novo login no site ou feche todas as janelas do seu navegador antes de tentar novamente.';
$string['sessionhandlerproblem'] = 'O manipulador de sessão está mal configurado';
$string['sessionipnomatch'] = 'Sinto muito, mas parece que o seu número de IP mudou desde o seu primeiro login. Esta medida de segurança evita o roubo da sua identidade por crackers enquanto você estiver utilizando este site. Contate o administrador do site se você precisar de ajuda para resolver este problema.';
$string['sessionipnomatch2'] = '<p>Desculpe, mas seu endereço IP parece ter mudado desde a primeira vez que você entrou. Este mecanismo de segurança evita que os crackers roubem sua identidade neste ambiente. Você poderá encontrar este erro se usa redes sem fio ou se está andando entre diferentes redes. Para mais ajuda, entre em contato com o administrador de seu ambiente.</p><p>Se deseja continuar, aperte a tecla F5 para recarregar esta página.</p>';
$string['sessionwaiterr'] = 'Tempo esgotado enquanto aguardava trava de sessão. <br/>Aguarde a finalização de requisição e tente novamente mais tarde.';
$string['shortnametaken'] = 'Nome breve já é usado em um outro curso ({$a})';
$string['socksnotsupported'] = 'SOCKS5 proxy não é compatível com PHP4';
$string['spellcheckernotconf'] = 'O corretor ortográfico não está configurado';
$string['sslonlyaccess'] = 'Por razões de segurança apenas as conexões https são permitidas, desculpe.';
$string['statscatchupmode'] = 'As estatísticas estão em modalidade de captura. Até agora {$a->daysdone} dias foram processados e {$a->dayspending} então pendentes. Faça um novo controle dauqi a pouco!';
$string['statsdisable'] = 'Estatísticas não estão habilitadas.';
$string['statsnodata'] = 'Não há dados disponíveis para essa combinação de curso e período de tempo';
$string['storedfilecannotcreatefile'] = 'Não é possível criar o arquivo de conjunto de arquivo local, verifique as permissões na raiz de dados e o espaço em disco disponível.';
$string['storedfilecannotcreatefiledirs'] = 'Não foi possível criar o diretório  para arquivos de pool locais. Favor verificar permissões em dataroot.';
$string['storedfilecannotread'] = 'Não é possível ler o arquivo, o arquivo não existe ou há problemas de permissão';
$string['storedfilenotcreated'] = 'Não é possível criar o arquivo "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}"';
$string['storedfileproblem'] = 'Exceção desconhecida relacionadas a arquivos locais ({$a})';
$string['tagdisabled'] = 'Tags estão desativadas!';
$string['tagnotfound'] = 'O tag especificado não foi encontrado no banco de dados';
$string['targetdatabasenotempty'] = 'O banco de dados de destino não está vazio. Transferência cancelada por razões de segurança.';
$string['textconditionsnotallowed'] = 'Não é permitida a comparação de condições de colunas de texto. Favor usar sql_compare_text() na sua consulta.';
$string['themenotinstall'] = 'Este tema não está instalado!';
$string['TODO'] = 'FAZER';
$string['tokengenerationfailed'] = 'Não é possível gerar um novo token.';
$string['transactionvoid'] = 'A transação não pode ser anulada porque já foi cancelada';
$string['unenrolerror'] = 'Ocorreu um erro ao tentar desinscrever essa pessoa';
$string['unicodeupgradeerror'] = 'Seu banco de dados não está em Unicode e essa versão do Moodle não consegue fazer a migração. Atualize para o Moodle 1.7.x e continue o processo pela página do Admin. Depois disso a migração continuará normalmente.';
$string['unknowaction'] = 'Ação desconhecida!';
$string['unknowcategory'] = 'Categoria desconhecida!';
$string['unknowcontext'] = 'Este é um contexto desconhecido ({$a}) em get_child_contexts!';
$string['unknowformat'] = 'Formato desconhecido ({$a})';
$string['unknownbackupexporterror'] = 'Erro não identificado ao preparar a informação para importação';
$string['unknownblockregion'] = 'A região do bloco \'{$a}\' não é reconhecida nesta página.';
$string['unknowncontext'] = 'Este é um contexto desconhecido.';
$string['unknowncourse'] = 'Curso "{$a}" desconhecido';
$string['unknowncourseidnumber'] = 'ID de curso desconhecido "{$a}"';
$string['unknowncourserequest'] = 'pedido de curso desconhecido';
$string['unknowncoursesection'] = 'Tópico desconhecido no curso "{$a}"';
$string['unknownevent'] = 'Evento desconhecido';
$string['unknownfiletype'] = 'Erro desconhecido no tipo de filtro';
$string['unknowngroup'] = 'Grupo desconhecido: "{$a}"';
$string['unknownhelp'] = 'Tópico de ajudar {$a} desconhecido';
$string['unknownjsinrequirejs'] = 'A biblioteca JS {$a} não foi encontrada';
$string['unknownmodulename'] = 'Nome do módulo desconhecido para formulário';
$string['unknownrole'] = 'Papel desconhecido: "{$a}"';
$string['unknownsortcolumn'] = 'Coluna de ordenação desconhecida {$a}';
$string['unknownuseraction'] = 'Sinto muito, não entendo esta ação de usuário';
$string['unknownuserselector'] = 'Seletor de usuário não identificado';
$string['unknoworder'] = 'Ordenação desconhecida ';
$string['unknowparamtype'] = 'Tipo de parâmetro desconhecido: {$a}';
$string['unknowquestiontype'] = 'Tipo de questão {$a} não suportado';
$string['unknowuploadaction'] = 'Erro: Ação de envio de arquivo ({$a}) desconhecida';
$string['unspecifycourseid'] = 'Deve ser especificado o ID do curso, o nome breve ou idnumber';
$string['unsupportedevent'] = 'Tipo de evento não suportado';
$string['unsupportedstate'] = 'Estado de conclusão não suportado';
$string['unsupportedwebserver'] = 'Software de servidor Web ({$a}) não é compatível, desculpe.';
$string['upgraderequires19'] = 'Erro: Nova versão do Moodle foi instalada no servidor, infelizmente atualização da versão anterior não é suportada <br /> Por favor, atualize primeiro para última versão 1.9.x.. Você também pode voltar à versão anterior, reinstalando os arquivos originais.';
$string['upgraderunning'] = 'O site está sendo atualizado, por favor, tente novamente mais tarde.';
$string['urlnotdefinerss'] = 'URL não definida para alimentador de notícias RSS';
$string['useradmineditadmin'] = 'Somente administradores tem permissão para modificar contas de outros administradores';
$string['useradminodelete'] = 'Contas de administradores não podem ser excluídas';
$string['userautherror'] = 'Plugin de autenticação desconhecido';
$string['userauthunsupported'] = 'Plugin de autenticação não suportado aqui';
$string['useremailduplicate'] = 'E-mail duplicado';
$string['usermustbemnet'] = 'Os usuários na lista de controle de acesso MNET devem ser usuários MNET remotos';
$string['usernotaddederror'] = 'Usuário não adicionado - erro';
$string['usernotaddedregistered'] = 'Usuário não adicionado - já registrado';
$string['usernotavailable'] = 'Os detalhes deste usuário não estão disponíveis a você';
$string['usernotdeletedadmin'] = 'Usuário não foi excluído - contas de administradores não podem ser excluídas';
$string['usernotdeletederror'] = 'Usuário não foi apagado - erro.';
$string['usernotdeletedmissing'] = 'Usuário não foi excluído - impossível encontrar esse "username"';
$string['usernotdeletedoff'] = 'Usuário não foi apagado - opção não permitida.';
$string['usernotincourse'] = 'Este usuário não está neste curso!';
$string['usernotrenamedadmin'] = 'Impossível renomear contas de admin.';
$string['usernotrenamedexists'] = 'Usuário não renomeado - o novo "username" já está em uso';
$string['usernotrenamedmissing'] = 'Usuário não renomeado - impossível achar o "username"';
$string['usernotrenamedoff'] = 'Usuário não foi renomeado - opção não permitida.';
$string['usernotupdatedadmin'] = 'Impossível atualizar contas de admin.';
$string['usernotupdatederror'] = 'Usuário não foi atualizado - erro.';
$string['usernotupdatednotexists'] = 'Usuário não foi atualizado - ele não existe.';
$string['userquotalimit'] = 'Você atingiu o limite da sua cota de arquivo.';
$string['userselectortoomany'] = 'O seletor de usuários selecionou mais de um usuário, apesar de que "multiselect" é falso.';
$string['wrongcall'] = 'Este "script" foi invocado de forma errada';
$string['wrongcontextid'] = 'O ID do contexto está incorreto (não foi possível achá-lo)';
$string['wrongdestpath'] = 'Caminho do destino errado';
$string['wrongroleid'] = 'ID do papel incorreto!';
$string['wrongsourcebase'] = 'URL do recurso errada';
$string['wrongusernamepassword'] = 'Usuário/senha incorreto';
$string['wrongzipfilename'] = 'Nome do arquivo ZIP errado';
$string['wscouldnotcreateecoursenopermission'] = 'WS. Sem permissão para criar curso.';
$string['wwwrootmismatch'] = 'Foi detectado acesso Incorreto. Este servidor pode ser acessado apenas através do endereço "{$a}".<br />Por favor, avise o  administrador.';
$string['wwwrootslash'] = 'Foi detectado  $CFG->wwwroot errado no config.php. Não deve ter barra final.<br />Por favor, avise o administrador.';
$string['xmldberror'] = 'Erro XMLDB!';
$string['youcannotdeletecategory'] = 'Não é possível excluir a categoria \'{$a}\' nem excluir ou mover os conteúdos.';
