<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'pt_br', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['appstoredescription'] = 'NOTA: Este aplicativo oficial Moodle Mobile vai funcionar apenas com sites de Moodle que foram configurados para permitir isso. Por favor, fale com o seu administrador do Moodle se você tiver quaisquer problemas para se conectar.

Se o seu site Moodle foi configurado corretamente, você pode usar este aplicativo para:

- Procurar o conteúdo de seus cursos, mesmo quando estiver offline
- Receber notificações instantâneas de mensagens e outros eventos
- Rapidamente encontrar e entrar em contato com outras pessoas em seus cursos
- Fazer upload de imagens, áudio, vídeos e outros arquivos do seu dispositivo móvel
- Visualizar suas notas do cursos
- e mais!

Por favor, veja http://docs.moodle.org/en/Mobile_app para todas as últimas informações.

Nós realmente gostaríamos de receber quaisquer boas opiniões sobre a funcionalidade até agora e sugestões sobre o que mais você quer esse aplicativo faça!

O aplicativo requer as seguintes permissões:
Gravar áudio - Para gravação de áudio para enviar para o Moodle
Ler e modificar o conteúdo do cartão SD - Os conteúdos são baixados para o cartão SD para que você possa vê-los off-line
Acesso à rede - Para ser capaz de se conectar com seu site Moodle e verificar se você está conectado ou não para mudar para o modo off-line
Executar no início do sistema - Para você receber notificações locais, mesmo quando o aplicativo estiver sendo executado em segundo plano
Prevenir telefone de dormir - De forma que você possa receber notificações a qualquer momento';
$string['mma.calendar.calendarevents'] = 'Eventos do calendário';
$string['mma.calendar.errorloadevent'] = 'Erro ao carregar evento.';
$string['mma.calendar.errorloadevents'] = 'Erro ao carregar eventos.';
$string['mma.calendar.noevents'] = 'Sem eventos';
$string['mma.calendar.notifications'] = 'Notificação';
$string['mma.coursecompletion.complete'] = 'Concluído';
$string['mma.coursecompletion.completecourse'] = 'Curso concluído';
$string['mma.coursecompletion.completed'] = 'Completado';
$string['mma.coursecompletion.completiondate'] = 'Data de conclusão';
$string['mma.coursecompletion.couldnotloadreport'] = 'Não foi possível carregar o relatório de conclusão do curso, por favor tente novamente mais tarde.';
$string['mma.coursecompletion.coursecompletion'] = 'Conclusão do curso';
$string['mma.coursecompletion.criteria'] = 'Critérios';
$string['mma.coursecompletion.criteriagroup'] = 'Grupo de critérios';
$string['mma.coursecompletion.criteriarequiredall'] = 'Todos os critérios abaixo são necessários';
$string['mma.coursecompletion.criteriarequiredany'] = 'Quaisquer critérios abaixo são necessários';
$string['mma.coursecompletion.inprogress'] = 'Em progresso';
$string['mma.coursecompletion.manualselfcompletion'] = 'Auto conclusão manual';
$string['mma.coursecompletion.notyetstarted'] = 'Ainda não começou';
$string['mma.coursecompletion.pending'] = 'Pendente';
$string['mma.coursecompletion.required'] = 'Necessário';
$string['mma.coursecompletion.requiredcriteria'] = 'Critério necessário';
$string['mma.coursecompletion.requirement'] = 'Exigência';
$string['mma.coursecompletion.status'] = 'Condição';
$string['mma.coursecompletion.viewcoursereport'] = 'Ver relatório de curso';
$string['mma.files.admindisableddownload'] = 'Por favor note que o administrador do Moodle desativou downloads de arquivos, você pode navegar através dos arquivos, mas não baixá-los.';
$string['mma.files.audio'] = 'Audio';
$string['mma.files.camera'] = 'Câmera';
$string['mma.files.chooseaccountuploadfile'] = 'Escolha uma conta para enviar o arquivo.';
$string['mma.files.clicktoupload'] = 'Clique no botão abaixo para enviar para seus arquivos privados.';
$string['mma.files.confirmuploadfile'] = 'Você está prestes a enviar {{size}}. Você tem certeza que quer continuar?';
$string['mma.files.couldnotloadfiles'] = 'A lista de arquivos não pode ser carregada.';
$string['mma.files.downloading'] = 'Baixando';
$string['mma.files.emptyfilelist'] = 'Não há arquivos para mostrar.';
$string['mma.files.errorcapturingaudio'] = 'Erro ao capturar áudio';
$string['mma.files.errorcapturingimage'] = 'Erro ao capturar imagem.';
$string['mma.files.errorcapturingvideo'] = 'Erro ao capturar  vídeo';
$string['mma.files.errorgettingimagealbum'] = 'Erro ao pegar imagem a partir do álbum.';
$string['mma.files.errormustbeonlinetoupload'] = 'Você precisa estar online para enviar arquivos.';
$string['mma.files.errornoapp'] = 'Você não tem um aplicativo instalado para fazer essa ação.';
$string['mma.files.errorreadingfile'] = 'Erro ao ler arquivo.';
$string['mma.files.errorreceivefilenosites'] = 'Não existem sites armazenados. Por favor adicione um site antes de enviar um arquivo.';
$string['mma.files.errorwhiledownloading'] = 'Houve um erro ao tentar baixar o arquivo.';
$string['mma.files.errorwhilerecordingaudio'] = 'Houve um erro ao tentar gravar o audio.';
$string['mma.files.errorwhileuploading'] = 'Houve um erro durante o envio do arquivo.';
$string['mma.files.file'] = 'Arquivo';
$string['mma.files.fileuploaded'] = 'Arquivo enviado';
$string['mma.files.myfiles'] = 'Meus arquivos';
$string['mma.files.myprivatefiles'] = 'Meus arquivos privados';
$string['mma.files.myprivatefilesdesc'] = 'Os arquivos que estão disponíveis em sua área de arquivos privados nesse site Moodle.';
$string['mma.files.photoalbums'] = 'Álbuns de fotos';
$string['mma.files.readingfile'] = 'Lendo arquivos';
$string['mma.files.sitefiles'] = 'Arquivos do site';
$string['mma.files.sitefilesdesc'] = 'Os outros arquivos que estão disponíveis a você neste site Moodle.';
$string['mma.files.success'] = 'Sucesso!';
$string['mma.files.uploadafile'] = 'Enviando um arquivo';
$string['mma.files.uploadfiles'] = 'Enviar arquivos';
$string['mma.files.uploading'] = 'Enviando';
$string['mma.files.video'] = 'Vídeo';
$string['mma.frontpage.frontpage'] = 'Página principal';
$string['mma.frontpage.sitehome'] = 'Página inicial';
$string['mma.grades.average'] = 'Média';
$string['mma.grades.contributiontocoursetotal'] = 'Contribuição ao total do curso';
$string['mma.grades.feedback'] = 'Feedback';
$string['mma.grades.grade'] = 'Nota';
$string['mma.grades.grades'] = 'Notas';
$string['mma.grades.itemname'] = 'Item de nota';
$string['mma.grades.lettergrade'] = 'Nota letra';
$string['mma.grades.percentage'] = 'Porcentagem';
$string['mma.grades.range'] = 'Range';
$string['mma.grades.rank'] = 'Posição';
$string['mma.grades.viewgrades'] = 'Ver notas';
$string['mma.grades.weight'] = 'Peso';
$string['mma.messages.contactlistempty'] = 'A lista de contatos está vaiza';
$string['mma.messages.contactname'] = 'Nome do contato';
$string['mma.messages.errordeletemessage'] = 'Erro enquanto excluía a mensagem.';
$string['mma.messages.erroruseronlyacceptsmessagefromcontacts'] = 'O usuário somente aceita mensagens de contatos';
$string['mma.messages.errorwhileretrievingcontacts'] = 'Erro ao recuperar contatos a partir do servidor.';
$string['mma.messages.errorwhileretrievingdiscussions'] = 'Erro ao recuperar discussão do servidor.';
$string['mma.messages.errorwhileretrievingmessages'] = 'Erro ao recuperar as mensagens do servidor.';
$string['mma.messages.messagenotsent'] = 'A mensagem não foi enviada. Por favor tente novamente mais tarde.';
$string['mma.messages.mustbeonlinetosendmessages'] = 'Você precisa estar conectado para enviar mensagens.';
$string['mma.messages.newmessage'] = 'Nova mensagem...';
$string['mma.messages.nomessages'] = 'Não há mensagens.';
$string['mma.messages.nousersfound'] = 'Nenhum usuário encontrado';
$string['mma.messages.send'] = 'Enviar';
$string['mma.messages.type_blocked'] = 'Bloqueado';
$string['mma.messages.type_offline'] = 'Offline';
$string['mma.messages.type_online'] = 'Online';
$string['mma.messages.type_search'] = 'Resultados de busca';
$string['mma.messages.type_strangers'] = 'Outros';
$string['mma.mod_assign.userwithid'] = 'Usuário com id {{id}}';
$string['mma.mod_chat.errorwhileconnecting'] = 'Erro ao se conectar.';
$string['mma.mod_chat.errorwhilegettingchatdata'] = 'Erro ao se conectar ao chat.';
$string['mma.mod_chat.errorwhilegettingchatusers'] = 'Erro ao obter os usuários de bate-papo.';
$string['mma.mod_chat.errorwhileretrievingmessages'] = 'Erro ao recuperar as mensagens do servidor.';
$string['mma.mod_chat.errorwhilesendingmessage'] = 'Erro ao enviar a mensagem.';
$string['mma.mod_chat.messagebeepsyou'] = '{{$a}} acaba de bipar você!';
$string['mma.mod_chat.messageenter'] = '{{$a}} acaba de entrar neste bate-papo';
$string['mma.mod_chat.messageexit'] = '{{$a}} deixou este bate-papo';
$string['mma.mod_chat.mustbeonlinetosendmessages'] = 'Você deve estar online para enviar mensagens';
$string['mma.mod_chat.sessionstart'] = 'A próxima sessão de chat vai começar em {{$a}}';
$string['mma.mod_choice.errorgetchoice'] = 'Erro ao obter dados do escolha.';
$string['mma.mod_choice.expired'] = 'Desculpe, esta atividade encerrada em {{$a}} e já não está disponível';
$string['mma.mod_choice.notopenyet'] = 'Desculpe, esta atividade não está disponível até {{$a}}';
$string['mma.mod_choice.numberofuser'] = 'Número de participantes';
$string['mma.mod_choice.numberofuserinpercentage'] = 'Porcentagem de participantes';
$string['mma.mod_choice.previewonly'] = 'Esta é apenas uma prévia das opções disponíveis para esta atividade. Você não será capaz de apresentar a sua escolha até {{$a}}.';
$string['mma.mod_choice.responsesresultgraphdescription'] = '{{number}}% de usuários que escolheram a opção: {{text}}.';
$string['mma.mod_folder.emptyfilelist'] = 'Não há arquivos para mostrar';
$string['mma.mod_folder.errorwhilegettingfolder'] = 'Erro ao obter dados da pasta.';
$string['mma.mod_forum.erroremptysubject'] = 'Assunto não pode estar vazio';
$string['mma.mod_forum.errorgetforum'] = 'Erro ao buscar dados de fórum.';
$string['mma.mod_forum.errorgetgroups'] = 'Erro ao obter configurações do grupo.';
$string['mma.mod_forum.forumnodiscussionsyet'] = 'Não existem tópicos neste fórum ainda';
$string['mma.mod_forum.group'] = 'Grupo';
$string['mma.mod_forum.numdiscussions'] = '{{numdiscussions}} discussões';
$string['mma.mod_forum.numreplies'] = '{{numreplies}} respostas';
$string['mma.mod_glossary.browsemode'] = 'Navegar nas entradas';
$string['mma.mod_glossary.byalphabet'] = 'Alfabeticamente';
$string['mma.mod_glossary.byauthor'] = 'Agrupar por autor';
$string['mma.mod_glossary.bynewestfirst'] = 'Novos primeiro';
$string['mma.mod_glossary.byrecentlyupdated'] = 'Recentemente atualizados';
$string['mma.mod_glossary.bysearch'] = 'Pesquisa';
$string['mma.mod_glossary.entrypendingapproval'] = 'A entrada está pendente de aprovação.';
$string['mma.mod_glossary.errorloadingentries'] = 'Ocorreu um erro enquanto carregava entradas.';
$string['mma.mod_glossary.errorloadingentry'] = 'Ocorreu um erro enquanto carregava a entrada.';
$string['mma.mod_glossary.errorloadingglossary'] = 'Ocorreu um erro enquanto carregava a entrada.';
$string['mma.mod_glossary.noentriesfound'] = 'Nenhuma entrada foi encontrada';
$string['mma.mod_glossary.searchquery'] = 'Consulta de pesquisa';
$string['mma.mod_imscp.showmoduledescription'] = 'Mostrar descrição';
$string['mma.mod_label.label'] = 'Rótulo';
$string['mma.mod_label.taptoview'] = 'Clique para ver o rótulo';
$string['mma.mod_lti.errorgetlti'] = 'Erro ao obter os dados do módulo.';
$string['mma.mod_lti.errorinvalidlaunchurl'] = 'O URL de lançamento não é válido.';
$string['mma.mod_lti.launchactivity'] = 'Iniciar a atividade';
$string['mma.mod_page.errorwhileloadingthepage'] = 'Erro ao carregar conteúdo da página.';
$string['mma.mod_resource.errorwhileloadingthecontent'] = 'Erro ao carregar conteúdo.';
$string['mma.mod_resource.openthefile'] = 'Abrir o arquivo';
$string['mma.mod_scorm.cannotcalculategrade'] = 'Nota não pôde ser calculada.';
$string['mma.mod_scorm.dataattemptshown'] = 'Estes dados pertence a tentativa número {{number}}.';
$string['mma.mod_scorm.errorcreateofflineattempt'] = 'Ocorreu um erro ao criar uma nova tentativa offline. Por favor, tente novamente.';
$string['mma.mod_scorm.errordownloadscorm'] = 'Erro baixar SCORM: "{{name}}".';
$string['mma.mod_scorm.errorgetscorm'] = 'Erro ao obter dados SCORM.';
$string['mma.mod_scorm.errorinvalidversion'] = 'Infelizmente, o aplicativo só suporta SCORM 1.2.';
$string['mma.mod_scorm.errornotdownloadable'] = 'O download de pacotes SCORM está desabilitado no seu site Moodle. Por favor, contate o administrador do site Moodle.';
$string['mma.mod_scorm.errornovalidsco'] = 'Este SCORM não tem um SCO visível para carregar.';
$string['mma.mod_scorm.errorpackagefile'] = 'Infelizmente, o aplicativo suporta apenas pacotes ZIP.';
$string['mma.mod_scorm.errorsyncscorm'] = 'Ocorreu um erro ao sincronizar. Por favor, tente novamente.';
$string['mma.mod_scorm.lastsync'] = 'Última sincronização';
$string['mma.mod_scorm.offlineattemptnote'] = 'Esta tentativa tem dados que não tem sido sincronizado.';
$string['mma.mod_scorm.offlineattemptovermax'] = 'Esta tentativa não pode ser enviada porque você ultrapassou o número máximo de tentativas.';
$string['mma.mod_scorm.scormstatusnotdownloaded'] = 'Este SCORM não é baixado. Ele será baixado automaticamente quando você abri-lo.';
$string['mma.mod_scorm.scormstatusoutdated'] = 'Este SCORM foi modificado desde o último download. Ele será baixado automaticamente quando você abri-lo.';
$string['mma.mod_scorm.warningofflinedatadeleted'] = 'Alguns dados off-line da tentativa {{number}} foram excluídas porque ele não pôde ser criado em uma nova tentativa.';
$string['mma.mod_scorm.warningsynconlineincomplete'] = 'Algumas tentativas não poderiam ser sincronizadas com o site porque a última tentativa não foi finalizada. Por favor termine a tentativa online primeiro.';
$string['mma.mod_survey.cannotsubmitsurvey'] = 'Desculpe, houve um problema enviar a sua pesquisa. Por favor, tente novamente.';
$string['mma.mod_survey.errorgetsurvey'] = 'Erro ao obter dados da pesquisa.';
$string['mma.mod_survey.results'] = 'Resultados';
$string['mma.mod_url.accessurl'] = 'Acessar URL';
$string['mma.mod_url.pointingtourl'] = 'A URL desse recurso direciona para';
$string['mma.notes.addnewnote'] = 'Adicionar uma nova anotação';
$string['mma.notes.coursenotes'] = 'Anotações do curso';
$string['mma.notes.eventnotecreated'] = 'Anotação criada';
$string['mma.notes.nonotes'] = 'Não há mais anotações desse típo';
$string['mma.notes.note'] = 'Anotação';
$string['mma.notes.notes'] = 'Anotações';
$string['mma.notes.personalnotes'] = 'Anotações pessoais';
$string['mma.notes.publishstate'] = 'Contexto';
$string['mma.notes.sitenotes'] = 'Anotações do site';
$string['mma.notes.userwithid'] = 'Usuário com o id {{id}}';
$string['mma.notifications.errorgetnotifications'] = 'Erro ao receber notificações';
$string['mma.notifications.notifications'] = 'Notificação';
$string['mma.notifications.therearentnotificationsyet'] = 'Não há notificações';
$string['mma.participants.noparticipants'] = 'Nenhum dos participantes encontrados para este curso';
$string['mma.participants.participants'] = 'Participantes';
$string['mm.contentlinks.chooseaccount'] = 'Escolha a conta';
$string['mm.contentlinks.chooseaccounttoopenlink'] = 'Escolha a conta que irá abrir o link';
$string['mm.contentlinks.confirmurlothersite'] = 'O link pertence a outro site. Você quer abrir-lo?';
$string['mm.contentlinks.errornoactions'] = 'Não foi possível encontrar uma ação para executar com este link.';
$string['mm.contentlinks.errornosites'] = 'Não foi possível encontrar qualquer site para lidar com este link.';
$string['mm.core.android'] = 'Android';
$string['mm.core.cannotconnect'] = 'Não é possível conectar-se: Verifique se digitou a URL corretamente e se seu site usa o Moodle 2.4 ou posterior.';
$string['mm.core.cannotdownloadfiles'] = 'Download de arquivos está desabilitado no seu serviço Mobile. Por favor, contate o administrador do site.';
$string['mm.core.clearsearch'] = 'Limpar busca';
$string['mm.core.clicktoseefull'] = 'Clique para ver o conteúdo completo.';
$string['mm.core.close'] = 'Fechar';
$string['mm.core.completion-alt-auto-fail'] = 'Concluído: {{$a}} (não alcançou a nota para passar)';
$string['mm.core.completion-alt-auto-n'] = 'Não concluído: {{$a}}';
$string['mm.core.completion-alt-auto-pass'] = 'Concluído: {{$a}} (nota para passar foi alcançada)';
$string['mm.core.completion-alt-auto-y'] = 'Concluído: {{$a}}';
$string['mm.core.completion-alt-manual-n'] = 'Não concluído: {{$a}}. Selecione para marcar como concluída.';
$string['mm.core.completion-alt-manual-y'] = 'Concluído: {{$a}}. Selecione para marcar como não concluída.';
$string['mm.core.confirmopeninbrowser'] = 'Você quer abri-lo no navegador?';
$string['mm.core.deleting'] = 'Excluindo';
$string['mm.core.dfdayweekmonth'] = 'ddd, D MMM';
$string['mm.core.dflastweekdate'] = 'ddd';
$string['mm.core.dfmediumdate'] = 'LLL';
$string['mm.core.dftimedate'] = 'h[:]mm A';
$string['mm.core.downloading'] = 'Baixando';
$string['mm.core.elementseparator'] = ',';
$string['mm.core.errorchangecompletion'] = 'Ocorreu um erro ao alterar o status de conclusão. Por favor, tente novamente.';
$string['mm.core.errordownloading'] = 'Erro ao baixar o arquivo';
$string['mm.core.errordownloadingsomefiles'] = 'Erro ao transferir arquivos de módulo. Alguns arquivos podem estar faltando.';
$string['mm.core.errorinvalidresponse'] = 'Resposta inválida recebida. Por favor, contate o administrador do site Moodle se o erro persistir.';
$string['mm.core.erroropenfilenoapp'] = 'Erro ao abrir o arquivo: nenhum aplicativo encontrado para abrir esse tipo de arquivo.';
$string['mm.core.erroropenfilenoextension'] = 'Erro ao abrir o arquivo: o arquivo não tem extensão.';
$string['mm.core.erroropenpopup'] = 'Esta atividade está tentando abrir um pop-up. Isto não é suportado neste app.';
$string['mm.core.humanreadablesize'] = '{{size}} {{unit}}';
$string['mm.core.image'] = 'Imagem';
$string['mm.core.imageviewer'] = 'Visualizador de imagens';
$string['mm.core.info'] = 'Informações';
$string['mm.core.ios'] = 'iOS';
$string['mm.core.loading'] = 'Carregando';
$string['mm.core.lostconnection'] = 'Perdemos conexão. Você precisa se reconectar. Seu token agora está inválido.';
$string['mm.core.mod_assign'] = 'Tarefa';
$string['mm.core.mod_assignment'] = 'Tarefa';
$string['mm.core.mod_book'] = 'Livro';
$string['mm.core.mod_chat'] = 'Bate-papo';
$string['mm.core.mod_choice'] = 'Escolha';
$string['mm.core.mod_data'] = 'Banco de dados';
$string['mm.core.mod_database'] = 'Banco de dados';
$string['mm.core.mod_external-tool'] = 'Ferramenta externa';
$string['mm.core.mod_feedback'] = 'Feedback';
$string['mm.core.mod_file'] = 'Arquivo';
$string['mm.core.mod_folder'] = 'Pasta';
$string['mm.core.mod_forum'] = 'Fórum';
$string['mm.core.mod_glossary'] = 'Glosário';
$string['mm.core.mod_ims'] = 'Conteúdo de pacote IMS';
$string['mm.core.mod_imscp'] = 'Conteúdo de pacote IMS';
$string['mm.core.mod_label'] = 'Rótulo';
$string['mm.core.mod_lesson'] = 'Lição';
$string['mm.core.mod_lti'] = 'Ferramenta externa';
$string['mm.core.mod_page'] = 'Página';
$string['mm.core.mod_quiz'] = 'Questionário';
$string['mm.core.mod_resource'] = 'Recurso';
$string['mm.core.mod_scorm'] = 'Pacote SCROM';
$string['mm.core.mod_survey'] = 'Pesquisa';
$string['mm.core.mod_url'] = 'URL';
$string['mm.core.mod_wiki'] = 'Wiki';
$string['mm.core.mod_workshop'] = 'Workshop';
$string['mm.core.networkerrormsg'] = 'Rede não habilitada ou não está funcionado';
$string['mm.core.notapplicable'] = 'n/a';
$string['mm.core.numdays'] = '{{$a}} dias';
$string['mm.core.numhours'] = '{{$a}} horas';
$string['mm.core.numminutes'] = '{{$a}} minutos';
$string['mm.core.nummonths'] = '{{$a}} meses';
$string['mm.core.numseconds'] = '{{$a}} segundos';
$string['mm.core.numyears'] = '{{$a}} anos';
$string['mm.core.offline'] = 'Offline';
$string['mm.core.online'] = 'Online';
$string['mm.core.openfullimage'] = 'Clique aqui para exibir a imagem no tamanho completo';
$string['mm.core.openinbrowser'] = 'Abrir no navegador';
$string['mm.core.percentagenumber'] = '{{$a}}%';
$string['mm.core.pulltorefresh'] = 'Puxe para atualizar';
$string['mm.core.requireduserdatamissing'] = 'Este usuário não possui alguns dados de perfil exigidos. Por favor, preencha estes dados em seu Moodle e tente novamente. <br> {{$a}}';
$string['mm.core.searching'] = 'Procurando';
$string['mm.core.sending'] = 'Enviando';
$string['mm.core.serverconnection'] = 'Erro de conexão com o servidor';
$string['mm.core.sizetb'] = 'TB';
$string['mm.core.success'] = 'Sucesso!';
$string['mm.core.tablet'] = 'Tablet';
$string['mm.core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['mm.core.unexpectederror'] = 'Erro inesperado. Por favor, feche e abra novamente o aplicativo para tentar novamente';
$string['mm.core.unknown'] = 'Desconhecido';
$string['mm.core.unzipping'] = 'Descompactando';
$string['mm.core.windowsphone'] = 'Windows Phone';
$string['mm.core.wsfunctionnotavailable'] = 'A função do webservice não está disponível.';
$string['mm.course.activitynotyetviewable'] = 'Essa atividade ou recurso ainda não é visualizável nesse aplicativo.';
$string['mm.course.activitynotyetviewablegothere'] = 'Essa atividade ou recurso ainda não é visualizável nesse aplicativo, clique no botão abaixo para acessar isso pelo site.';
$string['mm.course.allsections'] = 'Todas as seções';
$string['mm.course.confirmdownload'] = 'Você está prestes a baixar {{size}}. Você tem certeza que quer continuar?';
$string['mm.course.confirmdownloadsection'] = 'Você está prestes a baixar {{size}}. Você tem certeza que quer continuar?';
$string['mm.course.confirmdownloadunknownsize'] = 'Não fomos capazes de calcular o tamanho do download. Tem certeza de que deseja fazer o download?';
$string['mm.course.contents'] = 'Conteúdos';
$string['mm.course.couldnotloadsectioncontent'] = 'Não foi possível carregar o conteúdo da seção, por favor tente mais tarde.';
$string['mm.course.couldnotloadsections'] = 'Não foi possível carregar a seção, por favor tente mais tarde.';
$string['mm.course.errordownloadingsection'] = 'Erro ao baixar seção.';
$string['mm.course.errorgetmodule'] = 'Erro ao obter os dados do módulo.';
$string['mm.course.gotothesite'] = 'Ir para o site';
$string['mm.course.nocontentavailable'] = 'Nenhum conteúdo disponível nesse momento.';
$string['mm.courses.confirmselfenrol'] = 'Tem certeza de que deseja inscrever-se neste curso?';
$string['mm.courses.enrolme'] = 'Inscreva-me';
$string['mm.courses.errorloadcourses'] = 'Um erro ocorreu enquanto os cursos estavam sendo carregados.';
$string['mm.courses.errorsearching'] = 'Ocorreu um erro durante a pesquisa.';
$string['mm.courses.errorselfenrol'] = 'Ocorreu um erro ao auto registo.';
$string['mm.courses.filter'] = 'Filtro';
$string['mm.courses.filtermycourses'] = 'Filtrar meus cursos';
$string['mm.courses.frontpage'] = 'Primeira página';
$string['mm.course.showall'] = 'Mostrar todos';
$string['mm.courses.mycourses'] = 'Meus cursos';
$string['mm.courses.nocourses'] = 'Sem informações sobre o curso para mostrar.';
$string['mm.courses.nosearchresults'] = 'Não foram encontrados resultados da sua pesquisa';
$string['mm.courses.notenroled'] = 'Você não está registrado neste curso';
$string['mm.courses.notenrollable'] = 'Você não pode inscrever-se neste curso.';
$string['mm.courses.password'] = 'Chave de inscrição';
$string['mm.courses.search'] = 'Pesquisa';
$string['mm.courses.searchcourses'] = 'Buscar cursos';
$string['mm.courses.searchcoursesadvice'] = 'Você pode usar o botão de busca para acessar os cursos como convidado ou matricular-se em cursos que permitem que ele.';
$string['mm.courses.selfenrolment'] = 'Auto-inscrição';
$string['mm.courses.totalcoursesearchresults'] = 'Total de cursos: {{$a}}';
$string['mm.course.whoops'] = 'Opa!!!';
$string['mm.login.authenticating'] = 'Autenticação';
$string['mm.login.cancel'] = 'Cancelar';
$string['mm.login.cannotdownloadfiles'] = 'O download de arquivos está desabilitado em seu serviço Mobile, o aplicativo não pode trabalhar com essa configuração desabilitada. Por favor, contate o administrador do seu site.';
$string['mm.login.confirmdeletesite'] = 'Você tem certeza que quer excluir o site {{sitename}}?';
$string['mm.login.connect'] = 'Conectar!';
$string['mm.login.connecttomoodle'] = 'Conectar ao moodle';
$string['mm.login.credentials'] = 'Credenciais';
$string['mm.login.credentialsdescription'] = 'Por favor, informe seu nome de usuário e senha para efetuar o login';
$string['mm.login.erroraccesscontrolalloworigin'] = 'A chamada de Cross-Origin que você está tentando executar foi rejeitada. Por favor, verifique https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['mm.login.errordeletesite'] = 'Um erro ocorreu ao excluir esse site. Por favor tente novamente.';
$string['mm.login.errorupdatesite'] = 'Um erro ocorreu quando atualizava o token do site.';
$string['mm.login.help'] = 'Ajuda';
$string['mm.login.helpmelogin'] = '<p>Existem milhares de sites usando Moodle no mundo. Este aplicativo somente pode conectar com um Moodle se este foi especialmente configurado para permitir o acesso móvel. </p>
Se não conseguir se conectar com o seu Moodle, vai precisar entrar em contato com a administradora do seu Moodle e pedir ela acessar  <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p>
<p>Para testar o aplicativo em um site Moodle demo, digite <i>teacher</i>  ou <i>estudent</i> no campo <i>Usuário</i> e clique no botão <b>Adicionar</b>.</p>';
$string['mm.login.invalidaccount'] = 'Por favor, verifique os detalhes de seu Usuário ou peça ao administrador do site para verificar a configuração do site.';
$string['mm.login.invalidmoodleversion'] = 'Versão do Moodle inválida. A versão mínima requerida é:';
$string['mm.login.invalidsite'] = 'A URL do siteé inválida.';
$string['mm.login.localmobileunexpectedresponse'] = 'Verificação do Moodle Mobile Additional Features retornou uma resposta inesperada, você ira se autenticar usando o serviço Mobile padrão';
$string['mm.login.login'] = 'Login';
$string['mm.login.loginbutton'] = 'Login!';
$string['mm.login.logininsiterequired'] = 'É preciso logar no site num navegador.';
$string['mm.login.mobileservicesnotenabled'] = 'Os serviços móveis não estão habilitados no seu Moodle. Por favor contate a administradora do seu Moodle se achar que o acesso móvel deveria estar habilitado';
$string['mm.login.newsitedescription'] = 'Por favor, digite a URL do seu site Moodle. Note que, pode ser que ele não esteja configurado para trabalhar com este app.';
$string['mm.login.notloggedin'] = 'Você precisa estar logado.';
$string['mm.login.password'] = 'Senha';
$string['mm.login.passwordrequired'] = 'Senha necessária';
$string['mm.login.reconnect'] = 'Reconectar';
$string['mm.login.reconnectdescription'] = 'Seu token de autenticação é inválido ou expirou, você tem que reconectar com o site.';
$string['mm.login.reconnectssodescription'] = 'Seu token de autenticação é inválido ou expirou, você tem que reconectar com o site. Você precisa efetuar login no site em uma janela do navegador.';
$string['mm.login.siteaddress'] = 'Endereço do site';
$string['mm.login.siteinmaintenance'] = 'O site está em modo de manutenção';
$string['mm.login.siteurl'] = 'URL do site';
$string['mm.login.siteurlrequired'] = 'URL do site é obrigatória, por exemplo  <i>http://www.yourmoodlesite.abc ou https://www.yourmoodlesite.efg</i>';
$string['mm.login.username'] = 'Nome de Usuário';
$string['mm.login.usernamerequired'] = 'Nome de usuário exigido';
$string['mm.login.webservicesnotenabled'] = 'Web Services não estão ativados em seu site. Por favor, contate a administradora do seu Moodle se você achar que o acesso móvel deve ser ativado.';
$string['mm.settings.about'] = 'Sobre';
$string['mm.settings.appname'] = 'Moodle Mobile {{version}}';
$string['mm.settings.appready'] = 'Aplicativo pronto';
$string['mm.settings.cacheexpirationtime'] = 'Tempo de expiração do cache (milisegundos)';
$string['mm.settings.cordovadevicemodel'] = 'Cordova do modelo do dispositivo';
$string['mm.settings.cordovadeviceosversion'] = 'Cordova Device OS versão';
$string['mm.settings.cordovadeviceplatform'] = 'Cordova Device plataforma';
$string['mm.settings.cordovadeviceuuid'] = 'Cordova Device uuid';
$string['mm.settings.cordovaversion'] = 'Cordova versão';
$string['mm.settings.credits'] = 'Creditos';
$string['mm.settings.currentlanguage'] = 'Idioma atual';
$string['mm.settings.deletesitefiles'] = 'Você tem certeza que quer excluir os arquivos baixados do site \'{{sitename}}\'?';
$string['mm.settings.deletesitefilestitle'] = 'Excluir os arquivos do site';
$string['mm.settings.development'] = 'Desenvolvimento';
$string['mm.settings.deviceinfo'] = 'Informação do dispositivo';
$string['mm.settings.deviceos'] = 'Dispositivo OS';
$string['mm.settings.devicewebworkers'] = 'Device Web Workers suportados';
$string['mm.settings.displayformat'] = 'Formato de exibição';
$string['mm.settings.enabledebugging'] = 'Ativar a depuração';
$string['mm.settings.enabledownloadsection'] = 'Ativar seções de download';
$string['mm.settings.enabledownloadsectiondescription'] = 'Desativar essa opção para acelerar o carregamento das seções do curso.';
$string['mm.settings.enablesyncwifi'] = 'Permitir sincronização apenas quando em Wifi';
$string['mm.settings.errordeletesitefiles'] = 'Erro ao excluir os arquivos do site.';
$string['mm.settings.errorsyncsite'] = 'Erro ao sincronizar os dados do site, por favor verifique sua conexão de internet e tente novamente.';
$string['mm.settings.estimatedfreespace'] = 'Espaço livre estimado';
$string['mm.settings.filesystemroot'] = 'Raiz do sistema de arquivos';
$string['mm.settings.general'] = 'Geral';
$string['mm.settings.language'] = 'Idioma';
$string['mm.settings.license'] = 'Licença';
$string['mm.settings.localnotifavailable'] = 'Notificações locais disponíveis';
$string['mm.settings.locationhref'] = 'Webview URL';
$string['mm.settings.navigatorlanguage'] = 'Idioma de navegação';
$string['mm.settings.navigatoruseragent'] = 'Navegador userAgent';
$string['mm.settings.networkstatus'] = 'O status da conexão Internet';
$string['mm.settings.reportinbackground'] = 'Relatar erros automaticamente';
$string['mm.settings.settings'] = 'Configurações';
$string['mm.settings.sites'] = 'Sites';
$string['mm.settings.spaceusage'] = 'Uso do espaço';
$string['mm.settings.storagetype'] = 'Tipo de armazenamento';
$string['mm.settings.success'] = 'Sucesso!';
$string['mm.settings.synchronization'] = 'Sincronização';
$string['mm.settings.synchronizenow'] = 'Sincronizar agora';
$string['mm.settings.synchronizing'] = 'Sincronizando';
$string['mm.settings.syncsettings'] = 'Configurações de sincronização';
$string['mm.settings.syncsitesuccess'] = 'Os dados do site foram sincronizados e todo o cache foi invalidado.';
$string['mm.settings.total'] = 'Total';
$string['mm.settings.versioncode'] = 'Versão do código';
$string['mm.settings.versionname'] = 'Nome da versão';
$string['mm.settings.wificonnection'] = 'Conexão Wi-Fi';
$string['mm.sidemenu.appsettings'] = 'Configurações do aplicativo';
$string['mm.sidemenu.changesite'] = 'Mudar site';
$string['mm.sidemenu.help'] = 'Ajuda';
$string['mm.sidemenu.logout'] = 'Sair';
$string['mm.sidemenu.mycourses'] = 'Meus cursos';
$string['mm.sidemenu.togglemenu'] = 'Alternar menu';
$string['mm.sidemenu.website'] = 'Site';
$string['mm.user.address'] = 'Endereço';
$string['mm.user.city'] = 'Cidade';
$string['mm.user.contact'] = 'Contato';
$string['mm.user.country'] = 'País';
$string['mm.user.description'] = 'Descrição';
$string['mm.user.details'] = 'Detalhes';
$string['mm.user.detailsnotavailable'] = 'Os detalhes desse usuário não estão disponíveis para você.';
$string['mm.user.editingteacher'] = 'Professor';
$string['mm.user.email'] = 'Email';
$string['mm.user.interests'] = 'interesses';
$string['mm.user.invaliduser'] = 'Usuário inválido.';
$string['mm.user.manager'] = 'Gerente';
$string['mm.user.phone1'] = 'Telefone';
$string['mm.user.phone2'] = 'Celular';
$string['mm.user.roles'] = 'Papéis';
$string['mm.user.student'] = 'Estudante';
$string['mm.user.teacher'] = 'Professor não-editor';
$string['mm.user.webpage'] = 'Página da internet';
$string['pluginname'] = 'Cadeias de idiomas no Moodle Mobile';
