<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'pt_br', branch 'MOODLE_28_STABLE'
 *
 * @package   questionnaire
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ação';
$string['activityoverview'] = 'Você tem questionários que estão atrasados';
$string['additionalinfo'] = 'Informação Adicional';
$string['additionalinfo_help'] = 'Texto a ser mostrado no topo da primeira página desta enquete. (Ex. instruções etc.)';
$string['addnewquestion'] = 'Adicionando questão do tipo: {$a}';
$string['addquestions'] = 'Adicionar questões';
$string['addselqtype'] = 'Adicionar tipo de questão selecionado';
$string['alignment'] = 'Alinhamento dos botões de rádio';
$string['alignment_help'] = 'Selecione o alinhamento dos botões: Vertical (padrão) ou Horizontal.';
$string['all'] = 'Todos';
$string['alreadyfilled'] = 'Você já preencheu previamente esta enquete.';
$string['andaveragevalues'] = 'e os valores médios';
$string['anonymous'] = 'Anônimo';
$string['answerquestions'] = 'Responda às perguntas...';
$string['attempted'] = 'Este questionário foi enviado.';
$string['attemptstillinprogress'] = 'Em andamento. Salvo em:';
$string['autonumbering'] = 'Numeração automática';
$string['autonumbering_help'] = 'A numeração automática de perguntas e páginas. Você pode querer desativar a numeração automática de questionários com ramificação condicional.';
$string['autonumberno'] = 'Não numere as perguntas ou páginas';
$string['autonumberpages'] = 'Número de páginas Auto';
$string['autonumberpagesandquestions'] = 'Numerar automaticamente páginas e questões';
$string['autonumberquestions'] = 'Numerar automaticamente questões';
$string['average'] = 'Média';
$string['averageposition'] = 'Posição média';
$string['averagerank'] = 'Médias';
$string['bodytext'] = 'Texto do corpo';
$string['boxesnbexact'] = 'exatamente {$a} opção(ões).';
$string['boxesnbmax'] = 'no máximo {$a} opção(ões).';
$string['boxesnbmin'] = 'no mínimo {$a} opção(ões)).';
$string['boxesnbreq'] = 'Para esta questão você deve marcar';
$string['by'] = 'por';
$string['cannotviewpublicresponses'] = 'Você não pode ver respostas desta enquete pública';
$string['chart:bipolar'] = 'Barras bipolares';
$string['chart:hbar'] = 'Barras horizontais';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rosa';
$string['chart:type'] = 'Tipo de gráfico';
$string['chart:type_help'] = 'Selecione o tipo de gráfico que você quer utilizar neste feedback';
$string['chart:vprogress'] = 'Barra de progresso vertical';
$string['checkallradiobuttons'] = 'Por favor, selecione opção para o botão de rádio <strong>{$a}</strong>!';
$string['checkboxes'] = 'Caixas de Checagem';
$string['checkboxes_help'] = 'Entre uma opção por linha para o usuário selecionar uma ou múltiplas respostas.';
$string['checkbreaksadded'] = 'Nova quebra de página (s) inserido na posição (s):';
$string['checkbreaksok'] = 'Todas as quebras de página necessárias estão presentes!';
$string['checkbreaksremoved'] = 'Removido {$a} quebra de página (s) extra.';
$string['checknotstarted'] = 'Verificação não iniciada';
$string['checkstarted'] = 'Verificação iniciada';
$string['clicktoswitch'] = '(Clique para mudar)';
$string['closed'] = 'A enquete foi encerrada em {$a}.';
$string['closedate'] = 'Data de encerramento';
$string['closedate_help'] = 'Você pode especificar aqui uma data para encerrar a enquete. Marque a caixa de seleção e selecione a data e hora desejadas.
Os usuários não poderão preencher a enquete após esta data. Caso esta data não seja configurada, a enquete nunca será encerrada.';
$string['closeson'] = 'Enquete fecha em {$a}';
$string['completionsubmit'] = 'Estudante deve esta enquete para para completá-lo';
$string['confalts'] = '- OU - <br />Página de confirmação';
$string['configusergraph'] = 'Exibir gráficos para feedback "Teste de personalidade"';
$string['configusergraphlong'] = 'Use o <a href="http://www.rgraph.net/">Rgraph</a> biblioteca para exibir "Teste de personalidade" cartas de feedback.';
$string['confirmdelallresp'] = 'Você tem certeza que deseja remover TODAS as respostas desta enquete?';
$string['confirmdelchildren'] = 'Se você excluir esta pergunta,  as perguntas filhas também serão excluídos:';
$string['confirmdelgroupresp'] = 'Você está certo que deseja remover TODAS as respostas de {$a}?';
$string['confirmdelquestion'] = 'Tem certeza que deseja excluir a questão na posição {$a}?';
$string['confirmdelquestionresps'] = 'Isso também irá apagar a(s) {$a} resposta(s) já dada(s) a essa pergunta.';
$string['confirmdelresp'] = 'Você está certo que deseja remover as respostas de&nbsp;{$a}&nbsp;?';
$string['confpage'] = 'Texto do cabeçalho';
$string['confpagedesc'] = 'Cabeçalho (em negrito) e corpo do texto para a página de "Confirmação" apresentada após o usuário completar esta enquete. (A URL, se presente, tem precedência sobre o texto de confirmação.)';
$string['confpage_help'] = 'Título (em negrito) e corpo de texto para a &quot;confirmação&quot; página exibida depois que um usuário completa este questionário. (URL, se presente, tem precedência sobre o texto de confirmação.) Se você deixar este campo em branco, uma mensagem padrão será exibido após a conclusão do questionário (Obrigado por completar este questionário).';
$string['contentoptions'] = 'Opções de conteúdo';
$string['couldnotcreatenewsurvey'] = 'Não é possível criar uma nova enquete!';
$string['couldnotdelresp'] = 'Não foi possível remover resposta';
$string['createcontent'] = 'Defina Novo Conteúdo';
$string['createcontent_help'] = 'Selecione uma das opções entre as do botão de rádio. "Criar nova" e a padrão.';
$string['createnew'] = 'Criar nova';
$string['date'] = 'Data';
$string['dateformatting'] = 'Usar o formato dia/mês/ano, ou seja, <strong>14/3/1945</strong> para 14 de Março de 1945';
$string['date_help'] = 'Utilize este tipo de questão se deseja que a resposta seja uma data corretamente formatada';
$string['deleteallresponses'] = 'Remover TODAS as respostas';
$string['deletecurrentquestion'] = 'Remover questão {$a}';
$string['deletedallgroupresp'] = 'Removidas TODAS as respostas no grupo {$a}';
$string['deletedallresp'] = 'Respostas da enquete excluídas';
$string['deletedisabled'] = 'Este item não pode ser excluído';
$string['deletedresp'] = 'Respostas removidas';
$string['deleteresp'] = 'Remover esta resposta';
$string['deletingresp'] = 'Removendo resposta';
$string['dependquestion'] = 'Pergunta Pai';
$string['dependquestion_help'] = 'Você pode selecionar uma pergunta mãe e uma opção de escolha para esta pergunta. Uma pergunta filha só será exibida para o estudante se a sua pergunta mãe for previamente selecionada.';
$string['displaymethod'] = 'Método de apresentação não definido para questão.';
$string['download'] = 'Baixar';
$string['downloadtextformat'] = 'Baixar em formato texto';
$string['downloadtextformat_help'] = 'Este recurso permite que você salve todas as respostas de um questionário para um arquivo de texto (CSV).
Este arquivo pode ser importado para uma planilha (por exemplo, MS Excel ou Open Office Calc) ou um pacote estatístico para o processamento posterior dos dados.';
$string['dropdown'] = 'Caixa de Menu';
$string['dropdown_help'] = 'Não há vantagem real em utilizar a caixa de seleção ao invés de botões de rádio exceto pela longa lista de opções, para salvar espaço na tela.';
$string['edit'] = 'Editar';
$string['editingquestionnaire'] = 'Editar Configurações da Enquete';
$string['editquestion'] = 'Editando questão do tipo: {$a}';
$string['email'] = 'Email para enviar cópia das respostas';
$string['errnewname'] = 'Lamentamos, mas o nome já está em uso. Utilize outro nome.';
$string['erroropening'] = 'Erro ao abrir enquete.';
$string['errortable'] = 'Erro de sistema: tabela corrompida.';
$string['essaybox'] = 'Campo de Texto';
$string['essaybox_help'] = 'Esta questão irá exibir uma caixa de texto com x colunas (ou largura de área) e y linhas (número de linhas de texto).';
$string['event_all_responses_deleted'] = 'Todas as respostas foram excluídas';
$string['event_all_responses_saved_as_text'] = 'Todas as respostas foram salvas como texto';
$string['event_all_responses_viewed'] = 'Todos os relatórios de respostas visualizados';
$string['event_individual_responses_viewed'] = 'Relatórios de respostas individuais visualizados';
$string['event_non_respondents_viewed'] = 'Não respondentes visualizados';
$string['event_previewed'] = 'Questionário visualizado';
$string['event_question_created'] = 'Questão criada';
$string['event_question_deleted'] = 'Questão deletada';
$string['event_response_deleted'] = 'Resposta individual deletada';
$string['event_resumed'] = 'Tentativa retomada';
$string['event_saved'] = 'As respostas foram salvas';
$string['event_submitted'] = 'As respostas foram submetidas';
$string['feedback'] = 'Feedback';
$string['feedbackaddmorefeedbacks'] = 'Adicionar mais {no} campos de feedback';
$string['feedbackbysection'] = 'Feedback das seções';
$string['feedbackeditingglobal'] = 'Editando o feedback global da enquete';
$string['feedbackeditingmessages'] = 'Editando as mensagens de feedback da enquete';
$string['feedbackeditingsections'] = 'Editando as seções de feedback da enquete';
$string['feedbackeditmessages'] = 'Salvar configurações das seções e editar mensagens de feedback';
$string['feedbackeditsections'] = 'Salvar configurações e editar seções de feedback';
$string['feedbackerrorboundaryformat'] = 'Limites de pontuação do feedback devem ser um percentual ou um número. O valor inserido no limite {$a} não é reconhecido.';
$string['feedbackerrorboundaryoutofrange'] = 'Limites de pontuação do feedback devem estar entre 0% e 100%. O valor que você informou no limite {$a} está fora deste intervalo.';
$string['feedbackerrorjunkinboundary'] = 'Você deve preencher as caixas do limite da pontuação do feedback sem deixar lacunas.';
$string['feedbackerrorjunkinfeedback'] = 'Você deve preencher as caixas de feedback sem deixar lacunas.';
$string['feedbackerrororder'] = 'Limites de pontuação do feedback devem estar em ordem, com o maior primeiro. O valor inserido no limite {$a} está fora da seqüência.';
$string['feedbackglobal'] = 'Feedback global';
$string['feedbackglobalheading'] = 'Título do feedback global';
$string['feedbackglobalmessages'] = 'Mensagens de feedback globais';
$string['feedbackhdr'] = 'Feedbacks';
$string['feedbackheading'] = 'Título do feedback';
$string['feedbackheading_help'] = 'No campo de título do feedback você pode usar duas variáveis: $scorepercent e $oppositescorepercent.';
$string['feedback_help'] = 'Ajuda do feedback';
$string['feedbackmessages'] = 'Mensagens de feedback para a seção {$a}';
$string['feedbacknextsection'] = 'Próxima seção {$a}';
$string['feedbacknone'] = 'Sem mensagens de feedback';
$string['feedbacknotes'] = 'Notas de feedback';
$string['feedbacknotes_help'] = 'O texto inserido aqui será apresentado aos respondentes no final de seu relatório de feedback';
$string['feedbackoptions'] = 'Opções de feedback';
$string['feedbackoptions_help'] = 'Opções de feedback estão disponíveis se o seu questionário contém os seguintes tipos de perguntas e configurações pergunta:
Botões de rádio; Menu Dropdown ou Rate. Estas questões devem ser definidos como obrigatórios, o campo Nome da Questão não deve estar vazio e as escolhas possíveis respostas devem conter um valor.';
$string['feedbackremovequestionfromsection'] = 'Esta questão faz parte de uma seção de feedback';
$string['feedbackremovesection'] = 'Remover esta questão irá remover completamente a seção de feedback [{$a}]';
$string['feedbackreport'] = 'Relatório de Feedback';
$string['feedbackscore'] = 'Pontuação de feedback';
$string['feedbackscores'] = 'Mostrar pontuações';
$string['feedbackscores_help'] = 'Mostrar a tabela da pontuação de feedback';
$string['feedbacksection'] = 'Seção';
$string['feedbacksectionheading'] = 'Título de feedback para a seção {$a}';
$string['feedbacksectionheadingmissing'] = 'Você deve digitar um título para esta seção Feedback!';
$string['feedbacksectionheadingtext'] = 'Título';
$string['feedbacksectionlabel'] = 'Rótulo';
$string['feedbacksectionlabel_help'] = 'Este rótulo será utilizado nos gráficos/diagramas. Por favor, mantenha-o mais curto possível!';
$string['feedbacksections'] = '{$a} Seções de feedback';
$string['feedbacksectionsselect'] = 'Seções';
$string['feedbacksectionsselect_help'] = 'Coloque as suas questões para essas seções';
$string['feedbacksettingssaved'] = 'Configurações de feedback salvas';
$string['feedbacktype'] = 'Tipo de feedback';
$string['field'] = 'Questão {$a}';
$string['fieldlength'] = 'Tamanho da caixa texto';
$string['fieldlength_help'] = 'Para a caixa de texto ** ** tipo de pergunta, digite o comprimento ** ** Caixa de Entrada eo comprimento do texto ** ** máxima do texto a ser digitado pelo entrevistado. Os valores padrão são 20 caracteres para a largura da caixa de entrada e 25 caracteres para o comprimento máximo do texto digitado.';
$string['finished'] = 'Você respondeu todas as perguntas no questionário!';
$string['firstrespondent'] = 'Primeiro respondente';
$string['formateditor'] = 'Editor HTML';
$string['formatplain'] = 'Texto plano';
$string['grade'] = 'Escala de notas';
$string['gradesdeleted'] = 'Notas da enquete deletadas';
$string['headingtext'] = 'Texto do cabeçalho';
$string['horizontal'] = 'Horizontal';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Incluir códigos de escolhas';
$string['includechoicetext'] = 'Incluir textos de escolhas';
$string['incorrectcourseid'] = 'ID do curso é incorreto';
$string['incorrectmodule'] = 'ID do módulo do curso é incorreto';
$string['incorrectquestionnaire'] = 'Enquete é incorreta';
$string['invalidresponse'] = 'Foi especificada uma resposta inválida.';
$string['invalidresponserecord'] = 'Foi especificado um registro de resposta inválido.';
$string['invalidsurveyid'] = 'ID inválido para enquete.';
$string['kindofratescale'] = 'Tipo de escala de avaliação';
$string['kindofratescale_help'] = 'Clique com o botão direito no link "Mais ajuda" logo abaixo.';
$string['lastrespondent'] = 'Último respondente';
$string['length'] = 'Tamanho';
$string['managequestions'] = 'Gerenciar questões';
$string['managequestions_help'] = 'Na seção Gerenciar perguntas da página Editar perguntas, você pode realizar uma série de operações nas perguntas do questionário.';
$string['maxdigitsallowed'] = 'Número máximo de dígitos';
$string['maxdigitsallowed_help'] = 'Ao utilizar o máximo. dígitos permitido e Nb de dígitos decimais parâmetros você pode especificar
o comprimento e número de casas decimais necessária.';
$string['maxforcedresponses'] = 'Número máximo de marcações';
$string['maxtextlength'] = 'Tamanho máximo do texto';
$string['messageprovider:message'] = 'Lembrete de enquete';
$string['minforcedresponses'] = 'Número mínimo de marcações';
$string['minforcedresponses_help'] = 'Use esses parâmetros para forçar entrevistado assinalar um mínimo de ** min. ** Caixas e um máximo de Max **. ** Caixas de seleção. Para forçar um número exato de caixas de seleção para ser assinalada, definir Min **. ** E ** Max. ** Para o mesmo valor. Se apenas min ou um valor máximo é desejado, é só deixar o outro valor para o padrão ** 0 ** valor. Se você definir Min **. ** Ou ** Max. ** Para valores diferentes de seu padrão ** 0 ** valor, uma mensagem de advertência será exibida se entrevistado não está de acordo com suas exigências. Obviamente, você deve fazer quaisquer requisitos claros para o entrevistado ou nas instruções gerais do questionário ou no texto de questões relevantes.';
$string['misconfigured'] = 'Curso está mal configurado';
$string['missingname'] = 'Questão {$a} não pode ser utilizada na presente seção de feeedback porque ela não tem nome.';
$string['missingnameandrequired'] = 'Questão {$a} não pode ser utilizada na presente seção de feeedback porque não tem um nome e não é obrigatória.';
$string['missingquestion'] = 'Por favor, responda a questão obrigatória';
$string['missingquestions'] = 'Por favor, responda às questões obrigatórias:';
$string['missingrequired'] = 'Questão {$a} não pode ser utilizada na presente seção de feeedback porque não é obrigatória.';
$string['modulename'] = 'Enquete';
$string['modulename_help'] = 'O módulo enquete permite que você construa pesquisas usando diversos tipos de questões, com o objetivo de coletar dados dos usuários.';
$string['modulenameplural'] = 'Enquetes';
$string['movedisabled'] = 'Este item não pode ser movido';
$string['myresponses'] = 'Todas as suas respostas';
$string['myresponsetitle'] = 'Suas {$a} respostas';
$string['myresults'] = 'Seus Resultados';
$string['name'] = 'Nome';
$string['navigate'] = 'Permitir questões de ramificação';
$string['next'] = 'Próximo';
$string['nextpage'] = 'Próxima página';
$string['nlines'] = '{$a} linhas';
$string['noanswer'] = 'Sem resposta';
$string['noattempts'] = 'Não foram feitas tentativas nesse questionário';
$string['nodata'] = 'Nenhum dado foi postado.';
$string['noduplicates'] = 'Sem duplicações de escolhas';
$string['noduplicateschoiceserror'] = 'Você deve digitar pelo menos 2 respostas possíveis para a opção "Sem opções duplicadas"!';
$string['noneinuse'] = 'Esta enquete não contém questões.';
$string['non_respondents'] = 'Usuários que ainda não enviaram as suas respostas a esta enquete';
$string['nopublicsurveys'] = 'Não há enquetes públicas.';
$string['noresponsedata'] = 'Sem respostas para esta questão.';
$string['noresponses'] = 'Sem respostas';
$string['normal'] = 'Normal';
$string['notanumber'] = '<strong>{$a}</strong> não é um formato aceito para números.';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'Com coluna N/A (não aplicável)';
$string['notavail'] = 'A enquete ainda não está disponível. Tente novamente mais tarde.';
$string['noteligible'] = 'Você não faz parte do público alvo desta enquete.';
$string['notemplatesurveys'] = 'Não há enquetes modelo.';
$string['notopen'] = 'Esta enquete só será aberta em {$a}.';
$string['notrequired'] = 'Resposta não é necessária';
$string['not_started'] = 'não começou';
$string['nousersselected'] = 'Nenhum usuário selecionado';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} tentativas feitas nesta enquete';
$string['numberfloat'] = 'O número que você digitou <strong>{$a->number}</strong> foi reformatado/arredondado com <strong>{$a->precision}</strong> casa(s) decimal(ais).';
$string['numberofdecimaldigits'] = 'Número de casas decimais';
$string['numberscaleitems'] = 'Número de itens da escala';
$string['numberscaleitems_help'] = 'N º de itens da escala é o número * de itens * para ser usado em sua escala de taxa. Você usaria normalmente um valor de 3 a 5. Valor padrão: ** 5 **.';
$string['numeric'] = 'Campo Numérico';
$string['numeric_help'] = 'Utilize este tipo de questão se deseja que a resposta seja um número corretamente formatado';
$string['of'] = 'de';
$string['opendate'] = 'Data de abertura';
$string['opendate_help'] = 'Você pode especificar uma data para abrir o questionário aqui. Verifique a caixa de seleção e escolha a data e hora que quiser.
  Os usuários não serão capazes de preencher o questionário antes dessa data. Se isso não for selecionado, ele será aberto imediatamente.';
$string['option'] = 'opção {$a}';
$string['optionalname'] = 'Nome da Questão';
$string['optionalname_help'] = 'O nome da questão só é usada quando você exporta as respostas para o formato CSV / Excel.
Se você nunca exportar para CSV, então você não precisa se preocupar com nomes pergunta.
Se você planeja exportar seus dados do questionário regularmente para CSV, então você tem uma escolha de duas opções para a questão de nomenclatura.';
$string['or'] = '- OU -';
$string['order_ascending'] = 'Ordem acendente';
$string['order_default'] = 'Visualizar ordem padrão';
$string['order_descending'] = 'Ordem descendente';
$string['orderresponses'] = 'Ordem por respostas';
$string['orderresponses_help'] = 'Ao exibir todas as respostas que você pode encomendar as escolhas por número de respostas (a coluna média) para o seguinte
  4 tipos de perguntas.

* Botão de rádio escolhas individuais
* Escolhas única lista suspensa
* Múltiplas escolhas (caixas de seleção)
* Questões de taxa (incluindo escalas de Likert).

Quando você chegar na página de respostas All, por padrão, todas as respostas são ordenados na ordem em que o criador questionário entrou nas escolhas de perguntas.
  Você pode escolher para ordená-las por ordem crescente ou decrescente.';
$string['osgood'] = 'Diferencial Semântico (Osgood)';
$string['other'] = 'Outro:';
$string['otherempty'] = 'Se você marcar esta opção você deverá digitar algum texto na caixa de texto!';
$string['overviewnumresplog'] = 'respostas';
$string['overviewnumresplog1'] = 'resposta';
$string['overviewnumrespvw'] = 'respostas';
$string['overviewnumrespvw1'] = 'respostas';
$string['owner'] = 'Proprietário';
$string['page'] = 'Página';
$string['pageof'] = 'Página {$a->page} de {$a->totpages}';
$string['participant'] = 'Participante';
$string['pleasecomplete'] = 'Por favor complete essa escolha.';
$string['pluginadministration'] = 'Administração da Enquete';
$string['pluginname'] = 'Enquete';
$string['position'] = 'posição';
$string['possibleanswers'] = 'Respostas possíveis';
$string['posteddata'] = 'Reached page with posted data:';
$string['previewing'] = 'Pré-visualizando Enquete';
$string['preview_label'] = 'Pré-visualização';
$string['preview_questionnaire'] = 'Pré-visualização da qnquete';
$string['previous'] = 'anterior';
$string['previouspage'] = 'Página Anterior';
$string['print'] = 'Imprimir esta Resposta';
$string['printblank'] = 'Imprimir em Branco';
$string['printblanktooltip'] = 'Abrir janela de visualização de impressão com a enquente em branco';
$string['printtooltip'] = 'Abrir uma janela de visualização de impressão com as respostas correntes';
$string['private'] = 'Privada';
$string['public'] = 'Pública';
$string['publiccopy'] = 'Cópia:';
$string['publicoriginal'] = 'Original:';
$string['qtype'] = 'Tipo de resposta';
$string['qtypedaily'] = 'responder diariamente';
$string['qtype_help'] = 'Selecione caso um usuário tenha permissão para responder uma vez,  diariamente, semanalmente, mensalmente ou um número ilimitado de vezes (muitas)';
$string['qtypemonthly'] = 'responder mensalmente';
$string['qtypeonce'] = 'responder uma única vez';
$string['qtypeunlimited'] = 'responder várias vezes';
$string['qtypeweekly'] = 'responder semanalmente';
$string['questionnaire:addinstance'] = 'Adicionar nova enquete';
$string['questionnaireadministration'] = 'Administração da Enquete';
$string['questionnairecloses'] = 'Encerramento da enquete';
$string['questionnaire:copysurveys'] = 'Copiar enquetes modelo e privadas';
$string['questionnaire:createpublic'] = 'Criar enquetes públicas';
$string['questionnaire:createtemplates'] = 'Criar enquetes modelo';
$string['questionnaire:deleteresponses'] = 'Remover qualquer resposta';
$string['questionnaire:downloadresponses'] = 'Baixar respostas em formato CSV';
$string['questionnaire:editquestions'] = 'Criar e editar questões em enquetes';
$string['questionnaire:manage'] = 'Criar e editar enquetes';
$string['questionnaire:message'] = 'Enviar mensagem para não respondentes';
$string['questionnaireopens'] = 'Abertura da enquete';
$string['questionnaire:preview'] = 'Prévia da enquete';
$string['questionnaire:printblank'] = 'Imprimir enquete em branco';
$string['questionnaire:readallresponseanytime'] = 'Ler todas as respostas em qualquer instante';
$string['questionnaire:readallresponses'] = 'Ler resumo de respostas, sujeito ao horário de abertura';
$string['questionnaire:readownresponses'] = 'Ler as próprias respostas';
$string['questionnairereport'] = 'Relatório da Enquete';
$string['questionnaire:submit'] = 'Completar e enviar uma enquete';
$string['questionnaire:view'] = 'Visualizar enquete';
$string['questionnaire:viewsingleresponse'] = 'Visualizar respostas individuais';
$string['questionnum'] = 'Questão #';
$string['questions'] = 'Questões';
$string['questionsinsection'] = 'Questões nesta seção:';
$string['questiontypes'] = 'Tipos de Questões';
$string['questiontypes_help'] = 'Verifique a documentação do Moodle abaixo';
$string['radiobuttons'] = 'Botões de Rádio';
$string['radiobuttons_help'] = 'Neste tipo de seleção, o respondente precisa selecionar uma das escolhar oferecidas.';
$string['rank'] = 'Rank';
$string['ratescale'] = 'Avaliação/Escala';
$string['ratescale_help'] = 'Verifique a documentação Moodle abaixo';
$string['realm'] = 'Tipo de Enquete';
$string['realm_help'] = '* ** Há três tipos de questionários: **
* Privada  - pertence ao curso é definido em apenas.
* Modelo  - pode ser copiado e editado.
* Pública  - pode ser compartilhado entre os cursos.';
$string['redirecturl'] = 'A URL para a qual o usuário é redirecionado após completar esta enquete.';
$string['remove'] = 'Remover';
$string['removeallquestionnaireattempts'] = 'Deletar todas as respostas da enquete';
$string['removenotinuse'] = 'Esta enquete dependia de uma enquete pública que foi deletada.
Ela já não pode ser utilizada e deve ser deletada.';
$string['required'] = 'Resposta obrigatória';
$string['required_help'] = 'Se você selecionar  ***Sim***, a resposta a esta pergunta será obrigatória, ou seja, o respondente não será capaz de enviar o questionário até que esta pergunta seja respondida.';
$string['requiredparameter'] = 'Um parâmetro obrigatório não foi informado.';
$string['reset'] = 'Limpar';
$string['respeligiblerepl'] = '(substituído por sobreposição de permissões)';
$string['respondent'] = 'Respondente';
$string['respondenteligibleall'] = 'todos';
$string['respondenteligiblestudents'] = 'apenas estudantes';
$string['respondenteligibleteachers'] = 'apenas professores';
$string['respondents'] = 'Respondentes';
$string['respondenttype'] = 'Tipo do respondente';
$string['respondenttypeanonymous'] = 'anônimo';
$string['respondenttypefullname'] = 'nome completo';
$string['respondenttype_help'] = 'Você pode exibir nomes de seus usuários completos com cada resposta, definindo-o como &quot;fullname&quot;. Você pode ocultar identidades de seus usuários a partir das respostas, definindo-o como &quot;anônimo&quot;.';
$string['response'] = 'Resposta';
$string['responsefieldlines'] = 'Tamanho da caixa de entrada';
$string['responseformat'] = 'Formato de resposta';
$string['responseoptions'] = 'Opções de respostas';
$string['responses'] = 'Respostas';
$string['responseview'] = 'Estudantes podem visualizar TODAS as respostas';
$string['responseview_help'] = 'Você pode especificar quem pode ver as respostas de todos os respondentes aos questionários apresentados (tabelas gerais de estatísticas).';
$string['responseviewstudentsalways'] = 'Sempre';
$string['responseviewstudentsnever'] = 'Nunca';
$string['responseviewstudentswhenanswered'] = 'Depois de responder a enquete';
$string['responseviewstudentswhenclosed'] = 'Depois de encerrada a enquete';
$string['restrictedtoteacher'] = 'Estas funções são restritas aos professores!';
$string['resume'] = 'Salvar/Retomar respostas';
$string['resume_help'] = 'Definir esta opção permite que os usuários salvem suas respostas a um questionário antes de submetê-los.
Os usuários podem deixar o questionário inacabado e retomada a partir do ponto de salvaguarda em uma data posterior.';
$string['resumesurvey'] = 'Retomar enquete';
$string['return'] = 'Retornar';
$string['save'] = 'Salvar preenchimento parcial';
$string['saveasnew'] = 'Salvar como Nova Questão';
$string['savedbutnotsubmitted'] = 'Esta enquete foi salva, mas ainda não foi enviada.';
$string['savedprogress'] = 'Suas respostas foram salvas. Você pode retornar em qualquer instante para completar esta enquete e enviá-la.';
$string['saveeditedquestion'] = 'Salvar questão {$a}';
$string['savesettings'] = 'Salvar opções';
$string['section'] = 'Descrição';
$string['sectionbreak'] = '----- Quebra de Página -----';
$string['sectionbreak_help'] = '----- Quebra de página -----';
$string['sectionsnotset'] = 'Você deve selecionar pelo menos uma questão por seção! <br /> Seção(ões) não selecionada(s): {$a}';
$string['sectiontext'] = 'Rótulo';
$string['sectiontext_help'] = 'Esta não é uma questão mas um breve texto que será exibido para introduzir uma série de questões.';
$string['selecttheme'] = 'Selecione um tema (css) a ser usado nesta enquete.';
$string['send'] = 'Enviar';
$string['sendemail'] = 'Envia uma cópia contendo os dados de cada submissão para o endereço de email informado. Deixe em branco caso não desejes receber cópias.';
$string['sendemail_help'] = 'Envia uma cópia de cada envio para o endereço especificado ou endereços. Você pode fornecer mais de um endereço separando-os com vírgulas. Deixe em branco para nenhum backup de e-mail.';
$string['send_message'] = 'Enviar mensagem para os usuários selecionados';
$string['send_message_to'] = 'Enviar mensagem para:';
$string['settings'] = 'Opções';
$string['settingssaved'] = 'Opções salvas';
$string['show_nonrespondents'] = 'Não respondentes';
$string['started'] = 'Iniciado';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['subject'] = 'Assunto';
$string['submitoptions'] = 'Opções de envio';
$string['submitpreview'] = 'Enviar prévia';
$string['submitpreviewcorrect'] = 'Esta submissão seria aceita como corretamente preenchida.';
$string['submitsurvey'] = 'Enviar enquete';
$string['submitted'] = 'Enviada em:';
$string['subtitle'] = 'Subtítulo';
$string['subtitle_help'] = 'Subtítulo deste questionnaire. Aparece abaixo do título na primeira página apenas.';
$string['summary'] = 'Sumário';
$string['surveynotexists'] = 'enquete does not exist.';
$string['surveyowner'] = 'Você precisa ser o proprietário da enquete para poder executar esta operação.';
$string['surveyresponse'] = 'Respostas da enquete';
$string['template'] = 'Modelo';
$string['templatenotviewable'] = 'Enquetes modelo não são visualizáveis.';
$string['text'] = 'Texto da Questão';
$string['textareacolumns'] = 'Colunas da caixa de texto';
$string['textareacolumns_help'] = 'sta questão irá exibir uma caixa de texto simples, com ** x *** Textarea colunas * (área ou * largura *) e ** y *** Textarea linhas * (número de linhas de texto * *). Se você deixar ambos x e y ao padrão ** 0 ** valor (ou, se você configurá-lo para ** 0 **), então editor de HTML será exibido com altura padrão e largura (se disponível no contexto do curso / usuário e perfil do usuário).';
$string['textarearows'] = 'Linhas da caixa de texto';
$string['textbox'] = 'Caixa de Texto';
$string['textbox_help'] = 'Para o tipo de questão Caixa de Texto, introduza o comprimento caixa de entrada e o comprimento do texto máximo de texto a ser digitado pelo entrevistado. Os valores padrão são 20 caracteres para a largura da caixa de entrada e 25 caracteres para o comprimento máximo do texto digitado.';
$string['textdownloadoptions'] = 'Opções para baixar respostas em formato CSV';
$string['thank_head'] = 'Gratos por completar esta Enquete.';
$string['theme'] = 'Tema';
$string['thismonth'] = 'este mês';
$string['thisresponse'] = 'Esta resposta';
$string['thisweek'] = 'esta semana';
$string['title'] = 'Título';
$string['title_help'] = 'Título deste questionário, que aparecerá no topo de cada página. Por título padrão é definido como o nome do questionário, mas você pode editá-lo como quiser.';
$string['today'] = 'hoje';
$string['total'] = 'Total';
$string['type'] = 'Tipo de Questão';
$string['undefinedquestiontype'] = 'Tipo de questão não identificado';
$string['unknown'] = 'Desconhecido';
$string['unknownaction'] = 'Especificada uma ação desconhecida para enquetes...';
$string['url'] = 'URL de confirmação';
$string['url_help'] = 'A URL para a qual um usuário é redirecionado depois de completar este questionário.';
$string['useprivate'] = 'Copiar existente';
$string['usepublic'] = 'Usar pública';
$string['usetemplate'] = 'Copiar existente';
$string['vertical'] = 'Vertical';
$string['view'] = 'Visualizar';
$string['viewallresponses'] = 'Visualizar Todas as Respostas';
$string['viewallresponses_help'] = 'Se o questionário está definido para o  ** modo de grupo**: *Grupos visíveis* , ou está definido para  *Grupos separados * e o usuário atual
  tem o *moodle / site: accessallgroups* capacidade (no contexto atual), e os grupos foram definidos no curso atual,  em seguida, o usuário tem acesso a uma lista suspensa de grupos. Esta lista suspensa permite que o usuário "filtrar" as respostas ao questionário por parte de grupos.  Se a definição for ** Modo Grupo **: *Grupos separados* , os usuários que não têm o *moodle / site: accessallgroups* capacidade (normalmente estudantes ou professores não-edição, etc.) só vai ser capaz de ver as respostas do grupo (s) a que pertencem.';
$string['viewbyresponse'] = 'Lista de respostas';
$string['viewindividualresponse'] = 'Respostas individuais';
$string['viewindividualresponse_help'] = 'Clique sobre os nomes dos respondentes na lista abaixo para visualizar as respostas individuais.';
$string['viewresponses'] = 'Todas as respostas ({$a})';
$string['viewyourresponses'] = 'Suas Respostas {$a}';
$string['warning'] = 'Warning, error encountered.';
$string['wronganswers'] = 'Há algo de errado com as suas respostas (veja abaixo)';
$string['wrongdateformat'] = 'A data fornecida: <strong>{$a}</strong> não está no formato apresentado no exemplo.';
$string['wrongdaterange'] = 'ERRO! O ano deve estar no intervalo entre 1902 e 2037.';
$string['wrongformat'] = 'Há alguma coisa errada com sua resposta para a questão:';
$string['wrongformats'] = 'Há alguma coisa errada com sua resposta para as questões:';
$string['yesno'] = 'Sim/Não';
$string['yesno_help'] = 'Questão simples Sim/Não.';
$string['yourresponse'] = 'Sua resposta';
$string['yourresponses'] = 'Suas respostas';
