<?php

require_once 'modules/admin/models/StatusAliasGateway.php';
require_once 'modules/clients/models/ObjectCustomFields.php';

/**
 * Home Module's Action Controller
 *
 * @category   Action
 * @package    Home
 * @author     Alberto Vasquez <alberto@clientexec.com>
 * @license    http://www.clientexec.com  ClientExec License Agreement
 * @link       http://www.clientexec.com
 */
class Home_IndexpublicController extends CE_Controller_Action
{
    var $moduleName = "home";


    protected function loginAction()
    {
        $this->title = $this->user->lang('Login');

        //do not know what I really need to do here just yet
        if (isset($_REQUEST['needstologin'])) {
            $this->view->showloginneededwarning = true;
        } else {
            $this->view->showloginneededwarning = false;
        }

        if (@$_GET['return']) {
            $this->session->redirectUserVoice = $_GET['return'];
        } else if (@$_GET['return_ext_url']) {
            $this->session->return_ext_url = $_GET['return_ext_url'];
        }

        $forgot = $this->getParam('forgot', FILTER_SANITIZE_NUMBER_INT, 0);
        if ($forgot == 1) {
            $this->view->showForgot = true;
        } else {
            $this->view->showForgot = false;
        }

        $register = $this->getParam('register', FILTER_SANITIZE_NUMBER_INT, 0);
        if ($register == 1) {
            // Force show forgot to be false, so we only show register\
            $this->view->showRegister = true;
            $this->view->showForgot = false;
        } else {
            $this->view->showRegister = false;
        }

        $this->cssPages = array("templates/default/views/home/indexpublic/login.css");
        $this->jsLibs = array("templates/default/views/home/indexpublic/login.js");

        $this->view->allowRegistration = $this->settings->get('Allow Registration');
        $this->view->captcha = $this->settings->get('Request Access Code') == 1;
    }

    protected function invalidlicenseAction()
    {
        $licenseDefender = new LicenseDefender();
        $licenseDefender->resetLicenseIfNecessary();
        if ($licenseDefender->validateLicense()) {
            CE_Lib::redirectPage("index.php");
            return;
        }

        $this->cssPages = array("templates/default/views/home/indexpublic/invalidlicense.css");
        $this->view->gHideStyle = true;
    }

    protected function resetpwdAction()
    {
        $this->disableLayout(false);
    }

    protected function registerAction()
    {
        $this->disableLayout(false);
        $this->view->showCaptcha = false;
        if ($this->settings->get('Request Access Code') == 1) {
            if ( $this->settings->get('ReCaptcha Public Key') != '' ) {
                $this->view->captchaPublicKey = $this->settings->get('ReCaptcha Public Key');
            } else {
                $this->view->captchaPublicKey = '6LcFBRAUAAAAAEldd6qeKfixg2HTEw4n7tUb0AAH';
            }
            $this->view->showCaptcha = true;
        }
    }

    protected function resetpasswordAction()
    {

        $clean_email_address = htmlspecialchars($this->getParam('customerEmail', FILTER_SANITIZE_STRING), ENT_QUOTES);

        try {
            $emailSent = $this->sendConfirmationEmail($clean_email_address, 'reset');
            if (!$emailSent) {
                CE_Lib::log(3, "Unable to reset password because the provided email address (%s) is not a registered one.", $clean_email_address);
                $this->error = true;
                $this->message = $this->user->lang( "Invalid Email Address");
                $this->send();
                return;
            }
        } catch (Exception $ex) {
            $this->error = true;
            $this->message = $ex->getMessage();
            $this->send();
            return;
        }

        $this->send();
    }

    /**
     * Sends confirmation email when requesting password change
     *
     * @param string $email           email to send confirmation text to
     * @param string $type            type of email to send: 'reset' or 'activate'
     *
     * @return bool
     */
    protected function sendConfirmationEmail($email, $type='reset')
    {
        include_once 'modules/admin/models/StatusAliasGateway.php';
        include_once 'library/CE/NE_MailGateway.php';

        if ($email == '') {
            return false;
        }

        include_once 'modules/support/models/AutoresponderTemplateGateway.php';
        $templategateway = new AutoresponderTemplateGateway();

        if ($type == 'reset') {
            $template = $templategateway->getEmailTemplateByName("Forgot Password Template");
        } else {
            $template = $templategateway->getEmailTemplateByName("Activate Account Template");
        }

        $mailGateway = new NE_MailGateway();

        $bolReturnValue=false;
        $tClientID = 0;

        $ip = CE_Lib::getRemoteAddr();
        $host = @gethostbyaddr($ip);
        if ($host) {
            $host = "($host)";
        }

        $query = 'SELECT userid '
                .'FROM user_customuserfields uc '
                .'LEFT JOIN customuserfields c ON uc.customid=c.id '
                .'WHERE uc.value=? AND c.type=? ';
        $result = $this->db->query($query, $email, typeEMAIL);

        $supportMail = $this->settings->get("Support E-mail");
        if ( $supportMail == '' ) {
            throw new Exception('Support Email is not defined');
        }

        if ($result->getNumRows() > 0) {
            list($tClientID) = $result->fetch();
            $tmyUser = new User($tClientID);
            $statusGateway = StatusAliasGateway::getInstance($this->user);

            if ($type == 'reset') {
                // Don't let pending or fraud users reset their password
                if (in_array($tmyUser->getStatus(), $statusGateway->getUserStatusIdsFor(array(USER_STATUS_PENDING, USER_STATUS_FRAUD)))) {
                    throw new Exception($tmyUser->lang('Your account is not active'));
                }
            } else {
                // Don't let fraud users reset their password
                if (in_array($tmyUser->getStatus(), $statusGateway->getUserStatusIdsFor(USER_STATUS_FRAUD))) {
                    throw new Exception($tmyUser->lang('Your account is not valid'));
                }
            }

            $emailBodyArr = $template->getContents();
            $strSubjectEmailString = $template->getSubject();
            $templateID = $template->getId();
            if ($templateID !== false) {
                include_once 'modules/admin/models/Translations.php';
                $languages = CE_Lib::getEnabledLanguages();
                $translations = new Translations();
                $languageKey = ucfirst(strtolower($tmyUser->getRealLanguage()));
                CE_Lib::setI18n($languageKey);

                if (count($languages) > 1) {
                    $strSubjectEmailString = $translations->getValue(EMAIL_SUBJECT, $templateID, $languageKey, $strSubjectEmailString);
                    $emailBodyArr = $translations->getValue(EMAIL_CONTENT, $templateID, $languageKey, $emailBodyArr);
                }
            }

            if ($type == 'reset') {
                $action = "confirmpasswordlost";
            } else {
                $action = "confirmactivateaccount";
            }

            $emailBodyArr = str_replace(array("[COMPANYNAME]","%5BCOMPANYNAME%5D"), $this->settings->get("Company Name"), $emailBodyArr);
            $emailBodyArr = str_replace(array("[COMPANYADDRESS]","%5BCOMPANYADDRESS%5D"), $this->settings->get("Company Address"), $emailBodyArr);
            $emailBodyArr = str_replace("[CLIENTNAME]", $tmyUser->getFullName(true), $emailBodyArr);
            $emailBodyArr = str_replace("[FIRSTNAME]", $tmyUser->getFirstName(), $emailBodyArr);
            $emailBodyArr = str_replace("[CLIENTEMAIL]", $tmyUser->getEmail(), $emailBodyArr);
            $emailBodyArr = str_replace(array("[REQUESTIP]","%5BREQUESTIP%5D"), "$ip $host", $emailBodyArr);
            $emailBodyArr = str_replace(
                array("[CONFIRMATION URL]","%5BCONFIRMATION%20URL%5D"),
                CE_Lib::getSoftwareURL()."/index.php?fuse=home&action=".$action."&value=".md5(strtoupper($email))."&s=C1Ex".$tClientID."x58&public=1",
                $emailBodyArr
            );
            $emailBodyArr = CE_Lib::replaceCustomFields($this->db, $emailBodyArr, $tClientID, $this->settings->get('Date Format'));

            $strSubjectEmailString = str_replace(array("[COMPANYNAME]","%5BCOMPANYNAME%5D"), $this->settings->get("Company Name"), $strSubjectEmailString);
            $strSubjectEmailString = str_replace(array("[COMPANYADDRESS]","%5BCOMPANYADDRESS%5D"), $this->settings->get("Company Address"), $strSubjectEmailString);
            $strSubjectEmailString = str_replace("[CLIENTNAME]", $tmyUser->getFullName(true), $strSubjectEmailString);
            $strSubjectEmailString = str_replace("[FIRSTNAME]", $tmyUser->getFirstName(), $strSubjectEmailString);
            $strSubjectEmailString = str_replace("[CLIENTEMAIL]", $tmyUser->getEmail(), $strSubjectEmailString);
            $strSubjectEmailString = str_replace(array("[REQUESTIP]","%5BREQUESTIP%5D"), "$ip $host", $strSubjectEmailString);
            $strSubjectEmailString = str_replace(
                array("[CONFIRMATION URL]","%5BCONFIRMATION%20URL%5D"),
                CE_Lib::getSoftwareURL()."/index.php?fuse=home&action=".$action."&value=".md5(strtoupper($email))."&s=C1Ex".$tClientID."x58&public=1",
                $strSubjectEmailString
            );

            $mailSend = $mailGateway->sendMailMessage(
                $emailBodyArr,
                $supportMail,
                $this->settings->get("Company Name"),
                $tmyUser->getId(),
                '',
                $strSubjectEmailString,
                3,
                0,
                'notifications',
                '',
                '',
                MAILGATEWAY_CONTENTTYPE_HTML
            );
            if (!is_a($mailSend, 'NE_Error')) {
                if ($type == 'reset') {
                    include_once 'modules/clients/models/Client_EventLog.php';
                    $clientsEventLog = Client_EventLog::newInstance(false, $tClientID, $tClientID, CLIENT_EVENTLOG_RESQUESTED_RESET_PASSWORD, $tClientID);
                    $clientsEventLog->save();
                }
                return true;
            }

            return $mailSend;

        } else {
            $bolReturnValue = false;
        }
        return $bolReturnValue;
    }

    protected function confirmactivateaccountAction()
    {
        $this->confirmpasswordlostAction('activate');
    }


    protected function confirmpasswordlostAction($type='reset')
    {
        include_once 'library/CE/NE_MailGateway.php';

        $userGateway = new UserGateway($this->user);

        $value = $_REQUEST['value'];

        //convert value2 to a valid userid
        $value2 = $_REQUEST['s'];
        $value2 = mb_substr($value2, 4);
        $pos = strpos($value2, 'x');
        $value2 = mb_substr($value2, 0, $pos);

        $query = 'SELECT userid, value '
                .'FROM user_customuserfields uc '
                .'LEFT JOIN customuserfields c ON uc.customid=c.id '
                .'WHERE userid=? AND c.type=?';
        $result = $this->db->query($query, $value2, typeEMAIL);

        $generatePassword = true;
        // When activating must be a new customer without packages
        if ($type == 'activate') {
            $query2 = 'SELECT COUNT(*) '
                     .'FROM domains '
                     .'WHERE CustomerID=?';
            $result2 = $this->db->query($query2, $value2);
            list($tCountPackages) = $result2->fetch();
            if ($tCountPackages > 0) {
                $generatePassword = false;
            }
        }

        if ($result->getNumRows() > 0 && $generatePassword) {
            list($tUserID,$email) = $result->fetch();
            //confirm that this is a url we sent
            $email = rtrim($email);
            if (md5(strtoupper($email)) == $value) {
                $tUser = new User($tUserID);
                if ($type == 'activate') {
                    $tUser->activate();
                }
                $tNewPassword = CE_Lib::generatePassword();
                $tUser->setPassword($tNewPassword);
                $tUser->save();

                include_once 'modules/clients/models/Client_EventLog.php';
                $clientsEventLog = Client_EventLog::newInstance(false, $tUserID, $tUserID, CLIENT_EVENTLOG_PASSWORD_RESET, $tUserID);
                $clientsEventLog->save();

                $mailGateway = new NE_MailGateway();
                $mailSend = $mailGateway->sendMailMessage(
                    $userGateway->getNewPasswordEmail($tUser, $tNewPassword, $type),
                    $this->settings->get('Support E-mail'),
                    $this->settings->get('Company Name'),
                    $tUserID,
                    '',
                    $userGateway->getNewPasswordSubject($tUser, $tNewPassword, $type),
                    3,
                    0,
                    'notifications',
                    '',
                    '',
                    $tUser->isHTMLMails()? MAILGATEWAY_CONTENTTYPE_HTML : MAILGATEWAY_CONTENTTYPE_PLAINTEXT
                );
                if (!is_a($mailSend, 'NE_Error')) {
                    $message = $this->user->lang("Password has been sent to %s", $email);
                } else {
                    $message = $mailSend->getMessage();
                }
            } else {
                $message = $this->user->lang('Confirmation URL is corrupt');
            }
        } else {
            $message = $this->user->lang('Confirmation URL is corrupt');
        }

        CE_Lib::redirectPage('index.php?fuse=home&view=Login', $message);
    }

    protected function createaccountAction()
    {

        include_once 'modules/clients/models/UserGateway.php';

        $clean_email_address = htmlspecialchars($this->getParam('guestEmail', FILTER_SANITIZE_STRING), ENT_QUOTES);
        $clean_first_name = htmlspecialchars($this->getParam('guestFirstName', FILTER_SANITIZE_STRING), ENT_QUOTES);
        $clean_last_name = htmlspecialchars($this->getParam('guestLastName', FILTER_SANITIZE_STRING), ENT_QUOTES);

        try {
            if ($this->settings->get('Request Access Code') == 1) {
                if ( $this->settings->get('ReCaptcha Private Key') != "" ) {
                    $privateKey = $this->settings->get('ReCaptcha Private Key');
                } else {
                    $privateKey = "6LcFBRAUAAAAAEfj_K9tzddySFYkJjqEPqedfM5C"; // Use ours if none set
                }

                $recaptcha = new \ReCaptcha\ReCaptcha($privateKey, new \ReCaptcha\RequestMethod\SocketPost());
                $resp = $recaptcha->verify($_REQUEST['g-recaptcha-response'], CE_Lib::getRemoteAddr());

                if (!$resp->isSuccess()) {
                    CE_Lib::log(2, "New user registration: Invalid Captcha Response");
                    throw new Exception($this->user->lang('Failed Captcha'));
                }
            }

            $userGateway = new UserGateway($this->user);
            $userGateway->quick_user_create($clean_email_address, $clean_first_name, $clean_last_name);
            $this->sendConfirmationEmail($clean_email_address, 'activate');
        } catch (Exception $ex) {
            $this->error = true;
            $this->message = $ex->getMessage();
            $this->error_code = '2332'; // random num to identify invalid captcha
            $this->send();
            return;
        }

        $this->send();
    }

    protected function mainAction()
    {
        $languages = CE_Lib::getEnabledLanguages();
        include_once 'modules/admin/models/Translations.php';
        $translations = new Translations();
        $languageKey = ucfirst(strtolower($this->user->getLanguage()));

        // used to figure module in translations
        $_REQUEST['fuse'] = $_GET['fuse'] = 'home';

        $settings = new CE_Settings();
        $this->title = $this->user->lang('Home');

        $this->cssPages = array("templates/default/views/home/indexpublic/main.css");
        $this->jsLibs = array("templates/default/views/home/indexpublic/main.js");

        //let's get list of faqs
        include_once 'modules/knowledgebase/models/KBArticleListGateway.php';
        include_once 'modules/admin/models/ActiveOrderGateway.php';
        $aogateway = new ActiveOrderGateway($this->user);
        $this->view->summary = $aogateway->getCartSummary();

        $sort = array("field"=>"modified","dir"=>"desc");
        $gateway = new KBArticleListGateway();
        $faqs = $gateway->getArticleList($this->user, 0, 15, "faq", 0, $sort, true, null, $languageKey);
        $this->view->faqs = $faqs['data'];
        $this->view->announcements = array();
        $this->view->latestarticles = array();

        if ($this->user->hasPermission('clients_view_announcements')) {
            // Get latest announcement
            include_once 'modules/admin/models/Announcements.php';
            $announcements = new Announcements($this->user);
            $this->view->announcements = $announcements->getLastPublicAnnouncements($this->settings->get('Number of Announcements To Show On Main Page'));
        }

        include_once 'modules/knowledgebase/models/KB_ArticleGateway.php';
        //get latest articles
        $catGateway = new KB_CategoryGateway($this->user);
        $this->view->latestarticles = $catGateway->parseLatestArticles($languageKey);

        $articleGW = new KB_ArticleGateway($this->user);
        $this->view->populararticles = $articleGW->getMostPopularArticles(5, $languageKey);

        $this->view->show_series_name = "";
        if ($settings->get('Show Global Series Separately')) {
            $series = $articleGW->getAllSeries(false);
            if (count($series) > 0) {

                //let's pull the first article for first category in global series
                $articles = current($series);
                if (count($articles) > 0) {
                    $article = $articles[0];

                    $name = $settings->get('Global Series Name');
                    $GlobalSeriesNameSettingId = $settings->getSettingIdForName('Global Series Name');

                    $subname = $settings->get('Global Series Subtitle');
                    $GlobalSeriesSubtitleSettingId = $settings->getSettingIdForName('Global Series Subtitle');

                    if (count($languages) > 1) {
                        if ($GlobalSeriesNameSettingId !== false) {
                            $name = $translations->getValue(SETTING_VALUE, $GlobalSeriesNameSettingId, $languageKey, $name);
                        }
                        if ($GlobalSeriesSubtitleSettingId !== false) {
                            $subname = $translations->getValue(SETTING_VALUE, $GlobalSeriesSubtitleSettingId, $languageKey, $subname);
                        }
                    }

                    if (trim($name) == "") {
                        $name = $this->user->lang("Documentation");
                    }
                    if (trim($subname) == "") {
                        $subname = '';
                    }

                    $kbArticle = new KB_Article($article['art_id']);

                    $this->view->show_series_name = $name;
                    $this->view->show_series_subname = $subname;
                    $this->view->seriesURL = $kbArticle->generateLink();
                }

            }

        }

        $this->view->showLatestArticles = ($settings->get('Number of Latest Articles') > 0 && count($this->view->latestarticles) > 0 );
    }

    /**
     * Public home page ... not logged in
     * @publicview true
     * @return void
     */
    protected function dashboardAction()
    {
        $this->title = $this->user->lang('Dashboard');

        include_once "modules/admin/models/ServerGateway.php";
        include_once 'modules/support/models/TicketGateway.php';
        include_once "modules/billing/models/InvoiceListGateway.php";
        include_once 'modules/billing/models/Currency.php';
        include_once "modules/admin/models/PluginGateway.php";

        //if not logged in show login instead
        //$this->view->loggedIn = true;
        if ( $this->user->getId() == 0 || $this->user->isAdmin()) {
            $_REQUEST['needstologin'] = true;
            $this->_forward("login");
            return;
        }

        $this->cssPages = array(
            'templates/default/views/home/indexpublic/dashboard.css',
            'templates/default/views/clients/productspublic/products.css',
        );
        $this->jsLibs = array('templates/default/views/home/indexpublic/dashboard.js');

        // only include products.js if we are showing the product list.
        if ( $this->view->templateOptions['Show Product List in Dashboard']['value'] == 'Yes') {
            $this->jsLibs[] = 'templates/default/views/clients/productspublic/products.js';
        }

        //let's see if we have any status messages
        $server_gateway = new ServerGateway($this->user);
        $servers = $server_gateway->getServerIdsForUser($this->user);
        $this->view->servers_status_messages = array();
        foreach ($servers as $server) {

            $t_server = $server_gateway->getServer($server);
            if (trim($t_server['status_message']) != "") {
                $this->view->servers_status_messages[] = $t_server;
            }

        }

        $ticketGateway = new TicketGateway($this->user);
        list($tickets_iterator) = $ticketGateway->GetTickets($this->user, 10, 0, 'datesubmitted', 'DESC', 'open', $this->user->getId());

        $customCols = array();
        $this->view->customCols = array();
        foreach (ObjectCustomFields::getCustomFieldsByType('tickettypes') as $obj) {
            if (!$obj['isAdminOnly'] && $obj['isChangeable'] && $obj['showingridportal']) {
                $customCols[$obj['id']] = $obj['text'];
            }
        }

        $tickets = array();
        while ($ticket = $tickets_iterator->fetch()) {

            // check if all repsonses are private, and do not show this if they are.
            if ( $ticketGateway->getCountOfNonPrivateMsgsForTicketId($ticket->id) == 0 ) {
                 continue;
            }

            $a_ticket = $ticket->toArray();
            $a_ticket['ticketStatus'] = $this->user->lang($ticket->getStatus());
            $a_ticket['datesubmitted'] = date('F j, Y', strtotime($a_ticket['datesubmitted']));

            $a_ticket['customfields'] = array();

            $customFieldsIds = $ticket->getCustomFieldsIds();
            foreach ($customCols as $id => $label) {
                if ($customFieldsIds) {
                    $ids = explode(chr(29), $customFieldsIds);
                    $values = explode(chr(29), $ticket->getCustomFieldsValues());
                    if (($key = array_search($id, $ids)) !== false) {
                        if (!isset($this->view->customCols[$id])) {
                            $this->view->customCols[$id] = $label;
                        }
                        $a_ticket['customfields'][$id] = $values[$key];
                    } elseif (isset($this->view->customCols[$id])) {
                        $a_ticket['customfields'][$id] = '';
                    }
                } elseif (isset($this->view->customCols[$id])) {
                    $a_ticket['customfields'][$id] = '';
                }
            }
            $tickets[] = $a_ticket;

        }
        $this->view->tickets = $tickets;

        //Let's get invoices

        $currency = new Currency($this->user);
        $invoiceGateway = new InvoiceListGateway($this->user);
        $filter = array();
        $filter['b.status'] = array(0,5);

        $plugin_gateway = new PluginGateway($this->user);
        $plugin = $plugin_gateway->getPluginByName("gateways", $this->user->getPaymentType());
        // $plugin might be null
        if ($plugin) {
            $this->view->accepts_cc = $plugin->getVariable("Accept CC Number");
            $this->view->payment_type_name = $plugin->getVariable("Signup Name");
        }

        $invoices_iterator = $invoiceGateway->get_invoices_by_user($this->user->getId(), 'id desc', $filter);
        $invoices = array();
        while ($invoice = $invoices_iterator->fetch()) {
            $a_invoice = $invoice->toArray();
            $tinvoice = new Invoice($a_invoice['id']);
            if (!$tinvoice->isPaid() && !$tinvoice->isVoid() && !$tinvoice->isPending() && $invoice->getSubscriptionID() == '' && !@$this->view->accepts_cc) {
                $a_invoice['showpaybutton'] = true;
            } else {
                $a_invoice['showpaybutton'] = false;
            }
            $a_invoice['status_name'] = $this->user->lang($tinvoice->getStatusName());

            $a_invoice['balancedueraw'] = $a_invoice['balancedue'];
            $a_invoice['balancedue'] = $currency->format($this->user->getCurrency(), $a_invoice['balancedue'], true);
            $invoices[] = $a_invoice;
        }

        $this->view->invoices = $invoices;

        $this->view->payment_method = $this->user->getPaymentType();

        if ($this->user->hasPermission('clients_view_announcements')) {
            // Get latest announcement
            include_once 'modules/admin/models/Announcements.php';
            $announcements = new Announcements($this->user);
            $this->view->announcements = $announcements->getLastPublicAnnouncements(1);
        }
    }
}
