<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'via', language 'fr', branch 'MOODLE_28_STABLE'
 *
 * @package   via
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['absent'] = 'Absent';
$string['accessactivity'] = 'Accéder à votre activité :';
$string['activity_deleted'] = 'L\'activité Via a été supprimée directement dans l\'environnement Via par un utilisateur. Il est donc impossible d\'y accéder. Nous vous recommandons de supprimer cette activité dans Moodle et d\'en créer une nouvelle.';
$string['activitydeletion'] = 'Limiter la suppression d\'activité';
$string['activitydeletiondesc'] = 'Si cette case est cochée, les activitiés seront supprimées dans Moodle, mais pas dans Via.';
$string['activitydone'] = 'Cette activité est terminée.';
$string['activitytitle'] = 'Titre de l\'activité';
$string['activitywaserased'] = 'Impossible de trouver cette activité sur le serveur SVI. Elle semble avoir été supprimée.';
$string['adminid_nosuccess'] = 'La clé moodle n\'est pas valide.';
$string['adminid_success'] = 'La clé moodle a été testée avec succèss.';
$string['adminid_toolow'] = 'Les droits de l\'utilisateur ne permettront pas la création d\'activités, veuillez contacter l\'administrateur du site pour faire augmenter les droits.';
$string['adminnotrenrolled'] = 'En tant qu\'administrateur vous avez accès à l\'activité malgré ne pas être inscrit.';
$string['animator'] = 'Animateur';
$string['animators'] = 'Animateurs';
$string['apiconfig'] = 'Configuration de l\'API - étape 1';
$string['apiid'] = 'Clé API (ApiID)';
$string['apiidsetting'] = 'Identifiant unique donné à ceux qui communiquent avec l\'API. Cette donnée est comparée avec l\'IP du serveur appelant.';
$string['apiurl'] = 'URL de l\'API de Via';
$string['apiurlsetting'] = 'URL de base de l\'API pour Via';
$string['attending'] = 'Je participerai';
$string['audiomodelabel'] = 'Mode audio pour la conférence';
$string['audiorecord'] = 'Audio (MP3)';
$string['audiorecordinfo'] = 'Audio seulement';
$string['automatic'] = 'Automatique';
$string['automaticenrol'] = 'Inscription automatique';
$string['availabledate'] = 'Disponible dès le';
$string['awaitingauthorization'] = 'En attente d\'autorisation (manuelle)';
$string['backup'] = 'Inclure dans la sauvegarde de cours';
$string['backupdesc'] = 'Si cette case est cochée, les tableaux blancs et sondages d\'une activité seront inclus dans la sauvegarde du cours. Les documents sont toujours inclus dans ce processus tandis que l\'ajout des utilisateurs est facultatif.';
$string['backup_options'] = 'Sauvegarde d\'activité et les options de duplication';
$string['basedon'] = 'Le statut de présence est basé sur {$a} minutes.';
$string['by'] = 'par';
$string['cancel'] = 'Annuler';
$string['cat_check'] = 'Ajouter';
$string['cat_default'] = 'Par défaut';
$string['categoriesheader'] = 'Catégories';
$string['category'] = 'Choisissez une catégorie';
$string['cat_intro'] = 'Choisissez les catégories de Via que vous voulez rendre disponible dans Moodle.';
$string['cat_name'] = 'Noms des catégories';
$string['cats_modified'] = 'Les catégories ont été modifiées avec succès';
$string['choosecategories'] = 'Configurez les catégories';
$string['choosepresentor'] = 'Un seul présentateur peut être associé à l\'activité. Pour choisir un nouveau présentateur, simplement ajouter un utilisateur comme présentateur. Il sera automatique substitué.';
$string['cieid'] = 'Clé Via (CieID)';
$string['cieidsetting'] = 'Identifiant de l\'organisation à laquelle l\'utilisateur est associé dans Via.';
$string['config'] = 'Configuration';
$string['configassist'] = 'Assistant de configuration';
$string['confirmation'] = 'Confirmation des participants';
$string['confirmationstatus'] = 'Confirmation de la présence';
$string['confirmdelete'] = 'Êtes-vous certain de vouloir supprimer cet enregistrement définitivement ?';
$string['confirmed'] = 'Présence confirmée';
$string['confirmneeded'] = 'Vous devez confirmer votre présence';
$string['connectsuccess'] = 'Connexion à l\'API réussie avec succès.';
$string['conntest'] = 'Test de connexion';
$string['copied'] = '- Copie';
$string['createdby'] = 'Rapport généré par :';
$string['creationdate'] = 'Date de création du rapport :';
$string['date'] = 'Date de l\'activité';
$string['delete'] = 'Supprimer';
$string['description'] = 'Description';
$string['donousewaitingroom'] = 'Ne pas utiliser (désactiver)';
$string['downloadplaybacks'] = 'Télécharger les enregistrements';
$string['downloadplaybacksdesc'] = 'Si cette case est cochée, les utilisateurs avec des roles d\'édition seront autorisés à télécharger des enregistrements  Via. Avant de cocher cette case, veuillez contacter SVIesolutions pour valider que votre serveur le permet.';
$string['duplication'] = 'Inclure dans la duplication';
$string['duplicationdesc'] = 'Si cette case est cochée, les tableaux blancs et sondages d\'une activité seront inclus  à la nouvelle activité créée pendant le processus de duplication. Les utilisateurs et les documents sont toujours inclus dans ce processus.';
$string['duration'] = 'Durée (minutes)';
$string['edit'] = 'Modifier';
$string['editrecord'] = 'Modification d\'un enregistrement';
$string['emails_alert_address'] = 'Courriels pour l\'envoie d\'avertissements';
$string['emails_alert_addressdesc'] = 'Adresses courriels pour l\'envoie des avertissements de débordement. Si plusieurs, séparer les adresses par des virgules.';
$string['enddate'] = 'Termine le';
$string['enroledanimators'] = 'Animateurs actuels à l\'activité « {$a->name} »';
$string['enroledparticipants'] = 'Participants actuels à l\'activité « {$a->name} »';
$string['enrolmentheader'] = 'Inscription des participants';
$string['enrolmenttype'] = 'Gestion de l\'inscription des participants';
$string['enrolmenttype_help'] = 'Inscription automatique : tous les utilisateurs inscrits au cours seront ajoutés à l\'activité Via. Si un étudiant est ajouté au cours après la création de l\'activité Via, il sera ajouté lors de la prochaine synchronisation du Cron. Si par compte il accède   à l\'activité avant que le cron l\'ait ajouté, il sera ajouté   à l\'affichage de la page des détails de l\'activité. Les utilisateurs inscrits avec des droits d\'édition dans le cours moodle seront automatiquement synchronisés comme animateurs, mais cette liste demeure éditable.
Inscription manuelle : les participants doivent être ajoutés   à partir de la liste des participants en choisissant le participant parmi la liste des « Participants potentiels » (droit) et ajoutés   à l\'aide de la flèche au "Participant actuel" (gauche). NB.  Dans les deux modes d\'inscription, l\'utilisateur qui créera l\'activité est ajouté comme présentateur de façon automatique, mais reste éditable, tout comme la liste des animateurs. Il n\'est pas possible d\'avoir plus d\'un présentateur.';
$string['error:ACTIVITY_ACCESS_FAILED'] = 'ACTIVITY_ACCESS_FAILED - Lorsque l\'utilisateur n\'est pas associé ou n\'a pas le droit d\'accès à cette rencontre ou que la rencontre n\'est pas encore accessible.';
$string['error:ACTIVITY_DOES_NOT_EXIST'] = 'ACTIVITY_DOES_NOT_EXIST - Doit représenter une activité valide.';
$string['error:ACTIVITYID_EMPTY'] = 'ACTIVITYID_EMPTY - La valeur ActivityID est vide.';
$string['error:ACTIVITYID_INVALID'] = 'ACTIVITYID_INVALID - La valeur passée dans le noeud ActivityID n\'est pas valide.';
$string['error:allseatstaken'] = 'Désolé, tous les sièges disponibles sur le serveur SVI sont pris. Vous ne pouvez donc pas accéder à cette activité pour le moment. Un avis vient d\'être envoyé aux responsables afin de les aviser du débordement. Vous pouvez également envoyé un courriel à <a href=\'mailto:$a->email?subject=Avis de debordement sur Via\'>{$a->email}</a> pour les aviser.<br><br> Veuillez réessayer de vous connecter plus tard.';
$string['error:APIID_NOT_FOUND'] = 'L\'ApiID n\'existe pas. Merci de vérifier les informations de configuration.';
$string['error:APPLY_PERIODICITY_INVALID'] = 'APPLY_PERIODICITY_INVALID - La valeur passée doit être 0 ou 1.';
$string['error:AUTH_FAILED_BAD_APIID'] = 'AUTH_FAILED_BAD_APIID - La valeur APIID n\'est pas authorisée.';
$string['error:AUTH_FAILED_BAD_CIEID'] = 'AUTH_FAILED_BAD_CIEID - La valeur CieID n\'est pas authorisée.';
$string['error:AUTH_FAILED_BAD_IP'] = 'AUTH_FAILED_BAD_IP - Contactez SVIeSolutions pour ajouter cette adresse IP à la liste IP autorisées.';
$string['error:_CANNOT_CHANGE_ISNEWVIA'] = 'CANNOT_CHANGE_ISNEWVIA - Une fois que l\'activité a été accédée, il n’est plus possible de modifier la version de Via pour celle-ci.';
$string['error:CANNOT_CHANGE_STATE'] = 'CANNOT_CHANGE_STATE - L\'activité ne peut changer d\'état.';
$string['error:CIEID_NOT_FOUND'] = 'CIEID_NOT_FOUND - La CieID n\'existe pas. Merci de vérifier les informations de configuration.';
$string['error:COMPANYNAME_TOO_LONG'] = 'COMPANYNAME_TOO_LONG - La valeur CompanyName dépasse le maximum de 50 caractères.';
$string['error:deletefailed'] = 'La suppression des activités a échouée.';
$string['error:disablereviews'] = 'La désactivation du mode revoir a échouée.';
$string['error:EMAIL_TOO_LONG'] = 'EMAIL_TOO_LONG - La valeur Email dépasse le  maximum de 100 caractères.';
$string['error:ERROR_AUTH_BAD_CIEID'] = 'ERROR_AUTH_BAD_CIEID - La valeur IP de l\'appelant n\'est pas valide.';
$string['error:ERROR_FAILED_EDIT_USER'] = 'ERROR_FAILED_EDIT_USER - Erreur dans l\'édition. L\'usager n\'a pas été modifié.';
$string['error:ERROR_LOGIN_NO_SPACE_ALLOWED'] = 'ERROR_LOGIN_NO_SPACE_ALLOWED - Le login contient des espaces.';
$string['error:FIRSTNAME_TOO_LONG'] = 'FIRSTNAME_TOO_LONG - La valeur Firsname dépasse le maximum de 50 caractères.';
$string['error:FONCTIONTILE_TOO_LONG'] = 'FONCTIONTILE_TOO_LONG - La valeur Fonction dépasse le maximum de 50 caractères.';
$string['error:INVALID_ACTIVITYID'] = 'INVALID_ACTIVITYID - Lorsque la valeur ID de l\'activité synchrone n\'est pas valide.';
$string['error:INVALID_ACTIVITYSTATE'] = 'INVALID_ACTIVITYSTATE - La valeur passée dans le noeud ActivityState n\'est pas valide.';
$string['error:INVALID_ACTIVITYTYPE'] = 'INVALID_ACTIVITYTYPE - La valeur passée dans le noeud ActivityType n\'est pas valide.';
$string['error:INVALID_AUDIOTYPE'] = 'INVALID_AUDIOTYPE - La valeur passée dans le noeud AudioType n\'est pas valide.';
$string['error:INVALID_CIEID'] = 'INVALID_CIEID - La valeur CIEID doit être une valeur numérique.';
$string['error:INVALID_CONFIRMATION_STATUS'] = 'INVALID_CONFIRMATION_STATUS - La valeur passée dans le noeud ConfirmationStatus n\'est pas valide.';
$string['error:INVALID_DATE'] = 'INVALID_DATE - Date au format AAAA-MM-JJ HH:MM:SS.';
$string['error:INVALID_DURATION'] = 'INVALID_DURATION - La valeur DURATION doit être une valeur numérique.';
$string['error:INVALID_FRIDAY_VALUE'] = 'INVALID_FRIDAY_VALUE - La valeur de la propriété Friday est invalide.';
$string['error:INVALID_GENDER'] = 'INVALID_GENDER - La valeur passée dans le noeud Genre n\'est pas valide.';
$string['error:INVALID_ISNUMBEREDTITLE'] = 'NVALID_ISNUMBEREDTITLE - La valeur passée dans le noeud IsNumberedTitle n\'est pas valide.';
$string['error:INVALID_ISPUBLIC'] = 'INVALID_ISPUBLIC - La valeur ISPUBLIC doit être 0 ou 1.';
$string['error:INVALID_ISRECORDED'] = 'INVALID_ISRECORDED - La valeur passée dans le noeud IsRecorded n\'est pas valide.';
$string['error:INVALID_ISREPLAYALLOWED'] = 'INVALID_ISREPLAYALLOWED - La valeur passée dans le noeud IsReplayAllowed n\'est pas valide.';
$string['error:INVALID_LANGUAGE'] = 'INVALID_LANGUAGE - La valeur passée dans le noeud LANGAGE n\'est pas valide.';
$string['error:INVALID_MAIL_FORMAT'] = 'INVALID_MAIL_FORMAT - Le format du courriel n\'est pas valide.';
$string['error:INVALID_MONDAY_VALUE'] = 'INVALID_MONDAY_VALUE - La valeur de la propriété Monday est invalide.';
$string['error:INVALID_MONTHLYDAY'] = 'INVALID_MONTHLYDAY - La valeur de la journée mensuel n\'est pas valide.';
$string['error:INVALID_NEEDCONFIRMATION'] = 'INVALID_NEEDCONFIRMATION - La valeur passée dans le noeud NeedConfirmation n\'est pas valide.';
$string['error:INVALID_OBJECT_FORMAT'] = 'INVALID_OBJECT_FORMAT - Le INNERXML du soap:body est invalide.';
$string['error:INVALID_PARTICIPANT_TYPE'] = 'INVALID_PARTICIPANT_TYPE - La valeur passée dans le noeud ParticipantType n\'est pas valide.';
$string['error:INVALID_PERIODICITY_ENDDATE'] = 'INVALID_PERIODICITY_ENDDATE - Date au format AAAA-MM-JJ.';
$string['error:INVALID_PERIODICITY_STARTDATE'] = 'INVALID_PERIODICITY_STARTDATE - Date au format AAAA-MM-JJ HH:MM:SS.';
$string['error:INVALID_PHONERIGHT'] = 'INVALID_PHONERIGHT - Le pont téléphonique n\'est pas actif pour cette compagnie.';
$string['error:INVALID_PLAYBACK_ID'] = 'INVALID_PLAYBACK_ID - La valeur ID du playback n\'est pas valide.';
$string['error:INVALID_PROFILID'] = 'INVALID_PROFILID - Le profil n\'est pas valide ou n\'existe pas pour le client.';
$string['error:INVALID_RECNOTIFICATION'] = 'INVALID_RECNOTIFICATION - La valeur passée dans le noeud LANGAGE n\'est pas valide.';
$string['error:INVALID_RECORDMODEBEHAVIOR'] = 'INVALID_RECORDMODEBEHAVIOR - La valeur passée dans le noeud RecordModeBehaviour n\'est pas valide.';
$string['error:INVALID_RECORD_TYPE'] = 'INVALID_RECORD_TYPE - Le type d\'enregistrement n\'est pas valide.';
$string['error:INVALID_REDIRECT_TYPE'] = 'INVALID_REDIRECT_TYPE - La valeur passée au noeud RedirectType n\'est pas valide.';
$string['error:INVALID_REMINDERTIME'] = 'INVALID_REMINDERTIME - La valeur passée dans le noeud ReminderTime n\'est pas valide.';
$string['error:INVALID_ROOMTYPE'] = 'INVALID_ROOMTYPE - La valeur passée dans le noeud RoomType n\'est pas valide.';
$string['error:INVALID_SATURDAY_VALUE'] = 'INVALID_SATURDAY_VALUE - La valeur de la propriété Saturday est invalide.';
$string['error:INVALID_SOAP_FORMAT'] = 'INVALID_SOAP_FORMAT - La requête SOAP n\'a pas été instanciée correctement.';
$string['error:INVALID_STATUS'] = 'INVALID_STATUS - La valeur passée dans le noeud Status n\'est pas valide.';
$string['error:INVALID_SUNDAY_VALUE'] = 'INVALID_SUNDAY_VALUE - La valeur de la propriété Sunday est invalide.';
$string['error:INVALID_THURSDAY_VALUE'] = 'INVALID_THURSDAY_VALUE - La valeur de la propriété Thursday est invalide.';
$string['error:INVALID_TIMEZONE'] = 'INVALID_TIMEZONE - La valeur passée dans le noeud TIMEZONE n\'est pas valide.';
$string['error:INVALID_TITLE_TOO_LONG'] = 'INVALID_TITLE_TOO_LONG - Le titre dépasse le maximum de 100 caractères.';
$string['error:INVALID_TUESDAY_VALUE'] = 'INVALID_TUESDAY_VALUE - La valeur de la propriété Tuesday est invalide.';
$string['error:INVALID_USERID'] = 'INVALID_USERID - La valeur ID de l\'utilisateur n\'est pas valide.';
$string['error:INVALID_USER_RIGHT'] = 'NVALID_USER_RIGHT - L\'utilisateur n\'a pas le droit d\'édition ou de création sur les activités.';
$string['error:INVALID_USERTYPE'] = 'INVALID_USERTYPE - La valeur passée dans le noeud LANGAGE n\'est pas valide.';
$string['error:INVALID_WAITINGROOMACCESSMODE'] = 'INVALID_WAITINGROOMACCESSMODE - La valeur passée dans le noeud WaitingRoomAccesMode n\'est pas valide.';
$string['error:INVALID_WEDNESDAY_VALUE'] = 'INVALID_WEDNESDAY_VALUE - La valeur de la propriété Wednesday est invalide.';
$string['error:LASTNAME_TOO_LONG'] = 'LASTNAME_TOO_LONG - La valeur Lastname dépasse le maximum de 50 caractères.';
$string['error:LOGIN_EMPTY'] = 'LOGIN_EMPTY - La valeur Login est vide.';
$string['error:LOGIN_TOO_LONG'] = 'LOGIN_TOO_LONG - La valeur Login dépasse le maximum de 15 caractères.';
$string['error:LOGIN_USED'] = 'LOGIN_USED - La valeur Login est déjà utilisée.';
$string['error:PASSWORD_EMPTY'] = 'PASSWORD_EMPTY - La valeur Password est vide.';
$string['error:PASSWORD_TOO_LONG'] = 'PASSWORD_TOO_LONG - La valeur Password dépasse le maximum de 15 caractères.';
$string['error:PERIODICITY_NODE_MISSING'] = 'PERIODICITY_NODE_MISSING - La node Périodicité n\'a pas été passé.';
$string['error:PHONEBUS_TOO_LONG'] = 'PHONEBUS_TOO_LONG - La valeur PHONEBUS dépasse le maximum de 20 caractères.';
$string['error:PHONECEL_TOO_LONG'] = 'PHONECEL_TOO_LONG - La valeur PHONECEL dépasse le maximum de 20 caractères.';
$string['error:PHONEHOME_TOO_LONG'] = 'PHONEHOME_TOO_LONG - La valeur PHONEHOME dépasse le maximum de 20 caractères.';
$string['error:PLAYBACK_NOT_PUBLIC'] = 'PLAYBACK_NOT_PUBLIC - Ce playback n\'est pas disponible a tous.';
$string['error:RECORD_NOT_DOWNLOADABLE'] = 'RECORD_NOT_DOWNLOADABLE - L\'enregistrement n\'est pas disponible.';
$string['error:resetparticipants'] = 'Retirer tous les participants et animateurs (fonctionne seulement pour les activités avec inscription manuelle)';
$string['error:STATUS_INVALID'] = 'La connexion n\'est pas possible.';
$string['error:TITLE_IS_REQUIRED'] = 'TITLE_IS_REQUIRED - Le titre est requis.';
$string['error:TITLE_TOO_LONG'] = 'TITLE_TOO_LONG - La valeur Title dépasse le maximum de 100 caractères.';
$string['error:UNABLE_TO_CREATEDATE'] = 'UNABLE_TO_CREATEDATE - Erreur dans la création des dates de la périodicité.';
$string['error:URL_ERROR'] = 'URL_ERROR - L\'url de l\'API n\'existe pas. Merci de vérifier les informations de configuration.';
$string['error_user'] = 'Une erreur est survenue, l\'utilisateur {$a} n\'a pas pu être ajouté à l\'activité.';
$string['error:USER_DOES_NOT_EXIST'] = 'USER_DOES_NOT_EXIST - L\'usager n\'est pas valide.';
$string['error:USER_DOWNLOAD_NOT_ALLOWED'] = 'USER_DOWNLOAD_NOT_ALLOWED - L\'utilisateur n\'a pas le droit de télécharger l\'enregistrement.';
$string['error:USERID_EMPTY'] = 'USERID_EMPTY - La valeur UserID est vide.';
$string['existinganimators'] = 'Animateurs actuels';
$string['existingparticipants'] = 'Participants actuels';
$string['existingpresentator'] = 'Présentateur actuel';
$string['export'] = 'Visionner/Exporter';
$string['finish'] = 'Complétée';
$string['fullvideo'] = 'Grand format (MP4)';
$string['fullvideoinfo'] = 'Tel que disponible en revoir. Résolution : 1024x768';
$string['gotoactivity'] = 'Cliquez ici pour accéder à l\'activité';
$string['gotorecording'] = 'Accéder l\'enregistrement';
$string['groupusers'] = 'es utilisateurs du groupement associé : {$a} ne peuvent pas être dissociés de l\'activité, mais vous pouvez en ajouter.';
$string['hasconfirmed'] = 'Vous avez confirmé votre présence à l\'activité';
$string['hasconfirmednot'] = 'Vous avez confirmé que vous ne serez pas présent à l\'activité.';
$string['headerduration'] = 'Durée';
$string['hidelist'] = 'Cacher';
$string['highquality'] = 'Qualité haute';
$string['incomplete'] = 'Incomplète';
$string['inpresentatorabsence'] = 'En l\'absence du présentateur (automatique)';
$string['inviteclicktoaccesshtml'] = 'Pour accéder à l\'activité, cliquez sur ce lien :';
$string['inviteemail'] = '\'{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

L\'actitivé &quot; {$a->title} &quot; qui aura lieu le {$a->datebegin} de {$a->hourbegin} à {$a->hourend}.

{$a->invitemsg}

---------------------------------------------------------------------
Préparation à l\'activité

Cliquez le lien suivant pour l\'assistant de configuration : {$a->config}
Cliquez le lien suivant pour l\'assistance technique : {$a->assist}

---------------------------------------------------------------------
Accès Web

Pour accéder à l\'activité, cliquez sur ce lien : {$a->activitylink}

---------------------------------------------------------------------


Attention : Chaque activité peut êtretre enregistrée. Merci de ne pas y accéder si vous ne voulez pas être enregistré. Ce courriel contient vos informations personnelles de connexion. Ces informations ne doivent pas être partagées.\';';
$string['inviteemailhtml'] = '<p>Bonjour {$a->username},</p>
<p>L\'activité &laquo; {$a->title} &raquo; aura lieu le <b>{$a->datebegin}</b> de <b>{$a->hourbegin}</b> à <b>{$a->hourend}</b>.</p><p>{$a->invitemsg}</p>';
$string['inviteemailhtmlpermanent'] = '<p>Bonjour {$a->username},</p>

<p>{$a->invitemsg}</p>';
$string['inviteemailpermanent'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

{$a->invitemsg}

---------------------------------------------------------------------
Préparation à l\'activité

Cliquez le lien suivant pour l\'assistant de configuration : {$a->config}
Cliquez le lien suivant pour l\'assistance technique : {$a->assist}

---------------------------------------------------------------------
Accès Web

Pour accéder à l\'activité, cliquez sur ce lien : {$a->activitylink}

---------------------------------------------------------------------

Attention : Chaque activité peut êtretre enregistrée. Merci de ne pas y accéder si vous ne voulez pas être enregistré. Ce courriel contient vos informations personnelles de connexion. Ces informations ne doivent pas être partagées.';
$string['inviteemailsubject'] = 'INVITATION : {$a->title}';
$string['invitepreparationhtml'] = 'Préparation à l\'activité';
$string['invitessend'] = 'Les courriels d\'invitation seront envoyés d\'ici 15 minutes.';
$string['invitewarninghtml'] = 'Attention : Chaque activité peut être enregistrée. Merci de ne pas y accéder si vous ne voulez pas être enregistré. Ce courriel contient vos informations personnelles de connexion. Ces information ne doivent pas être partagées.';
$string['invitewebaccesshtml'] = 'Accès Web';
$string['list_activities'] = 'Liste de toutes les activités Via dans ce cours';
$string['lowquality'] = 'Qualité basse';
$string['manageparticipants'] = 'Gérer les utilisateurs';
$string['manual'] = 'Manuel';
$string['manualenrol'] = 'Inscription manuelle';
$string['mask'] = 'Afficher';
$string['mediumquality'] = 'Qualité moyenne';
$string['mobilevideo'] = 'Mobile (MP4)';
$string['mobilevideoinfo'] = 'Optimisé pour un affichage réduit. Résolution : 480x320';
$string['mode'] = 'Mode audio';
$string['modephone'] = 'Conférence téléphonique seulement';
$string['modevoiceweb'] = 'Voix par Internet';
$string['modewebphone'] = 'Voix par conférence téléphonique';
$string['modulename'] = 'Via';
$string['modulename_help'] = 'Le module Via vous permet de créer des rencontres en classe virtuelle synchrone afin d\'échanger en  direct à l\'aide de la voix et la vidéo pour :
-Des classes à distance en temps réel
-Des réunions
-Des rencontres pour les travaux d\'équipes
-Du tutorat
-Des séminaires
-Etc.

L\'outils permet de gérer des sous-groupes de travails, d\'annoter, de partager son écran, d\'importer/présenter des documents et d\'échanger par la voix/vidéo.

L\'option &laquo; Inscription des participants &raquo; vous permet d\'inscrire manuellement les participants ou encore de les synchroniser automatiquement avec les droits de votre espace Moodle par la sélection de l\'option &laquo; Inscription automatique &raquo;.

La section &laquo; Paramètres de sessions &raquo; vous permet de paramétrer l\'enregistrement des rencontres et la disponibilité de ces derniers pour vos apprenants.

NB. L\'édition et la modification des enregistrements doivent se faire dans l\'environnement Via.';
$string['modulenameplural'] = 'Via';
$string['moodle_adminid'] = 'Clé Admin Moodle';
$string['moodle_config'] = 'Configuration de l\'API - étape 2';
$string['moodleidsetting'] = 'ID Administrateur unique pour ce moodle';
$string['multimediaquality'] = 'Qualité multimédia';
$string['multimediaquality_help'] = 'Sélectionnez le profil multimédia à utiliser dans l\'activité pour les échanges multimédias (caméra Web, microphone et documents multimédias). Cette option peut avoir un impact important sur la fluidité des échanges et sur la bande passante nécessaire pour chaque participant. De façon générale, pour une meilleure expérience ou si vous êtes incertain, il est préférable d\'utiliser une qualité moindre pour assurer la fluidité des échanges. Il est possible de faire configurer d\'autres profils multimédia en fonction de vos besoins spécifiques (par exemple de grandes vignettes vidéo d\'excellente qualité pour une utilisation en mode local). Contactez un de nos experts Via pour en savoir davantage à ce sujet.';
$string['multiple'] = 'Multiple';
$string['mustaccept'] = 'Cochez la case pour accéder à l\'activité.';
$string['name'] = 'Nom';
$string['needconfirmation'] = 'Confirmation de disponibilité';
$string['needconfirmation_help'] = 'Confirmation de disponibilité';
$string['neverbegin'] = 'À faire';
$string['newversion'] = 'Utiliser la version la plus récente de Via';
$string['noanimators'] = 'Aucun animateur n\'est inscrit à cette activité.';
$string['nocategories'] = 'Aucune catégorie';
$string['no_categories'] = 'Il n\'y a aucune catégories de disponible, celles-ci doivent être créés dans le portail Via par un administrateur.';
$string['no_default'] = 'Aucune catégorie par défaut.';
$string['noparticipants'] = 'Aucun participant n\'est inscrit à cette activité.';
$string['noparticipantscheckbox'] = 'Ajouter les étudiants comme animateurs.';
$string['noparticipants_help'] = 'Cette option est disponible seulement en mode d\'inscription automatique et fait en sorte que les utilisateurs ayant le statut d\'étudiant sont tous inscrits avec les droits d\'animateurs dans via.';
$string['norecall'] = 'Aucun rappel';
$string['notactivated'] = 'Désactivé';
$string['notactivatedfeminin'] = 'Désactivée';
$string['notattending'] = 'Je ne participerai pas';
$string['notenrolled'] = 'Vous n\'êtes pas inscrits à cette activité. Contactez le professeur du cours si vous croyez que vous devez y avoir accès.';
$string['noticeclicktoaccesshtml'] = 'Cliquez sur le lien ci-dessous pour un accès direct :';
$string['noticeemail'] = 'Bonjour {$a->username},

Ceci est un message automatisé.

L\'exportation en format {$a->type} demandé pour l\'enregistrement &quot;{$a->playbacktitle}&quot; est terminée depuis le {$a->date}.
Vous pouvez accéder aux détails de votre activité &quot;{$a->activitytitle}&quot; pour télécharger votre enregistrement ou les rendre disponibles aux participants.

---------------------------------------------------------------------

Cliquez le lien suivant pour un accès direct : {$a->activitylink}

---------------------------------------------------------------------';
$string['noticeemailhtml'] = '<p>Bonjour {$a->username},</p>
<p>Ceci est un message automatisé.</p>
<p>L\'exportation en format {$a->type} demandé pour l\'enregistrement &quot;{$a->playbacktitle}&quot; est terminée depuis le {$a->date}.<br/>
Vous pouvez accéder aux détails de votre activité &quot;{$a->activitytitle}&quot; pour télécharger votre enregistrement ou les rendre disponibles aux participants.</p>';
$string['noticeemailsubject'] = 'ALERTE : Exportation enregistrement';
$string['notstarted'] = 'Cette activité n\'a pas encore débuté.';
$string['nounifiedrecordpermanent'] = 'Le mode &laquo; Unifié &raquo; n\'est pas possible pour une activité permanente. Veuillez sélectionner un choix différent.';
$string['nousers'] = 'Attention - Il n\'y a aucun utilisateur associé à cette activité!';
$string['oldapiversion'] = 'Vous utilisez une version anterieur à {$a} de l\'API';
$string['oldversion'] = 'Utiliser la version 6 de Via';
$string['options'] = 'Options pour l\'activité';
$string['overview'] = 'Débute le {$a->start} et se termine le {$a->end}';
$string['participant'] = 'Participant';
$string['participantmustconfirm'] = 'Confirmation de disponibilité';
$string['participantmustconfirmdesc'] = 'Si cette option est cochée, l\'option est disponible lors de la création des nouvelles activités. Une colonne de plus apparaitra dans la liste des participants avec leur disponibilité.';
$string['participants'] = 'Participants';
$string['participantsynchronization'] = 'Synchroniser les informations des participants';
$string['participantsynchronizationdesc'] = 'Cette option permet de synchroniser les informations des utilisateurs, incluant leur avatar, lors de leur connexion  à Via. M ême si cette option est cochée, le code d\'utilisateur Via, le type d\'utilisateur Via et le mot de passe dans Via ne seront pas mis  à jour.';
$string['passdate'] = 'La date sélectionnée est dépassée.';
$string['permanent'] = 'Activité permanente';
$string['permanentactivities'] = 'Activités permanents';
$string['permanentactivitiesdesc'] = 'Cochez cette case si vous désirez que vos utilisateurs puissent créer des activités permanentes (qui n\'ont pas de date de début et de fin).';
$string['permanent_help'] = 'Cocher l\'option « Permanente » afin de rendre votre activité toujours accessible, sans date précise. Vous serez alors dans l\'obligation d\'utiliser la salle d\'attente afin d\'en limiter l\'accès aux utilisateurs inscrits ayant le statut « participant ».';
$string['personalinvitemsg'] = 'Message personnalisé :';
$string['playback_downloaded'] = 'Enregistrement téléchargé';
$string['playbackheader'] = 'Différé (h:m:s)';
$string['playback_viewed'] = 'Enregistrement visionné';
$string['pluginadministration'] = 'Administration de Via';
$string['pluginname'] = 'Via';
$string['pluginversion'] = 'Version :';
$string['portalaccess'] = 'Accès au portail Via.';
$string['portalaccessdesc'] = 'Permet aux utilisateur d\'accéder au portail Via  à partir de leur éétat de session dans Moodle. En effet, lorsque l\'utilisateur acc ès  à une activité Via  à partir de Moodle, son état de session est actif dans le
portail Via et il est en mesure, simplement en ouvrant un nouvel onglet de son navigateur et en accédant au portail, de s\'y connecter sans avoir  à entrer de code utilisateur/mot de passe. Autrement, si l\'option n\'est pas activée, l\'utilisateur ne
peut pas se connecter au portail Via  à partir de son état de session Moodle.';
$string['potentialanimators'] = 'Animateurs potentiels';
$string['potentialparticipants'] = 'Participants potentiels';
$string['potentialpresentator'] = 'Présentateurs potentiels';
$string['preparation'] = 'Préparer votre activité :';
$string['prepareactivity'] = 'Préparer votre activité.';
$string['presence'] = 'Temps minimum requis de présence';
$string['presenceheader'] = 'Présence en direct (h:m:s)';
$string['presenceheaderreport'] = 'Présence en direct';
$string['presence_help'] = 'Valeur correspondante à la durée en minutes à partir de laquelle l\'utilisateur obtient le statut de présence pour l\'activité.';
$string['presencestatus'] = 'Rapport de présence sur les activités';
$string['presencestatusdesc'] = 'Si cette case est cochée, il vous est alors possible de fixer un temps minimum de présence (en minutes) afin que vos utilisateurs soient considérés comme présents dans votre activité. Ainsi, si vous fixez  à 50 minutes le seuil de présence pour votre activité, et que votre utilisateur s\'y connecte pendent 48 minutes, il sera considéré comme absent par le système.';
$string['presencetable'] = 'Statut de présence :';
$string['presencewarning'] = 'Important : Le Statut de présence en direct est déterminé en fonction du temps minimum requis pour être considéré présent pour cette activité. Ce statut influence la barre de progression du participant dans le déroulement de son parcours. Il vous est possible d\'ajuster ce statut en modifiant la valeur &laquo; Temps minimum requis de présence &raquo; dans les paramètres de l\'activité.';
$string['present'] = 'Présent';
$string['presentator'] = 'Présentateur';
$string['recalloneday'] = 'Un jour avant';
$string['recallonehour'] = 'Une heure avant';
$string['recalloneweek'] = 'Une semaine avant';
$string['recalltwodays'] = 'Deux jours avant';
$string['recalltwohours'] = 'Deux heures avant';
$string['recentrecordings'] = 'Enregistrement récent';
$string['recordaccept'] = 'J\'accepte';
$string['recording'] = 'Enregistrement';
$string['recordingisdownloadable'] = 'L\'enregistrement est téléchargeable';
$string['recordingisdownloadableinfo'] = 'Important : vous devez d\'abord exporter la vidéo afin qu\'elle soit disponible pour téléchargement.';
$string['recordingmode'] = 'Mode d\'enregistrement';
$string['recordingmode_help'] = 'Si vous désirez activer l\'enregistrement de vos activités, deux modes sont offerts : « Unifié » et « Multiple ». La fonction d\'enregistrement unifié produira un enregistrement unique peu importe le nombre d\'enregistrements effectués durant la rencontre tandis que les enregistrements multiples sont séparés et segmentés dans la liste.';
$string['recordings'] = 'Enregistrement(s) disponible(s) :';
$string['recordingtitle'] = 'Titre de l\'enregistrement';
$string['recordmodebehavior'] = 'Enregistrement';
$string['recordmodebehavior_help'] = 'En plus du mode, vous pouvez également décider de démarrer automatiquement l\'enregistrement   à l\'accès en utilisant l\'option &laquo; Automatique &raquo;. Choisissez l\'option &laquo; Manuel &raquo; si vous ne désirez pas que l\'enregistrement démarre automatiquement   à l\'accès. Vous devrez alors démarrer l\'enregistrement vous-même en accédant   à l\'interface synchrone.';
$string['recordwarning'] = 'Les activités peuvent être enregistrées. En cochant cette case, vous acceptez d\'être enregistré.';
$string['refused'] = 'Ne sera pas présent';
$string['reminderemail'] = '{$a->coursename} -> {$a->modulename} -> {$a->title} reminderemail
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

L\'actitivé &quot; {$a->title} &quot; qui aura lieu le {$a->datebegin} de {$a->hourbegin} à {$a->hourend}.

---------------------------------------------------------------------
Préparation à l\'activité

Cliquez le lien suivant pour l\'assistant de configuration : {$a->config}

Cliquez le lien suivant pour l\'assistance technique : {$a->assist}

---------------------------------------------------------------------
Accès Web

Pour accéder à l\'activité, cliquez sur ce lien : {$a->activitylink}

---------------------------------------------------------------------

Attention : Chaque activité peut être enregistrée. Merci de ne pas y accéder si vous ne voulez pas être enregistré. Ce courriel contient vos informations personnelles de connexion. Ces informations ne doivent pas être partagées.';
$string['reminderemailhtml'] = '<p>Bonjour {$a->username}, reminderemailhtml</p>
<p>Ceci est un rappel pour une activité qui aura lieu sous peu :</p>
<p><b>Titre :</b> {$a->title}<br/>
<b>Date et heure :</b> {$a->activitydate}<br/>
<b>Durée :</b> {$a->duration} minutes</p>';
$string['reminderemailsubject'] = 'RAPPEL : {$a->title}';
$string['report'] = 'Rapport de présence';
$string['resetdeletemodules'] = 'Supprimer toutes les activités';
$string['resetdisablereviews'] = 'Désactiver le revisionnement des activités';
$string['resetparticipants'] = 'Retirer tous les participants et animateurs (fonctionne seulement pour les activités avec inscription manuelle)';
$string['return'] = 'Retour';
$string['reviewacitvity'] = 'Rendre public tous les enregistrements par défaut';
$string['reviewacitvity_help'] = 'Dans le cas où vous désirez rendre tous les enregistrements disponibles au visionnement, sélectionnez l\'option &laquo; Rendre public tous les enregistrements par défaut &raquo;. Dans le cas contraire, aucun participant ne pourra visionner les enregistrements   à moins de les cocher individuellement dans la liste. Veuillez noter que cette option est modifiable en tout temps, même lorsque l\'activité est terminée.';
$string['reviewactivity'] = 'Cliquez ici pour revoir l\'activité.';
$string['role'] = 'Rôle';
$string['roomtype'] = 'Type d\'activité';
$string['roomtype_help'] = 'Le type &laquo; Standard &raquo; est une activité dans laquelle tous les participants sont listés et peuvent interagir normalement, selon le rôle attribué. Si vous choisissez plutôt une activité de type &laquo; Webinaire &raquo;, seuls le présentateur et les animateurs verront les noms des participants. De plus, ces derniers ne pourront interagir autrement que par le clavardage. Ce dernier type est idéal pour les activités comprenant de larges audiences (plus de 100 participants) ou pour des activités confidentielles.
Lorsque l\'option &laquo; Permanente &raquo; est sélectionnée, l\'activité n\'aura alors plus de date et d\'heure fixe. Tous les participants associés   à cette activité pourront alors y accéder   à n\'importe quel moment. Veuillez prendre note que seul le mode d\'enregistrement multiple est disponible pour ce type d\'activité.';
$string['roomversion'] = 'Choisissez la version de Via';
$string['roomversion_help'] = 'Choisissez la version de Via que vous voulez utiliser pour cette activité, une fois sauvegardé ceci n\'est pas modifiable.';
$string['save'] = 'Enregistrer';
$string['seminar'] = 'Webinaire';
$string['sendinvitation'] = 'Envoyer courriel d\'invitation';
$string['sendinvitationdesc'] = 'Si cochée, il sera possible d\'envoyer des invitations par courriel à tous les participants.';
$string['sendinvite'] = 'Envoyer un courriel d\'invitation';
$string['sendrecall'] = 'Envoyer un courriel de rappel';
$string['sendrecall_help'] = 'Permet de fixer un rappel automatique selon la période demandée. Vous pouvez choisir d\'envoyer un rappel automatiquement   à tous les participants 1 ou 2 heures avant, 1 ou 2 jours avant et même 1 semaine avant la tenue de l\'activité. Ils recevront alors le rappel directement par courriel.';
$string['sessionparameters'] = 'Paramètres de la session';
$string['show'] = 'Cacher';
$string['showlist'] = 'Afficher';
$string['showparticipants'] = 'Afficher la liste des participants';
$string['showparticipants_help'] = 'Vous permet d\'afficher la liste des participants dans l\'activité via en mode webinaire.';
$string['standard'] = 'Standard';
$string['startdate'] = 'Débute le';
$string['STATUS_INVALID'] = 'La connexion n\'est pas possible.';
$string['submitinvite'] = 'Envoyer les invitations';
$string['subscribeparticipants'] = 'Inscription des usagers';
$string['technicalassist'] = 'Assistance technique';
$string['technicalassist_url'] = 'Spécifier une page d\'assistance technique';
$string['technicalassist_urldesc'] = 'Par défaut, la page d\'assistance technique affichera les informations fournies dans Via. Vous pouvez spécifier une page personnalisée d\'assistance en appelant directement l\'URL. Cela peut  être une page créée dans Moodle ou un autre site.';
$string['testadminid'] = 'Tester la clé moodle';
$string['testconnection'] = 'Tester la connexion à l\'API';
$string['timeduration'] = 'Durée :';
$string['title_exists'] = 'Le titre existe déjà, veuillez essayer à nouveau.\'';
$string['unified'] = 'Unifié';
$string['userispresentor'] = 'Cet utilisateur est le présentateur. Veuillez désigner un nouveau présentateur afin de modifier le rôle de cet utilisateur.';
$string['versionscompatible'] = 'Les versions du module et de VIA sont compatible.';
$string['versions_not_compatible'] = 'Les versions du module et de VIA ne sont pas compatible. Cette version du module requière un minimum de';
$string['via_accessed'] = 'Activité Via accédé';
$string['via:addinstance'] = 'Ajouter une activité Via';
$string['viaaudiotypes'] = 'Sélectionnez les modes audios que vous voulez conserver.';
$string['via_categoriesdesc'] = 'Si cette case est cochée, des catégories créées dans Via pourront être ajouté à l\'activité.';
$string['via_details_viewed'] = 'Détails de l\'activité affichés';
$string['via:manage'] = 'Gérer les activités Via';
$string['viausers'] = 'Utilisateurs';
$string['via:view'] = 'Voir les activités Via';
$string['via:viewpresence'] = 'Voir les rapports de présence pour les activités Via';
$string['view'] = 'Visionner';
$string['waitingconfirm'] = 'En attente de la confirmation';
$string['waitingroomaccessmode'] = 'Salle d\'attente';
$string['waitingroomaccessmode_help'] = 'L\'option &laquo; En attente d\'autorisation &raquo; permet au présentateur d\'autoriser individuellement l\'accès des participants tandis que l\'option &laquo; En l\'absence du présentateur &raquo; vous assure qu\'aucun utilisateur ne pourra accéder   à l\'activité tant que le présentateur n\'est pas connecté. Cette dernière option est particulièrement utile lors d\'activités permanentes.';
