<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'zh_tw', branch 'MOODLE_28_STABLE'
 *
 * @package   block_xp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addacondition'] = '添加一條件';
$string['addarule'] = '添加一規則';
$string['addrulesformhelp'] = '最後一個欄位定義了當經驗值累積到標準時所增加的經驗點數總量';
$string['basexp'] = '演算法基底';
$string['cachedef_filters'] = '等級濾鏡';
$string['cachedef_ruleevent_eventslist'] = '一些事件的清單';
$string['changelevelformhelp'] = '如果更改級別數，自定義級別獎章將被暫時禁用，以防止沒有獎章的級別。如果更改了級別數，當這個格式被儲存，可以到視覺效果頁面重新啟用自定義獎章。';
$string['cheatguard'] = '防作弊守衛';
$string['coefxp'] = '演算法係數';
$string['configdescription'] = '附加說明';
$string['configheader'] = '設定';
$string['configtitle'] = '標題';
$string['congratulationsyouleveledup'] = '恭喜!';
$string['coolthanks'] = '太酷了，謝謝!';
$string['courselog'] = '課程紀錄';
$string['coursereport'] = '課程報告';
$string['courserules'] = '課程規則';
$string['coursesettings'] = '課程設定';
$string['coursevisuals'] = '課程視覺效果';
$string['customizelevels'] = '自定義等級';
$string['defaultrules'] = '預設規則';
$string['defaultrulesformhelp'] = '';
$string['deletecondition'] = '刪除條件';
$string['deleterule'] = '刪除規則';
$string['description'] = '說明';
$string['dismissnotice'] = '停用通知';
$string['enableinfos'] = '啟用資訊頁';
$string['enableinfos_help'] = '當設定為"否"時，學生將無法檢視資訊頁。';
$string['enableladder'] = '啟用階梯';
$string['enableladder_help'] = '當設定為"否"時，學生將無法檢視階梯。';
$string['enablelevelupnotif'] = '啟用升級提示';
$string['enablelevelupnotif_help'] = '當設定為"是"時，學生將會在到達新的等級的時候看到跳出的';
$string['enablelogging'] = '啟用登入';
$string['enablexpgain'] = '啟用XP加成';
$string['enablexpgain_help'] = '當設定為"否"的時候，沒有人會在此課程中獲得經驗點數。
這對凍結經驗值加成、或';
$string['errorformvalues'] = '表單的值中還是有些問題，請修正它們。';
$string['errorlevelsincorrect'] = '等級最小值為2';
$string['errornotalllevelsbadgesprovided'] = '您仍有等級獎章尚未提供。 遺失: {$a}';
$string['errorunknownevent'] = '錯誤：未知的事件';
$string['errorunknownmodule'] = '錯誤：未知的模組';
$string['errorxprequiredlowerthanpreviouslevel'] = '經驗值需求小於等於前一個等級';
$string['eventis'] = '這事件是{$a}';
$string['eventname'] = '事件名稱';
$string['eventproperty'] = '事件性質';
$string['eventtime'] = '事件時間';
$string['event_user_leveledup'] = '使用者升級';
$string['for1day'] = '一天';
$string['for1month'] = '一個月';
$string['for1week'] = '一周';
$string['for3days'] = '三天';
$string['forever'] = '永遠';
$string['forthewholesite'] = '在整個網站中';
$string['give'] = '給予';
$string['incourses'] = '在課程中';
$string['infos'] = '資訊';
$string['invalidxp'] = '無效的經驗值';
$string['keeplogs'] = '保留紀錄';
$string['ladder'] = '階梯';
$string['level'] = '等級';
$string['levelbadges'] = '等級徽章';
$string['levelbadgesformhelp'] = '幫這個檔案取名 [level].[file extension]，舉例來說： 1.png, 2.jpg,等等... 推薦的影像大小為100x100。';
$string['levelcount'] = '等級計算';
$string['leveldesc'] = '等級說明';
$string['levels'] = '等級';
$string['levelswillbereset'] = '警告! 儲存這個格式會重新計算所有人的等級';
$string['levelup'] = '升級了!';
$string['levelx'] = '等級 #{$a}';
$string['likenotice'] = '<strong>您喜歡這外掛嗎？</strong> 請花一些時間到 Moodle.org<a href="{$a->moodleorg}" target="_blank">把它加到您的最愛</a> 並在 <a href="{$a->github}" target="_blank"> GitHub給它星號</a>。';
$string['logging'] = '登入';
$string['maxactionspertime'] = '時間幀數中的Max. actions';
$string['maxactionspertime_help'] = '給出的時間幀數中將會計算XP的最大動作數量。任何後續的操作將被忽略。';
$string['movecondition'] = '移動條件';
$string['moverule'] = '移動規則';
$string['navinfos'] = '資訊';
$string['navladder'] = '階梯';
$string['navlevels'] = '等級';
$string['navlog'] = '紀錄';
$string['navreport'] = '報告';
$string['navrules'] = '規則';
$string['navsettings'] = '設定';
$string['navvisuals'] = '視覺效果';
$string['participatetolevelup'] = '參與這個課程以賺取經驗點數並升級';
$string['pickaconditiontype'] = '挑選一條件類型';
$string['pluginname'] = '升級!';
$string['progress'] = '進度';
$string['property:action'] = '事件動作';
$string['property:component'] = '事件組成';
$string['property:crud'] = '事件的CRUD';
$string['property:eventname'] = '事件名稱';
$string['property:target'] = '事件目標';
$string['rank'] = '排序';
$string['reallyresetdata'] = '真的要重設這堂課所有人的等級以及經驗點數嗎?';
$string['reallyresetgroupdata'] = '真的要重設在這一群組中所有人的等級以及經驗點數嗎？';
$string['resetcoursedata'] = '重設課程資料';
$string['resetgroupdata'] = '重設群組資料';
$string['rule'] = '規則';
$string['rulecm'] = '活動或資源';
$string['rulecmdesc'] = '這活動或資源是 \'{$a->contextname}\'';
$string['rule:contains'] = '包含';
$string['rule:eq'] = '等於';
$string['rule:eqs'] = '嚴格等於';
$string['ruleevent'] = '特定事件';
$string['ruleeventdesc'] = '這事件是\'{$a->eventname}\'';
$string['rule:gt'] = '大於';
$string['rule:gte'] = '大於等於';
$string['rule:lt'] = '小於';
$string['rule:lte'] = '小於等於';
$string['ruleproperty'] = '事件屬性';
$string['rulepropertydesc'] = '這屬性 \'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['rule:regex'] = '符合正則表達式';
$string['ruleset'] = '條件的集合';
$string['ruleset:all'] = '"所有"條件為真';
$string['ruleset:any'] = '"任何"條件為真';
$string['ruleset:none'] = '"沒有"條件為真';
$string['rulesformhelp'] = '<p>這個外掛利用事件來將學生進行的動作變成經驗點數。你可以使用下面的表單來增加你自己的規則，以及檢視預設的規則。</p>
<p>建議檢查此外掛之<a href="{$a->log}">紀錄</a> 驗證當你在課程中進行的動作會觸發什麼事件，然後對事件本身進行進一步了解： <a href="{$a->list}">所有事件清單</a>, <a href="{$a->doc}">開發者憑證</a>.</p>
<p>最後，請注意這個外掛總是忽略：
<ul>
    <li>管理員、訪客以及沒有登入之用戶的動作</li>
    <li>不具有<em>block/xp:earnxp</em>能力的用戶所做的動作</li>
    <li>在一個短暫的時間區間中重複動作，以避免作弊。</li>
    <li>事件的學習等級不等於 <em>參與中</em>.</li>
</ul>
</p>';
$string['timebetweensameactions'] = '進行相同動作之前所需的時間';
$string['timebetweensameactions_help'] = '在短時間內，兩個相同動作所需的最短時間。
一個動作';
$string['timeformaxactions'] = 'max.action的時間幀數';
$string['timeformaxactions_help'] = '時間幀（秒）在此期間用戶不應該超過的動作的最大次數。';
$string['updateandpreview'] = '更新及預覽';
$string['usealgo'] = '使用演算法';
$string['usecustomlevelbadges'] = '使用自定義獎章';
$string['usecustomlevelbadges_help'] = '當設定為"是"，你必須要為每個等級提供一個圖像';
$string['value'] = '值';
$string['valuessaved'] = '已順利儲存。';
$string['viewtheladder'] = '檢視階梯';
$string['when'] = '當';
$string['wherearexpused'] = '經驗點數要用在哪裡？';
$string['wherearexpused_desc'] = '當你設定為"在課程中"，獲得的經驗值將只會用在有添加這區塊的課程中。若你設定為"在整個網站上"，則用戶將會跨越課程，使用他在整個網站上所獲得的經驗值，而不是限制在選定的單一課程上。';
$string['xp'] = '經驗點數';
$string['xp:addinstance'] = '增加一個XP區塊';
$string['xp:earnxp'] = '賺取經驗點數';
$string['xpgaindisabled'] = '無法得到經驗值';
$string['xp:myaddinstance'] = '添加一個區塊到我的儀表板';
$string['xprequired'] = '需要經驗值';
$string['xp:view'] = '檢視這區塊和與它有關的頁面';
$string['youreachedlevela'] = '您到達等級 {$a}!';
$string['yourownrules'] = '你自己的規則';
