<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'zh_tw', branch 'MOODLE_28_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = '地址';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = '插入/編輯錨點';
$string['advanced:backcolor_desc'] = '選擇背景顏色';
$string['advanced:block'] = '格式';
$string['advanced:blockquote'] = '引文區塊化';
$string['advanced:blockquote_desc'] = '引文區塊化';
$string['advanced:bold_desc'] = '粗體(Ctrl+B)';
$string['advanced:bullist_desc'] = '插入/移除項目列表';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = '插入特殊字符';
$string['advanced:cleanup_desc'] = '清理雜亂代碼';
$string['advanced:clipboard_msg'] = '在Mozilla和Firefox中無法使用複製/剪下/貼上功能。 你是否需要瞭解更多有關此問題的資訊？';
$string['advanced:code'] = '代碼';
$string['advanced:code_desc'] = '編輯HTML代碼';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = '複製';
$string['advanced:custom1_desc'] = '你自行定義的說明';
$string['advanced:cut_desc'] = '剪下';
$string['advanced:dd'] = '定義說明';
$string['advanced:div'] = 'DIV';
$string['advanced_dlg:about_author'] = '作者';
$string['advanced_dlg:about_general'] = '關於';
$string['advanced_dlg:about_help'] = '幫助說明';
$string['advanced_dlg:about_license'] = '授權';
$string['advanced_dlg:about_loaded'] = '已載入的外掛套件';
$string['advanced_dlg:about_plugin'] = '外掛';
$string['advanced_dlg:about_plugins'] = '所有外掛套件';
$string['advanced_dlg:about_title'] = '關於TinyMCE';
$string['advanced_dlg:about_version'] = '版本';
$string['advanced_dlg:accessibility_help'] = '使用輔助';
$string['advanced_dlg:accessibility_usage_title'] = '一般使用';
$string['advanced_dlg:anchor_invalid'] = '請指定一個有效的錨點名稱。';
$string['advanced_dlg:anchor_name'] = '錨點名稱';
$string['advanced_dlg:anchor_title'] = '插入/編輯錨點';
$string['advanced_dlg:charmap_title'] = '選擇特殊字符';
$string['advanced_dlg:charmap_usage'] = '使用左右箭頭來導覽。';
$string['advanced_dlg:code_title'] = 'HTML元代碼編輯器';
$string['advanced_dlg:code_wordwrap'] = '文字自動換行';
$string['advanced_dlg:colorpicker_color'] = '顏色:';
$string['advanced_dlg:colorpicker_name'] = '名稱:';
$string['advanced_dlg:colorpicker_named_tab'] = '已命名';
$string['advanced_dlg:colorpicker_named_title'] = '已命名的顏色';
$string['advanced_dlg:colorpicker_palette_tab'] = '調色板';
$string['advanced_dlg:colorpicker_palette_title'] = '調色板的顏色';
$string['advanced_dlg:colorpicker_picker_tab'] = '拾色器';
$string['advanced_dlg:colorpicker_picker_title'] = '拾色器';
$string['advanced_dlg:colorpicker_title'] = '挑選一顏色';
$string['advanced_dlg:image_align'] = '對齊方式';
$string['advanced_dlg:image_align_baseline'] = '基線';
$string['advanced_dlg:image_align_bottom'] = '底部';
$string['advanced_dlg:image_align_left'] = '靠左';
$string['advanced_dlg:image_align_middle'] = '置中';
$string['advanced_dlg:image_align_right'] = '靠右';
$string['advanced_dlg:image_align_textbottom'] = '文字下方';
$string['advanced_dlg:image_align_texttop'] = '文字上方';
$string['advanced_dlg:image_align_top'] = '頂端';
$string['advanced_dlg:image_alt'] = '圖像說明';
$string['advanced_dlg:image_border'] = '邊框';
$string['advanced_dlg:image_dimensions'] = '尺寸';
$string['advanced_dlg:image_hspace'] = '水平間距';
$string['advanced_dlg:image_list'] = '圖像列表';
$string['advanced_dlg:image_src'] = '圖像網址';
$string['advanced_dlg:image_title'] = '插入/編輯圖像';
$string['advanced_dlg:image_vspace'] = '垂直間距';
$string['advanced_dlg:invalid_color_value'] = '無效的顏色值';
$string['advanced_dlg:link_is_email'] = '您輸入的似乎是一個電子郵件位址，你是否需要在位址開頭加入必要的mailto:？';
$string['advanced_dlg:link_is_external'] = '您輸入的似乎是一個外部鏈結，你是否需要在網址開頭加入必要的 http://？';
$string['advanced_dlg:link_list'] = '鏈結列表';
$string['advanced_dlg:link_target'] = '目標';
$string['advanced_dlg:link_target_blank'] = '在新窗口開啟鏈接';
$string['advanced_dlg:link_target_same'] = '在同一窗口開啟鏈接';
$string['advanced_dlg:link_title'] = '插入/編輯鏈接';
$string['advanced_dlg:link_titlefield'] = '標題';
$string['advanced_dlg:link_url'] = '鏈接的網址';
$string['advanced:dt'] = '定義術語';
$string['advanced:fontdefault'] = '字型';
$string['advanced:font_size'] = '字體大小';
$string['advanced:forecolor_desc'] = '選擇文字顏色';
$string['advanced:h1'] = '標題1';
$string['advanced:h2'] = '標題2';
$string['advanced:h3'] = '標題3';
$string['advanced:h4'] = '標題4';
$string['advanced:h5'] = '標題5';
$string['advanced:h6'] = '標題6';
$string['advanced:help_desc'] = '幫助說明';
$string['advanced:help_shortcut'] = '按ALT-F10 為工具欄。按ALT-0 為輔助說明';
$string['advanced:hr_desc'] = '插入水平線';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = '插入/編輯圖像';
$string['advanced:image_props_desc'] = '圖像屬性';
$string['advanced:indent_desc'] = '增加縮排';
$string['advanced:italic_desc'] = '斜體(Ctrl+I)';
$string['advanced:justifycenter_desc'] = '置中對齊';
$string['advanced:justifyfull_desc'] = '兩端對齊';
$string['advanced:justifyleft_desc'] = '靠左對齊';
$string['advanced:justifyright_desc'] = '靠右對齊';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = '插入/編輯鏈接';
$string['advanced:more_colors'] = '更多顏色....';
$string['advanced:newdocument'] = '您確認要清除所有內容嗎？';
$string['advanced:newdocument_desc'] = '新文件';
$string['advanced:numlist_desc'] = '插入/移除編號列表';
$string['advanced:outdent_desc'] = '減少縮排';
$string['advanced:paragraph'] = '段落';
$string['advanced:paste_desc'] = '貼上';
$string['advanced:path'] = '路徑';
$string['advanced:pre'] = '预排格式';
$string['advanced:redo_desc'] = '重做(Ctrl+Y)';
$string['advanced:removeformat_desc'] = '移除格式';
$string['advanced:rich_text_area'] = '豐富的文字區';
$string['advanced:samp'] = '代碼範例';
$string['advanced:shortcuts_desc'] = '使用輔助';
$string['advanced:striketrough_desc'] = '刪除線';
$string['advanced:style_select'] = '樣式';
$string['advanced:sub_desc'] = '下標';
$string['advanced:sup_desc'] = '上標';
$string['advanced:toolbar'] = '工具列';
$string['advanced:toolbar_focus'] = '跳到工具按鈕- Alt+Q，跳到編輯器- Alt-Z，跳到元件路徑- Alt-X。';
$string['advanced:underline_desc'] = '加底線(Ctrl+U)';
$string['advanced:undo_desc'] = '撤銷(Ctrl+Z)';
$string['advanced:unlink_desc'] = '取消超連結';
$string['advanced:visualaid_desc'] = '顯示/隱藏指引/不可見元件';
$string['advhr:advhr_desc'] = '插入水平線';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = '正常';
$string['advhr_dlg:noshade'] = '無陰影';
$string['advhr_dlg:size'] = '高';
$string['advhr_dlg:width'] = '寬';
$string['advhr_dlg:widthunits'] = '單位';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage_dlg:align'] = '對齊方式';
$string['advimage_dlg:align_baseline'] = '基線';
$string['advimage_dlg:align_bottom'] = '下方';
$string['advimage_dlg:align_left'] = '居左';
$string['advimage_dlg:align_middle'] = '居中';
$string['advimage_dlg:align_right'] = '居右';
$string['advimage_dlg:align_textbottom'] = '文字下方';
$string['advimage_dlg:align_texttop'] = '文字上方';
$string['advimage_dlg:align_top'] = '上方';
$string['advimage_dlg:alt'] = '圖像說明';
$string['advimage_dlg:alt_image'] = '替換的圖像';
$string['advimage_dlg:border'] = '邊框';
$string['advimage_dlg:classes'] = '類型';
$string['advimage_dlg:constrain_proportions'] = '鎖定比例';
$string['advimage_dlg:dialog_title'] = '插入/編輯圖像';
$string['advimage_dlg:dimensions'] = '尺寸';
$string['advimage_dlg:example_img'] = '預覽圖像';
$string['advimage_dlg:general'] = '一般';
$string['advimage_dlg:height'] = '高度';
$string['advimage_dlg:hspace'] = '水平間距';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = '圖像列表';
$string['advimage_dlg:langcode'] = '語言編碼';
$string['advimage_dlg:langdir'] = '語言書寫方向';
$string['advimage_dlg:list'] = '圖像列表';
$string['advimage_dlg:long_desc'] = '链接描述';
$string['advimage_dlg:ltr'] = '由左到右';
$string['advimage_dlg:map'] = '圖像熱點';
$string['advimage_dlg:misc'] = '其它';
$string['advimage_dlg:missing_alt'] = '是否確定不為圖像加入說明文字？若沒有加入說明文字，當使用者使用不讀入圖像或文字體的流覽器時，將會看不到這個圖像。';
$string['advimage_dlg:mouseout'] = '滑鼠移出';
$string['advimage_dlg:mouseover'] = '滑鼠移入';
$string['advimage_dlg:preview'] = '預覽';
$string['advimage_dlg:rtl'] = '由右到左';
$string['advimage_dlg:src'] = '圖像網址';
$string['advimage_dlg:style'] = '樣式';
$string['advimage_dlg:swap_image'] = '交替圖像';
$string['advimage_dlg:tab_advanced'] = '進階';
$string['advimage_dlg:tab_appearance'] = '外觀';
$string['advimage_dlg:tab_general'] = '一般';
$string['advimage_dlg:title'] = '查找';
$string['advimage_dlg:vspace'] = '垂直間距';
$string['advimage_dlg:width'] = '寬度';
$string['advimage:image_desc'] = '插入/編輯圖像';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink_dlg:accesskey'] = '快速鍵';
$string['advlink_dlg:advanced_props'] = '高级属性';
$string['advlink_dlg:advanced_tab'] = '高级';
$string['advlink_dlg:anchor_names'] = '锚点';
$string['advlink_dlg:classes'] = '类型';
$string['advlink_dlg:encoding'] = '编码';
$string['advlink_dlg:event_props'] = '事件';
$string['advlink_dlg:events_tab'] = '事件';
$string['advlink_dlg:general_props'] = '一般屬性';
$string['advlink_dlg:general_tab'] = '一般';
$string['advlink_dlg:height'] = '高度';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = '你輸入的網址看起來像是一個郵件地址。你要不要在地址的前端加上mailto:？';
$string['advlink_dlg:is_external'] = '你輸入的網址看起來像是一個外部連結。你要不要在網址的前端加上http://？';
$string['advlink_dlg:langcode'] = '语言编码';
$string['advlink_dlg:langdir'] = '语言书写方向';
$string['advlink_dlg:link_list'] = '链接列表';
$string['advlink_dlg:list'] = '链接列表';
$string['advlink_dlg:ltr'] = '由左到右';
$string['advlink_dlg:mime'] = '目標MIME類型';
$string['advlink_dlg:popup'] = 'Javascript彈出視窗';
$string['advlink_dlg:popup_dependent'] = '从属(只有Mozilla/Firefox有效)';
$string['advlink_dlg:popup_location'] = '显示网址列';
$string['advlink_dlg:popup_menubar'] = '显示菜单';
$string['advlink_dlg:popup_name'] = '視窗名稱';
$string['advlink_dlg:popup_opts'] = '选项';
$string['advlink_dlg:popup_position'] = '座標(X/Y)';
$string['advlink_dlg:popup_props'] = '窗口属性';
$string['advlink_dlg:popup_resizable'] = '可调整窗口尺寸';
$string['advlink_dlg:popup_return'] = '插入\'return false\'';
$string['advlink_dlg:popup_scrollbars'] = '显示边条';
$string['advlink_dlg:popup_size'] = '尺寸';
$string['advlink_dlg:popup_statusbar'] = '显示状态区';
$string['advlink_dlg:popup_tab'] = '快显窗口';
$string['advlink_dlg:popup_toolbar'] = '显示工具列';
$string['advlink_dlg:popup_url'] = '窗口网址';
$string['advlink_dlg:rel'] = '頁面到目標的關係';
$string['advlink_dlg:rev'] = '目標到頁面的關係';
$string['advlink_dlg:rtl'] = '由右到左';
$string['advlink_dlg:style'] = '样式';
$string['advlink_dlg:tabindex'] = '分頁索引';
$string['advlink_dlg:target'] = '目標';
$string['advlink_dlg:target_blank'] = '打开在新窗口';
$string['advlink_dlg:target_langcode'] = '目標語言';
$string['advlink_dlg:target_name'] = '目標名稱';
$string['advlink_dlg:target_parent'] = '在上層視窗/框架開啟';
$string['advlink_dlg:target_same'] = '在這一窗口/框架開啟';
$string['advlink_dlg:target_top'] = '在最上層的框架中開啟(替換所有的框架)';
$string['advlink_dlg:title'] = '插入/編輯鏈接';
$string['advlink_dlg:titlefield'] = '查找';
$string['advlink_dlg:url'] = '链接地址';
$string['advlink_dlg:width'] = '寬度';
$string['advlink:link_desc'] = '插入/編輯鏈接';
$string['advlist:circle'] = '圓圈';
$string['advlist:def'] = '預設';
$string['advlist:disc'] = '圓盤';
$string['advlist:lower_alpha'] = '小寫的英文字';
$string['advlist:lower_greek'] = '小寫的希臘文字';
$string['advlist:lower_roman'] = '小寫的羅馬數字';
$string['advlist:square'] = '方形';
$string['advlist:types'] = '類型';
$string['advlist:upper_alpha'] = '大寫的英文字';
$string['advlist:upper_roman'] = '大寫的羅馬數字';
$string['aria:rich_text_area'] = '豐富的文字區';
$string['autosave:restore_content'] = '回復自動儲存的內容。';
$string['autosave:unload_msg'] = '如果离开此页面将导致所做的更改全部遗失。';
$string['autosave:warning_message'] = '如果您要回復已儲存的內容，您將失去目前正在編輯的內容。您確定要回復已儲存的內容嗎？';
$string['availablebuttons'] = '可使用的按鈕';
$string['colors:000000'] = '黑色';
$string['colors:000080'] = '深藍色';
$string['colors:0000FF'] = '藍色';
$string['colors:003300'] = '深綠色';
$string['colors:003366'] = '深蔚藍色';
$string['colors:008000'] = '綠色';
$string['colors:008080'] = '蒂爾';
$string['colors:00CCFF'] = '天藍色';
$string['colors:00FF00'] = '石灰色';
$string['colors:00FFFF'] = '水綠色';
$string['colors:333300'] = '深橄欖色';
$string['colors:333333'] = '深灰色';
$string['colors:333399'] = '靛青色';
$string['colors:3366FF'] = '皇家藍色';
$string['colors:339966'] = '海藻綠色';
$string['colors:33CCCC'] = '綠松石色';
$string['colors:666699'] = '灰藍色';
$string['colors:800000'] = '栗色';
$string['colors:800080'] = '紫色';
$string['colors:808000'] = '橄欖色';
$string['colors:808080'] = '灰色';
$string['colors:993300'] = '焦橙色';
$string['colors:993366'] = '棕色';
$string['colors:999999'] = '中灰色';
$string['colors:99CC00'] = '黃綠色';
$string['colors:99CCFF'] = '淺天藍色';
$string['colors:C0C0C0'] = '銀色';
$string['colors:CC99FF'] = '杏紅色';
$string['colors:CCFFCC'] = '淺綠色';
$string['colors:CCFFFF'] = '淺青色';
$string['colors:FF0000'] = '紅色';
$string['colors:FF00FF'] = '洋紅色';
$string['colors:FF6600'] = '橙色';
$string['colors:FF9900'] = '琥珀色';
$string['colors:FF99CC'] = '粉紅色';
$string['colors:FFCC00'] = '金色';
$string['colors:FFCC99'] = '桃色';
$string['colors:FFFF00'] = '黃色';
$string['colors:FFFF99'] = '淺黃色';
$string['colors:FFFFFF'] = '白色';
$string['common:apply'] = '应用';
$string['common:browse'] = '浏览';
$string['common:cancel'] = '取消';
$string['common:class_name'] = '样式';
$string['common:clipboard_msg'] = '在Mozilla和Firefox中無法使用複製/剪下/貼上的功能。你是否需要了解有關此問題的更多訊息？';
$string['common:clipboard_no_support'] = '未支持您的浏览器，请使用键盘快速键';
$string['common:close'] = '關閉';
$string['common:edit_confirm'] = '是否切换到「所见即所得」模式？';
$string['common:insert'] = '插入';
$string['common:invalid_data'] = '錯誤: 輸入無效值，已被標示為紅色。';
$string['common:invalid_data_min'] = '{#field} 必須是一個數字大於 {#min}';
$string['common:invalid_data_number'] = '{#field} 必須是一個數字';
$string['common:invalid_data_size'] = '{#field} 必須是數字或百分比';
$string['common:more_colors'] = '更多顏色....';
$string['common:not_set'] = '--未设置--';
$string['common:popup_blocked'] = '抱歉！快显窗口已被阻止，请调整浏览器设置，允许此网站可弹出新窗口，以便使用此工具';
$string['common:update'] = '更新';
$string['common:value'] = '(值)';
$string['contextmenu:align'] = '對齊方式';
$string['contextmenu:center'] = '居中';
$string['contextmenu:full'] = '两端對齊';
$string['contextmenu:left'] = '居左';
$string['contextmenu:right'] = '居右';
$string['customconfig'] = '自定環境';
$string['customconfig_desc'] = '在 JSON 格式的自行定義的進階 TimyMCE 配置，例如：{"option1" : "value2", "option2" : "value2"}。在此指定的任何選項會覆蓋標準和插件的設定。';
$string['customtoolbar'] = '編輯器工具列';
$string['customtoolbar_desc'] = '每一行包含一系列按鈕的名稱，並以逗點隔開。使用"wrap"來隔開群組。空白行會被忽略不管。
參見 <a href="{$a}" target="_blank">{$a}</a> 來查看 TinyMCE 預設按鈕的清單。<br />
工具列的第一列永遠會顯示出來，而第二列和第三列則可以切換為是否可以看見。';
$string['directionality:ltr_desc'] = '文字从左到右';
$string['directionality:rtl_desc'] = '文字从右到左';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = '冷酷';
$string['emotions_dlg:cry'] = '哭泣';
$string['emotions_dlg:desc'] = '表情圖像';
$string['emotions_dlg:embarassed'] = '尴尬';
$string['emotions_dlg:foot_in_mouth'] = '咧嘴';
$string['emotions_dlg:frown'] = '皱眉';
$string['emotions_dlg:innocent'] = '天真';
$string['emotions_dlg:kiss'] = '吻';
$string['emotions_dlg:laughing'] = '大笑';
$string['emotions_dlg:money_mouth'] = '发财';
$string['emotions_dlg:sealed'] = '保密';
$string['emotions_dlg:smile'] = '微笑';
$string['emotions_dlg:surprised'] = '惊吓';
$string['emotions_dlg:title'] = '插入表情圖像';
$string['emotions_dlg:tongue_out'] = '吐舌头';
$string['emotions_dlg:undecided'] = '考虑';
$string['emotions_dlg:usage'] = '使用左和右方向鍵導覽。';
$string['emotions_dlg:wink'] = '眨眼';
$string['emotions_dlg:yell'] = '叫嚷';
$string['emotions:emotions_desc'] = '表情圖像';
$string['fontselectlist'] = '可使用的字型列表';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = '文文件属性';
$string['fullpage_dlg:active_color'] = 'Active颜色';
$string['fullpage_dlg:add'] = '添加新元素';
$string['fullpage_dlg:add_base'] = 'Base元素';
$string['fullpage_dlg:add_comment'] = 'Comment node';
$string['fullpage_dlg:add_link'] = 'Link元素';
$string['fullpage_dlg:add_meta'] = 'Meta元素';
$string['fullpage_dlg:add_script'] = 'Script元素';
$string['fullpage_dlg:add_style'] = 'Style元素';
$string['fullpage_dlg:add_title'] = '查找元素';
$string['fullpage_dlg:advanced_props'] = '高级';
$string['fullpage_dlg:advanced_tab'] = '高级';
$string['fullpage_dlg:appearance_bgprops'] = '背景属性';
$string['fullpage_dlg:appearance_linkprops'] = '链接颜色';
$string['fullpage_dlg:appearance_marginprops'] = 'Body margins';
$string['fullpage_dlg:appearance_style'] = '样式表及样式属性';
$string['fullpage_dlg:appearance_tab'] = '外观';
$string['fullpage_dlg:appearance_textprops'] = '文字属性';
$string['fullpage_dlg:author'] = '作者';
$string['fullpage_dlg:base_element'] = 'Base element';
$string['fullpage_dlg:bgcolor'] = '背景颜色';
$string['fullpage_dlg:bgimage'] = '背景圖像';
$string['fullpage_dlg:bottom_margin'] = '下边界';
$string['fullpage_dlg:charset'] = '字符集';
$string['fullpage_dlg:comment_element'] = 'Comment';
$string['fullpage_dlg:content'] = '内容';
$string['fullpage_dlg:copyright'] = '版权';
$string['fullpage_dlg:defer'] = '延迟';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = '字符编码';
$string['fullpage_dlg:fontface'] = '字形体系';
$string['fullpage_dlg:font_face'] = '字体';
$string['fullpage_dlg:fontsize'] = '字体大小';
$string['fullpage_dlg:font_size'] = '字体尺寸';
$string['fullpage_dlg:general_props'] = '一般';
$string['fullpage_dlg:head_elements'] = 'Head元素';
$string['fullpage_dlg:hover_color'] = 'Hover颜色';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = '信息';
$string['fullpage_dlg:langcode'] = '语言编码';
$string['fullpage_dlg:langdir'] = '语言书写方向';
$string['fullpage_dlg:langprops'] = '语言与编码';
$string['fullpage_dlg:language'] = '语言';
$string['fullpage_dlg:left_margin'] = '左边界';
$string['fullpage_dlg:link_color'] = '链接颜色';
$string['fullpage_dlg:link_element'] = 'Link element';
$string['fullpage_dlg:ltr'] = '由左到右';
$string['fullpage_dlg:media'] = '媒体';
$string['fullpage_dlg:meta_description'] = '内容说明';
$string['fullpage_dlg:meta_element'] = 'Meta element';
$string['fullpage_dlg:meta_index_follow'] = 'Index and follow the links';
$string['fullpage_dlg:meta_index_nofollow'] = 'Index and don\'t follow the links';
$string['fullpage_dlg:meta_keywords'] = '关键词';
$string['fullpage_dlg:meta_noindex_follow'] = 'Do not index but follow the links';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Do not index and don\'t follow the links';
$string['fullpage_dlg:meta_props'] = '後設( Meta )訊息';
$string['fullpage_dlg:meta_robots'] = '機器人';
$string['fullpage_dlg:meta_tab'] = '一般';
$string['fullpage_dlg:meta_title'] = '標題';
$string['fullpage_dlg:movedown'] = '下移選出的元素';
$string['fullpage_dlg:moveup'] = '上移選出的元素';
$string['fullpage_dlg:name'] = '名稱';
$string['fullpage_dlg:properties'] = '属性';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = '移除选定元素';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = '右邊界';
$string['fullpage_dlg:rtl'] = '由右到左';
$string['fullpage_dlg:script_element'] = '腳本元素';
$string['fullpage_dlg:src'] = '資源';
$string['fullpage_dlg:style'] = '樣式';
$string['fullpage_dlg:style_element'] = '樣式元素';
$string['fullpage_dlg:stylesheet'] = '樣式表';
$string['fullpage_dlg:target'] = '目標';
$string['fullpage_dlg:textcolor'] = '颜色';
$string['fullpage_dlg:text_color'] = '文字颜色';
$string['fullpage_dlg:title'] = '文件属性';
$string['fullpage_dlg:title_element'] = '標題元素';
$string['fullpage_dlg:top_margin'] = '上邊界';
$string['fullpage_dlg:type'] = '類型';
$string['fullpage_dlg:value'] = '值';
$string['fullpage_dlg:visited_color'] = 'Visited颜色';
$string['fullpage_dlg:xml_pi'] = 'XML宣告';
$string['fullscreen:desc'] = '切換全螢幕模式';
$string['iespell:download'] = '未检测到ieSpell的存在。是否现在立即安装？';
$string['iespell:iespell_desc'] = '拼字檢查';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = '星期日,星期一,星期二,星期三,星期四,星期五,星期六,星期日';
$string['insertdatetime:day_short'] = '周日,周一,周二,周三,周四,周五,周六,周日';
$string['insertdatetime:insertdate_desc'] = '插入今天日期';
$string['insertdatetime:inserttime_desc'] = '插入现在时间';
$string['insertdatetime:months_long'] = '一月,二月,三月,四月,五月,六月,七月,八月,九月,十月,十一月,十二月';
$string['insertdatetime:months_short'] = '1月,2月,3月,4月,5月,6月,7月,8月,9月,10月,11月,12月';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = '开关绝对位置';
$string['layer:backward_desc'] = '置后';
$string['layer:content'] = '新建图层...';
$string['layer:forward_desc'] = '置前';
$string['layer:insertlayer_desc'] = '插入图层';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = '插入/編輯鏈接鑲入媒體';
$string['media_dlg:advanced'] = '高级';
$string['media_dlg:align'] = '對齊';
$string['media_dlg:align_bottom'] = '下方';
$string['media_dlg:align_bottom_left'] = '左下';
$string['media_dlg:align_bottom_right'] = '右下';
$string['media_dlg:align_center'] = '中間';
$string['media_dlg:align_left'] = '靠左';
$string['media_dlg:align_right'] = '靠右';
$string['media_dlg:align_top'] = '上方';
$string['media_dlg:align_top_left'] = '左上';
$string['media_dlg:align_top_right'] = '右上';
$string['media_dlg:altsource1'] = '替換來源1';
$string['media_dlg:altsource2'] = '替換來源2';
$string['media_dlg:audio'] = 'HTML5聲音';
$string['media_dlg:autogotourl'] = '自動轉到URL';
$string['media_dlg:autohref'] = '自動HREF';
$string['media_dlg:autostart'] = '自動開始';
$string['media_dlg:balance'] = '平衡';
$string['media_dlg:base'] = '基底';
$string['media_dlg:baseurl'] = '基準網址';
$string['media_dlg:bgcolor'] = '背景顏色';
$string['media_dlg:cache'] = '快取';
$string['media_dlg:captioningid'] = '字幕 ID';
$string['media_dlg:center'] = '中心';
$string['media_dlg:class_name'] = '類型';
$string['media_dlg:console'] = '控制台';
$string['media_dlg:constrain_proportions'] = '鎖定比例';
$string['media_dlg:controller'] = '控制台';
$string['media_dlg:controls'] = '控制器';
$string['media_dlg:correction'] = '没有修正';
$string['media_dlg:currentmarker'] = '目前標記';
$string['media_dlg:currentposition'] = '目前位置';
$string['media_dlg:defaultframe'] = '預設畫面';
$string['media_dlg:embeddedaudio'] = '嵌入式聲音';
$string['media_dlg:embedded_audio_options'] = '嵌入式聲音選項';
$string['media_dlg:enabled'] = '啟用';
$string['media_dlg:enablejavascript'] = '啟用JavaScript';
$string['media_dlg:endtime'] = '結束時間';
$string['media_dlg:file'] = '檔案/網址';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash 選項';
$string['media_dlg:flashvars'] = 'Flash 變數';
$string['media_dlg:fullscreen'] = '全螢幕';
$string['media_dlg:general'] = '一般';
$string['media_dlg:hidden'] = '隱藏';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = '水平間距';
$string['media_dlg:html5_audio_options'] = '聲音選項';
$string['media_dlg:html5_video_options'] = 'HTML5影片選項';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = '圖像狀態';
$string['media_dlg:invokeurls'] = '調用網址';
$string['media_dlg:kioskmode'] = 'Kiosk模式';
$string['media_dlg:list'] = '列表';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = '循環播放';
$string['media_dlg:maintainaspect'] = 'Maintain aspect';
$string['media_dlg:menu'] = '顯示選單';
$string['media_dlg:mute'] = '静音';
$string['media_dlg:name'] = '名稱';
$string['media_dlg:nojava'] = '禁用 java';
$string['media_dlg:numloop'] = '循環次數';
$string['media_dlg:play'] = '自動撥放';
$string['media_dlg:playcount'] = '播放次數';
$string['media_dlg:playeveryframe'] = '逐幀撥放';
$string['media_dlg:poster'] = '海報';
$string['media_dlg:prefetch'] = '預先讀取';
$string['media_dlg:preload'] = '預載';
$string['media_dlg:preload_auto'] = '讓用戶的瀏覽器決定';
$string['media_dlg:preload_metadata'] = '預載影片的後設資料';
$string['media_dlg:preload_none'] = '不要預載';
$string['media_dlg:preview'] = '預覽';
$string['media_dlg:progress'] = '進度';
$string['media_dlg:qt_options'] = 'Quicktime選項';
$string['media_dlg:qtsrc'] = 'QT 資源';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:qt_stream_warn'] = '串流式RTSP資源應該添加到進階分頁下的QT資源欄位中。你也應該同時添加一個非串流的版本到這資源欄位中。';
$string['media_dlg:quality'] = '品質';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = '影格率';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Real media player選項';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = '比例';
$string['media_dlg:scriptcallbacks'] = '脚本回档';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave選項';
$string['media_dlg:shuffle'] = '隨機排列';
$string['media_dlg:size'] = '尺寸';
$string['media_dlg:sound'] = '聲音';
$string['media_dlg:source'] = '來源';
$string['media_dlg:starttime'] = '開始時間';
$string['media_dlg:stretchtofit'] = '展延以符合大小';
$string['media_dlg:swstretchhalign'] = '水平方向展延';
$string['media_dlg:swstretchstyle'] = '展延模式';
$string['media_dlg:swstretchvalign'] = '垂直方向展延';
$string['media_dlg:target'] = '目標';
$string['media_dlg:targetcache'] = '目標快取';
$string['media_dlg:title'] = '插入/編輯鑲入媒體';
$string['media_dlg:type'] = '類型';
$string['media_dlg:uimode'] = '面板模式';
$string['media_dlg:video'] = 'HTML5影片';
$string['media_dlg:volume'] = '音量';
$string['media_dlg:vspace'] = '垂直間距';
$string['media_dlg:windowlessvideo'] = '無邊框影片';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = '窗口模式';
$string['media_dlg:wmp_options'] = 'Windows media player選項';
$string['media:edit'] = '編輯嵌入式媒體';
$string['nonbreaking:nonbreaking_desc'] = '插入空格';
$string['pagebreak:desc'] = '插入分頁符號以便列印';
$string['paste_dlg:text_linebreaks'] = '保留跳行符號';
$string['paste_dlg:text_title'] = '在你的鍵盤上同時按下CTRL和V鍵，可以把文字貼上這視窗。';
$string['paste_dlg:word_title'] = '在你的鍵盤上同時按下CTRL和V鍵，可以把文字貼上這視窗。';
$string['paste:paste_text_desc'] = '以純文字格式貼上';
$string['paste:paste_word_desc'] = '從Word貼上';
$string['paste:plaintext_mode'] = '貼上現在是處於純文字模式。再次點按切換回普通的貼上模式。
在你貼上某物之後，你將會回到普通貼上模式。';
$string['paste:plaintext_mode_stick'] = '現在是在純文字貼上。再次切換回普通貼上模式。';
$string['paste:selectall_desc'] = '全選';
$string['pluginname'] = 'TinyMCE HTML編輯器';
$string['preview:preview_desc'] = '預覽';
$string['print:print_desc'] = '列印';
$string['save:cancel_desc'] = '取消更改';
$string['save:save_desc'] = '保存';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = '所有出現的搜尋字串都會被替換';
$string['searchreplace_dlg:direction'] = '方向';
$string['searchreplace_dlg:down'] = '向下';
$string['searchreplace_dlg:findnext'] = '找下一個';
$string['searchreplace_dlg:findwhat'] = '查尋找的目標';
$string['searchreplace_dlg:mcase'] = '大小寫相符';
$string['searchreplace_dlg:notfound'] = '搜尋已經完成，沒有找到要搜尋的字串。';
$string['searchreplace_dlg:replace'] = '替換';
$string['searchreplace_dlg:replaceall'] = '替換全部';
$string['searchreplace_dlg:replace_title'] = '查找/替換';
$string['searchreplace_dlg:replacewith'] = '替換為';
$string['searchreplace_dlg:searchnext_desc'] = '再次查找';
$string['searchreplace_dlg:search_title'] = '查找';
$string['searchreplace_dlg:up'] = '向上';
$string['searchreplace:replace_desc'] = '查找/替換';
$string['searchreplace:search_desc'] = '查找';
$string['settings'] = '一般設定';
$string['simple:bold_desc'] = '粗體(Ctrl+B)';
$string['simple:bullist_desc'] = '插入/移除項目列表';
$string['simple:cleanup_desc'] = '清理雜亂代碼';
$string['simple:italic_desc'] = '斜體(Ctrl+I)';
$string['simple:numlist_desc'] = '插入/移除編號列表';
$string['simple:redo_desc'] = '重做(Ctrl+Y)';
$string['simple:striketrough_desc'] = '刪除線';
$string['simple:underline_desc'] = '加底線(Ctrl+U)';
$string['simple:undo_desc'] = '撤消(Ctrl+Z)';
$string['spellchecker:desc'] = '切換拼字檢查器';
$string['spellchecker:ignore_word'] = '略過字';
$string['spellchecker:ignore_words'] = '全部略過';
$string['spellchecker:langs'] = '語言';
$string['spellchecker:learn_word'] = '學習字';
$string['spellchecker:menu'] = '拼字檢查器的設定';
$string['spellchecker:no_mpell'] = '沒發現拼寫錯誤';
$string['spellchecker:no_sug'] = '無拼寫上的建議';
$string['spellchecker:sug'] = '建議的字詞';
$string['spellchecker:wait'] = '請稍後...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = '編輯CSS樣式表';
$string['style_dlg:apply'] = '應用';
$string['style_dlg:background'] = '背景';
$string['style_dlg:background_attachment'] = '附件';
$string['style_dlg:background_color'] = '背景颜色';
$string['style_dlg:background_hpos'] = '水平位置';
$string['style_dlg:background_image'] = '背景圖像';
$string['style_dlg:background_repeat'] = '重複';
$string['style_dlg:background_tab'] = '背景';
$string['style_dlg:background_vpos'] = '水平位置';
$string['style_dlg:block'] = '阻止';
$string['style_dlg:block_display'] = '顯示';
$string['style_dlg:block_letterspacing'] = '字符間距';
$string['style_dlg:block_tab'] = '區塊';
$string['style_dlg:block_text_align'] = '文字對齊';
$string['style_dlg:block_text_indent'] = '文字縮排';
$string['style_dlg:block_vertical_alignment'] = '水平對齊方式';
$string['style_dlg:block_whitespace'] = '空白';
$string['style_dlg:block_wordspacing'] = '單字間距';
$string['style_dlg:border'] = '邊框';
$string['style_dlg:border_tab'] = '邊框';
$string['style_dlg:bottom'] = '下方';
$string['style_dlg:box'] = 'Box';
$string['style_dlg:box_clear'] = '清除';
$string['style_dlg:box_float'] = '浮動';
$string['style_dlg:box_height'] = '高度';
$string['style_dlg:box_tab'] = '箱型';
$string['style_dlg:box_width'] = '寬度';
$string['style_dlg:bullet_image'] = '項目圖示';
$string['style_dlg:clip'] = '剪輯';
$string['style_dlg:color'] = '颜色';
$string['style_dlg:height'] = '高度';
$string['style_dlg:left'] = '居左';
$string['style_dlg:list'] = '列表';
$string['style_dlg:list_tab'] = '列表';
$string['style_dlg:list_type'] = '类型';
$string['style_dlg:margin'] = '邊界';
$string['style_dlg:overflow'] = '溢出';
$string['style_dlg:padding'] = '留白';
$string['style_dlg:placement'] = '布置';
$string['style_dlg:position'] = '位置';
$string['style_dlg:positioning_tab'] = '位置';
$string['style_dlg:positioning_type'] = '類型';
$string['style_dlg:right'] = '居右';
$string['style_dlg:same'] = '全部一樣';
$string['style_dlg:style'] = '樣式';
$string['style_dlg:text'] = '文字';
$string['style_dlg:text_blink'] = '閃爍';
$string['style_dlg:text_case'] = '大小寫';
$string['style_dlg:text_color'] = '顏色';
$string['style_dlg:text_decoration'] = '裝飾';
$string['style_dlg:text_font'] = '字型';
$string['style_dlg:text_lineheight'] = '行高';
$string['style_dlg:text_none'] = '無';
$string['style_dlg:text_overline'] = '加頂線';
$string['style_dlg:text_props'] = '文字';
$string['style_dlg:text_size'] = '尺寸';
$string['style_dlg:text_striketrough'] = '刪除線';
$string['style_dlg:text_style'] = '樣式';
$string['style_dlg:text_tab'] = '文字';
$string['style_dlg:text_underline'] = '加底線';
$string['style_dlg:text_variant'] = '变形';
$string['style_dlg:text_weight'] = '寬度';
$string['style_dlg:title'] = '編輯CSS樣式表';
$string['style_dlg:toggle_insert_span'] = '在選擇的地方插入span';
$string['style_dlg:top'] = '上方';
$string['style_dlg:visibility'] = '可見性';
$string['style_dlg:width'] = '寬度';
$string['style_dlg:zindex'] = 'Z轴深度';
$string['subplugintype_tinymce'] = '外插';
$string['subplugintype_tinymce_plural'] = '外掛';
$string['table:cell'] = '細格';
$string['table:cell_desc'] = '細格屬性';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = '縱行';
$string['table:col_after_desc'] = '在右側插入縱行';
$string['table:col_before_desc'] = '在左側插入縱行';
$string['table:copy_row_desc'] = '複製表格橫列';
$string['table:cut_row_desc'] = '剪下表格橫列';
$string['table:del'] = '删除表格';
$string['table:delete_col_desc'] = '刪除縱行';
$string['table:delete_row_desc'] = '刪除橫列';
$string['table:desc'] = '插入/編輯表格';
$string['table_dlg:advanced_props'] = '進階屬性';
$string['table_dlg:advanced_tab'] = '進階';
$string['table_dlg:align'] = '對齊方式';
$string['table_dlg:align_bottom'] = '靠下方';
$string['table_dlg:align_default'] = '預設';
$string['table_dlg:align_left'] = '靠左';
$string['table_dlg:align_middle'] = '置中';
$string['table_dlg:align_right'] = '靠右';
$string['table_dlg:align_top'] = '靠上方';
$string['table_dlg:bgcolor'] = '背景顏色';
$string['table_dlg:bgimage'] = '背景圖像';
$string['table_dlg:border'] = '邊框';
$string['table_dlg:bordercolor'] = '邊框顏色';
$string['table_dlg:caption'] = '表格標題';
$string['table_dlg:cell_all'] = '更新表格內的全部細格';
$string['table_dlg:cell_cell'] = '更新所在的細格';
$string['table_dlg:cell_col'] = '更新縱行中的所有細格';
$string['table_dlg:cell_limit'] = '你已經超過最大的細格數{$cells}。';
$string['table_dlg:cellpadding'] = '細格留白';
$string['table_dlg:cell_row'] = '更新在橫列中的所有細格';
$string['table_dlg:cellspacing'] = '細格間距';
$string['table_dlg:cell_title'] = '細格屬性';
$string['table_dlg:cell_type'] = '細格類型';
$string['table_dlg:colgroup'] = '縱行分组';
$string['table_dlg:col_limit'] = '你已經超過最大的縱行數{$cols}。';
$string['table_dlg:cols'] = '縱行';
$string['table_dlg:frame'] = '框架';
$string['table_dlg:frame_all'] = '全部';
$string['table_dlg:frame_cols'] = '縱行';
$string['table_dlg:frame_groups'] = '群組';
$string['table_dlg:frame_none'] = '無';
$string['table_dlg:frame_rows'] = '橫列';
$string['table_dlg:general_props'] = '一般屬性';
$string['table_dlg:general_tab'] = '一般';
$string['table_dlg:height'] = '高度';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = '語言編碼';
$string['table_dlg:langdir'] = '語言書寫方向';
$string['table_dlg:ltr'] = '由左到右';
$string['table_dlg:merge_cells_title'] = '合併細格';
$string['table_dlg:mime'] = '目標MIME類型';
$string['table_dlg:missing_scope'] = '你確定要繼續，而不指定此表格的表頭？沒有它，可能有些人會看不懂顯示在此表格中的內容或資料。';
$string['table_dlg:row_all'] = '更新表格內的全部橫列';
$string['table_dlg:row_even'] = '更新表格內的偶數橫列';
$string['table_dlg:rowgroup'] = '橫列分組';
$string['table_dlg:row_limit'] = '你已經超過最大的橫列數{$rows}。';
$string['table_dlg:row_odd'] = '更新表格內的奇數橫列';
$string['table_dlg:row_row'] = '更新目前橫列';
$string['table_dlg:rows'] = '橫列';
$string['table_dlg:row_title'] = '橫列屬性';
$string['table_dlg:rowtype'] = '橫列的類型';
$string['table_dlg:rtl'] = '由右到左';
$string['table_dlg:rules'] = '尺規';
$string['table_dlg:rules_above'] = '上';
$string['table_dlg:rules_below'] = '下';
$string['table_dlg:rules_border'] = '邊框';
$string['table_dlg:rules_box'] = '方塊';
$string['table_dlg:rules_hsides'] = '水平邊';
$string['table_dlg:rules_lhs'] = '左邊';
$string['table_dlg:rules_rhs'] = '右邊';
$string['table_dlg:rules_void'] = '空';
$string['table_dlg:rules_vsides'] = '垂直邊';
$string['table_dlg:scope'] = '範圍';
$string['table_dlg:style'] = '樣式';
$string['table_dlg:summary'] = '概要';
$string['table_dlg:tbody'] = '表身';
$string['table_dlg:td'] = '數據';
$string['table_dlg:tfoot'] = '表尾';
$string['table_dlg:th'] = '表頭';
$string['table_dlg:thead'] = '表頭';
$string['table_dlg:title'] = '插入/編輯表格';
$string['table_dlg:valign'] = '垂直對齊';
$string['table_dlg:width'] = '寬度';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = '合併細格';
$string['table:paste_row_after_desc'] = '在下方貼上橫列';
$string['table:paste_row_before_desc'] = '在上方貼上橫列';
$string['table:props_desc'] = '表格属性';
$string['table:row'] = '橫列';
$string['table:row_after_desc'] = '在下方插入橫列';
$string['table:row_before_desc'] = '在上方插入橫列';
$string['table:row_desc'] = '橫列屬性';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = '拆開已合併的細格';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = '插入預先界定的樣版內容';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = '星期日，星期一，星期二，星期三，星期四，星期五，星期六，星期日';
$string['template_dlg:day_short'] = '周日，周一，周二，周三，周四，周五，周六，周日';
$string['template_dlg:desc'] = '插入預先界定的樣版內容';
$string['template_dlg:desc_label'] = '描述';
$string['template_dlg:label'] = '樣版';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = '一月，二月，三月，四月，五月，六月，七月，八月，九月，十月，十一月，十二月';
$string['template_dlg:months_short'] = '1月，2月，3月，4月，5月，6月，7月，8月，9月，10月，11月，12月';
$string['template_dlg:preview'] = '預覽';
$string['template_dlg:select'] = '選擇一樣版';
$string['template_dlg:title'] = '樣版標題';
$string['template_dlg:warning'] = '警告：更新樣版可能導致資料遺失。';
$string['visualblocks:desc'] = '顯示/隱藏區塊元素';
$string['visualchars:desc'] = '顯示/隱藏控制字元';
$string['wordcount:words'] = '字數：';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = '縮寫';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = '首字縮寫';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = '插入/編輯屬性';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = '引文';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = '删除';
$string['xhtmlxtras_dlg:attribs_title'] = '插入/編輯屬性';
$string['xhtmlxtras_dlg:attrib_tab'] = '属性';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = '属性';
$string['xhtmlxtras_dlg:attribute_events_tab'] = '事件';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = '快速键';
$string['xhtmlxtras_dlg:attribute_label_cite'] = '引文';
$string['xhtmlxtras_dlg:attribute_label_class'] = '類型';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = '日期/時間';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = '语言';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = '文字書寫方向';
$string['xhtmlxtras_dlg:attribute_label_style'] = '样式';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Tab索引';
$string['xhtmlxtras_dlg:attribute_label_title'] = '查找';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = '由左到右';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = '由右到左';
$string['xhtmlxtras_dlg:events_tab'] = '事件';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = '元素属性';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = '元素事件';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = '一般設定';
$string['xhtmlxtras_dlg:general_tab'] = '一般';
$string['xhtmlxtras_dlg:insert_date'] = '插入現在日期/時間';
$string['xhtmlxtras_dlg:option_ltr'] = '由左到右';
$string['xhtmlxtras_dlg:option_rtl'] = '由右到左';
$string['xhtmlxtras_dlg:remove'] = '删除';
$string['xhtmlxtras_dlg:title_abbr_element'] = '縮寫元素';
$string['xhtmlxtras_dlg:title_acronym_element'] = '首字縮寫元素';
$string['xhtmlxtras_dlg:title_cite_element'] = '引文元素';
$string['xhtmlxtras_dlg:title_del_element'] = '删除元素';
$string['xhtmlxtras_dlg:title_ins_element'] = '插入元素';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = '插入';
