<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'zh_tw', branch 'MOODLE_28_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = '即將開始安裝';
$string['action'] = '動作';
$string['actionchoice'] = '您想要怎麼處理這個檔案“{$a}”？';
$string['actions'] = '動作';
$string['active'] = '啟用';
$string['activeusers'] = '啟用的用戶';
$string['activities'] = '活動';
$string['activities_help'] = '各種活動，例如討論區、測驗和Wiki共筆，讓課程擁有各種互動內涵。';
$string['activity'] = '活動';
$string['activityclipboard'] = '搬移這個活動：{$a}';
$string['activityiscurrentlyhidden'] = '抱歉！此活動目前處於隱藏狀態';
$string['activitymodule'] = '活動模組';
$string['activitymodules'] = '活動模組';
$string['activityreport'] = '活動報表';
$string['activityreports'] = '活動報表';
$string['activityselect'] = '選擇把此活動搬移到其它地方';
$string['activitysince'] = '活動開始於 {$a}';
$string['activityweighted'] = '每個用戶的活動';
$string['add'] = '新增';
$string['addactivity'] = '新增活動...';
$string['addactivitytosection'] = '新增一個活動到單元 {$a}';
$string['addadmin'] = '新增網站管理員';
$string['addblock'] = '新增一個區塊';
$string['addcomment'] = '給予評論...';
$string['addcountertousername'] = '把用戶名稱增加上數字來建立用戶';
$string['addcreator'] = '新增課程管理員';
$string['adddots'] = '新增...';
$string['added'] = '新增 {$a}';
$string['addedrecip'] = '已加入{$a}位新收件人';
$string['addedrecips'] = '已加入{$a}位新收件人';
$string['addedtogroup'] = '已加入到群組“{$a}”';
$string['addedtogroupnot'] = '未加入群組“{$a}”';
$string['addedtogroupnotenrolled'] = '未加入群組“{$a}”，因為沒選修該課程';
$string['addfilehere'] = '將檔案新增在這裡';
$string['addinganew'] = '新增 {$a}';
$string['addinganewto'] = '新增 {$a->what} 到 {$a->to}';
$string['addingdatatoexisting'] = '新增資料到現有的';
$string['additionalnames'] = '附加名稱';
$string['addlinkhere'] = '在這裡增加網站連結';
$string['addnewcategory'] = '新增類別';
$string['addnewcourse'] = '新增課程';
$string['addnewuser'] = '新增一位用戶';
$string['addnousersrecip'] = '把還沒有進入{$a}的用戶加到收件人名單中';
$string['addpagehere'] = '在這裡新增文字';
$string['addresource'] = '新增資源...';
$string['addresourceoractivity'] = '新增活動或資源';
$string['addresourcetosection'] = '新增一個資源到單元 {$a}';
$string['address'] = '地址';
$string['addstudent'] = '新增學生';
$string['addsubcategory'] = '新增子類別';
$string['addteacher'] = '新增教師';
$string['admin'] = '管理';
$string['adminhelpaddnewuser'] = '手動建立一個新用戶帳號';
$string['adminhelpassignadmins'] = '網站管理員可以做任何事、到網站內任何地方';
$string['adminhelpassigncreators'] = '課程管理員可建立新課程、安排任課教師';
$string['adminhelpassignsiteroles'] = '套用已定義的網站角色到指定的用戶';
$string['adminhelpassignstudents'] = '進入一門課程，然後在管理選單中增加學生';
$string['adminhelpauthentication'] = '您可以使用系統內建帳號或外部資料庫';
$string['adminhelpbackup'] = '設定自動備份和備份排程';
$string['adminhelpconfiguration'] = '設定網站的外觀和操作方式';
$string['adminhelpconfigvariables'] = '設定網站的基本參數';
$string['adminhelpcourses'] = '定義課程及類別，指派用戶，編輯申請的課程';
$string['adminhelpeditorsettings'] = '定義HTML編輯器的基本設定';
$string['adminhelpedituser'] = '瀏覽帳號清單及編修這些資料';
$string['adminhelpenvironment'] = '檢查伺服器是否滿足目前及未來的安裝需求';
$string['adminhelpfailurelogs'] = '瀏覽登入錯誤的記錄';
$string['adminhelplanguage'] = '檢查和編輯現在的語言包';
$string['adminhelplogs'] = '瀏覽本網站上的所有活動日誌';
$string['adminhelpmanageblocks'] = '管理已安裝區塊和設定';
$string['adminhelpmanagedatabase'] = '直接存取資料庫(請小心！)';
$string['adminhelpmanagefilters'] = '選擇文字過濾和相關設定';
$string['adminhelpmanagemodules'] = '管理已安裝模組和設定';
$string['adminhelpmanageroles'] = '建立和定義可分配給用戶的角色';
$string['adminhelpmymoodle'] = '為用戶設定“我的Moodle”區塊';
$string['adminhelpreports'] = '網站層級報表';
$string['adminhelpsitefiles'] = '為了發佈一般檔案或上傳外部備份檔';
$string['adminhelpsitesettings'] = '定義網站首頁外觀';
$string['adminhelpstickyblocks'] = '設定Moodle全站的固定區塊';
$string['adminhelpthemes'] = '選擇網站佈景主題(例如字型、顏色等)';
$string['adminhelpuploadusers'] = '從文字檔匯入新的用戶帳號';
$string['adminhelpusers'] = '定義您的用戶和設定認證方式';
$string['adminhelpxmldbeditor'] = '編輯XMLDB檔案的介面。僅限開發人員。';
$string['administration'] = '管理';
$string['administrationsite'] = '網站管理';
$string['administrator'] = '網站管理員';
$string['administratordescription'] = '網站管理員通常可以在此網站上的所有課程進行任何事情。';
$string['administrators'] = '網站管理員';
$string['administratorsall'] = '所有管理員';
$string['administratorsandteachers'] = '管理員和教師';
$string['advanced'] = '進階';
$string['advancedfilter'] = '進階搜尋';
$string['advancedsettings'] = '進階設定';
$string['afterresource'] = '在資源"{$a}"之後';
$string['aftersection'] = '在單元"{$a}"之後';
$string['again'] = '再次';
$string['aimid'] = 'AIM 帳號';
$string['ajaxuse'] = 'AJAX與Javascript';
$string['all'] = '所有';
$string['allactions'] = '所有動作';
$string['allactivities'] = '所有活動';
$string['allcategories'] = '所有類別';
$string['allchanges'] = '所有變更';
$string['alldays'] = '所有日期';
$string['allfieldsrequired'] = '所有欄位都是必需的';
$string['allfiles'] = '所有檔案';
$string['allgroups'] = '所有群組';
$string['alllogs'] = '所有日誌';
$string['allmods'] = '所有 {$a}';
$string['allow'] = '允許';
$string['allowinternal'] = '也允許內部方法';
$string['allownone'] = '全部禁止';
$string['allownot'] = '不允許';
$string['allparticipants'] = '所有參與者';
$string['allteachers'] = '所有教師';
$string['alphanumerical'] = '只能包含字母、數字、橫線（-）或小數點（.）';
$string['alreadyconfirmed'] = '確認完成註冊手續';
$string['alternatename'] = '別名';
$string['always'] = '總是';
$string['and'] = '{$a->one} 與 {$a->two}';
$string['answer'] = '回答';
$string['any'] = '任何';
$string['appearance'] = '外觀';
$string['approve'] = '核准';
$string['areyousure'] = '你確定嗎？';
$string['areyousuretorestorethis'] = '確定要還原這個課程？';
$string['areyousuretorestorethisinfo'] = '稍後，您要選擇把此備份增加到一門現有課程中，還是建立一門新課程。';
$string['asc'] = '遞增';
$string['assessment'] = '評量';
$string['assignadmins'] = '指派網站管理員';
$string['assigncreators'] = '指派課程管理員';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = '指派網站層級的角色';
$string['authenticateduser'] = '已認證的用戶';
$string['authenticateduserdescription'] = '所有已登入的用戶';
$string['authentication'] = '身分認證';
$string['authenticationplugins'] = '身分認證外掛程式';
$string['autosubscribe'] = '討論區自動訂閱';
$string['autosubscribeno'] = '不：不要自動訂閱討論區';
$string['autosubscribeyes'] = '是：當我張貼文章時，就訂閱該討論區';
$string['availability'] = '可用性';
$string['availablecourses'] = '可使用的課程';
$string['back'] = '返回';
$string['backto'] = '回到{$a}';
$string['backtocourselisting'] = '回到課程列表';
$string['backtopageyouwereon'] = '回到剛才的頁面';
$string['backtoparticipants'] = '回到課程參與者清單';
$string['backup'] = '備份';
$string['backupactivehelp'] = '選擇是否進行自動備份。';
$string['backupcancelled'] = '備份已被取消';
$string['backupcoursefileshelp'] = '如果核選，該課程的檔案將被包含在自動備份檔中';
$string['backupdate'] = '備份日期';
$string['backupdatenew'] = 'nbsp; {$a->TAG} 現在是{$a->weekday}， {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} 是 {$a->weekday}，{$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br /> {$ A-> RECORDTYPE中}  -  {$ A-> recordname} <br />';
$string['backupdetails'] = '備份細節';
$string['backupexecuteathelp'] = '選擇在什麼時間自動執行備份';
$string['backupfailed'] = '您的一些課程尚未儲存!!';
$string['backupfilename'] = '備份';
$string['backupfinished'] = '備份完全成功';
$string['backupfromthissite'] = '這個網站已經備份過了嗎？';
$string['backupgradebookhistoryhelp'] = '如果啟用，成績單的歷程會被包含在自動備份中。注意，如果想使用這個功能，成績歷程就一定不能在伺服器設定中（disablegradehistory）被停用';
$string['backupincludemoduleshelp'] = '在自動備份中，選擇您是否要包含有或沒有用戶資料的課程模組';
$string['backupincludemoduleuserdatahelp'] = '選擇在自動備份時，是否要包含模組用戶的資料 。';
$string['backupkeephelp'] = '您想要為每門課程保存多少個最近的備份？ (會自動刪除比較舊的備份)';
$string['backuplogdetailed'] = '詳細的執行紀錄';
$string['backuploglaststatus'] = '最後執行的紀錄';
$string['backupmissinguserinfoperms'] = '注意：本次備份不包含使用者資料。"測驗"模組和"工作坊"模組與此備份不相容，所以它們完全不會被備份。';
$string['backupnext'] = '下一次備份';
$string['backupnonisowarning'] = '警告：這是來自於非unicode版本的Moodle(1.6以下）的備份。若此備份包含任個非ISO-8859-1文件，在回存於此Unicode版本的Moodle中，可能會發生中斷。關於如何正確備份的相關資訊，請看<a href="http://docs.moodle.org/en/Backup_FAQ">備份常見問答集</a>獲取更多關於正確還原備份的方法。';
$string['backupnotyetrun'] = '自動備份暫停';
$string['backuporiginalname'] = '備份檔名';
$string['backuproleassignments'] = '備份這些角色的角色指派';
$string['backupsavetohelp'] = '您要儲存備份檔案的目錄完整路徑<br/>(若留白，將使用課程預設的目錄)';
$string['backupsitefileshelp'] = '如果啟用，那麼課程中使用的網站檔案將自動包含在備份檔案中。';
$string['backuptakealook'] = '請看一下您的備份日誌檔在：{$a}';
$string['backupuserfileshelp'] = '選擇是否將用戶個人檔案(例如：個人照片)包含在自動備份檔中';
$string['backupversion'] = '備份版本';
$string['badges'] = '獎章';
$string['block'] = '區塊';
$string['blockconfiga'] = '設定{$a}區塊';
$string['blockconfigbad'] = '這個區塊未正確安裝，以致無法提供設定介面';
$string['blocks'] = '區塊';
$string['blocksaddedit'] = '新增/編輯區塊';
$string['blockseditoff'] = '關閉區塊編輯';
$string['blocksediton'] = '開啟區塊編輯';
$string['blocksetup'] = '設定區塊資料表';
$string['blocksuccess'] = '{$a}資料表已經正確設定了';
$string['brief'] = '簡要';
$string['bulkactions'] = '批量動作';
$string['bulkactionselect'] = '{$a}批量操作選擇';
$string['bulkmovecoursessuccess'] = '已成功移動{$a->courses}課程到{$a->category}';
$string['bycourseorder'] = '按課程順序';
$string['byname'] = '由{$a}';
$string['bypassed'] = '略過';
$string['cachecontrols'] = '快取控制';
$string['cancel'] = '取消';
$string['cancelled'] = '被取消';
$string['categories'] = '課程類別';
$string['categoriesandcoures'] = '課程類別和課程';
$string['category'] = '類別';
$string['categoryadded'] = '已經增加‘{$a}’類別';
$string['categorybulkaction'] = '隊選出類別的批量操作';
$string['categorycontents'] = '子類別和課程';
$string['categorycurrentcontents'] = '{$a}的內容';
$string['categorydeleted'] = '已刪除‘{$a}’類別';
$string['categoryduplicate'] = '類別名稱‘{$a}’已經存在';
$string['categorymodifiedcancel'] = '類別已經修改！請取消並且再試一次。';
$string['categoryname'] = '類別名稱';
$string['categorysubcategoryof'] = '{$a->category} - {$a->parentcategory}的下層類別';
$string['categoryupdated'] = '已經更新‘{$a}’類別';
$string['changedpassword'] = '更改後的密碼';
$string['changepassword'] = '更改密碼';
$string['changesmadereallygoaway'] = '您已經有變更。您確定要離開並放棄您修改的嗎？';
$string['changessaved'] = '更改的已經儲存';
$string['check'] = '檢查';
$string['checkall'] = '檢查所有';
$string['checkingbackup'] = '檢查備份中';
$string['checkingcourse'] = '檢查課程中';
$string['checkingforbbexport'] = '檢查BlackBoard的匯出中';
$string['checkinginstances'] = '檢查元件中';
$string['checkingsections'] = '檢查單元中';
$string['checklanguage'] = '檢查語言';
$string['checknone'] = '不檢查';
$string['childcoursenotfound'] = '找不到子課程！';
$string['childcourses'] = '子課程';
$string['choose'] = '選擇';
$string['choosecourse'] = '選擇課程';
$string['choosedots'] = '選擇...';
$string['chooselivelogs'] = '或查看目前的活動';
$string['chooselogs'] = '選擇您所想看的日誌';
$string['choosereportfilter'] = '為報表選擇一個過濾器';
$string['choosetheme'] = '選擇佈景主題';
$string['chooseuser'] = '選擇一位用戶';
$string['city'] = '縣/市';
$string['clambroken'] = '您的管理員已經啟動檔案上傳時的病毒檢查，但是有些設定不正確。<br/>您的檔案上傳失敗。系統已經發信給管理員通知他們修復這個錯誤。</br>請您稍後再重新上傳這個檔案。';
$string['clamdeletedfile'] = '檔案已被刪除';
$string['clamdeletedfilefailed'] = '檔案無法刪除';
$string['clamemailsubject'] = '{$a}:: Clam AV 警示';
$string['clamfailed'] = 'Clam AV 執行時發生錯誤。傳回的錯誤訊息是{$a}。下面是Clam輸出的資訊：';
$string['clamlost'] = 'Moodle已設定執行Clam檢查上傳的檔案，但是提供給Clam AV的路徑{$a}，是無效的。';
$string['clamlostandactinglikevirus'] = '此外，Moodle也設定若Clam執行失敗，檔案將視為病毒。意即若您沒有修復這個問題前，學生將無法成功地上傳檔案。';
$string['clammovedfile'] = '此檔案已經搬移至您指定的隔離目錄，新的位置是{$a}';
$string['clammovedfilebasic'] = '檔案已經搬移到隔離目錄了。';
$string['clamquarantinedirfailed'] = '無法將此檔案搬移至您指定的隔離目錄，{$a}。
如果發現它們含有病毒，您必須刪除此檔案以修正問題。';
$string['clamunknownerror'] = 'Clam 發生了不明的錯誤。';
$string['cleaningtempdata'] = '清除暫存資料';
$string['clear'] = '清空';
$string['clickhelpiconformoreinfo'] = '... 繼續... 點按輔助圖示可閱讀全文';
$string['clickhere'] = '點按這裡...';
$string['clicktochangeinbrackets'] = '{$a} (點按修改)';
$string['clicktohideshow'] = '點按展開或縮合';
$string['closebuttontitle'] = '關閉';
$string['closewindow'] = '關閉本視窗';
$string['collapse'] = '展延';
$string['collapseall'] = '全部縮合';
$string['collapsecategory'] = '摺疊{$a}';
$string['commentincontext'] = '在處境中尋找此評論';
$string['comments'] = '評論';
$string['commentscount'] = '評論數({$a})';
$string['commentsnotenabled'] = '評論功能未啟用';
$string['commentsrequirelogin'] = '你需要登入後才能檢視評論內容';
$string['comparelanguage'] = '比較並編輯目前語言';
$string['complete'] = '完全';
$string['completereport'] = '完整報告';
$string['configuration'] = '組態';
$string['confirm'] = '確認';
$string['confirmcheckfull'] = '您真的確定要批准{$a}嗎？';
$string['confirmcoursemove'] = '你確定要搬移這一課程({$a->course})到這一類別({$a->category})?';
$string['confirmed'] = '您的註冊已經獲准';
$string['confirmednot'] = '您的註冊尚未獲准！';
$string['content'] = '內容';
$string['continue'] = '繼續';
$string['continuetocourse'] = '按這裏進入您的課程';
$string['convertingwikitomarkdown'] = '把Wiki轉為Markdown';
$string['cookiesenabled'] = '您的瀏覽器必須啟動 Cookies 功能';
$string['cookiesenabled_help'] = '<p align="center"><b>Cookies</b></p><p>本站使用了兩個cookie。</p><p>最重要的是連線cookie，通常叫做<b>MoodleSession</b>。您必須在瀏覽器裡允許這個cookie，以便使您的登入在頁與頁之間連續有效。當您登離或關閉瀏覽器，這個cookie在瀏覽器和伺服器裡都會被刪除。</p><p>另一個cookie純粹是為了方便，通常被叫做類似<b>MOODLEID</b>之類的名字。它只用來在瀏覽器裡記住您的用戶名。這意味著當您再次回到本站，登入頁面裡的用戶名已經替您填好了。拒絕此cookie是安全的，只不過每次登入都要重新輸入用戶名而已。</p>';
$string['cookiesnotenabled'] = '不幸地，您所使用的瀏灠器的cookies功能目前未啟動';
$string['copy'] = '複製';
$string['copyasnoun'] = '複製';
$string['copyingcoursefiles'] = '複製課程檔案';
$string['copyingsitefiles'] = '正在複製課程中用到的網站檔案';
$string['copyinguserfiles'] = '複製用戶的檔案';
$string['copyingzipfile'] = '複製zip壓縮檔';
$string['copyrightnotice'] = '版權聲明';
$string['coresystem'] = '系統';
$string['cost'] = '費用';
$string['costdefault'] = '預設費用';
$string['counteditems'] = '{$a->count}{$a->items}';
$string['country'] = '國家';
$string['course'] = '課程';
$string['courseadministration'] = '課程管理';
$string['courseapprovedemail'] = '您申請的【{$a->name}】課程已經通過審核，同時也成為此課程{$a->teacher}。請由 {$a->url} 進入您的新課程。';
$string['courseapprovedemail2'] = '您申請的課程，{$a->name}，已經核准。若要存取您的新課程，請連線到 {$a->url}';
$string['courseapprovedfailed'] = '儲存課程審核失敗！';
$string['courseapprovedsubject'] = '您的開課申請已經審核通過！';
$string['courseavailable'] = '這課程學生可以使用';
$string['courseavailablenot'] = '這課程學生不能使用';
$string['coursebackup'] = '課程備份';
$string['coursebulkaction'] = '對選出課程的批量操作';
$string['coursecategories'] = '課程類別';
$string['coursecategory'] = '課程類別';
$string['coursecategorydeleted'] = '已刪除課程類別 {$a}';
$string['coursecategory_help'] = '這個設定值決定此課程將出現在課程清單的那一類別中。';
$string['coursecatmanagement'] = '課程和類別管理';
$string['coursecompletion'] = '課程進度';
$string['coursecompletions'] = '課程進度';
$string['coursecreators'] = '課程管理員';
$string['coursecreatorsdescription'] = '課程管理員可以建立新課程。';
$string['coursedeleted'] = '已刪除課程 {$a}';
$string['coursedisplay'] = '課程編排';
$string['coursedisplay_help'] = '此設置決定整個課程是否顯示在一個頁面，或分成幾個頁面。';
$string['coursedisplay_multi'] = '每頁顯示一個單元';
$string['coursedisplay_single'] = '在一個頁面上顯示全部單元';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = '舊版的課程檔案';
$string['coursefilesedit'] = '編輯舊版的課程檔案';
$string['coursefileswarning'] = '舊版的課程檔案功能已被廢棄';
$string['coursefileswarning_help'] = 'Moodle 2.0之後，課程檔案已捨棄不用。請盡可能改用外部倉儲資源。';
$string['courseformatdata'] = '課程格式資料';
$string['courseformatoptions'] = '{$a}的格式選項';
$string['courseformats'] = '課程格式';
$string['courseformatudpate'] = '更新格式';
$string['coursegrades'] = '課程成績';
$string['coursehelpcategory'] = '調整課程在課程列表的位置，可以讓學生更容易找到它。';
$string['coursehelpforce'] = '強制課程中所有活動都使用課程的群組模式。';
$string['coursehelpformat'] = '課程主頁將以此格式顯示';
$string['coursehelphiddensections'] = '課程中隱藏的單元要如何呈現給學生？';
$string['coursehelpmaximumupload'] = '訂定課程中學生上傳檔案的最大容量，同時也受到全網站設定的限制。';
$string['coursehelpnewsitemsnumber'] = '此設置決定要從公佈欄選出幾則最新消息，放在這課程頁面上的最新消息區塊中(如果設定為“0”，則最新消息區塊將不會顯示)。';
$string['coursehelpnumberweeks'] = '在課程主頁上，顯示的週次數或主題數。';
$string['coursehelpshowgrades'] = '啟用顯示成績單。這無法預防成績被顯示在個別的活動中。';
$string['coursehidden'] = '此課程目前並不對學生開放';
$string['courseinfo'] = '課程資訊';
$string['courselegacyfiles'] = '舊版的課程檔案';
$string['courselegacyfiles_help'] = '這課程檔案區提供 Moodle 1.9 或更早版本的相容性。在此課程所有參與者都可以存取本區的所有檔案(不管您是否有連結它們)，且沒有辦法知道在Moodle中是否有使用到這些檔案。

如果您使用這檔案區儲存課程檔案，您可能曝露您自己隱私及產生資安問題，還有在備份、課程匯入、分享或重複使用內容時遺失檔案。

所以建議您不要使用舊版檔案區，除非您真的知道您在做什麼。';
$string['courselegacyfilesofcourse'] = '流傳下來的課程檔案: {$a}';
$string['coursemessage'] = '傳訊息給課程用戶';
$string['coursenotaccessible'] = '這門課程未對公眾開放';
$string['courseoverview'] = '課程概況';
$string['courseoverviewfiles'] = '課程代表圖片';
$string['courseoverviewfilesext'] = '課程代表圖片類型';
$string['courseoverviewfiles_help'] = '課程代表圖片，將與課程摘要一起顯示在課程列表裡';
$string['courseoverviewfileslimit'] = '課程代表圖片檔案的限制';
$string['courseoverviewgraph'] = '課程概況圖';
$string['courseprofiles'] = '課程簡介';
$string['coursereasonforrejecting'] = '駁回申請的理由';
$string['coursereasonforrejectingemail'] = '將寄電子郵件給申請者';
$string['coursereject'] = '拒絕此開課申請';
$string['courserejected'] = '開課申請已拒絕，並且通知了申請者。';
$string['courserejectemail'] = '抱歉，您申請的課程已遭駁回。理由如下：{$a}';
$string['courserejectreason'] = '簡述您駁回此課程的理由<br/>(此理由將email給申請者）。';
$string['courserejectsubject'] = '您的開課申請被拒絕了';
$string['coursereport'] = '課程報表';
$string['coursereports'] = '課程報表';
$string['courserequest'] = '開課申請';
$string['courserequestdetails'] = '您申請課程的詳細資訊';
$string['courserequestfailed'] = '因故無法儲存您的課程申請。';
$string['courserequestintro'] = '使用此表格申請您要建立的課程。<br/>請您儘可能填寫完整的資料，讓管理者可以明白您申請這個課程的理由。';
$string['courserequestreason'] = '申請此課程的理由';
$string['courserequestsuccess'] = '已成功儲存您的開課申請資料。近日內，您將會收到審核結果的通知郵件。';
$string['courserequestsupport'] = '提供資訊幫助管理者審查您的開課申請。';
$string['courserestore'] = '還原課程';
$string['courses'] = '課程';
$string['coursesectionsummaries'] = '課程單元摘要';
$string['coursesectiontitle'] = '課程：{$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = '課程預設設定';
$string['coursesmovedout'] = '課程已從 {$a} 中移出';
$string['coursespending'] = '待審核的開課申請';
$string['coursestart'] = '課程開始';
$string['coursesummary'] = '課程摘要';
$string['coursesummary_help'] = '課程摘要顯示在課程清單中。課程搜尋除了課程名稱，也會搜尋此摘要資料。';
$string['coursetitle'] = '課程：{$a->course}';
$string['courseupdates'] = '更新課程';
$string['create'] = '建立';
$string['createaccount'] = '建立我的新帳號';
$string['createcategory'] = '建立類別';
$string['createfolder'] = '在 {$a} 建立一個新資料夾';
$string['createnew'] = '建立新的';
$string['createnewcategory'] = '建立新類別';
$string['createnewcourse'] = '建立新課程';
$string['createnewsubcategory'] = '建立新下層類別';
$string['createsubcategoryof'] = '建立{$a}的下層類別';
$string['createuser'] = '建立用戶';
$string['createuserandpass'] = '請選擇您的帳號名稱和密碼';
$string['createziparchive'] = '產生zip壓縮檔';
$string['creatingblocks'] = '建立區塊';
$string['creatingblocksroles'] = '建立區塊層級的角色指派與置換';
$string['creatingblogsinfo'] = '建立部落格資訊';
$string['creatingcategoriesandquestions'] = '建立類別和試題';
$string['creatingcoursemodules'] = '建立課程模組';
$string['creatingcourseroles'] = '建立課程層級的角色指派與置換';
$string['creatingevents'] = '建立事件';
$string['creatinggradebook'] = '建立成績單';
$string['creatinggroupings'] = '建立群組';
$string['creatinggroupingsgroups'] = '將分組加入為群';
$string['creatinggroups'] = '建立分組';
$string['creatinglogentries'] = '建立存取記錄';
$string['creatingmessagesinfo'] = '建立簡訊資訊';
$string['creatingmodroles'] = '建立模組層級的角色指派與置換';
$string['creatingnewcourse'] = '開設新的課程';
$string['creatingrolesdefinitions'] = '建立角色定義';
$string['creatingscales'] = '建立評分量尺';
$string['creatingsections'] = '建立單元段落';
$string['creatingtemporarystructures'] = '建立暫存結構';
$string['creatinguserroles'] = '建立用戶層級的角色指派與置換';
$string['creatingusers'] = '建立用戶';
$string['creatingxmlfile'] = '建立XML 檔案';
$string['currency'] = '貨幣';
$string['currentcourse'] = '目前課程';
$string['currentcourseadding'] = '增加資料至目前課程';
$string['currentcoursedeleting'] = '刪除目前課程';
$string['currentlanguage'] = '選定語言';
$string['currentlocaltime'] = '您的當地時間';
$string['currentlyselectedusers'] = '目前選擇的用戶';
$string['currentpicture'] = '個人照';
$string['currentrelease'] = '目前發行版本資訊';
$string['currentversion'] = '目前版本';
$string['databasechecking'] = '把Moodle資料庫從{$a->oldversion}升級到{$a->newversion}';
$string['databaseperformance'] = '資料庫效能';
$string['databasesetup'] = '正在安裝資料庫';
$string['databasesuccess'] = '資料庫升級成功';
$string['databaseupgradebackups'] = '現在的備份版本是{$a}';
$string['databaseupgradeblocks'] = '現在的區塊版本是{$a}';
$string['databaseupgradegroups'] = '現在群組的版本是{$a}';
$string['databaseupgradelocal'] = '現在的本地資料庫修訂版本為 {$a}';
$string['databaseupgrades'] = '升級資料庫';
$string['date'] = '日期';
$string['datechanged'] = '日期已變更';
$string['datemostrecentfirst'] = '時間日期 -- 最新的優先顯示';
$string['datemostrecentlast'] = '時間日期 -- 最新的最後顯示';
$string['day'] = '日';
$string['days'] = '日';
$string['decodinginternallinks'] = '解譯內部的連結';
$string['default'] = '預設';
$string['defaultcoursestudent'] = '學生';
$string['defaultcoursestudentdescription'] = '學生在課程中通常擁有較少的權限。';
$string['defaultcoursestudents'] = '學生們';
$string['defaultcoursesummary'] = '請寫一段精簡有趣的文字來介紹這個課程';
$string['defaultcourseteacher'] = '教師';
$string['defaultcourseteacherdescription'] = '教師可以在課程中執行任何操作，包括修改教學活動以及對學生評分。';
$string['defaultcourseteachers'] = '教師們';
$string['defaulteditor'] = '預設編輯器';
$string['delete'] = '刪除';
$string['deleteablock'] = '刪除區塊';
$string['deleteall'] = '全部刪除';
$string['deleteallcannotundo'] = '刪除全部--無法還原';
$string['deleteallcomments'] = '刪除所有評論';
$string['deleteallratings'] = '刪除所有評分';
$string['deletecategory'] = '刪除類別：{$a}';
$string['deletecategorycheck'] = '您十分確定要將這個<b>‘{$a}’</b>目錄完全刪除嗎？
這將會把所有課程移到父目錄(如果有的話)中，或者移到其他類別。';
$string['deletecategorycheck2'] = '如果刪除此課程類別，您必須選擇該類別下的課程和子類別要怎麼處理。';
$string['deletecategoryempty'] = '此類別是空的。';
$string['deletecheck'] = '刪除 {$a} 嗎？';
$string['deletecheckfiles'] = '您真的確定要刪除這些檔案嗎？';
$string['deletecheckfull'] = '您真的確定要徹底刪除用戶{$a}，包含他們的選課、活動和其他用戶資料？';
$string['deletechecktype'] = '您確定要刪除{$a->type}嗎？';
$string['deletechecktypename'] = '您確定要刪除  {$a->type}  “{$a->name}”嗎？';
$string['deletecheckwarning'] = '您即將刪除這些檔案';
$string['deletecomment'] = '刪除這則評論';
$string['deletecompletely'] = '完全刪除';
$string['deletecourse'] = '刪除一個課程';
$string['deletecoursecheck'] = '您確定要完全清除本課程以及所有相關資料嗎?';
$string['deleted'] = '已刪除';
$string['deletedactivity'] = '已經刪除 {$a}';
$string['deletedcourse'] = '{$a} 課程已經完全刪除了';
$string['deletednot'] = '無法刪除 {$a} ！';
$string['deleteselected'] = '刪除選擇的';
$string['deleteselectedkey'] = '刪除選擇的key';
$string['deletingcourse'] = '正在刪除{$a}';
$string['deletingexistingcoursedata'] = '刪除已存在的課程資料';
$string['deletingolddata'] = '刪除舊資料';
$string['department'] = '科系';
$string['desc'] = '遞減';
$string['description'] = '說明';
$string['deselectall'] = '取消選取';
$string['detailedless'] = '簡略';
$string['detailedmore'] = '詳細';
$string['directory'] = '目錄';
$string['disable'] = '取消';
$string['disabledcomments'] = '評論功能停用';
$string['displayingfirst'] = '只顯示第一個{$a->count} {$a->things}';
$string['displayingrecords'] = '顯示{$a}筆紀錄';
$string['displayingusers'] = '顯示用戶從{$a->start}到{$a->end}';
$string['displayonpage'] = '在頁面顯示';
$string['dndcourse'] = '您可以用拖放這一課程來改變它的排列順序，或是把它搬到另一個類別中。';
$string['dndenabled_inbox'] = '若要新增檔案，請將檔案拖放到這裡。';
$string['dndnotsupported'] = '不支援拖曳';
$string['dndnotsupported_help'] = '你的瀏覽器不支援以拖曳方式上傳檔案。<br />這一功能在所有當前版本的Chrome, Firefox 和 Safari，以及 Internet Explorer v10 以上都可以使用。';
$string['dndnotsupported_insentence'] = '不支援拖曳';
$string['dnduploadwithoutcontent'] = '沒有上傳任何內容';
$string['dndworkingfile'] = '將檔案拖放到課程單元中就可以上傳';
$string['dndworkingfilelink'] = '將檔案或超連結拖放到課程單元中就可以將它們上傳到課程中';
$string['dndworkingfiletext'] = '將檔案或文字拖放到課程單元中就可以將它們上傳到課程中';
$string['dndworkingfiletextlink'] = '將檔案、文字或超連結拖放到課程單元中就可以將它們上傳到課程中';
$string['dndworkinglink'] = '將超連結拖放到課程單元中就可以上傳';
$string['dndworkingtext'] = '將文字拖放到課程單元中就可以上傳';
$string['dndworkingtextlink'] = '將文字或超連結拖放到課程單元中就可以將它們上傳到課程中';
$string['documentation'] = 'Moodle文件';
$string['dontsortcategories'] = '不要將類別排序';
$string['dontsortcourses'] = '不要將課程排序';
$string['down'] = '往下';
$string['download'] = '下載';
$string['downloadall'] = '全部下載';
$string['downloadexcel'] = '以Excel 檔案格式下載';
$string['downloadfile'] = '下載檔案';
$string['downloadods'] = '以ODS檔案格式下載';
$string['downloadtext'] = '以文字檔格式下載';
$string['doyouagree'] = '您是否已經閱覽以上說明條件並且同意所有內容?';
$string['droptoupload'] = '檔案拖放到這裡就可以上傳';
$string['duplicate'] = '複製';
$string['edhelpaspellpath'] = '要在編輯器中使用拼寫檢查功能，您必須在伺服器上安裝<strong>aspell 0.50</strong>或其更高版本，並且還要正確地指定aspell程式的路徑。在Unix/Linux系統上通常是<strong>/usr/bin/aspell</strong>，當然也可能是其它地方。';
$string['edhelpbgcolor'] = '定義編輯區域的背景顏色。<br />有效值範例：#ffffff 或 white';
$string['edhelpcleanword'] = '這個設定決定是否過濾Word特定格式。';
$string['edhelpenablespelling'] = '是否做拼字檢查。如果啟動，必須在伺服器中安裝<strong>aspell</strong>。第二個值是<strong>預設的字典</strong>。若aspll 沒有用戶自己語言的字典，將會使用這一個。';
$string['edhelpfontfamily'] = '這個字型屬性是一系列具體的或通用的字型名稱列表。名稱之間必須用逗號分隔。';
$string['edhelpfontlist'] = '定義編輯器下拉選單可使用的字型。';
$string['edhelpfontsize'] = '使用預設值設定字型的大小。<br />有效的值如下：medium、large、smaller、lager、10pt、11px。';
$string['edit'] = '編修';
$string['edita'] = '編修{$a}';
$string['editcategorysettings'] = '編修類別設定';
$string['editcategorythis'] = '編修此類別';
$string['editcoursesettings'] = '編修課程設定';
$string['editfiles'] = '編修檔案';
$string['editgroupprofile'] = '編修群組的簡介';
$string['editinga'] = '正在編修{$a}';
$string['editingteachershort'] = '編修者';
$string['editlock'] = '不能修改這個數值!';
$string['editmyprofile'] = '編修個人資料';
$string['editorbgcolor'] = '背景顏色';
$string['editorcleanonpaste'] = '在貼上時清除Word 的HTML標籤';
$string['editorcommonsettings'] = '共同的設定';
$string['editordefaultfont'] = '預設字型';
$string['editorenablespelling'] = '啟動拼字檢查';
$string['editorfontlist'] = '字型清單';
$string['editorfontsize'] = '預設字型大小';
$string['editorresettodefaults'] = '重設為預設值';
$string['editorsettings'] = '編輯器設定';
$string['editorshortcutkeys'] = '編輯器快捷鍵';
$string['editsettings'] = '修改設定';
$string['editsummary'] = '編修概要';
$string['editthisactivity'] = '編修本活動';
$string['editthiscategory'] = '編修類別';
$string['edittitle'] = '編修標題';
$string['edittitleinstructions'] = '按Esc鍵可取消編輯，輸入完成後請按Enter鍵。';
$string['edituser'] = '編修用戶帳號';
$string['edulevel'] = '教育層次';
$string['edulevelother'] = '其他';
$string['edulevelparticipating'] = '參與';
$string['edulevelteacher'] = '教學';
$string['email'] = '電子郵件信箱';
$string['emailactive'] = '使用電子郵件';
$string['emailagain'] = '電子郵件(再次確認)';
$string['emailalreadysent'] = '一個密碼重設的電子郵件已經寄出去。請檢查您的電子郵件信箱。';
$string['emailcharset'] = '電子郵件的字元集';
$string['emailconfirm'] = '確認您的帳號';
$string['emailconfirmation'] = '嗨 {$a->firstname},您好

您(或是其他人)在 {$a->sitename} 網站，使用您的E-Mail註冊了新的使用帳號.

如果確認帳號確實是您所要申請的, 請點選以下網址完成帳號申請程序:

  {$a->link}

對大多數電子郵件而言,您只要點選上列網址即可，
如果並未出現連結的網站，請用剪貼的方式，啟動瀏覽器並進入上列網址的網頁.

歡迎您的加入
{$a->sitename}系統管理員{$a->admin}敬上';
$string['emailconfirmationsubject'] = '{$a}：帳號確認';
$string['emailconfirmsent'] = '<p>本系統已經送出電子郵件到 <b>{$a}</b></p>
   <p>訊息內容包含如何完成註冊手續。</p>
   <p>請閱覽您的私人郵件 按下確認連結後 便可登入本系統，若是有問題請和系統管理員連絡。</p>';
$string['emaildigest'] = '電子郵件摘要型式';
$string['emaildigestcomplete'] = '完整的(每天一封，包含完整內容)';
$string['emaildigest_help'] = '這是討論區預設要使用的每日濃縮設定。

*沒有濃縮 ---每一貼文會發一封email給你
*濃縮(完整貼文) ---你每天只會收到一封email，它會包含每一篇貼文的全部內容。
*濃縮(只有主旨) ---你每天只會收到一封email，它只會包含每一篇貼文的主旨。

你也可以為每一個討論區選擇不同的設定。';
$string['emaildigestoff'] = '無摘要(每次張貼就發送一封郵件)';
$string['emaildigestsubjects'] = '主題式(每天一封，只包含主題)';
$string['emaildisable'] = '這個電子郵件信箱已停用';
$string['emaildisableclick'] = '點按這裡不再向此信箱發送任何郵件';
$string['emaildisplay'] = '顯示電子郵件信箱';
$string['emaildisplaycourse'] = '只允許課程同學看到我的電子郵件信箱';
$string['emaildisplayhidden'] = '已隱藏電子郵件';
$string['emaildisplayno'] = '對所有人隱藏我的電子郵件信箱';
$string['emaildisplayyes'] = '允許所有人看到我的電子郵件信箱';
$string['emailenable'] = '這個電子郵件信箱可使用';
$string['emailenableclick'] = '點按這裡重新允許向此信箱發送郵件';
$string['emailexists'] = '這個電子郵件信箱已經註冊過了。';
$string['emailformat'] = '電子郵件格式';
$string['emailmustbereal'] = '注意：您的電子郵件信箱必須是真實可用的';
$string['emailnotallowed'] = '不允許使用如下網域名稱的電子郵件信箱：({$a})';
$string['emailnotfound'] = '資料庫中找不到此電子郵件信箱';
$string['emailonlyallowed'] = '這個電子郵件信箱不在允許的網域中：({$a})';
$string['emailpasswordchangeinfo'] = '{$a->firstname}您好，

有人（也許是您自己）試著索取帳號 “{$a->sitename}”的新密碼。

要修改您的密碼，請先點選下面網址：

{$a->link}

在大部分的郵件程式中，上面網址應該會顯示為藍色字體的連結讓您可以直接點選；如果不是這樣，請您複製網址到瀏覽器的網址列中。

如果您需要其他協助，請聯絡網站管理員： {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = '{$a->firstname}。您好，

有人（可能是您自己）對於“{$a->sitename}”網站中您的帳號要求新密碼，很不幸的您的帳號是失效的且無法重新設定，請聯絡網站管理員，
{$a->admin}。';
$string['emailpasswordchangeinfofail'] = '{$a->firstname} 您好，

有人（也許是您）要索取您在{$a->sitename}網站帳號的新密碼。

不幸地，這網站上的密碼無法重新設定，請聯絡網站管理員，
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a} ：更改密碼的資訊';
$string['emailpasswordconfirmation'] = '嗨{$a->firstname},您好

您(或是其他人)告訴本網站“{$a->sitename}”忘記了帳號的密碼，並要求重新設定一個新的密碼。若是您並未提出重新設定要求，則可能是別人弄錯了，請忽略本訊息。

如果是您確定要重新設定密碼，請點選下列網址連結確認：

{$a->link}

對大多數電子郵件而言,您只要點選上列網址即可，如果並未出現連結的網站，請用剪貼的方式，啟動瀏覽器並進入上列網址的網頁。

本封電子郵件是要確認是不是您需要重設密碼，而不是他人的惡作劇，點選確認後，您將立即收到一封電子郵件，裡面有您的帳號及新的密碼。

如果您需要協助，請聯絡網站管理員，
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}：變更密碼的確認';
$string['emailpasswordconfirmmaybesent'] = '<p>如果您輸入了正確的帳號或信箱，系統應該會寄出一封郵件給您。</p>
<p>信件內容包含了如何確認以及完成修改密碼的說明，這個過程很簡單。如果您仍感到困難無法進行，請聯絡網站管理員。</p>';
$string['emailpasswordconfirmnoemail'] = '<p>您指定的用戶帳號沒有登記電子郵件地址。</p>
<p>請聯繫網站管理員</p>';
$string['emailpasswordconfirmnotsent'] = '<p>您所提供的用戶細節，無法對應到一個現有的用戶帳號。</p>
<p>請檢查您輸入的資料，然後再試一次。若您還是有困難，請聯繫網站管理員。</p>';
$string['emailpasswordconfirmsent'] = '已經送有一電子郵件送到您的信箱<b>{$a}</b>中。
<br />它附上簡單的確認及完成密碼改變的指令。如果您仍有問題，請聯絡網站管理員。';
$string['emailpasswordsent'] = '謝謝您確認忘記密碼，系統已經幫您產生一個新密碼，並且透過電子郵件送到您的信箱<br /><b>{$a->email}</b>。<br />新的密碼是自動亂數產生的，您可以點選下列網址<a href="{$a->link}">變更密碼</a>，把它改成更容易記憶的密碼。';
$string['emailresetconfirmation'] = '嗨 {$a->firstname}，您好！

我們收到您在 {$a->sitename}的\'{$a->username}\' 帳號的密碼重新設定的請求。

為了確認這個請求，並為您的帳號設定一個新密碼，請到下列網址：

{$a->link}
(這一鏈結只有在接收到重設請求之後 {$a->resetminutes} 分鐘之內有效)

如果這密碼重設請求不是您提出來的，請不要做任何動作。

若您需要幫助，請聯絡網站管理員，{$a->admin}。';
$string['emailresetconfirmationsubject'] = '{$a}: 密碼重設請求';
$string['emailresetconfirmsent'] = '一個電子郵件已經送到您在<b>{$a}</b>的電子郵件信箱。

它包含一些簡單的指示以確認和完成密碼的更改。

若您仍然有困難，請聯繫網站管理員。';
$string['emailtoprivatefiles'] = '您亦可將電子郵件當成附件直接寄到個人的檔案空間。只要將檔案寄至電子郵件並寄至{$a}即可。';
$string['emailtoprivatefilesdenied'] = '您的管理員已經取消您上傳自己個人檔案之選項。';
$string['emptydragdropregion'] = '空白區域';
$string['enable'] = '啟用';
$string['encryptedcode'] = '加密程式碼';
$string['english'] = '英語';
$string['enrolmentmethods'] = '選修方法';
$string['entercourse'] = '點按進入課程';
$string['enteremail'] = '輸入您的電子郵件信箱';
$string['enteremailaddress'] = '請輸入您註冊的電子郵件信箱，系統將重新設定您的密碼，並將新密碼送到您的信箱中。';
$string['enterusername'] = '輸入您的用戶名稱';
$string['entries'] = '條目';
$string['error'] = '錯誤';
$string['errorcreatingactivity'] = '無法建立“{$a}”活動的實體';
$string['errorfiletoobig'] = '此檔案比{$a} bytes的限制還大';
$string['errornouploadrepo'] = '此網站沒有啟用上傳倉儲';
$string['errorwhenconfirming'] = '因為有錯誤發生，您目前尚未被認可。若您是點選在電子郵件上的連結，來到這裡，請檢查該行網址是否斷裂或換行。您可能需要以剪貼的方式在瀏覽器的網址列上重構正確的連結 。';
$string['eventcommentcreated'] = '已建立評論';
$string['eventcommentdeleted'] = '已刪除評論';
$string['eventcommentsviewed'] = '已檢視評論';
$string['eventcontentviewed'] = '已檢視的內容';
$string['eventcoursecategorycreated'] = '類別已建立';
$string['eventcoursecategorydeleted'] = '類目已被刪除';
$string['eventcoursecategoryupdated'] = '類別已更新';
$string['eventcoursecontentdeleted'] = '課程內容已被刪除';
$string['eventcoursecreated'] = '課程已建立';
$string['eventcoursedeleted'] = '課程已被刪除';
$string['eventcoursemodulecreated'] = '課程模組已建立';
$string['eventcoursemoduledeleted'] = '課程模組已刪除';
$string['eventcoursemoduleinstancelistviewed'] = '已檢視課程模組實例';
$string['eventcoursemoduleupdated'] = '課程模組已更新';
$string['eventcoursemoduleviewed'] = '已檢視課程模組';
$string['eventcourseresetended'] = '課程重置結束';
$string['eventcourseresetstarted'] = '課程重置開始';
$string['eventcourserestored'] = '課程已儲存';
$string['eventcoursesectionupdated'] = '課程分節已更新';
$string['eventcourseupdated'] = '課程已更新';
$string['eventcourseuserreportviewed'] = '課程使用者報告已檢視過';
$string['eventcourseviewed'] = '課程已檢視過';
$string['eventemailfailed'] = '電子郵件無法送出';
$string['eventname'] = '事件名稱';
$string['eventrecentactivityviewed'] = '最近活動已檢視過';
$string['eventunknownlogged'] = '未知事件';
$string['eventusercreated'] = '已建立的用戶';
$string['eventuserdeleted'] = '已刪除的用戶';
$string['eventuserlistviewed'] = '用戶列表已檢視過';
$string['eventuserloggedout'] = '已登出的用戶';
$string['eventuserpasswordupdated'] = '用戶密碼已更新';
$string['eventuserprofileviewed'] = '用戶個人資料表已檢視過';
$string['eventuserupdated'] = '已更新的用戶';
$string['everybody'] = '所有人';
$string['executeat'] = '執行於';
$string['existing'] = '現有的';
$string['existingadmins'] = '現有的網站管理員';
$string['existingcourse'] = '現有課程';
$string['existingcourseadding'] = '新增資料至現有課程';
$string['existingcoursedeleting'] = '刪除現有課程';
$string['existingcreators'] = '現有的課程管理員';
$string['existingstudents'] = '已選課的學生';
$string['existingteachers'] = '現有的教師';
$string['expand'] = '展延';
$string['expandall'] = '展開全部';
$string['expandcategory'] = '展開{$a}';
$string['explanation'] = '說明';
$string['extendenrol'] = '延長修課期限(個別的)';
$string['extendperiod'] = '延長修課期限';
$string['failedloginattempts'] = '自從您上次登入後共有{$a->attempts}次失敗的登入';
$string['feedback'] = '回饋';
$string['file'] = '檔案';
$string['fileexists'] = '已經有名為 {$a}的檔案';
$string['filemissing'] = '{$a}不見了';
$string['files'] = '檔案';
$string['filesanduploads'] = '檔案與上傳';
$string['filesfolders'] = '檔案/目錄';
$string['filetoolarge'] = '太大無法上傳';
$string['fileuploadwithcontent'] = '不能在檔案上傳中包含內容參數';
$string['filloutallfields'] = '請填完這個表單的所有空格';
$string['filter'] = '過濾器';
$string['findmorecourses'] = '搜尋更多課程...';
$string['first'] = '第一個';
$string['firstaccess'] = '首次使用';
$string['firstname'] = '名字';
$string['firstnamephonetic'] = '第一個名字 --  拼音';
$string['firstsiteaccess'] = '第一次登入網站';
$string['firsttime'] = '您第一次來訪嗎？';
$string['folder'] = '資料夾';
$string['folderclosed'] = '關閉的資料夾';
$string['folderopened'] = '開啟的資料夾';
$string['followingoptional'] = '以下項目是選擇性的';
$string['followingrequired'] = '以下項目是必填的';
$string['for'] = '為';
$string['force'] = '強制';
$string['forcelanguage'] = '強制使用的語言';
$string['forceno'] = '不強制';
$string['forcepasswordchange'] = '強制變更密碼';
$string['forcepasswordchangecheckfull'] = '您真的確定要強制變更密碼為{$a}嗎？';
$string['forcepasswordchange_help'] = '如果此核取方塊被勾選，那麼用戶在下次登入平台時，會被要求更換密碼';
$string['forcepasswordchangenot'] = '不能強制將密碼改為{$a}';
$string['forcepasswordchangenotice'] = '您必須修改您的密碼才能繼續進行。';
$string['forcetheme'] = '固定佈景主題';
$string['forgotaccount'] = '忘記了密碼？';
$string['forgotten'] = '忘記帳號或密碼嗎？';
$string['forgottenduplicate'] = '這個信箱由幾個帳號共用，請輸入帳號代替';
$string['forgotteninvalidurl'] = '無效的重設密碼網址';
$string['format'] = '格式';
$string['format_help'] = '課程格式決定課程頁面的版面編排方式。

* 單一活動格式 - 用來在課程頁面顯示一個單一活動，或資源(比如測驗或SCORM包裹)。

* SCORM格式 - 顯示放在課程頁面的第一個單元的SCORM教材包（SCORM / AICC模組的替代方案）。

* 討論區格式 - 一個討論區顯示在課程頁面上。

* 主題格式 - 課程頁面分成數個主題單元。

* 週曆格式 - 課程頁面將由週次單元組成，第一週從課程開始日起。';
$string['formathtml'] = 'HTML格式';
$string['formatmarkdown'] = 'Markdown格式';
$string['formatplain'] = '純文字格式';
$string['formattext'] = 'Moodle自動格式';
$string['formattexttype'] = '格式';
$string['framesetinfo'] = '這框架文件包含：';
$string['from'] = '從';
$string['frontpagecategorycombo'] = '綜合式列表';
$string['frontpagecategorynames'] = '顯示類別清單';
$string['frontpagecourselist'] = '顯示課程清單';
$string['frontpagecoursesearch'] = '課程搜尋';
$string['frontpagedescription'] = '首頁摘要';
$string['frontpagedescriptionhelp'] = '這一摘要說明可以使用課程/網站摘要區塊顯示在首頁上，或是包含在首頁的主題部分。';
$string['frontpageenrolledcourselist'] = '已參與的課程';
$string['frontpageformat'] = '首頁格式';
$string['frontpageformatloggedin'] = '登入後的首頁格式';
$string['frontpagenews'] = '顯示新聞';
$string['frontpagesettings'] = '首頁設定';
$string['fulllistofcourses'] = '所有課程';
$string['fullname'] = '完整名稱';
$string['fullnamecourse'] = '課程全名';
$string['fullnamecourse_help'] = '課程全名會顯示在課程的頁面頂端和課程清單中。';
$string['fullnamedisplay'] = '{$a->lastname} {$a->firstname}';
$string['fullnameuser'] = '用戶全名';
$string['fullprofile'] = '個人完整資料';
$string['fullsitename'] = '網站全名';
$string['functiondisabled'] = '此功能目前無法使用';
$string['general'] = '一般';
$string['geolocation'] = '緯度 - 經度';
$string['gettheselogs'] = '下載這些日誌';
$string['go'] = 'Go';
$string['gpl'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com) This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version. This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Moodle License information page for full details: http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com) This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Moodle License information page for full details: http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL授權';
$string['grade'] = '成績';
$string['grades'] = '成績';
$string['gravatarenabled'] = '本網站已經啟用<a href="http://www.gravatar.com/">Gravatar </a>。如果您不上傳個人照片，Moodle將會試著為您從Gravatar載入個人照片。';
$string['group'] = '分組';
$string['groupadd'] = '新增分組';
$string['groupaddusers'] = '將選取的加到分組';
$string['groupextendenrol'] = '延長修課期限(一般)';
$string['groupfor'] = '為組';
$string['groupinfo'] = '所選取的分組資訊';
$string['groupinfoedit'] = '修改分組設定';
$string['groupinfomembers'] = '所選取的成員資訊';
$string['groupinfopeople'] = '所選取的人員資訊';
$string['groupmembers'] = '組員';
$string['groupmemberssee'] = '檢視組員';
$string['groupmembersselected'] = '所選擇的組員';
$string['groupmode'] = '群組模式';
$string['groupmodeforce'] = '強制為群組模式';
$string['groupmy'] = '我的組別';
$string['groupnonmembers'] = '未加入群組的人';
$string['groupnotamember'] = '抱歉，您不是那個群組的成員';
$string['grouprandomassign'] = '隨機分組';
$string['groupremove'] = '移除所選取的分組';
$string['groupremovemembers'] = '移除所選取的成員';
$string['groups'] = '分組';
$string['groupsnone'] = '沒有分組';
$string['groupsseparate'] = '分隔群組';
$string['groupsvisible'] = '可視群組';
$string['guest'] = '訪客';
$string['guestdescription'] = '訪客的權限最小而且通常無法輸入任何文字。';
$string['guestskey'] = '允許有課程密碼者進入(不需註冊也可以)';
$string['guestsno'] = '只允許註冊者進入';
$string['guestsnotallowed'] = '抱歉，“{$a}”不允許訪客進入。';
$string['guestsyes'] = '允許沒有密鑰的訪客進入';
$string['guestuser'] = '訪客用戶';
$string['guestuserinfo'] = '該用戶是個特殊用戶，只允許以唯讀方式參觀一些課程。';
$string['help'] = '輔助說明';
$string['helpprefix2'] = '{$a}的輔助';
$string['helpwiththis'] = '輔助';
$string['hiddenassign'] = '隱藏指派';
$string['hiddenfromstudents'] = '對學生隱藏';
$string['hiddensections'] = '隱藏的單元';
$string['hiddensectionscollapsed'] = '隱藏的單元以摺疊的方式呈現';
$string['hiddensections_help'] = '課程中隱藏的學習單元<p>這一選項允許您決定您課程中隱藏的學習單元要如何顯示給學生看。</p><p>預設中，會顯示一個小區域，(以摺疊的形式，灰色的) 來指出隱藏的學習單元在哪裡。雖然學生無法真正看到隱藏的活動和文字。這在"週曆模式"中特別有用，因為不上課的週次就很清楚了。</p><p>若您願意，也可以選擇"完全隱藏"，這樣學生甚至不知道這課程中有一些學習單元被隱藏。</p>';
$string['hiddensectionsinvisible'] = '隱藏的單元是完全看不到的';
$string['hide'] = '隱藏';
$string['hideadvancedsettings'] = '隱藏進階設定';
$string['hidepicture'] = '隱藏照片';
$string['hidesection'] = '隱藏單元 {$a}';
$string['hidesettings'] = '隱藏設定';
$string['hideshowblocks'] = '隱藏或顯示區塊';
$string['hits'] = '點閱次數';
$string['hitsoncourse'] = '用戶{$a->username}瀏覽了{$a->coursename}';
$string['hitsoncoursetoday'] = '今天用戶{$a->username}瀏覽了{$a->coursename}';
$string['home'] = '首頁';
$string['hour'] = '小時';
$string['hours'] = '小時';
$string['howtomakethemes'] = '如何設計新的佈景主題';
$string['htmleditor'] = '使用 HTML 編輯器';
$string['htmleditoravailable'] = 'HTML編輯器可用';
$string['htmleditordisabled'] = '您在個人資料裡停用了HTML編輯器';
$string['htmleditordisabledadmin'] = '管理員已將本站的HTML編輯器關閉了';
$string['htmleditordisabledbrowser'] = '因為您的瀏覽器不支援，HTML編輯器的功能無法使用';
$string['htmlfilesonly'] = '只允許HTML檔案';
$string['htmlformat'] = '美化的HTML格式';
$string['icon'] = '圖示';
$string['icqnumber'] = 'ICQ 號碼';
$string['idnumber'] = '學號';
$string['idnumbercourse'] = '課程編號';
$string['idnumbercoursecategory'] = '類別編號';
$string['idnumbercoursecategory_help'] = '課程類別編號只用來和外部系統對應，不會在網站的任何地方顯示。如果此類別有公訂編號的話，可以在此輸入，否則此欄位可以空白。';
$string['idnumbercourse_help'] = '課程編號只用來和外部系統對應，不會在網站的任何地方顯示。如果此課程有公訂編號的話，可以在此輸入，否則此欄位可以空白。';
$string['idnumbergroup'] = '分組編號';
$string['idnumbergroup_help'] = '分組編號只用來和外部系統對應，不會在網站的任何地方顯示。如果此分組有公訂編號的話，可以在此輸入，否則此欄位可以空白。';
$string['idnumbergrouping'] = '分群編號';
$string['idnumbergrouping_help'] = '分群編號只用來和外部系統對應，不會在網站的任何地方顯示。如果此分群有公訂編號的話，可以在此輸入，否則此欄位可以空白。';
$string['idnumbermod'] = '識別編號';
$string['idnumbermod_help'] = '設定一個識別編號可以在成績計算時，做為活動識別。如果這個活動與任何成績計算公式無關，那麼它的識別編號可以空白。這個識別編號也可以在成績單中設定，不過它只能在活動設定頁中編輯。';
$string['idnumbertaken'] = '此識別編號已被使用';
$string['imagealt'] = '圖片說明';
$string['import'] = '匯入';
$string['importdata'] = '匯入課程資料';
$string['importdataexported'] = '成功地從\'來源\'課程匯出資料。<br />接下來將匯入到\'目的\'課程中。';
$string['importdatafinished'] = '匯入完成！繼續您的課程';
$string['importdatafrom'] = '找到匯入資料的課程:';
$string['inactive'] = '不活動的';
$string['include'] = '包含';
$string['includeallusers'] = '包含所有用戶';
$string['includecoursefiles'] = '包含課程檔案';
$string['includecourseusers'] = '包含課程用戶';
$string['included'] = '被包含';
$string['includelogentries'] = '包含日誌記錄';
$string['includemodules'] = '包含模組';
$string['includemoduleuserdata'] = '包含模組的用戶資料';
$string['includeneededusers'] = '包含需要的用戶';
$string['includenoneusers'] = '不包含任何用戶';
$string['includeroleassignments'] = '包含角色指派';
$string['includesitefiles'] = '包含這課程中用到的網站檔案';
$string['includeuserfiles'] = '包含用戶檔案';
$string['increasesections'] = '增加主題單元數';
$string['info'] = '資訊';
$string['institution'] = '機構';
$string['instudentview'] = '學生檢視模式';
$string['interests'] = '興趣';
$string['interestslist'] = '興趣列表';
$string['interestslist_help'] = '用逗號(半形)分隔輸入您各項興趣嗜好。您的興趣嗜好將以標籤形式顯示在您的個人資料頁中。';
$string['invalidemail'] = '無效的電子郵件信箱';
$string['invalidlogin'] = '登入無效，請重試';
$string['invalidusername'] = '用戶名稱只能包含數字、小寫字母、底線（_）、橫線（-）、小數點（.）或符號（@）';
$string['invalidusernameupload'] = '無效的用戶名稱';
$string['ip_address'] = 'IP位址';
$string['jump'] = '跳';
$string['jumpto'] = '跳至...';
$string['keep'] = '保留';
$string['keepsearching'] = '繼續搜尋';
$string['langltr'] = '文字書寫方向從左到右';
$string['langrtl'] = '文字書寫方向從右到左';
$string['language'] = '語言';
$string['languagegood'] = '這個語言包是最新的！  :-)';
$string['last'] = '最近';
$string['lastaccess'] = '上次存取';
$string['lastcourseaccess'] = '上次存取課程';
$string['lastedited'] = '最後編輯';
$string['lastip'] = '最新IP位址';
$string['lastlogin'] = '最後登入';
$string['lastmodified'] = '最後修改';
$string['lastname'] = '姓氏';
$string['lastnamephonetic'] = '姓氏 - 拼音';
$string['lastsiteaccess'] = '最後一次登入網站';
$string['lastyear'] = '去年';
$string['latestlanguagepack'] = '到moodle.org檢查有無最新的語言套件';
$string['layouttable'] = '版面配置表';
$string['leavetokeep'] = '留空白則保留原來密碼';
$string['legacythemeinuse'] = '因為您的瀏覽器版本太老舊了，所以本站將以相容模式顯示。';
$string['license'] = '授權條款';
$string['licenses'] = '授權方式';
$string['liketologin'] = '您現在想使用帳號登入嗎?';
$string['list'] = '清單';
$string['listfiles'] = '{$a}中的檔案清單';
$string['listofallpeople'] = '顯示所有人員';
$string['listofcourses'] = '課程清單';
$string['loadinghelp'] = '載入中.....';
$string['local'] = '本地';
$string['localplugins'] = '本地端外掛';
$string['localpluginsmanage'] = '管理本地端外掛';
$string['location'] = '位置';
$string['locktimeout'] = '在等待鎖定的時候已經超過操作時間。';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = '您以{$a}登入';
$string['loggedinasguest'] = '您正使用訪客身分瀏覽';
$string['loggedinnot'] = '您尚未登入';
$string['login'] = '登入';
$string['loginalready'] = '您已經登入';
$string['loginas'] = '以此身分登入';
$string['loginaspasswordexplain'] = '<p>要使用此功能，您需要特別的“登入為密碼”。<br />如果您沒有，請和伺服器管理員聯繫。</p>';
$string['login_failure_logs'] = '登入失敗的記錄';
$string['loginguest'] = '以訪客身分登入';
$string['loginsite'] = '登入本網站';
$string['loginsteps'] = '您好！如果您尚未申請帳號，為了能完整使用本網站課程，您需要先花一兩分鐘時間申請一個新帳號。此外，部分課程在初次選課時，還需要輸入開課教師所設定的選課密碼。
<p>申請帳號請依下列步驟進行：</p>
<ol>
<li>請於 <a href="{$a}">申請新帳號</a> 表單中輸入個人相關資料。</li>
<li>一封電子郵件會立刻寄送到您的信箱中。</li>
<li>讀取您的電子郵件，點按信件中的網址連結。</li>
<li>您的帳號將得到確認，並且立刻登入本網站。</li>
<li>然後，請選擇您想要參加的課程。</li>
<li>如果系統提示要選課密鑰，請輸入教師提供給您的選課密碼，這樣才能註冊到該課程中。</li>
<li>從此，您只要輸入個人的帳號與密碼〈在左邊的表單中〉，就可以進入任何一個您已選修的課程中。</li>
</ol>';
$string['loginstepsnone'] = '<p>嗨!</p>
<p>需要完成註冊手續才可能進入本課程。</p>
<p>您需要申請一個帳號名稱和密碼，以便進行登入系統的動作！</p>
<p>假如您所選定帳號名稱已經有人先登記，則需要輸入新的名稱，再試一次。</p>';
$string['loginto'] = '登入到{$a}';
$string['logout'] = '登出';
$string['logoutconfirm'] = '您確定要登出嗎？';
$string['logs'] = '日誌';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">更多</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">更多</a> ]';
$string['lookback'] = '回顧';
$string['mailadmins'] = '通知管理員';
$string['mailstudents'] = '通知學生';
$string['mailteachers'] = '通知教師';
$string['maincoursepage'] = '主要課程頁面';
$string['makeafolder'] = '建立資料夾';
$string['makeeditable'] = '假如您透過網頁伺服器(例如Apache)讓這"{$a}"成為可編輯的，那麼您就可以從這一頁直接編輯這一檔案';
$string['makethismyhome'] = '將此頁設為我的預設首頁';
$string['manageblocks'] = '區塊';
$string['managecategorythis'] = '管理此類別';
$string['managecourses'] = '課程管理';
$string['managedatabase'] = '資料庫管理';
$string['manageeditorfiles'] = '管理被編輯器使用的檔案';
$string['managefilters'] = '過濾器';
$string['managemodules'] = '模組管理';
$string['manageroles'] = '角色與權限';
$string['markedthistopic'] = '這個主題被凸顯為目前的教學主題';
$string['markthistopic'] = '將本主題凸顯為目前教學主題';
$string['matchingsearchandrole'] = '正搭配“{$a->search}”和{$a->role}';
$string['maxareabytesreached'] = '這檔案(或幾個檔案的總和)的大小比這一區保留的空間還大';
$string['maxbytesforfile'] = '這檔案{$a}比允許的最高限制還大';
$string['maxfilesize'] = '新檔案最大容量：{$a}';
$string['maxfilesreached'] = '此項目允許您最多附加 {$a}個檔案';
$string['maximumchars'] = '最多{$a}個字元';
$string['maximumgrade'] = '最高成績';
$string['maximumgradex'] = '最高分：{$a}';
$string['maximumshort'] = '最大';
$string['maximumupload'] = '最大上傳檔案大小';
$string['maximumupload_help'] = '這個設置決定可上傳到課程的檔案大小，由網站管理員的全站設定值限制住。而每個活動模組裡的設定，也可以進一步限制上傳檔案大小。';
$string['maxnumberweeks'] = '最大週數/主題數';
$string['maxnumberweeks_desc'] = '這控制出現在課程設定選項“週數/主題數”的最大值。';
$string['maxnumcoursesincombo'] = '瀏覽<a href="{$a->link}">{$a->numberofcourses}門課程</a>。';
$string['maxsize'] = '檔案最大容量：{$a}';
$string['maxsizeandareasize'] = '新檔案的最大容量：{$a->size}，整體限制：{$a->areasize}';
$string['maxsizeandattachments'] = '新檔案的最大容量： {$a->size} ，最多附件：{$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = '新檔案的最大容量： {$a->size} ，最多附件：{$a->attachments}，整體限制：{$a->areasize}';
$string['memberincourse'] = '課程成員';
$string['messagebody'] = '訊息內容';
$string['messagedselectedusers'] = '訊息已經發送給選擇的使用者，而收件人列表已重設了。';
$string['messagedselectedusersfailed'] = '發送訊息給選擇的使用者時發生錯誤，部份人可能沒有收到信件。';
$string['messageprovider:availableupdate'] = '有可用更新的通知';
$string['messageprovider:backup'] = '備份通知';
$string['messageprovider:badgecreatornotice'] = '獎章創造者的通知';
$string['messageprovider:badgerecipientnotice'] = '獎章受獎者的通知';
$string['messageprovider:courserequestapproved'] = '課程申請已核准的通知';
$string['messageprovider:courserequested'] = '課程開設申請通知';
$string['messageprovider:courserequestrejected'] = '課程開設申請被駁回的通知';
$string['messageprovider:errors'] = '本站的嚴重錯誤';
$string['messageprovider:errors_help'] = '有管理員必須知道的嚴重錯誤。';
$string['messageprovider:instantmessage'] = '用戶之間的私人訊息';
$string['messageprovider:instantmessage_help'] = '設定在收到本站其他用戶直接發給您的訊息後，該如何處理。';
$string['messageprovider:notices'] = '關於一些小問題的通知';
$string['messageprovider:notices_help'] = '有一些管理員可能會感興趣的通知';
$string['messageselect'] = '選擇這個用戶為收件人';
$string['messageselectadd'] = '發送訊息';
$string['middlename'] = '中間名字';
$string['migratinggrades'] = '移轉成績';
$string['min'] = '分鐘';
$string['mins'] = '分鐘';
$string['minute'] = '分鐘';
$string['minutes'] = '分鐘';
$string['miscellaneous'] = '其它';
$string['missingcategory'] = '您需要選定一個課程類別';
$string['missingdescription'] = '缺少說明資料';
$string['missingemail'] = '缺少電子郵件信箱';
$string['missingfirstname'] = '缺少名字資料';
$string['missingfromdisk'] = '從磁碟遺失';
$string['missingfullname'] = '缺少完整名稱';
$string['missinglastname'] = '缺少姓氏資料';
$string['missingname'] = '缺少名稱';
$string['missingnewpassword'] = '缺少新密碼';
$string['missingpassword'] = '缺少密碼';
$string['missingrecaptchachallengefield'] = '缺少 reCAPTCHA字詞驗證欄位';
$string['missingreqreason'] = '缺少理由';
$string['missingshortname'] = '缺少簡短名稱';
$string['missingshortsitename'] = '缺少網站簡稱';
$string['missingsitedescription'] = '缺少網站說明資料';
$string['missingsitename'] = '缺少網站名稱';
$string['missingstrings'] = '檢查未翻譯的語句';
$string['missingstudent'] = '必須選個東西';
$string['missingsummary'] = '缺少摘要';
$string['missingteacher'] = '必須選個東西';
$string['missingurl'] = '缺少網址';
$string['missingusername'] = '缺少帳號名稱';
$string['modchooserdisable'] = '關閉活動選擇器';
$string['modchooserenable'] = '開啟活動選擇器';
$string['moddoesnotsupporttype'] = '模組 {$a->modname}不支援上傳 {$a->type}類型檔案';
$string['modified'] = '修改時間';
$string['moduleintro'] = '說明';
$string['modulesetup'] = '設定模組的資料表';
$string['modulesuccess'] = '{$a}資料表已經正確設定了';
$string['modulesused'] = '已使用模組';
$string['month'] = '月';
$string['months'] = '月';
$string['moodledocs'] = 'Moodle線上文件';
$string['moodledocslink'] = '本頁的Moodle線上文件';
$string['moodlerelease'] = 'Moodle發行版';
$string['moodleversion'] = 'Moodle版本';
$string['more'] = '更多';
$string['morehelp'] = '更多輔助';
$string['moreinfo'] = '更多訊息';
$string['moreinformation'] = '關於這個錯誤的更多資訊';
$string['moreprofileinfoneeded'] = '請告訴我們更多關於您自己的資料';
$string['mostrecently'] = '最近';
$string['move'] = '搬移';
$string['movecategoriessuccess'] = '已順利移動類別{$a->count} 到類別\'{$a->to}\'';
$string['movecategoriestotopsuccess'] = '成功移動{$a->count} 個類別到頂層';
$string['movecategorycontentto'] = '搬入';
$string['movecategorysuccess'] = '已順利移動類別{$a->count} 到類別\'{$a->to}\'';
$string['movecategoryto'] = '搬移類別到：';
$string['movecategorytotopsuccess'] = '成功移動類別\'{$a->moved}\'到頂層';
$string['movecontent'] = '移動{$a}';
$string['movecontentstoanothercategory'] = '將內容搬移至另一個類別';
$string['movecoursemodule'] = '移動資源';
$string['movecoursesection'] = '移動單元';
$string['movecourseto'] = '搬移課程到：';
$string['movedown'] = '往下移';
$string['movefilestohere'] = '將檔案移到這裡';
$string['movefull'] = '搬移{$a}到這個位置';
$string['movehere'] = '移到這裡';
$string['moveleft'] = '左移';
$string['moveright'] = '右移';
$string['movesection'] = '移動單元 {$a}';
$string['moveselectedcategoriesto'] = '移動選出的類別到';
$string['moveselectedcoursesto'] = '搬移所選取的課程到...';
$string['movetoanotherfolder'] = '移到另一個目錄';
$string['moveup'] = '上移';
$string['msnid'] = 'MSN 帳號';
$string['mustchangepassword'] = '新的密碼必須與目前的密碼不同';
$string['mustconfirm'] = '您必須確認一下您的登入';
$string['mycourses'] = '我的課程';
$string['myfiles'] = '個人專用檔案';
$string['myfilesmanage'] = '管理個人專用檔案';
$string['myhome'] = '我的首頁';
$string['mymoodledashboard'] = '我的Moodle儀表板';
$string['myprofile'] = '個人資料';
$string['name'] = '名稱';
$string['nameforlink'] = '您想怎麼命名這個連結？';
$string['nameforpage'] = '頁面名稱';
$string['navigation'] = '導覽';
$string['needed'] = '需要的';
$string['networkdropped'] = '我們已檢測到您網路不可靠或已被中斷。<br />請理解除非你的上網狀況有所改善，您的這些變更可能無法正確的儲存。';
$string['never'] = '從不';
$string['neverdeletelogs'] = '從不刪除日誌';
$string['new'] = '新';
$string['newaccount'] = '新帳號';
$string['newcourse'] = '新課程';
$string['newpassword'] = '新密碼';
$string['newpasswordfromlost'] = '<strong>注意：</strong> 您 <strong>目前的密碼</strong> 將會寄送到您的 <strong>第二個</strong> 信箱來進行遺失密碼復原程序，在繼續之這一螢幕之前，請確認您已經收到您的替換密碼。';
$string['newpassword_help'] = '輸入一個新的密碼或留空續用舊密碼。';
$string['newpasswordtext'] = '嗨{$a->firstname},您好

您在“{$a->sitename}”網站的帳號，已經由系統重新設定一個新的臨時密碼

您現在的帳號資料如下：

  帳號名稱:{$a->username}
  密碼:{$a->newpassword}

您的新密碼是由系統亂數產生，如果您想更改為容易記憶的密碼，可以點選下列網址:
   {$a->link}

對大多數電子郵件而言,您只要點選上列網址即可，
如果並未出現連結的網站，請用剪貼的方式，啟動瀏覽器並進入上列網址的網頁。

{$a->sitename}管理員{$a->signoff}歡迎您。';
$string['newpicture'] = '新照片';
$string['newpicture_help'] = '要新增個人照片，先瀏覽和選擇一個JPG或PNG格式的圖片，然後點按“更新個人資料”按鈕。系統會將圖片剪裁為正方形，尺寸修改為100x100像素。';
$string['newsitem'] = '新聞項目';
$string['newsitems'] = '新聞條';
$string['newsitemsnumber'] = '顯示幾則新聞';
$string['newsitemsnumber_help'] = '此設置決定課程頁面上的最新消息區塊出現幾則最新消息。如果設定為“0”，則最新消息區塊將不會顯示。';
$string['newuser'] = '新用戶';
$string['newusernewpasswordsubj'] = '新用戶帳號';
$string['newusernewpasswordtext'] = '{$a->firstname}，您好

您在“{$a->sitename}”的帳號已經建立，系統產生一個暫時的密碼給您。

您目前的登入資訊如下：
帳號：{$a->username}
密碼：{$a->newpassword}
（在您第一次登入時會需要修改這個密碼）

要開始使用“{$a->sitename}”請透過連結登入：
{$a->link}

在大部分的郵件軟體中，上面的網址應該會自動以連結格式呈現，您可以直接點選；如果沒有，您可以將上面網址直接貼到瀏覽器的網址列中。

{$a->sitename}管理員{$a->signoff}歡迎您。';
$string['newusers'] = '新用戶';
$string['newwindow'] = '新視窗';
$string['next'] = '往後';
$string['nextsection'] = '下一單元';
$string['no'] = '否';
$string['noblockstoaddhere'] = '沒有可以增加到此頁的區塊';
$string['nobody'] = '沒人';
$string['nochange'] = '沒有改變';
$string['nocomments'] = '沒有評論';
$string['nocourses'] = '沒有課程';
$string['nocoursesfound'] = '找不到有"{$a}"這個關鍵字的課程';
$string['nocoursesyet'] = '此類別中無課程';
$string['nodstpresets'] = '管理員尚未啟用日光節約時間的支援功能';
$string['nofilesselected'] = '沒有檔案被選取來還原';
$string['nofilesyet'] = '本課程尚未上傳過任何檔案';
$string['nograde'] = '沒有成績';
$string['nohelpforactivityorresource'] = '暫時沒有和此資源或活動相關的輔助說明';
$string['noimagesyet'] = '本課程從未上傳過任何圖片';
$string['nologsfound'] = '沒有日誌資料';
$string['nomatchingusers'] = '沒有符合“{$a}”的用戶';
$string['nomorecourses'] = '沒有符合的課程被找到';
$string['nomoreidnumber'] = '並未使用識別編號避免衝突';
$string['none'] = '無';
$string['noneditingteacher'] = '助理教師';
$string['noneditingteacherdescription'] = '助理教師可以參與課程的教學活動與學生評分，但也許無法變更活動。';
$string['nonstandard'] = '非標準';
$string['nopendingcourses'] = '沒有開課申請需要審核';
$string['nopotentialadmins'] = '沒有候選的網站管理員';
$string['nopotentialcreators'] = '沒有候選的課程管理員';
$string['nopotentialstudents'] = '沒有候選的學生';
$string['nopotentialteachers'] = '沒有候選的教師';
$string['norecentactivity'] = '沒有近期的活動';
$string['noreplybouncemessage'] = '您已經回覆到一個無回應的電子郵件地址。如果您正要回覆到討論區的張貼文章，請使用{$a}討論區取代回覆。以下是電子郵件的內容:';
$string['noreplybouncesubject'] = '{$a} - 退回的信件';
$string['noreplyname'] = '不要回覆此郵件';
$string['noresetrecord'] = '這而沒有記錄來回應重設的請求。請啟動一心密碼重設請求。';
$string['noresults'] = '沒有結果';
$string['normal'] = '標準的';
$string['normalfilter'] = '標準搜尋';
$string['nosite'] = '找不到網站層級的課程';
$string['nostudentsfound'] = '沒找到{$a}';
$string['nostudentsingroup'] = '在這分組中尚未有學生';
$string['nostudentsyet'] = '還沒有學生選修此課程';
$string['nosuchemail'] = '沒有這樣的電子郵件信箱';
$string['notavailable'] = '無法使用';
$string['notavailablecourse'] = '{$a}是不能使用的';
$string['noteachersyet'] = '本課程還沒有教師';
$string['notenrolled'] = '{$a}沒有選修這課程。';
$string['notenrolledprofile'] = '個人資料無法使用，因為這用戶並沒有選修這門課程。';
$string['noteusercannotrolldatesoncontext'] = '<strong>注意：</strong>當還原備份時，因為您缺少必要權限，回復日期的能力被取消。';
$string['noteuserschangednonetocourse'] = '<strong> 注意：</strong> 當還原用戶資料(活動紀錄、檔案或訊息)時，課程用戶也必須還原回去。這個設定已經幫您修改了。';
$string['nothingnew'] = '沒有新近的活動';
$string['nothingtodisplay'] = '沒什麼可顯示';
$string['notice'] = '注意';
$string['noticenewerbackup'] = '這個備份檔已經由Moodle {$a->backuprelease} ({$a->backupversion})建立，同時您{$a->serverrelease} ({$a->serverversion})還要新。這可能會造成一些不一致性，因為無法保證備份檔案的向下相容性。';
$string['notifications'] = '通知';
$string['notifyloginfailuresmessage'] = '{$a->time},IP:{$a->ip},用戶:{$a->info}';
$string['notifyloginfailuresmessageend'] = '您可以在{$a}看這些日誌。';
$string['notifyloginfailuresmessagestart'] = '以下是上次您接到通知後，嘗試登入{$a}失敗的列表';
$string['notifyloginfailuressubject'] = '{$a} :: 登入失敗通知';
$string['notincluded'] = '未包括';
$string['notingroup'] = '抱歉，您必須是群組的成員才能看到這個活動';
$string['notpublic'] = '沒有公開！';
$string['nousersfound'] = '找不到用戶';
$string['nousersmatching'] = '沒有找到符合 \'{$a}\' 的用戶';
$string['nousersyet'] = '尚無用戶';
$string['novalidcourses'] = '沒有可以顯示的課程';
$string['now'] = '現在';
$string['numattempts'] = '{$a}次登入失敗';
$string['numberofcourses'] = '課程數';
$string['numberweeks'] = '週數/主題數';
$string['numdays'] = '{$a}日';
$string['numhours'] = '{$a}小時';
$string['numletters'] = '{$a}個字母';
$string['numminutes'] = '{$a}分';
$string['nummonths'] = '{$a}月';
$string['numseconds'] = '{$a}秒';
$string['numviews'] = '{$a}次瀏覽';
$string['numweeks'] = '{$a}週';
$string['numwords'] = '{$a}字數';
$string['numyears'] = '{$a}年';
$string['ok'] = '好';
$string['oldpassword'] = '現在的密碼';
$string['olduserdirectory'] = '這是舊用戶的目錄，而且不再需要。您可以安全的刪除它。裡面的檔案已經複製到新用戶的目錄了。';
$string['optional'] = '可選的';
$string['options'] = '選項';
$string['order'] = '次序';
$string['originalpath'] = '原始路徑';
$string['orphanedactivitiesinsectionno'] = '沒有歸屬的活動(單元 {$a})';
$string['other'] = '其他';
$string['outline'] = '概要';
$string['outlinereport'] = '概要報表';
$string['page'] = '頁';
$string['pagea'] = '頁碼{$a}';
$string['pageheaderconfigablock'] = '設定%fullname%區塊';
$string['pagepath'] = '頁面路徑';
$string['pageshouldredirect'] = '本頁面會自動重新導向。如果什麼都沒發生，請點選下面的"繼續"連結。';
$string['parentcategory'] = '父類別';
$string['parentcoursenotfound'] = '找不到上層課程';
$string['parentfolder'] = '父目錄';
$string['participants'] = '成員';
$string['participantslist'] = '成員清單';
$string['participationratio'] = '參與比例';
$string['participationreport'] = '參與報表';
$string['password'] = '密碼';
$string['passwordchanged'] = '密碼已經被修改';
$string['passwordconfirmchange'] = '密碼變更確認';
$string['passwordextlink'] = '下面超連結提供重設您遺失的密碼，您將會退出Moodle。';
$string['passwordforgotten'] = '忘記密碼了';
$string['passwordforgotteninstructions'] = '首先，系統需要在用戶資料庫中找到您的資料。所以請在下列欄位，輸入您的用戶名稱<strong>或</strong>註冊的電子郵件地址。選填一樣資料即可。';
$string['passwordforgotteninstructions2'] = '想重設密碼，請在下面填寫您的用戶名或電子郵件l地址。如果我們找到資料庫中有關於您的記錄，我們會發送一封電子郵件到您的信箱。郵件會指引您如何重新獲得存取權限。';
$string['passwordnohelp'] = '目前沒有關於遺失密碼的說明文件，請聯絡網站管理員。';
$string['passwordrecovery'] = '請協助我登入';
$string['passwordsdiffer'] = '這些密碼不符';
$string['passwordsent'] = '已經送出密碼';
$string['passwordsenttext'] = '<p>系統以電子郵件送出資訊到{$a->email}。</p>
   <p><b>請查收您的郵件以獲得新設定的密碼</b></p>
<p>這個新密碼是自動生成的，所以您可能需要前往<a href="{$a->link}">這裡</a>改成您自己容易記憶的密碼。</p>';
$string['passwordset'] = '您的密碼已經被重新設定了。';
$string['path'] = '路徑';
$string['pathnotexists'] = '伺服器中這個路徑不存在';
$string['pathslasherror'] = '路徑不能以斜線符號結尾!!';
$string['paymentinstant'] = '使用以下按鈕立即付款及註冊。';
$string['paymentpending'] = '（<small><b><u>{$a}</u></b> 等待中</small>）';
$string['paymentrequired'] = '這個課程需要付費才能進入。';
$string['payments'] = '付款';
$string['paymentsorry'] = '謝謝您的繳費!不幸地您的繳費沒有完全處理完成，而且您還沒到課程“{$a->fullname}”註冊。請稍後再嘗試繼續課程，如果您仍然有問題，請通知{$a->teacher}老師或網站管理員。';
$string['paymentthanks'] = '謝謝惠顧!您已經註冊這個課程了:<br/>"{$a}"';
$string['pendingrequests'] = '待審的開課申請';
$string['periodending'] = '結束時間 ({$a})';
$string['perpage'] = '每頁';
$string['perpagea'] = '每頁:{$a}';
$string['personal'] = '個人的';
$string['personalprofile'] = '個人的簡介';
$string['phone'] = '電話';
$string['phone2'] = '行動電話';
$string['phpinfo'] = 'PHP 設定資訊';
$string['pictureof'] = '{$a}的相片';
$string['pictureofuser'] = '用戶的相片';
$string['pleaseclose'] = '現在請關閉這個視窗';
$string['pleasesearchmore'] = '請蒐尋更多一些';
$string['pleaseusesearch'] = '請使用這搜尋';
$string['plugin'] = '外掛程式';
$string['plugincheck'] = '檢查外掛程式';
$string['plugindeletefiles'] = '與外掛“{$a->name}”相關的所有資料都已經從資料庫刪除。為了防止外掛程式被重新安裝，您現在就應該從伺服器刪除此目錄：{$a->directory}';
$string['pluginsetup'] = '設定外掛的資料表';
$string['policyaccept'] = '我了解並且同意';
$string['policyagree'] = '您必須同意這協議才能繼續使用這個網站。您同意嗎?';
$string['policyagreement'] = '網站使用協議';
$string['policyagreementclick'] = '連結到網站使用協議';
$string['popup'] = '彈出';
$string['popupwindow'] = '在新的視窗開啟檔案';
$string['popupwindowname'] = '彈出視窗';
$string['post'] = '張貼';
$string['posts'] = '張貼';
$string['potentialadmins'] = '候選的網站管理員';
$string['potentialcreators'] = '候選的課程管理員';
$string['potentialstudents'] = '候選的學生';
$string['potentialteachers'] = '候選的教師';
$string['preferences'] = '偏好';
$string['preferredlanguage'] = '偏愛的語言';
$string['preferredtheme'] = '偏愛的佈景';
$string['preprocessingbackupfile'] = '預先處理備份檔案';
$string['prev'] = '前一個';
$string['preview'] = '預覽';
$string['previewhtml'] = 'HTML格式預覽';
$string['previeworchoose'] = '預覽或選取一個佈景主題';
$string['previous'] = '向前';
$string['previouslyselectedusers'] = '之前選擇的用戶不符合“{$a}”';
$string['previoussection'] = '上一單元';
$string['primaryadminsetup'] = '設定管理員帳號';
$string['private_files_handler'] = '儲存附件至位於個人檔案儲存空間的電子郵件。';
$string['private_files_handler_name'] = '寄電子郵件至個人檔案。';
$string['profile'] = '簡歷';
$string['profilenotshown'] = '直到這個人至少選修一門課後，個人簡歷介紹才會顯示。';
$string['publicprofile'] = '公開的個人資料';
$string['publicsitefileswarning'] = '注意：任何人都可存取放在此處的檔案';
$string['publicsitefileswarning2'] = '請注意：放在這裡的檔案，只要知道或猜到網址的人，就能讀取到檔案。基於安全的理由，建議您任何備份的檔案在還原後，應該立即刪除。';
$string['publicsitefileswarning3'] = '請注意：放在這裡的檔案，只要知道或猜到網址的人，就能讀取到檔案。<br/>基於安全的理由，建議您備份的檔案應該只儲存在安全的備份資料夾中。';
$string['publish'] = '發佈';
$string['question'] = '試題';
$string['questionsinthequestionbank'] = '題庫中的試題';
$string['readinginfofrombackup'] = '讀取備份資訊';
$string['readme'] = '說明';
$string['recentactivity'] = '最近活動';
$string['recentactivityreport'] = '最近活動的完整報表...';
$string['recipientslist'] = '收件人名單';
$string['recreatedcategory'] = '重建類別 {$a}';
$string['redirect'] = '重新導向';
$string['reducesections'] = '減少單元數量';
$string['refresh'] = '更新';
$string['refreshingevents'] = '更新事件';
$string['registration'] = 'Moodle註冊';
$string['registrationcontact'] = '公開聯絡方式';
$string['registrationcontactno'] = '不，我不希望在網站列表中顯示聯絡表單';
$string['registrationcontactyes'] = '是的，提供一個表單以方便未來的Moodle用戶聯絡我';
$string['registrationemail'] = '電子郵件通知';
$string['registrationinfo'] = '<p>此網頁讓您到moodle.org註冊您的Moodle網站。註冊是自由的。註冊的主要優點是會將您列入重大通知的電子郵件清單中，例如:新版Moodle釋出消息及安全警報等。<p>預設中，您的資料保有隱私，而且絕不會遭受販賣或轉交給其他人。收集這些資料的唯一原因是支援的目的，同時建立一個完整的Moodle社群的統計圖。<p>如果您註冊了，您可以讓您的網站名稱、國家及URL加到Moodle網站的開放清單中。<p>所有新註冊都會經過手動確認，才加到這個清單中，但一旦您加入後，您可以隨時用此表單更新您的註冊資料。';
$string['registrationinfotitle'] = '註冊資訊';
$string['registrationno'] = '不，我不要收到電子郵件';
$string['registrationsend'] = '傳送註冊資訊到moodle.org';
$string['registrationyes'] = '是的，有重要事情請通知我';
$string['reject'] = '駁回';
$string['rejectdots'] = '駁回...';
$string['reload'] = '重新載入';
$string['remoteappuser'] = '遠端的{$a}用戶';
$string['remove'] = '移除';
$string['removeadmin'] = '移除網站管理員';
$string['removecreator'] = '移除課程管理員';
$string['removestudent'] = '移除學生';
$string['removeteacher'] = '移除教師';
$string['rename'] = '改名';
$string['renamefileto'] = '將<b>{$a}</b>重命名為';
$string['report'] = '報表';
$string['reports'] = '報表';
$string['repositories'] = '倉儲';
$string['requestcourse'] = '開課申請';
$string['requestedby'] = '申請人';
$string['requestedcourses'] = '申請開設的課程';
$string['requestreason'] = '開課申請的理由';
$string['required'] = '必須的';
$string['requirespayment'] = '這個課程需要付費';
$string['reset'] = '歸零';
$string['resetcomponent'] = '元件';
$string['resetcourse'] = '課程重新設定';
$string['resetinfo'] = '這個頁面允許您清空一個課程的用戶資料，但是保留課程活動與其他設定。請注意，下面的選項送出後您將會永遠從這個課程中刪除選擇的用戶資料。';
$string['resetnotimplemented'] = '未實作出重新設定的功能';
$string['resetrecordexpired'] = '您所用的這一密碼重設鏈結，是已經超過{$a}分鐘，且已經過期失效。請再重新做一次密碼重設。';
$string['resetstartdate'] = '重設開始日期';
$string['resetstatus'] = '狀態';
$string['resettask'] = '任務';
$string['resettodefaults'] = '重設為預設值';
$string['resortcourses'] = '課程重新排序';
$string['resortsubcategoriesby'] = '以{$a} 由小到大排列下層目錄';
$string['resortsubcategoriesbyreverse'] = '以{$a} 由大到小排列下層目錄';
$string['resource'] = '資源';
$string['resourcedisplayauto'] = '自動';
$string['resourcedisplaydownload'] = '強迫下載';
$string['resourcedisplayembed'] = '嵌入';
$string['resourcedisplayframe'] = '在框架中';
$string['resourcedisplaynew'] = '新視窗';
$string['resourcedisplayopen'] = '開啟';
$string['resourcedisplaypopup'] = '在彈出視窗中';
$string['resources'] = '資源';
$string['resources_help'] = '啟用資源類型，幾乎可以把任何類型的web內容加入到課程中';
$string['restore'] = '還原';
$string['restorecancelled'] = '還原已被取消';
$string['restorecannotassignroles'] = '從備份檔還原時，需要指派角色，但是您沒有權限這麼做。';
$string['restorecannotcreateorassignroles'] = '從備份檔還原時，需要建立或指派角色，但是您沒有權限這麼做。';
$string['restorecannotcreateuser'] = '從備份檔還原時，需要建立用戶“{$a}”，但是您沒有權限這麼做。';
$string['restorecannotoverrideperms'] = '從備份檔還原時，需要覆蓋取代權限，但是您沒有權限這麼做。';
$string['restorecoursenow'] = '立刻還原這個課程！';
$string['restoredaccount'] = '已還原的帳號';
$string['restoredaccountinfo'] = '此帳號從其他伺服器匯入，密碼已經遺失。要經由電子郵件設定新密碼，請點選"繼續"';
$string['restorefinished'] = '還原成功';
$string['restoreto'] = '還原到';
$string['restoretositeadding'] = '警告：您即將還原到網站的首頁，並且會增加資料到首頁！';
$string['restoretositedeleting'] = '警告：您即將還原到網站的首頁，並且會先刪除資料！';
$string['restoreuserconflict'] = '從備份檔案還原用戶\'{$a}\'會引起衝突';
$string['restoreuserinfofailed'] = '還原過程已經停止，因為您沒有還原用戶資料的權限。';
$string['restoreusersprecheck'] = '檢查用戶資料';
$string['restoreusersprecheckerror'] = '檢查用戶資料時發現一些問題';
$string['restricted'] = '受限制的';
$string['returningtosite'] = '返回這個網站嗎？';
$string['returntooriginaluser'] = '返回到{$a}';
$string['revert'] = '重設';
$string['role'] = '角色';
$string['roleassignments'] = '角色分配';
$string['rolemappings'] = '角色對應';
$string['rolerenaming'] = '角色更名';
$string['rolerenaming_help'] = '這選項允許您更改用於您課程的角色所顯示的名稱。例如，您可能希望將「教師」改稱為「教授」或「督導」。只有顯示的名稱會被更改 - 底下的角色授權不受影響。這些新角色名稱將會出現在課程參與者頁面，和課程的其他地方。如果這重新命名的角色是管理員選出來當作課程管理者角色，那麼這新角色名稱也將出現在課程清單。';
$string['roles'] = '角色';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'RSS連結文章數設定';
$string['rsserror'] = '讀取RSS資料錯誤';
$string['rsserrorauth'] = '您的RSS連結不包含有效的認證口令。';
$string['rsserrorguest'] = '這個饋送使用訪客身分連結資料，但是訪客沒有讀取資料的權限，請以一個有效的使用者瀏覽這個饋送的原始位址(URL)，並取得一個新的RSS連結。';
$string['rsskeyshelp'] = '為了保證安全和隱私，RSS摘要的網址中包含一個特殊的認證，用來標明他們屬於哪個使用者。這可以防止其他用戶從RSS饋送取得他們不應該瀏覽到的訊息。</p><p>在您第一次瀏覽會產生RSS摘要的Moodle頁面時，此認證會自動建立。如果您擔心您的RSS摘要認證已經被洩漏，您可以點及這裡的重置連結在取得一個新的。但請注意，您目前的RSS摘要的網址將會失效。';
$string['rsstype'] = '此活動的RSS摘要';
$string['saveandnext'] = '儲存後顯示下一位';
$string['savechanges'] = '儲存變更';
$string['savechangesanddisplay'] = '儲存並顯示';
$string['savechangesandreturntocourse'] = '儲存並返回課程';
$string['savecomment'] = '儲存評論';
$string['savedat'] = '儲存在：';
$string['savepreferences'] = '儲存偏好設定';
$string['saveto'] = '儲存到';
$string['scale'] = '量尺';
$string['scale_help'] = '<p>教師可以自行建立新的量尺，用於課程中的任何需要計分的活動。</p><p>量尺的名稱應該要能很清處說明其性質的片語：它將會出現在量尺選用清單上，以及跟內容相關連的輔助按鈕上</p><p>量尺本身是以價值觀的排列清單來界定，從消極(負面)到積極(正面)排序，並以英文半形逗號開隔。例如:</p><blockquote><i>很失望,不夠好,普通,好,非常好, 棒極了!</i></blockquote>或是<blockquote>D,C,B,A,A+</blockquote><p>量尺也應該包括一個好的說明，說明它的意義，以及它應該如何使用。這個說明將會出現在給教師和學生的輔助說明頁面上。</p><p>最後，這裡可能有系統管理者事先就訂定好的一個或多個"標準"量尺。它們將可以用於所有的課程。</p>';
$string['scales'] = '量尺';
$string['scalescustom'] = '自訂量尺';
$string['scalescustomcreate'] = '新增量尺';
$string['scalescustomno'] = '目前沒有自訂的量尺';
$string['scalesstandard'] = '標準量尺';
$string['scalestandard'] = '標準量尺';
$string['scalestandard_help'] = '標準量尺是提供整個網站所有課程使用。';
$string['scalestandard_link'] = '成績/量尺';
$string['scalestip'] = '使用管理選單上的「量尺」設定，來新增量尺。';
$string['scalestip2'] = '若要建立自訂的量尺，請點按課程管理選單的“成績”連結，然後選擇量尺->檢視。';
$string['schedule'] = '時程';
$string['screenshot'] = '畫面';
$string['search'] = '搜尋';
$string['searchagain'] = '再次搜尋';
$string['searchbyemail'] = '以電子郵件信箱搜尋';
$string['searchbyusername'] = '以用戶名稱搜尋';
$string['searchcourses'] = '搜尋課程';
$string['searchhelp'] = '<p>您可以同時使用多關鍵字來搜尋。並以下列方法來改進您的搜尋</p>
<ul>
<li>word -- 搜尋任何包含有此關鍵字的內容。
<li>+word -- 只有完全吻合這些關鍵字才會被找出來。
<li>-word -- 排除含有此關鍵字的結果。
</ul>';
$string['search_help'] = '基本搜尋可以在文字中尋找一個或多個字詞。字詞之間用空格分隔。只有一個字母的單字會被忽略。如要進行進階搜尋，直接點選搜尋按鈕，搜尋框中什麼都不要輸入，便可瀏覽進階搜尋表單。';
$string['searchoptions'] = '搜尋選項';
$string['searchresults'] = '搜尋結果';
$string['sec'] = '秒';
$string['seconds'] = '秒';
$string['secondsleft'] = '{$a}秒';
$string['secondstotime172800'] = '兩天';
$string['secondstotime259200'] = '三天';
$string['secondstotime345600'] = '四天';
$string['secondstotime432000'] = '五天';
$string['secondstotime518400'] = '六天';
$string['secondstotime604800'] = '一週';
$string['secondstotime86400'] = '一天';
$string['secretalreadyused'] = '確認更改密碼的連結已經使用過，密碼不能被更改。';
$string['secs'] = '秒';
$string['section'] = '單元';
$string['sectionname'] = '單元名稱';
$string['sections'] = '單元';
$string['sectionusedefaultname'] = '使用預設單元名稱';
$string['seealsostats'] = '請參閱：統計';
$string['selctauser'] = '選擇一位用戶';
$string['select'] = '選取';
$string['selectacategory'] = '請選擇一類別';
$string['selectacountry'] = '選擇一個國家';
$string['selectacourse'] = '選擇一門課程';
$string['selectacoursesite'] = '選擇一門課程或網站';
$string['selectagroup'] = '選擇一個分組';
$string['selectall'] = '全選';
$string['selectamodule'] = '請選擇一個活動模組';
$string['selectanaction'] = '選擇一個動作';
$string['selectanoptions'] = '選擇一個選項';
$string['selectaregion'] = '選擇一個地區';
$string['selectcategorysort'] = '你要對哪一個類別做排序？';
$string['selectcategorysortby'] = '選擇你將如何將類別排序';
$string['selectcoursesortby'] = '選擇你將如何將課程排序';
$string['selectdefault'] = '選擇預設值';
$string['selectedcategories'] = '選出的類別';
$string['selectedfile'] = '已選擇的檔案';
$string['selectednowmove'] = '{$a}檔案被選取搬移。請到選擇目的地，並按 *搬移檔案至此*';
$string['selectfiles'] = '選擇檔案';
$string['selectmoduletoviewhelp'] = '選擇一個模組來檢視輔助說明。';
$string['selectnos'] = '全選"否"';
$string['selectperiod'] = '選擇期間';
$string['senddetails'] = '以電子郵件傳送我的詳細資料';
$string['separate'] = '分開的';
$string['separateandconnected'] = '分割或相關方法認知式';
$string['separateandconnectedinfo'] = '這個尺度基於獨立型和情境型認知理論。此理論描述了我們了解和評論所聞所見事物的兩種不同方法。<ul><li><strong>獨立型的人</strong>總是儘量保持客觀，避免受感覺和情緒的影響。在與其他人討論時，他們喜歡維護自己的觀點，用邏輯找出對手觀點中的漏洞。</li><li><strong>情景型的人</strong>比其他人更敏感。他們善於換位思考，喜歡傾聽和提問，直到他們覺得自己能從別人的角度理解事物。他們通過分享自己的經驗，來從他人獲得知識。</li></ul>';
$string['servererror'] = '和伺服器通訊時發生了一個錯誤';
$string['serverlocaltime'] = '伺服器的當地時間';
$string['setcategorytheme'] = '設定各類別專用的佈景主題';
$string['setpassword'] = '設定密碼';
$string['setpasswordinstructions'] = '請在下面輸入你的新密碼，並重複，再擊點"設定密碼"。<br />
你的新密碼將會被儲存，而你將會被登入。';
$string['settings'] = '設定';
$string['shortname'] = '課程簡稱';
$string['shortnamecollisionwarning'] = '[*]= 這個簡稱已經被其他課程使用，需要修改才能獲得核准。';
$string['shortnamecourse'] = '課程簡稱';
$string['shortnamecourse_help'] = '課程簡稱會顯示在導覽列，以及使用在課程郵件訊息的主旨行中。
　　';
$string['shortnametaken'] = '這個簡稱已用於另一個課程({$a})';
$string['shortnameuser'] = '用戶簡稱';
$string['shortsitename'] = '網站簡稱';
$string['show'] = '顯示';
$string['showactions'] = '顯示動作';
$string['showadvancedsettings'] = '顯示進階設定';
$string['showall'] = '顯示全部{$a}';
$string['showallcourses'] = '顯示全部課程';
$string['showallusers'] = '顯示全部用戶';
$string['showblockcourse'] = '顯示包含區塊的課程清單';
$string['showcategory'] = '顯示 {$a}';
$string['showcomments'] = '顯示/隱藏評論';
$string['showcommentsnonjs'] = '顯示評論';
$string['showdescription'] = '顯示說明';
$string['showdescription_help'] = '如果啟用，上述的介紹/說明將顯示在課程頁面上，於活動/資源連結的下方。';
$string['showgrades'] = '向學生顯示成績單';
$string['showgrades_help'] = '<p>許多活動都允許設定分數</p><p>預設中，在課程中的所有分數都可以在成績頁中看到，在課程主頁中選單可找到。</p><p>如果教師在課程中不想打分數，或只是不想讓學生看到成績，那他可以在課程設定頁中關閉成績簿的顯示。這樣做不會影響活動中使用或設定成績，它只是不讓學生看到而已。</p>';
$string['showingacourses'] = '顯示所有{$a}課程';
$string['showingxofycourses'] = '顯示全部{$a->total} 個課程的{$a->start} 到 {$a->end} 。';
$string['showlistofcourses'] = '顯示課程清單';
$string['showmodulecourse'] = '顯示包含活動的課程清單';
$string['showonly'] = '只顯示';
$string['showperpage'] = '每頁顯示{$a}';
$string['showrecent'] = '顯示近期活動';
$string['showreports'] = '顯示活動報表';
$string['showreports_help'] = '活動報表提供給每一位參與者，顯示他們在課程中的活動。以及他們的貢獻，例如討論區發表或作業繳交，這些報表還包括使用紀錄。這個設定決定學生是否可以經由個人資料頁，來檢視自己的活動報表。';
$string['showsettings'] = '顯示設定';
$string['showtheselogs'] = '顯示這些日誌';
$string['showthishelpinlanguage'] = '顯示輔助說明採用語言：{$a}';
$string['since'] = '自從';
$string['sincelast'] = '從上次登入後';
$string['site'] = '網站';
$string['sitedefault'] = '網站預設';
$string['siteerrors'] = '網站錯誤記錄';
$string['sitefiles'] = '網站檔案';
$string['sitefilesused'] = '在此課程中使用的網站檔案';
$string['sitehome'] = '網站首頁';
$string['sitelegacyfiles'] = '舊版的網站檔案';
$string['sitelogs'] = '網站日誌';
$string['sitemessage'] = '傳簡訊通知用戶';
$string['sitenews'] = '網站公告';
$string['sitepages'] = '網站頁面';
$string['sitepartlist'] = '您沒有檢視參與者清單的權限。';
$string['sitepartlist0'] = '您必須是網站教師身份才有權限看這個網站的參與者清單';
$string['sitepartlist1'] = '您必須是教師身份才有權限看這個網站的參與者清單';
$string['sites'] = '網站';
$string['sitesection'] = '包含一個主題區塊';
$string['sitesettings'] = '網站設定';
$string['siteteachers'] = '網站教師';
$string['size'] = '大小';
$string['sizeb'] = '位元組';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = '略過';
$string['skiptocategorylisting'] = '跳到類別列表';
$string['skiptocoursedetails'] = '跳到詳細的課程訊息';
$string['skiptocourselisting'] = '跳到課程列表';
$string['skypeid'] = 'Skype 帳號';
$string['socialheadline'] = '社區論壇 - 最新話題';
$string['someallowguest'] = '有些課程可能允許訪客瀏覽';
$string['someerrorswerefound'] = '可能有些資訊遺失或有誤。細節請看下列。';
$string['sort'] = '排序';
$string['sortby'] = '排序依據';
$string['sortbyx'] = '依{$a}遞增排序';
$string['sortbyxreverse'] = '依{$a}遞減排序';
$string['sorting'] = '排序';
$string['sourcerole'] = '來源角色';
$string['specifyname'] = '您必須指定一個名稱';
$string['standard'] = '標準';
$string['starpending'] = '([*] = 待審核的課程)';
$string['startdate'] = '課程開始日期';
$string['startdate_help'] = '此設定決定週曆格式課程的第一週開始時間。它也訂定了紀錄課程活動日誌的開始時間。';
$string['startingfrom'] = '開始於';
$string['startsignup'] = '申請一個新帳號';
$string['state'] = '縣/市';
$string['statistics'] = '統計';
$string['statisticsgraph'] = '統計圖表';
$string['stats'] = '統計';
$string['statslogins'] = '登入';
$string['statsmodedetailed'] = '詳細(用戶)檢視';
$string['statsmodegeneral'] = '一般檢視';
$string['statsnodata'] = '目前沒有課程與時間的合併資料';
$string['statsnodatauser'] = '目前沒有課程、用戶與時間的合併資料';
$string['statsoff'] = '統計功能尚未啟用';
$string['statsreads'] = '瀏覽';
$string['statsreport1'] = '登入';
$string['statsreport10'] = '用戶活動';
$string['statsreport11'] = '最活躍課程';
$string['statsreport12'] = '最活躍課程(加權)';
$string['statsreport13'] = '最多參與的課程(選修)';
$string['statsreport14'] = '最多參與的課程(瀏覽/發表)';
$string['statsreport2'] = '瀏覽(全部角色)';
$string['statsreport3'] = '發表(全部角色)';
$string['statsreport4'] = '所有活動(全部角色)';
$string['statsreport5'] = '所有活動(瀏覽和發表)';
$string['statsreport7'] = '用戶活動(瀏覽和發表)';
$string['statsreport8'] = '所有用戶活動';
$string['statsreport9'] = '登入(網站課程)';
$string['statsreportactivity'] = '所有活動(全部角色)';
$string['statsreportactivitybyrole'] = '所有活動(瀏覽和發表)';
$string['statsreportforuser'] = '為';
$string['statsreportlogins'] = '登入';
$string['statsreportreads'] = '瀏覽 (所有角色)';
$string['statsreporttype'] = '報表類型';
$string['statsreportwrites'] = '發表(全部角色)';
$string['statsstudentactivity'] = '學生活動';
$string['statsstudentreads'] = '學生瀏覽';
$string['statsstudentwrites'] = '學生發表';
$string['statsteacheractivity'] = '教師活動';
$string['statsteacherreads'] = '教師瀏覽';
$string['statsteacherwrites'] = '教師發表';
$string['statstimeperiod'] = '期間 - 過去的：';
$string['statsuniquelogins'] = '唯一登入';
$string['statsuseractivity'] = '所有活動';
$string['statsuserlogins'] = '登入';
$string['statsuserreads'] = '瀏覽';
$string['statsuserwrites'] = '發表';
$string['statswrites'] = '發表';
$string['status'] = '狀態';
$string['stringsnotset'] = '以下的字串未被定義在{$a}';
$string['studentnotallowed'] = '抱歉，您無法以{$a}身分進入本課程';
$string['students'] = '學生';
$string['studentsandteachers'] = '學生和教師';
$string['subcategories'] = '下層類別';
$string['subcategory'] = '下層類別';
$string['subcategoryof'] = '{$a}的下層類別';
$string['submit'] = '送出';
$string['success'] = '成功';
$string['summary'] = '摘要';
$string['summary_help'] = '摘要是一小段文字，向學生簡介該主題或週次內的活動。這段文字會顯示在課程頁面中單元名稱的後面。';
$string['summaryof'] = '{$a}的摘要';
$string['supplyinfo'] = '更多細節';
$string['suspended'] = '已停用';
$string['suspendedusers'] = '已被停用的使用者';
$string['switchdevicedefault'] = '切換到標準的佈景主題';
$string['switchdevicerecommended'] = '為您的設備切換到推薦的佈景主題';
$string['switchrolereturn'] = '返回我的正常角色';
$string['switchroleto'] = '變換角色為...';
$string['tag'] = '標籤';
$string['tagalready'] = '這個標籤已經存在';
$string['tagmanagement'] = '新增/刪除標籤';
$string['tags'] = '標籤';
$string['targetrole'] = '目標角色';
$string['teacheronly'] = '{$a}專用';
$string['teacherroles'] = '{$a}角色';
$string['teachers'] = '教師';
$string['textediting'] = '文字編輯器';
$string['texteditor'] = '使用標準網頁形式';
$string['textformat'] = '一般文字格式';
$string['thanks'] = '謝謝';
$string['theme'] = '佈景主題';
$string['themes'] = '佈景主題';
$string['themesaved'] = '新的佈景主題已儲存';
$string['therearecourses'] = '這裡有{$a}門課程';
$string['thereareno'] = '在此課程沒有 {$a}';
$string['thiscategory'] = '這一類別';
$string['thiscategorycontains'] = '此類別包含';
$string['time'] = '時間';
$string['timecreatedcourse'] = '課程建立日期';
$string['timezone'] = '時區';
$string['to'] = '到';
$string['tocontent'] = '到項目"{$a}"';
$string['tocreatenewaccount'] = '直接跳到建立新帳號';
$string['today'] = '今日';
$string['todaylogs'] = '今天的日誌';
$string['toeveryone'] = '給每個人';
$string['toomanybounces'] = '這個電子郵件信箱已經有太多退信。您<b>必須</b>更改才能繼續。';
$string['toomanytoshow'] = '要顯示的用戶太多';
$string['toomanyusersmatchsearch'] = '太多用戶（{$a->count}位）符合 “{$a->search}”條件';
$string['toomanyuserstoshow'] = '太多位用戶（{$a}位）要顯示';
$string['toonly'] = '只給{$a}';
$string['top'] = '最上層';
$string['topic'] = '主題';
$string['topichide'] = '對{$a}隱藏此主題';
$string['topicoutline'] = '主題大綱';
$string['topicshow'] = '顯示此主題於{$a}';
$string['toplevelcategory'] = '頂層類別';
$string['total'] = '總共';
$string['totopofsection'] = '到單元"{$a}"的上方';
$string['trackforums'] = '討論區追蹤';
$string['trackforumsno'] = '不：不需要追蹤我看過的文章';
$string['trackforumsyes'] = '好：把新張貼的文章突顯出來';
$string['trysearching'] = '請試試搜尋';
$string['turneditingoff'] = '關閉編輯模式';
$string['turneditingon'] = '啟動編輯模式';
$string['unauthorisedlogin'] = '這用戶帳號"{$a}"，在此網站上無法使用';
$string['undecided'] = '尚未決定';
$string['unfinished'] = '未完成';
$string['unknowncategory'] = '不明的類別';
$string['unknownerror'] = '未知的錯誤';
$string['unlimited'] = '無限制';
$string['unpacking'] = '解開{$a}';
$string['unsafepassword'] = '不安全的密碼 - 試試別的吧！';
$string['untilcomplete'] = '直到完成';
$string['unusedaccounts'] = '當帳號{$a}天未使用則自動撤銷選課。';
$string['unzip'] = '解壓縮';
$string['unzippingbackup'] = '解壓縮備份檔';
$string['up'] = '往上';
$string['update'] = '更新';
$string['updated'] = '已更新{$a}';
$string['updatemymoodleoff'] = '停止自訂此頁';
$string['updatemymoodleon'] = '自訂此頁';
$string['updatemyprofile'] = '更新個人資料';
$string['updatesevery'] = '每{$a}秒更新一次';
$string['updatethis'] = '更改這個{$a}';
$string['updatethiscourse'] = '更新此課程';
$string['updatinga'] = '更新中：{$a}';
$string['updatingain'] = '正在更改{$a->in}中的{$a->what}';
$string['upload'] = '上傳';
$string['uploadafile'] = '上傳一個檔案';
$string['uploadcantwrite'] = '檔案儲存到磁碟時發生錯誤';
$string['uploadedfile'] = '檔案上傳成功';
$string['uploadedfileto'] = '上傳{$a->file}到{$a->directory}目錄下';
$string['uploadedfiletoobig'] = '抱歉，檔案太大(上傳限制是{$a}位元)';
$string['uploadextension'] = '某個PHP延伸套件停止了檔案上傳';
$string['uploadfailednotrecovering'] = '檔案上傳失敗，因為其中一個檔案有問題，{$a->name}。<br/>這是問題記錄：<br/>{$a->problem}<br/>無法復原。';
$string['uploadfilelog'] = '檔案{$a}的上傳記錄';
$string['uploadformlimit'] = '上傳的檔案{$a}超過這個表單所設定的檔案大小的上限。';
$string['uploadlabel'] = '標題';
$string['uploadlimitwithsize'] = '{$a->contextname} 上傳的限制 ({$a->displaysize})';
$string['uploadnewfile'] = '上傳新檔案';
$string['uploadnofilefound'] = '找不到檔案 - 您確定已經選擇了一個要上傳的檔案嗎?';
$string['uploadnotallowed'] = '不允許上傳';
$string['uploadnotempdir'] = '缺少暫存的資料夾';
$string['uploadoldfilesdeleted'] = '已刪除您的上傳區的舊檔案';
$string['uploadpartialfile'] = '檔案僅部分上傳';
$string['uploadproblem'] = '上傳檔案{$a}時發生不知名錯誤  (是否檔案過大?)';
$string['uploadrenamedchars'] = '由於有無效字元，已將{$a->oldname}更名為{$a->newname}';
$string['uploadrenamedcollision'] = '因為檔名衝突重複，已將檔案重新命名，由{$a->oldname}改成{$a->newname}。';
$string['uploadserverlimit'] = '上傳的檔案超出系統設定的檔案大小上限。';
$string['uploadthisfile'] = '上傳本檔案';
$string['url'] = '網址';
$string['used'] = '已使用';
$string['usedinnplaces'] = '在{$a}處使用';
$string['usemessageform'] = '或者是透過下面表單寄送訊息給選取的學生';
$string['user'] = '用戶';
$string['useractivity'] = '活動';
$string['userconfirmed'] = '確認{$a}';
$string['usercurrentsettings'] = '個人資料設定';
$string['userdata'] = '用戶資料';
$string['userdeleted'] = '該用戶帳號已被刪除';
$string['userdescription'] = '個人簡介';
$string['userdescription_help'] = '可以在此框中輸入一些關於您自己的文字。它們會在您的個人資料頁中顯示給其他人看。';
$string['userdetails'] = '用戶的詳細資料';
$string['userfiles'] = '用戶的檔案';
$string['userlist'] = '用戶清單';
$string['usermenu'] = '用戶選單';
$string['username'] = '帳號';
$string['usernameemail'] = '帳號/電子郵件';
$string['usernameemailmatch'] = '帳號與電子郵件信箱不是同一位用戶的';
$string['usernameexists'] = '帳號名稱重複(已被使用)，請選擇另一個名稱';
$string['usernamelowercase'] = '只允許小寫英文字母';
$string['usernamenotfound'] = '資料庫中找不到這個用戶名稱';
$string['usernameoremail'] = '輸入帳號或信箱';
$string['usernotconfirmed'] = '無法確認{$a}';
$string['userpic'] = '用戶相片';
$string['users'] = '用戶';
$string['userselectorautoselectunique'] = '如果只有一位用戶符合搜尋條件，就會自動選擇他';
$string['userselectorpreserveselected'] = '保留選取的用戶，即使他們不符合搜尋條件';
$string['userselectorsearchanywhere'] = '用戶名稱有任意字符合搜尋文字即可';
$string['usersnew'] = '新用戶';
$string['usersnoaccesssince'] = '未活動超過';
$string['userswithfiles'] = '有檔案的用戶';
$string['useruploadtype'] = '用戶上傳類型：{$a}';
$string['userviewingsettings'] = '{$a}的個人資料設定';
$string['userzones'] = '用戶區';
$string['usetheme'] = '使用佈景主題';
$string['usingexistingcourse'] = '使用現有課程';
$string['valuealreadyused'] = '這個值已經使用過了。';
$string['version'] = '版本';
$string['view'] = '瀏覽';
$string['viewallcourses'] = '瀏覽所有課程';
$string['viewallcoursescategories'] = '瀏覽所有課程和分類';
$string['viewallsubcategories'] = '觀看所有的子類別';
$string['viewfileinpopup'] = '在彈出視窗檢視檔案';
$string['viewing'] = '檢視：';
$string['viewmore'] = '觀看更多';
$string['viewprofile'] = '瀏覽個人資料';
$string['views'] = '瀏覽';
$string['viewsolution'] = '查看解決方案';
$string['virusfound'] = '管理員請注意!Clam AV發現{$a->course}課程的{$a->user}使用者上傳的檔案有病毒。以下是clamscan的報告:';
$string['virusfoundlater'] = '您於{$a->date}在{$a->course}課程中所上傳的檔案{$a->filename}發現有病毒。這裡是對您檔案所做的處理動作:

{$a->action}

如果這是繳交的作業，您需要重新繳交，您的教師就可以再看到了。';
$string['virusfoundlateradmin'] = '管理員請注意！{$a->date}時，在{$a->course}課程的用戶{$a->user}上傳的檔案{$a->filename}中，發現含有病毒。以下是對這個檔案的處理報告:

{$a->action}

已經通知該使用者了。';
$string['virusfoundlateradminnolog'] = '管理員請注意!上傳的檔案中，{$a->filename}已經發現有病毒。Moodle無法將這個檔案重新送回上傳它的使用者。以下是對這個檔案的處理報告:

{$a->action}';
$string['virusfoundsubject'] = '{$a}：發現病毒!';
$string['virusfounduser'] = '您所上傳的檔案{$a->filename}，經由病毒檢查，發現受感染，
您的檔案上傳失敗。';
$string['virusplaceholder'] = '所上傳的檔案檢查出病毒，已經搬移或刪除並通知使用者。';
$string['visible'] = '是否顯示';
$string['visible_help'] = '這個設定決定這課程是否出現在課程列表中。教師和管理者以外的其他用戶都不能進入此課程。';
$string['visibletostudents'] = '{$a}可以看見';
$string['warning'] = '警告';
$string['warningdeleteresource'] = '警告：在某個資源中引用了{$a}。您想要更新相關聯的資源嗎？';
$string['webpage'] = '網頁';
$string['week'] = '週';
$string['weekhide'] = '從{$a}隱藏這個星期';
$string['weeklyoutline'] = '本週大綱';
$string['weeks'] = '週';
$string['weekshow'] = '顯示本週到{$a}';
$string['welcometocourse'] = '歡迎參加{$a}課程';
$string['welcometocoursetext'] = '歡迎參加{$a->coursename}課程！

如果您還沒有做，請先編輯您的個人資料，這樣我們才可以進一步認識您：

{$a->profileurl}';
$string['whatforlink'] = '你要如何處理這一鏈結？';
$string['whatforpage'] = '你要如何處理這一文字？';
$string['whattocallzip'] = '您要如何命名這個ZIP檔案？';
$string['whattodo'] = '要做什麼';
$string['windowclosing'] = '本視窗會自動關閉。如果沒有關閉，請現在就關閉它。';
$string['withchosenfiles'] = '將選定的檔案';
$string['withdisablednote'] = '{$a} (停用)';
$string['withoutuserdata'] = '不含用戶資料';
$string['withselectedusers'] = '針對選取的用戶...';
$string['withselectedusers_help'] = '* 發送訊息 - 將訊息發送到一位或多位學生

* 新增一篇筆記 - 新增一篇筆記給選取的學生

* 新增一篇共同筆記 - 新增一篇筆記給一位以上的學生';
$string['withuserdata'] = '包含用戶資料';
$string['wordforstudent'] = '學生的稱呼';
$string['wordforstudenteg'] = '例如學生、夥伴等';
$string['wordforstudents'] = '學生們的稱呼';
$string['wordforstudentseg'] = '例如學生們、夥伴們等';
$string['wordforteacher'] = '教師的稱謂';
$string['wordforteachereg'] = '例如教師、講師、教授和輔導員等';
$string['wordforteachers'] = '教師們的稱謂';
$string['wordforteacherseg'] = '例如教師們、導師們、教授們和教員們等';
$string['writingblogsinfo'] = '寫入部落格資訊';
$string['writingcategoriesandquestions'] = '寫入類別和試題';
$string['writingcoursedata'] = '寫入課程資料';
$string['writingeventsinfo'] = '寫入事件資訊';
$string['writinggeneralinfo'] = '寫入一般資訊';
$string['writinggradebookinfo'] = '寫入成績單資訊';
$string['writinggroupingsgroupsinfo'] = '寫入分群分組資訊';
$string['writinggroupingsinfo'] = '寫入分群資訊';
$string['writinggroupsinfo'] = '寫入分組資訊';
$string['writingheader'] = '寫入檔案標頭';
$string['writingloginfo'] = '寫入日誌資訊';
$string['writingmessagesinfo'] = '寫入訊息資訊';
$string['writingmoduleinfo'] = '寫入模組資訊';
$string['writingscalesinfo'] = '寫入量尺資訊';
$string['writinguserinfo'] = '寫入用戶資訊';
$string['wrongpassword'] = '這個帳號的密碼不正確';
$string['yahooid'] = 'Yahoo 帳號';
$string['year'] = '年';
$string['years'] = '年';
$string['yes'] = '是';
$string['youareabouttocreatezip'] = '您即將建立一個zip的包裝壓縮';
$string['youaregoingtorestorefrom'] = '您即將啟動還原程序';
$string['youneedtoenrol'] = '您必須先選修這門課程，才能執行這個動作。';
$string['yourlastlogin'] = '您上次登入是在';
$string['yourself'] = '您自己';
$string['yourteacher'] = '您的{$a}';
$string['yourwordforx'] = '您稱呼“{$a}”為';
$string['zippingbackup'] = '壓縮備份資料中';
