<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_magazine', language 'zh_tw', branch 'MOODLE_27_STABLE'
 *
 * @package   theme_magazine
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background'] = '背景';
$string['backgrounddesc'] = '輸入圖片網址來改變背景圖片。（例如：http://www.somesite/mybackground.jpg）';
$string['blockcolor'] = '區塊顏色';
$string['blockcolordesc'] = '區塊標題字體顏色';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot">

<h2>Magazine</h2><img src="magazine/pix/screenshot.png" />

<h3>主題討論區</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

<h3>主題致謝</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

<h3>主題文檔</h3>
<p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>

<h3>錯誤提報</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p></div><div class="theme_description">

<h2>關於</h2>
<p>Magazine是一個三列、可變寬度的Moodle 2.0主題。

<h2>調整</h2>
<p>本主題基於Moodle核心的基本主題和布景主題構建。如果您想修改它，我們建議您在修改之前先複製一份並換名稱。這樣將來Moodle升級時才不會覆蓋您定製的主題。而且一旦您搞亂了它，還有原始檔的備份。關於修改主題的更多資訊，請流覽<a href="http://docs.moodle.org/en/Theme">Moodle文檔</a>。
</p>

<h2>致謝</h2>
<p>本主題由NewSchool Learning的John Stabinger編寫和維護。可以通過contact@newschoollearning.com聯繫他。</p>

<h2>授權</h2>
<p>Moodle核心提供的所有主題，包括此主題的授權協定都是<a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>。
用於這主題的某些圖標示來自於Splashy 圖標集合，是可以在 http://splashyfish.com/icons/. 免費取用。</div></div>';
$string['configtitle'] = 'Magazine 主題';
$string['forumback'] = '討論區背景顏色';
$string['forumbackdesc'] = '設置討論區帖子主題的背景色。';
$string['headingcolor'] = '標題顏色';
$string['headingcolordesc'] = '大標題（網站新聞、我的課程）和其他標題的顏色。';
$string['linkcolor'] = '鏈結';
$string['linkcolordesc'] = '設定本主題鏈結的顏色，使用html 16 進位制代碼。';
$string['linkhover'] = '鏈結懸停';
$string['linkhoverdesc'] = '設定本主題中鏈結（懸停時）的顏色，使用html 16進位制代碼。';
$string['logo'] = '標誌';
$string['logodesc'] = '輸入標誌的網址（例如，http://www.somesite/animage.png），可改變佈景的標誌。預設的標誌是300px寬，80px高。背景透明的PNG檔案格式效果最好。';
$string['maincolor'] = '主要顏色';
$string['maincoloraccent'] = '主突出色';
$string['maincoloraccentdesc'] = '停靠欄和頭部邊界的深突出色。應該比主色略深一點。';
$string['maincolordesc'] = '設置頭部、停靠欄和其他區域顏色的16進制代碼。深色或飽和色的效果最好。';
$string['pluginname'] = 'Magazine';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
