<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'es', branch 'MOODLE_28_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'a punto de ser instalado';
$string['action'] = 'Acción';
$string['actionchoice'] = '¿Qué quiere hacer con el archivo \'{$a}\'?';
$string['actions'] = 'Acciones';
$string['active'] = 'Activa';
$string['activeusers'] = 'Usuarios activos';
$string['activities'] = 'Actividades';
$string['activities_help'] = 'Las actividades (tales como foros, cuestionarios y wikis) posibilitan agregar contenidos interactivos al curso';
$string['activity'] = 'Actividad';
$string['activityclipboard'] = 'Moviendo la actividad: {$a}';
$string['activityiscurrentlyhidden'] = 'Lo sentimos, esta actividad está oculta';
$string['activitymodule'] = 'Módulo';
$string['activitymodules'] = 'Módulos de actividad';
$string['activityreport'] = 'Informe de actividades';
$string['activityreports'] = 'Informes de actividad';
$string['activityselect'] = 'Seleccionar esta actividad para moverla';
$string['activitysince'] = 'Actividad desde {$a}';
$string['activityweighted'] = 'Actividad por usuario';
$string['add'] = 'Agregar';
$string['addactivity'] = 'Agregar actividad...';
$string['addactivitytosection'] = 'Añadir una actividad a la sección \'{$a}\'';
$string['addadmin'] = 'Agregar administrador';
$string['addblock'] = 'Agregar un bloque';
$string['addcomment'] = 'Agregar un comentario...';
$string['addcountertousername'] = 'Crear usuario agregando un número al nombre de usuario';
$string['addcreator'] = 'Agregar creador de curso';
$string['adddots'] = 'Agregar...';
$string['added'] = 'Agregado {$a}';
$string['addedrecip'] = 'Agregado nuevo receptor {$a}';
$string['addedrecips'] = 'Agregados nuevos receptores {$a}';
$string['addedtogroup'] = 'Agregado al grupo "{$a}"';
$string['addedtogroupnot'] = 'No agregado al grupo "{$a}"';
$string['addedtogroupnotenrolled'] = 'No agregado al grupo "{$a}" porque no está matriculado en el curso';
$string['addfilehere'] = 'Añada archivo(s) aquí';
$string['addinganew'] = 'Agregando {$a}';
$string['addinganewto'] = 'Agregando {$a->what} a {$a->to}';
$string['addingdatatoexisting'] = 'Agregando información';
$string['additionalnames'] = 'Nombres adicionales';
$string['addlinkhere'] = 'Añada el enlace aquí';
$string['addnewcategory'] = 'Agregar nueva categoría';
$string['addnewcourse'] = 'Agregar un nuevo curso';
$string['addnewuser'] = 'Agregar usuario';
$string['addnousersrecip'] = 'Agregar a la lista de destinatarios a los usuarios que no han accedido a este {$a}';
$string['addpagehere'] = 'Añadir texto aquí';
$string['addresource'] = 'Agregar recurso...';
$string['addresourceoractivity'] = 'Añadir una actividad o un recurso';
$string['addresourcetosection'] = 'Añadir recurso a la sección \'{$a}\'';
$string['address'] = 'Dirección';
$string['addstudent'] = 'Agregar estudiante';
$string['addsubcategory'] = 'Agregar una subcategoría';
$string['addteacher'] = 'Agregar profesor';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Crear una nueva cuenta manualmente';
$string['adminhelpassignadmins'] = 'Los administradores pueden hacer cualquier cosa en cualquier parte del sitio';
$string['adminhelpassigncreators'] = 'Los creadores pueden crear nuevos cursos';
$string['adminhelpassignsiteroles'] = 'Aplicar roles definidos de sitio a usuarios específicos';
$string['adminhelpassignstudents'] = 'Ir a un curso y agregar estudiantes desde el menú Administración';
$string['adminhelpauthentication'] = 'Puede utilizar cuentas internas o bases de datos externas';
$string['adminhelpbackup'] = 'Configurar las copias de seguridad automáticas';
$string['adminhelpconfiguration'] = 'Configurar la apariencia y el funcionamiento general del sitio';
$string['adminhelpconfigvariables'] = 'Configurar variables que inciden en la operación general del sitio';
$string['adminhelpcourses'] = 'Definir cursos y categorías y asignarles personas';
$string['adminhelpeditorsettings'] = 'Definir ajustes básicos del editor HTML';
$string['adminhelpedituser'] = 'Navegar por la lista de usuarios y editar cualquiera de ellos';
$string['adminhelpenvironment'] = 'Compruebe si su servidor se ajusta a los requerimientos de instalación actuales y futuros.';
$string['adminhelpfailurelogs'] = 'Revisar registros de accesos fallidos';
$string['adminhelplanguage'] = 'Revisar y editar el presente idioma';
$string['adminhelplogs'] = 'Navegar por los registros de toda la actividad del sitio';
$string['adminhelpmanageblocks'] = 'Manejar bloques instalados y sus ajustes';
$string['adminhelpmanagedatabase'] = 'Acceder directamente a la base de datos (¡cuidado!)';
$string['adminhelpmanagefilters'] = 'Seleccionar filtros de texto y su configuración';
$string['adminhelpmanagemodules'] = 'Administrar los módulos instalados y sus configuraciones';
$string['adminhelpmanageroles'] = 'Crear y definir roles que pueden aplicarse a los usuarios';
$string['adminhelpmymoodle'] = 'Configurar los bloques de Mi Moodle para usuarios';
$string['adminhelpreports'] = 'Clasificación de cursos por distintos criterios';
$string['adminhelpsitefiles'] = 'Publicar archivos en general o subir copias de seguridad externas';
$string['adminhelpsitesettings'] = 'Definir el aspecto de la página principal';
$string['adminhelpstickyblocks'] = 'Configurar bloques \'sticky\' a través de Moodle';
$string['adminhelpthemes'] = 'Elegir el estilo del sitio (colores, fuentes, etc.)';
$string['adminhelpuploadusers'] = 'Importar usuarios desde un archivo de texto';
$string['adminhelpusers'] = 'Definir los usuarios y configurar la identificación';
$string['adminhelpxmldbeditor'] = 'Interfaz para editar archivos XMLDB. Sólo para desarrolladores.';
$string['administration'] = 'Administración';
$string['administrationsite'] = 'Administración del sitio';
$string['administrator'] = 'Administrador';
$string['administratordescription'] = 'Normalmente los administradores pueden hacer cualquier cosa en el sitio, en todos los cursos.';
$string['administrators'] = 'Administradores';
$string['administratorsall'] = 'Todos los administradores';
$string['administratorsandteachers'] = 'Administradores y profesores';
$string['advanced'] = 'Avanzada';
$string['advancedfilter'] = 'Búsqueda avanzada';
$string['advancedsettings'] = 'Ajustes avanzados';
$string['afterresource'] = 'Después del recurso "{$a}"';
$string['aftersection'] = 'Después de la sección "{$a}"';
$string['again'] = 'de nuevo';
$string['aimid'] = 'ID AIM';
$string['ajaxuse'] = 'AJAX y Javascript';
$string['all'] = 'Todos';
$string['allactions'] = 'Todas las acciones';
$string['allactivities'] = 'Todas las actividades';
$string['allcategories'] = 'Todas las categorías';
$string['allchanges'] = 'Todos los cambios';
$string['alldays'] = 'Todos los días';
$string['allfieldsrequired'] = 'Todos los campos son obligatorios';
$string['allfiles'] = 'Todos los archivos';
$string['allgroups'] = 'Todos los grupos';
$string['alllogs'] = 'Todas las entradas';
$string['allmods'] = 'Todos {$a}';
$string['allow'] = 'Permitir';
$string['allowinternal'] = 'Permitir también métodos internos';
$string['allownone'] = 'No permitir ninguno';
$string['allownot'] = 'No permitir';
$string['allparticipants'] = 'Todos los participantes';
$string['allteachers'] = 'Todos los profesores';
$string['alphanumerical'] = 'Sólo puede contener caracteres alfanuméricos, guión (-) o punto (.)';
$string['alreadyconfirmed'] = 'El registro ya ha sido confirmado';
$string['alternatename'] = 'Nombre alternativo';
$string['always'] = 'Siempre';
$string['and'] = '{$a->one} y {$a->two}';
$string['answer'] = 'Respuesta';
$string['any'] = 'Cualquiera';
$string['appearance'] = 'Apariencia';
$string['approve'] = 'Aprobar';
$string['areyousure'] = '¿Està seguro?';
$string['areyousuretorestorethis'] = '¿Está seguro de que desea continuar?';
$string['areyousuretorestorethisinfo'] = 'Más adelante en este proceso tendrá la opción de agregar esta copia a otro curso o utilizarla para crear un curso completamente nuevo.';
$string['asc'] = 'Ascendente';
$string['assessment'] = 'Evaluación';
$string['assignadmins'] = 'Asignar administradores';
$string['assigncreators'] = 'Asignar creadores';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Asignar roles para todo el sitio';
$string['authenticateduser'] = 'Usuario identificado';
$string['authenticateduserdescription'] = 'Todos los usuarios identificados.';
$string['authentication'] = 'Identificación';
$string['authenticationplugins'] = 'Plugins de identificación';
$string['autosubscribe'] = 'Subscripción automática al foro';
$string['autosubscribeno'] = 'No: no me suscriba automáticamente a los foros';
$string['autosubscribeyes'] = 'Sí: cuando envíe un mensaje suscríbame a ese foro';
$string['availability'] = 'Disponibilidad';
$string['availablecourses'] = 'Cursos disponibles';
$string['back'] = 'Atrás';
$string['backto'] = 'Regresar a {$a}';
$string['backtocourselisting'] = 'Volver a la lista de cursos';
$string['backtopageyouwereon'] = 'Volver a la página de procedencia';
$string['backtoparticipants'] = 'Volver a la lista de participantes';
$string['backup'] = 'Copia de seguridad';
$string['backupactivehelp'] = 'Decida si se hacen o no copias de seguridad automatizadas';
$string['backupcancelled'] = 'Copia de seguridad cancelada';
$string['backupcoursefileshelp'] = 'Si se activa, los archivos del curso se incluirán en copias de seguridad automatizadas';
$string['backupdate'] = 'Fecha de la copia de seguridad';
$string['backupdatenew'] = '{$a->TAG} es ahora {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} fue {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detalles de la copia de seguridad';
$string['backupexecuteathelp'] = 'Decida a qué hora se realizarán las copias de seguridad automatizadas';
$string['backupfailed'] = '¡Algunos de sus cursos no han sido guardados!';
$string['backupfilename'] = 'copia de seguridad';
$string['backupfinished'] = 'Copia de seguridad completada con éxito';
$string['backupfromthissite'] = '¿Se ha hecho copia de seguridad en el sitio?';
$string['backupgradebookhistoryhelp'] = 'Si está habilitada la opción, la historia del libro de calificaciones se incluirá en las copias de seguridad automatizadas. Advierta que la historia de calificaciones no debe estar desactivada en los ajustes del servidor (disablegradhistory) para que esta característica funcione.';
$string['backupincludemoduleshelp'] = 'Seleccione si desea incluir los módulos, con o sin los datos de usuario, en las copias de seguridad';
$string['backupincludemoduleuserdatahelp'] = 'Decida si quiere incluir datos del usuario del módulo en las copias de seguridad automatizadas.';
$string['backupkeephelp'] = '¿Cuántas copias de seguridad de cada curso desea mantener? (las más antiguas serán borradas automáticamente)';
$string['backuplogdetailed'] = 'Registro de ejecución detallado';
$string['backuploglaststatus'] = 'Último registro de ejecución';
$string['backupmissinguserinfoperms'] = 'Nota: Esta copia de seguridad no contiene datos de usuarios. Las actividades de Ejercicio y Taller no se incluirán en la copia de seguridad, puesto que estos módulos no son compatibles con este tipo de copia.';
$string['backupnext'] = 'Siguiente copia de seguridad';
$string['backupnonisowarning'] = 'ATENCIÓN: esta copia proviene de una versión de Moodle no Unicode (anterior a la 1.6). Si la copia contiene cualquier texto que no sea ISO-8859-1 puede CORROMPERSE si intenta restaurarla a esta versión Unicode de Moodle.
Si desea más información sobre cómo recuperar correctamente la copia, puede consultar <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>';
$string['backupnotyetrun'] = 'Copia de seguridad automática pendiente';
$string['backuporiginalname'] = 'Nombre de la copia de seguridad';
$string['backuproleassignments'] = 'Copia de seguridad de las asignaciones de rol de estos roles';
$string['backupsavetohelp'] = 'Ruta completa del directorio en el que desea que se guarden las copias de seguridad<br />(dejarlo en blanco para guardarlas en el directorio por defecto de cada curso)';
$string['backupsitefileshelp'] = 'Si se activa esta opción, los archivos del sitio usados en los cursos se incluirán en copias de seguridad automatizadas';
$string['backuptakealook'] = 'Por favor, examine los registros de su copia de seguridad en: {$a}';
$string['backupuserfileshelp'] = 'Seleccione si desea incluir los archivos personales de los usuarios (e.g., imágenes) en la copia de seguridad';
$string['backupversion'] = 'Versión de la copia de seguridad';
$string['badges'] = 'Insignias';
$string['block'] = 'Bloque';
$string['blockconfiga'] = 'Configurando un bloque {$a}';
$string['blockconfigbad'] = 'Este bloque no se ha implementado correctamente y por consiguiente no se puede proporcionar una interfaz de configuración.';
$string['blocks'] = 'Bloques';
$string['blocksaddedit'] = 'Añadir/Editar bloques';
$string['blockseditoff'] = 'Desactivar la edición de bloques';
$string['blocksediton'] = 'Activar la edición de bloques';
$string['blocksetup'] = 'Configurando tablas de bloque';
$string['blocksuccess'] = 'Las tablas de {$a} han sido instaladas correctamente';
$string['brief'] = 'Resumen';
$string['bulkactions'] = 'Acciones masivas';
$string['bulkactionselect'] = '{$a} selección acción masiva';
$string['bulkmovecoursessuccess'] = 'Movidos con éxito {$a->courses} cursos a {$a->category}';
$string['bycourseorder'] = 'Por orden de curso';
$string['byname'] = 'por {$a}';
$string['bypassed'] = 'Evitado';
$string['cachecontrols'] = 'Controles de caché';
$string['cancel'] = 'Cancelar';
$string['cancelled'] = 'Cancelado';
$string['categories'] = 'Categorías';
$string['categoriesandcoures'] = 'Categorías de cursos y cursos';
$string['category'] = 'Categoría';
$string['categoryadded'] = 'Se instaló la categoría \'{$a}\'';
$string['categorybulkaction'] = 'Acciones masivas sobre las categorías seleccionadas';
$string['categorycontents'] = 'Subcategorías y cursos';
$string['categorycurrentcontents'] = 'Contenido de {$a}';
$string['categorydeleted'] = 'Se ha borrado la categoría \'{$a}\'';
$string['categoryduplicate'] = 'Ya existe una categoría llamada \'{$a}\'.';
$string['categorymodifiedcancel'] = 'La categoría se ha modificado. Por favor, cancele y pruebe de nuevo.';
$string['categoryname'] = 'Nombre de la categoría';
$string['categorysubcategoryof'] = '{$a->category} - subcategory de {$a->parentcategory}';
$string['categoryupdated'] = 'La categoría \'{$a}\' ha sido actualizada';
$string['changedpassword'] = 'Contraseña actualizada';
$string['changepassword'] = 'Cambiar contraseña';
$string['changesmadereallygoaway'] = 'Ha realizado cambios. ¿Seguro que quiere salir y perder los cambios?';
$string['changessaved'] = 'Cambios actualizados';
$string['check'] = 'Revisar';
$string['checkall'] = 'Comprobar todo';
$string['checkingbackup'] = 'Revisando la copia de seguridad';
$string['checkingcourse'] = 'Revisando el curso';
$string['checkingforbbexport'] = 'Comprobando exportación a Blackboard';
$string['checkinginstances'] = 'Revisando casos';
$string['checkingsections'] = 'Revisando secciones';
$string['checklanguage'] = 'Revisar el idioma';
$string['checknone'] = 'No comprobar nada';
$string['childcoursenotfound'] = '¡Curso secundario no encontrado!';
$string['childcourses'] = 'Cursos hijo';
$string['choose'] = 'Elegir';
$string['choosecourse'] = 'Seleccione un curso';
$string['choosedots'] = 'Elegir...';
$string['chooselivelogs'] = 'o vea la actividad actual';
$string['chooselogs'] = 'Seleccione los registros que desea ver';
$string['choosereportfilter'] = 'Elegir un filtro para el informe';
$string['choosetheme'] = 'Elegir tema gráfico';
$string['chooseuser'] = 'Seleccionar un usuario';
$string['city'] = 'Ciudad';
$string['clambroken'] = 'Su administrador ha habilitado el chequeo de virus para archivos subidos, pero algo está mal configurado.<br />La subida de archivos NO ha sido posible. Se ha enviado un email a su administrador para que corrija el problema.<br />Intente subir el archivo más tarde.';
$string['clamdeletedfile'] = 'El archivo ha sido eliminado';
$string['clamdeletedfilefailed'] = 'El archivo no ha podido eliminarse';
$string['clamemailsubject'] = '{$a} :: Notificación Clam AV';
$string['clamfailed'] = 'Clam AV no se ha ejecutado. El mensaje de error de retorno es {$a}. Éste es el output de Clam:';
$string['clamlost'] = 'Moodle está configurado para ejecutar Clam al cargar un archivo, pero la ruta para Clam AV, {$a}, no es válida.';
$string['clamlostandactinglikevirus'] = 'Además, Moodle está configurado de modo que si Clam no funciona, los archivos son tratados como si fueran virus. Esto, en esencia, significa que ningún estudiante puede subir archivos hasta que el problema se solucione.';
$string['clammovedfile'] = 'El archivo ha sido movido al directorio de cuarentena que usted ha especificado, y su nueva ubicación es {$a}';
$string['clammovedfilebasic'] = 'El archivo ha sido trasladado al directorio de cuarentena.';
$string['clamquarantinedirfailed'] = 'No se ha podido trasladar el archivo al directorio de cuarentena {$a} que usted ha especificado. Necesita corregir esto puesto que los archivos deben eliminarse si están infectados.';
$string['clamunknownerror'] = 'Se ha producido un error desconocido con Clam.';
$string['cleaningtempdata'] = 'Borrando archivos temporales';
$string['clear'] = 'Limpiar';
$string['clickhelpiconformoreinfo'] = '...continúa... Haga clic en el icono de ayuda para leer el artículo completo';
$string['clickhere'] = 'Clic aquí...';
$string['clicktochangeinbrackets'] = '{$a} (Clic para cambiar)';
$string['clicktohideshow'] = 'Clic para expandir o colapsar';
$string['closebuttontitle'] = 'Cerrar';
$string['closewindow'] = 'Cerrar esta ventana';
$string['collapse'] = 'Colapsar';
$string['collapseall'] = 'Colapsar todo';
$string['collapsecategory'] = 'Colapsar {$a}';
$string['commentincontext'] = 'Encontrar este comentario en el contexto';
$string['comments'] = 'Comentarios';
$string['commentscount'] = 'Comentarios ({$a})';
$string['commentsnotenabled'] = 'La característica de Comentarios no está habilitada';
$string['commentsrequirelogin'] = 'Necesita identificarse para ver los comentarios.';
$string['comparelanguage'] = 'Comparar y editar el presente idioma';
$string['complete'] = 'Completado';
$string['completereport'] = 'Informe completo';
$string['configuration'] = 'Configuración';
$string['confirm'] = 'Confirmar';
$string['confirmcheckfull'] = '¿Está totalmente seguro que quiere confirmar {$a}?';
$string['confirmcoursemove'] = '¿Está seguro de que desea mover este curso ({$a->course}) a esta categoría ({$a->category})?';
$string['confirmed'] = 'Registro confirmado';
$string['confirmednot'] = 'Su registro no se ha confirmado aún.';
$string['content'] = 'Contenido';
$string['continue'] = 'Continuar';
$string['continuetocourse'] = 'Haga clic aquí para entrar a su curso';
$string['convertingwikitomarkdown'] = 'Convirtiendo Wiki a Markdown';
$string['cookiesenabled'] = 'Las \'Cookies\' deben estar habilitadas en su navegador';
$string['cookiesenabled_help'] = '<p>Este sitio utiliza dos "cookies".</p>

<p>La esencial es la de sesión, normalmente llamada <b>MoodleSession</b>.
Debe permitir que su navegador la acepte para poder mantener el servicio
funcionando de una página a otra. Cuando sale de la plataforma o cierra su navegador la \'cookie\' se destruye (en su navegador y en el servidor).</p>

<p>La otra \'cookie\', normalmente llamada <b>MOODLEID</b>, es para su comodidad. Se limita a recordar su nombre de usuario dentro del navegador. Esto significa que cuando
regrese al sitio se escribirá automáticamente su nombre en el campo nombre de usuario
(userid). Si desea mayor seguridad no utilice esta opción: sólo tendrá que escribir su nombre manualmente cada vez que quiera ingresar.</p>';
$string['cookiesnotenabled'] = 'Las \'cookies\' no están habilitadas en su navegador';
$string['copy'] = 'copia';
$string['copyasnoun'] = 'copia';
$string['copyingcoursefiles'] = 'Copiando los archivos del curso';
$string['copyingsitefiles'] = 'Copiando los archivos del sitio usados en el curso';
$string['copyinguserfiles'] = 'Copiando los archivos de los usuarios';
$string['copyingzipfile'] = 'Copiando archivo zip';
$string['copyrightnotice'] = 'Copyright';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Coste';
$string['costdefault'] = 'Costo por defecto';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'País';
$string['course'] = 'Curso';
$string['courseadministration'] = 'Administración del curso';
$string['courseapprovedemail'] = 'El curso que ha solicitado, {$a->name}, y usted ha sido nombrado {$a->teacher}. Para acceder a su nuevo curso, vaya a {$a->url}';
$string['courseapprovedemail2'] = 'El curso que ha solicitado, {$a->name}, ha sido aprobado. Para acceder a él, gaya a {$a->url}';
$string['courseapprovedfailed'] = '¡No se ha podido guardar su curso como aprobado!';
$string['courseapprovedsubject'] = '¡Su curso ha sido aprobado!';
$string['courseavailable'] = 'Este curso está disponible para los estudiantes';
$string['courseavailablenot'] = 'Este curso no está disponible para los estudiantes';
$string['coursebackup'] = 'Copia de seguridad del curso';
$string['coursebulkaction'] = 'Acciones masivas sobre los cursos seleccionados';
$string['coursecategories'] = 'Categorías de cursos';
$string['coursecategory'] = 'Categoría de cursos';
$string['coursecategorydeleted'] = 'Eliminada la categoría de curso {$a}';
$string['coursecategory_help'] = 'Este ajuste determina la categoría en la que aparecerá el curso en la lista de cursos.';
$string['coursecatmanagement'] = 'Gestión de cursos y categorías';
$string['coursecompletion'] = 'Finalización del curso';
$string['coursecompletions'] = 'Finalizaciones del curso';
$string['coursecreators'] = 'Creador de curso';
$string['coursecreatorsdescription'] = 'Los creadores de cursos pueden crear nuevos cursos.';
$string['coursedeleted'] = 'Eliminado el curso {$a}';
$string['coursedisplay'] = 'Paginación del curso';
$string['coursedisplay_help'] = 'Este parámetro determina si el curso completo se muestra en una página o se desglosa en varias páginas.';
$string['coursedisplay_multi'] = 'Mostrar una sección por página';
$string['coursedisplay_single'] = 'Mostrar todas las secciones en una página';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Archivos heredados del curso';
$string['coursefilesedit'] = 'Editar archivos heredados del curso';
$string['coursefileswarning'] = 'Los archivos del curso están en desuso';
$string['coursefileswarning_help'] = 'Los archivos del curso están en desuso desde Moodle 2.0; por favor, utilice repositorios externos en su lugar cuanto le sea posible.';
$string['courseformatdata'] = 'Datos de formato del curso';
$string['courseformatoptions'] = 'Opciones de formato para {$a}';
$string['courseformats'] = 'Formatos de curso';
$string['courseformatudpate'] = 'Actualización de formato';
$string['coursegrades'] = 'Calificaciones del curso';
$string['coursehelpcategory'] = 'Coloque el curso en el listado de cursos a fin de facilitar el acceso a los estudiantes.';
$string['coursehelpforce'] = 'Forzar el modo de grupo en el curso para todas las actividades del curso.';
$string['coursehelpformat'] = 'La portada del curso se mostrará en este formato.';
$string['coursehelphiddensections'] = 'Cómo se mostrarán a los estudiantes las secciones ocultas del curso.';
$string['coursehelpmaximumupload'] = 'Definir el tamaño máximo de los archivos que los estudiantes pueden subir a este curso, limitado por el ajuste general del sitio.';
$string['coursehelpnewsitemsnumber'] = 'Número de ítems recientes de foro de Novedades que aparecen en el bloque de Últimas noticias en la página del curso.  Si se indica cero, el bloque no aparecerá.';
$string['coursehelpnumberweeks'] = 'Número de secciones en el curso (aplicable solo a ciertos formatos de curso).';
$string['coursehelpshowgrades'] = 'Activa la presentación del libro de calificaciones. No impide que las calificaciones se muestren dentro de las actividades individuales.';
$string['coursehidden'] = 'Este curso no es accesible de momento a los estudiantes';
$string['courseinfo'] = 'Información del curso';
$string['courselegacyfiles'] = 'Archivos de curso heredados';
$string['courselegacyfiles_help'] = 'El área de archivos del curso proporciona cierta compatibilidad hacia atrás con las versiones de Moodle 1.9 y anteriores. Todos los archivos de este área son siempre accesibles a todos los participantes en el curso (tanto si enlaza a ellos como si no) y no hay manera de saber dónde se pueden estar usando en Moodle cualquiera de estos archivos.

Si utiliza este área para almacenar archivos de curso, puede exponerse a una serie de riesgos de privacidad y de seguridad, así como a la pérdida de archivos en las copias de seguridad, en las importaciones de cursos o cada vez que el contenido del curso sea compartido o reutilizado. Por ello se recomienda que no utilice esta área a menos que realmente sepa lo que está haciendo.';
$string['courselegacyfilesofcourse'] = 'Archivos del curso heredados: {$a}';
$string['coursemessage'] = 'Mensaje a usuarios de curso';
$string['coursenotaccessible'] = 'Este curso no permite acceso público';
$string['courseoverview'] = 'Vista general del curso';
$string['courseoverviewfiles'] = 'Archivos del resumen del curso';
$string['courseoverviewfilesext'] = 'Extensiones de los archivos de resumen del curso';
$string['courseoverviewfiles_help'] = 'Los archivos del resumen del curso (por lo general imágenes) se muestran en la lista de cursos, junto con el resumen.';
$string['courseoverviewfileslimit'] = 'Límite de archivos en el resumen del curso';
$string['courseoverviewgraph'] = 'Gráfico global del curso';
$string['courseprofiles'] = 'Perfiles de curso';
$string['coursereasonforrejecting'] = 'Razones para rechazar esta solicitud';
$string['coursereasonforrejectingemail'] = 'Esto se enviará al solicitante';
$string['coursereject'] = 'Rechazar solicitud de curso';
$string['courserejected'] = 'El curso ha sido rechazado y así se ha notificado al solicitante.';
$string['courserejectemail'] = 'Lo sentimos, el curso solicitado ha sido rechazado por la siguiente razón:

{$a}';
$string['courserejectreason'] = 'Escriba sus razones para rechazar este curso<br />(serán enviadas al solicitante)';
$string['courserejectsubject'] = 'Su curso ha sido rechazado';
$string['coursereport'] = 'Informe de curso';
$string['coursereports'] = 'Informes del curso';
$string['courserequest'] = 'Solicitud de curso';
$string['courserequestdetails'] = 'Detalles del curso que solicita';
$string['courserequestfailed'] = 'Por alguna razón desconocida, su solicitud de curso no ha podido guardarse';
$string['courserequestintro'] = 'Utilice este formulario para solcitar la creación de un curso.<br />Suministre toda la información posible para facilitar<br />a los administradores la comprensión de las razones por las que solicita el curso.';
$string['courserequestreason'] = 'Razones para solicitar el curso';
$string['courserequestsuccess'] = 'Su solicitud de curso se ha guardado con éxito. Dentro de unos días se le notificará el resultado por correo electrónico.';
$string['courserequestsupport'] = 'Información de apoyo para ayudar al administrador a evaluar esta solicitud';
$string['courserestore'] = 'Restaurar curso';
$string['courses'] = 'Cursos';
$string['coursesectionsummaries'] = 'Resúmenes de sección del curso';
$string['coursesectiontitle'] = 'Curso: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'Ajustes por defecto del curso';
$string['coursesmovedout'] = 'Cursos apartados de {$a}';
$string['coursespending'] = 'Cursos pendientes de aprobación';
$string['coursestart'] = 'Comienzo del curso';
$string['coursesummary'] = 'Resumen del curso';
$string['coursesummary_help'] = 'El resumen del curso se muestra en la lista de cursos. Una búsqueda de cursos busca el texto del resumen del curso además de los nombres de curso.';
$string['coursetitle'] = 'Curso: {$a->course}';
$string['courseupdates'] = 'Actualizaciones de cursos';
$string['create'] = 'Crear';
$string['createaccount'] = 'Crear cuenta';
$string['createcategory'] = 'Crear categoría';
$string['createfolder'] = 'Crear un directorio en {$a}';
$string['createnew'] = 'Crear nuevo';
$string['createnewcategory'] = 'Crear nueva categoría';
$string['createnewcourse'] = 'Crear nuevo curso';
$string['createnewsubcategory'] = 'Crear nueva subcategoría';
$string['createsubcategoryof'] = 'Crear subcategoría de {$a}';
$string['createuser'] = 'Crear usuario';
$string['createuserandpass'] = 'Crear un nuevo usuario y contraseña para acceder al sistema';
$string['createziparchive'] = 'Crear archivo zip';
$string['creatingblocks'] = 'Creando bloques';
$string['creatingblocksroles'] = 'Creando asignaciones y anulaciones de rol en nivel de bloque';
$string['creatingblogsinfo'] = 'Creando información de blogs';
$string['creatingcategoriesandquestions'] = 'Creando categorías y preguntas';
$string['creatingcoursemodules'] = 'Creando módulos de curso';
$string['creatingcourseroles'] = 'Creando asignaciones y anulaciones de rol en nivel de curso';
$string['creatingevents'] = 'Creando eventos';
$string['creatinggradebook'] = 'Creando libro de calificaciones';
$string['creatinggroupings'] = 'Creando agrupamientos';
$string['creatinggroupingsgroups'] = 'Agregando grupos a agrupamientos';
$string['creatinggroups'] = 'Creando grupos';
$string['creatinglogentries'] = 'Creando entradas de registro';
$string['creatingmessagesinfo'] = 'Creando información sobre mensajes';
$string['creatingmodroles'] = 'Creando asignaciones y anulaciones de rol en nivel de módulo';
$string['creatingnewcourse'] = 'Creando nuevo curso';
$string['creatingrolesdefinitions'] = 'Creando definiciones de roles';
$string['creatingscales'] = 'Creando escalas';
$string['creatingsections'] = 'Creando secciones';
$string['creatingtemporarystructures'] = 'Creando estructuras temporales';
$string['creatinguserroles'] = 'Creando asignaciones y anulaciones de rol en nivel de usuario';
$string['creatingusers'] = 'Creando usuarios';
$string['creatingxmlfile'] = 'Creando el archivo XML';
$string['currency'] = 'Moneda';
$string['currentcourse'] = 'Curso actual';
$string['currentcourseadding'] = 'Curso actual, agregando información';
$string['currentcoursedeleting'] = 'Curso actual, borrando primero';
$string['currentlanguage'] = 'Idioma actual';
$string['currentlocaltime'] = 'su hora local';
$string['currentlyselectedusers'] = 'Usuarios seleccionados';
$string['currentpicture'] = 'Imagen actual';
$string['currentrelease'] = 'Información de la versión';
$string['currentversion'] = 'Versión';
$string['databasechecking'] = 'Actualizando la base de datos de Moodle desde la versión {$a->oldversion} a {$a->newversion}';
$string['databaseperformance'] = 'Rendimiento de la base de datos';
$string['databasesetup'] = 'Configurando la base de datos';
$string['databasesuccess'] = 'La base de datos se ha actualizado satisfactoriamente';
$string['databaseupgradebackups'] = 'La versión de la copia de seguridad es {$a}';
$string['databaseupgradeblocks'] = 'La versión de los bloques es {$a}';
$string['databaseupgradegroups'] = 'La versión de los grupos es {$a}';
$string['databaseupgradelocal'] = 'La versión de personalización de la base de datos local es ahora {$a}';
$string['databaseupgrades'] = 'Actualizando la base de datos';
$string['date'] = 'Fecha';
$string['datechanged'] = 'Fecha cambiada';
$string['datemostrecentfirst'] = 'Fecha - primero el más reciente';
$string['datemostrecentlast'] = 'Fecha - último el más reciente';
$string['day'] = 'día';
$string['days'] = 'días';
$string['decodinginternallinks'] = 'Decodificando enlaces internos';
$string['default'] = 'Por defecto';
$string['defaultcoursestudent'] = 'Estudiante';
$string['defaultcoursestudentdescription'] = 'Los estudiantes tienen por lo general menos privilegios dentro de un curso.';
$string['defaultcoursestudents'] = 'Estudiantes';
$string['defaultcoursesummary'] = 'Escriba aquí la descripción del curso';
$string['defaultcourseteacher'] = 'Profesor';
$string['defaultcourseteacherdescription'] = 'Los profesores pueden realizar cualquier acción dentro de un curso, incluyendo cambiar actividades y calificar a los estudiantes.';
$string['defaultcourseteachers'] = 'Profesores';
$string['defaulteditor'] = 'Editor por defecto';
$string['delete'] = 'Borrar';
$string['deleteablock'] = 'Eliminar un bloque';
$string['deleteall'] = 'Borrar todo';
$string['deleteallcannotundo'] = 'Eliminar todo (no se puede deshacer)';
$string['deleteallcomments'] = 'Eliminar todos los comentarios';
$string['deleteallratings'] = 'Eliminar todas las calificaciones';
$string['deletecategory'] = 'Eliminar categoría: {$a}';
$string['deletecategorycheck'] = '¿Está totalmente seguro que quiere eliminar por completo la categoría <b>\'{$a}\'</b>?<br /> Esta acción trasladará todos los cursos a la categoría padre (si existe) o a Miscelánea.';
$string['deletecategorycheck2'] = 'Si elimina esta categoría, necesita decidir qué hacer con los cursos y subcategorías que contiene.';
$string['deletecategoryempty'] = 'Esta categoría está vacía';
$string['deletecheck'] = '¿ Borrar {$a} ?';
$string['deletecheckfiles'] = '¿Está totalmente seguro que quiere borrar estos archivos?';
$string['deletecheckfull'] = '¿Está totalmente seguro que quiere borrar definitivamente al usuario {$a}, incluyendo sus matriculaciones, actividades y resto de datos?';
$string['deletechecktype'] = '¿Está seguro que quiere borrar esto {$a->type}?';
$string['deletechecktypename'] = '¿Está seguro que quiere borrar el/la {$a->type}  "{$a->name}"?';
$string['deletecheckwarning'] = 'Está a punto de borrar estos archivos';
$string['deletecomment'] = 'Eliminar este comentario';
$string['deletecompletely'] = 'Borrado';
$string['deletecourse'] = 'Borrar curso';
$string['deletecoursecheck'] = '¿Está totalmente seguro que quiere borrar definitivamente este curso y toda la información que contiene?';
$string['deleted'] = 'Borrado';
$string['deletedactivity'] = 'Se ha borrado {$a}';
$string['deletedcourse'] = '{$a} se ha borrado satisfactoriamente';
$string['deletednot'] = '¡No se puede borrar {$a}!';
$string['deleteselected'] = 'Borrar seleccionado';
$string['deleteselectedkey'] = 'Eliminar clave seleccionada';
$string['deletingcourse'] = 'Borrando {$a}';
$string['deletingexistingcoursedata'] = 'Borrando datos del curso';
$string['deletingolddata'] = 'Borrando datos antiguos';
$string['department'] = 'Departamento';
$string['desc'] = 'Descendente';
$string['description'] = 'Descripción';
$string['deselectall'] = 'No seleccionar ninguno';
$string['detailedless'] = 'Menos detalle';
$string['detailedmore'] = 'Más detalle';
$string['directory'] = 'Directorio';
$string['disable'] = 'Deshabilitar';
$string['disabledcomments'] = 'Los comandos están desactivados';
$string['displayingfirst'] = 'Mostrando las primeras {$a->count} {$a->things}';
$string['displayingrecords'] = 'Mostrando {$a} registros';
$string['displayingusers'] = 'Mostrando los usuarios {$a->start} a {$a->end}';
$string['displayonpage'] = 'Mostrar en página';
$string['dndcourse'] = 'Puede arrastrar y soltar este curso para alterar su clasificación o moverlo a otra categoría.';
$string['dndenabled_inbox'] = 'Puede arrastrar y soltar archivos aquí para añadirlos';
$string['dndnotsupported'] = 'La subida mediante \'drag and drop\' no está soportada';
$string['dndnotsupported_help'] = 'Su navegador no soporta la subida mediante \'drag and drop\'.<br /> Esta funcionalidad está disponible en todas las versiones recientes de Chrome, Firefox y Safari, así como en Internet Explorer versión 10 y superiores.';
$string['dndnotsupported_insentence'] = '\'drag and drop\' no soportado';
$string['dnduploadwithoutcontent'] = 'Esta carga de ficheros no tiene ningún contenido.';
$string['dndworkingfile'] = 'Para subir archivos, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingfilelink'] = 'Para subir archivos o enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingfiletext'] = 'Para subir archivos o texto, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingfiletextlink'] = 'Para subir archivos, textos o enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkinglink'] = 'Para subir enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingtext'] = 'Para subir textos, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingtextlink'] = 'Para subir  textos o enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['documentation'] = 'Documentación de Moodle';
$string['dontsortcategories'] = 'No ordenar categorías';
$string['dontsortcourses'] = 'No ordenar cursos';
$string['down'] = 'Abajo';
$string['download'] = 'Descargar';
$string['downloadall'] = 'Descargar todo';
$string['downloadexcel'] = 'Descargar en formato Excel';
$string['downloadfile'] = 'Descargar archivo';
$string['downloadods'] = 'Descargar en formato ODS';
$string['downloadtext'] = 'Descargar en formato de texto';
$string['doyouagree'] = '¿Ha leído y comprendido los términos y condiciones?';
$string['droptoupload'] = 'Suelte los archivos a subir aquí';
$string['duplicate'] = 'Duplicar';
$string['edhelpaspellpath'] = 'Para usar un revisor de ortografía dentro del editor, usted DEBE tener instalado <strong>aspell 0.50</strong> o superior en su servidor, y debe especificar la ruta correcta de acceso al aspell binario. En sistemas Unix/Linux, esta ruta normalmente es <strong>/usr/bin/aspell</strong>, pero podría ser cualquiera otra.';
$string['edhelpbgcolor'] = 'Defina el color de fondo del área de edición.<br />Valores válidos son, por ejemplo: #ffffff o \'white\'';
$string['edhelpcleanword'] = 'Este ajuste activa o desactiva el filtro de formato específico Word.';
$string['edhelpenablespelling'] = 'Activa o desactiva la corrección ortográfica. Cuando está activado, <strong>aspell</strong> debe estar instalado en el servidor.';
$string['edhelpfontfamily'] = 'La propiedad familia de fuentes es una lista de nombres de fuentes y/o nombres de una familia genérica. Los nombres de la familia deben estar separados por comas.';
$string['edhelpfontlist'] = 'Defina las fuentes usadas en el menú emergente de editores.';
$string['edhelpfontsize'] = 'El tamaño por defecto de la fuente ajusta dicho tamaño. <br />Valores válidos son, por ejemplo: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Editar';
$string['edita'] = 'Editar {$a}';
$string['editcategorysettings'] = 'Editar ajustes de categoría';
$string['editcategorythis'] = 'Editar esta categoría';
$string['editcoursesettings'] = 'Editar la configuración del curso';
$string['editfiles'] = 'Editar archivos';
$string['editgroupprofile'] = 'Editar el perfil del grupo';
$string['editinga'] = 'Editando {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Este valor no puede editarse.';
$string['editmyprofile'] = 'Editar perfil';
$string['editorbgcolor'] = 'Color de fondo';
$string['editorcleanonpaste'] = 'Limpiar HTML de Word al pegar';
$string['editorcommonsettings'] = 'Ajustes comunes';
$string['editordefaultfont'] = 'Fuente por defecto';
$string['editorenablespelling'] = 'Activar corrección ortográfica';
$string['editorfontlist'] = 'Lista de fuentes';
$string['editorfontsize'] = 'Tamaño de la fuente por defecto';
$string['editorresettodefaults'] = 'Volver a valores por defecto';
$string['editorsettings'] = 'Ajustes del editor';
$string['editorshortcutkeys'] = 'Atajos del editor';
$string['editsettings'] = 'Editar ajustes';
$string['editsummary'] = 'Editar informe';
$string['editthisactivity'] = 'Editar esta actividad';
$string['editthiscategory'] = 'Editar esta categoría';
$string['edittitle'] = 'Editar título';
$string['edittitleinstructions'] = 'Esc para cancelar, Enter para finalizar';
$string['edituser'] = 'Editar usuario';
$string['edulevel'] = 'Nivel de formación';
$string['edulevelother'] = 'Otro';
$string['edulevelparticipating'] = 'Participando';
$string['edulevelteacher'] = 'Enseñando';
$string['email'] = 'Dirección de correo';
$string['emailactive'] = 'Correo activado';
$string['emailagain'] = 'Correo (de nuevo)';
$string['emailalreadysent'] = 'Se ha enviado un correo electrónico de restablecimiento de contraseña. Por favor, consulte su buzón de correo electrónico.';
$string['emailcharset'] = 'Conjunto de caracteres para email';
$string['emailconfirm'] = 'Confirme su cuenta';
$string['emailconfirmation'] = 'Hola, {$a->firstname}.

Se ha solicitado la apertura de una cuenta en
\'{$a->sitename}\' utilizando su dirección de correo.

Para completar el proceso de inscripción haga clic aquí:

{$a->link}

En la mayoría de programas de correo electrónico este
enlace debería aparecer en azul. Si no funciona, córtelo y
péguelo en la ventana de direcciones de su navegador.

Si necesita ayuda, contacte por favor con el administrador
del sitio,
{$a->admin}';
$string['emailconfirmationsubject'] = 'Confirmación de la cuenta  {$a}';
$string['emailconfirmsent'] = '<p>Hemos enviado un correo electrónico a <b>{$a}</b></p>
<p>En él encontrará instrucciones sencillas para concluir el proceso.</p>
<p>Si tuviera alguna dificultad, contacte con el Administrador del Sistema.</p>';
$string['emaildigest'] = 'Tipo de resumen de correo';
$string['emaildigestcomplete'] = 'Completo (correo diario con mensajes completos)';
$string['emaildigest_help'] = 'Este es el ajuste de resumen diario que usarán los foros por defecto.

* Sin resumen - recibirá un correo electrónico por cada mensaje del foro;
* Resumen - mensaje completo - recibirá un correo resumen por día con los contenidos completos de cada mensaje del foro;
* Resumen - solo asuntos - recibirá un correo resumen por día solo con los asuntos de cada mensaje del foro.

Puede elegir también un ajuste diferente para cada uno de los foros, si así lo desea.';
$string['emaildigestoff'] = 'Sin resumen (un correo por cada mensaje del foro)';
$string['emaildigestsubjects'] = 'Por temas (correo diario sólo con temas)';
$string['emaildisable'] = 'La dirección de correo no está habilitada';
$string['emaildisableclick'] = 'Haga clic aquí para desactivar el envío de correo a esta dirección';
$string['emaildisplay'] = 'Mostrar correo';
$string['emaildisplaycourse'] = 'Mostrar mi dirección de correo sólo a mis compañeros de curso';
$string['emaildisplayhidden'] = 'Email oculto';
$string['emaildisplayno'] = 'Ocultar a todos mi dirección de correo';
$string['emaildisplayyes'] = 'Mostrar a todos mi dirección de correo';
$string['emailenable'] = 'La dirección de correo está habilitada';
$string['emailenableclick'] = 'Haga clic aquí para volver a activar el envío de correo a esta dirección';
$string['emailexists'] = 'Esta dirección de correo ya está registrada.';
$string['emailformat'] = 'Formato de correo';
$string['emailmustbereal'] = 'IMPORTANTE: Para concluir el proceso debe escribir una dirección de correo verdadera';
$string['emailnotallowed'] = 'Las direcciones email de estos dominios no están permitidas ({$a})';
$string['emailnotfound'] = 'No se ha encontrado la dirección email en la base de datos';
$string['emailonlyallowed'] = 'Este email no figura entre los permitidos ({$a})';
$string['emailpasswordchangeinfo'] = 'Hola, {$a->firstname}.

Alguien (seguramente usted) ha solicitado una nueva contraseña para su
cuenta en \'{$a->sitename}\'.

Para cambiar su contraseña, por favor, diríjase a la siguiente dirección:

{$a->link}

En la mayoría de los programas de correo electrónico, esto aparecerá como un enlace en color azul en el que usted puede hacer clic. Si no funcionara, copie y pegue la dirección en la barra de navegación de su navegador.';
$string['emailpasswordchangeinfodisabled'] = 'Hola, {$a->firstname}.

Se ha solicitado una nueva contraseña para su cuenta en \'{$a->sitename}\'.

Desafortunadamente, su cuenta en este sitio ha sido desactivada y no puede ser reactivada. Por favor, contacte con el administrador del sitio, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hola, {$a->firstname}.

Alguien (seguramente usted) ha solicitado una nueva contraseña para su
cuenta en \'{$a->sitename}\'.

Lo sentimos, pero las contraseñas no pueden cambiarse en este sitio. Contacte por favor con el administrador,
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Cambiar información sobre la contraseña';
$string['emailpasswordconfirmation'] = 'Hola, {$a->firstname}.

Recibimos la solicitud de nueva contraseña para su cuenta
en \'{$a->sitename}\'.

Para concluir el proceso y poder enviarle una nueva contraseña por correo,
diríjase a la siguiente dirección:

{$a->link}

En la mayoría de programas de correo electrónico el
enlace anterior debería aparecer en azul y puede hacer
clic sobre él. Si no funcionara, córtelo y péguelo en la
ventana de direcciones de su navegador.

Si necesita ayuda adicional, póngase en contacto con el
administrador, {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: confirmación de cambio de contraseña';
$string['emailpasswordconfirmmaybesent'] = '<p>Si ha suministrado un nombre de usuario o dirección correctos, se le debería haber enviado un email.</p>
<p>Contiene instrucciones sencillas para confirmar y completar el cambio de contraseña.
Si sigue teniendo dificultades, contacte por favor con el administrador del sitio.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> La cuenta de usuario que ha especificado no tiene una dirección de correo electrónico registrada. </p><p> Por favor, póngase en contacto con el administrador del sitio. </p>';
$string['emailpasswordconfirmnotsent'] = '<p> Los datos de usuario que ha introducido no identifican una cuenta de usuario existente. </p><p> Compruebe la información introducida por favor y vuelva a intentarlo. Si continúa teniendo problemas, por favor póngase en contacto con el administrador del sitio. </p>';
$string['emailpasswordconfirmsent'] = 'Hemos enviado un correo a su dirección <b>{$a}</b>.
<p>Este mensaje contiene instrucciones sencillas para completar y confirmar el cambio de contraseña.
Si tuviera alguna dificultad, contacte con el Administrador.</p>';
$string['emailpasswordsent'] = 'Gracias por confirmar el cambio de contraseña.
<p>Ya le enviamos un correo con su nueva contraseña a <b>{$a->email}</b>.</p>
<p>La nueva contraseña ha sido generada automáticamente.
Le recomendamos que <a href="{$a->link}">cambie su contraseña</a> por otra más fácil de recordar.</p>';
$string['emailresetconfirmation'] = 'Hola {$a->firstname}.

Usted solicitó un restablecimiento de contraseña para su cuenta \'{$a->username}\' en {$a->sitename}.

Para confirmar esta petición, y establecer una nueva contraseña para su cuenta, por favor vaya a la siguiente dirección de Internet: {$a->link} (Este enlace es válido durante  {$a->resetminutes} minutos desde el momento en que hizo la solicitud por primera vez .

Si usted no ha solicitado este restablecimiento de contraseña, no necesita realizar ninguna acción.

Si necesita ayuda, por favor póngase en contacto con el administrador del sitio, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Solicitud de restablecimiento de contraseña';
$string['emailresetconfirmsent'] = 'Se ha enviado un correo electrónico a su dirección en <b>{$a}.</b> <br /> Contiene unas sencillas instrucciones para confirmar y completar el cambio de contraseña.
Si continúa teniendo problemas, póngase en contacto con el administrador del sitio.';
$string['emailtoprivatefiles'] = 'También puede enviar directamente archivos vía e-mail a esta zona de archivos privados. Simplemente adjunte sus archivos a un correo electrónico y envíelo a la dirección de correo electrónico {$a}';
$string['emailtoprivatefilesdenied'] = 'El administrador ha desactivado la opción de subir sus propios ficheros privados.';
$string['emptydragdropregion'] = 'región vacía';
$string['enable'] = 'Habilitar';
$string['encryptedcode'] = 'Código encriptado';
$string['english'] = 'Inglés';
$string['enrolmentmethods'] = 'Métodos de matriculación';
$string['entercourse'] = 'Haga clic aquí para entrar al curso';
$string['enteremail'] = 'Haga clic para entrar en este curso';
$string['enteremailaddress'] = 'Escriba su dirección de correo electrónico.
Le enviaremos una nueva contraseña.';
$string['enterusername'] = 'Escriba su nombre de usuario';
$string['entries'] = 'Entradas';
$string['error'] = 'Error';
$string['errorcreatingactivity'] = 'No se puede crear una instancia de la actividad \'{$a}\'';
$string['errorfiletoobig'] = 'El archivo era más grande que el límite de {$a} bytes';
$string['errornouploadrepo'] = 'No existe un repositorio de carga habilitados para este sitio';
$string['errorwhenconfirming'] = 'Ha ocurrido un error, por lo que usted aún no ha sido confirmado. Si llegó aquí a través de un enlace en su correo electrónico, asegúrese de que esa línea  en su correo no esté rota o cortada. De ser así, tendrá que utilizar copiar y pegar para reconstruir adecuadamente el enlace.';
$string['eventcommentcreated'] = 'Comentario creado';
$string['eventcommentdeleted'] = 'Comentario eliminado';
$string['eventcommentsviewed'] = 'Comentarios vistos';
$string['eventcontentviewed'] = 'Contenido visto';
$string['eventcoursecategorycreated'] = 'Categoría creada';
$string['eventcoursecategorydeleted'] = 'Categoría eliminada';
$string['eventcoursecategoryupdated'] = 'Categoría actualizada';
$string['eventcoursecontentdeleted'] = 'Contenido del curso eliminado';
$string['eventcoursecreated'] = 'Curso creado';
$string['eventcoursedeleted'] = 'Curso eliminado';
$string['eventcoursemodulecreated'] = 'Módulo de curso creado';
$string['eventcoursemoduledeleted'] = 'Módulo de curso eliminado';
$string['eventcoursemoduleinstancelistviewed'] = 'Instancia del módulo del curso visualizada';
$string['eventcoursemoduleupdated'] = 'Módulo de curso actualizado';
$string['eventcoursemoduleviewed'] = 'Módulo de curso visto';
$string['eventcourseresetended'] = 'Reinicio de curso finalizado';
$string['eventcourseresetstarted'] = 'Reinicio de curso iniciado';
$string['eventcourserestored'] = 'Curso restaurado';
$string['eventcoursesectionupdated'] = 'Sección de curso actualizado';
$string['eventcourseupdated'] = 'Curso actualizado';
$string['eventcourseuserreportviewed'] = 'Informe usuario del curso visto';
$string['eventcourseviewed'] = 'Curso visto';
$string['eventemailfailed'] = '';
$string['eventname'] = 'Nombre evento';
$string['eventrecentactivityviewed'] = 'Actividad reciente vista';
$string['eventunknownlogged'] = 'Evento desconocido';
$string['eventusercreated'] = 'Usuario creado';
$string['eventuserdeleted'] = 'Usuario eliminado';
$string['eventuserlistviewed'] = 'Lista de usuarios vista';
$string['eventuserloggedout'] = 'Usuario desconectado';
$string['eventuserpasswordupdated'] = 'Contraseña usuario acutalizada';
$string['eventuserprofileviewed'] = 'Perfil de usuario visto';
$string['eventuserupdated'] = 'Usuario actualizado';
$string['everybody'] = 'Todos';
$string['executeat'] = 'Ejecutar a las';
$string['existing'] = 'Existente';
$string['existingadmins'] = 'Administradores existentes';
$string['existingcourse'] = 'Curso existente';
$string['existingcourseadding'] = 'Curso existente, agregando información';
$string['existingcoursedeleting'] = 'Curso existente, borrando primero';
$string['existingcreators'] = 'Creadores existentes';
$string['existingstudents'] = 'Estudiantes inscritos';
$string['existingteachers'] = 'Profesores existentes';
$string['expand'] = 'Expandir';
$string['expandall'] = 'Expandir todo';
$string['expandcategory'] = 'Expandir {$a}';
$string['explanation'] = 'Explicación';
$string['extendenrol'] = 'Ampliar matriculación (individual)';
$string['extendperiod'] = 'Período de ampliación';
$string['failedloginattempts'] = '{$a->attempts} intentos de identificación fallidos desde su último acceso';
$string['feedback'] = 'Retroalimentación';
$string['file'] = 'Archivo';
$string['fileexists'] = 'Ya existe un archivo llamado {$a}';
$string['filemissing'] = 'No se encuentra {$a}';
$string['files'] = 'Archivos';
$string['filesanduploads'] = 'Archivos y subida';
$string['filesfolders'] = 'Archivos/directorios';
$string['filetoolarge'] = 'es demasiado grande para cargar';
$string['fileuploadwithcontent'] = 'La carga de archivos no debe incluir el parámetro contenido';
$string['filloutallfields'] = 'Por favor rellene todos los campos de este formulario';
$string['filter'] = 'Filtro';
$string['findmorecourses'] = 'Encontrar más cursos...';
$string['first'] = 'Primero';
$string['firstaccess'] = 'Primer acceso';
$string['firstname'] = 'Nombre';
$string['firstnamephonetic'] = 'Nombre - fonético';
$string['firstsiteaccess'] = 'Primer acceso al sitio';
$string['firsttime'] = 'Registrarse como usuario';
$string['folder'] = 'Carpeta';
$string['folderclosed'] = 'Carpeta cerrada';
$string['folderopened'] = 'Carpeta abierta';
$string['followingoptional'] = 'Los siguientes datos son opcionales';
$string['followingrequired'] = 'Los siguientes datos son indispensables';
$string['for'] = 'Para';
$string['force'] = 'Forzar';
$string['forcelanguage'] = 'Forzar idioma';
$string['forceno'] = 'No forzar';
$string['forcepasswordchange'] = 'Forzar cambio de contraseña';
$string['forcepasswordchangecheckfull'] = '¿Está totalmente seguro que quiere forzar un cambio de contraseña a {$a} ?';
$string['forcepasswordchange_help'] = 'Avisar al usuario de que lo cambie en su próximo acceso.';
$string['forcepasswordchangenot'] = 'No se pudo forzar el cambio de contraseña a {$a}';
$string['forcepasswordchangenotice'] = 'Para continuar, deberá cambiar su contraseña.';
$string['forcetheme'] = 'Forzar tema';
$string['forgotaccount'] = '¿Ha extraviado la contraseña?';
$string['forgotten'] = '¿Olvidó su nombre de usuario o contraseña?';
$string['forgottenduplicate'] = 'La dirección email es compartida por varias cuentas: por favor, utilice el nombre de usuario en su lugar.';
$string['forgotteninvalidurl'] = 'Contraseña no válida, reiniciar URL';
$string['format'] = 'Formato';
$string['format_help'] = 'El formato del curso determina el diseño de la página del curso.

* Formato de actividad única  - Visualiza una única actividad o recurso (como un Cuestionario o un paquete SCORM)

* Formato Social - Se muestra un foro en la página del curso

* Formato de Temas - La página del curso se organiza en secciones temáticas

* Formato semanal - la página del curso está organizado en secciones semanales, con la primera semana a partir de la fecha de inicio del curso';
$string['formathtml'] = 'Formato HTML';
$string['formatmarkdown'] = 'Formado Markdown';
$string['formatplain'] = 'Formato de texto plano';
$string['formattext'] = 'Formato automático';
$string['formattexttype'] = 'Formato';
$string['framesetinfo'] = 'Este documento contiene:';
$string['from'] = 'Desde';
$string['frontpagecategorycombo'] = 'Lista combo';
$string['frontpagecategorynames'] = 'Mostrar la lista de categorías';
$string['frontpagecourselist'] = 'Mostrar la lista de cursos';
$string['frontpagecoursesearch'] = 'Caja de texto de búsqueda en el curso';
$string['frontpagedescription'] = 'Descripción de la página principal';
$string['frontpagedescriptionhelp'] = 'Este resumen puede mostrarse en la página principal utilizando el bloque Resumen del curso/sitio.';
$string['frontpageenrolledcourselist'] = 'Cursos inscritos';
$string['frontpageformat'] = 'Formato de la página principal';
$string['frontpageformatloggedin'] = 'Formato de portada al entrar';
$string['frontpagenews'] = 'Mostrar ítems de noticias';
$string['frontpagesettings'] = 'Ajustes de la página principal';
$string['fulllistofcourses'] = 'Todos los cursos';
$string['fullname'] = 'Nombre completo';
$string['fullnamecourse'] = 'Nombre completo del curso';
$string['fullnamecourse_help'] = 'El nombre completo del curso se muestra en la parte superior de cada página del curso y en la lista de cursos.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nombre completo del usuario';
$string['fullprofile'] = 'Perfil completo';
$string['fullsitename'] = 'Nombre completo del sitio';
$string['functiondisabled'] = 'Esta funcionalidad está actualmente desactivada';
$string['general'] = 'General';
$string['geolocation'] = 'latitud - longitud';
$string['gettheselogs'] = 'Conseguir estos registros';
$string['go'] = 'Ir';
$string['gpl'] = 'Copyright (C) 1999 en adelante, Martin Dougiamas (http://moodle.com)

Este programa es software libre; usted puede redistribuirlo y /o modificarlo bajo los términos de la GNU (General Public License) publicada por The Free Software Foundation; incluso de la versión 2 de la Licencia, o (a su elección) alguna posterior.

Este programa se distribuye con la esperanza de que resulte útil, pero SIN GARANTÍA ALGUNA; incluso sin la garantía implícita de DISTRIBUCIÓN MERCANTIL o AJUSTE A UN PROPÓSITO PARTICULAR.

Para más detalles, vea la página de información de Licencia de Moodle: http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 en adelante, Martin Dougiamas (http://moodle.com)

Este programa es software libre: usted puede redistribuirlo y
/o modificarlo bajo los términos de la GNU (General Public License) publicada por la Fundación para el Software Libre, ya sea la versión 3 de dicha Licencia, o (a su elección) cualquier versión posterior.

Este programa se distribuye con la esperanza de que sea útil, pero SIN NINGUNA GARANTÍA; sin la garantía implícita de COMERCIALIZACIÓN o IDONEIDAD PARA UN PROPÓSITO PARTICULAR.

Vea la página de información de Licencia de Moodle para más detalles: http://docs.moodle.org/en/License';
$string['gpllicense'] = 'Licencia GPL';
$string['grade'] = 'Calificación';
$string['grades'] = 'Calificaciones';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> se ha habilitado para este sitio. Si usted no carga una imagen en su perfil, Moodle intentará cargar una imagen para su perfil desde Gravatar';
$string['group'] = 'Grupo';
$string['groupadd'] = 'Agregar nuevo grupo';
$string['groupaddusers'] = 'Agregar seleccionados al grupo';
$string['groupextendenrol'] = 'Matriculación extendida (común)';
$string['groupfor'] = 'para el grupo';
$string['groupinfo'] = 'Información sobre el grupo seleccionado';
$string['groupinfoedit'] = 'Editar ajustes de grupo';
$string['groupinfomembers'] = 'Información sobre los miembros seleccionados';
$string['groupinfopeople'] = 'Información sobre las personas seleccionadas';
$string['groupmembers'] = 'Miembros del grupo';
$string['groupmemberssee'] = 'Ver los integrantes del grupo';
$string['groupmembersselected'] = 'Miembros del grupo seleccionado';
$string['groupmode'] = 'Modo de grupo';
$string['groupmodeforce'] = 'Forzar el modo de grupo';
$string['groupmy'] = 'Mi grupo';
$string['groupnonmembers'] = 'Personas que no están en ningún grupo';
$string['groupnotamember'] = 'Lo sentimos, usted no es miembro de ese grupo';
$string['grouprandomassign'] = 'Asignar aleatoriamente a todos a grupos';
$string['groupremove'] = 'Quitar el grupo seleccionado';
$string['groupremovemembers'] = 'Quitar los miembros seleccionados';
$string['groups'] = 'Grupos';
$string['groupsnone'] = 'No hay grupos';
$string['groupsseparate'] = 'Grupos separados';
$string['groupsvisible'] = 'Grupos visibles';
$string['guest'] = 'Invitado';
$string['guestdescription'] = 'Los invitados tienen privilegios mínimos y normalmente no están autorizados para escribir.';
$string['guestskey'] = 'Permitir la matriculación a invitados con contraseña';
$string['guestsno'] = 'No admitir invitados';
$string['guestsnotallowed'] = 'Lo sentimos, \'{$a}\' no permite acceso a invitados.';
$string['guestsyes'] = 'Permitir matriculación a invitados sin contraseña';
$string['guestuser'] = 'Invitado';
$string['guestuserinfo'] = 'Este usuario sólo tiene acceso de lectura en ciertos cursos.';
$string['help'] = 'Ayuda';
$string['helpprefix2'] = 'Ayuda con {$a}';
$string['helpwiththis'] = 'Ayuda';
$string['hiddenassign'] = 'Tarea oculta';
$string['hiddenfromstudents'] = 'Oculto de estudiantes';
$string['hiddensections'] = 'Secciones ocultas';
$string['hiddensectionscollapsed'] = 'Las secciones ocultas se muestran en forma colapsada';
$string['hiddensections_help'] = 'Este ajuste determina si las secciones ocultas se muestran a los estudiantes en forma colapsada o están completamente ocultas';
$string['hiddensectionsinvisible'] = 'Las secciones ocultas son totalmente invisibles';
$string['hide'] = 'Ocultar';
$string['hideadvancedsettings'] = 'Ocultar ajustes avanzados';
$string['hidepicture'] = 'Ocultar imagen';
$string['hidesection'] = 'Ocultar sección {$a}';
$string['hidesettings'] = 'Ocultar ajustes';
$string['hideshowblocks'] = 'Ocultar o mostrar bloques';
$string['hits'] = 'Clics';
$string['hitsoncourse'] = 'Clics de {$a->username} en {$a->coursename}';
$string['hitsoncoursetoday'] = 'Clics de hoy de {$a->username} en {$a->coursename}';
$string['home'] = 'Página Principal';
$string['hour'] = 'hora';
$string['hours'] = 'horas';
$string['howtomakethemes'] = 'Cómo desarrollar temas';
$string['htmleditor'] = 'Usar el editor de HTML';
$string['htmleditoravailable'] = 'El editor HTML está disponible';
$string['htmleditordisabled'] = 'Usted ha desactivado el editor HTML en su perfil de usuario.';
$string['htmleditordisabledadmin'] = 'El administrador ha deshabilitado el editor HTML';
$string['htmleditordisabledbrowser'] = 'El editor de HTML no está disponible porque su navegador no es compatible.';
$string['htmlfilesonly'] = 'Sólo archivos HTML';
$string['htmlformat'] = 'Formato HTML';
$string['icon'] = 'Icono';
$string['icqnumber'] = 'Número de ICQ';
$string['idnumber'] = 'Número de ID';
$string['idnumbercourse'] = 'Número ID del curso';
$string['idnumbercoursecategory'] = 'Número ID de la categoría';
$string['idnumbercoursecategory_help'] = 'El número de identificación ID de una categoría de cursos sólo se usa cuando se compara la categoría contra un sistema externo y no se muestra en ningún lugar del sitio. Si la categoría tiene un código oficial, este puede ser introducido, de lo contrario, el campo puede dejarse en blanco.';
$string['idnumbercourse_help'] = '<P>El número ID de un curso únicamente se usa cuando se compara este curso contra un sistema externo - lo cual nunca es mostrado dentro de Moodle. Si tiene un código oficial para este curso úselo aquí ... de otra forma lo puede dejar en blanco.</p>';
$string['idnumbergroup'] = 'Número de identificación del grupo';
$string['idnumbergroup_help'] = 'El número ID de un grupo sólo se usa cuando se compara el grupo con un sistema externo, y no se muestra en ningún otror lugar del sitio. Si el grupo tiene un código oficial, entonces se puede introducr este, de lo contrario, el campo se puede dejar en blanco.';
$string['idnumbergrouping'] = 'Número de identificación del agrupamiento';
$string['idnumbergrouping_help'] = 'El número ID de una agrupación sólo se usa cuando se compara la agrupación en un sistema externo y no se muestra en cualquier lugar en el sitio. Si la agrupación tiene un código oficial se pueden introducir, de lo contrario el campo se puede dejar en blanco.';
$string['idnumbermod'] = 'Número ID';
$string['idnumbermod_help'] = 'El número ID proporciona una forma de identificar la actividad a fin de poder calcular la calificación. Si la actividad no está incluida en ningún cálculo de calificación, el campo Número ID puede dejarse en blanco. El Número ID puede asimismo ajustarse en la página de edición del cálculo de calificaciones, si bien únicamente
puede editarse en la página de actualización de la actividad.';
$string['idnumbertaken'] = 'Este número ID ya está ocupado';
$string['imagealt'] = 'Descripción de la imagen';
$string['import'] = 'Importar';
$string['importdata'] = 'Importar datos del curso';
$string['importdataexported'] = 'Datos correctamente exportados \'desde\' el curso.<br />Continúe importando \'hacia\' su curso.';
$string['importdatafinished'] = 'Importación completa. Continúe con su curso';
$string['importdatafrom'] = 'Encontrar un curso al que importar datos desde:';
$string['inactive'] = 'Inactivo';
$string['include'] = 'Incluir';
$string['includeallusers'] = 'Incluir a todos los usuarios';
$string['includecoursefiles'] = 'Incluir los archivos del curso';
$string['includecourseusers'] = 'Incluir los usuarios del curso';
$string['included'] = 'Incluido';
$string['includelogentries'] = 'Incluir las entradas de registro';
$string['includemodules'] = 'Incluir Módulos';
$string['includemoduleuserdata'] = 'Incluir datos del usuario del módulo';
$string['includeneededusers'] = 'Incluir usuarios necesarios';
$string['includenoneusers'] = 'No incluir usuarios';
$string['includeroleassignments'] = 'Incluir asignaciones de rol';
$string['includesitefiles'] = 'Incluir archivos del sitio usados en este curso';
$string['includeuserfiles'] = 'Incluir los archivos de los usuarios';
$string['increasesections'] = 'Aumentar el número de secciones';
$string['info'] = 'Información';
$string['institution'] = 'Institución';
$string['instudentview'] = 'en vista estudiante';
$string['interests'] = 'Intereses';
$string['interestslist'] = 'Lista de intereses';
$string['interestslist_help'] = 'Escriba sus intereses separados por comas. Se mostrarán como marcas en la página de su perfil.';
$string['invalidemail'] = 'Dirección de correo no válida';
$string['invalidlogin'] = 'Datos erróneos. Por favor, inténtelo otra vez.';
$string['invalidusername'] = 'El nombre de usuario sólo puede contener caracteres alfanuméricos, subrayado (_), guión (-), punto (.) o arroba (@)';
$string['invalidusernameupload'] = 'Nombre de usuario no válido';
$string['ip_address'] = 'Dirección IP';
$string['jump'] = 'Salto';
$string['jumpto'] = 'Ir a...';
$string['keep'] = 'Mantener';
$string['keepsearching'] = 'Seguir buscando';
$string['langltr'] = 'Dirección normal de texto';
$string['langrtl'] = 'Dirección inversa de texto';
$string['language'] = 'Idioma';
$string['languagegood'] = '¡Este idioma está actualizado! :-)';
$string['last'] = 'Último';
$string['lastaccess'] = 'Último acceso';
$string['lastcourseaccess'] = 'Último acceso al curso';
$string['lastedited'] = 'Última edición';
$string['lastip'] = 'Última dirección IP';
$string['lastlogin'] = 'Última entrada';
$string['lastmodified'] = 'Última modificación';
$string['lastname'] = 'Apellido(s)';
$string['lastnamephonetic'] = 'Apellidos - fonético';
$string['lastsiteaccess'] = 'Último acceso al site';
$string['lastyear'] = 'Último año';
$string['latestlanguagepack'] = 'Ver la última versión del idioma en moodle.org';
$string['layouttable'] = 'Tabla esquema';
$string['leavetokeep'] = 'Dejar en blanco para mantener la contraseña actual';
$string['legacythemeinuse'] = 'El sitio aparece en modo de compatibilidad porque su navegador es demasiado antiguo.';
$string['license'] = 'Licencia';
$string['licenses'] = 'Licencias';
$string['liketologin'] = '¿Desea acceder ahora con una cuenta de usuario completa?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista de archivos en {$a}';
$string['listofallpeople'] = 'Lista total de personas';
$string['listofcourses'] = 'Listado de cursos';
$string['loadinghelp'] = 'Cargando...';
$string['local'] = 'Local';
$string['localplugins'] = 'Extensiones locales';
$string['localpluginsmanage'] = 'Gestionar extensiones locales';
$string['location'] = 'Ubicación';
$string['locktimeout'] = 'La operación ha agotado el tiempo de espera para un bloqueo.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Usted se ha identificado como {$a}';
$string['loggedinasguest'] = 'En este momento está usando el acceso para invitados';
$string['loggedinnot'] = 'Usted no se ha identificado.';
$string['login'] = 'Entrar';
$string['loginalready'] = 'Usted ya ha accedido al sistema';
$string['loginas'] = 'Entrar como';
$string['loginaspasswordexplain'] = '<p>Debe introducir la "loginas password" especial para usar esta característica.<br />Si no la sabe, pregunte al administrador de su servidor.</p>';
$string['login_failure_logs'] = 'Registro de fallos de acceso';
$string['loginguest'] = 'Entrar como invitado';
$string['loginsite'] = 'Entrar al sitio';
$string['loginsteps'] = 'Hola. Para acceder al sistema tómese un minuto para
crear una cuenta.
Cada curso puede disponer de una "clave de acceso"
que sólo tendrá que usar la primera vez.
Estos son los pasos:
<ol>
<li>Rellene el <a href="{$a}">Formulario de Registro</a> con sus datos.</li>
<li>El sistema le enviará un correo para verificar que su dirección sea correcta.</li>
<li>Lea el correo y confirme su matrícula.</li>
<li>Su registro será confirmado y usted podrá acceder al curso.</li>
<li>Seleccione el curso en el que desea participar.</li>
<li>Si algún curso en particular le solicita una "contraseña de acceso"
utilice la que le facilitaron cuando se matriculó.
Así quedará matriculado.</li>
<li>A partir de ese momento no necesitará utilizar más que su nombre de usuario y contraseña
en el formulario de la página
para entrar a cualquier curso en el que esté matriculado.</li>
</ol>';
$string['loginstepsnone'] = '<p>¡Hola!</p>
<p>Para acceder a todos los cursos necesita crear una cuenta.</p>
<p>Todo lo que tiene que hacer es inscribirse en esta página.</p>
<p>Si alguna otra persona hubiera elegido su nombre de usuario o su contraseña, deberá elegir un nombre de usuario diferente.</p>';
$string['loginto'] = 'Entrar a {$a}';
$string['logout'] = 'Salir';
$string['logoutconfirm'] = '¿Realmente desea desconectarse?';
$string['logs'] = 'Registros';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">more</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">more</a> ]';
$string['lookback'] = 'Período';
$string['mailadmins'] = 'Informar a administradores';
$string['mailstudents'] = 'Informar a estudiantes';
$string['mailteachers'] = 'Informar a profesores';
$string['maincoursepage'] = 'Página principal del curso';
$string['makeafolder'] = 'Crear un directorio';
$string['makeeditable'] = 'Si \'{$a}\' tiene CHMOD 777, usted puede editar el idioma desde aquí.';
$string['makethismyhome'] = 'Hacer ésta mi página de inicio por defecto';
$string['manageblocks'] = 'Bloques';
$string['managecategorythis'] = 'Gestionar esta categoría';
$string['managecourses'] = 'Gestionar cursos';
$string['managedatabase'] = 'Administrar la base de datos';
$string['manageeditorfiles'] = 'Gestionar archivos usados por el editor';
$string['managefilters'] = 'Filtros';
$string['managemodules'] = 'Administrar módulos';
$string['manageroles'] = 'Roles y permisos';
$string['markedthistopic'] = 'Este tema está marcado como actual';
$string['markthistopic'] = 'Marcar este tema como el tema actual';
$string['matchingsearchandrole'] = 'Coincidencias \'{$a->search}\' y {$a->role}';
$string['maxareabytesreached'] = 'El archivo (o el tamaño total de varios archivos) es más grande que el espacio que queda en esta zona.';
$string['maxbytesforfile'] = 'El archivo  {$a} es más grande que el tamaño máximo permitido.';
$string['maxfilesize'] = 'Tamaño máximo para archivos nuevos: {$a}';
$string['maxfilesreached'] = 'Puede adjuntar un máximo de {$a} archivo(s)  a este item';
$string['maximumchars'] = 'Máximo: {$a} caracteres';
$string['maximumgrade'] = 'Calificación máxima';
$string['maximumgradex'] = 'Calificación máxima {$a}';
$string['maximumshort'] = 'Máx.';
$string['maximumupload'] = 'Tamaño máximo para archivos cargados por usuarios';
$string['maximumupload_help'] = '<P>Esta variable determina el tamaño máximo permitido para los archivos subidos
 por los estudiantes a este curso, limitado por el tamaño máximo del sitio, que es determinado por el administrador.

<P>También es posible limitar el tamaño en las variables presentes en cada módulo de actividades.';
$string['maxnumberweeks'] = 'Número máximo de secciones';
$string['maxnumberweeks_desc'] = 'El valor máximo del número de secciones del menú desplegable (se aplica sólo a ciertos formatos de curso).';
$string['maxnumcoursesincombo'] = 'Ojear <a href="{$a->link}">{$a->numberofcourses} cursos</a>.';
$string['maxsize'] = 'Tamaño máximo: {$a}';
$string['maxsizeandareasize'] = 'El tamaño máximo para los archivos nuevos es: {$a->size},para el límite global es: {$a->areasize}';
$string['maxsizeandattachments'] = 'Tamaño máximo para nuevos archivos: {$a->size}, número máximo de archivos adjuntos: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'El tamaño máximo para los archivos nuevos es: {$a->size}, el número máximo de archivos adjuntos es: {$a->attachments}, el límite global es: {$a->areasize}';
$string['memberincourse'] = 'Personas en el curso';
$string['messagebody'] = 'Cuerpo del mensaje';
$string['messagedselectedusers'] = 'Se ha enviado un mensaje a los usuarios seleccionados y se ha reajustado la lista de receptores.';
$string['messagedselectedusersfailed'] = 'Algo ha ido mal al enviar mensajes a los usuarios seleccionados. Algunos pueden haber recibido el mensaje.';
$string['messageprovider:availableupdate'] = 'Notificaciones de actualización disponibles';
$string['messageprovider:backup'] = 'Notificaciones de copia de seguridad';
$string['messageprovider:badgecreatornotice'] = 'Notificaciones del creador de Insignias';
$string['messageprovider:badgerecipientnotice'] = 'Notificaciones a los receptores de Insignias';
$string['messageprovider:courserequestapproved'] = 'Notificacíón de aprobación de solicitud de creación de curso';
$string['messageprovider:courserequested'] = 'Notificación de solicitud de creación de curso';
$string['messageprovider:courserequestrejected'] = 'Notificacíón de rechazo de solicitud de creación de curso';
$string['messageprovider:errors'] = 'Errores importantes en el sitio';
$string['messageprovider:errors_help'] = 'Estos son errores importantes que un administrador debería conocer.';
$string['messageprovider:instantmessage'] = 'Mensajes personales entre los usuarios';
$string['messageprovider:instantmessage_help'] = 'Esta sección configura lo que sucede con los mensajes que otros usuarios le han enviado en el sitio.';
$string['messageprovider:notices'] = 'Avisos sobre problemas menores';
$string['messageprovider:notices_help'] = 'Estos son avisos que un administrador podría estar interesado en ver.';
$string['messageselect'] = 'Seleccionar este usuario como receptor de mensaje';
$string['messageselectadd'] = 'Enviar mensaje';
$string['middlename'] = 'Nombre intermedio';
$string['migratinggrades'] = 'Migrando calificaciones';
$string['min'] = 'minutos';
$string['mins'] = 'minutos';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['miscellaneous'] = 'Miscelánea';
$string['missingcategory'] = 'Necesita elegir una categoría';
$string['missingdescription'] = 'Falta la descripción';
$string['missingemail'] = 'Falta la dirección de correo';
$string['missingfirstname'] = 'Falta el nombre dado';
$string['missingfromdisk'] = 'Ausente del disco';
$string['missingfullname'] = 'Falta el nombre completo';
$string['missinglastname'] = 'Falta el apellido(s)';
$string['missingname'] = 'Falta el nombre';
$string['missingnewpassword'] = 'Falta la nueva contraseña';
$string['missingpassword'] = 'Falta la contraseña';
$string['missingrecaptchachallengefield'] = 'Falta el campo \'challenge\' de reCAPTCHA';
$string['missingreqreason'] = 'Falta la razón';
$string['missingshortname'] = 'Falta el nombre corto';
$string['missingshortsitename'] = 'Falta el nombre corto del sitio';
$string['missingsitedescription'] = 'Falta la descripción del sitio';
$string['missingsitename'] = 'Falta el nombre del sitio';
$string['missingstrings'] = 'Revisar palabras o frases sin traducir';
$string['missingstudent'] = 'Debe elegir algo';
$string['missingsummary'] = 'Falta el resumen';
$string['missingteacher'] = 'Debe elegir algo';
$string['missingurl'] = 'Falta URL';
$string['missingusername'] = 'Falta el nombre de usuario';
$string['modchooserdisable'] = 'Desactivar Selector de Actividades';
$string['modchooserenable'] = 'Conectar Selector de actividades';
$string['moddoesnotsupporttype'] = 'El módulo {$a->modname} no soporta subida de archivos del tipo {$a->type}';
$string['modified'] = 'Modificado';
$string['moduleintro'] = 'Descripción';
$string['modulesetup'] = 'Instalando el módulo de tablas';
$string['modulesuccess'] = 'El módulo de tablas {$a} se instaló correctamente';
$string['modulesused'] = 'Módulos utilizados';
$string['month'] = 'Mes';
$string['months'] = 'Meses';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Moodle Docs para esta página';
$string['moodlerelease'] = 'Lanzamiento de Moodle';
$string['moodleversion'] = 'Versión de Moodle';
$string['more'] = 'más';
$string['morehelp'] = 'Más ayuda';
$string['moreinfo'] = 'Más información';
$string['moreinformation'] = 'Más información sobre este error';
$string['moreprofileinfoneeded'] = 'Por favor, díagnos algo acerca de sí mismo';
$string['mostrecently'] = 'más recientes';
$string['move'] = 'Mover';
$string['movecategoriessuccess'] = 'Se han movido con éxito {$a->count} categorías dentro de la categoría \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Movidas con éxito al nivel principal {$a->count} categorías';
$string['movecategorycontentto'] = 'Mover a';
$string['movecategorysuccess'] = 'Se ha movido con éxito la categoría \'{$a->moved}\' dentro de la categoría \'{$a->to}\'';
$string['movecategoryto'] = 'Mover categoría a:';
$string['movecategorytotopsuccess'] = 'Movidas con éxito al nivel principal {$a->count} categorías';
$string['movecontent'] = 'Mover {$a}';
$string['movecontentstoanothercategory'] = 'Mover el contenido a otra categoría';
$string['movecoursemodule'] = 'Mover el recurso';
$string['movecoursesection'] = 'Mover la sección';
$string['movecourseto'] = 'Mover curso a:';
$string['movedown'] = 'Mover hacia abajo';
$string['movefilestohere'] = 'Colocar archivos aquí';
$string['movefull'] = 'Mover {$a} a este lugar';
$string['movehere'] = 'Colocar aquí';
$string['moveleft'] = 'Mover a la izquierda';
$string['moveright'] = 'Mover a la derecha';
$string['movesection'] = 'Mover sección {$a}';
$string['moveselectedcategoriesto'] = 'Mover las categorías seleccionadas a';
$string['moveselectedcoursesto'] = 'Mover los cursos seleccionados a...';
$string['movetoanotherfolder'] = 'Mover a otro directrorio';
$string['moveup'] = 'Mover hacia arriba';
$string['msnid'] = 'ID MSN';
$string['mustchangepassword'] = 'La nueva contraseña debe ser diferente a la actual';
$string['mustconfirm'] = 'Necesita confirmar el acceso';
$string['mycourses'] = 'Mis cursos';
$string['myfiles'] = 'Mis archivos privados';
$string['myfilesmanage'] = 'Gestionar mis archivos privados';
$string['myhome'] = 'Área personal';
$string['mymoodledashboard'] = 'Mi panel de control Moodle';
$string['myprofile'] = 'Mi perfil';
$string['name'] = 'Nombre';
$string['nameforlink'] = '¿Cómo quiere llamar a este enlace?';
$string['nameforpage'] = 'Nombre';
$string['navigation'] = 'Navegación';
$string['needed'] = 'Requerido';
$string['networkdropped'] = 'Hemos detectado que su conexión a Internet no es fiable o ha sido interrumpida.<br /> Por favor tenga en cuenta que los cambios realizados podrían no guardarse correctamente hasta que su conexión se recupere.';
$string['never'] = 'Nunca';
$string['neverdeletelogs'] = 'Nunca borrar los registros';
$string['new'] = 'Nuevo';
$string['newaccount'] = 'Nueva cuenta';
$string['newcourse'] = 'Nuevo curso';
$string['newpassword'] = 'Nueva contraseña';
$string['newpasswordfromlost'] = '<strong>AVISO:</strong> Su<strong>Contraseña actual</strong> ha sido enviada en el <strong>segundo</strong> de los dos correos electrónicos enviados como parte del proceso de recuperación de la contraseña perdida. Asegúrese de que ha recibido la nueva contraseña antes de continuar con esta pantalla.';
$string['newpassword_help'] = 'Escriba una nueva contraseña o déjelo en blanco para mantener la contraseña actual.';
$string['newpasswordtext'] = 'Hola, {$a->firstname}.

La contraseña de su cuenta en \'{$a->sitename}\' se ha
cancelado y se le ha otorgado una nueva contraseña temporal.

Su nueva información de acceso es:
   Nombre de usuario: {$a->username}
   Contraseña: {$a->newpassword}

Diríjase por favor a esta página y cambie su contraseña temporal por una que pueda recordar mejor:
   {$a->link}

En la mayoría de los programas de correo electrónico el
enlace anterior aparecerá como una línea de texto en azul
sobre la que puede hacer clic. Si eso no sucede, copie y
pegue la dirección en la barra de direcciones de su navegador.

Atte. El Administrador de \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'Imagen nueva';
$string['newpicture_help'] = '<P>Usted puede subir una imagen desde su ordenador al servidor, y esta imagen se
utilizará en varios lugares para identificarlo.
<P>Por este motivo, las mejores imágenes son las de estilo identificación, aunque
puede utilizar la imagen que desee.
<P>La imagen debe ser formato JPG o PNG (lo que significa que el nombre de la imagen
terminará en .jpg o en .png) y debe tener un tamaño de 100 x 100 píxeles o más.
<P>Puede colocar una imagen utilizando uno de estos cuatro métodos:

<OL>
<LI>Utilizando una cámara digital, es muy sencillo, dado que sus fotos seguramente
ya estarán en el formato correcto en su ordenador.
<LI>Utilizando un "scanner" para digitalizar una fotografía impresa. Asegúrese de
guardar la imagen en formato JPG o PNG.
<LI>Si usted es una artista, puede dibujar una imagen utilizando algún programa de diseño.
<LI>También puede conseguir una imagen que lo identifique en la red.
<A TARGET=google HREF="http://images.google.com/">http://images.google.com</A>
es un excelente lugar para buscar imágenes. Una vez encontrada, coloque el cursor
sobre ella y pulsando el botón derecho del ratón elija la opción "Guardar imagen como".
(Diferentes ordenadores pueden variar en este procedimiento)
</OL>

<P>Para subir la imagen, haga clic en el botón "Examinar" en esta página y seleccione
la imagen en su disco duro.
<P>IMPORTANTE: Asegúrese de no subir una imagen que exceda el tamaño
máximo permitido, en bites, pues no se cargará.
<P>Luego haga clic en "Actualizar información personal" en la parte inferior de la página; si la imagen
es mayor a 100 x 100 píxeles se cortará.
<P>Cuando acabe de cambiar su imagen es posible que no vea el cambio; si eso sucede
actualice la página (oprimiendo F5 o el botón actualizar).';
$string['newsitem'] = 'ítem de noticias';
$string['newsitems'] = 'ítems de noticias';
$string['newsitemsnumber'] = 'Items de noticias para ver';
$string['newsitemsnumber_help'] = '<P>En los formatos semanal y de temas aparece un foro llamado
"Novedades". Es un buen lugar para
colocar los mensajes que se desea que lean los alumnos.
(Dado que todos los alumnos son automáticamente suscritos
a este foro, recibirán en su correo los mensajes que se coloquen aquí).</P>

<P>Este parámetro determina cuántos de los últimos mensajes
aparecerán en la página de inicio del curso, en la casilla de novedades en la parte derecha de la página.</P>

<P>Si su elección es "0" no se mostrarán novedades en la página.</P>';
$string['newuser'] = 'Nuevo usuario';
$string['newusernewpasswordsubj'] = 'Cuenta de nuevo usuario';
$string['newusernewpasswordtext'] = 'Hola, {$a->firstname},

Se le ha abierto una nueva cuenta en \'{$a->sitename}\'
y se le ha asignado una nueva contraseña temporal.

La información para entrar es:
nombre de usuario: {$a->username}
contraseña: {$a->newpassword}
(deberá cambiar su contraseña cuando acceda por primera vez)

Para comenzar a usar \'{$a->sitename}\', entre en
{$a->link}

En la mayoría de programas de correo electrónico, debería aparecer en forma de enlace azul sobre el que simplemente puede hacer clic. Si eso no funciona, copie y pegue la dirección en la barra de direcciones del navegador.

Un saludo del administrador de \'{$a->sitename}\',
{$a->signoff}';
$string['newusers'] = 'Nuevos usuarios';
$string['newwindow'] = 'Nueva ventana';
$string['next'] = 'Siguiente';
$string['nextsection'] = 'Siguiente sección';
$string['no'] = 'No';
$string['noblockstoaddhere'] = 'No existen bloques que pueda agregar a esta página.';
$string['nobody'] = 'Nadie';
$string['nochange'] = 'Sin cambios';
$string['nocomments'] = 'No hay comentarios';
$string['nocourses'] = 'Sin cursos';
$string['nocoursesfound'] = 'No se encontraron cursos con las palabras {$a}';
$string['nocoursesyet'] = 'No hay cursos en esta categoría';
$string['nodstpresets'] = 'El administrador no ha activado el soporte Daylight Savings Time';
$string['nofilesselected'] = 'No se ha seleccionado ningún archivo para restaurar';
$string['nofilesyet'] = 'Aún no se han subido archivos a su curso';
$string['nograde'] = 'No hay calificación';
$string['nohelpforactivityorresource'] = 'Actualmente no hay ayuda asociada a este recurso o actividad';
$string['noimagesyet'] = 'Aún no se han subido  imágenes a su curso';
$string['nologsfound'] = 'No se han encontrado registros';
$string['nomatchingusers'] = 'Ningún usuario coincide con {$a}';
$string['nomorecourses'] = 'No se encontraron más cursos que cumplan el criterio';
$string['nomoreidnumber'] = 'No se usa un número de identificación para evitar colisiones';
$string['none'] = 'Ninguno';
$string['noneditingteacher'] = 'Profesor sin permiso de edición';
$string['noneditingteacherdescription'] = 'Los profesores sin permiso de edición pueden enseñar en los cursos y calificar a los estudiantes, pero no pueden modificar las actividades.';
$string['nonstandard'] = 'No estándar';
$string['nopendingcourses'] = 'No hay cursos pendientes de aprobación';
$string['nopotentialadmins'] = 'No hay administradores potenciales';
$string['nopotentialcreators'] = 'No hay creadores potenciales';
$string['nopotentialstudents'] = 'No hay estudiantes potenciales';
$string['nopotentialteachers'] = 'No hay profesores potenciales';
$string['norecentactivity'] = 'No hay actividad reciente';
$string['noreplybouncemessage'] = 'Ha respondido a una dirección \'no-reply\'. Si está intentando responder a un mensaje de foro, use por favor los foros {$a}.

Éste es el contenido de su correo:';
$string['noreplybouncesubject'] = '{$a} - correo devuelto.';
$string['noreplyname'] = 'No contestar a este correo';
$string['noresetrecord'] = 'No hay constancia de esa solicitud. Por favor haga una nueva solicitud de restablecimiento de contraseña.';
$string['noresults'] = 'No hay resultados';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Búsqueda normal';
$string['nosite'] = 'No se encontró curso en el nivel de sitio';
$string['nostudentsfound'] = 'No se encuentra {$a}';
$string['nostudentsingroup'] = 'Aún no hay estudiantes en este grupo';
$string['nostudentsyet'] = 'Aún no se ha matriculado ningún alumno en este curso';
$string['nosuchemail'] = 'No existe esa dirección de correo';
$string['notavailable'] = 'No disponible';
$string['notavailablecourse'] = '{$a} no disponible';
$string['noteachersyet'] = 'Aún no hay profesores en este curso';
$string['notenrolled'] = '{$a} no está matriculado en este curso.';
$string['notenrolledprofile'] = 'Este perfil no está disponible porque el usuario no está matriculado en este curso.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Nota:<strong>La posibilidad de mover fechas al restaurar esta copia de seguridad se ha desactivado porque no tiene los permisos necesarios.';
$string['noteuserschangednonetocourse'] = '<strong>Nota:<strong>Los usuarios de los cursos deben ser restaurados cuando se restauran los datos de usuario (en actividades, archivos o mensajes). Esta configuración ha sido cambiada para usted.';
$string['nothingnew'] = 'Sin actividad reciente';
$string['nothingtodisplay'] = 'Nada que mostrar';
$string['notice'] = 'Noticia';
$string['noticenewerbackup'] = 'Esta copia de seguridad ha sido creada con Moodle {$a->backuprelease} ({$a->backupversion}) y es más reciente que la versión instalada de Moodle {$a->serverrelease} ({$a->serverversion}). Esto podría ocasionar algunas inconsistencias debido a que no se puede garantizar la compatibilidad retrospectiva de las copias de seguridad.';
$string['notifications'] = 'Notificaciones';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Usuario: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Puede ver estos logs en {$a}';
$string['notifyloginfailuresmessagestart'] = 'Listado de intentos fallidos de acceso a {$a} desde que se le envió la última notificación';
$string['notifyloginfailuressubject'] = '{$a} :: Notificación de intentos de identificación fallidos';
$string['notincluded'] = 'No incluido';
$string['notingroup'] = 'Lo sentimos, para ver esta actividad necesita ser miembro del grupo.';
$string['notpublic'] = '¡No es público!';
$string['nousersfound'] = 'No se encuentran usuarios';
$string['nousersmatching'] = 'No se encontraron usuarios con \'{$a}\'';
$string['nousersyet'] = 'Aún no hay usuarios';
$string['novalidcourses'] = 'No hay cursos válidos para mostrar';
$string['now'] = 'ahora';
$string['numattempts'] = '{$a} intento(s) de identificación fallido(s)';
$string['numberofcourses'] = 'Número de cursos';
$string['numberweeks'] = 'Número de secciones';
$string['numdays'] = '{$a} días';
$string['numhours'] = '{$a} horas';
$string['numletters'] = '{$a} letras';
$string['numminutes'] = '{$a} minutos';
$string['nummonths'] = '{$a} meses';
$string['numseconds'] = '{$a} segundos';
$string['numviews'] = '{$a} vistas';
$string['numweeks'] = '{$a} semanas';
$string['numwords'] = '{$a} palabras';
$string['numyears'] = '{$a} años';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Contraseña actual';
$string['olduserdirectory'] = 'Éste es el directorio de usuarios ANTIGUO, y ya no es necesario. rnPuede eliminarlo con seguridad. rnLos archivos que contiene se han copiado al NUEVO directorio de usuarios.';
$string['optional'] = 'opcional';
$string['options'] = 'opciones';
$string['order'] = 'Ordenar';
$string['originalpath'] = 'Ruta original';
$string['orphanedactivitiesinsectionno'] = 'Actividades huérfanas (sección {$a})';
$string['other'] = 'Otro';
$string['outline'] = 'Diagrama';
$string['outlinereport'] = 'Diagrama de informe';
$string['page'] = 'Página';
$string['pagea'] = 'Página {$a}';
$string['pageheaderconfigablock'] = 'Configurando un bloque en {%fullname%}';
$string['pagepath'] = 'Ruta a la página';
$string['pageshouldredirect'] = 'Esta página debería redireccionar automáticamente. Si no ocurre nada, por favor utilice el enlace de continuar que aparece más abajo.';
$string['parentcategory'] = 'Categoría padre';
$string['parentcoursenotfound'] = '¡Curso raíz no encontrado!';
$string['parentfolder'] = 'Directorio raíz';
$string['participants'] = 'Participantes';
$string['participantslist'] = 'Lista de participantes';
$string['participationratio'] = 'Tasa de participación';
$string['participationreport'] = 'Informe de participación';
$string['password'] = 'Contraseña';
$string['passwordchanged'] = 'La contraseña ha cambiado';
$string['passwordconfirmchange'] = 'Confirmar cambio de contraseña';
$string['passwordextlink'] = 'Este enlace sirve para recuperar su contraseña perdida y requiere salir de Moodle.';
$string['passwordforgotten'] = 'Contraseña olvidada';
$string['passwordforgotteninstructions'] = 'Sus detalles deben encontrarse primero en la base de datos del usuario. Por favor, escriba <strong>o bien</strong> su nombre de usuario o bien su dirección registrada de correo electrónico en el recuadro apropiado. No es necesario escribir ambos.';
$string['passwordforgotteninstructions2'] = 'Para reajustar su contraseña, envíe su nombre de usuario o su dirección de correo electrónico. Si podemos encontrarlo en la base de datos, le enviaremos un email con instrucciones para poder acceder de nuevo.';
$string['passwordnohelp'] = 'No es posible encontrar su contraseña perdida. Por favor, póngase en contacto con el administrador de Moodle.';
$string['passwordrecovery'] = 'Sí, ayúdeme a entrar';
$string['passwordsdiffer'] = 'Las contraseñas son diferentes';
$string['passwordsent'] = 'Se ha enviado la contraseña';
$string['passwordsenttext'] = '<p>El sistema ha enviado un correo electrónico a {$a->email}.</p>
<p><b>Revise su correo para recibir una nueva contraseña</b></p>
<p>La nueva contraseña se genera automáticamente, por lo que tal vez usted desee
<a href="{$a->link}">cambiarla</a> por una que le sea más fácil recordar.</p>';
$string['passwordset'] = 'Se ha establecido su contraseña.';
$string['path'] = 'Ruta';
$string['pathnotexists'] = '¡Esta ruta no existe en su servidor!';
$string['pathslasherror'] = '¡La ruta no puede terminar con una barra!';
$string['paymentinstant'] = '¡Utilice el botón de abajo para pagar y poder matricularse en minutos!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pendiente</small>)';
$string['paymentrequired'] = 'Para entrar a este curso es necesario pagar.';
$string['payments'] = 'Pagos';
$string['paymentsorry'] = '¡Gracias por su pago! Por desgracia, su pago aún no ha sido procesado por completo, y usted todavía no está registrado para entrar al curso "{$a->fullname}". Por favor, intente continuar el curso dentro de unos segundos. Si continúa teniendo problemas, avise al {$a->teacher} o al administrador del sitio';
$string['paymentthanks'] = '¡Gracias por su pago! Ya está matriculado en el curso:<br />"{$a}"';
$string['pendingrequests'] = 'Solicitudes pendientes';
$string['periodending'] = 'Fin del período ({$a})';
$string['perpage'] = 'Por página';
$string['perpagea'] = 'Por página: {$a}';
$string['personal'] = 'Personal';
$string['personalprofile'] = 'Información personal';
$string['phone'] = 'Teléfono';
$string['phone2'] = 'Teléfono móvil';
$string['phpinfo'] = 'Información PHP';
$string['pictureof'] = 'Imagen de {$a}';
$string['pictureofuser'] = 'Imagen del usuario';
$string['pleaseclose'] = 'Por favor, cierre ahora esta ventana.';
$string['pleasesearchmore'] = 'Por favor, busque algo más';
$string['pleaseusesearch'] = 'Por favor, use la búsqueda';
$string['plugin'] = 'Plugin';
$string['plugincheck'] = 'Comprobación de \'plugins\'';
$string['plugindeletefiles'] = 'Todos los datos asociados con el plugin \'{$a->name}\' han sido eliminados de la base de datos. Para prevenir que el plugin se reinstale por sí mismo, debería eliminar ahora el directorio de su servidor: {$a->directory}';
$string['pluginsetup'] = 'Ajustando tablas de plugins';
$string['policyaccept'] = 'Entiendo y estoy de acuerdo';
$string['policyagree'] = 'Usted deberá estar de acuerdo con estas condiciones antes de seguir usando este sitio. ¿Está de acuerdo?';
$string['policyagreement'] = 'Acuerdo con las Condiciones del Sitio';
$string['policyagreementclick'] = 'Haga clic aquí para leer el acuerdo con las condiciones del sitio';
$string['popup'] = 'emergente';
$string['popupwindow'] = 'Abrir el archivo en una ventana nueva';
$string['popupwindowname'] = 'Ventana emergente';
$string['post'] = 'Mensaje';
$string['posts'] = 'Mensajes';
$string['potentialadmins'] = 'Administradores potenciales';
$string['potentialcreators'] = 'Creadores potenciales';
$string['potentialstudents'] = 'Estudiantes potenciales';
$string['potentialteachers'] = 'Profesores potenciales';
$string['preferences'] = 'Preferencias';
$string['preferredlanguage'] = 'Idioma preferido';
$string['preferredtheme'] = 'Tema preferido';
$string['preprocessingbackupfile'] = 'Procesando el archivo de copia de seguridad';
$string['prev'] = 'Prev';
$string['preview'] = 'Vista previa';
$string['previewhtml'] = 'Vista previa formato HTML';
$string['previeworchoose'] = 'Prever o elegir un tema';
$string['previous'] = 'Anterior';
$string['previouslyselectedusers'] = 'Usuarios previamente seleccionados que no coinciden con {$a}';
$string['previoussection'] = 'Sección anterior';
$string['primaryadminsetup'] = 'Ajustar cuenta del administrador';
$string['private_files_handler'] = 'Almacenar los adjuntos de un correo electrónico en el espacio de almacenamiento de ficheros privados del usuario.';
$string['private_files_handler_name'] = 'Correo electrónico a ficheros Privados';
$string['profile'] = 'Perfil';
$string['profilenotshown'] = 'Esta descripción de perfil no se mostrará hasta que esta persona se matricule al menos en un curso.';
$string['publicprofile'] = 'Perfil público';
$string['publicsitefileswarning'] = 'Nota: cualquiera puede ver los archivos colocados aquí';
$string['publicsitefileswarning2'] = 'Nota: Los archivos colocados aquí pueden ser vistos por cualquiera que conozca (o pueda adivinar) la URL. Por razones de seguridad, se recomienda que los archivos de cualquier copia de seguridad se eliminen inmediatamente después de restaurarlos.';
$string['publicsitefileswarning3'] = 'Nota: Los archivos colocados aquí pueden ser vistos por cualquiera que conozca (o pueda adivinar) la URL. <br />Por razones de seguridad, se recomienda que los archivos de cualquier copia de seguridad se eliminen inmediatamente después de restaurarlos.';
$string['publish'] = 'Publicar';
$string['question'] = 'Pregunta';
$string['questionsinthequestionbank'] = 'Preguntas en el banco de preguntas';
$string['readinginfofrombackup'] = 'Leyendo información de la copia de seguridad';
$string['readme'] = 'LÉAME';
$string['recentactivity'] = 'Actividad reciente';
$string['recentactivityreport'] = 'Informe completo de la actividad reciente...';
$string['recipientslist'] = 'Lista de receptores';
$string['recreatedcategory'] = 'Categoría recreada {$a}';
$string['redirect'] = 'Redireccionar';
$string['reducesections'] = 'Reducir el número de secciones';
$string['refresh'] = 'Recargar';
$string['refreshingevents'] = 'Refrescando eventos';
$string['registration'] = 'Registro de Moodle';
$string['registrationcontact'] = 'Contacto del público';
$string['registrationcontactno'] = 'No, no deseo un formulario de contacto en el listado del sitio';
$string['registrationcontactyes'] = 'Sí, proporcióneme un formulario de Moodlers para que contacten conmigo';
$string['registrationemail'] = 'Notificaciones por correo electrónico';
$string['registrationinfo'] = '<p>Esta página le permite registrar si sitio Moodle en moodle.org. El registro es gratuito.
El principal beneficio del registro es que usted será incluido en una lista de correo de bajo volumen para
notificaciones importantes como alertas de seguridad y nuevos lanzamientos de Moodle.</p>
<p>Su información será confidencial, y nunca será vendida o transmitida a nadie más. La única razón para
recopilar esta información es prestarle apoyo y ayudar a costruir un cuadro estadístico de la comunidad
Moodle.</p>
<p>Si lo desea, puede escribir el nombre de su sitio, país y URL para que aparezca en la lista pública de los sitios que usan Moodle.</p>
<p>Todos los registros son verificados manualmente antes de ser colocados en la lista, pero una vez en ella, puede actualizar su registro (y sus datos en la lista pública) en cualquier momento rellenando de nuevo este formulario.</p>';
$string['registrationinfotitle'] = 'Información de registro';
$string['registrationno'] = 'No deseo recibir notificaciones por correo electrónico';
$string['registrationsend'] = 'Enviar mi información de registro a moodle.org';
$string['registrationyes'] = 'Sí, envíeme notificaciones por correo electrónico';
$string['reject'] = 'Rechazar';
$string['rejectdots'] = 'Rechazar...';
$string['reload'] = 'Recargar';
$string['remoteappuser'] = 'Usuario {$a} remoto';
$string['remove'] = 'Quitar';
$string['removeadmin'] = 'Quitar administrador';
$string['removecreator'] = 'Quitar creador';
$string['removestudent'] = 'Quitar estudiante';
$string['removeteacher'] = 'Quitar profesor';
$string['rename'] = 'Renombrar';
$string['renamefileto'] = 'Renombrar <b>{$a}</b> a';
$string['report'] = 'Informe';
$string['reports'] = 'Informes';
$string['repositories'] = 'Repositorios';
$string['requestcourse'] = 'Solicitar un curso';
$string['requestedby'] = 'Solicitado por';
$string['requestedcourses'] = 'Cursos solicitados';
$string['requestreason'] = 'Razón para solicitar el curso';
$string['required'] = 'Obligatorio';
$string['requirespayment'] = 'Para acceder a este curso es preciso pagar';
$string['reset'] = 'Reiniciar';
$string['resetcomponent'] = 'Componente';
$string['resetcourse'] = 'Reiniciar curso';
$string['resetinfo'] = 'Esta página le permite vaciar un curso de datos de usuario, en tanto que se conservan las actividades y otros ajustes. Por favor, tome nota de que al seleccionar los ítems de más abajo y enviar esta página, eliminará definitivamente de este curso los datos de los usuarios seleccionados.';
$string['resetnotimplemented'] = 'Reinicialización no implementada';
$string['resetrecordexpired'] = 'El enlace para restablecer la contraseña que utilizó tiene más de {$a} minutos y ha expirado. Por favor, inicie un nuevo restablecimiento de contraseña.';
$string['resetstartdate'] = 'Reajustar fecha inicial';
$string['resetstatus'] = 'Estatus';
$string['resettask'] = 'Tarea';
$string['resettodefaults'] = 'Reajustar a valores por defecto';
$string['resortcourses'] = 'Ordenar cursos';
$string['resortsubcategoriesby'] = 'Ordenar categorías por {$a} ascendente';
$string['resortsubcategoriesbyreverse'] = 'Ordenar categorías por {$a} descendente';
$string['resource'] = 'Recurso';
$string['resourcedisplayauto'] = 'Automático';
$string['resourcedisplaydownload'] = 'Forzar descarga';
$string['resourcedisplayembed'] = 'Incrustar';
$string['resourcedisplayframe'] = 'En el marco';
$string['resourcedisplaynew'] = 'Nueva ventana';
$string['resourcedisplayopen'] = 'Abrir';
$string['resourcedisplaypopup'] = 'En ventana emergente';
$string['resources'] = 'Recursos';
$string['resources_help'] = 'Los tipos de recurso posibilitan que prácticamente cualquier contenido web se pueda insertar en el curso.';
$string['restore'] = 'Restaurar';
$string['restorecancelled'] = 'Cancelada la restauración';
$string['restorecannotassignroles'] = 'La restauración necesita asignar roles y usted carece de permiso para hacerlo';
$string['restorecannotcreateorassignroles'] = 'La restauración necesita crear o asignar roles y usted carece de permiso para hacerlo';
$string['restorecannotcreateuser'] = 'La restauración necesita crear un usuario \'{$a}\' a partir de la copia de seguridad y usted carece de permiso para hacerlo';
$string['restorecannotoverrideperms'] = 'La restauración necesita anular permisos y usted carece de permiso para hacerlo';
$string['restorecoursenow'] = 'Restaurar este curso ahora';
$string['restoredaccount'] = 'Cuenta restaurada';
$string['restoredaccountinfo'] = 'Esta cuenta se ha importado de otro servidor y la contraseña se ha perdido. Para fijar una nueva contraseña por email, haga clic en "Continuar"';
$string['restorefinished'] = 'Restauración completada con éxito';
$string['restoreto'] = 'Restaurar a';
$string['restoretositeadding'] = 'Advertencia: Está a punto de restaurar la portada del sitio añadiéndole datos.';
$string['restoretositedeleting'] = 'Advertencia: Está a punto de restaurar la página principal del sitio eliminando la información anterior.';
$string['restoreuserconflict'] = 'Tratar de restaurar al usuario \'{$a}\' a partir del archivo de copia de seguridad puede ocasionar conflicto';
$string['restoreuserinfofailed'] = 'El proceso de restauración se ha detenido porque usted no tiene permiso para restaurar datos de usuario.';
$string['restoreusersprecheck'] = 'Comprobando los datos de usuario';
$string['restoreusersprecheckerror'] = 'Se han detectado problemas en la comprobación de los datos de usuario';
$string['restricted'] = 'Restringido';
$string['returningtosite'] = 'Usuarios registrados';
$string['returntooriginaluser'] = 'Volver a \'{$a}\'';
$string['revert'] = 'Revertir';
$string['role'] = 'Rol';
$string['roleassignments'] = 'Asignaciones de roles';
$string['rolemappings'] = 'Mapeos de rol';
$string['rolerenaming'] = 'Renombrar rol';
$string['rolerenaming_help'] = 'Esta configuración permite cambiar los nombres mostrados en los roles usados en el curso. <P>Sólo se cambia el nombre mostrado - los permisos de los roles no se vean afectados. <P>Los nuevos nombres de los roles aparecerán en la página de participantes en el curso y allá donde se muestren estos.
<P>Si el rol renombrado corresponde a un rol de gestor del curso, asignado por el administardor, el nuevo nombre del rol también aparecerá como parte de las listas de cursos.';
$string['roles'] = 'Roles';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Número de artículos recientes RSS';
$string['rsserror'] = 'Error al leer datos RSS';
$string['rsserrorauth'] = 'Su enlace RSS no contiene una ficha de identificación válida.';
$string['rsserrorguest'] = 'Esta fuente utiliza el acceso de invitados para acceder a los datos, pero el invitado no tiene permiso para leer los datos. Visite la ubicación original de la que esta fuente proviene (URL) como un usuario válido y obtenga de allí un nuevo enlace RSS.';
$string['rsskeyshelp'] = '<p>Para garantizar la seguridad y la privacidad, las direcciones URL RSS feed contienen un \'testigo\' especial que identifica al usuario para el que son. Esto impide que otros usuarios accedan a áreas de Moodle a las que no deben tener acceso.</p><p>Este \'testigo\' se crea automáticamente la primera vez que accede a un área que produce una fuente RSS. Si usted piensa que su \'testigo\' de fuente RSS ha sido comprometido de alguna manera, usted puede solicitar uno nuevo haciendo clic en el vínculo restablecer enlace. Tenga en cuenta que la URL de la fuente RSS actual dejará de ser válida.</p>';
$string['rsstype'] = 'Canal RSS para esta actividad';
$string['saveandnext'] = 'Guardar y mostrar siguiente';
$string['savechanges'] = 'Guardar cambios';
$string['savechangesanddisplay'] = 'Guardar cambios y mostrar';
$string['savechangesandreturntocourse'] = 'Guardar cambios y regresar al curso';
$string['savecomment'] = 'Guardar comentario';
$string['savedat'] = 'Guardado en:';
$string['savepreferences'] = 'Guardar preferencias';
$string['saveto'] = 'Guardar en';
$string['scale'] = 'Escala';
$string['scale_help'] = '<p>En cualquier curso los profesores pueden crear nuevas escalas
personalizadas con el objeto de llevar a cabo cualquier actividad de
evaluación.</p>

<p>El nombre de la escala debería ser una frase que la identifique con
claridad: ese nombre aparecerá tanto en listas de selección de escalas
como en los botones de ayuda sensibles al contexto.</p>

<p>La propia escala se define como una lista jerárquica de valores, de negativo
a positivo, separados por comas. Por ejemplo:</p>

<blockquote><i>
   Insuficiente, Regular, Promedio, Bueno, Muy bueno, Excelente!
</i></blockquote>

<p>Las escalas deberían asimismo incluir una descripción adecuada de lo
que significan y cómo deberían utilizarse. Esta descripción aparecerá
en las páginas de ayuda para profesores y estudiantes.</p>

<p>Por último, puede haber una o más escalas "estándar" definidas en el
sitio por el administrador del sistema. Estas escalas estarán
disponibles en todos los cursos.</p>';
$string['scales'] = 'Escalas';
$string['scalescustom'] = 'Escalas personalizadas';
$string['scalescustomcreate'] = 'Agregar una nueva escala';
$string['scalescustomno'] = 'Aún no se han creado nuevas escalas';
$string['scalesstandard'] = 'Escalas estándar';
$string['scalestandard'] = 'Escala estándar';
$string['scalestandard_help'] = '<p>Una escala estándar es una que esta disponible globalmente en el sitio, para todos los cursos.</p>';
$string['scalestip'] = 'Para crear escalas personalizadas utilice el enlace \'Escalas...\' en el menú de administración del curso.';
$string['scalestip2'] = 'Para crear escalas personalizadas, haga clic en el enlace Calificaciones del menú de administración del curso, luego seleccione Editar, Escalas.';
$string['schedule'] = 'Programación';
$string['screenshot'] = 'Pantallazo';
$string['search'] = 'Buscar';
$string['searchagain'] = 'Volver a buscar';
$string['searchbyemail'] = 'Buscar por dirección email';
$string['searchbyusername'] = 'Buscar por nombre de usuario';
$string['searchcourses'] = 'Buscar cursos';
$string['searchhelp'] = '<p>Puede buscar muchas palabras al mismo tiempo y puede refinar la búsqueda del siguiente modo:</p>
<ul>
<li>palabra - buscar cualquier coincidencia de ésta palabra en el texto.</li>
<li>+palabra - se encontrarán sólo las palabras que coincidan exactamente.</li>
<li>-palabra - no incluir resultados que contengan ésta palabra.</li>
</ul>';
$string['search_help'] = 'Para realizar una búsqueda básica de una o más palabras en cualquier lugar del texto, simplemente escríbalas separadas por espacios. Se usarán todas las palabras de más de dos caracteres.

Para realizar una búsqueda avanzada, pulse el botón de búsqueda sin teclear nada en la caja de texto.';
$string['searchoptions'] = 'Opciones de búsqueda';
$string['searchresults'] = 'Resultados de la búsqueda';
$string['sec'] = 'segundos';
$string['seconds'] = 'segundos';
$string['secondsleft'] = '{$a} segundos';
$string['secondstotime172800'] = '2 días';
$string['secondstotime259200'] = '3 días';
$string['secondstotime345600'] = '4 días';
$string['secondstotime432000'] = '5 días';
$string['secondstotime518400'] = '6 días';
$string['secondstotime604800'] = '1 semana';
$string['secondstotime86400'] = '1 día';
$string['secretalreadyused'] = 'El enlace de confirmación de cambio de contraseña ya se ha utilizado, y la contraseña no se ha cambiado.';
$string['secs'] = 'segundos';
$string['section'] = 'Sección';
$string['sectionname'] = 'Nombre de sección';
$string['sections'] = 'Secciones';
$string['sectionusedefaultname'] = 'Utilizar nombre de sección por defecto';
$string['seealsostats'] = 'Ver también: estadísticas';
$string['selctauser'] = 'Seleccionar un usuario';
$string['select'] = 'Seleccionar';
$string['selectacategory'] = 'Por favor, seleccione una categoría';
$string['selectacountry'] = 'Seleccione su país';
$string['selectacourse'] = 'Seleccionar un curso';
$string['selectacoursesite'] = 'Seleccione un curso o un sitio';
$string['selectagroup'] = 'Seleccionar un grupo';
$string['selectall'] = 'Seleccionar todos';
$string['selectamodule'] = 'Por favor, seleccione un módulo de actividad';
$string['selectanaction'] = 'Seleccionar acciones';
$string['selectanoptions'] = 'Seleccione una opción';
$string['selectaregion'] = 'Seleccionar una región';
$string['selectcategorysort'] = '¿Qué categorías desearía ordenar?';
$string['selectcategorysortby'] = 'Seleccione cómo le gustaría ordenar las categorías';
$string['selectcoursesortby'] = 'Seleccione cómo le gustaría ordenar los cursos';
$string['selectdefault'] = 'Seleccionar por defecto';
$string['selectedcategories'] = 'Categorías seleccionadas';
$string['selectedfile'] = 'Archivo seleccionado';
$string['selectednowmove'] = '{$a} archivos seleccionados. Ahora vaya al destino y pulse \'Colocar archivos aquí\'';
$string['selectfiles'] = 'Seleccionar archivos';
$string['selectmoduletoviewhelp'] = 'Seleccione una actividad o un recurso para ver la ayuda.

Haga doble clic en el nombre de una actividad o recurso para añadirla de forma rápida';
$string['selectnos'] = 'Seleccione todos \'no\'';
$string['selectperiod'] = 'Seleccionar período';
$string['senddetails'] = 'Enviar detalles por correo electrónico';
$string['separate'] = 'Separar';
$string['separateandconnected'] = 'Vías de conocimiento separadas y conectadas';
$string['separateandconnectedinfo'] = 'La escala está basada en la teoría de las vías de conocimiento separadas (aprendizaje individual)  y conectadas (aprendizaje colaborativo). Esta teoría describe dos maneras diferentes con las que podemos evaluar y aprender a partir de lo que vemos y oímos. <li><strong> Conocedores separados (individulaistas) </strong> se mantiene lo la más objetivso posible, sin incluir sentimientos y emociones. En una discusión con otras personas, les gusta defender sus propias ideas, usando la lógica para encontrar fisuras en las ideas del adversario. </li> <li> <strong> Conocedores conectados (colaborativos) </strong> son más sensibles a otras personas. Son expertos en empatía y tienden a escuchar y hacer preguntas hasta que sienten que pueden conectar y "entender las cosas desde otros punto de vista". Aprenden tratando de compartir experiencias lo que les permite encontrar el conocimiento en las demás personas.';
$string['servererror'] = 'Se produjo un error mientras se comunicaba con el servidor';
$string['serverlocaltime'] = 'Hora local del servidor';
$string['setcategorytheme'] = 'Ajustar el tema de la categoría';
$string['setpassword'] = 'Establecer contraseña';
$string['setpasswordinstructions'] = 'Por favor, introduzca y repita a continuación la nueva contraseña, haga clic en "Establecer contraseña";. <br /> Su nueva contraseña se guardará, y usted será identificado.';
$string['settings'] = 'Configuración';
$string['shortname'] = 'Nombre corto';
$string['shortnamecollisionwarning'] = '[*] = Este nombre corto ya está en uso por un curso, y necesita cambiarse hasta que se apruebe';
$string['shortnamecourse'] = 'Nombre corto del curso';
$string['shortnamecourse_help'] = '<P>Muchas instituciones asignan nombres cortos a sus cursos para efectos
administrativos, como BP102 o 4H-LIT. Si ya lo hace, escríbalo aquí; si no,
invente uno y escríbalo aquí. Se utilizará en diferentes lugares en los que
un nombre completo sería inadecuado, como en la linea "asunto" del correo.
</P>';
$string['shortnametaken'] = 'Este nombre corto ya está en uso en otro curso ({$a})';
$string['shortnameuser'] = 'Nombre corto del usuario';
$string['shortsitename'] = 'Nombre corto para el sitio (una palabra)';
$string['show'] = 'Mostrar';
$string['showactions'] = 'Mostrar acciones';
$string['showadvancedsettings'] = 'Mostrar ajustes avanzados';
$string['showall'] = 'Mostrar {$a}';
$string['showallcourses'] = 'Mostrar todos los cursos';
$string['showallusers'] = 'Mostrar todos los usuarios';
$string['showblockcourse'] = 'Mostrar lista de cursos que contienen bloque';
$string['showcategory'] = 'Mostrar {$a}';
$string['showcomments'] = 'Mostrar/ocultar comentario';
$string['showcommentsnonjs'] = 'Mostrar comentarios';
$string['showdescription'] = 'Muestra la descripción en la página del curso';
$string['showdescription_help'] = 'Si se activa, la descripción anterior se mostrará en la página del curso justo debajo del enlace a la actividad o recurso.';
$string['showgrades'] = 'Mostrar libro de calificaciones a los estudiantes';
$string['showgrades_help'] = '<p>Muchas de las actividades permiten otorgar calificaciones.</p>

<p>Por defecto, los resultados de todas las calificaciones
   del curso aparecen en la sección de Calificaciones,
   disponible en la página principal del curso.</p>

<p>Si un profesor no está interesado en usar calificaciones
   en un curso o, simplemente quiere ocultarlas a los
   alumnos, puede desactivar la visualización de las
   calificaciones en la Configuración del Curso. Esto no impide usar o establecer calificaciones para actividades
   individuales: únicamente impide que los alumnos vean
   los resultados.</p>';
$string['showingacourses'] = 'Mostrando todos {$a} cursos';
$string['showingxofycourses'] = 'Mostrando cursos {$a->start} a {$a->end} de {$a->total} cursos';
$string['showlistofcourses'] = 'Mostrar listas de cursos';
$string['showmodulecourse'] = 'Mostrar lista de cursos que contienen actividad';
$string['showonly'] = 'Mostrar sólo';
$string['showperpage'] = 'Mostrar {$a} por página';
$string['showrecent'] = 'Mostrar actividad reciente';
$string['showreports'] = 'Mostrar informes de actividad';
$string['showreports_help'] = '<p>Los informes de actividades están disponibles para todos los participantes que muestren sus actividades en el presente curso. Al igual que las listas de contribuciones, estos informes incluyen un detallado registro de los accesos.</p>

<p>Los profesores siempre tendrán acceso a estos informes usando el enlace existente en el página de información personal de cada participante.</p>

<p>El acceso de los estudiantes a sus propios informes es controlado por el profesor a través la configuración misma del curso. En algunos cursos estos informes pueden ser una herramienta muy útil para que el estudiante sepa su evolución en el curso, si bien en otros casos es posible que no sea necesario.</p>

<p>Otra razón para deshabilitarlo es que los informes pueden recargar ligeramente el servidor cuando se generan. Para grandes grupos puede ser más eficiente mantenerlo deshabilitado.</p>';
$string['showsettings'] = 'Mostrar ajustes';
$string['showtheselogs'] = 'Mostrar estos registros';
$string['showthishelpinlanguage'] = 'Mostrar esta ayuda en el idioma: \'{$a}\'';
$string['since'] = 'Desde';
$string['sincelast'] = 'desde el último acceso';
$string['site'] = 'Sitio';
$string['sitedefault'] = 'Configuración por defecto del sitio';
$string['siteerrors'] = 'Errores de sitio';
$string['sitefiles'] = 'Archivos del sitio';
$string['sitefilesused'] = 'Archivos del sitio usados en este curso';
$string['sitehome'] = 'Inicio del sitio';
$string['sitelegacyfiles'] = 'Archivos heredados del sitio';
$string['sitelogs'] = 'Registros del sitio';
$string['sitemessage'] = 'Mensaje usuarios';
$string['sitenews'] = 'Novedades del sitio';
$string['sitepages'] = 'Páginas del sitio';
$string['sitepartlist'] = 'No dispone de los permisos necesarios para ver la lista de participantes';
$string['sitepartlist0'] = 'Para poder ver la lista de participantes, usted debe ser un profesor del sitio';
$string['sitepartlist1'] = 'Para poder ver la lista de participantes, usted debe ser un profesor';
$string['sites'] = 'Sitios';
$string['sitesection'] = 'Incluir una sección de tema';
$string['sitesettings'] = 'Configurar el sitio';
$string['siteteachers'] = 'Profesores del sitio';
$string['size'] = 'Tamaño';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Pasado por alto';
$string['skiptocategorylisting'] = 'Ir a la lista de categorías';
$string['skiptocoursedetails'] = 'Ir a la información detallada del curso';
$string['skiptocourselisting'] = 'Ir a la lista de cursos';
$string['skypeid'] = 'ID Skype';
$string['socialheadline'] = 'Foro social, últimos temas';
$string['someallowguest'] = 'Algunos cursos permiten el acceso de invitados';
$string['someerrorswerefound'] = 'Falta alguna información o es incorrecta. Abajo aparecen más detalles.';
$string['sort'] = 'Ordenar';
$string['sortby'] = 'Ordenar por';
$string['sortbyx'] = 'Ordenar por {$a} ascendente';
$string['sortbyxreverse'] = 'Ordenar por {$a} descendente';
$string['sorting'] = 'Ordenando';
$string['sourcerole'] = 'Rol fuente';
$string['specifyname'] = 'Debe especificar un nombre.';
$string['standard'] = 'Estándar';
$string['starpending'] = '([*] = curso pendiente de aprobación)';
$string['startdate'] = 'Fecha de inicio del curso';
$string['startdate_help'] = 'Este ajuste determina el comienzo de la primera semana para un curso en formato semanal. También determina la fecha más temprana para la que existirá registro de las actividades del curso. Si el curso es restablecido y la fecha de inicio del curso modificada, todas las fechas en el curso se moverán en relación a la nueva fecha de inicio.';
$string['startingfrom'] = 'Comienzo en';
$string['startsignup'] = 'Crear nueva cuenta';
$string['state'] = 'Estado/Municipio';
$string['statistics'] = 'Estadísticas';
$string['statisticsgraph'] = 'Gráfico de estadísticas';
$string['stats'] = 'Estadísticas';
$string['statslogins'] = 'Accesos';
$string['statsmodedetailed'] = 'Vista detallada (usuario)';
$string['statsmodegeneral'] = 'Vista general';
$string['statsnodata'] = 'No existen datos disponibles para esa combinación de curso y período de tiempo.';
$string['statsnodatauser'] = 'No existen datos disponibles para esa combinación de curso, usuario y período de tiempo.';
$string['statsoff'] = 'Las estadísticas no están habilitadas actualmente';
$string['statsreads'] = 'Vistas';
$string['statsreport1'] = 'Accesos';
$string['statsreport10'] = 'Actividad del usuario';
$string['statsreport11'] = 'Cursos más activos';
$string['statsreport12'] = 'Cursos más activos (ponderados)';
$string['statsreport13'] = 'Cursos con más participación (matriculaciones)';
$string['statsreport14'] = 'Cursos con más participación (vistas/mensajes)';
$string['statsreport2'] = 'Vistas (todos los roles)';
$string['statsreport3'] = 'Mensajes (todos los roles)';
$string['statsreport4'] = 'Toda la actividad (todos los roles)';
$string['statsreport5'] = 'Toda la actividad (vistas y mensajes)';
$string['statsreport7'] = 'Actividad del usuario (vistas y mensajes)';
$string['statsreport8'] = 'Toda la actividad del usuario';
$string['statsreport9'] = 'Accesos (sitio y curso)';
$string['statsreportactivity'] = 'Toda la actividad (profesor y estudiante)';
$string['statsreportactivitybyrole'] = 'Toda la actividad (vistas y mensajes)';
$string['statsreportforuser'] = 'para';
$string['statsreportlogins'] = 'Accesos';
$string['statsreportreads'] = 'Vistas (todos los roles)';
$string['statsreporttype'] = 'Tipo de informe';
$string['statsreportwrites'] = 'Mensajes (todos los roles)';
$string['statsstudentactivity'] = 'Actividad del estudiante';
$string['statsstudentreads'] = 'Vistas del estudiante';
$string['statsstudentwrites'] = 'Mensajes del estudiante';
$string['statsteacheractivity'] = 'Actividad del profesor';
$string['statsteacherreads'] = 'Vistas del profesor';
$string['statsteacherwrites'] = 'Mensajes del profesor';
$string['statstimeperiod'] = 'Período de tiempo - último:';
$string['statsuniquelogins'] = 'Accesos únicos';
$string['statsuseractivity'] = 'Toda la actividad';
$string['statsuserlogins'] = 'Accesos';
$string['statsuserreads'] = 'Vistas';
$string['statsuserwrites'] = 'Mensajes';
$string['statswrites'] = 'Mensajes';
$string['status'] = 'Estado';
$string['stringsnotset'] = 'Las siguientes cadenas no están definidas en {$a}';
$string['studentnotallowed'] = 'Lo sentimos, pero no puede entrar a este curso como \'{$a}\'';
$string['students'] = 'Estudiantes';
$string['studentsandteachers'] = 'Estudiantes y profesores';
$string['subcategories'] = 'Subcategorías';
$string['subcategory'] = 'Subcategoría';
$string['subcategoryof'] = 'Subcategoría de {$a}';
$string['submit'] = 'Enviar';
$string['success'] = 'Éxito';
$string['summary'] = 'Resumen';
$string['summary_help'] = 'La idea de un resumen de tema es un texto corto que prepare a los
alumnos para las actividades que realizará en ese tema (o
semana). El texto se muestra en la página del curso bajo el nombre de la sección.';
$string['summaryof'] = 'Resumen de {$a}';
$string['supplyinfo'] = 'Por favor, escriba algunos datos sobre usted';
$string['suspended'] = 'Suspendido';
$string['suspendedusers'] = 'Usuarios suspendidos';
$string['switchdevicedefault'] = 'Cambiar al tema estándar';
$string['switchdevicerecommended'] = 'Cambiar al tema recomendado para su dispositivo';
$string['switchrolereturn'] = 'Volver a mi rol normal';
$string['switchroleto'] = 'Cambiar rol a...';
$string['tag'] = 'Marca';
$string['tagalready'] = 'Esta marca ya existe';
$string['tagmanagement'] = 'Agregar/Eliminar marcas';
$string['tags'] = 'Marcas';
$string['targetrole'] = 'Rol destino';
$string['teacheronly'] = 'para {$a} solamente';
$string['teacherroles'] = 'roles de {$a}';
$string['teachers'] = 'Profesores';
$string['textediting'] = 'Editor de texto';
$string['texteditor'] = 'Use formas estándar de HTML';
$string['textformat'] = 'Formato de texto';
$string['thanks'] = 'Gracias';
$string['theme'] = 'Tema';
$string['themes'] = 'Temas';
$string['themesaved'] = 'Se ha guardado el nuevo tema';
$string['therearecourses'] = 'Hay {$a} cursos';
$string['thereareno'] = 'No hay {$a} en este curso';
$string['thiscategory'] = 'Esta categoría';
$string['thiscategorycontains'] = 'Esta categoría contiene';
$string['time'] = 'Hora';
$string['timecreatedcourse'] = 'Hora de creación del curso';
$string['timezone'] = 'Zona horaria';
$string['to'] = 'Hasta';
$string['tocontent'] = 'Al elemento "{$a}"';
$string['tocreatenewaccount'] = 'Saltar a creación de una nueva cuenta';
$string['today'] = 'Hoy';
$string['todaylogs'] = 'Registros de hoy';
$string['toeveryone'] = 'a todos';
$string['toomanybounces'] = 'Esta dirección de correo ha tenido muchas devoluciones. <b>Debe</b> cambiarla para continuar.';
$string['toomanytoshow'] = 'Hay demasiados usuarios para mostrarlos aquí';
$string['toomanyusersmatchsearch'] = 'Demasiados usuarios ({$a->count}) coinciden con \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Demasiados usuarios ({$a}) para mostrar';
$string['toonly'] = 'sólo a {$a}';
$string['top'] = 'Superior';
$string['topic'] = 'Tema';
$string['topichide'] = 'Ocultar este tema a {$a}';
$string['topicoutline'] = 'Diagrama de temas';
$string['topicshow'] = 'Mostrar este tema a {$a}';
$string['toplevelcategory'] = 'Categoría de nivel superior';
$string['total'] = 'Total';
$string['totopofsection'] = 'Al inicio de la sección "{$a}"';
$string['trackforums'] = 'Rastreo del foro';
$string['trackforumsno'] = 'No: no registrar los mensajes que he visto';
$string['trackforumsyes'] = 'Sí: resaltar los mensajes nuevos';
$string['trysearching'] = 'Intente una búsqueda en su lugar.';
$string['turneditingoff'] = 'Desactivar edición';
$string['turneditingon'] = 'Activar edición';
$string['unauthorisedlogin'] = 'La cuenta del usuario "{$a}" no está disponible en este sitio';
$string['undecided'] = 'No decidido';
$string['unfinished'] = 'Sin terminar';
$string['unknowncategory'] = 'Categoría desconocida';
$string['unknownerror'] = 'Error desconocido';
$string['unlimited'] = 'Sin límite';
$string['unpacking'] = 'Abriendo {$a}';
$string['unsafepassword'] = 'Esta contraseña no es segura, intente otra';
$string['untilcomplete'] = 'Hasta que se complete';
$string['unusedaccounts'] = 'Las personas que no entren al curso durante {$a} días se darán de baja automáticamente. Su cuenta seguirá existiendo y podrán reinscribirse en cualquier momento.';
$string['unzip'] = 'Descomprimir';
$string['unzippingbackup'] = 'Descomprimiendo la copia de seguridad';
$string['up'] = 'Arriba';
$string['update'] = 'Actualizar';
$string['updated'] = 'Actualizado: {$a}';
$string['updatemymoodleoff'] = 'Dejar de personalizar esta página';
$string['updatemymoodleon'] = 'Personalizar esta página';
$string['updatemyprofile'] = 'Actualizar información personal';
$string['updatesevery'] = 'Actualizado cada {$a} segundos';
$string['updatethis'] = 'Actualizar {$a}';
$string['updatethiscourse'] = 'Actualizar este curso';
$string['updatinga'] = 'Actualizando {$a}';
$string['updatingain'] = 'Actualizando {$a->what} en {$a->in}';
$string['upload'] = 'Subir';
$string['uploadafile'] = 'Subir un archivo';
$string['uploadcantwrite'] = 'No se pudo escribir el archivo en el disco';
$string['uploadedfile'] = 'Archivo subido con éxito';
$string['uploadedfileto'] = 'El archivo {$a->file} ha sido subido al directorio {$a->directory}';
$string['uploadedfiletoobig'] = 'Lo sentimos, el archivo es demasiado grande (el límite es de {$a} bytes)';
$string['uploadextension'] = 'Subida del archivo detenida por una extensión PHP';
$string['uploadfailednotrecovering'] = 'La subida del archivo ha fallado debido a un problema con uno de los archivos, {$a->name}.<br/> Éste es el registro de los problemas:<br />{$a->problem}<br />Sin recuperar.';
$string['uploadfilelog'] = 'Registro de subida para el archivo {$a}';
$string['uploadformlimit'] = 'El archivo subido {$a} sobrepasa el límite de tamaño máximo establecido por el formulario';
$string['uploadlabel'] = 'Título:';
$string['uploadlimitwithsize'] = '{$a->contextname} límite de subida ({$a->displaysize})';
$string['uploadnewfile'] = 'Subir un nuevo archivo';
$string['uploadnofilefound'] = 'No se encontró el archivo. ¿Está seguro de que seleccionó uno?';
$string['uploadnotallowed'] = 'No se permite subir archivos';
$string['uploadnotempdir'] = 'Falta un directorio temporal';
$string['uploadoldfilesdeleted'] = 'El(los) archivo(s) viejos de su área de subida ha(n) sido destruído(s)';
$string['uploadpartialfile'] = 'El archivo ha sido parcialmente subido';
$string['uploadproblem'] = 'Ha ocurrido un problema inesperado al subir {$a} (tal vez es demasiado grande).';
$string['uploadrenamedchars'] = 'El nombre del archivo se ha cambiado de {$a->oldname} a {$a->newname} debido a la existencia de caracteres no válidos.';
$string['uploadrenamedcollision'] = 'El nombre del archivo se ha cambiado de {$a->oldname} a {$a->newname} debido a la existencia de un conflicto con el nombre del archivo.';
$string['uploadserverlimit'] = 'El archivo subido sobrepasa el límite de tamaño máximo establecido por el servidor';
$string['uploadthisfile'] = 'Subir este archivo';
$string['url'] = 'URL';
$string['used'] = 'Usado';
$string['usedinnplaces'] = 'Usado en {$a} lugares';
$string['usemessageform'] = 'o utilice el formulario de más abajo para enviar un mensaje a los estudiantes seleccionados';
$string['user'] = 'Usuario';
$string['useractivity'] = 'Actividad';
$string['userconfirmed'] = 'Confirmado {$a}';
$string['usercurrentsettings'] = 'Ajustes de mi perfil';
$string['userdata'] = 'Datos de usuario';
$string['userdeleted'] = 'Esta cuenta se ha cancelado';
$string['userdescription'] = 'Descripción';
$string['userdescription_help'] = 'Esta caja le permite escribir un texto sobre usted mismo. Luego se mostrará en la página de su perfil para que otras personas puedan verlo.';
$string['userdetails'] = 'Detalles de usuario';
$string['userfiles'] = 'Archivos del usuario';
$string['userlist'] = 'Lista de usuarios';
$string['usermenu'] = 'Menú de usuario';
$string['username'] = 'Nombre de usuario';
$string['usernameemail'] = 'Nombre de usuario / correo electrónico';
$string['usernameemailmatch'] = 'El nombre de usuario y la dirección de correo electrónico no se refieren al mismo usuario';
$string['usernameexists'] = 'Este nombre de usuario ya existe. Por favor, seleccione otro.';
$string['usernamelowercase'] = 'Sólo se permiten minúsculas';
$string['usernamenotfound'] = 'No se ha encontrado el nombre de usuario en la base de datos';
$string['usernameoremail'] = 'Escribir nombre de usuario o dirección email';
$string['usernotconfirmed'] = 'No se pudo confirmar {$a}';
$string['userpic'] = 'Imagen del usuario';
$string['users'] = 'Usuarios';
$string['userselectorautoselectunique'] = 'Si sólo un usuario coincide con la búsqueda, seleccionarlo automáticamente';
$string['userselectorpreserveselected'] = 'Mantener los usuarios seleccionados, incluso si no coinciden más con la búsqueda';
$string['userselectorsearchanywhere'] = 'Coincidencia del texto de búsqueda en cualquier parte del los campos visibles';
$string['usersnew'] = 'Usuarios nuevos';
$string['usersnoaccesssince'] = 'Mostrar usuarios que han estado inactivos durante más de';
$string['userswithfiles'] = 'Usuarios con archivos';
$string['useruploadtype'] = 'Tipo de subida de usuario: {$a}';
$string['userviewingsettings'] = 'Ajustes de perfil para {$a}';
$string['userzones'] = 'Zonas de usuarios';
$string['usetheme'] = 'Usar tema';
$string['usingexistingcourse'] = 'Usando un curso existente';
$string['valuealreadyused'] = 'Este valor ya ha sido usado.';
$string['version'] = 'Versión';
$string['view'] = 'Vista';
$string['viewallcourses'] = 'Ver todos los cursos';
$string['viewallcoursescategories'] = 'Ver todos los cursos y categorías';
$string['viewallsubcategories'] = 'Ver todas las subcategorías';
$string['viewfileinpopup'] = 'Ver archivo en ventana desplegable';
$string['viewing'] = 'Viendo:';
$string['viewmore'] = 'Ver más';
$string['viewprofile'] = 'Ver perfil';
$string['views'] = 'Vistas';
$string['viewsolution'] = 'ver solución';
$string['virusfound'] = '¡Atención, administrador! Clam AV ha encontrado un virus en el archivo subido por el usuario {$a->user} en el curso {$a->course}. Éste es el mensaje de salida de clamscan:';
$string['virusfoundlater'] = 'Un archivo que usted subió el {$a->date} denominado {$a->filename} en el curso {$a->course} contiene un virus. He aquí un resumen de lo que ha ocurrido con el archivo:

{$a->action}

Si se trata de un trabajo enviado, reenvíelo para que su tutor pueda verlo.';
$string['virusfoundlateradmin'] = '¡Atención, administrador! Un archivo subido el {$a->date} denominado {$a->filename} en el curso {$a->course} por el usuario {$a->user} contiene un virus. He aquí un resumen de lo que ha ocurrido con el archivo:

{$a->action}

El usuario ha sido también avisado';
$string['virusfoundlateradminnolog'] = '¡Atención, administrador! Un archivo subido denominado {$a->filename} contiene un virus. Moodle ha sido incapaz de devolver este archivo al usuario que lo subió. He aquí un resumen de lo que ha ocurrido con el archivo: {$a->action}';
$string['virusfoundsubject'] = '{$a}: ¡Se ha encontrado un virus!';
$string['virusfounduser'] = 'El archivo subido, {$a->filename}, ha sido escaneado por un antivirus y está infectado. NO se ha podido subir.';
$string['virusplaceholder'] = 'El archivo subido contenía un virus y ha sido trasladado o eliminado. Se ha comunicado al usuario.';
$string['visible'] = 'Visible';
$string['visible_help'] = 'Esta opción determina si el curso aparece en la lista de cursos. Excepto los profesores y administradores, los usuarios no pueden entrar al curso.';
$string['visibletostudents'] = 'Visible a {$a}';
$string['warning'] = 'Advertencia';
$string['warningdeleteresource'] = 'ATENCIÓN: Un recurso hace referencia a {$a}. ¿Desea actualizar el recurso?';
$string['webpage'] = 'Página web';
$string['week'] = 'Semana';
$string['weekhide'] = 'Ocultar esta semana a {$a}';
$string['weeklyoutline'] = 'Diagrama semanal';
$string['weeks'] = 'semanas';
$string['weekshow'] = 'Mostrar esta semana a {$a}';
$string['welcometocourse'] = 'Bienvenido a {$a}';
$string['welcometocoursetext'] = 'Bienvenido a {$a->coursename}

Lo primero que debe hacer es actualizar su información personal: así podremos saber algo más sobre usted.

  {$a->profileurl}';
$string['whatforlink'] = '¿Qué quiere hacer con el enlace?';
$string['whatforpage'] = '¿Qué quiere hacer con el texto?';
$string['whattocallzip'] = '¿Cómo quiere que se llame el archivo zip?';
$string['whattodo'] = 'Qué hacer';
$string['windowclosing'] = 'Esta ventana debería cerrarse automáticamente. De no ser así, ciérrela ahora, por favor.';
$string['withchosenfiles'] = 'Con los archivos escogidos';
$string['withdisablednote'] = '{$a} (desactivado)';
$string['withoutuserdata'] = 'sin datos de usuario';
$string['withselectedusers'] = 'Con los usuarios seleccionados...';
$string['withselectedusers_help'] = '* Enviar mensaje: Para enviar un mensaje a uno o más participantes.
* Agregar una nueva nota: Para agregar una nota a un participante seleccionado
* Agregar una nota común: Para agregar la misma nota a más de un participante';
$string['withuserdata'] = 'con datos de usuario';
$string['wordforstudent'] = 'Su palabra para Estudiante';
$string['wordforstudenteg'] = 'por ejemplo: Estudiante, Alumno, Participante, etc.';
$string['wordforstudents'] = 'Su palabra para Estudiantes';
$string['wordforstudentseg'] = 'por ejemplo: Estudiantes, Alumnos, Participantes, etc.';
$string['wordforteacher'] = 'Su palabra para Profesor';
$string['wordforteachereg'] = 'por ejemplo: Profesor, Tutor, Asesor, etc.';
$string['wordforteachers'] = 'Su palabra para Profesores';
$string['wordforteacherseg'] = 'por ejemplo: Profesores, Tutores, Asesores, etc.';
$string['writingblogsinfo'] = 'Escribiendo información de blogs';
$string['writingcategoriesandquestions'] = 'Escribiendo categorías y preguntas';
$string['writingcoursedata'] = 'Escribiendo información del curso';
$string['writingeventsinfo'] = 'Escribiendo información del evento';
$string['writinggeneralinfo'] = 'Escribiendo información general';
$string['writinggradebookinfo'] = 'Escribiendo información del libro de calificaciones';
$string['writinggroupingsgroupsinfo'] = 'Escribiendo información de agrupamientos/grupos';
$string['writinggroupingsinfo'] = 'Escribiendo información de agrupamientos';
$string['writinggroupsinfo'] = 'Escribiendo información de grupos';
$string['writingheader'] = 'Escribiendo el encabezado';
$string['writingloginfo'] = 'Escribiendo información de registros';
$string['writingmessagesinfo'] = 'Escribiendo información de mensajes';
$string['writingmoduleinfo'] = 'Escribiendo información del módulo';
$string['writingscalesinfo'] = 'Escribiendo información de escalas';
$string['writinguserinfo'] = 'Escribiendo información del usuario';
$string['wrongpassword'] = 'Contraseña incorrecta para este nombre de usuario';
$string['yahooid'] = 'ID Yahoo';
$string['year'] = 'año';
$string['years'] = 'años';
$string['yes'] = 'Sí';
$string['youareabouttocreatezip'] = 'Está a punto de crear un archivo \'zip\' que contiene';
$string['youaregoingtorestorefrom'] = 'Está a punto de comenzar el proceso de restauración de';
$string['youneedtoenrol'] = 'Para llevar a cabo esta acción necesita matricularse en este curso.';
$string['yourlastlogin'] = 'Su último ingreso fue el';
$string['yourself'] = 'usted';
$string['yourteacher'] = 'su {$a}';
$string['yourwordforx'] = 'Su palabra para \'{$a}\'';
$string['zippingbackup'] = 'Comprimiendo la copia de seguridad';
